/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.protobuf.utils;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.spark_protobuf.protobuf.DescriptorProtos;
import org.sparkproject.spark_protobuf.protobuf.Descriptors;
import org.sparkproject.spark_protobuf.protobuf.InvalidProtocolBufferException;
import org.sparkproject.spark_protobuf.protobuf.Message;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ProtobufUtils$
implements Logging {
    public static ProtobufUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ProtobufUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Descriptors.Descriptor buildDescriptor(String messageName, Option<String> descFilePathOpt) {
        Option<String> option = descFilePathOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String filePath = (String)some.value();
            return this.buildDescriptor(filePath, messageName);
        }
        if (None$.MODULE$.equals(option)) {
            return this.buildDescriptorFromJavaClass(messageName);
        }
        throw new MatchError(option);
    }

    public Descriptors.Descriptor buildDescriptorFromJavaClass(String protobufClassName) {
        Method method;
        Class clazz;
        Class<Message> shadedMessageClass = Message.class;
        String missingShadingErrorMessage = new StringBuilder(79).append("The jar with Protobuf classes needs to be shaded ").append("(com.google.protobuf.* --> ").append(shadedMessageClass.getPackage().getName()).append(".*)").toString();
        try {
            clazz = Utils$.MODULE$.classForName(protobufClassName, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        }
        catch (Throwable throwable) {
            NoClassDefFoundError noClassDefFoundError;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassNotFoundException) {
                ClassNotFoundException classNotFoundException = (ClassNotFoundException)throwable2;
                String explanation = protobufClassName.contains(".") ? "Ensure the class include in the jar" : "Ensure the class name includes package prefix";
                throw QueryCompilationErrors$.MODULE$.protobufClassLoadError(protobufClassName, explanation, (Throwable)classNotFoundException);
            }
            if (throwable2 instanceof NoClassDefFoundError && (noClassDefFoundError = (NoClassDefFoundError)throwable2).getMessage().matches("com/google/proto.*Generated.*")) {
                throw QueryCompilationErrors$.MODULE$.protobufClassLoadError(protobufClassName, missingShadingErrorMessage, (Throwable)noClassDefFoundError);
            }
            throw throwable;
        }
        Class protobufClass = clazz;
        if (!shadedMessageClass.isAssignableFrom(protobufClass)) {
            Class unshadedMessageClass = Utils$.MODULE$.classForName(String.join((CharSequence)".", "com", "google", "protobuf", "Message"), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            String explanation = unshadedMessageClass.isAssignableFrom(protobufClass) ? new StringBuilder(49).append(protobufClassName).append(" does not extend shaded Protobuf Message class ").append(shadedMessageClass.getName()).append(". ").append(missingShadingErrorMessage).toString() : new StringBuilder(31).append(protobufClassName).append(" is not a Protobuf Message type").toString();
            throw QueryCompilationErrors$.MODULE$.protobufClassLoadError(protobufClassName, explanation, QueryCompilationErrors$.MODULE$.protobufClassLoadError$default$3());
        }
        try {
            method = protobufClass.getDeclaredMethod("getDescriptor", new Class[0]);
        }
        catch (NoSuchMethodError e) {
            throw QueryCompilationErrors$.MODULE$.protobufClassLoadError(protobufClassName, "Could not find getDescriptor() method", (Throwable)e);
        }
        Method getDescriptorMethod = method;
        return (Descriptors.Descriptor)getDescriptorMethod.invoke(null, new Object[0]);
    }

    public Descriptors.Descriptor buildDescriptor(String descFilePath, String messageName) {
        Option descriptorOpt = ((TraversableLike)this.parseFileDescriptorSet(descFilePath).flatMap((Function1 & Serializable & scala.Serializable)fileDesc -> Option$.MODULE$.option2Iterable(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fileDesc.getMessageTypes()).asScala()).find((Function1 & Serializable & scala.Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)ProtobufUtils$.$anonfun$buildDescriptor$2(messageName, desc)))), List$.MODULE$.canBuildFrom())).headOption();
        Option option = descriptorOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Descriptors.Descriptor d = (Descriptors.Descriptor)some.value();
            return d;
        }
        if (None$.MODULE$.equals(option)) {
            throw QueryCompilationErrors$.MODULE$.unableToLocateProtobufMessageError(messageName);
        }
        throw new MatchError((Object)option);
    }

    private List<Descriptors.FileDescriptor> parseFileDescriptorSet(String descFilePath) {
        List list;
        DescriptorProtos.FileDescriptorSet fileDescriptorSet = null;
        try {
            BufferedInputStream dscFile = new BufferedInputStream(new FileInputStream(descFilePath));
            fileDescriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom(dscFile);
        }
        catch (InvalidProtocolBufferException ex) {
            throw QueryCompilationErrors$.MODULE$.descriptorParseError(descFilePath, (Throwable)ex);
        }
        catch (IOException ex) {
            throw QueryCompilationErrors$.MODULE$.cannotFindDescriptorFileError(descFilePath, (Throwable)ex);
        }
        try {
            List fileDescriptorList;
            Map<String, DescriptorProtos.FileDescriptorProto> fileDescriptorProtoIndex = this.createDescriptorProtoMap(fileDescriptorSet);
            list = fileDescriptorList = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fileDescriptorSet.getFileList()).asScala()).map((Function1 & Serializable & scala.Serializable)fileDescriptorProto -> MODULE$.buildFileDescriptor((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, fileDescriptorProtoIndex), Buffer$.MODULE$.canBuildFrom())).toList();
        }
        catch (Exception e) {
            throw QueryCompilationErrors$.MODULE$.failedParsingDescriptorError(descFilePath, (Throwable)e);
        }
        return list;
    }

    private Descriptors.FileDescriptor buildFileDescriptor(DescriptorProtos.FileDescriptorProto fileDescriptorProto, Map<String, DescriptorProtos.FileDescriptorProto> fileDescriptorProtoMap) {
        Buffer fileDescriptorList = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)fileDescriptorProto.getDependencyList()).asScala()).map((Function1 & Serializable & scala.Serializable)dependency -> {
            Option option = fileDescriptorProtoMap.get(dependency);
            if (option instanceof Some) {
                Some some = (Some)option;
                DescriptorProtos.FileDescriptorProto dependencyProto = (DescriptorProtos.FileDescriptorProto)some.value();
                return MODULE$.buildFileDescriptor(dependencyProto, fileDescriptorProtoMap);
            }
            if (None$.MODULE$.equals(option)) {
                throw QueryCompilationErrors$.MODULE$.protobufDescriptorDependencyError(dependency);
            }
            throw new MatchError((Object)option);
        }, Buffer$.MODULE$.canBuildFrom());
        return Descriptors.FileDescriptor.buildFrom(fileDescriptorProto, (Descriptors.FileDescriptor[])fileDescriptorList.toArray(ClassTag$.MODULE$.apply(Descriptors.FileDescriptor.class)));
    }

    private Map<String, DescriptorProtos.FileDescriptorProto> createDescriptorProtoMap(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fileDescriptorSet.getFileList()).asScala()).map((Function1 & Serializable & scala.Serializable)descriptorProto -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)descriptorProto.getName()), descriptorProto), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public String toFieldStr(Seq<String> names) {
        Seq<String> seq = names;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            return "top-level record";
        }
        return new StringBuilder(8).append("field '").append(seq.mkString(".")).append("'").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$buildDescriptor$2(String messageName$1, Descriptors.Descriptor desc) {
        String string = desc.getName();
        String string2 = messageName$1;
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = desc.getFullName();
        String string4 = messageName$1;
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private ProtobufUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

