/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.repl.Main$;
import org.apache.spark.repl.SparkILoop;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005]4Aa\u0005\u000b\u0001;!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00139\u0003B\u0002\u0019\u0001A\u0003%\u0001\u0006C\u00042\u0001\t\u0007I\u0011\u0002\u001a\t\rY\u0002\u0001\u0015!\u00034\u0011%9\u0004\u00011AA\u0002\u0013%\u0001\bC\u0005@\u0001\u0001\u0007\t\u0019!C\u0005\u0001\"I\u0011\n\u0001a\u0001\u0002\u0003\u0006K!\u000f\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u0019y\u0005\u0001)A\u0005\u0019\"9\u0001\u000b\u0001b\u0001\n\u0013Y\u0005BB)\u0001A\u0003%A\nC\u0003S\u0001\u0011\u00053\u000bC\u0003U\u0001\u0011\u00053\u000bC\u0003V\u0001\u0011%a\u000bC\u0003`\u0001\u0011\u0005\u0001\rC\u0003n\u0001\u0011\u0005a\u000eC\u0003t\u0001\u0011\u0005AO\u0001\nTS:<G.\u001a;p]J+\u0007\u000f\\*vSR,'BA\u000b\u0017\u0003\u0011\u0011X\r\u001d7\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001=A\u0011q\u0004I\u0007\u0002-%\u0011\u0011E\u0006\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0013\u0001\u001b\u0005!\u0012aA8viV\t\u0001\u0006\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005\u0011\u0011n\u001c\u0006\u0002[\u0005!!.\u0019<b\u0013\ty#F\u0001\u0007TiJLgnZ,sSR,'/\u0001\u0003pkR\u0004\u0013AA5o+\u0005\u0019\u0004CA\u00155\u0013\t)$FA\tQSB,GmT;uaV$8\u000b\u001e:fC6\f1!\u001b8!\u0003\u0019!\bN]3bIV\t\u0011\b\u0005\u0002;{5\t1H\u0003\u0002=Y\u0005!A.\u00198h\u0013\tq4H\u0001\u0004UQJ,\u0017\rZ\u0001\u000bi\"\u0014X-\u00193`I\u0015\fHCA!H!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u0011)f.\u001b;\t\u000f!;\u0011\u0011!a\u0001s\u0005\u0019\u0001\u0010J\u0019\u0002\u000fQD'/Z1eA\u000592i\u0014(G?\u0016CViQ+U\u001fJ{6\tT!T'B\u000bE\u000bS\u000b\u0002\u0019B\u0011!(T\u0005\u0003\u001dn\u0012aa\u0015;sS:<\u0017\u0001G\"P\u001d\u001a{V\tW#D+R{%kX\"M\u0003N\u001b\u0006+\u0011+IA\u0005!r\u000e\u001c3Fq\u0016\u001cW\u000f^8s\u00072\f7o\u001d9bi\"\fQc\u001c7e\u000bb,7-\u001e;pe\u000ec\u0017m]:qCRD\u0007%A\u0005cK\u001a|'/Z!mYR\t\u0011)\u0001\u0005bMR,'/\u00117m\u0003%9\u0018-\u001b;V]RLG\u000e\u0006\u0002B/\")\u0001l\u0004a\u00013\u0006!1m\u001c8e!\r\u0011%\fX\u0005\u00037\u000e\u0013\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\tk\u0016B\u00010D\u0005\u001d\u0011un\u001c7fC:\faB];o\u0013:$XM\u001d9sKR,'\u000f\u0006\u0002bWB\u0011!-\u001b\b\u0003G\u001e\u0004\"\u0001Z\"\u000e\u0003\u0015T!A\u001a\u000f\u0002\rq\u0012xn\u001c;?\u0013\tA7)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d*T!\u0001[\"\t\u000b1\u0004\u0002\u0019A1\u0002\u000b%t\u0007/\u001e;\u0002\u001d\u0005\u001c8/\u001a:u\u0007>tG/Y5ogR\u0019\u0011i\\9\t\u000bA\f\u0002\u0019A1\u0002\u000f5,7o]1hK\")!/\u0005a\u0001C\u00061q.\u001e;qkR\fA#Y:tKJ$Hi\\3t\u001d>$8i\u001c8uC&tGcA!vm\")\u0001O\u0005a\u0001C\")!O\u0005a\u0001C\u0002")
public class SingletonReplSuite
extends SparkFunSuite {
    private final StringWriter out = new StringWriter();
    private final PipedOutputStream in = new PipedOutputStream();
    private Thread thread;
    private final String CONF_EXECUTOR_CLASSPATH;
    private final String oldExecutorClasspath = System.getProperty(this.CONF_EXECUTOR_CLASSPATH());

    private StringWriter out() {
        return this.out;
    }

    private PipedOutputStream in() {
        return this.in;
    }

    private Thread thread() {
        return this.thread;
    }

    private void thread_$eq(Thread x$1) {
        this.thread = x$1;
    }

    private String CONF_EXECUTOR_CLASSPATH() {
        return this.CONF_EXECUTOR_CLASSPATH;
    }

    private String oldExecutorClasspath() {
        return this.oldExecutorClasspath;
    }

    public void beforeAll() {
        super.beforeAll();
        String classpath = System.getProperty("java.class.path");
        System.setProperty(this.CONF_EXECUTOR_CLASSPATH(), classpath);
        Main$.MODULE$.conf().set("spark.master", "local-cluster[2,1,1024]");
        SparkILoop interp = new SparkILoop(new BufferedReader(new InputStreamReader(new PipedInputStream(this.in()))), new PrintWriter(this.out()));
        Main$.MODULE$.sparkContext_$eq(null);
        Main$.MODULE$.sparkSession_$eq(null);
        this.thread_$eq(new Thread(() -> Main$.MODULE$.doMain((String[])((Object[])new String[]{"-classpath", classpath}), interp)));
        this.thread().setDaemon(true);
        this.thread().start();
        this.waitUntil((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.out().toString().contains("Type :help for more information"));
    }

    public void afterAll() {
        this.in().close();
        this.thread().join();
        String string = this.oldExecutorClasspath() != null ? System.setProperty(this.CONF_EXECUTOR_CLASSPATH(), this.oldExecutorClasspath()) : System.clearProperty(this.CONF_EXECUTOR_CLASSPATH());
        super.afterAll();
    }

    private void waitUntil(Function0<Object> cond) {
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(500)).millis())), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(cond.apply$mcZ$sp(), "cond.apply()", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(16).append("current output: ").append(this.out().toString()).toString(), Prettifier$.MODULE$.default(), new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }, Retrying$.MODULE$.retryingNatureOfT(), new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
    }

    public String runInterpreter(String input) {
        int currentOffset = this.out().getBuffer().length();
        long timestamp = System.currentTimeMillis();
        this.in().write(new StringBuilder(0).append(input).append(new StringBuilder(18).append("\nval _result_").append(timestamp).append(" = 1\n").toString()).toString().getBytes());
        this.in().flush();
        String stopMessage = new StringBuilder(17).append("_result_").append(timestamp).append(": Int = 1").toString();
        this.waitUntil((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.out().getBuffer().substring(currentOffset).contains(stopMessage));
        return this.out().getBuffer().substring(currentOffset);
    }

    public void assertContains(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(39).append("Interpreter output did not contain '").append(message).append("':\n").append(output).toString(), Prettifier$.MODULE$.default(), new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
    }

    public void assertDoesNotContain(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(33).append("Interpreter output contained '").append(message).append("':\n").append(output).toString(), Prettifier$.MODULE$.default(), new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
    }

    public SingletonReplSuite() {
        this.CONF_EXECUTOR_CLASSPATH = "spark.executor.extraClassPath";
        this.test("simple foreach with accumulator", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |val accum = sc.longAccumulator\n        |sc.parallelize(1 to 10).foreach(x => accum.add(x))\n        |val res = accum.value\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("res: Long = 55", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("external vars", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |var v = 7\n        |val res1 = sc.parallelize(1 to 10).map(x => v).collect().reduceLeft(_+_)\n        |v = 10\n        |val res2 = sc.parallelize(1 to 10).map(x => v).collect().reduceLeft(_+_)\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("res1: Int = 70", output);
            this.assertContains("res2: Int = 100", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("external classes", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class C {\n        |def foo = 5\n        |}\n        |val res = sc.parallelize(1 to 10).map(x => (new C).foo).collect().reduceLeft(_+_)\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("res: Int = 50", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("external functions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |def double(x: Int) = x + x\n        |val res = sc.parallelize(1 to 10).map(x => double(x)).collect().reduceLeft(_+_)\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("res: Int = 110", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("external functions that access vars", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |var v = 7\n        |def getV() = v\n        |val res1 = sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n        |v = 10\n        |val res2 = sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("res1: Int = 70", output);
            this.assertContains("res2: Int = 100", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        this.test("broadcast vars", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |var array = new Array[Int](5)\n        |val broadcastArray = sc.broadcast(array)\n        |val res1 = sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n        |array(0) = 5\n        |val res2 = sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("res1: Array[Int] = Array(0, 0, 0, 0, 0)", output);
            this.assertContains("res2: Array[Int] = Array(0, 0, 0, 0, 0)", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("interacting with files", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            File tempDir = Utils$.MODULE$.createTempDir();
            FileWriter out = new FileWriter(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tempDir), "/input"));
            out.write("Hello world!\n");
            out.write("What's up?\n");
            out.write("Goodbye\n");
            out.close();
            String output = this.runInterpreter(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |var file = sc.textFile(\"%s\").cache()\n        |val res1 = file.count()\n        |val res2 = file.count()\n        |val res3 = file.count()\n      "))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{StringEscapeUtils.escapeJava((String)new StringBuilder(5).append(tempDir.getAbsolutePath()).append(File.separator).append("input").toString())})));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("res1: Long = 3", output);
            this.assertContains("res2: Long = 3", output);
            this.assertContains("res3: Long = 3", output);
            Utils$.MODULE$.deleteRecursively(tempDir);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("local-cluster mode", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |var v = 7\n        |def getV() = v\n        |val res1 = sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n        |v = 10\n        |val res2 = sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n        |var array = new Array[Int](5)\n        |val broadcastArray = sc.broadcast(array)\n        |val res3 = sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n        |array(0) = 5\n        |val res4 = sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("res1: Int = 70", output);
            this.assertContains("res2: Int = 100", output);
            this.assertContains("res3: Array[Int] = Array(0, 0, 0, 0, 0)", output);
            this.assertContains("res4: Array[Int] = Array(0, 0, 0, 0, 0)", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        this.test("SPARK-1199 two instances of same class don't type check.", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |case class Sum(exp: String, exp2: String)\n        |val a = Sum(\"A\", \"B\")\n        |def b(a: Sum): String = a match { case Sum(_, _) => \"Found Sum\" }\n        |b(a)\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        this.test("SPARK-2452 compound statements.", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |val x = 4 ; def f() = x\n        |f()\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        this.test("SPARK-2576 importing implicits", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |import spark.implicits._\n        |case class TestCaseClass(value: Int)\n        |sc.parallelize(1 to 10).map(x => TestCaseClass(x)).toDF().collect()\n        |\n        |// Test Dataset Serialization in the REPL\n        |Seq(TestCaseClass(1)).toDS().collect()\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("Datasets and encoders", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |import org.apache.spark.sql.functions._\n        |import org.apache.spark.sql.{Encoder, Encoders}\n        |import org.apache.spark.sql.expressions.Aggregator\n        |import org.apache.spark.sql.TypedColumn\n        |val simpleSum = new Aggregator[Int, Int, Int] {\n        |  def zero: Int = 0                     // The initial value.\n        |  def reduce(b: Int, a: Int) = b + a    // Add an element to the running total\n        |  def merge(b1: Int, b2: Int) = b1 + b2 // Merge intermediate values.\n        |  def finish(b: Int) = b                // Return the final result.\n        |  def bufferEncoder: Encoder[Int] = Encoders.scalaInt\n        |  def outputEncoder: Encoder[Int] = Encoders.scalaInt\n        |}.toColumn\n        |\n        |val ds = Seq(1, 2, 3, 4).toDS()\n        |ds.select(simpleSum).collect\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("SPARK-2632 importing a method from non serializable class and not using it.", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |class TestClass() { def testMethod = 3 }\n        |val t = new TestClass\n        |import t.testMethod\n        |case class TestCaseClass(value: Int)\n        |sc.parallelize(1 to 10).map(x => TestCaseClass(x)).collect()\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("collecting objects of class defined in repl", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |case class Foo(i: Int)\n        |val res = sc.parallelize((1 to 100).map(Foo), 10).collect()\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("res: Array[Foo] = Array(Foo(1),", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        this.test("collecting objects of class defined in repl - shuffling", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |case class Foo(i: Int)\n        |val list = List((1, Foo(1)), (1, Foo(2)))\n        |val res = sc.parallelize(list).groupByKey().collect()\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("res: Array[(Int, Iterable[Foo])] = Array((1,", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        this.test("replicating blocks of object with class defined in repl", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |val timeout = 60000 // 60 seconds\n        |val start = System.currentTimeMillis\n        |while(sc.statusTracker.getExecutorInfos.size != 3 &&\n        |    (System.currentTimeMillis - start) < timeout) {\n        |  Thread.sleep(10)\n        |}\n        |if (System.currentTimeMillis - start >= timeout) {\n        |  throw new java.util.concurrent.TimeoutException(\"Executors were not up in 60 seconds\")\n        |}\n        |import org.apache.spark.storage.StorageLevel._\n        |case class Foo(i: Int)\n        |val rdd1 = sc.parallelize((1 to 100).map(Foo), 10).persist(MEMORY_ONLY)\n        |val rdd2 = sc.parallelize((1 to 100).map(Foo), 10).persist(MEMORY_ONLY_2)\n        |rdd1.count()\n        |rdd2.count()\n        |val cached1 = sc.getRDDStorageInfo.filter(_.id == rdd1.id).map(_.numCachedPartitions).sum\n        |val size1 = sc.getRDDStorageInfo.filter(_.id == rdd1.id).map(_.memSize).sum\n        |val size2 = sc.getRDDStorageInfo.filter(_.id == rdd2.id).map(_.memSize).sum\n        |assert(size2 == size1 * 2, s\"Blocks not replicated properly size1=$size1, size2=$size2\")\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("cached1: Int = 10", output);
            this.assertDoesNotContain("AssertionError", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        this.test("should clone and clean line object in ClosureCleaner", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |import org.apache.spark.rdd.RDD\n        |\n        |val lines = sc.textFile(\"pom.xml\")\n        |case class Data(s: String)\n        |val dataRDD = lines.map(line => Data(line.take(3)))\n        |dataRDD.cache.count\n        |val repartitioned = dataRDD.repartition(dataRDD.partitions.size)\n        |repartitioned.cache.count\n        |\n        |def getCacheSize(rdd: RDD[_]) = {\n        |  sc.getRDDStorageInfo.filter(_.id == rdd.id).map(_.memSize).sum\n        |}\n        |val cacheSize1 = getCacheSize(dataRDD)\n        |val cacheSize2 = getCacheSize(repartitioned)\n        |\n        |// The cache size of dataRDD and the repartitioned one should be similar.\n        |val deviation = math.abs(cacheSize2 - cacheSize1).toDouble / cacheSize1\n        |assert(deviation < 0.2,\n        |  s\"deviation too large: $deviation, first size: $cacheSize1, second size: $cacheSize2\")\n      ")));
            this.assertDoesNotContain("AssertionError", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        this.test("newProductSeqEncoder with REPL defined class", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |case class Click(id: Int)\n        |spark.implicits.newProductSeqEncoder[Click]\n      ")));
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        this.test("create encoder in executors", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String output = this.runInterpreter(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |case class Foo(s: String)\n        |\n        |import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder\n        |\n        |val r =\n        |  sc.parallelize(1 to 1).map { i => ExpressionEncoder[Foo](); Foo(\"bar\") }.collect.head\n      ")));
            this.assertContains("r: Foo = Foo(bar)", output);
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
    }
}

