/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.spark.ProcessTestUtils;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.util.ThreadUtils$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005a3A!\u0002\u0004\u0001\u001f!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!91\nAI\u0001\n\u0003a\u0005bB,\u0001#\u0003%\t\u0001\u0014\u0002\u0010'B\f'o[*iK2d7+^5uK*\u0011q\u0001C\u0001\u0005e\u0016\u0004HN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0005\n\u0005MA!!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002-A\u0011q\u0003A\u0007\u0002\r\u0005q!/\u001e8J]R,'\u000f\u001d:fi\u0016\u0014H\u0003\u0002\u000e5}%#\"aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006E\t\u0001\raI\u0001\u001ag\u000e\u0014\u0018\u000e\u001d;t\u0003:$W\t\u001f9fGR,G-\u00118to\u0016\u00148\u000fE\u0002\u001dI\u0019J!!J\u000f\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u001dO%J\u0013B\u0001\u0015\u001e\u0005\u0019!V\u000f\u001d7feA\u0011!&\r\b\u0003W=\u0002\"\u0001L\u000f\u000e\u00035R!A\f\b\u0002\rq\u0012xn\u001c;?\u0013\t\u0001T$\u0001\u0004Qe\u0016$WMZ\u0005\u0003eM\u0012aa\u0015;sS:<'B\u0001\u0019\u001e\u0011\u0015)$\u00011\u00017\u0003\u001d!\u0018.\\3pkR\u0004\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\u0011\u0011,(/\u0019;j_:T!aO\u000f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002>q\tqa)\u001b8ji\u0016$UO]1uS>t\u0007bB \u0003!\u0003\u0005\r\u0001Q\u0001\nKb$(/Y!sON\u00042!\u0011$*\u001d\t\u0011EI\u0004\u0002-\u0007&\ta$\u0003\u0002F;\u00059\u0001/Y2lC\u001e,\u0017BA$I\u0005\r\u0019V-\u001d\u0006\u0003\u000bvAqA\u0013\u0002\u0011\u0002\u0003\u0007\u0001)\u0001\bfeJ|'OU3ta>t7/Z:\u00021I,h.\u00138uKJ\u0004(/\u001a;fe\u0012\"WMZ1vYR$#'F\u0001NU\t\u0001ejK\u0001P!\t\u0001V+D\u0001R\u0015\t\u00116+A\u0005v]\u000eDWmY6fI*\u0011A+H\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001,R\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0019eVt\u0017J\u001c;feB\u0014X\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004")
public class SparkShellSuite
extends SparkFunSuite {
    public void runInterpreter(FiniteDuration timeout, Seq<String> extraArgs, Seq<String> errorResponses, Seq<Tuple2<String, String>> scriptsAndExpectedAnswers) {
        String scripts = ((IterableOnceOps)scriptsAndExpectedAnswers.map((Function1 & Serializable)x$1 -> new StringBuilder(1).append((String)x$1._1()).append("\n").toString())).mkString();
        Seq expectedAnswers = (Seq)scriptsAndExpectedAnswers.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String answer = (String)tuple2._2();
            Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{answer}));
            return seq;
        });
        String cliScript = Predef$.MODULE$.wrapRefArray((Object[])"../bin/spark-shell".split("/")).mkString(File.separator);
        Seq command = (Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(77).append(cliScript).append("\n         |  --master local\n         |  --conf spark.ui.enabled=false\n       ").toString())).split("\\s+"))).$plus$plus(extraArgs);
        IntRef next = IntRef.create((int)0);
        Promise foundMasterAndApplicationIdMessage = Promise$.MODULE$.apply();
        Promise foundAllExpectedAnswers = Promise$.MODULE$.apply();
        ArrayBuffer buffer = new ArrayBuffer();
        Object lock = new Object();
        Process process = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class))).start();
        OutputStreamWriter stdinWriter = new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8);
        stdinWriter.write(scripts);
        stdinWriter.flush();
        stdinWriter.close();
        new ProcessTestUtils.ProcessOutputCapturer(process.getInputStream(), (Function1 & Serializable)line -> {
            this.captureOutput$1("stdout", line, lock, buffer, foundMasterAndApplicationIdMessage, next, expectedAnswers, foundAllExpectedAnswers, errorResponses);
            return BoxedUnit.UNIT;
        }).start();
        new ProcessTestUtils.ProcessOutputCapturer(process.getErrorStream(), (Function1 & Serializable)line -> {
            this.captureOutput$1("stderr", line, lock, buffer, foundMasterAndApplicationIdMessage, next, expectedAnswers, foundAllExpectedAnswers, errorResponses);
            return BoxedUnit.UNIT;
        }).start();
        try {
            try {
                FiniteDuration finiteDuration;
                if (!extraArgs.contains((Object)"-e")) {
                    ThreadUtils$.MODULE$.awaitResult((Awaitable)foundMasterAndApplicationIdMessage.future(), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).minutes());
                    this.log().info("spark-shell driver is booted. Waiting for expected answers.");
                    finiteDuration = timeout;
                } else {
                    finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).minutes().$plus(timeout);
                }
                FiniteDuration timeoutForQuery = finiteDuration;
                ThreadUtils$.MODULE$.awaitResult((Awaitable)foundAllExpectedAnswers.future(), (Duration)timeoutForQuery);
                this.log().info("Found all expected output.");
            }
            catch (Throwable cause) {
                String message = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(404).append("\n           |=======================\n           |SparkShellSuite failure output\n           |=======================\n           |Spark Shell command line: ").append(command.mkString(" ")).append("\n           |Exception: ").append(cause).append("\n           |Failed to capture next expected output \"").append(expectedAnswers.apply(next.elem)).append("\" within ").append(timeout).append(".\n           |\n           |").append(buffer.mkString("\n")).append("\n           |===========================\n           |End SparkShellSuite failure output\n           |===========================\n         ").toString()));
                this.logError((Function0 & Serializable)() -> message, cause);
                throw this.fail(message, cause, new Position("SparkShellSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            }
        }
        finally {
            if (!process.waitFor(1L, TimeUnit.MINUTES)) {
                try {
                    this.log().warn("spark-shell did not exit gracefully.");
                }
                finally {
                    process.destroy();
                }
            }
        }
    }

    public Seq<String> runInterpreter$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Seq<String> runInterpreter$default$3() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error:"}));
    }

    private final void captureOutput$1(String source, String line, Object lock$1, ArrayBuffer buffer$1, Promise foundMasterAndApplicationIdMessage$1, IntRef next$1, Seq expectedAnswers$1, Promise foundAllExpectedAnswers$1, Seq errorResponses$1) {
        Object object = lock$1;
        synchronized (object) {
            Object object2;
            String newLine = new StringBuilder(2).append(source).append("> ").append(line).toString();
            this.logInfo((Function0 & Serializable)() -> newLine);
            buffer$1.$plus$eq((Object)newLine);
            Object object3 = line.startsWith("Spark context available") && line.contains("app id") ? BoxesRunTime.boxToBoolean((boolean)foundMasterAndApplicationIdMessage$1.trySuccess((Object)BoxedUnit.UNIT)) : BoxedUnit.UNIT;
            if (next$1.elem < expectedAnswers$1.size() && line.contains((CharSequence)expectedAnswers$1.apply(next$1.elem))) {
                this.logInfo((Function0 & Serializable)() -> new StringBuilder(33).append(source).append("> found expected output line ").append(next$1.elem).append(": '").append(expectedAnswers$1.apply(next$1.elem)).append("'").toString());
                ++next$1.elem;
                object2 = next$1.elem == expectedAnswers$1.size() ? BoxesRunTime.boxToBoolean((boolean)foundAllExpectedAnswers$1.trySuccess((Object)BoxedUnit.UNIT)) : BoxedUnit.UNIT;
            } else {
                errorResponses$1.foreach((Function1 & Serializable)r -> line.contains((CharSequence)r) ? BoxesRunTime.boxToBoolean((boolean)foundAllExpectedAnswers$1.tryFailure((Throwable)new RuntimeException(new StringBuilder(25).append("Failed with error line '").append(line).append("'").toString()))) : BoxedUnit.UNIT);
                object2 = BoxedUnit.UNIT;
            }
        }
    }

    public SparkShellSuite() {
        this.test("SPARK-37058: Add command line unit test for spark-shell", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.runInterpreter(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)package$.MODULE$.Seq().empty()), this.runInterpreter$default$3(), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |spark.sql(\"drop table if exists t_37058\")\n      "))), (Object)"res0: org.apache.spark.sql.DataFrame = []")})), new Position("SparkShellSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.test("SPARK-37058: Add command line unit test for spark-shell with --verbose", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.runInterpreter(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--verbose"}))), this.runInterpreter$default$3(), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(""))), (Object)"org.apache.spark.repl.Main")})), new Position("SparkShellSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
    }
}

