/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;

public final class ArrowUtils$ {
    public static ArrowUtils$ MODULE$;
    private final RootAllocator rootAllocator;

    static {
        new ArrowUtils$();
    }

    public RootAllocator rootAllocator() {
        return this.rootAllocator;
    }

    public ArrowType toArrowType(DataType dt, String timeZoneId, boolean largeVarTypes) {
        DecimalType decimalType;
        Option<Tuple2<Object, Object>> option;
        boolean bl = false;
        DataType dataType = null;
        boolean bl2 = false;
        DataType dataType2 = null;
        boolean bl3 = false;
        DataType dataType3 = null;
        DataType dataType4 = dt;
        if (BooleanType$.MODULE$.equals(dataType4)) {
            return ArrowType.Bool.INSTANCE;
        }
        if (ByteType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(8, true);
        }
        if (ShortType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(16, true);
        }
        if (IntegerType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(32, true);
        }
        if (LongType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(64, true);
        }
        if (FloatType$.MODULE$.equals(dataType4)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        }
        if (DoubleType$.MODULE$.equals(dataType4)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        }
        if (StringType$.MODULE$.equals(dataType4)) {
            bl = true;
            dataType = dataType4;
            if (!largeVarTypes) {
                return ArrowType.Utf8.INSTANCE;
            }
        }
        if (BinaryType$.MODULE$.equals(dataType4)) {
            bl2 = true;
            dataType2 = dataType4;
            if (!largeVarTypes) {
                return ArrowType.Binary.INSTANCE;
            }
        }
        if (bl && largeVarTypes) {
            return ArrowType.LargeUtf8.INSTANCE;
        }
        if (bl2 && largeVarTypes) {
            return ArrowType.LargeBinary.INSTANCE;
        }
        if (dataType4 instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType4)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return new ArrowType.Decimal(precision, scale);
        }
        if (DateType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Date(DateUnit.DAY);
        }
        if (TimestampType$.MODULE$.equals(dataType4)) {
            bl3 = true;
            dataType3 = dataType4;
            if (timeZoneId == null) {
                throw new IllegalStateException("Missing timezoneId where it is mandatory.");
            }
        }
        if (bl3) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, timeZoneId);
        }
        if (TimestampNTZType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, null);
        }
        if (NullType$.MODULE$.equals(dataType4)) {
            return ArrowType.Null.INSTANCE;
        }
        if (dataType4 instanceof YearMonthIntervalType) {
            return new ArrowType.Interval(IntervalUnit.YEAR_MONTH);
        }
        if (dataType4 instanceof DayTimeIntervalType) {
            return new ArrowType.Duration(TimeUnit.MICROSECOND);
        }
        throw ExecutionErrors$.MODULE$.unsupportedDataTypeError(dt);
    }

    public boolean toArrowType$default$3() {
        return false;
    }

    public DataType fromArrowType(ArrowType dt) {
        boolean bl = false;
        ArrowType.Int intVal = null;
        boolean bl2 = false;
        ArrowType.FloatingPoint floatingPoint = null;
        boolean bl3 = false;
        ArrowType.Timestamp timestamp = null;
        ArrowType arrowType = dt;
        ArrowType.Bool bool = ArrowType.Bool.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(bool != null ? !bool.equals(arrowType2) : arrowType2 != null)) {
            return BooleanType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Int) {
            bl = true;
            intVal = (ArrowType.Int)arrowType;
            if (intVal.getIsSigned() && intVal.getBitWidth() == 8) {
                return ByteType$.MODULE$;
            }
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 16) {
            return ShortType$.MODULE$;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 32) {
            return IntegerType$.MODULE$;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 64) {
            return LongType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.FloatingPoint) {
            bl2 = true;
            floatingPoint = (ArrowType.FloatingPoint)arrowType;
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.SINGLE;
            if (!(floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision2) : floatingPointPrecision2 != null)) {
                return FloatType$.MODULE$;
            }
        }
        if (bl2) {
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision3 = FloatingPointPrecision.DOUBLE;
            if (!(floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision3) : floatingPointPrecision3 != null)) {
                return DoubleType$.MODULE$;
            }
        }
        ArrowType.Utf8 utf8 = ArrowType.Utf8.INSTANCE;
        ArrowType arrowType3 = arrowType;
        if (!(utf8 != null ? !utf8.equals(arrowType3) : arrowType3 != null)) {
            return StringType$.MODULE$;
        }
        ArrowType.Binary binary = ArrowType.Binary.INSTANCE;
        ArrowType arrowType4 = arrowType;
        if (!(binary != null ? !binary.equals(arrowType4) : arrowType4 != null)) {
            return BinaryType$.MODULE$;
        }
        ArrowType.LargeUtf8 largeUtf8 = ArrowType.LargeUtf8.INSTANCE;
        ArrowType arrowType5 = arrowType;
        if (!(largeUtf8 != null ? !largeUtf8.equals(arrowType5) : arrowType5 != null)) {
            return StringType$.MODULE$;
        }
        ArrowType.LargeBinary largeBinary = ArrowType.LargeBinary.INSTANCE;
        ArrowType arrowType6 = arrowType;
        if (!(largeBinary != null ? !largeBinary.equals(arrowType6) : arrowType6 != null)) {
            return BinaryType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Decimal) {
            ArrowType.Decimal decimal = (ArrowType.Decimal)arrowType;
            return new DecimalType(decimal.getPrecision(), decimal.getScale());
        }
        if (arrowType instanceof ArrowType.Date) {
            ArrowType.Date date = (ArrowType.Date)arrowType;
            DateUnit dateUnit = date.getUnit();
            DateUnit dateUnit2 = DateUnit.DAY;
            if (!(dateUnit != null ? !dateUnit.equals(dateUnit2) : dateUnit2 != null)) {
                return DateType$.MODULE$;
            }
        }
        if (arrowType instanceof ArrowType.Timestamp) {
            bl3 = true;
            timestamp = (ArrowType.Timestamp)arrowType;
            TimeUnit timeUnit = timestamp.getUnit();
            TimeUnit timeUnit2 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !timeUnit.equals(timeUnit2) : timeUnit2 != null) && timestamp.getTimezone() == null) {
                return TimestampNTZType$.MODULE$;
            }
        }
        if (bl3) {
            TimeUnit timeUnit = timestamp.getUnit();
            TimeUnit timeUnit3 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !timeUnit.equals(timeUnit3) : timeUnit3 != null)) {
                return TimestampType$.MODULE$;
            }
        }
        ArrowType.Null nullVal = ArrowType.Null.INSTANCE;
        ArrowType arrowType7 = arrowType;
        if (!(nullVal != null ? !nullVal.equals(arrowType7) : arrowType7 != null)) {
            return NullType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Interval) {
            ArrowType.Interval interval = (ArrowType.Interval)arrowType;
            IntervalUnit intervalUnit = interval.getUnit();
            IntervalUnit intervalUnit2 = IntervalUnit.YEAR_MONTH;
            if (!(intervalUnit != null ? !intervalUnit.equals(intervalUnit2) : intervalUnit2 != null)) {
                return YearMonthIntervalType$.MODULE$.apply();
            }
        }
        if (arrowType instanceof ArrowType.Duration) {
            ArrowType.Duration duration = (ArrowType.Duration)arrowType;
            TimeUnit timeUnit = duration.getUnit();
            TimeUnit timeUnit4 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !timeUnit.equals(timeUnit4) : timeUnit4 != null)) {
                return DayTimeIntervalType$.MODULE$.apply();
            }
        }
        throw ExecutionErrors$.MODULE$.unsupportedArrowTypeError(dt);
    }

    public Field toArrowField(String name, DataType dt, boolean nullable, String timeZoneId, boolean largeVarTypes) {
        DataType dataType;
        while (true) {
            if ((dataType = dt) instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType elementType = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.List.INSTANCE, null);
                return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("element", elementType, containsNull, timeZoneId, largeVarTypes), (List)Nil$.MODULE$)).asJava());
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields = structType.fields();
                FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.Struct.INSTANCE, null);
                return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId, largeVarTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class))))).toSeq()).asJava());
            }
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean valueContainsNull = mapType.valueContainsNull();
                FieldType mapType2 = new FieldType(nullable, (ArrowType)new ArrowType.Map(false), null);
                return new Field(name, mapType2, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("entries", new StructType().add("key", keyType, false).add("value", valueType, valueContainsNull), false, timeZoneId, largeVarTypes), (List)Nil$.MODULE$)).asJava());
            }
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        FieldType fieldType = new FieldType(nullable, this.toArrowType(dataType, timeZoneId, largeVarTypes), null);
        return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
    }

    public boolean toArrowField$default$5() {
        return false;
    }

    public DataType fromArrowField(Field field) {
        ArrowType arrowType = field.getType();
        if (arrowType instanceof ArrowType.Map) {
            Field elementField = (Field)field.getChildren().get(0);
            DataType keyType = this.fromArrowField((Field)elementField.getChildren().get(0));
            DataType valueType = this.fromArrowField((Field)elementField.getChildren().get(1));
            return new MapType(keyType, valueType, ((Field)elementField.getChildren().get(1)).isNullable());
        }
        ArrowType.List list = ArrowType.List.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(list != null ? !list.equals(arrowType2) : arrowType2 != null)) {
            Field elementField = (Field)field.getChildren().get(0);
            DataType elementType = this.fromArrowField(elementField);
            return new ArrayType(elementType, elementField.isNullable());
        }
        ArrowType.Struct struct = ArrowType.Struct.INSTANCE;
        ArrowType arrowType3 = arrowType;
        if (!(struct != null ? !struct.equals(arrowType3) : arrowType3 != null)) {
            Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(field.getChildren()).asScala()).map((Function1 & Serializable & scala.Serializable)child -> {
                DataType dt = MODULE$.fromArrowField((Field)child);
                return new StructField(child.getName(), dt, child.isNullable(), StructField$.MODULE$.apply$default$4());
            }, Buffer$.MODULE$.canBuildFrom());
            return new StructType((StructField[])fields.toArray(ClassTag$.MODULE$.apply(StructField.class)));
        }
        return this.fromArrowType(arrowType);
    }

    public Schema toArrowSchema(StructType schema, String timeZoneId, boolean errorOnDuplicatedFieldNames, boolean largeVarTypes) {
        return new Schema((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema.map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toArrowField(field.name(), MODULE$.deduplicateFieldNames(field.dataType(), errorOnDuplicatedFieldNames), field.nullable(), timeZoneId, largeVarTypes), Seq$.MODULE$.canBuildFrom())).asJava());
    }

    public boolean toArrowSchema$default$4() {
        return false;
    }

    public StructType fromArrowSchema(Schema schema) {
        return new StructType((StructField[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> {
            DataType dt = MODULE$.fromArrowField((Field)field);
            return new StructField(field.getName(), dt, field.isNullable(), StructField$.MODULE$.apply$default$4());
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    private DataType deduplicateFieldNames(DataType dt, boolean errorOnDuplicatedFieldNames) {
        DataType dataType;
        while ((dataType = dt) instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        if (dataType instanceof StructType) {
            String[] stringArray;
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.names())).toSet().size() == structType.names().length) {
                stringArray = structType.names();
            } else {
                if (errorOnDuplicatedFieldNames) {
                    throw ExecutionErrors$.MODULE$.duplicatedFieldNameInArrowStructError((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])structType.names()));
                }
                Map genNawName = (Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.names())).groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        String[] names = (String[])tuple2._2();
                        if (names.length > 1) {
                            AtomicInteger i = new AtomicInteger();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(name).append("_").append(i.getAndIncrement()).toString());
                        }
                    }
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Function0 & Serializable & scala.Serializable)() -> name);
                    }
                    throw new MatchError((Object)tuple2);
                }, Map$.MODULE$.canBuildFrom());
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.names())).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)((Function0)genNawName.apply(x$1)).apply(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
            String[] newNames = stringArray;
            StructField[] newFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])newNames), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    StructField structField = (StructField)tuple2._1();
                    String name = (String)tuple2._2();
                    if (structField != null) {
                        DataType dataType = structField.dataType();
                        boolean nullable = structField.nullable();
                        Metadata metadata = structField.metadata();
                        return new StructField(name, MODULE$.deduplicateFieldNames(dataType, errorOnDuplicatedFieldNames), nullable, metadata);
                    }
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            return new StructType(newFields);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            return new ArrayType(this.deduplicateFieldNames(elementType, errorOnDuplicatedFieldNames), containsNull);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            return new MapType(this.deduplicateFieldNames(keyType, errorOnDuplicatedFieldNames), this.deduplicateFieldNames(valueType, errorOnDuplicatedFieldNames), valueContainsNull);
        }
        return dt;
    }

    private ArrowUtils$() {
        MODULE$ = this;
        this.rootAllocator = new RootAllocator(Long.MAX_VALUE);
    }
}

