/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SparkClassUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@DeveloperApi
public final class UDTRegistration$
implements Serializable,
Logging {
    public static final UDTRegistration$ MODULE$ = new UDTRegistration$();
    private static Map<String, String> udtMap;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Map<String, String> udtMap$lzycompute() {
        UDTRegistration$ uDTRegistration$ = this;
        synchronized (uDTRegistration$) {
            if (!bitmap$0) {
                udtMap = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"org.apache.spark.ml.linalg.Vector", (Object)"org.apache.spark.ml.linalg.VectorUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.DenseVector", (Object)"org.apache.spark.ml.linalg.VectorUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.SparseVector", (Object)"org.apache.spark.ml.linalg.VectorUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.Matrix", (Object)"org.apache.spark.ml.linalg.MatrixUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.DenseMatrix", (Object)"org.apache.spark.ml.linalg.MatrixUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.SparseMatrix", (Object)"org.apache.spark.ml.linalg.MatrixUDT")}));
                bitmap$0 = true;
            }
        }
        return udtMap;
    }

    private Map<String, String> udtMap() {
        if (!bitmap$0) {
            return this.udtMap$lzycompute();
        }
        return udtMap;
    }

    public boolean exists(String userClassName) {
        return this.udtMap().contains((Object)userClassName);
    }

    public void register(String userClass, String udtClass) {
        if (this.udtMap().contains((Object)userClass)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot register UDT for " + userClass + ", which is already registered.");
            return;
        }
        this.udtMap().$plus$eq((Object)new Tuple2((Object)userClass, (Object)udtClass));
    }

    public Option<Class<?>> getUDTFor(String userClass) {
        return this.udtMap().get((Object)userClass).map((Function1 & Serializable)udtClassName -> {
            if (SparkClassUtils$.MODULE$.classIsLoadable(udtClassName)) {
                Class udtClass = SparkClassUtils$.MODULE$.classForName(udtClassName, SparkClassUtils$.MODULE$.classForName$default$2(), SparkClassUtils$.MODULE$.classForName$default$3());
                if (UserDefinedType.class.isAssignableFrom(udtClass)) {
                    return udtClass;
                }
                throw DataTypeErrors$.MODULE$.notUserDefinedTypeError(udtClass.getName(), userClass);
            }
            throw DataTypeErrors$.MODULE$.cannotLoadUserDefinedTypeError((String)udtClassName, userClass);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UDTRegistration$.class);
    }

    private UDTRegistration$() {
    }
}

