/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.catalyst.parser.DataTypeParser$;
import org.apache.spark.sql.catalyst.parser.LegacyTypeStringParser$;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@Stable
public final class StructType$
extends AbstractDataType
implements Serializable {
    public static final StructType$ MODULE$ = new StructType$();

    @Override
    public DataType defaultConcreteType() {
        return new StructType();
    }

    @Override
    public boolean acceptsType(DataType other) {
        return other instanceof StructType;
    }

    @Override
    public String simpleString() {
        return "struct";
    }

    public StructType fromString(String raw) {
        DataType dataType = (DataType)Try$.MODULE$.apply((Function0 & Serializable)() -> DataType$.MODULE$.fromJson(raw)).getOrElse((Function0 & Serializable)() -> LegacyTypeStringParser$.MODULE$.parseString(raw));
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return structType;
        }
        throw DataTypeErrors$.MODULE$.failedParsingStructTypeError(raw);
    }

    public StructType fromDDL(String ddl) {
        return DataTypeParser$.MODULE$.parseTableSchema(ddl);
    }

    public StructType apply(Seq<StructField> fields) {
        return new StructType((StructField[])fields.toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public StructType apply(List<StructField> fields) {
        return new StructType((StructField[])CollectionConverters$.MODULE$.ListHasAsScala(fields).asScala().toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public DataType removeMetadata(String key, DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            StructField[] newFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)f -> {
                MetadataBuilder mb = new MetadataBuilder();
                DataType x$1 = MODULE$.removeMetadata(key, f.dataType());
                Metadata x$2 = mb.withMetadata(f.metadata()).remove(key).build();
                String x$3 = f.copy$default$1();
                boolean x$4 = f.copy$default$3();
                return f.copy(x$3, x$1, x$4, x$2);
            }, ClassTag$.MODULE$.apply(StructField.class));
            return new StructType(newFields);
        }
        return dt;
    }

    public DataType unionLikeMerge(DataType left, DataType right) {
        return this.mergeInternal(left, right, (Function2<StructType, StructType, StructType>)(Function2 & Serializable)(s1, s2) -> {
            StructField[] rightFields;
            StructField[] leftFields = s1.fields();
            Predef$.MODULE$.require(leftFields.length == (rightFields = s2.fields()).length, (Function0 & Serializable)() -> "To merge nullability, two structs must have same number of fields.");
            StructField[] newFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])leftFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])rightFields))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField leftField = (StructField)tuple2._1();
                    StructField rightField = (StructField)tuple2._2();
                    DataType x$1 = MODULE$.unionLikeMerge(leftField.dataType(), rightField.dataType());
                    boolean x$2 = leftField.nullable() || rightField.nullable();
                    String x$3 = leftField.copy$default$1();
                    Metadata x$4 = leftField.copy$default$4();
                    return leftField.copy(x$3, x$1, x$2, x$4);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(StructField.class));
            return new StructType(newFields);
        });
    }

    public DataType merge(DataType left, DataType right, boolean caseSensitive) {
        return this.mergeInternal(left, right, (Function2<StructType, StructType, StructType>)(Function2 & Serializable)(s1, s2) -> {
            StructField[] leftFields = s1.fields();
            StructField[] rightFields = s2.fields();
            ArrayBuffer newFields = ArrayBuffer$.MODULE$.empty();
            Map<String, StructField> rightMapped = MODULE$.fieldsMap(rightFields, caseSensitive);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])leftFields), (Function1 & Serializable)x0$1 -> {
                StructType$.$anonfun$merge$2(rightMapped, newFields, caseSensitive, x0$1);
                return BoxedUnit.UNIT;
            });
            Map<String, StructField> leftMapped = MODULE$.fieldsMap(leftFields, caseSensitive);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])rightFields), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)leftMapped.contains((Object)StructType$.normalize$1(f.name(), caseSensitive))))), (Function1 & Serializable)f -> (ArrayBuffer)newFields.$plus$eq(f));
            return new StructType((StructField[])newFields.toArray(ClassTag$.MODULE$.apply(StructField.class)));
        });
    }

    public boolean merge$default$3() {
        return true;
    }

    private DataType mergeInternal(DataType left, DataType right, Function2<StructType, StructType, StructType> mergeStruct) {
        Tuple2 tuple2 = new Tuple2((Object)left, (Object)right);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType leftElementType = arrayType.elementType();
                boolean leftContainsNull = arrayType.containsNull();
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType2;
                    DataType rightElementType = arrayType2.elementType();
                    boolean rightContainsNull = arrayType2.containsNull();
                    return new ArrayType(this.mergeInternal(leftElementType, rightElementType, mergeStruct), leftContainsNull || rightContainsNull);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType leftKeyType = mapType.keyType();
                DataType leftValueType = mapType.valueType();
                boolean leftContainsNull = mapType.valueContainsNull();
                if (dataType3 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType3;
                    DataType rightKeyType = mapType2.keyType();
                    DataType rightValueType = mapType2.valueType();
                    boolean rightContainsNull = mapType2.valueContainsNull();
                    return new MapType(this.mergeInternal(leftKeyType, rightKeyType, mergeStruct), this.mergeInternal(leftValueType, rightValueType, mergeStruct), leftContainsNull || rightContainsNull);
                }
            }
        }
        if (tuple2 != null) {
            DataType s1 = (DataType)tuple2._1();
            DataType s2 = (DataType)tuple2._2();
            if (s1 instanceof StructType) {
                StructType structType = (StructType)s1;
                if (s2 instanceof StructType) {
                    StructType structType2 = (StructType)s2;
                    return (DataType)mergeStruct.apply((Object)structType, (Object)structType2);
                }
            }
        }
        if (tuple2 != null) {
            DecimalType decimalType;
            Option<Tuple2<Object, Object>> option;
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                DecimalType decimalType2;
                Option<Tuple2<Object, Object>> option2;
                int leftPrecision = ((Tuple2)option.get())._1$mcI$sp();
                int leftScale = ((Tuple2)option.get())._2$mcI$sp();
                if (dataType4 instanceof DecimalType && !(option2 = DecimalType$Fixed$.MODULE$.unapply(decimalType2 = (DecimalType)dataType4)).isEmpty()) {
                    int rightPrecision = ((Tuple2)option2.get())._1$mcI$sp();
                    int rightScale = ((Tuple2)option2.get())._2$mcI$sp();
                    if (leftScale == rightScale) {
                        return new DecimalType(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(leftPrecision), rightPrecision), leftScale);
                    }
                    throw DataTypeErrors$.MODULE$.cannotMergeDecimalTypesWithIncompatibleScaleError(leftScale, rightScale);
                }
            }
        }
        if (tuple2 != null) {
            DataType leftUdt = (DataType)tuple2._1();
            DataType rightUdt = (DataType)tuple2._2();
            if (leftUdt instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)leftUdt;
                if (rightUdt instanceof UserDefinedType) {
                    UserDefinedType userDefinedType2 = (UserDefinedType)rightUdt;
                    Class clazz = userDefinedType.userClass();
                    Class clazz2 = userDefinedType2.userClass();
                    if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                        return userDefinedType;
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType5 = (DataType)tuple2._2();
            if (dataType instanceof YearMonthIntervalType) {
                YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
                byte lstart = yearMonthIntervalType.startField();
                byte lend = yearMonthIntervalType.endField();
                if (dataType5 instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType2 = (YearMonthIntervalType)dataType5;
                    byte rstart = yearMonthIntervalType2.startField();
                    byte rend = yearMonthIntervalType2.endField();
                    return new YearMonthIntervalType((byte)Math.min(lstart, rstart), (byte)Math.max(lend, rend));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType6 = (DataType)tuple2._2();
            if (dataType instanceof DayTimeIntervalType) {
                DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
                byte lstart = dayTimeIntervalType.startField();
                byte lend = dayTimeIntervalType.endField();
                if (dataType6 instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType2 = (DayTimeIntervalType)dataType6;
                    byte rstart = dayTimeIntervalType2.startField();
                    byte rend = dayTimeIntervalType2.endField();
                    return new DayTimeIntervalType((byte)Math.min(lstart, rstart), (byte)Math.max(lend, rend));
                }
            }
        }
        if (tuple2 != null) {
            DataType leftType = (DataType)tuple2._1();
            DataType rightType = (DataType)tuple2._2();
            DataType dataType = leftType;
            DataType dataType7 = rightType;
            if (!(dataType != null ? !dataType.equals(dataType7) : dataType7 != null)) {
                return leftType;
            }
        }
        throw DataTypeErrors$.MODULE$.cannotMergeIncompatibleDataTypesError(left, right);
    }

    public Map<String, StructField> fieldsMap(StructField[] fields, boolean caseSensitive) {
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        map.sizeHint(fields.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)s -> {
            if (caseSensitive) {
                return map.put((Object)s.name(), s);
            }
            return map.put((Object)s.name().toLowerCase(Locale.ROOT), s);
        });
        return map;
    }

    public boolean fieldsMap$default$2() {
        return true;
    }

    public Option<StructType> findMissingFields(StructType source, StructType target, Function2<String, String, Object> resolver) {
        ArrayBuffer newFields = ArrayBuffer$.MODULE$.empty();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])target.fields()), (Function1 & Serializable)field -> {
            Option found = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])source.fields()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)StructType$.$anonfun$findMissingFields$2(resolver, field, f)));
            if (found.isEmpty()) {
                return newFields.$plus$eq(field);
            }
            if (StructType$.bothStructType$1(((StructField)found.get()).dataType(), field.dataType()) && !((StructField)found.get()).dataType().sameType(field.dataType())) {
                return MODULE$.findMissingFields((StructType)((StructField)found.get()).dataType(), (StructType)field.dataType(), resolver).map((Function1 & Serializable)missingType -> {
                    StructField qual$1 = (StructField)found.get();
                    StructType x$1 = missingType;
                    String x$2 = qual$1.copy$default$1();
                    boolean x$3 = qual$1.copy$default$3();
                    Metadata x$4 = qual$1.copy$default$4();
                    return (ArrayBuffer)newFields.$plus$eq((Object)qual$1.copy(x$2, x$1, x$3, x$4));
                });
            }
            return BoxedUnit.UNIT;
        });
        if (newFields.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)new StructType((StructField[])newFields.toArray(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public StructType apply(StructField[] fields) {
        return new StructType(fields);
    }

    public Option<StructField[]> unapply(StructType x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.fields());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StructType$.class);
    }

    private static final String normalize$1(String name, boolean caseSensitive$1) {
        if (caseSensitive$1) {
            return name;
        }
        return name.toLowerCase(Locale.ROOT);
    }

    public static final /* synthetic */ void $anonfun$merge$2(Map rightMapped$1, ArrayBuffer newFields$1, boolean caseSensitive$1, StructField x0$1) {
        StructField structField = x0$1;
        if (structField != null) {
            String leftName = structField.name();
            DataType leftType = structField.dataType();
            boolean leftNullable = structField.nullable();
            rightMapped$1.get((Object)StructType$.normalize$1(leftName, caseSensitive$1)).map((Function1 & Serializable)x0$2 -> {
                StructField structField = x0$2;
                if (structField != null) {
                    StructField structField2;
                    DataType rightType = structField.dataType();
                    boolean rightNullable = structField.nullable();
                    try {
                        DataType x$1 = MODULE$.merge(leftType, rightType, MODULE$.merge$default$3());
                        boolean x$2 = leftNullable || rightNullable;
                        String x$3 = structField.copy$default$1();
                        Metadata x$4 = structField.copy$default$4();
                        structField2 = structField.copy(x$3, x$1, x$2, x$4);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            throw DataTypeErrors$.MODULE$.cannotMergeIncompatibleDataTypesError(leftType, rightType);
                        }
                        throw throwable;
                    }
                    return structField2;
                }
                throw new MatchError((Object)structField);
            }).orElse((Function0 & Serializable)() -> new Some((Object)structField)).foreach((Function1 & Serializable)x$9 -> (ArrayBuffer)newFields$1.$plus$eq(x$9));
            return;
        }
        throw new MatchError((Object)structField);
    }

    private static final boolean bothStructType$1(DataType dt1, DataType dt2) {
        return dt1 instanceof StructType && dt2 instanceof StructType;
    }

    public static final /* synthetic */ boolean $anonfun$findMissingFields$2(Function2 resolver$2, StructField field$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$2.apply((Object)field$1.name(), (Object)f.name()));
    }

    private StructType$() {
    }
}

