/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.kafka010.KafkaSource;
import org.apache.spark.sql.kafka010.StartingOffsets;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class KafkaSource$
implements Serializable {
    public static final KafkaSource$ MODULE$;
    private final String INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE;
    private final String INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE;

    static {
        new KafkaSource$();
    }

    public String INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE() {
        return this.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE;
    }

    public String INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE() {
        return this.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE;
    }

    public StructType kafkaSchema() {
        return StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("key", (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("value", (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("topic", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("partition", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("offset", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("timestamp", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("timestampType", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
    }

    public String[] org$apache$spark$sql$kafka010$KafkaSource$$getSortedExecutorList(SparkContext sc) {
        BlockManager bm = sc.env().blockManager();
        return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])bm.master().getPeers(bm.blockManagerId()).toArray(ClassTag$.MODULE$.apply(BlockManagerId.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ExecutorCacheTaskLocation apply(BlockManagerId x) {
                return new ExecutorCacheTaskLocation(x.host(), x.executorId());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExecutorCacheTaskLocation.class)))).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
                return KafkaSource$.MODULE$.org$apache$spark$sql$kafka010$KafkaSource$$compare(a, b);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ExecutorCacheTaskLocation x$5) {
                return x$5.toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public boolean org$apache$spark$sql$kafka010$KafkaSource$$compare(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
        String string = a.host();
        String string2 = b.host();
        return !(string != null ? !string.equals(string2) : string2 != null) ? new StringOps(Predef$.MODULE$.augmentString(a.executorId())).$greater((Object)b.executorId()) : new StringOps(Predef$.MODULE$.augmentString(a.host())).$greater((Object)b.host());
    }

    public int org$apache$spark$sql$kafka010$KafkaSource$$floorMod(long a, int b) {
        return ((int)(a % (long)b) + b) % b;
    }

    public KafkaSource apply(SQLContext sqlContext, KafkaSource.ConsumerStrategy consumerStrategy, java.util.Map<String, Object> executorKafkaParams, Map<String, String> sourceOptions, String metadataPath, StartingOffsets startingOffsets, boolean failOnDataLoss) {
        return new KafkaSource(sqlContext, consumerStrategy, executorKafkaParams, sourceOptions, metadataPath, startingOffsets, failOnDataLoss);
    }

    public Option<Tuple7<SQLContext, KafkaSource.ConsumerStrategy, java.util.Map<String, Object>, Map<String, String>, String, StartingOffsets, Object>> unapply(KafkaSource x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.sqlContext(), (Object)x$0.consumerStrategy(), x$0.executorKafkaParams(), x$0.sourceOptions(), (Object)x$0.metadataPath(), (Object)x$0.startingOffsets(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.failOnDataLoss())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private KafkaSource$() {
        MODULE$ = this;
        this.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE = new StringOps(Predef$.MODULE$.augmentString("\n      |Some data may have been lost because they are not available in Kafka any more; either the\n      | data was aged out by Kafka or the topic may have been deleted before all the data in the\n      | topic was processed. If you want your streaming query to fail on such cases, set the source\n      | option \"failOnDataLoss\" to \"true\".\n    ")).stripMargin();
        this.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE = new StringOps(Predef$.MODULE$.augmentString("\n      |Some data may have been lost because they are not available in Kafka any more; either the\n      | data was aged out by Kafka or the topic may have been deleted before all the data in the\n      | topic was processed. If you don't want your streaming query to fail on such cases, set the\n      | source option \"failOnDataLoss\" to \"false\".\n    ")).stripMargin();
    }
}

