/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.PartialResult;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.kafka010.CachedKafkaConsumer;
import org.apache.spark.sql.kafka010.CachedKafkaConsumer$;
import org.apache.spark.sql.kafka010.KafkaSourceRDDOffsetRange;
import org.apache.spark.sql.kafka010.KafkaSourceRDDPartition;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.NextIterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd!B\u0001\u0003\u0001\ta!AD&bM.\f7k\\;sG\u0016\u0014F\t\u0012\u0006\u0003\u0007\u0011\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7C\u0001\u0001\u000e!\rq\u0011cE\u0007\u0002\u001f)\u0011\u0001CB\u0001\u0004e\u0012$\u0017B\u0001\n\u0010\u0005\r\u0011F\t\u0012\t\u0005)miR$D\u0001\u0016\u0015\t1r#\u0001\u0005d_:\u001cX/\\3s\u0015\tA\u0012$A\u0004dY&,g\u000e^:\u000b\u0005iA\u0011!B6bM.\f\u0017B\u0001\u000f\u0016\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u00042AH\u0011$\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"!B!se\u0006L\bC\u0001\u0010%\u0013\t)sD\u0001\u0003CsR,\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\u0005M\u001c7\u0001\u0001\t\u0003U-j\u0011AB\u0005\u0003Y\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001B\f\u0001\u0003\u0002\u0003\u0006IaL\u0001\u0014Kb,7-\u001e;pe.\u000bgm[1QCJ\fWn\u001d\t\u0005aU:d(D\u00012\u0015\t\u00114'\u0001\u0003vi&d'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u00121!T1q!\tA4H\u0004\u0002\u001fs%\u0011!hH\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;?A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011iM\u0001\u0005Y\u0006tw-\u0003\u0002D\u0001\n1qJ\u00196fGRD\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IAR\u0001\r_\u001a47/\u001a;SC:<Wm\u001d\t\u0004\u000f>\u0013fB\u0001%N\u001d\tIE*D\u0001K\u0015\tY\u0005&\u0001\u0004=e>|GOP\u0005\u0002A%\u0011ajH\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0016KA\u0002TKFT!AT\u0010\u0011\u0005M#V\"\u0001\u0002\n\u0005U\u0013!!G&bM.\f7k\\;sG\u0016\u0014F\tR(gMN,GOU1oO\u0016D\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001W\u0001\u000ea>dG\u000eV5nK>,H/T:\u0011\u0005yI\u0016B\u0001. \u0005\u0011auN\\4\t\u0011q\u0003!\u0011!Q\u0001\nu\u000baBZ1jY>sG)\u0019;b\u0019>\u001c8\u000f\u0005\u0002\u001f=&\u0011ql\b\u0002\b\u0005>|G.Z1o\u0011\u0015\t\u0007\u0001\"\u0001c\u0003\u0019a\u0014N\\5u}Q11\rZ3gO\"\u0004\"a\u0015\u0001\t\u000b\u001d\u0002\u0007\u0019A\u0015\t\u000b9\u0002\u0007\u0019A\u0018\t\u000b\u0015\u0003\u0007\u0019\u0001$\t\u000b]\u0003\u0007\u0019\u0001-\t\u000bq\u0003\u0007\u0019A/\t\u000b)\u0004A\u0011I6\u0002\u000fA,'o]5tiR\u0011A.\\\u0007\u0002\u0001!)a.\u001ba\u0001_\u0006Aa.Z<MKZ,G\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002s\r\u000591\u000f^8sC\u001e,\u0017B\u0001;r\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0011\u00151\b\u0001\"\u0011x\u000359W\r\u001e)beRLG/[8ogV\t\u0001\u0010E\u0002\u001fCe\u0004\"A\u000b>\n\u0005m4!!\u0003)beRLG/[8o\u0011\u0015i\b\u0001\"\u0011\u007f\u0003\u0015\u0019w.\u001e8u)\u0005A\u0006bBA\u0001\u0001\u0011\u0005\u00131A\u0001\fG>,h\u000e^!qaJ|\u0007\u0010\u0006\u0004\u0002\u0006\u0005]\u00111\u0004\t\u0007\u0003\u000f\ti!!\u0005\u000e\u0005\u0005%!bAA\u0006\r\u00059\u0001/\u0019:uS\u0006d\u0017\u0002BA\b\u0003\u0013\u0011Q\u0002U1si&\fGNU3tk2$\b\u0003BA\u0004\u0003'IA!!\u0006\u0002\n\ti!i\\;oI\u0016$Gi\\;cY\u0016Da!!\u0007\u0000\u0001\u0004A\u0016a\u0002;j[\u0016|W\u000f\u001e\u0005\n\u0003;y\b\u0013!a\u0001\u0003?\t!bY8oM&$WM\\2f!\rq\u0012\u0011E\u0005\u0004\u0003Gy\"A\u0002#pk\ndW\rC\u0004\u0002(\u0001!\t%!\u000b\u0002\u000f%\u001cX)\u001c9usR\tQ\fC\u0004\u0002.\u0001!\t%a\f\u0002\tQ\f7.\u001a\u000b\u0005\u0003c\t\u0019\u0004E\u0002\u001fCMA\u0001\"!\u000e\u0002,\u0001\u0007\u0011qG\u0001\u0004]Vl\u0007c\u0001\u0010\u0002:%\u0019\u00111H\u0010\u0003\u0007%sG\u000fC\u0004\u0002@\u0001!\t%!\u0011\u0002+\u001d,G\u000f\u0015:fM\u0016\u0014(/\u001a3M_\u000e\fG/[8ogR!\u00111IA#!\r9uj\u000e\u0005\b\u0003\u000f\ni\u00041\u0001z\u0003\u0015\u0019\b\u000f\\5u\u0011\u001d\tY\u0005\u0001C!\u0003\u001b\nqaY8naV$X\r\u0006\u0004\u0002P\u0005U\u0013\u0011\f\t\u0005\u000f\u0006E3#C\u0002\u0002TE\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\b\u0003/\nI\u00051\u0001z\u0003\u001d!\b.\u001a)beRD\u0001\"a\u0017\u0002J\u0001\u0007\u0011QL\u0001\bG>tG/\u001a=u!\rQ\u0013qL\u0005\u0004\u0003C2!a\u0003+bg.\u001cuN\u001c;fqR\u0004")
public class KafkaSourceRDD
extends RDD<ConsumerRecord<byte[], byte[]>> {
    public final java.util.Map<String, Object> org$apache$spark$sql$kafka010$KafkaSourceRDD$$executorKafkaParams;
    private final Seq<KafkaSourceRDDOffsetRange> offsetRanges;
    public final long org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs;
    public final boolean org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss;

    public KafkaSourceRDD persist(StorageLevel newLevel) {
        this.logError((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window";
            }
        });
        return (KafkaSourceRDD)super.persist(newLevel);
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)this.offsetRanges.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaSourceRDDPartition apply(Tuple2<KafkaSourceRDDOffsetRange, Object> x0$1) {
                Tuple2<KafkaSourceRDDOffsetRange, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    KafkaSourceRDDOffsetRange o = (KafkaSourceRDDOffsetRange)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    KafkaSourceRDDPartition kafkaSourceRDDPartition = new KafkaSourceRDDPartition(i, o);
                    return kafkaSourceRDDPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public long count() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.offsetRanges.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(KafkaSourceRDDOffsetRange x$1) {
                return x$1.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public PartialResult<BoundedDouble> countApprox(long timeout, double confidence) {
        long c = this.count();
        return new PartialResult((Object)new BoundedDouble((double)c, 1.0, (double)c, (double)c), true);
    }

    public boolean isEmpty() {
        return this.count() == 0L;
    }

    public ConsumerRecord<byte[], byte[]>[] take(int num) {
        KafkaSourceRDDPartition[] nonEmptyPartitions = (KafkaSourceRDDPartition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.partitions()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaSourceRDDPartition apply(Partition x$2) {
                return (KafkaSourceRDDPartition)x$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KafkaSourceRDDPartition.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaSourceRDDPartition x$3) {
                return x$3.offsetRange().size() > 0L;
            }
        });
        if (num < 1 || Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions).isEmpty()) {
            return new ConsumerRecord[0];
        }
        Map parts = (Map)Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2)new Serializable(this, num){
            public static final long serialVersionUID = 0L;
            private final int num$1;

            public final Map<Object, Object> apply(Map<Object, Object> result, KafkaSourceRDDPartition part) {
                Map map;
                int remain = this.num$1 - BoxesRunTime.unboxToInt((Object)result.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                if (remain > 0) {
                    long taken = Math.min((long)remain, part.offsetRange().size());
                    map = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)part.index())), (Object)BoxesRunTime.boxToInteger((int)((int)taken))));
                } else {
                    map = result;
                }
                return map;
            }
            {
                this.num$1 = num$1;
            }
        });
        ArrayBuffer buf = new ArrayBuffer();
        ConsumerRecord[][] res = (ConsumerRecord[][])this.context().runJob((RDD)this, (Function2)new Serializable(this, parts){
            public static final long serialVersionUID = 0L;
            private final Map parts$1;

            public final ConsumerRecord<byte[], byte[]>[] apply(TaskContext tc, Iterator<ConsumerRecord<byte[], byte[]>> it) {
                return (ConsumerRecord[])it.take(BoxesRunTime.unboxToInt((Object)this.parts$1.apply((Object)BoxesRunTime.boxToInteger((int)tc.partitionId())))).toArray(ClassTag$.MODULE$.apply(ConsumerRecord.class));
            }
            {
                this.parts$1 = parts$1;
            }
        }, (Seq)Predef$.MODULE$.wrapIntArray((int[])parts.keys().toArray(ClassTag$.MODULE$.Int())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ConsumerRecord.class)));
        Predef$.MODULE$.refArrayOps((Object[])res).foreach((Function1)new Serializable(this, buf){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer buf$1;

            public final ArrayBuffer<ConsumerRecord<byte[], byte[]>> apply(ConsumerRecord<byte[], byte[]>[] x$4) {
                return this.buf$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])x$4));
            }
            {
                this.buf$1 = buf$1;
            }
        });
        return (ConsumerRecord[])buf.toArray(ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }

    public Seq<String> getPreferredLocations(Partition split) {
        KafkaSourceRDDPartition part = (KafkaSourceRDDPartition)split;
        return (Seq)part.offsetRange().preferredLoc().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$5) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$5}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Iterator<ConsumerRecord<byte[], byte[]>> compute(Partition thePart, TaskContext context) {
        NextIterator<ConsumerRecord<byte[], byte[]>> nextIterator;
        KafkaSourceRDDOffsetRange range = ((KafkaSourceRDDPartition)thePart).offsetRange();
        Predef$.MODULE$.assert(range.fromOffset() <= range.untilOffset(), (Function0)new Serializable(this, range){
            public static final long serialVersionUID = 0L;
            private final KafkaSourceRDDOffsetRange range$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is after the ending offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$1.fromOffset()), BoxesRunTime.boxToLong((long)this.range$1.untilOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for topic ", " partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1.topic(), BoxesRunTime.boxToInteger((int)this.range$1.partition())}))).append((Object)"You either provided an invalid fromOffset, or the Kafka topic has been damaged").toString();
            }
            {
                this.range$1 = range$1;
            }
        });
        if (range.fromOffset() == range.untilOffset()) {
            this.logInfo((Function0)new Serializable(this, range){
                public static final long serialVersionUID = 0L;
                private final KafkaSourceRDDOffsetRange range$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is the same as ending offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$1.fromOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"skipping ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1.topic(), BoxesRunTime.boxToInteger((int)this.range$1.partition())}))).toString();
                }
                {
                    this.range$1 = range$1;
                }
            });
            nextIterator = package$.MODULE$.Iterator().empty();
        } else {
            nextIterator = new NextIterator<ConsumerRecord<byte[], byte[]>>(this, range){
                private final CachedKafkaConsumer consumer;
                private long requestOffset;
                private final /* synthetic */ KafkaSourceRDD $outer;
                private final KafkaSourceRDDOffsetRange range$1;

                private CachedKafkaConsumer consumer() {
                    return this.consumer;
                }

                private long requestOffset() {
                    return this.requestOffset;
                }

                private void requestOffset_$eq(long x$1) {
                    this.requestOffset = x$1;
                }

                public ConsumerRecord<byte[], byte[]> getNext() {
                    ConsumerRecord<byte[], byte[]> consumerRecord;
                    if (this.requestOffset() >= this.range$1.untilOffset()) {
                        this.finished_$eq(true);
                        consumerRecord = null;
                    } else {
                        ConsumerRecord<byte[], byte[]> r = this.consumer().get(this.requestOffset(), this.range$1.untilOffset(), this.$outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs, this.$outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss);
                        if (r == null) {
                            this.finished_$eq(true);
                            consumerRecord = null;
                        } else {
                            this.requestOffset_$eq(r.offset() + 1L);
                            consumerRecord = r;
                        }
                    }
                    return consumerRecord;
                }

                public void close() {
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.range$1 = range$1;
                    this.consumer = CachedKafkaConsumer$.MODULE$.getOrCreate(range$1.topic(), range$1.partition(), $outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$executorKafkaParams);
                    this.requestOffset = range$1.fromOffset();
                }
            };
        }
        return nextIterator;
    }

    public KafkaSourceRDD(SparkContext sc, java.util.Map<String, Object> executorKafkaParams, Seq<KafkaSourceRDDOffsetRange> offsetRanges, long pollTimeoutMs, boolean failOnDataLoss) {
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$executorKafkaParams = executorKafkaParams;
        this.offsetRanges = offsetRanges;
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs = pollTimeoutMs;
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss = failOnDataLoss;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }
}

