/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.PartialResult;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.kafka010.CachedKafkaConsumer;
import org.apache.spark.sql.kafka010.CachedKafkaConsumer$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaSourceRDDOffsetRange;
import org.apache.spark.sql.kafka010.KafkaSourceRDDPartition;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.NextIterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005md!B\u0001\u0003\u0001\ta!AD&bM.\f7k\\;sG\u0016\u0014F\t\u0012\u0006\u0003\u0007\u0011\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7C\u0001\u0001\u000e!\rq\u0011cE\u0007\u0002\u001f)\u0011\u0001CB\u0001\u0004e\u0012$\u0017B\u0001\n\u0010\u0005\r\u0011F\t\u0012\t\u0005)miR$D\u0001\u0016\u0015\t1r#\u0001\u0005d_:\u001cX/\\3s\u0015\tA\u0012$A\u0004dY&,g\u000e^:\u000b\u0005iA\u0011!B6bM.\f\u0017B\u0001\u000f\u0016\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u00042AH\u0011$\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"!B!se\u0006L\bC\u0001\u0010%\u0013\t)sD\u0001\u0003CsR,\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\u0005M\u001c7\u0001\u0001\t\u0003U-j\u0011AB\u0005\u0003Y\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001B\f\u0001\u0003\u0002\u0003\u0006IaL\u0001\u0014Kb,7-\u001e;pe.\u000bgm[1QCJ\fWn\u001d\t\u0005aU:d(D\u00012\u0015\t\u00114'\u0001\u0003vi&d'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u00121!T1q!\tA4H\u0004\u0002\u001fs%\u0011!hH\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;?A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011iM\u0001\u0005Y\u0006tw-\u0003\u0002D\u0001\n1qJ\u00196fGRD\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IAR\u0001\r_\u001a47/\u001a;SC:<Wm\u001d\t\u0004\u000f>\u0013fB\u0001%N\u001d\tIE*D\u0001K\u0015\tY\u0005&\u0001\u0004=e>|GOP\u0005\u0002A%\u0011ajH\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0016KA\u0002TKFT!AT\u0010\u0011\u0005M#V\"\u0001\u0002\n\u0005U\u0013!!G&bM.\f7k\\;sG\u0016\u0014F\tR(gMN,GOU1oO\u0016D\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001W\u0001\u000ea>dG\u000eV5nK>,H/T:\u0011\u0005yI\u0016B\u0001. \u0005\u0011auN\\4\t\u0011q\u0003!\u0011!Q\u0001\nu\u000baBZ1jY>sG)\u0019;b\u0019>\u001c8\u000f\u0005\u0002\u001f=&\u0011ql\b\u0002\b\u0005>|G.Z1o\u0011!\t\u0007A!A!\u0002\u0013i\u0016A\u0005:fkN,7*\u00194lC\u000e{gn];nKJDQa\u0019\u0001\u0005\u0002\u0011\fa\u0001P5oSRtDcB3gO\"L'n\u001b\t\u0003'\u0002AQa\n2A\u0002%BQA\f2A\u0002=BQ!\u00122A\u0002\u0019CQa\u00162A\u0002aCQ\u0001\u00182A\u0002uCQ!\u00192A\u0002uCQ!\u001c\u0001\u0005B9\fq\u0001]3sg&\u001cH\u000f\u0006\u0002pa6\t\u0001\u0001C\u0003rY\u0002\u0007!/\u0001\u0005oK^dUM^3m!\t\u0019h/D\u0001u\u0015\t)h!A\u0004ti>\u0014\u0018mZ3\n\u0005]$(\u0001D*u_J\fw-\u001a'fm\u0016d\u0007\"B=\u0001\t\u0003R\u0018!D4fiB\u000b'\u000f^5uS>t7/F\u0001|!\rq\u0012\u0005 \t\u0003UuL!A \u0004\u0003\u0013A\u000b'\u000f^5uS>t\u0007bBA\u0001\u0001\u0011\u0005\u00131A\u0001\u0006G>,h\u000e\u001e\u000b\u00021\"9\u0011q\u0001\u0001\u0005B\u0005%\u0011aC2pk:$\u0018\t\u001d9s_b$b!a\u0003\u0002\u001e\u0005\u0005\u0002CBA\u0007\u0003'\t9\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\u0004\u0002\u000fA\f'\u000f^5bY&!\u0011QCA\b\u00055\u0001\u0016M\u001d;jC2\u0014Vm];miB!\u0011QBA\r\u0013\u0011\tY\"a\u0004\u0003\u001b\t{WO\u001c3fI\u0012{WO\u00197f\u0011\u001d\ty\"!\u0002A\u0002a\u000bq\u0001^5nK>,H\u000f\u0003\u0006\u0002$\u0005\u0015\u0001\u0013!a\u0001\u0003K\t!bY8oM&$WM\\2f!\rq\u0012qE\u0005\u0004\u0003Sy\"A\u0002#pk\ndW\rC\u0004\u0002.\u0001!\t%a\f\u0002\u000f%\u001cX)\u001c9usR\tQ\fC\u0004\u00024\u0001!\t%!\u000e\u0002\tQ\f7.\u001a\u000b\u0005\u0003o\tI\u0004E\u0002\u001fCMA\u0001\"a\u000f\u00022\u0001\u0007\u0011QH\u0001\u0004]Vl\u0007c\u0001\u0010\u0002@%\u0019\u0011\u0011I\u0010\u0003\u0007%sG\u000fC\u0004\u0002F\u0001!\t%a\u0012\u0002+\u001d,G\u000f\u0015:fM\u0016\u0014(/\u001a3M_\u000e\fG/[8ogR!\u0011\u0011JA&!\r9uj\u000e\u0005\b\u0003\u001b\n\u0019\u00051\u0001}\u0003\u0015\u0019\b\u000f\\5u\u0011\u001d\t\t\u0006\u0001C!\u0003'\nqaY8naV$X\r\u0006\u0004\u0002V\u0005m\u0013q\f\t\u0005\u000f\u0006]3#C\u0002\u0002ZE\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\b\u0003;\ny\u00051\u0001}\u0003\u001d!\b.\u001a)beRD\u0001\"!\u0019\u0002P\u0001\u0007\u00111M\u0001\bG>tG/\u001a=u!\rQ\u0013QM\u0005\u0004\u0003O2!a\u0003+bg.\u001cuN\u001c;fqRDq!a\u001b\u0001\t\u0013\ti'\u0001\u0007sKN|GN^3SC:<W\rF\u0003S\u0003_\n9\bC\u0004\u0017\u0003S\u0002\r!!\u001d\u0011\u0007M\u000b\u0019(C\u0002\u0002v\t\u00111cQ1dQ\u0016$7*\u00194lC\u000e{gn];nKJDq!!\u001f\u0002j\u0001\u0007!+A\u0003sC:<W\r")
public class KafkaSourceRDD
extends RDD<ConsumerRecord<byte[], byte[]>> {
    public final Map<String, Object> org$apache$spark$sql$kafka010$KafkaSourceRDD$$executorKafkaParams;
    private final Seq<KafkaSourceRDDOffsetRange> offsetRanges;
    public final long org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs;
    public final boolean org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss;
    public final boolean org$apache$spark$sql$kafka010$KafkaSourceRDD$$reuseKafkaConsumer;

    public KafkaSourceRDD persist(StorageLevel newLevel) {
        this.logError((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window";
            }
        });
        return (KafkaSourceRDD)super.persist(newLevel);
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)this.offsetRanges.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaSourceRDDPartition apply(Tuple2<KafkaSourceRDDOffsetRange, Object> x0$1) {
                Tuple2<KafkaSourceRDDOffsetRange, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    KafkaSourceRDDOffsetRange o = (KafkaSourceRDDOffsetRange)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    KafkaSourceRDDPartition kafkaSourceRDDPartition = new KafkaSourceRDDPartition(i, o);
                    return kafkaSourceRDDPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public long count() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.offsetRanges.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(KafkaSourceRDDOffsetRange x$1) {
                return x$1.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public PartialResult<BoundedDouble> countApprox(long timeout, double confidence) {
        long c = this.count();
        return new PartialResult((Object)new BoundedDouble((double)c, 1.0, (double)c, (double)c), true);
    }

    public boolean isEmpty() {
        return this.count() == 0L;
    }

    public ConsumerRecord<byte[], byte[]>[] take(int num) {
        KafkaSourceRDDPartition[] nonEmptyPartitions = (KafkaSourceRDDPartition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.partitions()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaSourceRDDPartition apply(Partition x$2) {
                return (KafkaSourceRDDPartition)x$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KafkaSourceRDDPartition.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaSourceRDDPartition x$3) {
                return x$3.offsetRange().size() > 0L;
            }
        });
        if (num < 1 || Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions).isEmpty()) {
            return new ConsumerRecord[0];
        }
        scala.collection.immutable.Map parts = (scala.collection.immutable.Map)Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2)new Serializable(this, num){
            public static final long serialVersionUID = 0L;
            private final int num$1;

            public final scala.collection.immutable.Map<Object, Object> apply(scala.collection.immutable.Map<Object, Object> result, KafkaSourceRDDPartition part) {
                scala.collection.immutable.Map map;
                int remain = this.num$1 - BoxesRunTime.unboxToInt((Object)result.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                if (remain > 0) {
                    long taken = Math.min((long)remain, part.offsetRange().size());
                    map = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)part.index())), (Object)BoxesRunTime.boxToInteger((int)((int)taken))));
                } else {
                    map = result;
                }
                return map;
            }
            {
                this.num$1 = num$1;
            }
        });
        ArrayBuffer buf = new ArrayBuffer();
        ConsumerRecord[][] res = (ConsumerRecord[][])this.context().runJob((RDD)this, (Function2)new Serializable(this, parts){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map parts$1;

            public final ConsumerRecord<byte[], byte[]>[] apply(TaskContext tc, Iterator<ConsumerRecord<byte[], byte[]>> it) {
                return (ConsumerRecord[])it.take(BoxesRunTime.unboxToInt((Object)this.parts$1.apply((Object)BoxesRunTime.boxToInteger((int)tc.partitionId())))).toArray(ClassTag$.MODULE$.apply(ConsumerRecord.class));
            }
            {
                this.parts$1 = parts$1;
            }
        }, (Seq)Predef$.MODULE$.wrapIntArray((int[])parts.keys().toArray(ClassTag$.MODULE$.Int())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ConsumerRecord.class)));
        Predef$.MODULE$.refArrayOps((Object[])res).foreach((Function1)new Serializable(this, buf){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer buf$1;

            public final ArrayBuffer<ConsumerRecord<byte[], byte[]>> apply(ConsumerRecord<byte[], byte[]>[] x$4) {
                return this.buf$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])x$4));
            }
            {
                this.buf$1 = buf$1;
            }
        });
        return (ConsumerRecord[])buf.toArray(ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }

    public Seq<String> getPreferredLocations(Partition split) {
        KafkaSourceRDDPartition part = (KafkaSourceRDDPartition)split;
        return (Seq)part.offsetRange().preferredLoc().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$5) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$5}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Iterator<ConsumerRecord<byte[], byte[]>> compute(Partition thePart, TaskContext context) {
        Object object;
        KafkaSourceRDDPartition sourcePartition = (KafkaSourceRDDPartition)thePart;
        String topic = sourcePartition.offsetRange().topic();
        int kafkaPartition = sourcePartition.offsetRange().partition();
        CachedKafkaConsumer consumer = this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$reuseKafkaConsumer ? CachedKafkaConsumer$.MODULE$.getOrCreate(topic, kafkaPartition, this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$executorKafkaParams) : CachedKafkaConsumer$.MODULE$.createUncached(topic, kafkaPartition, this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$executorKafkaParams);
        KafkaSourceRDDOffsetRange range = this.resolveRange(consumer, sourcePartition.offsetRange());
        Predef$.MODULE$.assert(range.fromOffset() <= range.untilOffset(), (Function0)new Serializable(this, range){
            public static final long serialVersionUID = 0L;
            private final KafkaSourceRDDOffsetRange range$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is after the ending offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$1.fromOffset()), BoxesRunTime.boxToLong((long)this.range$1.untilOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for topic ", " partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1.topic(), BoxesRunTime.boxToInteger((int)this.range$1.partition())}))).append((Object)"You either provided an invalid fromOffset, or the Kafka topic has been damaged").toString();
            }
            {
                this.range$1 = range$1;
            }
        });
        if (range.fromOffset() == range.untilOffset()) {
            this.logInfo((Function0)new Serializable(this, range){
                public static final long serialVersionUID = 0L;
                private final KafkaSourceRDDOffsetRange range$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is the same as ending offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$1.fromOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"skipping ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1.topic(), BoxesRunTime.boxToInteger((int)this.range$1.partition())}))).toString();
                }
                {
                    this.range$1 = range$1;
                }
            });
            object = package$.MODULE$.Iterator().empty();
        } else {
            NextIterator<ConsumerRecord<byte[], byte[]>> underlying = new NextIterator<ConsumerRecord<byte[], byte[]>>(this, topic, kafkaPartition, consumer, range){
                private long requestOffset;
                private final /* synthetic */ KafkaSourceRDD $outer;
                private final String topic$1;
                private final int kafkaPartition$1;
                private final CachedKafkaConsumer consumer$1;
                private final KafkaSourceRDDOffsetRange range$1;

                public long requestOffset() {
                    return this.requestOffset;
                }

                public void requestOffset_$eq(long x$1) {
                    this.requestOffset = x$1;
                }

                public ConsumerRecord<byte[], byte[]> getNext() {
                    ConsumerRecord<byte[], byte[]> consumerRecord;
                    if (this.requestOffset() >= this.range$1.untilOffset()) {
                        this.finished_$eq(true);
                        consumerRecord = null;
                    } else {
                        ConsumerRecord<byte[], byte[]> r = this.consumer$1.get(this.requestOffset(), this.range$1.untilOffset(), this.$outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs, this.$outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss);
                        if (r == null) {
                            this.finished_$eq(true);
                            consumerRecord = null;
                        } else {
                            this.requestOffset_$eq(r.offset() + 1L);
                            consumerRecord = r;
                        }
                    }
                    return consumerRecord;
                }

                public void close() {
                    if (this.$outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$reuseKafkaConsumer) {
                        CachedKafkaConsumer$.MODULE$.releaseKafkaConsumer(this.topic$1, this.kafkaPartition$1, this.$outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$executorKafkaParams);
                    } else {
                        this.consumer$1.close();
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                    this.kafkaPartition$1 = kafkaPartition$1;
                    this.consumer$1 = consumer$1;
                    this.range$1 = range$1;
                    this.requestOffset = range$1.fromOffset();
                }
            };
            context.addTaskCompletionListener((Function1)new Serializable(this, (NextIterator)underlying){
                public static final long serialVersionUID = 0L;
                private final NextIterator underlying$1;

                public final void apply(TaskContext x$6) {
                    this.underlying$1.closeIfNeeded();
                }
                {
                    this.underlying$1 = underlying$1;
                }
            });
            object = underlying;
        }
        return object;
    }

    private KafkaSourceRDDOffsetRange resolveRange(CachedKafkaConsumer consumer, KafkaSourceRDDOffsetRange range) {
        KafkaSourceRDDOffsetRange kafkaSourceRDDOffsetRange;
        if (range.fromOffset() < 0L || range.untilOffset() < 0L) {
            long l;
            long fromOffset;
            long l2;
            CachedKafkaConsumer.AvailableOffsetRange availableOffsetRange = consumer.getAvailableOffsetRange();
            if (range.fromOffset() < 0L) {
                Predef$.MODULE$.assert(range.fromOffset() == KafkaOffsetRangeLimit$.MODULE$.EARLIEST(), (Function0)new Serializable(this, range){
                    public static final long serialVersionUID = 0L;
                    private final KafkaSourceRDDOffsetRange range$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"earliest offset ", " does not equal ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$2.fromOffset()), BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.EARLIEST())}));
                    }
                    {
                        this.range$2 = range$2;
                    }
                });
                l2 = availableOffsetRange.earliest();
            } else {
                l2 = fromOffset = range.fromOffset();
            }
            if (range.untilOffset() < 0L) {
                Predef$.MODULE$.assert(range.untilOffset() == KafkaOffsetRangeLimit$.MODULE$.LATEST(), (Function0)new Serializable(this, range){
                    public static final long serialVersionUID = 0L;
                    private final KafkaSourceRDDOffsetRange range$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"latest offset ", " does not equal ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$2.untilOffset()), BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST())}));
                    }
                    {
                        this.range$2 = range$2;
                    }
                });
                l = availableOffsetRange.latest();
            } else {
                l = range.untilOffset();
            }
            long untilOffset = l;
            kafkaSourceRDDOffsetRange = new KafkaSourceRDDOffsetRange(range.topicPartition(), fromOffset, untilOffset, range.preferredLoc());
        } else {
            kafkaSourceRDDOffsetRange = range;
        }
        return kafkaSourceRDDOffsetRange;
    }

    public KafkaSourceRDD(SparkContext sc, Map<String, Object> executorKafkaParams, Seq<KafkaSourceRDDOffsetRange> offsetRanges, long pollTimeoutMs, boolean failOnDataLoss2, boolean reuseKafkaConsumer) {
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$executorKafkaParams = executorKafkaParams;
        this.offsetRanges = offsetRanges;
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs = pollTimeoutMs;
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss = failOnDataLoss2;
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$reuseKafkaConsumer = reuseKafkaConsumer;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }
}

