/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.kafka010.CachedKafkaConsumer;
import org.apache.spark.sql.kafka010.CachedKafkaConsumer$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CachedKafkaConsumer$
implements Logging,
Serializable {
    public static final CachedKafkaConsumer$ MODULE$;
    private final long org$apache$spark$sql$kafka010$CachedKafkaConsumer$$UNKNOWN_OFFSET;
    private LinkedHashMap<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer> cache;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new CachedKafkaConsumer$();
    }

    private LinkedHashMap cache$lzycompute() {
        CachedKafkaConsumer$ cachedKafkaConsumer$ = this;
        synchronized (cachedKafkaConsumer$) {
            if (!this.bitmap$0) {
                SparkConf conf = SparkEnv$.MODULE$.get().conf();
                int capacity = conf.getInt("spark.sql.kafkaConsumerCache.capacity", 64);
                this.cache = new LinkedHashMap<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer>(capacity){
                    public final int capacity$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean removeEldestEntry(Map.Entry<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer> entry) {
                        if (entry.getValue().org$apache$spark$sql$kafka010$CachedKafkaConsumer$$inuse()) return false;
                        if (this.size() <= this.capacity$1) return false;
                        CachedKafkaConsumer$.MODULE$.logWarning((Function0<String>)new Serializable(this, entry){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;
                            private final Map.Entry entry$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KafkaConsumer cache hitting max capacity of ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.capacity$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removing consumer for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.entry$1 = entry$1;
                            }
                        });
                        try {
                            entry.getValue().close();
                            return true;
                        }
                        catch (SparkException sparkException) {
                            CachedKafkaConsumer$.MODULE$.logError((Function0<String>)new Serializable(this, entry){
                                public static final long serialVersionUID = 0L;
                                private final Map.Entry entry$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error closing earliest Kafka consumer for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}));
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            }, sparkException);
                        }
                        return true;
                    }
                    {
                        this.capacity$1 = capacity$1;
                        super(capacity$1, 0.75f, true);
                    }
                };
                this.bitmap$0 = true;
            }
            return this.cache;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public long org$apache$spark$sql$kafka010$CachedKafkaConsumer$$UNKNOWN_OFFSET() {
        return this.org$apache$spark$sql$kafka010$CachedKafkaConsumer$$UNKNOWN_OFFSET;
    }

    private LinkedHashMap<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer> cache() {
        return this.bitmap$0 ? this.cache : this.cache$lzycompute();
    }

    public void releaseKafkaConsumer(String topic, int partition, Map<String, Object> kafkaParams) {
        String groupId = (String)kafkaParams.get("group.id");
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        CachedKafkaConsumer.CacheKey key = new CachedKafkaConsumer.CacheKey(groupId, topicPartition);
        CachedKafkaConsumer$ cachedKafkaConsumer$ = this;
        synchronized (cachedKafkaConsumer$) {
            BoxedUnit boxedUnit;
            CachedKafkaConsumer consumer = this.cache().get(key);
            if (consumer == null) {
                this.logWarning((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to release consumer that does not exist"})).s((Seq)Nil$.MODULE$);
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                consumer.org$apache$spark$sql$kafka010$CachedKafkaConsumer$$inuse_$eq(false);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void removeKafkaConsumer(String topic, int partition, Map<String, Object> kafkaParams) {
        String groupId = (String)kafkaParams.get("group.id");
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        CachedKafkaConsumer.CacheKey key = new CachedKafkaConsumer.CacheKey(groupId, topicPartition);
        CachedKafkaConsumer$ cachedKafkaConsumer$ = this;
        synchronized (cachedKafkaConsumer$) {
            BoxedUnit boxedUnit;
            CachedKafkaConsumer removedConsumer = (CachedKafkaConsumer)this.cache().remove(key);
            if (removedConsumer == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                removedConsumer.close();
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public synchronized CachedKafkaConsumer getOrCreate(String topic, int partition, Map<String, Object> kafkaParams) {
        CachedKafkaConsumer cachedKafkaConsumer;
        String groupId = (String)kafkaParams.get("group.id");
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        CachedKafkaConsumer.CacheKey key = new CachedKafkaConsumer.CacheKey(groupId, topicPartition);
        if (TaskContext$.MODULE$.get() != null && TaskContext$.MODULE$.get().attemptNumber() >= 1) {
            this.removeKafkaConsumer(topic, partition, kafkaParams);
            CachedKafkaConsumer consumer = new CachedKafkaConsumer(topicPartition, kafkaParams);
            consumer.org$apache$spark$sql$kafka010$CachedKafkaConsumer$$inuse_$eq(true);
            this.cache().put(key, consumer);
            cachedKafkaConsumer = consumer;
        } else {
            Object object = this.cache().containsKey(key) ? BoxedUnit.UNIT : this.cache().put(key, new CachedKafkaConsumer(topicPartition, kafkaParams));
            CachedKafkaConsumer consumer = this.cache().get(key);
            consumer.org$apache$spark$sql$kafka010$CachedKafkaConsumer$$inuse_$eq(true);
            cachedKafkaConsumer = consumer;
        }
        return cachedKafkaConsumer;
    }

    public CachedKafkaConsumer createUncached(String topic, int partition, Map<String, Object> kafkaParams) {
        return new CachedKafkaConsumer(new TopicPartition(topic, partition), kafkaParams);
    }

    public void org$apache$spark$sql$kafka010$CachedKafkaConsumer$$reportDataLoss0(boolean failOnDataLoss2, String finalMessage, Throwable cause) {
        if (failOnDataLoss2) {
            if (cause == null) {
                throw new IllegalStateException(finalMessage);
            }
            throw new IllegalStateException(finalMessage, cause);
        }
        if (cause == null) {
            this.logWarning((Function0<String>)new Serializable(finalMessage){
                public static final long serialVersionUID = 0L;
                private final String finalMessage$1;

                public final String apply() {
                    return this.finalMessage$1;
                }
                {
                    this.finalMessage$1 = finalMessage$1;
                }
            });
        } else {
            this.logWarning((Function0<String>)new Serializable(finalMessage){
                public static final long serialVersionUID = 0L;
                private final String finalMessage$1;

                public final String apply() {
                    return this.finalMessage$1;
                }
                {
                    this.finalMessage$1 = finalMessage$1;
                }
            }, cause);
        }
    }

    private Throwable reportDataLoss0$default$3() {
        return null;
    }

    public CachedKafkaConsumer apply(TopicPartition topicPartition, Map<String, Object> kafkaParams) {
        return new CachedKafkaConsumer(topicPartition, kafkaParams);
    }

    public Option<Tuple2<TopicPartition, Map<String, Object>>> unapply(CachedKafkaConsumer x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.topicPartition(), x$0.kafkaParams()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CachedKafkaConsumer$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$sql$kafka010$CachedKafkaConsumer$$UNKNOWN_OFFSET = -2L;
    }
}

