/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.kafka010.ConsumerStrategy;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaOffsetReader$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaSourceRDD;
import org.apache.spark.sql.kafka010.KafkaSourceRDDOffsetRange;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005=a!B\u0001\u0003\u0001\ta!!D&bM.\f'+\u001a7bi&|gN\u0003\u0002\u0004\t\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cB\u0001A\u0007\u0014-A\u0011a\"E\u0007\u0002\u001f)\u0011\u0001\u0003B\u0001\bg>,(oY3t\u0013\t\u0011rB\u0001\u0007CCN,'+\u001a7bi&|g\u000e\u0005\u0002\u000f)%\u0011Qc\u0004\u0002\n)\u0006\u0014G.Z*dC:\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!a\u0007\r\u0003\u000f1{wmZ5oO\"AQ\u0004\u0001BC\u0002\u0013\u0005s$\u0001\u0006tc2\u001cuN\u001c;fqR\u001c\u0001!F\u0001!!\t\t#%D\u0001\u0005\u0013\t\u0019CA\u0001\u0006T#2\u001buN\u001c;fqRD\u0001\"\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\fgFd7i\u001c8uKb$\b\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0003!\u0019HO]1uK\u001eL\bCA\u0015+\u001b\u0005\u0011\u0011BA\u0016\u0003\u0005A\u0019uN\\:v[\u0016\u00148\u000b\u001e:bi\u0016<\u0017\u0010\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u00035\u0019x.\u001e:dK>\u0003H/[8ogB!q&\u000e\u001d9\u001d\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0003\u0019\u0001&/\u001a3fM&\u0011ag\u000e\u0002\u0004\u001b\u0006\u0004(B\u0001\u001b2!\ty\u0013(\u0003\u0002;o\t11\u000b\u001e:j]\u001eD\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0015gB,7-\u001b4jK\u0012\\\u0015MZ6b!\u0006\u0014\u0018-\\:\t\u0011y\u0002!\u0011!Q\u0001\n}\naBZ1jY>sG)\u0019;b\u0019>\u001c8\u000f\u0005\u00021\u0001&\u0011\u0011)\r\u0002\b\u0005>|G.Z1o\u0011!\u0019\u0005A!A!\u0002\u0013!\u0015aD:uCJ$\u0018N\\4PM\u001a\u001cX\r^:\u0011\u0005%*\u0015B\u0001$\u0003\u0005UY\u0015MZ6b\u001f\u001a47/\u001a;SC:<W\rT5nSRD\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I\u0001R\u0001\u000eK:$\u0017N\\4PM\u001a\u001cX\r^:\t\u000b)\u0003A\u0011A&\u0002\rqJg.\u001b;?)!aUJT(Q#J\u001b\u0006CA\u0015\u0001\u0011\u0015i\u0012\n1\u0001!\u0011\u00159\u0013\n1\u0001)\u0011\u0015i\u0013\n1\u0001/\u0011\u0015a\u0014\n1\u0001/\u0011\u0015q\u0014\n1\u0001@\u0011\u0015\u0019\u0015\n1\u0001E\u0011\u0015A\u0015\n1\u0001E\u0011\u001d)\u0006A1A\u0005\nY\u000bQ\u0002]8mYRKW.Z8vi6\u001bX#A,\u0011\u0005AB\u0016BA-2\u0005\u0011auN\\4\t\rm\u0003\u0001\u0015!\u0003X\u00039\u0001x\u000e\u001c7US6,w.\u001e;Ng\u0002BQ!\u0018\u0001\u0005By\u000baa]2iK6\fW#A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t$\u0011!\u0002;za\u0016\u001c\u0018B\u00013b\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006M\u0002!\teZ\u0001\nEVLG\u000eZ*dC:$\u0012\u0001\u001b\t\u0004S2tW\"\u00016\u000b\u0005-4\u0011a\u0001:eI&\u0011QN\u001b\u0002\u0004%\u0012#\u0005CA\u0011p\u0013\t\u0001HAA\u0002S_^DQA\u001d\u0001\u0005\nM\f1cZ3u!\u0006\u0014H/\u001b;j_:|eMZ:fiN$B\u0001^?\u0002\u0006A!q&N;X!\t180D\u0001x\u0015\tA\u00180\u0001\u0004d_6lwN\u001c\u0006\u0003u\"\tQa[1gW\u0006L!\u0001`<\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")a0\u001da\u0001\u007f\u0006Y1.\u00194lCJ+\u0017\rZ3s!\rI\u0013\u0011A\u0005\u0004\u0003\u0007\u0011!!E&bM.\fwJ\u001a4tKR\u0014V-\u00193fe\"1\u0011qA9A\u0002\u0011\u000bAb[1gW\u0006|eMZ:fiNDq!a\u0003\u0001\t\u0003\ni!\u0001\u0005u_N#(/\u001b8h)\u0005A\u0004")
public class KafkaRelation
extends BaseRelation
implements TableScan,
Logging {
    private final SQLContext sqlContext;
    private final ConsumerStrategy strategy;
    private final scala.collection.immutable.Map<String, String> sourceOptions;
    private final scala.collection.immutable.Map<String, String> specifiedKafkaParams;
    private final boolean failOnDataLoss;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final KafkaOffsetRangeLimit endingOffsets;
    private final long pollTimeoutMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public StructType schema() {
        return KafkaOffsetReader$.MODULE$.kafkaSchema();
    }

    /*
     * WARNING - void declaration
     */
    public RDD<Row> buildScan() {
        Tuple2 tuple2;
        String uniqueGroupId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-kafka-relation-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID()}));
        KafkaOffsetReader kafkaOffsetReader = new KafkaOffsetReader(this.strategy, KafkaSourceProvider$.MODULE$.kafkaParamsForDriver(this.specifiedKafkaParams), this.sourceOptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-driver"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uniqueGroupId})));
        try {
            tuple2 = new Tuple2(this.getPartitionOffsets(kafkaOffsetReader, this.startingOffsets), this.getPartitionOffsets(kafkaOffsetReader, this.endingOffsets));
            kafkaOffsetReader.close();
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 != null) {
            void var10_9;
            void var9_8;
            Tuple2 tuple23;
            scala.collection.immutable.Map fromPartitionOffsets = (scala.collection.immutable.Map)tuple22._1();
            scala.collection.immutable.Map untilPartitionOffsets = (scala.collection.immutable.Map)tuple22._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)fromPartitionOffsets, (Object)untilPartitionOffsets);
            scala.collection.immutable.Map fromPartitionOffsets2 = (scala.collection.immutable.Map)tuple24._1();
            scala.collection.immutable.Map untilPartitionOffsets2 = (scala.collection.immutable.Map)tuple24._2();
            Set set2 = fromPartitionOffsets2.keySet();
            Set set3 = untilPartitionOffsets2.keySet();
            if (!(set2 != null ? !set2.equals(set3) : set3 != null)) {
                KafkaSourceRDDOffsetRange[] offsetRanges = (KafkaSourceRDDOffsetRange[])((TraversableOnce)untilPartitionOffsets2.keySet().map((Function1)new Serializable(this, fromPartitionOffsets2, untilPartitionOffsets2){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map fromPartitionOffsets$1;
                    private final scala.collection.immutable.Map untilPartitionOffsets$1;

                    public final KafkaSourceRDDOffsetRange apply(TopicPartition tp) {
                        long fromOffset = BoxesRunTime.unboxToLong((Object)this.fromPartitionOffsets$1.get((Object)tp).getOrElse((Function0)new Serializable(this, tp){
                            public static final long serialVersionUID = 0L;
                            private final TopicPartition tp$1;

                            public final Nothing$ apply() {
                                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " doesn't have a from offset"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1})));
                            }
                            {
                                this.tp$1 = tp$1;
                            }
                        }));
                        long untilOffset = BoxesRunTime.unboxToLong((Object)this.untilPartitionOffsets$1.apply((Object)tp));
                        return new KafkaSourceRDDOffsetRange(tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
                    }
                    {
                        this.fromPartitionOffsets$1 = fromPartitionOffsets$1;
                        this.untilPartitionOffsets$1 = untilPartitionOffsets$1;
                    }
                }, Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(KafkaSourceRDDOffsetRange.class));
                this.logInfo((Function0<String>)new Serializable(this, offsetRanges){
                    public static final long serialVersionUID = 0L;
                    private final KafkaSourceRDDOffsetRange[] offsetRanges$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"GetBatch generating RDD of offset range: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges$1).sortBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(KafkaSourceRDDOffsetRange x$2) {
                                return x$2.topicPartition().toString();
                            }
                        }, (Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString();
                    }
                    {
                        this.offsetRanges$1 = offsetRanges$1;
                    }
                });
                Map<String, Object> executorKafkaParams = KafkaSourceProvider$.MODULE$.kafkaParamsForExecutors(this.specifiedKafkaParams, uniqueGroupId);
                RDD rdd = new KafkaSourceRDD(this.sqlContext().sparkContext(), executorKafkaParams, (Seq<KafkaSourceRDDOffsetRange>)Predef$.MODULE$.wrapRefArray((Object[])offsetRanges), this.pollTimeoutMs(), this.failOnDataLoss, false).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InternalRow apply(ConsumerRecord<byte[], byte[]> cr) {
                        return InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cr.key(), cr.value(), UTF8String.fromString((String)cr.topic()), BoxesRunTime.boxToInteger((int)cr.partition()), BoxesRunTime.boxToLong((long)cr.offset()), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(cr.timestamp()))), BoxesRunTime.boxToInteger((int)cr.timestampType().id)}));
                    }
                }, ClassTag$.MODULE$.apply(InternalRow.class));
                return this.sqlContext().internalCreateDataFrame(rdd, this.schema(), this.sqlContext().internalCreateDataFrame$default$3()).rdd();
            }
            Ordering topicOrdering = package$.MODULE$.Ordering().by((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(TopicPartition t) {
                    return t.topic();
                }
            }, (Ordering)Ordering.String$.MODULE$);
            String fromTopics = ((TraversableOnce)var9_8.keySet().toList().sorted(topicOrdering)).mkString(",");
            String untilTopics = ((TraversableOnce)var10_9.keySet().toList().sorted(topicOrdering)).mkString(",");
            throw new IllegalStateException(new StringBuilder().append((Object)"different topic partitions ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for starting offsets topics[", "] and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fromTopics}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ending offsets topics[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{untilTopics}))).toString());
        }
        throw new MatchError((Object)tuple22);
    }

    private scala.collection.immutable.Map<TopicPartition, Object> getPartitionOffsets(KafkaOffsetReader kafkaReader, KafkaOffsetRangeLimit kafkaOffsets) {
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit;
        block5: {
            scala.collection.immutable.Map map;
            block3: {
                Set<TopicPartition> partitions2;
                block4: {
                    block2: {
                        partitions2 = kafkaReader.fetchTopicPartitions();
                        kafkaOffsetRangeLimit = kafkaOffsets;
                        if (!EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) break block2;
                        map = ((TraversableOnce)partitions2.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<TopicPartition, Object> apply(TopicPartition x0$1) {
                                TopicPartition topicPartition = x0$1;
                                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.EARLIEST()));
                                return tuple2;
                            }
                        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        break block3;
                    }
                    if (!LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) break block4;
                    map = ((TraversableOnce)partitions2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<TopicPartition, Object> apply(TopicPartition x0$2) {
                            TopicPartition topicPartition = x0$2;
                            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST()));
                            return tuple2;
                        }
                    }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    break block3;
                }
                if (!(kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit)) break block5;
                SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets2 = specificOffsetRangeLimit.partitionOffsets();
                map = this.validateTopicPartitions$1(partitions2, partitionOffsets2);
            }
            return map;
        }
        throw new MatchError((Object)kafkaOffsetRangeLimit);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KafkaRelation(strategy=", ", start=", ", end=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.strategy, this.startingOffsets, this.endingOffsets}));
    }

    private final scala.collection.immutable.Map validateTopicPartitions$1(Set partitions2, scala.collection.immutable.Map partitionOffsets2) {
        Set set2 = partitions2;
        Set set3 = partitionOffsets2.keySet();
        Predef$.MODULE$.assert(!(set2 != null ? !set2.equals(set3) : set3 != null), (Function0)new Serializable(this, partitions2, partitionOffsets2){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;
            private final scala.collection.immutable.Map partitionOffsets$1;

            public final String apply() {
                return new StringBuilder().append((Object)"If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest, if you don't care.\n").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified: ", " Assigned: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionOffsets$1.keySet(), this.partitions$1}))).toString();
            }
            {
                this.partitions$1 = partitions$1;
                this.partitionOffsets$1 = partitionOffsets$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this, partitions2, partitionOffsets2){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;
            private final scala.collection.immutable.Map partitionOffsets$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partitions assigned to consumer: ", ". Seeking to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitions$1, this.partitionOffsets$1}));
            }
            {
                this.partitions$1 = partitions$1;
                this.partitionOffsets$1 = partitionOffsets$1;
            }
        });
        return partitionOffsets2;
    }

    public KafkaRelation(SQLContext sqlContext, ConsumerStrategy strategy2, scala.collection.immutable.Map<String, String> sourceOptions, scala.collection.immutable.Map<String, String> specifiedKafkaParams, boolean failOnDataLoss2, KafkaOffsetRangeLimit startingOffsets, KafkaOffsetRangeLimit endingOffsets) {
        this.sqlContext = sqlContext;
        this.strategy = strategy2;
        this.sourceOptions = sourceOptions;
        this.specifiedKafkaParams = specifiedKafkaParams;
        this.failOnDataLoss = failOnDataLoss2;
        this.startingOffsets = startingOffsets;
        this.endingOffsets = endingOffsets;
        Logging.class.$init$((Logging)this);
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = startingOffsets;
        LatestOffsetRangeLimit$ latestOffsetRangeLimit$ = LatestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(kafkaOffsetRangeLimit != null ? !kafkaOffsetRangeLimit.equals(latestOffsetRangeLimit$) : latestOffsetRangeLimit$ != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting offset not allowed to be set to latest offsets.";
            }
        });
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit2 = endingOffsets;
        EarliestOffsetRangeLimit$ earliestOffsetRangeLimit$ = EarliestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(kafkaOffsetRangeLimit2 != null ? !kafkaOffsetRangeLimit2.equals(earliestOffsetRangeLimit$) : earliestOffsetRangeLimit$ != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Ending offset not allowed to be set to earliest offsets.";
            }
        });
        this.pollTimeoutMs = new StringOps(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)"kafkaConsumer.pollTimeoutMs", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaRelation $outer;

            public final String apply() {
                return ((Object)BoxesRunTime.boxToLong((long)this.$outer.sqlContext().sparkContext().conf().getTimeAsMs("spark.network.timeout", "120s"))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }))).toLong();
    }
}

