/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.kafka010.KafkaDataConsumer;
import org.apache.spark.sql.kafka010.KafkaDataConsumer$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaSourceRDDOffsetRange;
import org.apache.spark.sql.kafka010.KafkaSourceRDDPartition;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.NextIterator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005]b!B\u0001\u0003\u0001\ta!AD&bM.\f7k\\;sG\u0016\u0014F\t\u0012\u0006\u0003\u0007\u0011\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7C\u0001\u0001\u000e!\rq\u0011cE\u0007\u0002\u001f)\u0011\u0001CB\u0001\u0004e\u0012$\u0017B\u0001\n\u0010\u0005\r\u0011F\t\u0012\t\u0005)miR$D\u0001\u0016\u0015\t1r#\u0001\u0005d_:\u001cX/\\3s\u0015\tA\u0012$A\u0004dY&,g\u000e^:\u000b\u0005iA\u0011!B6bM.\f\u0017B\u0001\u000f\u0016\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u00042AH\u0011$\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"!B!se\u0006L\bC\u0001\u0010%\u0013\t)sD\u0001\u0003CsR,\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\u0005M\u001c7\u0001\u0001\t\u0003U-j\u0011AB\u0005\u0003Y\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001B\f\u0001\u0003\u0002\u0003\u0006IaL\u0001\u0014Kb,7-\u001e;pe.\u000bgm[1QCJ\fWn\u001d\t\u0005aU:d(D\u00012\u0015\t\u00114'\u0001\u0003vi&d'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u00121!T1q!\tA4H\u0004\u0002\u001fs%\u0011!hH\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;?A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011iM\u0001\u0005Y\u0006tw-\u0003\u0002D\u0001\n1qJ\u00196fGRD\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IAR\u0001\r_\u001a47/\u001a;SC:<Wm\u001d\t\u0004\u000f>\u0013fB\u0001%N\u001d\tIE*D\u0001K\u0015\tY\u0005&\u0001\u0004=e>|GOP\u0005\u0002A%\u0011ajH\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0016KA\u0002TKFT!AT\u0010\u0011\u0005M#V\"\u0001\u0002\n\u0005U\u0013!!G&bM.\f7k\\;sG\u0016\u0014F\tR(gMN,GOU1oO\u0016D\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001W\u0001\u000ea>dG\u000eV5nK>,H/T:\u0011\u0005yI\u0016B\u0001. \u0005\u0011auN\\4\t\u0011q\u0003!\u0011!Q\u0001\nu\u000baBZ1jY>sG)\u0019;b\u0019>\u001c8\u000f\u0005\u0002\u001f=&\u0011ql\b\u0002\b\u0005>|G.Z1o\u0011!\t\u0007A!A!\u0002\u0013i\u0016A\u0005:fkN,7*\u00194lC\u000e{gn];nKJDQa\u0019\u0001\u0005\u0002\u0011\fa\u0001P5oSRtDcB3gO\"L'n\u001b\t\u0003'\u0002AQa\n2A\u0002%BQA\f2A\u0002=BQ!\u00122A\u0002\u0019CQa\u00162A\u0002aCQ\u0001\u00182A\u0002uCQ!\u00192A\u0002uCQ!\u001c\u0001\u0005B9\fq\u0001]3sg&\u001cH\u000f\u0006\u0002pa6\t\u0001\u0001C\u0003rY\u0002\u0007!/\u0001\u0005oK^dUM^3m!\t\u0019h/D\u0001u\u0015\t)h!A\u0004ti>\u0014\u0018mZ3\n\u0005]$(\u0001D*u_J\fw-\u001a'fm\u0016d\u0007\"B=\u0001\t\u0003R\u0018!D4fiB\u000b'\u000f^5uS>t7/F\u0001|!\rq\u0012\u0005 \t\u0003UuL!A \u0004\u0003\u0013A\u000b'\u000f^5uS>t\u0007bBA\u0001\u0001\u0011\u0005\u00131A\u0001\u0016O\u0016$\bK]3gKJ\u0014X\r\u001a'pG\u0006$\u0018n\u001c8t)\u0011\t)!a\u0002\u0011\u0007\u001d{u\u0007\u0003\u0004\u0002\n}\u0004\r\u0001`\u0001\u0006gBd\u0017\u000e\u001e\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0003\u001d\u0019w.\u001c9vi\u0016$b!!\u0005\u0002\u0018\u0005m\u0001\u0003B$\u0002\u0014MI1!!\u0006R\u0005!IE/\u001a:bi>\u0014\bbBA\r\u0003\u0017\u0001\r\u0001`\u0001\bi\",\u0007+\u0019:u\u0011!\ti\"a\u0003A\u0002\u0005}\u0011aB2p]R,\u0007\u0010\u001e\t\u0004U\u0005\u0005\u0012bAA\u0012\r\tYA+Y:l\u0007>tG/\u001a=u\u0011\u001d\t9\u0003\u0001C\u0005\u0003S\tAB]3t_24XMU1oO\u0016$RAUA\u0016\u0003gAqAFA\u0013\u0001\u0004\ti\u0003E\u0002T\u0003_I1!!\r\u0003\u0005EY\u0015MZ6b\t\u0006$\u0018mQ8ogVlWM\u001d\u0005\b\u0003k\t)\u00031\u0001S\u0003\u0015\u0011\u0018M\\4f\u0001")
public class KafkaSourceRDD
extends RDD<ConsumerRecord<byte[], byte[]>> {
    private final Map<String, Object> executorKafkaParams;
    private final Seq<KafkaSourceRDDOffsetRange> offsetRanges;
    public final long org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs;
    public final boolean org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss;
    private final boolean reuseKafkaConsumer;

    public KafkaSourceRDD persist(StorageLevel newLevel) {
        this.logError((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window";
            }
        });
        return (KafkaSourceRDD)super.persist(newLevel);
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)this.offsetRanges.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaSourceRDDPartition apply(Tuple2<KafkaSourceRDDOffsetRange, Object> x0$1) {
                Tuple2<KafkaSourceRDDOffsetRange, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    KafkaSourceRDDOffsetRange o = (KafkaSourceRDDOffsetRange)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    KafkaSourceRDDPartition kafkaSourceRDDPartition = new KafkaSourceRDDPartition(i, o);
                    return kafkaSourceRDDPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public Seq<String> getPreferredLocations(Partition split) {
        KafkaSourceRDDPartition part = (KafkaSourceRDDPartition)split;
        return (Seq)part.offsetRange().preferredLoc().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$1) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$1}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Iterator<ConsumerRecord<byte[], byte[]>> compute(Partition thePart, TaskContext context) {
        Object object;
        KafkaSourceRDDPartition sourcePartition = (KafkaSourceRDDPartition)thePart;
        KafkaDataConsumer consumer = KafkaDataConsumer$.MODULE$.acquire(sourcePartition.offsetRange().topicPartition(), this.executorKafkaParams, this.reuseKafkaConsumer);
        KafkaSourceRDDOffsetRange range = this.resolveRange(consumer, sourcePartition.offsetRange());
        Predef$.MODULE$.assert(range.fromOffset() <= range.untilOffset(), (Function0)new Serializable(this, range){
            public static final long serialVersionUID = 0L;
            private final KafkaSourceRDDOffsetRange range$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is after the ending offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$1.fromOffset()), BoxesRunTime.boxToLong((long)this.range$1.untilOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for topic ", " partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1.topic(), BoxesRunTime.boxToInteger((int)this.range$1.partition())}))).append((Object)"You either provided an invalid fromOffset, or the Kafka topic has been damaged").toString();
            }
            {
                this.range$1 = range$1;
            }
        });
        if (range.fromOffset() == range.untilOffset()) {
            this.logInfo((Function0)new Serializable(this, range){
                public static final long serialVersionUID = 0L;
                private final KafkaSourceRDDOffsetRange range$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is the same as ending offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$1.fromOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"skipping ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1.topic(), BoxesRunTime.boxToInteger((int)this.range$1.partition())}))).toString();
                }
                {
                    this.range$1 = range$1;
                }
            });
            consumer.release();
            object = package$.MODULE$.Iterator().empty();
        } else {
            NextIterator<ConsumerRecord<byte[], byte[]>> underlying = new NextIterator<ConsumerRecord<byte[], byte[]>>(this, consumer, range){
                private long requestOffset;
                private final /* synthetic */ KafkaSourceRDD $outer;
                private final KafkaDataConsumer consumer$1;
                private final KafkaSourceRDDOffsetRange range$1;

                public long requestOffset() {
                    return this.requestOffset;
                }

                public void requestOffset_$eq(long x$1) {
                    this.requestOffset = x$1;
                }

                public ConsumerRecord<byte[], byte[]> getNext() {
                    ConsumerRecord<byte[], byte[]> consumerRecord;
                    if (this.requestOffset() >= this.range$1.untilOffset()) {
                        this.finished_$eq(true);
                        consumerRecord = null;
                    } else {
                        ConsumerRecord<byte[], byte[]> r = this.consumer$1.get(this.requestOffset(), this.range$1.untilOffset(), this.$outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs, this.$outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss);
                        if (r == null) {
                            this.finished_$eq(true);
                            consumerRecord = null;
                        } else {
                            this.requestOffset_$eq(r.offset() + 1L);
                            consumerRecord = r;
                        }
                    }
                    return consumerRecord;
                }

                public void close() {
                    this.consumer$1.release();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.consumer$1 = consumer$1;
                    this.range$1 = range$1;
                    this.requestOffset = range$1.fromOffset();
                }
            };
            context.addTaskCompletionListener((Function1)new Serializable(this, (NextIterator)underlying){
                public static final long serialVersionUID = 0L;
                private final NextIterator underlying$1;

                public final void apply(TaskContext x$2) {
                    this.underlying$1.closeIfNeeded();
                }
                {
                    this.underlying$1 = underlying$1;
                }
            });
            object = underlying;
        }
        return object;
    }

    private KafkaSourceRDDOffsetRange resolveRange(KafkaDataConsumer consumer, KafkaSourceRDDOffsetRange range) {
        KafkaSourceRDDOffsetRange kafkaSourceRDDOffsetRange;
        if (range.fromOffset() < 0L || range.untilOffset() < 0L) {
            long l;
            long fromOffset;
            long l2;
            KafkaDataConsumer.AvailableOffsetRange availableOffsetRange = consumer.getAvailableOffsetRange();
            if (range.fromOffset() < 0L) {
                Predef$.MODULE$.assert(range.fromOffset() == KafkaOffsetRangeLimit$.MODULE$.EARLIEST(), (Function0)new Serializable(this, range){
                    public static final long serialVersionUID = 0L;
                    private final KafkaSourceRDDOffsetRange range$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"earliest offset ", " does not equal ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$2.fromOffset()), BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.EARLIEST())}));
                    }
                    {
                        this.range$2 = range$2;
                    }
                });
                l2 = availableOffsetRange.earliest();
            } else {
                l2 = fromOffset = range.fromOffset();
            }
            if (range.untilOffset() < 0L) {
                Predef$.MODULE$.assert(range.untilOffset() == KafkaOffsetRangeLimit$.MODULE$.LATEST(), (Function0)new Serializable(this, range){
                    public static final long serialVersionUID = 0L;
                    private final KafkaSourceRDDOffsetRange range$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"latest offset ", " does not equal ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$2.untilOffset()), BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST())}));
                    }
                    {
                        this.range$2 = range$2;
                    }
                });
                l = availableOffsetRange.latest();
            } else {
                l = range.untilOffset();
            }
            long untilOffset = l;
            kafkaSourceRDDOffsetRange = new KafkaSourceRDDOffsetRange(range.topicPartition(), fromOffset, untilOffset, range.preferredLoc());
        } else {
            kafkaSourceRDDOffsetRange = range;
        }
        return kafkaSourceRDDOffsetRange;
    }

    public KafkaSourceRDD(SparkContext sc, Map<String, Object> executorKafkaParams, Seq<KafkaSourceRDDOffsetRange> offsetRanges, long pollTimeoutMs, boolean failOnDataLoss2, boolean reuseKafkaConsumer) {
        this.executorKafkaParams = executorKafkaParams;
        this.offsetRanges = offsetRanges;
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs = pollTimeoutMs;
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss = failOnDataLoss2;
        this.reuseKafkaConsumer = reuseKafkaConsumer;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }
}

