/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.kafka010.FetchedData;
import org.apache.spark.sql.kafka010.FetchedDataPool$CachedFetchedData$;
import org.apache.spark.sql.kafka010.KafkaDataConsumer;
import org.apache.spark.sql.kafka010.package$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tme!B A\u0001\u0001S\u0005\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011D\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\u0006]\u0002!\ta\u001c\u0005\u0006]\u0002!\t!\u001e\u0005\bq\u0002\u0011\r\u0011\"\u0003z\u0011\u001d\u0011Y\u0003\u0001Q\u0001\niD\u0011B!\f\u0001\u0005\u0004%I!a\u0018\t\u0011\t=\u0002\u0001)A\u0005\u0003CB\u0011B!\r\u0001\u0005\u0004%I!a\u0018\t\u0011\tM\u0002\u0001)A\u0005\u0003CBqA!\u000e\u0001\t\u0013\u00119\u0004C\u0005\u0003T\u0001\u0001\r\u0011\"\u0003\u0003V!I!q\u000b\u0001A\u0002\u0013%!\u0011\f\u0005\t\u0005;\u0002\u0001\u0015)\u0003\u0003:!I!q\f\u0001C\u0002\u0013%!\u0011\r\u0005\t\u0005_\u0002\u0001\u0015!\u0003\u0003d!I!\u0011\u000f\u0001C\u0002\u0013%!\u0011\r\u0005\t\u0005g\u0002\u0001\u0015!\u0003\u0003d!9!Q\u000f\u0001\u0005\u0002\u0005}\u0003b\u0002B<\u0001\u0011\u0005\u0011q\f\u0005\b\u0005s\u0002A\u0011\u0001B>\u0011\u001d\u0011)\t\u0001C\u0001\u0005\u000fCqAa#\u0001\t\u0003\u0011i\tC\u0004\u0003\u0014\u0002!\tA!&\t\u000f\t]\u0005\u0001\"\u0001\u0003\u0016\"9!\u0011\u0014\u0001\u0005\n\tUu\u0001CA\u0019\u0001\"\u0005\u0001)a\r\u0007\u000f}\u0002\u0005\u0012\u0001!\u00026!1a.\bC\u0001\u0003o1q!!\u000f\u001e\u0001\u0002\u000bY\u0004\u0003\u0006\u0002J}\u0011)\u001a!C\u0001\u0003\u0017B!\"a\u0015 \u0005#\u0005\u000b\u0011BA'\u0011\u0019qw\u0004\"\u0001\u0002V!I\u0011QL\u0010A\u0002\u0013\u0005\u0011q\f\u0005\n\u0003Oz\u0002\u0019!C\u0001\u0003SB\u0001\"!\u001e A\u0003&\u0011\u0011\r\u0005\n\u0003oz\u0002\u0019!C\u0001\u0003?B\u0011\"!\u001f \u0001\u0004%\t!a\u001f\t\u0011\u0005}t\u0004)Q\u0005\u0003CB\u0011\"!! \u0001\u0004%\t!a!\t\u0013\u0005-u\u00041A\u0005\u0002\u00055\u0005\u0002CAI?\u0001\u0006K!!\"\t\u000f\u0005Mu\u0004\"\u0001\u0002L!I\u0011QS\u0010\u0002\u0002\u0013\u0005\u0011q\u0013\u0005\n\u00037{\u0012\u0013!C\u0001\u0003;C\u0011\"a- \u0003\u0003%\t%!.\t\u0013\u0005\rw$!A\u0005\u0002\u0005\u0015\u0007\"CAg?\u0005\u0005I\u0011AAh\u0011%\tInHA\u0001\n\u0003\nY\u000eC\u0005\u0002f~\t\t\u0011\"\u0001\u0002h\"I\u00111^\u0010\u0002\u0002\u0013\u0005\u0013Q\u001e\u0005\n\u0003_|\u0012\u0011!C!\u0003cD\u0011\"a= \u0003\u0003%\t%!>\b\u0011\u0005eX\u0004#\u0003A\u0003w4\u0001\"!\u000f\u001e\u0011\u0013\u0001\u0015Q \u0005\u0007]b\"\t!a@\t\u000f\t\u0005\u0001\b\"\u0001\u0003\u0004!I!Q\u0001\u001d\u0002\u0002\u0013\u0005%q\u0001\u0005\n\u0005\u0017A\u0014\u0011!CA\u0005\u001bA\u0011B!\u00079\u0003\u0003%IAa\u0007\u0006\u000f\t\rR\u0004\u0001!\u0003&\tya)\u001a;dQ\u0016$G)\u0019;b!>|GN\u0003\u0002B\u0005\u0006A1.\u00194lCB\n\u0004G\u0003\u0002D\t\u0006\u00191/\u001d7\u000b\u0005\u00153\u0015!B:qCJ\\'BA$I\u0003\u0019\t\u0007/Y2iK*\t\u0011*A\u0002pe\u001e\u001c2\u0001A&R!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u0019\te.\u001f*fMB\u0011!+V\u0007\u0002'*\u0011A\u000bR\u0001\tS:$XM\u001d8bY&\u0011ak\u0015\u0002\b\u0019><w-\u001b8h\u0003=)\u00070Z2vi>\u00148+\u001a:wS\u000e,7\u0001\u0001\t\u00035\u0006l\u0011a\u0017\u0006\u00039v\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003En\u0013\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003\u0015\u0019Gn\\2l!\t)w-D\u0001g\u0015\tqF)\u0003\u0002iM\n)1\t\\8dW\u0006!1m\u001c8g!\tYG.D\u0001E\u0013\tiGIA\u0005Ta\u0006\u00148nQ8oM\u00061A(\u001b8jiz\"B\u0001\u001d:tiB\u0011\u0011\u000fA\u0007\u0002\u0001\")q\u000b\u0002a\u00013\")1\r\u0002a\u0001I\")\u0011\u000e\u0002a\u0001UR\u0011\u0001O\u001e\u0005\u0006o\u0016\u0001\rA[\u0001\ngB\f'o[\"p]\u001a\fQaY1dQ\u0016,\u0012A\u001f\t\bw\u0006\u0005\u0011QAA\u0017\u001b\u0005a(BA?\u007f\u0003\u001diW\u000f^1cY\u0016T!a`'\u0002\u0015\r|G\u000e\\3di&|g.C\u0002\u0002\u0004q\u00141!T1q!\u0011\t9!a\n\u000f\t\u0005%\u00111\u0005\b\u0005\u0003\u0017\t\tC\u0004\u0003\u0002\u000e\u0005}a\u0002BA\b\u0003;qA!!\u0005\u0002\u001c9!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018a\u000ba\u0001\u0010:p_Rt\u0014\"A%\n\u0005\u001dC\u0015BA#G\u0013\t\u0019E)\u0003\u0002B\u0005&\u0019\u0011Q\u0005!\u0002#-\u000bgm[1ECR\f7i\u001c8tk6,'/\u0003\u0003\u0002*\u0005-\"\u0001C\"bG\",7*Z=\u000b\u0007\u0005\u0015\u0002\tE\u0002\u00020yr!!\u001d\u000f\u0002\u001f\u0019+Go\u00195fI\u0012\u000bG/\u0019)p_2\u0004\"!]\u000f\u0014\u0005uYECAA\u001a\u0005E\u0019\u0015m\u00195fI\u001a+Go\u00195fI\u0012\u000bG/Y\n\u0007?-\u000bi$a\u0011\u0011\u00071\u000by$C\u0002\u0002B5\u0013q\u0001\u0015:pIV\u001cG\u000fE\u0002M\u0003\u000bJ1!a\u0012N\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003-1W\r^2iK\u0012$\u0015\r^1\u0016\u0005\u00055\u0003cA9\u0002P%\u0019\u0011\u0011\u000b!\u0003\u0017\u0019+Go\u00195fI\u0012\u000bG/Y\u0001\rM\u0016$8\r[3e\t\u0006$\u0018\r\t\u000b\u0005\u0003/\nY\u0006E\u0002\u0002Z}i\u0011!\b\u0005\b\u0003\u0013\u0012\u0003\u0019AA'\u0003Ua\u0017m\u001d;SK2,\u0017m]3e)&lWm\u001d;b[B,\"!!\u0019\u0011\u00071\u000b\u0019'C\u0002\u0002f5\u0013A\u0001T8oO\u0006IB.Y:u%\u0016dW-Y:fIRKW.Z:uC6\u0004x\fJ3r)\u0011\tY'!\u001d\u0011\u00071\u000bi'C\u0002\u0002p5\u0013A!\u00168ji\"I\u00111\u000f\u0013\u0002\u0002\u0003\u0007\u0011\u0011M\u0001\u0004q\u0012\n\u0014A\u00067bgR\u0014V\r\\3bg\u0016$G+[7fgR\fW\u000e\u001d\u0011\u0002+1\f7\u000f^!dcVL'/\u001a3US6,7\u000f^1na\u0006IB.Y:u\u0003\u000e\fX/\u001b:fIRKW.Z:uC6\u0004x\fJ3r)\u0011\tY'! \t\u0013\u0005Mt%!AA\u0002\u0005\u0005\u0014A\u00067bgR\f5-];je\u0016$G+[7fgR\fW\u000e\u001d\u0011\u0002\u000b%tWk]3\u0016\u0005\u0005\u0015\u0005c\u0001'\u0002\b&\u0019\u0011\u0011R'\u0003\u000f\t{w\u000e\\3b]\u0006I\u0011N\\+tK~#S-\u001d\u000b\u0005\u0003W\ny\tC\u0005\u0002t)\n\t\u00111\u0001\u0002\u0006\u00061\u0011N\\+tK\u0002\n\u0011bZ3u\u001f\nTWm\u0019;\u0002\t\r|\u0007/\u001f\u000b\u0005\u0003/\nI\nC\u0005\u0002J5\u0002\n\u00111\u0001\u0002N\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAPU\u0011\ti%!),\u0005\u0005\r\u0006\u0003BAS\u0003_k!!a*\u000b\t\u0005%\u00161V\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!,N\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\u000b9KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\\!\u0011\tI,a0\u000e\u0005\u0005m&bAA_?\u0006!A.\u00198h\u0013\u0011\t\t-a/\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\rE\u0002M\u0003\u0013L1!a3N\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t.a6\u0011\u00071\u000b\u0019.C\u0002\u0002V6\u00131!\u00118z\u0011%\t\u0019(MA\u0001\u0002\u0004\t9-A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u000e\u0005\u0004\u0002`\u0006\u0005\u0018\u0011[\u0007\u0002}&\u0019\u00111\u001d@\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000b\u000bI\u000fC\u0005\u0002tM\n\t\u00111\u0001\u0002R\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002H\u0006AAo\\*ue&tw\r\u0006\u0002\u00028\u00061Q-];bYN$B!!\"\u0002x\"I\u00111\u000f\u001c\u0002\u0002\u0003\u0007\u0011\u0011[\u0001\u0012\u0007\u0006\u001c\u0007.\u001a3GKR\u001c\u0007.\u001a3ECR\f\u0007cAA-qM!\u0001hSA\")\t\tY0A\u0003f[B$\u0018\u0010\u0006\u0002\u0002X\u0005)\u0011\r\u001d9msR!\u0011q\u000bB\u0005\u0011\u001d\tIe\u000fa\u0001\u0003\u001b\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0010\tU\u0001#\u0002'\u0003\u0012\u00055\u0013b\u0001B\n\u001b\n1q\n\u001d;j_:D\u0011Ba\u0006=\u0003\u0003\u0005\r!a\u0016\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u000f!\u0011\tILa\b\n\t\t\u0005\u00121\u0018\u0002\u0007\u001f\nTWm\u0019;\u0003+\r\u000b7\r[3e\r\u0016$8\r[3e\t\u0006$\u0018\rT5tiB)1Pa\n\u0002X%\u0019!\u0011\u0006?\u0003\u00151K7\u000f\u001e\"vM\u001a,'/\u0001\u0004dC\u000eDW\rI\u0001\u001b[&tWI^5di\u0006\u0014G.Z%eY\u0016$\u0016.\\3NS2d\u0017n]\u0001\u001c[&tWI^5di\u0006\u0014G.Z%eY\u0016$\u0016.\\3NS2d\u0017n\u001d\u0011\u0002=\u00154\u0018n\u0019;peRC'/Z1e%Vt\u0017J\u001c;feZ\fG.T5mY&\u001c\u0018aH3wS\u000e$xN\u001d+ie\u0016\fGMU;o\u0013:$XM\u001d<bY6KG\u000e\\5tA\u0005\u00112\u000f^1si\u00163\u0018n\u0019;peRC'/Z1e)\t\u0011I\u0004E\u0003M\u0005#\u0011Y\u0004\r\u0003\u0003>\t\u001d\u0003#\u0002.\u0003@\t\r\u0013b\u0001B!7\ny1k\u00195fIVdW\r\u001a$viV\u0014X\r\u0005\u0003\u0003F\t\u001dC\u0002\u0001\u0003\f\u0005\u0013b\u0011\u0011!A\u0001\u0006\u0003\u0011YEA\u0002`IE\nBA!\u0014\u0002RB\u0019AJa\u0014\n\u0007\tESJA\u0004O_RD\u0017N\\4\u0002\u0013M\u001c\u0007.\u001a3vY\u0016$WC\u0001B\u001d\u00035\u00198\r[3ek2,Gm\u0018\u0013fcR!\u00111\u000eB.\u0011%\t\u0019HDA\u0001\u0002\u0004\u0011I$\u0001\u0006tG\",G-\u001e7fI\u0002\nQC\\;n\u0007J,\u0017\r^3e\r\u0016$8\r[3e\t\u0006$\u0018-\u0006\u0002\u0003dA!!Q\rB6\u001b\t\u00119GC\u0002\u0003jm\u000ba!\u0019;p[&\u001c\u0017\u0002\u0002B7\u0005O\u0012\u0011\u0002T8oO\u0006#G-\u001a:\u0002-9,Xn\u0011:fCR,GMR3uG\",G\rR1uC\u0002\n\u0001C\\;n)>$\u0018\r\\#mK6,g\u000e^:\u0002#9,X\u000eV8uC2,E.Z7f]R\u001c\b%\u0001\u0006ok6\u001c%/Z1uK\u0012\f\u0001B\\;n)>$\u0018\r\\\u0001\bC\u000e\fX/\u001b:f)\u0019\tiE! \u0003\u0002\"9!q\u0010\fA\u0002\u0005\u0015\u0011aA6fs\"9!1\u0011\fA\u0002\u0005\u0005\u0014A\u00053fg&\u0014X\rZ*uCJ$xJ\u001a4tKR\f!\"\u001b8wC2LG-\u0019;f)\u0011\tYG!#\t\u000f\t}t\u00031\u0001\u0002\u0006\u00059!/\u001a7fCN,GCBA6\u0005\u001f\u0013\t\nC\u0004\u0003\u0000a\u0001\r!!\u0002\t\u000f\u0005%\u0003\u00041\u0001\u0002N\u0005A1\u000f[;uI><h\u000e\u0006\u0002\u0002l\u0005)!/Z:fi\u0006)\"/Z7pm\u0016LE\r\\3GKR\u001c\u0007.\u001a3ECR\f\u0007")
public class FetchedDataPool
implements Logging {
    private final ScheduledExecutorService executorService;
    private final Clock clock;
    private final Map<KafkaDataConsumer.CacheKey, ListBuffer<CachedFetchedData>> cache;
    private final long minEvictableIdleTimeMillis;
    private final long evictorThreadRunIntervalMillis;
    private Option<ScheduledFuture<?>> scheduled;
    private final LongAdder numCreatedFetchedData;
    private final LongAdder numTotalElements;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Map<KafkaDataConsumer.CacheKey, ListBuffer<CachedFetchedData>> cache() {
        return this.cache;
    }

    private long minEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    private long evictorThreadRunIntervalMillis() {
        return this.evictorThreadRunIntervalMillis;
    }

    private Option<ScheduledFuture<?>> startEvictorThread() {
        None$ none$;
        if (this.evictorThreadRunIntervalMillis() > 0L) {
            ScheduledFuture<?> future = this.executorService.scheduleAtFixedRate(() -> Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.removeIdleFetchedData()), 0L, this.evictorThreadRunIntervalMillis(), TimeUnit.MILLISECONDS);
            none$ = new Some(future);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<ScheduledFuture<?>> scheduled() {
        return this.scheduled;
    }

    private void scheduled_$eq(Option<ScheduledFuture<?>> x$1) {
        this.scheduled = x$1;
    }

    private LongAdder numCreatedFetchedData() {
        return this.numCreatedFetchedData;
    }

    private LongAdder numTotalElements() {
        return this.numTotalElements;
    }

    public long numCreated() {
        return this.numCreatedFetchedData().sum();
    }

    public long numTotal() {
        return this.numTotalElements().sum();
    }

    public synchronized FetchedData acquire(KafkaDataConsumer.CacheKey key, long desiredStartOffset) {
        ListBuffer fetchedDataList = (ListBuffer)this.cache().getOrElseUpdate((Object)key, (Function0 & Serializable & scala.Serializable)() -> new ListBuffer());
        Option cachedFetchedDataOption = fetchedDataList.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FetchedDataPool.$anonfun$acquire$2(desiredStartOffset, p)));
        CachedFetchedData cachedFetchedData = null;
        if (cachedFetchedDataOption.isDefined()) {
            cachedFetchedData = (CachedFetchedData)cachedFetchedDataOption.get();
        } else {
            cachedFetchedData = FetchedDataPool$CachedFetchedData$.MODULE$.empty();
            fetchedDataList.$plus$eq((Object)cachedFetchedData);
            this.numCreatedFetchedData().increment();
            this.numTotalElements().increment();
        }
        cachedFetchedData.lastAcquiredTimestamp_$eq(this.clock.getTimeMillis());
        cachedFetchedData.inUse_$eq(true);
        return cachedFetchedData.getObject();
    }

    public synchronized void invalidate(KafkaDataConsumer.CacheKey key) {
        Option option = this.cache().remove((Object)key);
        if (option instanceof Some) {
            Some some = (Some)option;
            ListBuffer lst = (ListBuffer)some.value();
            this.numTotalElements().add(-1 * lst.size());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public synchronized void release(KafkaDataConsumer.CacheKey key, FetchedData fetchedData) {
        Option option = this.cache().get((Object)key);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            ListBuffer fetchedDataList = (ListBuffer)some.value();
            Option cachedFetchedDataOption = fetchedDataList.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FetchedDataPool.$anonfun$release$2(fetchedData, p)));
            if (cachedFetchedDataOption.isEmpty()) {
                this.warnReleasedDataNotInPool$1(key, fetchedData);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                CachedFetchedData cachedFetchedData = (CachedFetchedData)cachedFetchedDataOption.get();
                cachedFetchedData.inUse_$eq(false);
                cachedFetchedData.lastReleasedTimestamp_$eq(this.clock.getTimeMillis());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            this.warnReleasedDataNotInPool$1(key, fetchedData);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void shutdown() {
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.executorService, ThreadUtils$.MODULE$.shutdown$default$2());
    }

    public synchronized void reset() {
        this.scheduled().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.cancel(true)));
        this.cache().clear();
        this.numTotalElements().reset();
        this.numCreatedFetchedData().reset();
        this.scheduled_$eq(this.startEvictorThread());
    }

    private synchronized void removeIdleFetchedData() {
        long now = this.clock.getTimeMillis();
        long maxAllowedReleasedTimestamp = now - this.minEvictableIdleTimeMillis();
        this.cache().values().foreach((Function1 & Serializable & scala.Serializable)p -> {
            FetchedDataPool.$anonfun$removeIdleFetchedData$1(this, maxAllowedReleasedTimestamp, p);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$acquire$2(long desiredStartOffset$1, CachedFetchedData p) {
        return !p.inUse() && p.getObject().nextOffsetInFetchedData() == desiredStartOffset$1;
    }

    private final void warnReleasedDataNotInPool$1(KafkaDataConsumer.CacheKey key, FetchedData fetchedData) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("No matching data in pool for ").append(fetchedData).append(" in key ").append(key).append(". ").append("It might be released before, or it was not a part of pool.").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$release$2(FetchedData fetchedData$2, CachedFetchedData p) {
        if (!p.inUse()) return false;
        FetchedData fetchedData = p.getObject();
        FetchedData fetchedData2 = fetchedData$2;
        if (fetchedData != null) {
            if (!((Object)fetchedData).equals(fetchedData2)) return false;
            return true;
        }
        if (fetchedData2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$removeIdleFetchedData$2(long maxAllowedReleasedTimestamp$1, CachedFetchedData q) {
        return !q.inUse() && q.lastReleasedTimestamp() < maxAllowedReleasedTimestamp$1;
    }

    public static final /* synthetic */ void $anonfun$removeIdleFetchedData$1(FetchedDataPool $this, long maxAllowedReleasedTimestamp$1, ListBuffer p) {
        ListBuffer expired = (ListBuffer)p.filter((Function1 & Serializable & scala.Serializable)q -> BoxesRunTime.boxToBoolean((boolean)FetchedDataPool.$anonfun$removeIdleFetchedData$2(maxAllowedReleasedTimestamp$1, q)));
        p.$minus$minus$eq((TraversableOnce)expired);
        $this.numTotalElements().add(-1 * expired.size());
    }

    public FetchedDataPool(ScheduledExecutorService executorService, Clock clock, SparkConf conf) {
        this.executorService = executorService;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.cache = HashMap$.MODULE$.empty();
        this.minEvictableIdleTimeMillis = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.FETCHED_DATA_CACHE_TIMEOUT()));
        this.evictorThreadRunIntervalMillis = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.FETCHED_DATA_CACHE_EVICTOR_THREAD_RUN_INTERVAL()));
        this.scheduled = this.startEvictorThread();
        this.numCreatedFetchedData = new LongAdder();
        this.numTotalElements = new LongAdder();
    }

    public FetchedDataPool(SparkConf sparkConf) {
        this(ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("kafka-fetched-data-cache-evictor"), (Clock)new SystemClock(), sparkConf);
    }

    public static class CachedFetchedData
    implements Product,
    scala.Serializable {
        private final FetchedData fetchedData;
        private long lastReleasedTimestamp;
        private long lastAcquiredTimestamp;
        private boolean inUse;

        public FetchedData fetchedData() {
            return this.fetchedData;
        }

        public long lastReleasedTimestamp() {
            return this.lastReleasedTimestamp;
        }

        public void lastReleasedTimestamp_$eq(long x$1) {
            this.lastReleasedTimestamp = x$1;
        }

        public long lastAcquiredTimestamp() {
            return this.lastAcquiredTimestamp;
        }

        public void lastAcquiredTimestamp_$eq(long x$1) {
            this.lastAcquiredTimestamp = x$1;
        }

        public boolean inUse() {
            return this.inUse;
        }

        public void inUse_$eq(boolean x$1) {
            this.inUse = x$1;
        }

        public FetchedData getObject() {
            return this.fetchedData();
        }

        public CachedFetchedData copy(FetchedData fetchedData) {
            return new CachedFetchedData(fetchedData);
        }

        public FetchedData copy$default$1() {
            return this.fetchedData();
        }

        public String productPrefix() {
            return "CachedFetchedData";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.fetchedData();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CachedFetchedData;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CachedFetchedData)) return false;
            boolean bl = true;
            if (!bl) return false;
            CachedFetchedData cachedFetchedData = (CachedFetchedData)x$1;
            FetchedData fetchedData = this.fetchedData();
            FetchedData fetchedData2 = cachedFetchedData.fetchedData();
            if (fetchedData == null) {
                if (fetchedData2 != null) {
                    return false;
                }
            } else if (!((Object)fetchedData).equals(fetchedData2)) return false;
            if (!cachedFetchedData.canEqual(this)) return false;
            return true;
        }

        public CachedFetchedData(FetchedData fetchedData) {
            this.fetchedData = fetchedData;
            Product.$init$((Product)this);
            this.lastReleasedTimestamp = Long.MAX_VALUE;
            this.lastAcquiredTimestamp = Long.MIN_VALUE;
            this.inUse = false;
        }
    }
}

