/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaConfigUpdater;
import org.apache.spark.kafka010.KafkaTokenClusterConf;
import org.apache.spark.kafka010.KafkaTokenUtil$;
import org.apache.spark.sql.kafka010.KafkaDataConsumer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!\u0002\u000b\u0016\u0001Uy\u0002\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\t\u0011}\u0002!\u0011!Q\u0001\n]B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t!\u0011\u0005\t+\u0002\u0011\t\u0011)A\u0005\u0005\")a\u000b\u0001C\u0001/\"9A\f\u0001b\u0001\n\u0003i\u0006B\u00020\u0001A\u0003%\u0001\n\u0003\u0005`\u0001\t\u0007I\u0011A\u000ba\u0011\u0019Q\u0007\u0001)A\u0005C\"Q1\u000e\u0001a\u0001\u0002\u0004%\t!F!\t\u00151\u0004\u0001\u0019!a\u0001\n\u0003)R\u000eC\u0005t\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\"9A\u000f\u0001b\u0001\n\u0013)\bbBA\u0004\u0001\u0001\u0006IA\u001e\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\u0015\u0001\t\u0003\n)\u0006C\u0004\u0002X\u0001!I!!\u0017\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^\t)\u0012J\u001c;fe:\fGnS1gW\u0006\u001cuN\\:v[\u0016\u0014(B\u0001\f\u0018\u0003!Y\u0017MZ6baE\u0002$B\u0001\r\u001a\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sON!\u0001\u0001\t\u0015/!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u00142kK\u000e$\bCA\u0015-\u001b\u0005Q#BA\u0016%\u0003\tIw.\u0003\u0002.U\tI1\t\\8tK\u0006\u0014G.\u001a\t\u0003_Ij\u0011\u0001\r\u0006\u0003ce\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003gA\u0012q\u0001T8hO&tw-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0004\u0001U\tq\u0007\u0005\u00029{5\t\u0011H\u0003\u0002;w\u000511m\\7n_:T!\u0001P\u000e\u0002\u000b-\fgm[1\n\u0005yJ$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005Y1.\u00194lCB\u000b'/Y7t+\u0005\u0011\u0005\u0003B\"G\u0011\u0002j\u0011\u0001\u0012\u0006\u0003\u000b\u0012\nA!\u001e;jY&\u0011q\t\u0012\u0002\u0004\u001b\u0006\u0004\bCA%S\u001d\tQ\u0005\u000b\u0005\u0002L\u001d6\tAJ\u0003\u0002Nk\u00051AH]8pizR\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u000ba\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011KT\u0001\rW\u000647.\u0019)be\u0006l7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007aS6\f\u0005\u0002Z\u00015\tQ\u0003C\u00035\u000b\u0001\u0007q\u0007C\u0003A\u000b\u0001\u0007!)A\u0004he>,\b/\u00133\u0016\u0003!\u000b\u0001b\u001a:pkBLE\rI\u0001\u000eG2,8\u000f^3s\u0007>tg-[4\u0016\u0003\u0005\u00042AY2f\u001b\u0005q\u0015B\u00013O\u0005\u0019y\u0005\u000f^5p]B\u0011a\r[\u0007\u0002O*\u0011a#G\u0005\u0003S\u001e\u0014QcS1gW\u0006$vn[3o\u00072,8\u000f^3s\u0007>tg-\u0001\bdYV\u001cH/\u001a:D_:4\u0017n\u001a\u0011\u0002/-\fgm[1QCJ\fWn],ji\"\u001cVmY;sSRL\u0018aG6bM.\f\u0007+\u0019:b[N<\u0016\u000e\u001e5TK\u000e,(/\u001b;z?\u0012*\u0017\u000f\u0006\u0002ocB\u0011!m\\\u0005\u0003a:\u0013A!\u00168ji\"9!oCA\u0001\u0002\u0004\u0011\u0015a\u0001=%c\u0005A2.\u00194lCB\u000b'/Y7t/&$\bnU3dkJLG/\u001f\u0011\u0002\u0011\r|gn];nKJ,\u0012A\u001e\t\u0005onlX0D\u0001y\u0015\t!\u0018P\u0003\u0002{w\u000591\r\\5f]R\u001c\u0018B\u0001?y\u00055Y\u0015MZ6b\u0007>t7/^7feB!!M`A\u0001\u0013\tyhJA\u0003BeJ\f\u0017\u0010E\u0002c\u0003\u0007I1!!\u0002O\u0005\u0011\u0011\u0015\u0010^3\u0002\u0013\r|gn];nKJ\u0004\u0013!\u00024fi\u000eDGCBA\u0007\u0003K\tI\u0003E\u0004c\u0003\u001f\t\u0019\"a\b\n\u0007\u0005EaJ\u0001\u0004UkBdWM\r\t\u0006\u0007\u0006U\u0011\u0011D\u0005\u0004\u0003/!%\u0001\u0002'jgR\u0004Ra^A\u000e{vL1!!\by\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u00042AYA\u0011\u0013\r\t\u0019C\u0014\u0002\u0005\u0019>tw\rC\u0004\u0002(=\u0001\r!a\b\u0002\r=4gm]3u\u0011\u001d\tYc\u0004a\u0001\u0003?\tQ\u0002]8mYRKW.Z8vi6\u001b\u0018aF4fi\u00063\u0018-\u001b7bE2,wJ\u001a4tKR\u0014\u0016M\\4f)\t\t\t\u0004\u0005\u0003\u00024\u00055c\u0002BA\u001b\u0003\u0013rA!a\u000e\u0002H9!\u0011\u0011HA#\u001d\u0011\tY$a\u0011\u000f\t\u0005u\u0012\u0011\t\b\u0004\u0017\u0006}\u0012\"\u0001\u0010\n\u0005qi\u0012B\u0001\u000e\u001c\u0013\tA\u0012$\u0003\u0002\u0017/%\u0019\u00111J\u000b\u0002#-\u000bgm[1ECR\f7i\u001c8tk6,'/\u0003\u0003\u0002P\u0005E#\u0001F!wC&d\u0017M\u00197f\u001f\u001a47/\u001a;SC:<WMC\u0002\u0002LU\tQa\u00197pg\u0016$\u0012A\\\u0001\u000fGJ,\u0017\r^3D_:\u001cX/\\3s)\u00051\u0018\u0001B:fK.$2A\\A0\u0011\u001d\t9c\u0005a\u0001\u0003?\u0001")
public class InternalKafkaConsumer
implements Closeable,
Logging {
    private final TopicPartition topicPartition;
    private final java.util.Map<String, Object> kafkaParams;
    private final String groupId;
    private final Option<KafkaTokenClusterConf> clusterConfig;
    private java.util.Map<String, Object> kafkaParamsWithSecurity;
    private final KafkaConsumer<byte[], byte[]> consumer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public java.util.Map<String, Object> kafkaParams() {
        return this.kafkaParams;
    }

    public String groupId() {
        return this.groupId;
    }

    public Option<KafkaTokenClusterConf> clusterConfig() {
        return this.clusterConfig;
    }

    public java.util.Map<String, Object> kafkaParamsWithSecurity() {
        return this.kafkaParamsWithSecurity;
    }

    public void kafkaParamsWithSecurity_$eq(java.util.Map<String, Object> x$1) {
        this.kafkaParamsWithSecurity = x$1;
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public Tuple2<List<ConsumerRecord<byte[], byte[]>>, Object> fetch(long offset, long pollTimeoutMs) {
        this.seek(offset);
        ConsumerRecords p = this.consumer().poll(pollTimeoutMs);
        List r = p.records(this.topicPartition());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Polled ").append(this.groupId()).append(" ").append(p.partitions()).append("  ").append(r.size()).toString());
        long offsetAfterPoll = this.consumer().position(this.topicPartition());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Offset changed from ").append(offset).append(" to ").append(offsetAfterPoll).append(" after polling").toString());
        Tuple2 fetchedData = new Tuple2((Object)r, (Object)BoxesRunTime.boxToLong((long)offsetAfterPoll));
        if (r.isEmpty()) {
            KafkaDataConsumer.AvailableOffsetRange range = this.getAvailableOffsetRange();
            if (offset < range.earliest() || offset >= range.latest()) {
                throw new OffsetOutOfRangeException((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)offset)}))).asJava());
            }
            if (offset == offsetAfterPoll) {
                throw new TimeoutException(new StringBuilder(48).append("Cannot fetch record for offset ").append(offset).append(" in ").append(pollTimeoutMs).append(" milliseconds").toString());
            }
        }
        return fetchedData;
    }

    public KafkaDataConsumer.AvailableOffsetRange getAvailableOffsetRange() {
        this.consumer().seekToBeginning((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()}))).asJava());
        long earliestOffset = this.consumer().position(this.topicPartition());
        this.consumer().seekToEnd((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()}))).asJava());
        long latestOffset = this.consumer().position(this.topicPartition());
        return new KafkaDataConsumer.AvailableOffsetRange(earliestOffset, latestOffset);
    }

    @Override
    public void close() {
        this.consumer().close();
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createConsumer() {
        void var1_1;
        this.kafkaParamsWithSecurity_$eq(new KafkaConfigUpdater("executor", ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.kafkaParams()).asScala()).toMap(Predef$.MODULE$.$conforms())).setAuthenticationConfigIfNeeded(this.clusterConfig()).build());
        KafkaConsumer c = new KafkaConsumer(this.kafkaParamsWithSecurity());
        ArrayList<TopicPartition> tps = new ArrayList<TopicPartition>();
        tps.add(this.topicPartition());
        c.assign(tps);
        return var1_1;
    }

    private void seek(long offset) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Seeking to ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).toString());
        this.consumer().seek(this.topicPartition(), offset);
    }

    public InternalKafkaConsumer(TopicPartition topicPartition, java.util.Map<String, Object> kafkaParams) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        Logging.$init$((Logging)this);
        this.groupId = (String)kafkaParams.get("group.id");
        this.clusterConfig = KafkaTokenUtil$.MODULE$.findMatchingTokenClusterConfig(SparkEnv$.MODULE$.get().conf(), (String)kafkaParams.get("bootstrap.servers"));
        this.consumer = this.createConsumer();
    }
}

