/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.kafka010.ConsumerStrategy;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaBatchInputPartition;
import org.apache.spark.sql.kafka010.KafkaBatchReaderFactory$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i4QAD\b\u0001\u001feA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!AA\n\u0001B\u0001B\u0003%Q\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011!)\u0006A!A!\u0002\u00131\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011i\u0003!\u0011!Q\u0001\nECQa\u0017\u0001\u0005\u0002qC\u0001\"\u001a\u0001C\u0002\u0013\u0005qB\u001a\u0005\u0007U\u0002\u0001\u000b\u0011B4\t\u000b-\u0004A\u0011\t7\t\u000bM\u0004A\u0011\t;\t\u000ba\u0004A\u0011I=\u0003\u0015-\u000bgm[1CCR\u001c\u0007N\u0003\u0002\u0011#\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u0013'\u0005\u00191/\u001d7\u000b\u0005Q)\u0012!B:qCJ\\'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001cB\u0001\u0001\u000e#UA\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0005Y\u0006twMC\u0001 \u0003\u0011Q\u0017M^1\n\u0005\u0005b\"AB(cU\u0016\u001cG\u000f\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005!!/Z1e\u0015\t9\u0013#A\u0005d_:tWm\u0019;pe&\u0011\u0011\u0006\n\u0002\u0006\u0005\u0006$8\r\u001b\t\u0003W9j\u0011\u0001\f\u0006\u0003[M\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003_1\u0012q\u0001T8hO&tw-\u0001\u0005tiJ\fG/Z4z\u0007\u0001\u0001\"a\r\u001b\u000e\u0003=I!!N\b\u0003!\r{gn];nKJ\u001cFO]1uK\u001eL\u0018!D:pkJ\u001cWm\u00149uS>t7\u000fE\u00029{}j\u0011!\u000f\u0006\u0003um\nA!\u001e;jY*\u0011A(E\u0001\tG\u0006$\u0018\r\\=ti&\u0011a(\u000f\u0002\u0013\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wK6\u000b\u0007\u000f\u0005\u0002A\u0013:\u0011\u0011i\u0012\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tF\na\u0001\u0010:p_Rt$\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+\u0015A\u0002)sK\u0012,g-\u0003\u0002K\u0017\n11\u000b\u001e:j]\u001eT!\u0001S#\u0002)M\u0004XmY5gS\u0016$7*\u00194lCB\u000b'/Y7t!\u0011\u0001ejP \n\u0005=[%aA'ba\u0006qa-Y5m\u001f:$\u0015\r^1M_N\u001c\bC\u0001*T\u001b\u0005)\u0015B\u0001+F\u0005\u001d\u0011un\u001c7fC:\fqb\u001d;beRLgnZ(gMN,Go\u001d\t\u0003g]K!\u0001W\b\u0003+-\u000bgm[1PM\u001a\u001cX\r\u001e*b]\u001e,G*[7ji\u0006iQM\u001c3j]\u001e|eMZ:fiN\fa\"\u001b8dYV$W\rS3bI\u0016\u00148/\u0001\u0004=S:LGO\u0010\u000b\t;z{\u0006-\u00192dIB\u00111\u0007\u0001\u0005\u0006a!\u0001\rA\r\u0005\u0006m!\u0001\ra\u000e\u0005\u0006\u0019\"\u0001\r!\u0014\u0005\u0006!\"\u0001\r!\u0015\u0005\u0006+\"\u0001\rA\u0016\u0005\u00063\"\u0001\rA\u0016\u0005\u00065\"\u0001\r!U\u0001\u000ea>dG\u000eV5nK>,H/T:\u0016\u0003\u001d\u0004\"A\u00155\n\u0005%,%\u0001\u0002'p]\u001e\fa\u0002]8mYRKW.Z8vi6\u001b\b%A\nqY\u0006t\u0017J\u001c9viB\u000b'\u000f^5uS>t7\u000fF\u0001n!\r\u0011f\u000e]\u0005\u0003_\u0016\u0013Q!\u0011:sCf\u0004\"aI9\n\u0005I$#AD%oaV$\b+\u0019:uSRLwN\\\u0001\u0014GJ,\u0017\r^3SK\u0006$WM\u001d$bGR|'/\u001f\u000b\u0002kB\u00111E^\u0005\u0003o\u0012\u0012a\u0003U1si&$\u0018n\u001c8SK\u0006$WM\u001d$bGR|'/_\u0001\ti>\u001cFO]5oOR\tq\b")
public class KafkaBatch
implements Batch,
Logging {
    private final ConsumerStrategy strategy;
    private final CaseInsensitiveMap<String> sourceOptions;
    private final Map<String, String> specifiedKafkaParams;
    private final boolean failOnDataLoss;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final KafkaOffsetRangeLimit endingOffsets;
    private final boolean includeHeaders;
    private final long pollTimeoutMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public InputPartition[] planInputPartitions() {
        Tuple2 tuple2;
        String uniqueGroupId = KafkaSourceProvider$.MODULE$.batchUniqueGroupId(this.sourceOptions);
        try (KafkaOffsetReader kafkaOffsetReader = new KafkaOffsetReader(this.strategy, KafkaSourceProvider$.MODULE$.kafkaParamsForDriver(this.specifiedKafkaParams), this.sourceOptions, new StringBuilder(7).append(uniqueGroupId).append("-driver").toString());){
            tuple2 = new Tuple2(kafkaOffsetReader.fetchPartitionOffsets(this.startingOffsets, true), kafkaOffsetReader.fetchPartitionOffsets(this.endingOffsets, false));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Map fromPartitionOffsets = (Map)tuple22._1();
        Map untilPartitionOffsets = (Map)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)fromPartitionOffsets, (Object)untilPartitionOffsets);
        Tuple2 tuple24 = tuple23;
        Map fromPartitionOffsets2 = (Map)tuple24._1();
        Map untilPartitionOffsets2 = (Map)tuple24._2();
        Set set = fromPartitionOffsets2.keySet();
        Set set2 = untilPartitionOffsets2.keySet();
        if (set == null ? set2 != null : !set.equals(set2)) {
            Ordering topicOrdering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)t -> t.topic(), (Ordering)Ordering.String$.MODULE$);
            String fromTopics = ((TraversableOnce)fromPartitionOffsets2.keySet().toList().sorted(topicOrdering)).mkString(",");
            String untilTopics = ((TraversableOnce)untilPartitionOffsets2.keySet().toList().sorted(topicOrdering)).mkString(",");
            throw new IllegalStateException(new StringBuilder(84).append("different topic partitions ").append("for starting offsets topics[").append(fromTopics).append("] and ").append("ending offsets topics[").append(untilTopics).append("]").toString());
        }
        KafkaOffsetRange[] offsetRanges = (KafkaOffsetRange[])((TraversableOnce)untilPartitionOffsets2.keySet().map((Function1 & Serializable & scala.Serializable)tp -> {
            long fromOffset = BoxesRunTime.unboxToLong((Object)fromPartitionOffsets2.getOrElse(tp, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(27).append(tp).append(" doesn't have a from offset").toString());
            }));
            long untilOffset = BoxesRunTime.unboxToLong((Object)untilPartitionOffsets2.apply(tp));
            return new KafkaOffsetRange((TopicPartition)tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
        }, Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(KafkaOffsetRange.class));
        java.util.Map<String, Object> executorKafkaParams = KafkaSourceProvider$.MODULE$.kafkaParamsForExecutors(this.specifiedKafkaParams, uniqueGroupId);
        return (InputPartition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])offsetRanges)).map((Function1 & Serializable & scala.Serializable)range -> new KafkaBatchInputPartition((KafkaOffsetRange)range, executorKafkaParams, this.pollTimeoutMs(), $this.failOnDataLoss, $this.includeHeaders), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KafkaBatchInputPartition.class))))).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public PartitionReaderFactory createReaderFactory() {
        return KafkaBatchReaderFactory$.MODULE$;
    }

    public String toString() {
        return new StringBuilder(35).append("KafkaBatch(strategy=").append(this.strategy).append(", start=").append(this.startingOffsets).append(", end=").append(this.endingOffsets).append(")").toString();
    }

    public KafkaBatch(ConsumerStrategy strategy, CaseInsensitiveMap<String> sourceOptions, Map<String, String> specifiedKafkaParams, boolean failOnDataLoss, KafkaOffsetRangeLimit startingOffsets, KafkaOffsetRangeLimit endingOffsets, boolean includeHeaders) {
        this.strategy = strategy;
        this.sourceOptions = sourceOptions;
        this.specifiedKafkaParams = specifiedKafkaParams;
        this.failOnDataLoss = failOnDataLoss;
        this.startingOffsets = startingOffsets;
        this.endingOffsets = endingOffsets;
        this.includeHeaders = includeHeaders;
        Logging.$init$((Logging)this);
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = startingOffsets;
        LatestOffsetRangeLimit$ latestOffsetRangeLimit$ = LatestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(kafkaOffsetRangeLimit == null ? latestOffsetRangeLimit$ != null : !kafkaOffsetRangeLimit.equals(latestOffsetRangeLimit$), (Function0 & Serializable & scala.Serializable)() -> "Starting offset not allowed to be set to latest offsets.");
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit2 = endingOffsets;
        EarliestOffsetRangeLimit$ earliestOffsetRangeLimit$ = EarliestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(kafkaOffsetRangeLimit2 == null ? earliestOffsetRangeLimit$ != null : !kafkaOffsetRangeLimit2.equals(earliestOffsetRangeLimit$), (Function0 & Serializable & scala.Serializable)() -> "Ending offset not allowed to be set to earliest offsets.");
        this.pollTimeoutMs = new StringOps(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), (Function0 & Serializable & scala.Serializable)() -> ((Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L))).toString()))).toLong();
    }
}

