/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.connector.read.streaming.ContinuousPartitionReader;
import org.apache.spark.sql.kafka010.KafkaDataConsumer;
import org.apache.spark.sql.kafka010.KafkaDataConsumer$;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter;
import org.apache.spark.sql.kafka010.KafkaSourcePartitionOffset;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001\u0002\f\u0018\u0001\tB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003F\u0011!q\u0006A!A!\u0002\u0013y\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u000b\r\u0004A\u0011\u00013\t\u000f5\u0004!\u0019!C\u0005]\"1!\u000f\u0001Q\u0001\n=Dqa\u001d\u0001C\u0002\u0013%A\u000fC\u0004\u0002\f\u0001\u0001\u000b\u0011B;\t\u0013\u00055\u0001\u00011A\u0005\n\u0005=\u0001\"CA\t\u0001\u0001\u0007I\u0011BA\n\u0011\u001d\ty\u0002\u0001Q!\n\u0015C1\"!\t\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002$!Y\u0011q\b\u0001A\u0002\u0003\u0007I\u0011BA!\u0011-\t)\u0005\u0001a\u0001\u0002\u0003\u0006K!!\n\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J!9\u00111\n\u0001\u0005B\u00055\u0003bBA(\u0001\u0011\u0005\u0013\u0011\u000b\u0005\b\u00033\u0002A\u0011IA.\u0005yY\u0015MZ6b\u0007>tG/\u001b8v_V\u001c\b+\u0019:uSRLwN\u001c*fC\u0012,'O\u0003\u0002\u00193\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u001b7\u0005\u00191/\u001d7\u000b\u0005qi\u0012!B:qCJ\\'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001G-\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\t1\fgn\u001a\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSE\u0001\u0004PE*,7\r\u001e\t\u0004YM*T\"A\u0017\u000b\u00059z\u0013!C:ue\u0016\fW.\u001b8h\u0015\t\u0001\u0014'\u0001\u0003sK\u0006$'B\u0001\u001a\u001a\u0003%\u0019wN\u001c8fGR|'/\u0003\u00025[\tI2i\u001c8uS:,x.^:QCJ$\u0018\u000e^5p]J+\u0017\rZ3s!\t1\u0014(D\u00018\u0015\tA\u0014$\u0001\u0005dCR\fG._:u\u0013\tQtGA\u0006J]R,'O\\1m%><\u0018A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000baaY8n[>t'BA!\u001e\u0003\u0015Y\u0017MZ6b\u0013\t\u0019eH\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\u0005\u0019>tw-A\u0006lC\u001a\\\u0017\rU1sC6\u001c\b\u0003B'Q%\u000ej\u0011A\u0014\u0006\u0003\u001f\u001e\nA!\u001e;jY&\u0011\u0011K\u0014\u0002\u0004\u001b\u0006\u0004\bCA*[\u001d\t!\u0006\f\u0005\u0002V\u000f6\taK\u0003\u0002XC\u00051AH]8pizJ!!W$\u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033\u001e\u000bQ\u0002]8mYRKW.Z8vi6\u001b\u0018A\u00044bS2|e\u000eR1uC2{7o\u001d\t\u0003\r\u0002L!!Y$\u0003\u000f\t{w\u000e\\3b]\u0006q\u0011N\\2mk\u0012,\u0007*Z1eKJ\u001c\u0018A\u0002\u001fj]&$h\bF\u0004fO\"L'n\u001b7\u0011\u0005\u0019\u0004Q\"A\f\t\u000bm:\u0001\u0019\u0001\u001f\t\u000b\u0011;\u0001\u0019A#\t\u000b-;\u0001\u0019\u0001'\t\u000bu;\u0001\u0019A#\t\u000by;\u0001\u0019A0\t\u000b\t<\u0001\u0019A0\u0002\u0011\r|gn];nKJ,\u0012a\u001c\t\u0003MBL!!]\f\u0003#-\u000bgm[1ECR\f7i\u001c8tk6,'/A\u0005d_:\u001cX/\\3sA\u0005\u0011RO\\:bM\u0016\u0014vn\u001e)s_*,7\r^8s+\u0005)\b\u0003\u0002$wq~L!a^$\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA=}\u001d\t1'0\u0003\u0002|/\u0005I2*\u00194lCJ+7m\u001c:e)>\u0014vn^\"p]Z,'\u000f^3s\u0013\tihP\u0001\u0004SK\u000e|'\u000f\u001a\u0006\u0003w^\u0001B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b9\u0014aC3yaJ,7o]5p]NLA!!\u0003\u0002\u0004\tIQK\\:bM\u0016\u0014vn^\u0001\u0014k:\u001c\u0018MZ3S_^\u0004&o\u001c6fGR|'\u000fI\u0001\u0010]\u0016DHoS1gW\u0006|eMZ:fiV\tQ)A\noKb$8*\u00194lC>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0005m\u0001c\u0001$\u0002\u0018%\u0019\u0011\u0011D$\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003;i\u0011\u0011!a\u0001\u000b\u0006\u0019\u0001\u0010J\u0019\u0002!9,\u0007\u0010^&bM.\fwJ\u001a4tKR\u0004\u0013!D2veJ,g\u000e\u001e*fG>\u0014H-\u0006\u0002\u0002&AA\u0011qEA\u0018\u0003g\t\u0019$\u0004\u0002\u0002*)\u0019Q.a\u000b\u000b\u0007\u00055\u0002)A\u0004dY&,g\u000e^:\n\t\u0005E\u0012\u0011\u0006\u0002\u000f\u0007>t7/^7feJ+7m\u001c:e!\u00151\u0015QGA\u001d\u0013\r\t9d\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\r\u0006m\u0012bAA\u001f\u000f\n!!)\u001f;f\u0003E\u0019WO\u001d:f]R\u0014VmY8sI~#S-\u001d\u000b\u0005\u0003+\t\u0019\u0005C\u0005\u0002\u001eA\t\t\u00111\u0001\u0002&\u0005q1-\u001e:sK:$(+Z2pe\u0012\u0004\u0013\u0001\u00028fqR$\u0012aX\u0001\u0004O\u0016$H#A@\u0002\u0013\u001d,Go\u00144gg\u0016$HCAA*!\r1\u0017QK\u0005\u0004\u0003/:\"AG&bM.\f7k\\;sG\u0016\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$\u0018!B2m_N,GCAA\u000b\u0001")
public class KafkaContinuousPartitionReader
implements ContinuousPartitionReader<InternalRow> {
    private final TopicPartition topicPartition;
    private final long pollTimeoutMs;
    private final boolean failOnDataLoss;
    private final KafkaDataConsumer consumer;
    private final Function1<ConsumerRecord<byte[], byte[]>, UnsafeRow> unsafeRowProjector;
    private long nextKafkaOffset;
    private ConsumerRecord<byte[], byte[]> currentRecord;

    private KafkaDataConsumer consumer() {
        return this.consumer;
    }

    private Function1<ConsumerRecord<byte[], byte[]>, UnsafeRow> unsafeRowProjector() {
        return this.unsafeRowProjector;
    }

    private long nextKafkaOffset() {
        return this.nextKafkaOffset;
    }

    private void nextKafkaOffset_$eq(long x$1) {
        this.nextKafkaOffset = x$1;
    }

    private ConsumerRecord<byte[], byte[]> currentRecord() {
        return this.currentRecord;
    }

    private void currentRecord_$eq(ConsumerRecord<byte[], byte[]> x$1) {
        this.currentRecord = x$1;
    }

    public boolean next() {
        ConsumerRecord<byte[], byte[]> r = null;
        while (r == null) {
            if (TaskContext$.MODULE$.get().isInterrupted() || TaskContext$.MODULE$.get().isCompleted()) {
                return false;
            }
            try {
                r = this.consumer().get(this.nextKafkaOffset(), Long.MAX_VALUE, this.pollTimeoutMs, this.failOnDataLoss);
            }
            catch (Throwable throwable) {
                IllegalStateException illegalStateException;
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof java.util.concurrent.TimeoutException ? true : throwable2 instanceof TimeoutException;
                if (bl) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (throwable2 instanceof IllegalStateException && (illegalStateException = (IllegalStateException)throwable2).getCause() instanceof OffsetOutOfRangeException) {
                    KafkaDataConsumer.AvailableOffsetRange range = this.consumer().getAvailableOffsetRange();
                    if (range.latest() < this.nextKafkaOffset() || range.earliest() > this.nextKafkaOffset()) {
                        throw illegalStateException;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
        this.nextKafkaOffset_$eq(r.offset() + 1L);
        this.currentRecord_$eq(r);
        return true;
    }

    public UnsafeRow get() {
        return (UnsafeRow)this.unsafeRowProjector().apply(this.currentRecord());
    }

    public KafkaSourcePartitionOffset getOffset() {
        return new KafkaSourcePartitionOffset(this.topicPartition, this.nextKafkaOffset());
    }

    public void close() {
        this.consumer().release();
    }

    public KafkaContinuousPartitionReader(TopicPartition topicPartition, long startOffset, Map<String, Object> kafkaParams, long pollTimeoutMs, boolean failOnDataLoss, boolean includeHeaders) {
        this.topicPartition = topicPartition;
        this.pollTimeoutMs = pollTimeoutMs;
        this.failOnDataLoss = failOnDataLoss;
        this.consumer = KafkaDataConsumer$.MODULE$.acquire(topicPartition, kafkaParams);
        this.unsafeRowProjector = new KafkaRecordToRowConverter().toUnsafeRowProjector(includeHeaders);
        this.nextKafkaOffset = startOffset;
    }
}

