/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaTokenUtil$;
import org.apache.spark.sql.kafka010.FetchedData;
import org.apache.spark.sql.kafka010.FetchedDataPool;
import org.apache.spark.sql.kafka010.FetchedRecord;
import org.apache.spark.sql.kafka010.InternalKafkaConsumer;
import org.apache.spark.sql.kafka010.InternalKafkaConsumerPool;
import org.apache.spark.sql.kafka010.KafkaDataConsumer$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\ruf!\u00021b\u0001\u0005\\\u0007\u0002\u0003=\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u0015\u0005\u0015\u0001A!A!\u0002\u0013\t9\u0001\u0003\u0006\u0002:\u0001\u0011\t\u0011)A\u0005\u0003wA!\"a\u0011\u0001\u0005\u0003\u0005\u000b\u0011BA#\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bB!\"!\u0017\u0001\u0001\u0004%\t!YA.\u0011)\tI\u0007\u0001a\u0001\n\u0003\t\u00171\u000e\u0005\t\u0003o\u0002\u0001\u0015)\u0003\u0002^!I\u0011\u0011\u0011\u0001A\u0002\u0013%\u00111\u0011\u0005\n\u0003\u001b\u0003\u0001\u0019!C\u0005\u0003\u001fC\u0001\"a%\u0001A\u0003&\u0011Q\u0011\u0005\n\u0003/\u0003!\u0019!C\u0005\u00033C\u0001\"a'\u0001A\u0003%\u0011q\u0003\u0005\n\u0003;\u0003!\u0019!C\u0005\u0003?C\u0001ba\u0001\u0001A\u0003%\u0011\u0011\u0015\u0005\n\u0007\u000b\u0001!\u0019!C\u0005\u0007\u000fA\u0001ba\u0004\u0001A\u0003%1\u0011\u0002\u0005\b\u0007#\u0001A\u0011AB\n\u0011\u001d\u0019y\u0004\u0001C\u0001\u0007\u0003Bqa!\u0012\u0001\t\u0003\u00199\u0005C\u0004\u0004J\u0001!Iaa\u0012\t\u000f\r-\u0003\u0001\"\u0003\u0004H!91Q\n\u0001\u0005\n\r=\u0003bBB,\u0001\u0011%1\u0011\f\u0005\b\u0007S\u0002A\u0011BB6\u0011!\u0019)\b\u0001C\u0001C\u000e]\u0004bBB=\u0001\u0011%1q\t\u0005\b\u0007w\u0002A\u0011BB?\u0011\u001d\u0019\t\t\u0001C\u0005\u0007\u0007Cqaa#\u0001\t\u0013\u0019i\tC\u0005\u0004\u001c\u0002\t\n\u0011\"\u0003\u0003\u0000\"91Q\u0014\u0001\u0005\n\r}u\u0001CASC\"\u0005\u0011-a*\u0007\u000f\u0001\f\u0007\u0012A1\u0002*\"9\u00111\n\u0012\u0005\u0002\u0005-\u0006\"CAWE\t\u0007I\u0011AAX\u0011!\t9L\tQ\u0001\n\u0005EfABA]E\u0001\u000bY\f\u0003\u0006\u0002J\u001a\u0012)\u001a!C\u0001\u0003_C!\"a3'\u0005#\u0005\u000b\u0011BAY\u0011)\tiM\nBK\u0002\u0013\u0005\u0011q\u0016\u0005\u000b\u0003\u001f4#\u0011#Q\u0001\n\u0005E\u0006bBA&M\u0011\u0005\u0011\u0011\u001b\u0005\n\u000374\u0013\u0011!C\u0001\u0003;D\u0011\"a9'#\u0003%\t!!:\t\u0013\u0005mh%%A\u0005\u0002\u0005\u0015\b\"CA\u007fM\u0005\u0005I\u0011IA\u0000\u0011%\u0011)AJA\u0001\n\u0003\u00119\u0001C\u0005\u0003\u0010\u0019\n\t\u0011\"\u0001\u0003\u0012!I!1\u0004\u0014\u0002\u0002\u0013\u0005#Q\u0004\u0005\n\u0005W1\u0013\u0011!C\u0001\u0005[A\u0011Ba\u000e'\u0003\u0003%\tE!\u000f\t\u0013\tmb%!A\u0005B\tu\u0002\"\u0003B M\u0005\u0005I\u0011\tB!\u000f%\u0011)EIA\u0001\u0012\u0003\u00119EB\u0005\u0002:\n\n\t\u0011#\u0001\u0003J!9\u00111\n\u001d\u0005\u0002\t]\u0003\"\u0003B\u001eq\u0005\u0005IQ\tB\u001f\u0011%\u0011I\u0006OA\u0001\n\u0003\u0013Y\u0006C\u0005\u0003ba\n\t\u0011\"!\u0003d!I!\u0011\u000f\u001d\u0002\u0002\u0013%!1\u000f\u0004\u0007\u0005k\u0012\u0003Ia\u001e\t\u0015\u0005]eH!f\u0001\n\u0003\tI\n\u0003\u0006\u0002\u001cz\u0012\t\u0012)A\u0005\u0003/A\u0011\u0002\u001f \u0003\u0016\u0004%\tA!\u001f\t\u0013\tmdH!E!\u0002\u0013Q\bbBA&}\u0011\u0005!Q\u0010\u0005\b\u0003\u0017rD\u0011\u0001BC\u0011%\tYNPA\u0001\n\u0003\u0011Y\tC\u0005\u0002dz\n\n\u0011\"\u0001\u0003\u0012\"I\u00111  \u0012\u0002\u0013\u0005!Q\u0013\u0005\n\u0003{t\u0014\u0011!C!\u0003\u007fD\u0011B!\u0002?\u0003\u0003%\tAa\u0002\t\u0013\t=a(!A\u0005\u0002\te\u0005\"\u0003B\u000e}\u0005\u0005I\u0011\tB\u000f\u0011%\u0011YCPA\u0001\n\u0003\u0011i\nC\u0005\u00038y\n\t\u0011\"\u0011\u0003:!I!1\b \u0002\u0002\u0013\u0005#Q\b\u0005\n\u0005\u007fq\u0014\u0011!C!\u0005C;\u0011B!*#\u0003\u0003E\tAa*\u0007\u0013\tU$%!A\t\u0002\t%\u0006bBA&#\u0012\u0005!Q\u0016\u0005\n\u0005w\t\u0016\u0011!C#\u0005{A\u0011B!\u0017R\u0003\u0003%\tIa,\t\u0013\t\u0005\u0014+!A\u0005\u0002\nU\u0006\"\u0003B9#\u0006\u0005I\u0011\u0002B:\u0011%\u0011iL\tb\u0001\n\u0013\u0011y\f\u0003\u0005\u0003J\n\u0002\u000b\u0011\u0002Ba\u0011%\tID\tb\u0001\n\u0013\u0011Y\r\u0003\u0005\u0003N\n\u0002\u000b\u0011BA\u001e\u0011%\t\u0019E\tb\u0001\n\u0013\u0011y\r\u0003\u0005\u0003R\n\u0002\u000b\u0011BA#\u0011\u001d\u0011\u0019N\tC\u0001\u0005+DqAa7#\t\u0013\u0011i\u000eC\u0005\u0003~\n\n\n\u0011\"\u0003\u0003\u0000\n\t2*\u00194lC\u0012\u000bG/Y\"p]N,X.\u001a:\u000b\u0005\t\u001c\u0017\u0001C6bM.\f\u0007'\r\u0019\u000b\u0005\u0011,\u0017aA:rY*\u0011amZ\u0001\u0006gB\f'o\u001b\u0006\u0003Q&\fa!\u00199bG\",'\"\u00016\u0002\u0007=\u0014xmE\u0002\u0001YJ\u0004\"!\u001c9\u000e\u00039T\u0011a\\\u0001\u0006g\u000e\fG.Y\u0005\u0003c:\u0014a!\u00118z%\u00164\u0007CA:w\u001b\u0005!(BA;f\u0003!Ig\u000e^3s]\u0006d\u0017BA<u\u0005\u001daunZ4j]\u001e\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u0001\u0001\u0011\u0007m\f\t!D\u0001}\u0015\tih0\u0001\u0004d_6lwN\u001c\u0006\u0003\u007f\u001e\fQa[1gW\u0006L1!a\u0001}\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1b[1gW\u0006\u0004\u0016M]1ngBA\u0011\u0011BA\n\u0003/\ti#\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0011\u0001\u00026bm\u0006LA!!\u0006\u0002\f\t\u0019Q*\u00199\u0011\t\u0005e\u0011q\u0005\b\u0005\u00037\t\u0019\u0003E\u0002\u0002\u001e9l!!a\b\u000b\u0007\u0005\u0005\u00120\u0001\u0004=e>|GOP\u0005\u0004\u0003Kq\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002*\u0005-\"AB*ue&twMC\u0002\u0002&9\u0004B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\ty!\u0001\u0003mC:<\u0017\u0002BA\u001c\u0003c\u0011aa\u00142kK\u000e$\u0018\u0001D2p]N,X.\u001a:Q_>d\u0007\u0003BA\u001f\u0003\u007fi\u0011!Y\u0005\u0004\u0003\u0003\n'!G%oi\u0016\u0014h.\u00197LC\u001a\\\u0017mQ8ogVlWM\u001d)p_2\fqBZ3uG\",G\rR1uCB{w\u000e\u001c\t\u0005\u0003{\t9%C\u0002\u0002J\u0005\u0014qBR3uG\",G\rR1uCB{w\u000e\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005=\u0013\u0011KA*\u0003+\n9\u0006E\u0002\u0002>\u0001AQ\u0001_\u0003A\u0002iDq!!\u0002\u0006\u0001\u0004\t9\u0001C\u0004\u0002:\u0015\u0001\r!a\u000f\t\u000f\u0005\rS\u00011\u0001\u0002F\u0005IqlY8ogVlWM]\u000b\u0003\u0003;\u0002R!\\A0\u0003GJ1!!\u0019o\u0005\u0019y\u0005\u000f^5p]B!\u0011QHA3\u0013\r\t9'\u0019\u0002\u0016\u0013:$XM\u001d8bY.\u000bgm[1D_:\u001cX/\\3s\u00035y6m\u001c8tk6,'o\u0018\u0013fcR!\u0011QNA:!\ri\u0017qN\u0005\u0004\u0003cr'\u0001B+oSRD\u0011\"!\u001e\b\u0003\u0003\u0005\r!!\u0018\u0002\u0007a$\u0013'\u0001\u0006`G>t7/^7fe\u0002B3\u0001CA>!\ri\u0017QP\u0005\u0004\u0003\u007fr'\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0019}3W\r^2iK\u0012$\u0015\r^1\u0016\u0005\u0005\u0015\u0005#B7\u0002`\u0005\u001d\u0005\u0003BA\u001f\u0003\u0013K1!a#b\u0005-1U\r^2iK\u0012$\u0015\r^1\u0002!}3W\r^2iK\u0012$\u0015\r^1`I\u0015\fH\u0003BA7\u0003#C\u0011\"!\u001e\u000b\u0003\u0003\u0005\r!!\"\u0002\u001b}3W\r^2iK\u0012$\u0015\r^1!Q\rY\u00111P\u0001\bOJ|W\u000f]%e+\t\t9\"\u0001\u0005he>,\b/\u00133!\u0003!\u0019\u0017m\u00195f\u0017\u0016LXCAAQ!\r\t\u0019K\u0010\b\u0004\u0003{\t\u0013!E&bM.\fG)\u0019;b\u0007>t7/^7feB\u0019\u0011Q\b\u0012\u0014\u0007\tb'\u000f\u0006\u0002\u0002(\u0006qQKT&O\u001f^sul\u0014$G'\u0016#VCAAY!\ri\u00171W\u0005\u0004\u0003ks'\u0001\u0002'p]\u001e\fq\"\u0016(L\u001d>;fjX(G\rN+E\u000b\t\u0002\u0015\u0003Z\f\u0017\u000e\\1cY\u0016|eMZ:fiJ\u000bgnZ3\u0014\r\u0019b\u0017QXAb!\ri\u0017qX\u0005\u0004\u0003\u0003t'a\u0002)s_\u0012,8\r\u001e\t\u0004[\u0006\u0015\u0017bAAd]\na1+\u001a:jC2L'0\u00192mK\u0006AQ-\u0019:mS\u0016\u001cH/A\u0005fCJd\u0017.Z:uA\u00051A.\u0019;fgR\fq\u0001\\1uKN$\b\u0005\u0006\u0004\u0002T\u0006]\u0017\u0011\u001c\t\u0004\u0003+4S\"\u0001\u0012\t\u000f\u0005%7\u00061\u0001\u00022\"9\u0011QZ\u0016A\u0002\u0005E\u0016\u0001B2paf$b!a5\u0002`\u0006\u0005\b\"CAeYA\u0005\t\u0019AAY\u0011%\ti\r\fI\u0001\u0002\u0004\t\t,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d(\u0006BAY\u0003S\\#!a;\u0011\t\u00055\u0018q_\u0007\u0003\u0003_TA!!=\u0002t\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003kt\u0017AC1o]>$\u0018\r^5p]&!\u0011\u0011`Ax\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!\u0011\u0001\t\u0005\u0003_\u0011\u0019!\u0003\u0003\u0002*\u0005E\u0012\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0005!\ri'1B\u0005\u0004\u0005\u001bq'aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\n\u00053\u00012!\u001cB\u000b\u0013\r\u00119B\u001c\u0002\u0004\u0003:L\b\"CA;c\u0005\u0005\t\u0019\u0001B\u0005\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0010!\u0019\u0011\tCa\n\u0003\u00145\u0011!1\u0005\u0006\u0004\u0005Kq\u0017AC2pY2,7\r^5p]&!!\u0011\u0006B\u0012\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t=\"Q\u0007\t\u0004[\nE\u0012b\u0001B\u001a]\n9!i\\8mK\u0006t\u0007\"CA;g\u0005\u0005\t\u0019\u0001B\n\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u0005\u0003!!xn\u0015;sS:<GC\u0001B\u0001\u0003\u0019)\u0017/^1mgR!!q\u0006B\"\u0011%\t)HNA\u0001\u0002\u0004\u0011\u0019\"\u0001\u000bBm\u0006LG.\u00192mK>3gm]3u%\u0006tw-\u001a\t\u0004\u0003+D4#\u0002\u001d\u0003L\u0005\r\u0007C\u0003B'\u0005'\n\t,!-\u0002T6\u0011!q\n\u0006\u0004\u0005#r\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005+\u0012yEA\tBEN$(/Y2u\rVt7\r^5p]J\"\"Aa\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005M'Q\fB0\u0011\u001d\tIm\u000fa\u0001\u0003cCq!!4<\u0001\u0004\t\t,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0015$Q\u000e\t\u0006[\u0006}#q\r\t\b[\n%\u0014\u0011WAY\u0013\r\u0011YG\u001c\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\t=D(!AA\u0002\u0005M\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tiC\u0001\u0005DC\u000eDWmS3z'\u0019qD.!0\u0002DV\t!0A\bu_BL7\rU1si&$\u0018n\u001c8!)\u0019\u0011yH!!\u0003\u0004B\u0019\u0011Q\u001b \t\u000f\u0005]5\t1\u0001\u0002\u0018!)\u0001p\u0011a\u0001uR1!q\u0010BD\u0005\u0013CQ\u0001\u001f#A\u0002iDq!!\u0002E\u0001\u0004\t9\u0001\u0006\u0004\u0003\u0000\t5%q\u0012\u0005\n\u0003/+\u0005\u0013!a\u0001\u0003/Aq\u0001_#\u0011\u0002\u0003\u0007!0\u0006\u0002\u0003\u0014*\"\u0011qCAu+\t\u00119JK\u0002{\u0003S$BAa\u0005\u0003\u001c\"I\u0011Q\u000f&\u0002\u0002\u0003\u0007!\u0011\u0002\u000b\u0005\u0005_\u0011y\nC\u0005\u0002v1\u000b\t\u00111\u0001\u0003\u0014Q!!q\u0006BR\u0011%\t)hTA\u0001\u0002\u0004\u0011\u0019\"\u0001\u0005DC\u000eDWmS3z!\r\t).U\n\u0006#\n-\u00161\u0019\t\n\u0005\u001b\u0012\u0019&a\u0006{\u0005\u007f\"\"Aa*\u0015\r\t}$\u0011\u0017BZ\u0011\u001d\t9\n\u0016a\u0001\u0003/AQ\u0001\u001f+A\u0002i$BAa.\u0003<B)Q.a\u0018\u0003:B1QN!\u001b\u0002\u0018iD\u0011Ba\u001cV\u0003\u0003\u0005\rAa \u0002\u0013M\u0004\u0018M]6D_:4WC\u0001Ba!\u0011\u0011\u0019M!2\u000e\u0003\u0015L1Aa2f\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0006ta\u0006\u00148nQ8oM\u0002*\"!a\u000f\u0002\u001b\r|gn];nKJ\u0004vn\u001c7!+\t\t)%\u0001\tgKR\u001c\u0007.\u001a3ECR\f\u0007k\\8mA\u00059\u0011mY9vSJ,GCBA(\u0005/\u0014I\u000eC\u0003y;\u0002\u0007!\u0010C\u0004\u0002\u0006u\u0003\r!a\u0002\u0002\u001fI,\u0007o\u001c:u\t\u0006$\u0018\rT8tgB\"\u0002\"!\u001c\u0003`\n\r(q\u001d\u0005\b\u0005Ct\u0006\u0019\u0001B\u0018\u000391\u0017-\u001b7P]\u0012\u000bG/\u0019'pgNDqA!:_\u0001\u0004\t9\"\u0001\u0007gS:\fG.T3tg\u0006<W\rC\u0005\u0003jz\u0003\n\u00111\u0001\u0003l\u0006)1-Y;tKB!!Q\u001eB|\u001d\u0011\u0011yOa=\u000f\t\u0005u!\u0011_\u0005\u0002_&\u0019!Q\u001f8\u0002\u000fA\f7m[1hK&!!\u0011 B~\u0005%!\u0006N]8xC\ndWMC\u0002\u0003v:\f\u0011D]3q_J$H)\u0019;b\u0019>\u001c8\u000f\r\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\u0001\u0016\u0005\u0005W\fI/A\u0005dC\u000eDWmS3zA\u0005ia-\u001a;dQ\u0016$'+Z2pe\u0012,\"a!\u0003\u0011\t\u0005u21B\u0005\u0004\u0007\u001b\t'!\u0004$fi\u000eDW\r\u001a*fG>\u0014H-\u0001\bgKR\u001c\u0007.\u001a3SK\u000e|'\u000f\u001a\u0011\u0002\u0007\u001d,G\u000f\u0006\u0006\u0004\u0016\rE2QGB\u001d\u0007{\u0001\u0002ba\u0006\u0004\"\r\u00152QE\u0007\u0003\u00073QAaa\u0007\u0004\u001e\u0005A1m\u001c8tk6,'OC\u0002\u0004 y\fqa\u00197jK:$8/\u0003\u0003\u0004$\re!AD\"p]N,X.\u001a:SK\u000e|'\u000f\u001a\t\u0006[\u000e\u001d21F\u0005\u0004\u0007Sq'!B!se\u0006L\bcA7\u0004.%\u00191q\u00068\u0003\t\tKH/\u001a\u0005\b\u0007g\u0011\u0002\u0019AAY\u0003\u0019ygMZ:fi\"91q\u0007\nA\u0002\u0005E\u0016aC;oi&dwJ\u001a4tKRDqaa\u000f\u0013\u0001\u0004\t\t,A\u0007q_2dG+[7f_V$Xj\u001d\u0005\b\u0005C\u0014\u0002\u0019\u0001B\u0018\u0003]9W\r^!wC&d\u0017M\u00197f\u001f\u001a47/\u001a;SC:<W\r\u0006\u0002\u0004DA\u0019\u00111\u0015\u0014\u0002\u000fI,G.Z1tKR\u0011\u0011QN\u0001\u0010e\u0016dW-Y:f\u0007>t7/^7fe\u0006\u0011\"/\u001a7fCN,g)\u001a;dQ\u0016$G)\u0019;b\u0003\u0005:W\r^#be2LWm\u001d;Bm\u0006LG.\u00192mK>3gm]3u\u0005\u0016$x/Z3o)!\t\tl!\u0015\u0004T\rU\u0003bBB\u000e/\u0001\u0007\u00111\r\u0005\b\u0007g9\u0002\u0019AAY\u0011\u001d\u00199d\u0006a\u0001\u0003c\u000b1BZ3uG\"\u0014VmY8sIRq1\u0011BB.\u0007;\u001a\tga\u0019\u0004f\r\u001d\u0004bBB\u000e1\u0001\u0007\u00111\r\u0005\b\u0007?B\u0002\u0019AAD\u0003-1W\r^2iK\u0012$\u0015\r^1\t\u000f\rM\u0002\u00041\u0001\u00022\"91q\u0007\rA\u0002\u0005E\u0006bBB\u001e1\u0001\u0007\u0011\u0011\u0017\u0005\b\u0005CD\u0002\u0019\u0001B\u0018\u0003%1W\r^2i\t\u0006$\u0018\r\u0006\u0006\u0002n\r54qNB9\u0007gBqaa\u0007\u001a\u0001\u0004\t\u0019\u0007C\u0004\u0004`e\u0001\r!a\"\t\u000f\rM\u0012\u00041\u0001\u00022\"911H\rA\u0002\u0005E\u0016!F4fi>\u0013(+\u001a;sS\u00164XmQ8ogVlWM\u001d\u000b\u0003\u0003G\n\u0001C]3ue&,g/Z\"p]N,X.\u001a:\u00021\u001d,Go\u0014:SKR\u0014\u0018.\u001a<f\r\u0016$8\r[3e\t\u0006$\u0018\r\u0006\u0003\u0002\b\u000e}\u0004bBB\u001a9\u0001\u0007\u0011\u0011W\u0001\u0012C\u0012$\u0017\u000e^5p]\u0006dW*Z:tC\u001e,G\u0003CA\f\u0007\u000b\u001b9i!#\t\u000bal\u0002\u0019\u0001>\t\u000f\u0005]U\u00041\u0001\u0002\u0018!9!\u0011]\u000fA\u0002\t=\u0012A\u0004:fa>\u0014H\u000fR1uC2{7o\u001d\u000b\r\u0003[\u001ayi!%\u0004\u0014\u000eU5\u0011\u0014\u0005\u0006qz\u0001\rA\u001f\u0005\b\u0003/s\u0002\u0019AA\f\u0011\u001d\u0011\tO\ba\u0001\u0005_Aqaa&\u001f\u0001\u0004\t9\"A\u0004nKN\u001c\u0018mZ3\t\u0013\t%h\u0004%AA\u0002\t-\u0018\u0001\u0007:fa>\u0014H\u000fR1uC2{7o\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005a\"/\u001e8V]&tG/\u001a:skB$\u0018N\u00197z\u0013\u001a\u0004vn]:jE2,W\u0003BBQ\u0007O#Baa)\u00044B!1QUBT\u0019\u0001!qa!+!\u0005\u0004\u0019YKA\u0001U#\u0011\u0019iKa\u0005\u0011\u00075\u001cy+C\u0002\u00042:\u0014qAT8uQ&tw\r\u0003\u0005\u00046\u0002\"\t\u0019AB\\\u0003\u0011\u0011w\u000eZ=\u0011\u000b5\u001cIla)\n\u0007\rmfN\u0001\u0005=Eft\u0017-\\3?\u0001")
public class KafkaDataConsumer
implements Logging {
    private final TopicPartition topicPartition;
    private final Map<String, Object> kafkaParams;
    private final InternalKafkaConsumerPool consumerPool;
    private final FetchedDataPool fetchedDataPool;
    private volatile Option<InternalKafkaConsumer> _consumer;
    private volatile Option<FetchedData> _fetchedData;
    private final String groupId;
    private final CacheKey cacheKey;
    private final FetchedRecord fetchedRecord;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KafkaDataConsumer acquire(TopicPartition topicPartition, Map<String, Object> map) {
        return KafkaDataConsumer$.MODULE$.acquire(topicPartition, map);
    }

    public static long UNKNOWN_OFFSET() {
        return KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<InternalKafkaConsumer> _consumer() {
        return this._consumer;
    }

    public void _consumer_$eq(Option<InternalKafkaConsumer> x$1) {
        this._consumer = x$1;
    }

    private Option<FetchedData> _fetchedData() {
        return this._fetchedData;
    }

    private void _fetchedData_$eq(Option<FetchedData> x$1) {
        this._fetchedData = x$1;
    }

    private String groupId() {
        return this.groupId;
    }

    private CacheKey cacheKey() {
        return this.cacheKey;
    }

    private FetchedRecord fetchedRecord() {
        return this.fetchedRecord;
    }

    public ConsumerRecord<byte[], byte[]> get(long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        return (ConsumerRecord)this.runUninterruptiblyIfPossible((Function0 & Serializable & scala.Serializable)() -> {
            ConsumerRecord<byte[], byte[]> consumerRecord;
            Predef$.MODULE$.require(offset < untilOffset, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("offset must always be less than untilOffset [offset: ").append(offset).append(", untilOffset: ").append(untilOffset).append("]").toString());
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            FetchedData fetchedData = this.getOrRetrieveFetchedData(offset);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Get ").append(this.groupId()).append(" ").append($this.topicPartition).append(" nextOffset ").append(fetchedData.nextOffsetInFetchedData()).append(" ").append("requested $offset").toString());
            LongRef toFetchOffset = LongRef.create((long)offset);
            FetchedRecord fetchedRecord = null;
            boolean isFetchComplete = false;
            while (toFetchOffset.elem != KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET() && !isFetchComplete) {
                try {
                    fetchedRecord = this.fetchRecord(consumer, fetchedData, toFetchOffset.elem, untilOffset, pollTimeoutMs, failOnDataLoss);
                    if (fetchedRecord.record() != null) {
                        isFetchComplete = true;
                        continue;
                    }
                    toFetchOffset.elem = fetchedRecord.nextOffsetToFetch();
                    if (toFetchOffset.elem >= untilOffset) {
                        fetchedData.reset();
                        toFetchOffset.elem = KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
                        continue;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Skipped offsets [").append(offset).append(", ").append(toFetchOffset$1.elem).append("]").toString());
                }
                catch (OffsetOutOfRangeException e) {
                    this.releaseConsumer();
                    fetchedData.reset();
                    this.reportDataLoss($this.topicPartition, this.groupId(), failOnDataLoss, new StringBuilder(20).append("Cannot fetch offset ").append(toFetchOffset.elem).toString(), e);
                    toFetchOffset.elem = this.getEarliestAvailableOffsetBetween(consumer, toFetchOffset.elem, untilOffset);
                }
            }
            if (isFetchComplete) {
                consumerRecord = fetchedRecord.record();
            } else {
                fetchedData.reset();
                consumerRecord = null;
            }
            return consumerRecord;
        });
    }

    public AvailableOffsetRange getAvailableOffsetRange() {
        return (AvailableOffsetRange)this.runUninterruptiblyIfPossible((Function0 & Serializable & scala.Serializable)() -> {
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            return consumer.getAvailableOffsetRange();
        });
    }

    public void release() {
        this.releaseConsumer();
        this.releaseFetchedData();
    }

    private void releaseConsumer() {
        block0: {
            if (!this._consumer().isDefined()) break block0;
            this.consumerPool.returnObject((InternalKafkaConsumer)this._consumer().get());
            this._consumer_$eq((Option<InternalKafkaConsumer>)None$.MODULE$);
        }
    }

    private void releaseFetchedData() {
        block0: {
            if (!this._fetchedData().isDefined()) break block0;
            this.fetchedDataPool.release(this.cacheKey(), (FetchedData)this._fetchedData().get());
            this._fetchedData_$eq((Option<FetchedData>)None$.MODULE$);
        }
    }

    private long getEarliestAvailableOffsetBetween(InternalKafkaConsumer consumer, long offset, long untilOffset) {
        long l;
        AvailableOffsetRange range = consumer.getAvailableOffsetRange();
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Some data may be lost. Recovering from the earliest offset: ").append(range.earliest()).toString());
        TopicPartition topicPartition = consumer.topicPartition();
        String groupId = consumer.groupId();
        if (offset >= range.latest() || range.earliest() >= untilOffset) {
            String warningMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(untilOffset).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString())).stripMargin();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
            l = KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
        } else if (offset >= range.earliest()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Found a disappeared offset ").append(offset).append(". Some data may be lost ").append(this.additionalMessage(topicPartition, groupId, false)).toString());
            l = offset;
        } else {
            String warningMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(range.earliest()).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString())).stripMargin();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
            l = range.earliest();
        }
        return l;
    }

    private FetchedRecord fetchRecord(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        FetchedRecord fetchedRecord;
        if (offset != fetchedData.nextOffsetInFetchedData()) {
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        } else if (!fetchedData.hasNext()) {
            if (offset < fetchedData.offsetAfterPoll()) {
                long nextOffsetToFetch = fetchedData.offsetAfterPoll();
                fetchedData.reset();
                return this.fetchedRecord().withRecord(null, nextOffsetToFetch);
            }
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        }
        if (!fetchedData.hasNext()) {
            Predef$.MODULE$.assert(offset <= fetchedData.offsetAfterPoll(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("seek to ").append(offset).append(" and poll but the offset was reset to ").append(fetchedData.offsetAfterPoll()).toString());
            fetchedRecord = this.fetchedRecord().withRecord(null, fetchedData.offsetAfterPoll());
        } else {
            ConsumerRecord<byte[], byte[]> record = fetchedData.next();
            if (record.offset() > offset) {
                AvailableOffsetRange range = consumer.getAvailableOffsetRange();
                if (range.earliest() <= offset) {
                    fetchedData.previous();
                    return this.fetchedRecord().withRecord(null, record.offset());
                }
                if (failOnDataLoss) {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), true, new StringBuilder(28).append("Cannot fetch records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
                    throw new IllegalStateException("reportDataLoss didn't throw an exception when 'failOnDataLoss' is true");
                }
                if (record.offset() >= untilOffset) {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(untilOffset).append(")").toString(), this.reportDataLoss$default$5());
                    fetchedRecord = this.fetchedRecord().withRecord(null, untilOffset);
                } else {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
                    fetchedRecord = this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
                }
            } else {
                if (record.offset() < offset) {
                    throw new IllegalStateException(new StringBuilder(51).append("Tried to fetch ").append(offset).append(" but the returned record offset was ").append(record.offset()).toString());
                }
                fetchedRecord = this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
            }
        }
        return fetchedRecord;
    }

    private void fetchData(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long pollTimeoutMs) {
        Tuple2<List<ConsumerRecord<byte[], byte[]>>, Object> tuple2 = consumer.fetch(offset, pollTimeoutMs);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List records = (List)tuple2._1();
        long offsetAfterPoll = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)records, (Object)BoxesRunTime.boxToLong((long)offsetAfterPoll));
        Tuple2 tuple23 = tuple22;
        List records2 = (List)tuple23._1();
        long offsetAfterPoll2 = tuple23._2$mcJ$sp();
        fetchedData.withNewPoll(records2.listIterator(), offsetAfterPoll2);
    }

    public InternalKafkaConsumer getOrRetrieveConsumer() {
        block1: {
            if (!this._consumer().isDefined()) {
                this.retrieveConsumer();
            }
            Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Consumer must be defined");
            if (KafkaTokenUtil$.MODULE$.isConnectorUsingCurrentToken(((InternalKafkaConsumer)this._consumer().get()).kafkaParamsWithSecurity(), ((InternalKafkaConsumer)this._consumer().get()).clusterConfig())) break block1;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cached consumer uses an old delegation token, invalidating.");
            this.releaseConsumer();
            this.consumerPool.invalidateKey(this.cacheKey());
            this.fetchedDataPool.invalidate(this.cacheKey());
            this.retrieveConsumer();
        }
        return (InternalKafkaConsumer)this._consumer().get();
    }

    private void retrieveConsumer() {
        this._consumer_$eq((Option<InternalKafkaConsumer>)Option$.MODULE$.apply((Object)this.consumerPool.borrowObject(this.cacheKey(), this.kafkaParams)));
        Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "borrowing consumer from pool must always succeed.");
    }

    private FetchedData getOrRetrieveFetchedData(long offset) {
        FetchedData fetchedData;
        Option<FetchedData> option = this._fetchedData();
        if (None$.MODULE$.equals(option)) {
            this._fetchedData_$eq((Option<FetchedData>)Option$.MODULE$.apply((Object)this.fetchedDataPool.acquire(this.cacheKey(), offset)));
            Predef$.MODULE$.require(this._fetchedData().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "acquiring fetched data from cache must always succeed.");
            fetchedData = (FetchedData)this._fetchedData().get();
        } else if (option instanceof Some) {
            FetchedData fetchedData2;
            Some some = (Some)option;
            fetchedData = fetchedData2 = (FetchedData)some.value();
        } else {
            throw new MatchError(option);
        }
        return fetchedData;
    }

    private String additionalMessage(TopicPartition topicPartition, String groupId, boolean failOnDataLoss) {
        return failOnDataLoss ? new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString() : new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString();
    }

    private void reportDataLoss(TopicPartition topicPartition, String groupId, boolean failOnDataLoss, String message, Throwable cause) {
        String finalMessage = new StringBuilder(1).append(message).append(" ").append(this.additionalMessage(topicPartition, groupId, failOnDataLoss)).toString();
        KafkaDataConsumer$.MODULE$.org$apache$spark$sql$kafka010$KafkaDataConsumer$$reportDataLoss0(failOnDataLoss, finalMessage, cause);
    }

    private Throwable reportDataLoss$default$5() {
        return null;
    }

    private <T> T runUninterruptiblyIfPossible(Function0<T> body) {
        Object object;
        Thread thread = Thread.currentThread();
        if (thread instanceof UninterruptibleThread) {
            UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
            object = uninterruptibleThread.runUninterruptibly(body);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "KafkaDataConsumer is not running in UninterruptibleThread. It may hang when KafkaDataConsumer's methods are interrupted because of KAFKA-1894");
            object = body.apply();
        }
        return (T)object;
    }

    public KafkaDataConsumer(TopicPartition topicPartition, Map<String, Object> kafkaParams, InternalKafkaConsumerPool consumerPool, FetchedDataPool fetchedDataPool) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        this.consumerPool = consumerPool;
        this.fetchedDataPool = fetchedDataPool;
        Logging.$init$((Logging)this);
        this._consumer = None$.MODULE$;
        this._fetchedData = None$.MODULE$;
        this.groupId = (String)kafkaParams.get("group.id");
        this.cacheKey = new CacheKey(this.groupId(), topicPartition);
        this.fetchedRecord = new FetchedRecord(null, KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET());
    }

    public static class AvailableOffsetRange
    implements Product,
    scala.Serializable {
        private final long earliest;
        private final long latest;

        public long earliest() {
            return this.earliest;
        }

        public long latest() {
            return this.latest;
        }

        public AvailableOffsetRange copy(long earliest, long latest) {
            return new AvailableOffsetRange(earliest, latest);
        }

        public long copy$default$1() {
            return this.earliest();
        }

        public long copy$default$2() {
            return this.latest();
        }

        public String productPrefix() {
            return "AvailableOffsetRange";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Long l;
            int n = x$1;
            switch (n) {
                case 0: {
                    l = BoxesRunTime.boxToLong((long)this.earliest());
                    break;
                }
                case 1: {
                    l = BoxesRunTime.boxToLong((long)this.latest());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return l;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AvailableOffsetRange;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.earliest()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.latest()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AvailableOffsetRange)) return false;
            boolean bl = true;
            if (!bl) return false;
            AvailableOffsetRange availableOffsetRange = (AvailableOffsetRange)x$1;
            if (this.earliest() != availableOffsetRange.earliest()) return false;
            if (this.latest() != availableOffsetRange.latest()) return false;
            if (!availableOffsetRange.canEqual(this)) return false;
            return true;
        }

        public AvailableOffsetRange(long earliest, long latest) {
            this.earliest = earliest;
            this.latest = latest;
            Product.$init$((Product)this);
        }
    }

    public static class CacheKey
    implements Product,
    scala.Serializable {
        private final String groupId;
        private final TopicPartition topicPartition;

        public String groupId() {
            return this.groupId;
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }

        public CacheKey copy(String groupId, TopicPartition topicPartition) {
            return new CacheKey(groupId, topicPartition);
        }

        public String copy$default$1() {
            return this.groupId();
        }

        public TopicPartition copy$default$2() {
            return this.topicPartition();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = this.groupId();
                    break;
                }
                case 1: {
                    string = this.topicPartition();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return string;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            String string = this.groupId();
            String string2 = cacheKey.groupId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            TopicPartition topicPartition = this.topicPartition();
            TopicPartition topicPartition2 = cacheKey.topicPartition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            if (!cacheKey.canEqual(this)) return false;
            return true;
        }

        public CacheKey(String groupId, TopicPartition topicPartition) {
            this.groupId = groupId;
            this.topicPartition = topicPartition;
            Product.$init$((Product)this);
        }

        public CacheKey(TopicPartition topicPartition, Map<String, Object> kafkaParams) {
            this((String)kafkaParams.get("group.id"), topicPartition);
        }
    }
}

