/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.execution.streaming.sources.RateControlMicroBatchStream;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.JsonUtils$;
import org.apache.spark.sql.kafka010.KafkaBatchInputPartition;
import org.apache.spark.sql.kafka010.KafkaBatchReaderFactory$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005uf!\u0002\u0011\"\u0001\u0005Z\u0003\"\u0003#\u0001\u0005\u000b\u0007I\u0011A\u0011F\u0011!Y\u0005A!A!\u0002\u00131\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\"A1\u000e\u0001B\u0001B\u0003%A\u000eC\u0003q\u0001\u0011\u0005\u0011\u000f\u0003\u0005z\u0001\t\u0007I\u0011A\u0011{\u0011\u0019q\b\u0001)A\u0005w\"Iq\u0010\u0001b\u0001\n\u0003\t\u0013\u0011\u0001\u0005\t\u0003\u0013\u0001\u0001\u0015!\u0003\u0002\u0004!I\u00111\u0002\u0001C\u0002\u0013%\u0011Q\u0002\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003m\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u000b\u0011-\ti\u0002\u0001a\u0001\u0002\u0004%I!a\b\t\u0017\u0005\u001d\u0002\u00011AA\u0002\u0013%\u0011\u0011\u0006\u0005\f\u0003k\u0001\u0001\u0019!A!B\u0013\t\t\u0003C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!9\u0011Q\u000b\u0001\u0005B\u0005]\u0003bBA7\u0001\u0011\u0005\u0013q\u000e\u0005\b\u0003o\u0002A\u0011IA=\u0011\u001d\ty\b\u0001C!\u0003\u0003Cq!!\"\u0001\t\u0003\n9\tC\u0004\u0002\n\u0002!\t%a#\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBAX\u0001\u0011%\u0011\u0011\u0017\u0005\b\u0003k\u0003A\u0011BA\\\u0005UY\u0015MZ6b\u001b&\u001c'o\u001c\"bi\u000eD7\u000b\u001e:fC6T!AI\u0012\u0002\u0011-\fgm[11cAR!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h'\u0011\u0001A\u0006\u000e \u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001\u00027b]\u001eT\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024]\t1qJ\u00196fGR\u0004\"!\u000e\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u000fM|WO]2fg*\u0011\u0011HO\u0001\ngR\u0014X-Y7j]\u001eT!aO\u0012\u0002\u0013\u0015DXmY;uS>t\u0017BA\u001f7\u0005m\u0011\u0016\r^3D_:$(o\u001c7NS\u000e\u0014xNQ1uG\"\u001cFO]3b[B\u0011qHQ\u0007\u0002\u0001*\u0011\u0011)J\u0001\tS:$XM\u001d8bY&\u00111\t\u0011\u0002\b\u0019><w-\u001b8h\u0003EY\u0017MZ6b\u001f\u001a47/\u001a;SK\u0006$WM]\u000b\u0002\rB\u0011q\tS\u0007\u0002C%\u0011\u0011*\t\u0002\u0012\u0017\u000647.Y(gMN,GOU3bI\u0016\u00148\u0001A\u0001\u0013W\u000647.Y(gMN,GOU3bI\u0016\u0014\b%A\nfq\u0016\u001cW\u000f^8s\u0017\u000647.\u0019)be\u0006l7\u000f\u0005\u0003O#NcS\"A(\u000b\u0005A\u0003\u0014\u0001B;uS2L!AU(\u0003\u00075\u000b\u0007\u000f\u0005\u0002U;:\u0011Qk\u0017\t\u0003-fk\u0011a\u0016\u0006\u00031*\u000ba\u0001\u0010:p_Rt$\"\u0001.\u0002\u000bM\u001c\u0017\r\\1\n\u0005qK\u0016A\u0002)sK\u0012,g-\u0003\u0002_?\n11\u000b\u001e:j]\u001eT!\u0001X-\u0002\u000f=\u0004H/[8ogB\u0011!\rZ\u0007\u0002G*\u0011\u0001kI\u0005\u0003K\u000e\u0014\u0001dQ1tK&s7/\u001a8tSRLg/Z*ue&tw-T1q\u00031iW\r^1eCR\f\u0007+\u0019;i\u0003=\u0019H/\u0019:uS:<wJ\u001a4tKR\u001c\bCA$j\u0013\tQ\u0017EA\u000bLC\u001a\\\u0017m\u00144gg\u0016$(+\u00198hK2KW.\u001b;\u0002\u001d\u0019\f\u0017\u000e\\(o\t\u0006$\u0018\rT8tgB\u0011QN\\\u0007\u00023&\u0011q.\u0017\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q9!o\u001d;vm^D\bCA$\u0001\u0011\u0015!\u0005\u00021\u0001G\u0011\u0015a\u0005\u00021\u0001N\u0011\u0015\u0001\u0007\u00021\u0001b\u0011\u00151\u0007\u00021\u0001T\u0011\u00159\u0007\u00021\u0001i\u0011\u0015Y\u0007\u00021\u0001m\u00035\u0001x\u000e\u001c7US6,w.\u001e;NgV\t1\u0010\u0005\u0002ny&\u0011Q0\u0017\u0002\u0005\u0019>tw-\u0001\bq_2dG+[7f_V$Xj\u001d\u0011\u0002)5\f\u0007p\u00144gg\u0016$8\u000fU3s)JLwmZ3s+\t\t\u0019\u0001\u0005\u0003n\u0003\u000bY\u0018bAA\u00043\n1q\n\u001d;j_:\fQ#\\1y\u001f\u001a47/\u001a;t!\u0016\u0014HK]5hO\u0016\u0014\b%\u0001\bj]\u000edW\u000fZ3IK\u0006$WM]:\u0016\u00031\fq\"\u001b8dYV$W\rS3bI\u0016\u00148\u000fI\u0001\u0010e\u0006tw-Z\"bY\u000e,H.\u0019;peV\u0011\u0011Q\u0003\t\u0004\u000f\u0006]\u0011bAA\rC\tQ2*\u00194lC>3gm]3u%\u0006tw-Z\"bY\u000e,H.\u0019;pe\u0006\u0001\"/\u00198hK\u000e\u000bGnY;mCR|'\u000fI\u0001\u0014K:$\u0007+\u0019:uSRLwN\\(gMN,Go]\u000b\u0003\u0003C\u00012aRA\u0012\u0013\r\t)#\t\u0002\u0012\u0017\u000647.Y*pkJ\u001cWm\u00144gg\u0016$\u0018aF3oIB\u000b'\u000f^5uS>twJ\u001a4tKR\u001cx\fJ3r)\u0011\tY#!\r\u0011\u00075\fi#C\u0002\u00020e\u0013A!\u00168ji\"I\u00111\u0007\n\u0002\u0002\u0003\u0007\u0011\u0011E\u0001\u0004q\u0012\n\u0014\u0001F3oIB\u000b'\u000f^5uS>twJ\u001a4tKR\u001c\b%A\u0007j]&$\u0018.\u00197PM\u001a\u001cX\r\u001e\u000b\u0003\u0003w\u0001B!!\u0010\u0002J5\u0011\u0011q\b\u0006\u0004s\u0005\u0005#\u0002BA\"\u0003\u000b\nAA]3bI*\u0019\u0011qI\u0012\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002BA&\u0003\u007f\u0011aa\u00144gg\u0016$\u0018\u0001\u00047bi\u0016\u001cHo\u00144gg\u0016$H\u0003BA\u001e\u0003#Bq!a\u0015\u0016\u0001\u0004\tY$A\u0003ti\u0006\u0014H/A\nqY\u0006t\u0017J\u001c9viB\u000b'\u000f^5uS>t7\u000f\u0006\u0004\u0002Z\u0005\u001d\u0014\u0011\u000e\t\u0006[\u0006m\u0013qL\u0005\u0004\u0003;J&!B!se\u0006L\b\u0003BA1\u0003Gj!!!\u0011\n\t\u0005\u0015\u0014\u0011\t\u0002\u000f\u0013:\u0004X\u000f\u001e)beRLG/[8o\u0011\u001d\t\u0019F\u0006a\u0001\u0003wAq!a\u001b\u0017\u0001\u0004\tY$A\u0002f]\u0012\f1c\u0019:fCR,'+Z1eKJ4\u0015m\u0019;pef$\"!!\u001d\u0011\t\u0005\u0005\u00141O\u0005\u0005\u0003k\n\tE\u0001\fQCJ$\u0018\u000e^5p]J+\u0017\rZ3s\r\u0006\u001cGo\u001c:z\u0003E!Wm]3sS\u0006d\u0017N_3PM\u001a\u001cX\r\u001e\u000b\u0005\u0003w\tY\b\u0003\u0004\u0002~a\u0001\raU\u0001\u0005UN|g.\u0001\u0004d_6l\u0017\u000e\u001e\u000b\u0005\u0003W\t\u0019\tC\u0004\u0002le\u0001\r!a\u000f\u0002\tM$x\u000e\u001d\u000b\u0003\u0003W\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002'\u0006\u0011s-\u001a;Pe\u000e\u0013X-\u0019;f\u0013:LG/[1m!\u0006\u0014H/\u001b;j_:|eMZ:fiN$\"!!%\u0011\t\u0005M\u0015\u0011\u0014\b\u0004\u000f\u0006U\u0015bAALC\u00059\u0001/Y2lC\u001e,\u0017\u0002BAN\u0003;\u0013!\u0003U1si&$\u0018n\u001c8PM\u001a\u001cX\r^'ba*\u0019\u0011qS\u0011\u0002\u0013I\fG/\u001a'j[&$H\u0003CAI\u0003G\u000b9+a+\t\r\u0005\u0015V\u00041\u0001|\u0003\u0015a\u0017.\\5u\u0011\u001d\tI+\ba\u0001\u0003#\u000bAA\u001a:p[\"9\u0011QV\u000fA\u0002\u0005E\u0015!B;oi&d\u0017!F4fiN{'\u000f^3e\u000bb,7-\u001e;pe2K7\u000f\u001e\u000b\u0003\u0003g\u0003B!\\A.'\u0006q!/\u001a9peR$\u0015\r^1M_N\u001cH\u0003BA\u0016\u0003sCa!a/ \u0001\u0004\u0019\u0016aB7fgN\fw-\u001a")
public class KafkaMicroBatchStream
implements RateControlMicroBatchStream,
Logging {
    private final KafkaOffsetReader kafkaOffsetReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final boolean includeHeaders;
    private final KafkaOffsetRangeCalculator rangeCalculator;
    private KafkaSourceOffset endPartitionOffsets;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Offset latestOffset() {
        return RateControlMicroBatchStream.latestOffset$((RateControlMicroBatchStream)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public KafkaOffsetReader kafkaOffsetReader() {
        return this.kafkaOffsetReader;
    }

    public long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private KafkaOffsetRangeCalculator rangeCalculator() {
        return this.rangeCalculator;
    }

    private KafkaSourceOffset endPartitionOffsets() {
        return this.endPartitionOffsets;
    }

    private void endPartitionOffsets_$eq(KafkaSourceOffset x$1) {
        this.endPartitionOffsets = x$1;
    }

    public Offset initialOffset() {
        return new KafkaSourceOffset(this.getOrCreateInitialPartitionOffsets());
    }

    public Offset latestOffset(Offset start) {
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets = this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(startPartitionOffsets));
        this.endPartitionOffsets_$eq(new KafkaSourceOffset((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)this.maxOffsetsPerTrigger().map((Function1 & Serializable & scala.Serializable)maxOffsets -> this.rateLimit(BoxesRunTime.unboxToLong((Object)maxOffsets), (scala.collection.immutable.Map<TopicPartition, Object>)startPartitionOffsets, (scala.collection.immutable.Map<TopicPartition, Object>)latestPartitionOffsets)).getOrElse((Function0 & Serializable & scala.Serializable)() -> latestPartitionOffsets))));
        return this.endPartitionOffsets();
    }

    public InputPartition[] planInputPartitions(Offset start, Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        scala.collection.immutable.Map<TopicPartition, Object> endPartitionOffsets = ((KafkaSourceOffset)end).partitionToOffsets();
        Set newPartitions = (Set)endPartitionOffsets.keySet().diff((GenSet)startPartitionOffsets.keySet());
        scala.collection.immutable.Map<TopicPartition, Object> newPartitionInitialOffsets = this.kafkaOffsetReader().fetchEarliestOffsets((Seq<TopicPartition>)newPartitions.toSeq());
        Set set = newPartitionInitialOffsets.keySet();
        Set set2 = newPartitions;
        if (set == null ? set2 != null : !set.equals(set2)) {
            Set deletedPartitions = (Set)newPartitions.diff((GenSet)newPartitionInitialOffsets.keySet());
            this.reportDataLoss(new StringBuilder(64).append("Cannot find earliest offsets of ").append(deletedPartitions).append(". Some data may have been missed").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Partitions added: ").append(newPartitionInitialOffsets).toString());
        ((IterableLike)newPartitionInitialOffsets.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$planInputPartitions$2(x$2)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaMicroBatchStream.$anonfun$planInputPartitions$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        Set deletedPartitions = (Set)startPartitionOffsets.keySet().diff((GenSet)endPartitionOffsets.keySet());
        if (deletedPartitions.nonEmpty()) {
            String message = this.kafkaOffsetReader().driverKafkaParams().containsKey("group.id") ? new StringBuilder(11).append(deletedPartitions).append(" are gone. ").append(KafkaSourceProvider$.MODULE$.CUSTOM_GROUP_ID_ERROR_MESSAGE()).toString() : new StringBuilder(42).append(deletedPartitions).append(" are gone. Some data may have been missed.").toString();
            this.reportDataLoss(message);
        }
        Seq topicPartitions = ((SetLike)endPartitionOffsets.keySet().filter((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$planInputPartitions$4(newPartitionInitialOffsets, startPartitionOffsets, tp)))).toSeq();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("TopicPartitions: ").append(topicPartitions.mkString(", ")).toString());
        scala.collection.immutable.Map fromOffsets = startPartitionOffsets.$plus$plus(newPartitionInitialOffsets);
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = endPartitionOffsets;
        untilOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            KafkaMicroBatchStream.$anonfun$planInputPartitions$6(this, fromOffsets, x0$2);
            return BoxedUnit.UNIT;
        });
        Seq<KafkaOffsetRange> offsetRanges = this.rangeCalculator().getRanges((scala.collection.immutable.Map<TopicPartition, Object>)fromOffsets, untilOffsets, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.getSortedExecutorList()));
        return (InputPartition[])((TraversableOnce)offsetRanges.map((Function1 & Serializable & scala.Serializable)range -> new KafkaBatchInputPartition((KafkaOffsetRange)range, $this.executorKafkaParams, this.pollTimeoutMs(), $this.failOnDataLoss, this.includeHeaders()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public PartitionReaderFactory createReaderFactory() {
        return KafkaBatchReaderFactory$.MODULE$;
    }

    public Offset deserializeOffset(String json) {
        return new KafkaSourceOffset(JsonUtils$.MODULE$.partitionOffsets(json));
    }

    public void commit(Offset end) {
    }

    public void stop() {
        this.kafkaOffsetReader().close();
    }

    public String toString() {
        return new StringBuilder(9).append("KafkaV2[").append(this.kafkaOffsetReader()).append("]").toString();
    }

    private scala.collection.immutable.Map<TopicPartition, Object> getOrCreateInitialPartitionOffsets() {
        Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
        Predef$.MODULE$.assert(SparkSession$.MODULE$.getActiveSession().nonEmpty());
        KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter((SparkSession)SparkSession$.MODULE$.getActiveSession().get(), this.metadataPath);
        return ((KafkaSourceOffset)((Object)metadataLog.get(0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var3_8;
            KafkaSourceOffset kafkaSourceOffset;
            KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
            if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchEarliestOffsets());
            } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
            } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
                    this.reportDataLoss(message);
                    return BoxedUnit.UNIT;
                });
            } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificTimestampBasedOffsets(p, true);
            } else {
                throw new MatchError((Object)kafkaOffsetRangeLimit);
            }
            KafkaSourceOffset offsets = kafkaSourceOffset;
            metadataLog.add(0L, (Object)offsets);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append((Object)offsets).toString());
            return var3_8;
        }))).partitionToOffsets();
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        scala.collection.immutable.Map<TopicPartition, Object> fromNew = this.kafkaOffsetReader().fetchEarliestOffsets((Seq<TopicPartition>)until.keySet().diff((GenSet)from.keySet()).toSeq());
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Iterable iterable = Option$.MODULE$.option2Iterable(from.get((Object)tp).orElse((Function0 & Serializable & scala.Serializable)() -> fromNew.get((Object)tp)).flatMap((Function1 & Serializable & scala.Serializable)begin -> KafkaMicroBatchStream.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin))));
            return iterable;
        }, Map$.MODULE$.canBuildFrom());
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return total < 1.0 ? until : (scala.collection.immutable.Map)until.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)size -> {
                long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)fromNew.apply((Object)tp))));
                double prorate = (double)limit * ((double)size / total);
                long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                return Math.min(end, off);
            }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> end));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    private String[] getSortedExecutorList() {
        BlockManager bm = SparkEnv$.MODULE$.get().blockManager();
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bm.master().getPeers(bm.blockManagerId()).toArray(ClassTag$.MODULE$.apply(BlockManagerId.class)))).map((Function1 & Serializable & scala.Serializable)x -> new ExecutorCacheTaskLocation(x.host(), x.executorId()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExecutorCacheTaskLocation.class))))).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.compare$1(a, b))))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString());
    }

    public static final /* synthetic */ long $anonfun$maxOffsetsPerTrigger$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$planInputPartitions$2(Tuple2 x$2) {
        return x$2._2$mcJ$sp() != 0L;
    }

    public static final /* synthetic */ void $anonfun$planInputPartitions$3(KafkaMicroBatchStream $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition p = (TopicPartition)tuple2._1();
        long o = tuple2._2$mcJ$sp();
        $this.reportDataLoss(new StringBuilder(74).append("Added partition ").append(p).append(" starts from ").append(o).append(" instead of 0. Some data may have been missed").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$planInputPartitions$4(scala.collection.immutable.Map newPartitionInitialOffsets$1, scala.collection.immutable.Map startPartitionOffsets$2, TopicPartition tp) {
        return newPartitionInitialOffsets$1.contains((Object)tp) || startPartitionOffsets$2.contains((Object)tp);
    }

    public static final /* synthetic */ void $anonfun$planInputPartitions$6(KafkaMicroBatchStream $this, scala.collection.immutable.Map fromOffsets$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        long untilOffset = tuple2._2$mcJ$sp();
        fromOffsets$1.get((Object)tp).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)fromOffset -> {
            block0: {
                if (untilOffset >= fromOffset) break block0;
                $this.reportDataLoss(new StringBuilder(73).append("Partition ").append(tp).append("'s offset was changed from ").append(fromOffset).append(" to ").append(untilOffset).append(", some data may have been missed").toString());
            }
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaMicroBatchStream $this, long end$1, TopicPartition tp$2, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("rateLimit ").append(tp$2).append(" size is ").append(size).toString());
        return size > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$2), (Object)BoxesRunTime.boxToLong((long)size))) : None$.MODULE$;
    }

    private static final boolean compare$1(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
        String string = a.host();
        String string2 = b.host();
        return !(string != null ? !string.equals(string2) : string2 != null) ? new StringOps(Predef$.MODULE$.augmentString(a.executorId())).$greater((Object)b.executorId()) : new StringOps(Predef$.MODULE$.augmentString(a.host())).$greater((Object)b.host());
    }

    public KafkaMicroBatchStream(KafkaOffsetReader kafkaOffsetReader, Map<String, Object> executorKafkaParams, CaseInsensitiveStringMap options, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.kafkaOffsetReader = kafkaOffsetReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        RateControlMicroBatchStream.$init$((RateControlMicroBatchStream)this);
        Logging.$init$((Logging)this);
        this.pollTimeoutMs = options.getLong(KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L);
        this.maxOffsetsPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)KafkaMicroBatchStream.$anonfun$maxOffsetsPerTrigger$1(x$1)));
        this.includeHeaders = options.getBoolean(KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), false);
        this.rangeCalculator = KafkaOffsetRangeCalculator$.MODULE$.apply(options);
    }
}

