/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.kafka010.ConsumerStrategy;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\ted!\u0002\u0016,\u0001-*\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011!\u0003!Q1A\u0005\u0002%C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"AA\u000e\u0001B\u0001B\u0003%!\u000bC\u0003n\u0001\u0011\u0005a\u000eC\u0004u\u0001\t\u0007I\u0011A;\t\rq\u0004\u0001\u0015!\u0003w\u0011\u001di\bA1A\u0005\u0002yDq!!\u0003\u0001A\u0003%q\u0010C\u0005\u0002\f\u0001\u0001\r\u0011\"\u0003\u0002\u000e!I\u0011q\u0002\u0001A\u0002\u0013%\u0011\u0011\u0003\u0005\b\u0003;\u0001\u0001\u0015)\u0003S\u0011%\ty\u0002\u0001a\u0001\n\u0013\t\t\u0003C\u0005\u0002*\u0001\u0001\r\u0011\"\u0003\u0002,!A\u0011q\u0006\u0001!B\u0013\t\u0019\u0003C\u0005\u00022\u0001\u0001\r\u0011\"\u0005\u00024!I\u0011Q\u000b\u0001A\u0002\u0013E\u0011q\u000b\u0005\t\u00037\u0002\u0001\u0015)\u0003\u00026!9\u00111\b\u0001\u0005\u0012\u0005M\u0002BCA3\u0001\t\u0007I\u0011A\u0016\u0002\"!A\u0011q\r\u0001!\u0002\u0013\t\u0019\u0003\u0003\u0006\u0002j\u0001\u0011\r\u0011\"\u0001,\u0003WB\u0001\"a\u001d\u0001A\u0003%\u0011Q\u000e\u0005\b\u0003k\u0002A\u0011BA<\u0011\u001d\tI\b\u0001C!\u0003oBq!a\u001f\u0001\t\u0003\ti\bC\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0006bBAe\u0001\u0011\u0005\u00111\u001a\u0005\b\u0003+\u0004A\u0011BAl\u0011\u001d\ty\u000f\u0001C\u0001\u0003cDq!a=\u0001\t\u0003\t)\u0010C\u0004\u0002p\u0002!\tAa\u0004\t\u000f\t\u0015\u0002\u0001\"\u0003\u0003(!I!\u0011\u0007\u0001\u0012\u0002\u0013%!1\u0007\u0005\b\u0005\u0013\u0002A\u0011\u0002B&\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005_BqA!\u001e\u0001\t\u0013\ti\bC\u0004\u0003x\u0001!I!! \u0003#-\u000bgm[1PM\u001a\u001cX\r\u001e*fC\u0012,'O\u0003\u0002-[\u0005A1.\u00194lCB\n\u0004G\u0003\u0002/_\u0005\u00191/\u001d7\u000b\u0005A\n\u0014!B:qCJ\\'B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001e\u001c2\u0001\u0001\u001c=!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0019\te.\u001f*fMB\u0011Q\bQ\u0007\u0002})\u0011qhL\u0001\tS:$XM\u001d8bY&\u0011\u0011I\u0010\u0002\b\u0019><w-\u001b8h\u0003A\u0019wN\\:v[\u0016\u00148\u000b\u001e:bi\u0016<\u0017p\u0001\u0001\u0011\u0005\u00153U\"A\u0016\n\u0005\u001d[#\u0001E\"p]N,X.\u001a:TiJ\fG/Z4z\u0003E!'/\u001b<fe.\u000bgm[1QCJ\fWn]\u000b\u0002\u0015B!1\n\u0015*^\u001b\u0005a%BA'O\u0003\u0011)H/\u001b7\u000b\u0003=\u000bAA[1wC&\u0011\u0011\u000b\u0014\u0002\u0004\u001b\u0006\u0004\bCA*[\u001d\t!\u0006\f\u0005\u0002Vq5\taK\u0003\u0002X\u0007\u00061AH]8pizJ!!\u0017\u001d\u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033b\u0002\"AX1\u000e\u0003}S!\u0001\u0019(\u0002\t1\fgnZ\u0005\u0003E~\u0013aa\u00142kK\u000e$\u0018A\u00053sSZ,'oS1gW\u0006\u0004\u0016M]1ng\u0002\nQB]3bI\u0016\u0014x\n\u001d;j_:\u001c\bc\u00014k%6\tqM\u0003\u0002NQ*\u0011\u0011.L\u0001\tG\u0006$\u0018\r\\=ti&\u00111n\u001a\u0002\u0013\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wK6\u000b\u0007/A\nee&4XM]$s_V\u0004\u0018\n\u001a)sK\u001aL\u00070\u0001\u0004=S:LGO\u0010\u000b\u0006_B\f(o\u001d\t\u0003\u000b\u0002AQA\u0011\u0004A\u0002\u0011CQ\u0001\u0013\u0004A\u0002)CQ\u0001\u001a\u0004A\u0002\u0015DQ\u0001\u001c\u0004A\u0002I\u000b\u0011c[1gW\u0006\u0014V-\u00193feRC'/Z1e+\u00051\bCA<{\u001b\u0005A(BA=M\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003wb\u0014q\"\u0012=fGV$xN]*feZL7-Z\u0001\u0013W\u000647.\u0019*fC\u0012,'\u000f\u00165sK\u0006$\u0007%A\u0006fq\u0016\u001c7i\u001c8uKb$X#A@\u0011\t\u0005\u0005\u0011QA\u0007\u0003\u0003\u0007Q!!\u001f\u001d\n\t\u0005\u001d\u00111\u0001\u0002 \u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017\u0001D3yK\u000e\u001cuN\u001c;fqR\u0004\u0013aB4s_V\u0004\u0018\nZ\u000b\u0002%\u0006YqM]8va&#w\fJ3r)\u0011\t\u0019\"!\u0007\u0011\u0007]\n)\"C\u0002\u0002\u0018a\u0012A!\u00168ji\"A\u00111\u0004\u0007\u0002\u0002\u0003\u0007!+A\u0002yIE\n\u0001b\u001a:pkBLE\rI\u0001\u0007]\u0016DH/\u00133\u0016\u0005\u0005\r\u0002cA\u001c\u0002&%\u0019\u0011q\u0005\u001d\u0003\u0007%sG/\u0001\u0006oKb$\u0018\nZ0%KF$B!a\u0005\u0002.!I\u00111D\b\u0002\u0002\u0003\u0007\u00111E\u0001\b]\u0016DH/\u00133!\u0003%y6m\u001c8tk6,'/\u0006\u0002\u00026AA\u0011qGA#\u0003\u0013\nI%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003!\u0019wN\\:v[\u0016\u0014(\u0002BA \u0003\u0003\nqa\u00197jK:$8OC\u0002\u0002DE\nQa[1gW\u0006LA!a\u0012\u0002:\tA1i\u001c8tk6,'\u000fE\u00038\u0003\u0017\ny%C\u0002\u0002Na\u0012Q!\u0011:sCf\u00042aNA)\u0013\r\t\u0019\u0006\u000f\u0002\u0005\u0005f$X-A\u0007`G>t7/^7fe~#S-\u001d\u000b\u0005\u0003'\tI\u0006C\u0005\u0002\u001cI\t\t\u00111\u0001\u00026\u0005QqlY8ogVlWM\u001d\u0011)\u0007M\ty\u0006E\u00028\u0003CJ1!a\u00199\u0005!1x\u000e\\1uS2,\u0017AF7bq>3gm]3u\r\u0016$8\r[!ui\u0016l\u0007\u000f^:\u0002/5\f\u0007p\u00144gg\u0016$h)\u001a;dQ\u0006#H/Z7qiN\u0004\u0013\u0001H8gMN,GOR3uG\"\fE\u000f^3naRLe\u000e^3sm\u0006dWj]\u000b\u0003\u0003[\u00022aNA8\u0013\r\t\t\b\u000f\u0002\u0005\u0019>tw-A\u000fpM\u001a\u001cX\r\u001e$fi\u000eD\u0017\t\u001e;f[B$\u0018J\u001c;feZ\fG.T:!\u0003-qW\r\u001f;He>,\b/\u00133\u0015\u0003I\u000b\u0001\u0002^8TiJLgnZ\u0001\u0006G2|7/\u001a\u000b\u0003\u0003'\tACZ3uG\"$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cHCAAB!\u0015\u0019\u0016QQAE\u0013\r\t9\t\u0018\u0002\u0004'\u0016$\b\u0003BAF\u0003#k!!!$\u000b\t\u0005=\u0015\u0011I\u0001\u0007G>lWn\u001c8\n\t\u0005M\u0015Q\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003U1W\r^2i!\u0006\u0014H/\u001b;j_:|eMZ:fiN$b!!'\u0002\u001e\u0006\u001d\u0006cB*\u0002\u001c\u0006%\u0015QN\u0005\u0003#rCq!a(\u001e\u0001\u0004\t\t+\u0001\tpM\u001a\u001cX\r\u001e*b]\u001e,G*[7jiB\u0019Q)a)\n\u0007\u0005\u00156FA\u000bLC\u001a\\\u0017m\u00144gg\u0016$(+\u00198hK2KW.\u001b;\t\u000f\u0005%V\u00041\u0001\u0002,\u0006\t\u0012n]*uCJ$\u0018N\\4PM\u001a\u001cX\r^:\u0011\u0007]\ni+C\u0002\u00020b\u0012qAQ8pY\u0016\fg.\u0001\u000bgKR\u001c\u0007n\u00159fG&4\u0017nY(gMN,Go\u001d\u000b\u0007\u0003k\u000bY,a0\u0011\u0007\u0015\u000b9,C\u0002\u0002:.\u0012\u0011cS1gW\u0006\u001cv.\u001e:dK>3gm]3u\u0011\u001d\tiL\ba\u0001\u00033\u000b\u0001\u0003]1si&$\u0018n\u001c8PM\u001a\u001cX\r^:\t\u000f\u0005\u0005g\u00041\u0001\u0002D\u0006q!/\u001a9peR$\u0015\r^1M_N\u001c\bCB\u001c\u0002FJ\u000b\u0019\"C\u0002\u0002Hb\u0012\u0011BR;oGRLwN\\\u0019\u0002E\u0019,Go\u00195Ta\u0016\u001c\u0017NZ5d)&lWm\u001d;b[B\u0014\u0015m]3e\u001f\u001a47/\u001a;t)\u0019\t),!4\u0002R\"9\u0011qZ\u0010A\u0002\u0005e\u0015a\u00059beRLG/[8o)&lWm\u001d;b[B\u001c\bbBAj?\u0001\u0007\u00111V\u0001\u0018M\u0006LGn](o\u001d>l\u0015\r^2iS:<wJ\u001a4tKR\fQCZ3uG\"\u001c\u0006/Z2jM&\u001cwJ\u001a4tKR\u001c\b\u0007\u0006\u0005\u00026\u0006e\u00171]Au\u0011\u001d\tY\u000e\ta\u0001\u0003;\f\u0001E\u001a8BgN,'\u000f\u001e)be\u0006lW\r^3sg^KG\u000f\u001b)beRLG/[8ogB9q'!2\u0002`\u0006M\u0001#B&\u0002b\u0006%\u0015bAAD\u0019\"9\u0011Q\u001d\u0011A\u0002\u0005\u001d\u0018A\u00074o%\u0016$(/[3wKB\u000b'\u000f^5uS>twJ\u001a4tKR\u001c\bcB\u001c\u0002F\u0006}\u0017\u0011\u0014\u0005\b\u0003W\u0004\u0003\u0019AAw\u0003Y1g.Q:tKJ$h)\u001a;dQ\u0016$wJ\u001a4tKR\u001c\bcB\u001c\u0002F\u0006e\u00151C\u0001\u0015M\u0016$8\r[#be2LWm\u001d;PM\u001a\u001cX\r^:\u0015\u0005\u0005e\u0015A\u00054fi\u000eDG*\u0019;fgR|eMZ:fiN$B!a>\u0003\u0006A!\u0011\u0011`A\u0000\u001d\r)\u00151`\u0005\u0004\u0003{\\\u0013a\u00029bG.\fw-Z\u0005\u0005\u0005\u0003\u0011\u0019A\u0001\nQCJ$\u0018\u000e^5p]>3gm]3u\u001b\u0006\u0004(bAA\u007fW!9!q\u0001\u0012A\u0002\t%\u0011\u0001D6o_^twJ\u001a4tKR\u001c\b#B\u001c\u0003\f\u0005]\u0018b\u0001B\u0007q\t1q\n\u001d;j_:$B!!'\u0003\u0012!9!1C\u0012A\u0002\tU\u0011!\u00048foB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0003\u0018\t}\u0011\u0011\u0012\b\u0005\u00053\u0011iBD\u0002V\u00057I\u0011!O\u0005\u0004\u0003{D\u0014\u0002\u0002B\u0011\u0005G\u00111aU3r\u0015\r\ti\u0010O\u0001\u001da\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:,G\rV8D_:\u001cX/\\3s)\u0019\tIJ!\u000b\u0003.!9!1\u0006\u0013A\u0002\u0005\u001d\u0018\u0001\u00022pIfD\u0011Ba\f%!\u0003\u0005\r!a+\u0002-\u0019,Go\u00195j]\u001e,\u0015M\u001d7jKN$xJ\u001a4tKR\fa\u0005]1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8fIR{7i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)D\u000b\u0003\u0002,\n]2F\u0001B\u001d!\u0011\u0011YD!\u0012\u000e\u0005\tu\"\u0002\u0002B \u0005\u0003\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\r\u0003(\u0001\u0006b]:|G/\u0019;j_:LAAa\u0012\u0003>\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%I,h.\u00168j]R,'O];qi&\u0014G._\u000b\u0005\u0005\u001b\u0012\u0019\u0006\u0006\u0003\u0003P\t\u0015\u0004\u0003\u0002B)\u0005'b\u0001\u0001B\u0004\u0003V\u0019\u0012\rAa\u0016\u0003\u0003Q\u000bBA!\u0017\u0003`A\u0019qGa\u0017\n\u0007\tu\u0003HA\u0004O_RD\u0017N\\4\u0011\u0007]\u0012\t'C\u0002\u0003da\u00121!\u00118z\u0011!\u0011YC\nCA\u0002\t\u001d\u0004#B\u001c\u0003j\t=\u0013b\u0001B6q\tAAHY=oC6,g(A\u000exSRD'+\u001a;sS\u0016\u001cx+\u001b;i_V$\u0018J\u001c;feJ,\b\u000f\u001e\u000b\u0005\u00033\u0013\t\b\u0003\u0005\u0003,\u001d\"\t\u0019\u0001B:!\u00159$\u0011NAM\u00031\u0019Ho\u001c9D_:\u001cX/\\3s\u00035\u0011Xm]3u\u0007>t7/^7fe\u0002")
public class KafkaOffsetReader
implements Logging {
    private final ConsumerStrategy consumerStrategy;
    private final java.util.Map<String, Object> driverKafkaParams;
    private final String driverGroupIdPrefix;
    private final ExecutorService kafkaReaderThread;
    private final ExecutionContextExecutorService execContext;
    private String groupId;
    private int nextId;
    private volatile Consumer<byte[], byte[]> _consumer;
    private final int maxOffsetFetchAttempts;
    private final long offsetFetchAttemptIntervalMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public java.util.Map<String, Object> driverKafkaParams() {
        return this.driverKafkaParams;
    }

    public ExecutorService kafkaReaderThread() {
        return this.kafkaReaderThread;
    }

    public ExecutionContextExecutorService execContext() {
        return this.execContext;
    }

    private String groupId() {
        return this.groupId;
    }

    private void groupId_$eq(String x$1) {
        this.groupId = x$1;
    }

    private int nextId() {
        return this.nextId;
    }

    private void nextId_$eq(int x$1) {
        this.nextId = x$1;
    }

    public Consumer<byte[], byte[]> _consumer() {
        return this._consumer;
    }

    public void _consumer_$eq(Consumer<byte[], byte[]> x$1) {
        this._consumer = x$1;
    }

    public synchronized Consumer<byte[], byte[]> consumer() {
        block0: {
            Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
            if (this._consumer() != null) break block0;
            HashMap<String, Object> newKafkaParams = new HashMap<String, Object>(this.driverKafkaParams());
            Object object = this.driverKafkaParams().get("group.id") == null ? newKafkaParams.put("group.id", this.nextGroupId()) : BoxedUnit.UNIT;
            this._consumer_$eq(this.consumerStrategy.createConsumer(newKafkaParams));
        }
        return this._consumer();
    }

    public int maxOffsetFetchAttempts() {
        return this.maxOffsetFetchAttempts;
    }

    public long offsetFetchAttemptIntervalMs() {
        return this.offsetFetchAttemptIntervalMs;
    }

    private String nextGroupId() {
        this.groupId_$eq(new StringBuilder(1).append(this.driverGroupIdPrefix).append("-").append(this.nextId()).toString());
        this.nextId_$eq(this.nextId() + 1);
        return this.groupId();
    }

    public String toString() {
        return this.consumerStrategy.toString();
    }

    public void close() {
        Object object = this._consumer() != null ? this.runUninterruptibly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopConsumer()) : BoxedUnit.UNIT;
        this.kafkaReaderThread().shutdown();
    }

    public scala.collection.immutable.Set<TopicPartition> fetchTopicPartitions() {
        return (scala.collection.immutable.Set)this.runUninterruptibly((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
            this.consumer().poll(0L);
            Set partitions = this.consumer().assignment();
            this.consumer().pause((Collection)partitions);
            return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toSet();
        });
    }

    public scala.collection.immutable.Map<TopicPartition, Object> fetchPartitionOffsets(KafkaOffsetRangeLimit offsetRangeLimit, boolean isStartingOffsets) {
        scala.collection.immutable.Map<TopicPartition, Object> map;
        scala.collection.immutable.Set<TopicPartition> partitions = this.fetchTopicPartitions();
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = offsetRangeLimit;
        if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            map = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TopicPartition topicPartition = x0$1;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.EARLIEST()));
                return tuple2;
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            map = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TopicPartition topicPartition = x0$2;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST()));
                return tuple2;
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
            SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
            scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets = specificOffsetRangeLimit.partitionOffsets();
            map = this.validateTopicPartitions$1(partitions, partitionOffsets);
        } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
            SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
            scala.collection.immutable.Map<TopicPartition, Object> partitionTimestamps = specificTimestampRangeLimit.topicTimestamps();
            map = this.fetchSpecificTimestampBasedOffsets(partitionTimestamps, isStartingOffsets).partitionToOffsets();
        } else {
            throw new MatchError((Object)kafkaOffsetRangeLimit);
        }
        return map;
    }

    public KafkaSourceOffset fetchSpecificOffsets(scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets, Function1<String, BoxedUnit> reportDataLoss) {
        Function1 & Serializable & scala.Serializable fnAssertParametersWithPartitions = (Function1 & Serializable & scala.Serializable)partitions -> {
            KafkaOffsetReader.$anonfun$fetchSpecificOffsets$1(this, partitionOffsets, partitions);
            return BoxedUnit.UNIT;
        };
        Function1 & Serializable & scala.Serializable fnRetrievePartitionOffsets = (Function1 & Serializable & scala.Serializable)x$1 -> partitionOffsets;
        Function1 & Serializable & scala.Serializable fnAssertFetchedOffsets = (Function1 & Serializable & scala.Serializable)fetched -> {
            partitionOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KafkaOffsetReader.$anonfun$fetchSpecificOffsets$6(fetched, reportDataLoss$1, x0$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        return this.fetchSpecificOffsets0((Function1<Set<TopicPartition>, BoxedUnit>)fnAssertParametersWithPartitions, (Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)fnRetrievePartitionOffsets, (Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit>)fnAssertFetchedOffsets);
    }

    public KafkaSourceOffset fetchSpecificTimestampBasedOffsets(scala.collection.immutable.Map<TopicPartition, Object> partitionTimestamps, boolean failsOnNoMatchingOffset) {
        Function1 & Serializable & scala.Serializable fnAssertParametersWithPartitions = (Function1 & Serializable & scala.Serializable)partitions -> {
            KafkaOffsetReader.$anonfun$fetchSpecificTimestampBasedOffsets$1(this, partitionTimestamps, partitions);
            return BoxedUnit.UNIT;
        };
        Function1 & Serializable & scala.Serializable fnRetrievePartitionOffsets = (Function1 & Serializable & scala.Serializable)x$2 -> {
            java.util.Map converted = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionTimestamps.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long timestamp = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)timestamp);
                return tuple22;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).asJava();
            java.util.Map offsetForTime = this.consumer().offsetsForTimes(converted);
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetForTime).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                OffsetAndTimestamp offsetAndTimestamp;
                TopicPartition tp;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    tp = (TopicPartition)tuple2._1();
                    offsetAndTimestamp = (OffsetAndTimestamp)tuple2._2();
                    if (failsOnNoMatchingOffset) {
                        Predef$.MODULE$.assert(offsetAndTimestamp != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("No offset matched from request of ").append("topic-partition ").append(tp).append(" and timestamp ").append(partitionTimestamps.apply((Object)tp)).append(".").toString());
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 tuple22 = offsetAndTimestamp == null ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST())) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)offsetAndTimestamp.offset()));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        };
        Function1 & Serializable & scala.Serializable fnAssertFetchedOffsets = (Function1 & Serializable & scala.Serializable)x$3 -> {
            KafkaOffsetReader.$anonfun$fetchSpecificTimestampBasedOffsets$8(x$3);
            return BoxedUnit.UNIT;
        };
        return this.fetchSpecificOffsets0((Function1<Set<TopicPartition>, BoxedUnit>)fnAssertParametersWithPartitions, (Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)fnRetrievePartitionOffsets, (Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit>)fnAssertFetchedOffsets);
    }

    private KafkaSourceOffset fetchSpecificOffsets0(Function1<Set<TopicPartition>, BoxedUnit> fnAssertParametersWithPartitions, Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>> fnRetrievePartitionOffsets, Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit> fnAssertFetchedOffsets) {
        scala.collection.immutable.Map<TopicPartition, Object> fetched = this.partitionsAssignedToConsumer((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            fnAssertParametersWithPartitions.apply(partitions);
            scala.collection.immutable.Map partitionOffsets = (scala.collection.immutable.Map)fnRetrievePartitionOffsets.apply(partitions);
            partitionOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KafkaOffsetReader.$anonfun$fetchSpecificOffsets0$2(this, x0$1);
                return BoxedUnit.UNIT;
            });
            return (scala.collection.immutable.Map)partitionOffsets.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(tp)));
                return tuple22;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        }, this.partitionsAssignedToConsumer$default$2());
        fnAssertFetchedOffsets.apply(fetched);
        return new KafkaSourceOffset(fetched);
    }

    public scala.collection.immutable.Map<TopicPartition, Object> fetchEarliestOffsets() {
        return this.partitionsAssignedToConsumer((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            void var2_2;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to the beginning");
            this.consumer().seekToBeginning((Collection)partitions);
            scala.collection.immutable.Map partitionOffsets = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Got earliest offsets for partition : ").append(partitionOffsets).toString());
            return var2_2;
        }, true);
    }

    public scala.collection.immutable.Map<TopicPartition, Object> fetchLatestOffsets(Option<scala.collection.immutable.Map<TopicPartition, Object>> knownOffsets) {
        return this.partitionsAssignedToConsumer((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            scala.collection.immutable.Map map;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to the end.");
            if (knownOffsets.isEmpty()) {
                this.consumer().seekToEnd((Collection)partitions);
                map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            } else {
                ObjectRef partitionOffsets = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
                ObjectRef incorrectOffsets = ObjectRef.create((Object)Nil$.MODULE$);
                int attempt = 0;
                do {
                    this.consumer().seekToEnd((Collection)partitions);
                    partitionOffsets.elem = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    ++attempt;
                    incorrectOffsets.elem = KafkaOffsetReader.findIncorrectOffsets$1(partitionOffsets, knownOffsets);
                    if (!((Seq)incorrectOffsets.elem).nonEmpty()) continue;
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Found incorrect offsets in some partitions ").append("(partition, previous offset, fetched offset): ").append((Seq)incorrectOffsets$2.elem).toString());
                    if (attempt >= this.maxOffsetFetchAttempts()) continue;
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Retrying to fetch latest offsets because of incorrect offsets");
                    Thread.sleep(this.offsetFetchAttemptIntervalMs());
                } while (((Seq)incorrectOffsets.elem).nonEmpty() && attempt < this.maxOffsetFetchAttempts());
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Got latest offsets for partition : ").append((scala.collection.immutable.Map)partitionOffsets$4.elem).toString());
                map = (scala.collection.immutable.Map)partitionOffsets.elem;
            }
            return map;
        }, this.partitionsAssignedToConsumer$default$2());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> fetchEarliestOffsets(Seq<TopicPartition> newPartitions) {
        return newPartitions.isEmpty() ? Predef$.MODULE$.Map().empty() : this.partitionsAssignedToConsumer((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            void var3_3;
            this.consumer().seekToBeginning((Collection)partitions);
            scala.collection.immutable.Map partitionOffsets = ((TraversableOnce)((TraversableLike)newPartitions.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)partitions.contains(p)))).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Got earliest offsets for new partitions: ").append(partitionOffsets).toString());
            return var3_3;
        }, true);
    }

    private scala.collection.immutable.Map<TopicPartition, Object> partitionsAssignedToConsumer(Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>> body, boolean fetchingEarliestOffset) {
        return (scala.collection.immutable.Map)this.runUninterruptibly((Function0 & Serializable & scala.Serializable)() -> this.withRetriesWithoutInterrupt((Function0<scala.collection.immutable.Map<TopicPartition, Object>>)(Function0 & Serializable & scala.Serializable)() -> {
            this.consumer().poll(0L);
            Set partitions = this.consumer().assignment();
            if (!fetchingEarliestOffset) {
                ((IterableLike)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    KafkaOffsetReader.$anonfun$partitionsAssignedToConsumer$4(x$5);
                    return BoxedUnit.UNIT;
                });
            }
            this.consumer().pause((Collection)partitions);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Partitions assigned to consumer: ").append(partitions).append(".").toString());
            return (scala.collection.immutable.Map)body.apply((Object)partitions);
        }));
    }

    private boolean partitionsAssignedToConsumer$default$2() {
        return false;
    }

    private <T> T runUninterruptibly(Function0<T> body) {
        Object object;
        if (!(Thread.currentThread() instanceof UninterruptibleThread)) {
            Future future = Future$.MODULE$.apply(body, (ExecutionContext)this.execContext());
            object = ThreadUtils$.MODULE$.awaitResult((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
        } else {
            object = body.apply();
        }
        return (T)object;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> withRetriesWithoutInterrupt(Function0<scala.collection.immutable.Map<TopicPartition, Object>> body) {
        scala.collection.immutable.Map map;
        Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
        KafkaOffsetReader kafkaOffsetReader = this;
        synchronized (kafkaOffsetReader) {
            ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
            IntRef attempt = IntRef.create((int)1);
            ObjectRef lastException = ObjectRef.create(null);
            while (((Option)result.elem).isEmpty() && attempt.elem <= this.maxOffsetFetchAttempts() && !Thread.currentThread().isInterrupted()) {
                Thread thread = Thread.currentThread();
                if (thread instanceof UninterruptibleThread) {
                    UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
                    BoxedUnit boxedUnit = (BoxedUnit)uninterruptibleThread.runUninterruptibly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        try {
                            result$1.elem = new Some(body.apply());
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (!option.isEmpty()) {
                                Throwable e = (Throwable)option.get();
                                lastException$1.elem = e;
                                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Error in attempt ").append(attempt$1.elem).append(" getting Kafka offsets: ").toString(), e);
                                ++attempt$1.elem;
                                Thread.sleep(this.offsetFetchAttemptIntervalMs());
                                this.resetConsumer();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            throw throwable;
                        }
                    });
                    continue;
                }
                throw new IllegalStateException("Kafka APIs must be executed on a o.a.spark.util.UninterruptibleThread");
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (((Option)result.elem).isEmpty()) {
                Predef$.MODULE$.assert(attempt.elem > this.maxOffsetFetchAttempts());
                Predef$.MODULE$.assert((Throwable)lastException.elem != null);
                throw (Throwable)lastException.elem;
            }
            map = (scala.collection.immutable.Map)((Option)result.elem).get();
        }
        return map;
    }

    private synchronized void stopConsumer() {
        block0: {
            Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
            if (this._consumer() == null) break block0;
            this._consumer().close();
        }
    }

    private synchronized void resetConsumer() {
        this.stopConsumer();
        this._consumer_$eq(null);
    }

    private final scala.collection.immutable.Map validateTopicPartitions$1(scala.collection.immutable.Set partitions, scala.collection.immutable.Map partitionOffsets) {
        scala.collection.immutable.Set set = partitions;
        scala.collection.immutable.Set set2 = partitionOffsets.keySet();
        Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(142).append("If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest.\n").append("Specified: ").append(partitionOffsets.keySet()).append(" Assigned: ").append(partitions).toString());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Partitions assigned to consumer: ").append(partitions).append(". Seeking to ").append(partitionOffsets).toString());
        return partitionOffsets;
    }

    public static final /* synthetic */ void $anonfun$fetchSpecificOffsets$1(KafkaOffsetReader $this, scala.collection.immutable.Map partitionOffsets$2, Set partitions) {
        Object object = JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala();
        scala.collection.immutable.Set set = partitionOffsets$2.keySet();
        Predef$.MODULE$.assert(!(object != null ? !object.equals(set) : set != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(161).append("If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest, if you don't care.\n").append("Specified: ").append(partitionOffsets$2.keySet()).append(" Assigned: ").append(JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toString());
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Partitions assigned to consumer: ").append(partitions).append(". Seeking to ").append(partitionOffsets$2).toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$fetchSpecificOffsets$6(scala.collection.immutable.Map fetched$1, Function1 reportDataLoss$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            long off = tuple2._2$mcJ$sp();
            if (off != KafkaOffsetRangeLimit$.MODULE$.LATEST() && off != KafkaOffsetRangeLimit$.MODULE$.EARLIEST()) {
                BoxedUnit boxedUnit = BoxesRunTime.unboxToLong((Object)fetched$1.apply((Object)tp)) != off ? (BoxedUnit)reportDataLoss$1.apply((Object)new StringBuilder(48).append("startingOffsets for ").append(tp).append(" was ").append(off).append(" but consumer reset to ").append(fetched$1.apply((Object)tp)).toString()) : BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$fetchSpecificTimestampBasedOffsets$1(KafkaOffsetReader $this, scala.collection.immutable.Map partitionTimestamps$1, Set partitions) {
        Object object = JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala();
        scala.collection.immutable.Set set = partitionTimestamps$1.keySet();
        Predef$.MODULE$.assert(!(object != null ? !object.equals(set) : set != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append("If starting/endingOffsetsByTimestamp contains specific offsets, you must specify all ").append("topics. Specified: ").append(partitionTimestamps$1.keySet()).append(" Assigned: ").append(JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toString());
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Partitions assigned to consumer: ").append(partitions).append(". Seeking to ").append(partitionTimestamps$1).toString());
    }

    public static final /* synthetic */ void $anonfun$fetchSpecificTimestampBasedOffsets$8(scala.collection.immutable.Map x$3) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$fetchSpecificOffsets0$2(KafkaOffsetReader $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            if (KafkaOffsetRangeLimit$.MODULE$.LATEST() == l) {
                $this.consumer().seekToEnd(Arrays.asList((Object[])new TopicPartition[]{tp}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            if (KafkaOffsetRangeLimit$.MODULE$.EARLIEST() == l) {
                $this.consumer().seekToBeginning(Arrays.asList((Object[])new TopicPartition[]{tp}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicPartition tp = (TopicPartition)tuple2._1();
        long off = tuple2._2$mcJ$sp();
        $this.consumer().seek(tp, off);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$fetchLatestOffsets$6(long offset$1, TopicPartition tp$2, ObjectRef incorrectOffsets$1, long knownOffset) {
        BoxedUnit boxedUnit;
        if (knownOffset > offset$1) {
            Tuple3 incorrectOffset = new Tuple3((Object)tp$2, (Object)BoxesRunTime.boxToLong((long)knownOffset), (Object)BoxesRunTime.boxToLong((long)offset$1));
            boxedUnit = ((ArrayBuffer)incorrectOffsets$1.elem).$plus$eq((Object)incorrectOffset);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$fetchLatestOffsets$5(TopicPartition tp$2, long offset$1, ObjectRef incorrectOffsets$1, scala.collection.immutable.Map x$4) {
        x$4.get((Object)tp$2).foreach((Function1 & Serializable & scala.Serializable)knownOffset -> KafkaOffsetReader.$anonfun$fetchLatestOffsets$6(offset$1, tp$2, incorrectOffsets$1, BoxesRunTime.unboxToLong((Object)knownOffset)));
    }

    public static final /* synthetic */ void $anonfun$fetchLatestOffsets$4(Option knownOffsets$1, ObjectRef incorrectOffsets$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        knownOffsets$1.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            KafkaOffsetReader.$anonfun$fetchLatestOffsets$5(tp, offset, incorrectOffsets$1, x$4);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final Seq findIncorrectOffsets$1(ObjectRef partitionOffsets$4, Option knownOffsets$1) {
        ObjectRef incorrectOffsets = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        ((scala.collection.immutable.Map)partitionOffsets$4.elem).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaOffsetReader.$anonfun$fetchLatestOffsets$4(knownOffsets$1, incorrectOffsets, x0$1);
            return BoxedUnit.UNIT;
        });
        return (ArrayBuffer)incorrectOffsets.elem;
    }

    public static final /* synthetic */ void $anonfun$partitionsAssignedToConsumer$4(Tuple2 x$5) {
    }

    public KafkaOffsetReader(ConsumerStrategy consumerStrategy, java.util.Map<String, Object> driverKafkaParams, CaseInsensitiveMap<String> readerOptions, String driverGroupIdPrefix) {
        this.consumerStrategy = consumerStrategy;
        this.driverKafkaParams = driverKafkaParams;
        this.driverGroupIdPrefix = driverGroupIdPrefix;
        Logging.$init$((Logging)this);
        this.kafkaReaderThread = Executors.newSingleThreadExecutor(r -> {
            void var1_1;
            UninterruptibleThread t = new UninterruptibleThread(null, r){
                private final Runnable r$1;

                public void run() {
                    this.r$1.run();
                }
                {
                    this.r$1 = r$1;
                    super("Kafka Offset Reader");
                }
            };
            t.setDaemon(true);
            return var1_1;
        });
        this.execContext = ExecutionContext$.MODULE$.fromExecutorService(this.kafkaReaderThread());
        this.groupId = null;
        this.nextId = 0;
        this._consumer = null;
        this.maxOffsetFetchAttempts = new StringOps(Predef$.MODULE$.augmentString((String)readerOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.FETCH_OFFSET_NUM_RETRY(), (Function0 & Serializable & scala.Serializable)() -> "3"))).toInt();
        this.offsetFetchAttemptIntervalMs = new StringOps(Predef$.MODULE$.augmentString((String)readerOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.FETCH_OFFSET_RETRY_INTERVAL_MS(), (Function0 & Serializable & scala.Serializable)() -> "1000"))).toLong();
    }
}

