/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.kafka010.KafkaDataConsumer;
import org.apache.spark.sql.kafka010.KafkaDataConsumer$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaSourceRDDOffsetRange;
import org.apache.spark.sql.kafka010.KafkaSourceRDDPartition;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.NextIterator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!\u0002\u0007\u000e\u000159\u0002\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011]\u0002!\u0011!Q\u0001\naB\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t?\u0002\u0011\t\u0011)A\u0005A\"A1\r\u0001B\u0001B\u0003%A\rC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0003{\u0001\u0011\u00053\u0010C\u0004\u0002\u0002\u0001!\t%a\u0001\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!9\u00111\u0005\u0001\u0005\n\u0005\u0015\"AD&bM.\f7k\\;sG\u0016\u0014F\t\u0012\u0006\u0003\u001d=\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003!E\t1a]9m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7C\u0001\u0001\u0019!\rIBDH\u0007\u00025)\u00111$E\u0001\u0004e\u0012$\u0017BA\u000f\u001b\u0005\r\u0011F\t\u0012\t\u0005?\u0019B\u0003&D\u0001!\u0015\t\t#%\u0001\u0005d_:\u001cX/\\3s\u0015\t\u0019C%A\u0004dY&,g\u000e^:\u000b\u0005\u0015\u001a\u0012!B6bM.\f\u0017BA\u0014!\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u00042!\u000b\u0017/\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#!B!se\u0006L\bCA\u00150\u0013\t\u0001$F\u0001\u0003CsR,\u0017AA:d\u0007\u0001\u0001\"\u0001N\u001b\u000e\u0003EI!AN\t\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\u0002'\u0015DXmY;u_J\\\u0015MZ6b!\u0006\u0014\u0018-\\:\u0011\ter\u0004iS\u0007\u0002u)\u00111\bP\u0001\u0005kRLGNC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$aA'baB\u0011\u0011\t\u0013\b\u0003\u0005\u001a\u0003\"a\u0011\u0016\u000e\u0003\u0011S!!\u0012\u001a\u0002\rq\u0012xn\u001c;?\u0013\t9%&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$+!\tau*D\u0001N\u0015\tqE(\u0001\u0003mC:<\u0017B\u0001)N\u0005\u0019y%M[3di\u0006aqN\u001a4tKR\u0014\u0016M\\4fgB\u00191\u000bW.\u000f\u0005Q3fBA\"V\u0013\u0005Y\u0013BA,+\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0017.\u0003\u0007M+\u0017O\u0003\u0002XUA\u0011A,X\u0007\u0002\u001b%\u0011a,\u0004\u0002\u001a\u0017\u000647.Y*pkJ\u001cWM\u0015#E\u001f\u001a47/\u001a;SC:<W-A\u0007q_2dG+[7f_V$Xj\u001d\t\u0003S\u0005L!A\u0019\u0016\u0003\t1{gnZ\u0001\u000fM\u0006LGn\u00148ECR\fGj\\:t!\tIS-\u0003\u0002gU\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0004jU.dWN\u001c\t\u00039\u0002AQ!\r\u0004A\u0002MBQa\u000e\u0004A\u0002aBQ!\u0015\u0004A\u0002ICQa\u0018\u0004A\u0002\u0001DQa\u0019\u0004A\u0002\u0011\fq\u0001]3sg&\u001cH\u000f\u0006\u0002re6\t\u0001\u0001C\u0003t\u000f\u0001\u0007A/\u0001\u0005oK^dUM^3m!\t)\b0D\u0001w\u0015\t9\u0018#A\u0004ti>\u0014\u0018mZ3\n\u0005e4(\u0001D*u_J\fw-\u001a'fm\u0016d\u0017!D4fiB\u000b'\u000f^5uS>t7/F\u0001}!\rIC& \t\u0003iyL!a`\t\u0003\u0013A\u000b'\u000f^5uS>t\u0017!F4fiB\u0013XMZ3se\u0016$Gj\\2bi&|gn\u001d\u000b\u0005\u0003\u000b\t9\u0001E\u0002T1\u0002Ca!!\u0003\n\u0001\u0004i\u0018!B:qY&$\u0018aB2p[B,H/\u001a\u000b\u0007\u0003\u001f\t)\"!\u0007\u0011\tM\u000b\tBH\u0005\u0004\u0003'Q&\u0001C%uKJ\fGo\u001c:\t\r\u0005]!\u00021\u0001~\u0003\u001d!\b.\u001a)beRDq!a\u0007\u000b\u0001\u0004\ti\"A\u0004d_:$X\r\u001f;\u0011\u0007Q\ny\"C\u0002\u0002\"E\u00111\u0002V1tW\u000e{g\u000e^3yi\u0006a!/Z:pYZ,'+\u00198hKR)1,a\n\u00020!1\u0011e\u0003a\u0001\u0003S\u00012\u0001XA\u0016\u0013\r\ti#\u0004\u0002\u0012\u0017\u000647.\u0019#bi\u0006\u001cuN\\:v[\u0016\u0014\bBBA\u0019\u0017\u0001\u00071,A\u0003sC:<W\r")
public class KafkaSourceRDD
extends RDD<ConsumerRecord<byte[], byte[]>> {
    private final Map<String, Object> executorKafkaParams;
    private final Seq<KafkaSourceRDDOffsetRange> offsetRanges;
    public final long org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs;
    public final boolean org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss;

    public KafkaSourceRDD persist(StorageLevel newLevel) {
        this.logError((Function0 & Serializable & scala.Serializable)() -> "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window");
        return (KafkaSourceRDD)super.persist(newLevel);
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)this.offsetRanges.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            KafkaSourceRDDOffsetRange o = (KafkaSourceRDDOffsetRange)tuple2._1();
            int i = tuple2._2$mcI$sp();
            KafkaSourceRDDPartition kafkaSourceRDDPartition = new KafkaSourceRDDPartition(i, o);
            return kafkaSourceRDDPartition;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public Seq<String> getPreferredLocations(Partition split) {
        KafkaSourceRDDPartition part = (KafkaSourceRDDPartition)split;
        return (Seq)part.offsetRange().preferredLoc().map((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$1}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
    }

    public Iterator<ConsumerRecord<byte[], byte[]>> compute(Partition thePart, TaskContext context) {
        Object object;
        KafkaSourceRDDPartition sourcePartition = (KafkaSourceRDDPartition)thePart;
        KafkaDataConsumer consumer = KafkaDataConsumer$.MODULE$.acquire(sourcePartition.offsetRange().topicPartition(), this.executorKafkaParams);
        KafkaSourceRDDOffsetRange range = this.resolveRange(consumer, sourcePartition.offsetRange());
        Predef$.MODULE$.assert(range.fromOffset() <= range.untilOffset(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(147).append("Beginning offset ").append(range.fromOffset()).append(" is after the ending offset ").append(range.untilOffset()).append(" ").append("for topic ").append(range.topic()).append(" partition ").append(range.partition()).append(". ").append("You either provided an invalid fromOffset, or the Kafka topic has been damaged").toString());
        if (range.fromOffset() == range.untilOffset()) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Beginning offset ").append(range.fromOffset()).append(" is the same as ending offset ").append("skipping ").append(range.topic()).append(" ").append(range.partition()).toString());
            consumer.release();
            object = package$.MODULE$.Iterator().empty();
        } else {
            NextIterator<ConsumerRecord<byte[], byte[]>> underlying = new NextIterator<ConsumerRecord<byte[], byte[]>>(this, range, consumer){
                private long requestOffset;
                private final /* synthetic */ KafkaSourceRDD $outer;
                private final KafkaSourceRDDOffsetRange range$1;
                private final KafkaDataConsumer consumer$1;

                public long requestOffset() {
                    return this.requestOffset;
                }

                public void requestOffset_$eq(long x$1) {
                    this.requestOffset = x$1;
                }

                /*
                 * WARNING - void declaration
                 */
                public ConsumerRecord<byte[], byte[]> getNext() {
                    Object v0;
                    if (this.requestOffset() >= this.range$1.untilOffset()) {
                        this.finished_$eq(true);
                        v0 = null;
                    } else {
                        ConsumerRecord<byte[], byte[]> r = this.consumer$1.get(this.requestOffset(), this.range$1.untilOffset(), this.$outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs, this.$outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss);
                        if (r == null) {
                            this.finished_$eq(true);
                            v0 = null;
                        } else {
                            void var1_1;
                            this.requestOffset_$eq(r.offset() + 1L);
                            v0 = var1_1;
                        }
                    }
                    return v0;
                }

                public void close() {
                    this.consumer$1.release();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.range$1 = range$1;
                    this.consumer$1 = consumer$1;
                    this.requestOffset = range$1.fromOffset();
                }
            };
            context.addTaskCompletionListener(arg_0 -> KafkaSourceRDD.$anonfun$compute$3$adapted((NextIterator)underlying, arg_0));
            object = underlying;
        }
        return object;
    }

    private KafkaSourceRDDOffsetRange resolveRange(KafkaDataConsumer consumer, KafkaSourceRDDOffsetRange range) {
        KafkaSourceRDDOffsetRange kafkaSourceRDDOffsetRange;
        if (range.fromOffset() < 0L || range.untilOffset() < 0L) {
            long l;
            long fromOffset;
            long l2;
            KafkaDataConsumer.AvailableOffsetRange availableOffsetRange = consumer.getAvailableOffsetRange();
            if (range.fromOffset() < 0L) {
                Predef$.MODULE$.assert(range.fromOffset() == KafkaOffsetRangeLimit$.MODULE$.EARLIEST(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("earliest offset ").append(range.fromOffset()).append(" does not equal ").append(KafkaOffsetRangeLimit$.MODULE$.EARLIEST()).toString());
                l2 = availableOffsetRange.earliest();
            } else {
                l2 = fromOffset = range.fromOffset();
            }
            if (range.untilOffset() < 0L) {
                Predef$.MODULE$.assert(range.untilOffset() == KafkaOffsetRangeLimit$.MODULE$.LATEST(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("latest offset ").append(range.untilOffset()).append(" does not equal ").append(KafkaOffsetRangeLimit$.MODULE$.LATEST()).toString());
                l = availableOffsetRange.latest();
            } else {
                l = range.untilOffset();
            }
            long untilOffset = l;
            kafkaSourceRDDOffsetRange = new KafkaSourceRDDOffsetRange(range.topicPartition(), fromOffset, untilOffset, range.preferredLoc());
        } else {
            kafkaSourceRDDOffsetRange = range;
        }
        return kafkaSourceRDDOffsetRange;
    }

    public KafkaSourceRDD(SparkContext sc, Map<String, Object> executorKafkaParams, Seq<KafkaSourceRDDOffsetRange> offsetRanges, long pollTimeoutMs, boolean failOnDataLoss) {
        this.executorKafkaParams = executorKafkaParams;
        this.offsetRanges = offsetRanges;
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs = pollTimeoutMs;
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss = failOnDataLoss;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }

    public static final /* synthetic */ Object $anonfun$compute$3$adapted(NextIterator underlying$1, TaskContext x$2) {
        underlying$1.closeIfNeeded();
        return BoxedUnit.UNIT;
    }
}

