/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaWriteTask;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class KafkaWriter$
implements Logging {
    public static KafkaWriter$ MODULE$;
    private final String TOPIC_ATTRIBUTE_NAME;
    private final String KEY_ATTRIBUTE_NAME;
    private final String VALUE_ATTRIBUTE_NAME;
    private final String HEADERS_ATTRIBUTE_NAME;
    private final String PARTITION_ATTRIBUTE_NAME;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KafkaWriter$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String TOPIC_ATTRIBUTE_NAME() {
        return this.TOPIC_ATTRIBUTE_NAME;
    }

    public String KEY_ATTRIBUTE_NAME() {
        return this.KEY_ATTRIBUTE_NAME;
    }

    public String VALUE_ATTRIBUTE_NAME() {
        return this.VALUE_ATTRIBUTE_NAME;
    }

    public String HEADERS_ATTRIBUTE_NAME() {
        return this.HEADERS_ATTRIBUTE_NAME;
    }

    public String PARTITION_ATTRIBUTE_NAME() {
        return this.PARTITION_ATTRIBUTE_NAME;
    }

    public String toString() {
        return "KafkaWriter";
    }

    public void validateQuery(Seq<Attribute> schema, Map<String, Object> kafkaParameters, Option<String> topic) {
        try {
            this.topicExpression(schema, topic);
            this.keyExpression(schema);
            this.valueExpression(schema);
            this.headersExpression(schema);
            this.partitionExpression(schema);
        }
        catch (IllegalStateException e) {
            throw new AnalysisException(e.getMessage(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public Option<String> validateQuery$default$3() {
        return None$.MODULE$;
    }

    public void write(SparkSession sparkSession, QueryExecution queryExecution, Map<String, Object> kafkaParameters, Option<String> topic) {
        Seq schema = queryExecution.analyzed().output();
        this.validateQuery((Seq<Attribute>)schema, kafkaParameters, topic);
        queryExecution.toRdd().foreachPartition((Function1 & Serializable & scala.Serializable)iter -> {
            KafkaWriter$.$anonfun$write$1(kafkaParameters, schema, topic, iter);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> write$default$4() {
        return None$.MODULE$;
    }

    public Expression topicExpression(Seq<Attribute> schema, Option<String> topic) {
        return (Expression)topic.map((Function1 & Serializable & scala.Serializable)x$1 -> Literal$.MODULE$.apply(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.expression(schema, MODULE$.TOPIC_ATTRIBUTE_NAME(), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$}))), (Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(91).append("topic option required when no ").append("'").append(MODULE$.TOPIC_ATTRIBUTE_NAME()).append("' attribute is present. Use the ").append(KafkaSourceProvider$.MODULE$.TOPIC_OPTION_KEY()).append(" option for setting a topic.").toString());
        }));
    }

    public Option<String> topicExpression$default$2() {
        return None$.MODULE$;
    }

    public Expression keyExpression(Seq<Attribute> schema) {
        return this.expression(schema, this.KEY_ATTRIBUTE_NAME(), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, BinaryType$.MODULE$}))), (Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Literal(null, (DataType)BinaryType$.MODULE$));
    }

    public Expression valueExpression(Seq<Attribute> schema) {
        return this.expression(schema, this.VALUE_ATTRIBUTE_NAME(), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, BinaryType$.MODULE$}))), (Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(31).append("Required attribute '").append(MODULE$.VALUE_ATTRIBUTE_NAME()).append("' not found").toString());
        });
    }

    public Expression headersExpression(Seq<Attribute> schema) {
        return this.expression(schema, this.HEADERS_ATTRIBUTE_NAME(), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType[]{KafkaRecordToRowConverter$.MODULE$.headersType()}))), (Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Literal(CatalystTypeConverters$.MODULE$.convertToCatalyst(null), (DataType)KafkaRecordToRowConverter$.MODULE$.headersType()));
    }

    public Expression partitionExpression(Seq<Attribute> schema) {
        return this.expression(schema, this.PARTITION_ATTRIBUTE_NAME(), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IntegerType$[]{IntegerType$.MODULE$}))), (Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Literal(null, (DataType)IntegerType$.MODULE$));
    }

    private Expression expression(Seq<Attribute> schema, String attrName, Seq<DataType> desired, Function0<Expression> function0) {
        Expression expr = (Expression)schema.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KafkaWriter$.$anonfun$expression$1(attrName, x$2))).getOrElse(function0);
        if (!desired.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.sameType(expr.dataType())))) {
            throw new IllegalStateException(new StringBuilder(44).append(attrName).append(" attribute unsupported type ").append(expr.dataType().catalogString()).append(". ").append(attrName).append(" must be a(n) ").append(((TraversableOnce)desired.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.catalogString(), Seq$.MODULE$.canBuildFrom())).mkString(" or ")).toString());
        }
        return expr;
    }

    public static final /* synthetic */ void $anonfun$write$1(Map kafkaParameters$1, Seq schema$1, Option topic$1, Iterator iter) {
        KafkaWriteTask writeTask = new KafkaWriteTask(kafkaParameters$1, (Seq<Attribute>)schema$1, (Option<String>)topic$1);
        Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writeTask.execute((Iterator<InternalRow>)iter), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writeTask.close());
    }

    public static final /* synthetic */ boolean $anonfun$expression$1(String attrName$1, Attribute x$2) {
        String string = x$2.name();
        String string2 = attrName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private KafkaWriter$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.TOPIC_ATTRIBUTE_NAME = "topic";
        this.KEY_ATTRIBUTE_NAME = "key";
        this.VALUE_ATTRIBUTE_NAME = "value";
        this.HEADERS_ATTRIBUTE_NAME = "headers";
        this.PARTITION_ATTRIBUTE_NAME = "partition";
    }
}

