/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceOffset$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a3Q\u0001C\u0005\u0001\u0013MA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!)A\u0007\u0001C\u0001k!9\u0011\b\u0001b\u0001\n\u0003Q\u0004BB \u0001A\u0003%1\bC\u0003A\u0001\u0011\u0005\u0013\tC\u0003R\u0001\u0011\u0005#K\u0001\u0010LC\u001a\\\u0017mU8ve\u000e,\u0017J\\5uS\u0006dwJ\u001a4tKR<&/\u001b;fe*\u0011!bC\u0001\tW\u000647.\u0019\u00192a)\u0011A\"D\u0001\u0004gFd'B\u0001\b\u0010\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0014\u0005\u0001!\u0002cA\u000b\u001b95\taC\u0003\u0002\u00181\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u00033-\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005m1\"a\u0004%E\rNkU\r^1eCR\fGj\\4\u0011\u0005uqR\"A\u0005\n\u0005}I!!E&bM.\f7k\\;sG\u0016|eMZ:fi\u0006a1\u000f]1sWN+7o]5p]\u000e\u0001\u0001CA\u0012%\u001b\u0005Y\u0011BA\u0013\f\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u00031iW\r^1eCR\f\u0007+\u0019;i!\tA\u0013G\u0004\u0002*_A\u0011!&L\u0007\u0002W)\u0011A&I\u0001\u0007yI|w\u000e\u001e \u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003a5\na\u0001P5oSRtDc\u0001\u001c8qA\u0011Q\u0004\u0001\u0005\u0006A\r\u0001\rA\t\u0005\u0006M\r\u0001\raJ\u0001\b-\u0016\u00136+S(O+\u0005Y\u0004C\u0001\u001f>\u001b\u0005i\u0013B\u0001 .\u0005\rIe\u000e^\u0001\t-\u0016\u00136+S(OA\u0005I1/\u001a:jC2L'0\u001a\u000b\u0004\u0005\u0016;\u0005C\u0001\u001fD\u0013\t!UF\u0001\u0003V]&$\b\"\u0002$\u0007\u0001\u0004a\u0012\u0001C7fi\u0006$\u0017\r^1\t\u000b!3\u0001\u0019A%\u0002\u0007=,H\u000f\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006\u0011\u0011n\u001c\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\t\u00016J\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.A\u0006eKN,'/[1mSj,GC\u0001\u000fT\u0011\u0015!v\u00011\u0001V\u0003\tIg\u000e\u0005\u0002K-&\u0011qk\u0013\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e")
public class KafkaSourceInitialOffsetWriter
extends HDFSMetadataLog<KafkaSourceOffset> {
    private final int VERSION;

    public int VERSION() {
        return this.VERSION;
    }

    public void serialize(KafkaSourceOffset metadata, OutputStream out) {
        out.write(0);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        writer.write(new StringBuilder(2).append("v").append(this.VERSION()).append("\n").toString());
        writer.write(metadata.json());
        writer.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KafkaSourceOffset deserialize(InputStream in) {
        KafkaSourceOffset kafkaSourceOffset;
        in.read();
        String content = IOUtils.toString((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(content)).nonEmpty());
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(content), 0) == 'v') {
            int indexOfNewLine = content.indexOf("\n");
            if (indexOfNewLine <= 0) throw new IllegalStateException("Log file was malformed: failed to detect the log file version line.");
            this.validateVersion(content.substring(0, indexOfNewLine), this.VERSION());
            kafkaSourceOffset = KafkaSourceOffset$.MODULE$.apply(new SerializedOffset(content.substring(indexOfNewLine + 1)));
            return kafkaSourceOffset;
        } else {
            kafkaSourceOffset = KafkaSourceOffset$.MODULE$.apply(new SerializedOffset(content));
        }
        return kafkaSourceOffset;
    }

    public KafkaSourceInitialOffsetWriter(SparkSession sparkSession, String metadataPath) {
        super(sparkSession, metadataPath, ClassTag$.MODULE$.apply(KafkaSourceOffset.class));
        this.VERSION = 1;
    }
}

