/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001I4Qa\u0003\u0007\u0001\u0019YA\u0001\"\b\u0001\u0003\u0006\u0004%\ta\b\u0005\tM\u0001\u0011\t\u0011)A\u0005A!)q\u0005\u0001C\u0001Q!)A\u0006\u0001C\u0001[!9!\nAI\u0001\n\u0003Y\u0005\"\u0002,\u0001\t\u00139vA\u00023\r\u0011\u0003aQM\u0002\u0004\f\u0019!\u0005AB\u001a\u0005\u0006O!!\ta\u001a\u0005\u0006Q\"!\t!\u001b\u0002\u001b\u0017\u000647.Y(gMN,GOU1oO\u0016\u001c\u0015\r\\2vY\u0006$xN\u001d\u0006\u0003\u001b9\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003\u001fA\t1a]9m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u0006iQ.\u001b8QCJ$\u0018\u000e^5p]N\u001c\u0001!F\u0001!!\rA\u0012eI\u0005\u0003Ee\u0011aa\u00149uS>t\u0007C\u0001\r%\u0013\t)\u0013DA\u0002J]R\fa\"\\5o!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003S-\u0002\"A\u000b\u0001\u000e\u00031AQ!H\u0002A\u0002\u0001\n\u0011bZ3u%\u0006tw-Z:\u0015\u00079jt\bE\u00020oir!\u0001M\u001b\u000f\u0005E\"T\"\u0001\u001a\u000b\u0005Mr\u0012A\u0002\u001fs_>$h(C\u0001\u001b\u0013\t1\u0014$A\u0004qC\u000e\\\u0017mZ3\n\u0005aJ$aA*fc*\u0011a'\u0007\t\u0003UmJ!\u0001\u0010\u0007\u0003!-\u000bgm[1PM\u001a\u001cX\r\u001e*b]\u001e,\u0007\"\u0002 \u0005\u0001\u0004q\u0013A\u0002:b]\u001e,7\u000fC\u0004A\tA\u0005\t\u0019A!\u0002#\u0015DXmY;u_JdunY1uS>t7\u000fE\u00020o\t\u0003\"aQ$\u000f\u0005\u0011+\u0005CA\u0019\u001a\u0013\t1\u0015$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$\u001a\u0003M9W\r\u001e*b]\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005a%FA!NW\u0005q\u0005CA(U\u001b\u0005\u0001&BA)S\u0003%)hn\u00195fG.,GM\u0003\u0002T3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005U\u0003&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Yq-\u001a;M_\u000e\fG/[8o)\rA\u0016l\u0019\t\u00041\u0005\u0012\u0005\"\u0002.\u0007\u0001\u0004Y\u0016A\u0001;q!\ta\u0016-D\u0001^\u0015\tqv,\u0001\u0004d_6lwN\u001c\u0006\u0003AJ\tQa[1gW\u0006L!AY/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")\u0001I\u0002a\u0001\u0003\u0006Q2*\u00194lC>3gm]3u%\u0006tw-Z\"bY\u000e,H.\u0019;peB\u0011!\u0006C\n\u0003\u0011]!\u0012!Z\u0001\u0006CB\u0004H.\u001f\u000b\u0003S)DQa\u001b\u0006A\u00021\fqa\u001c9uS>t7\u000f\u0005\u0002na6\taN\u0003\u0002p\u001d\u0005!Q\u000f^5m\u0013\t\thN\u0001\rDCN,\u0017J\\:f]NLG/\u001b<f'R\u0014\u0018N\\4NCB\u0004")
public class KafkaOffsetRangeCalculator {
    private final Option<Object> minPartitions;

    public static KafkaOffsetRangeCalculator apply(CaseInsensitiveStringMap caseInsensitiveStringMap) {
        return KafkaOffsetRangeCalculator$.MODULE$.apply(caseInsensitiveStringMap);
    }

    public Option<Object> minPartitions() {
        return this.minPartitions;
    }

    public Seq<KafkaOffsetRange> getRanges(Seq<KafkaOffsetRange> ranges, Seq<String> executorLocations) {
        Seq seq;
        Seq offsetRanges = (Seq)ranges.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetRangeCalculator.$anonfun$getRanges$1(x$1)));
        if (this.minPartitions().isEmpty() || offsetRanges.size() > BoxesRunTime.unboxToInt((Object)this.minPartitions().get())) {
            seq = (Seq)offsetRanges.map((Function1 & Serializable & scala.Serializable)range -> {
                Option<String> x$1 = this.getLocation(range.topicPartition(), executorLocations);
                TopicPartition x$2 = range.copy$default$1();
                long x$3 = range.copy$default$2();
                long x$4 = range.copy$default$3();
                return range.copy(x$2, x$3, x$4, x$1);
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            long totalSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)offsetRanges.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            seq = (Seq)((TraversableLike)offsetRanges.flatMap((Function1 & Serializable & scala.Serializable)range -> {
                TopicPartition tp = range.topicPartition();
                long size = range.size();
                int parts = (int)package$.MODULE$.max(package$.MODULE$.round((double)size / (double)totalSize * (double)BoxesRunTime.unboxToInt((Object)this.minPartitions().get())), 1L);
                LongRef remaining = LongRef.create((long)size);
                LongRef startOffset = LongRef.create((long)range.fromOffset());
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), parts).map((Function1 & Serializable & scala.Serializable)part -> KafkaOffsetRangeCalculator.$anonfun$getRanges$5(remaining, parts, startOffset, range, tp, BoxesRunTime.unboxToInt((Object)part)), IndexedSeq$.MODULE$.canBuildFrom());
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetRangeCalculator.$anonfun$getRanges$6(x$3)));
        }
        return seq;
    }

    public Seq<String> getRanges$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private Option<String> getLocation(TopicPartition tp, Seq<String> executorLocations) {
        int numExecutors = executorLocations.length();
        return numExecutors > 0 ? new Some(executorLocations.apply(KafkaOffsetRangeCalculator.floorMod$1(tp.hashCode(), numExecutors))) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getRanges$1(KafkaOffsetRange x$1) {
        return x$1.size() > 0L;
    }

    public static final /* synthetic */ KafkaOffsetRange $anonfun$getRanges$5(LongRef remaining$1, int parts$1, LongRef startOffset$1, KafkaOffsetRange range$1, TopicPartition tp$1, int part) {
        long thisPartition = remaining$1.elem / (long)(parts$1 - part);
        remaining$1.elem -= thisPartition;
        long endOffset = package$.MODULE$.min(startOffset$1.elem + thisPartition, range$1.untilOffset());
        KafkaOffsetRange offsetRange = new KafkaOffsetRange(tp$1, startOffset$1.elem, endOffset, (Option<String>)None$.MODULE$);
        startOffset$1.elem = endOffset;
        return offsetRange;
    }

    public static final /* synthetic */ boolean $anonfun$getRanges$6(KafkaOffsetRange x$3) {
        return x$3.size() > 0L;
    }

    private static final int floorMod$1(long a, int b) {
        return ((int)(a % (long)b) + b) % b;
    }

    public KafkaOffsetRangeCalculator(Option<Object> minPartitions) {
        this.minPartitions = minPartitions;
        Predef$.MODULE$.require(minPartitions.isEmpty() || BoxesRunTime.unboxToInt((Object)minPartitions.get()) > 0);
    }
}

