/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.kafka010.ConsumerStrategy;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaOffsetReader$;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaSourceRDD;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!\u0002\n\u0014\u0001Mi\u0002\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011I\u0018\t\u0011Q\u0002!\u0011!Q\u0001\nAB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!I\u0006A!A!\u0002\u0013)\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011y\u0003!\u0011!Q\u0001\nmCQa\u0018\u0001\u0005\u0002\u0001DqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004p\u0001\u0001\u0006I\u0001\u001c\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u0011\u0019)\b\u0001)A\u0005e\")a\u000f\u0001C!o\")a\u0010\u0001C!\u007f\"9\u00111\u0003\u0001\u0005B\u0005U!!D&bM.\f'+\u001a7bi&|gN\u0003\u0002\u0015+\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u0017/\u0005\u00191/\u001d7\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001cB\u0001\u0001\u0010%OA\u0011qDI\u0007\u0002A)\u0011\u0011%F\u0001\bg>,(oY3t\u0013\t\u0019\u0003E\u0001\u0007CCN,'+\u001a7bi&|g\u000e\u0005\u0002 K%\u0011a\u0005\t\u0002\n)\u0006\u0014G.Z*dC:\u0004\"\u0001K\u0016\u000e\u0003%R!AK\f\u0002\u0011%tG/\u001a:oC2L!\u0001L\u0015\u0003\u000f1{wmZ5oO\u0006Q1/\u001d7D_:$X\r\u001f;\u0004\u0001U\t\u0001\u0007\u0005\u00022e5\tQ#\u0003\u00024+\tQ1+\u0015'D_:$X\r\u001f;\u0002\u0017M\fHnQ8oi\u0016DH\u000fI\u0001\tgR\u0014\u0018\r^3hsB\u0011q\u0007O\u0007\u0002'%\u0011\u0011h\u0005\u0002\u0011\u0007>t7/^7feN#(/\u0019;fOf\fQb]8ve\u000e,w\n\u001d;j_:\u001c\bc\u0001\u001fB\u00076\tQH\u0003\u0002?\u007f\u0005!Q\u000f^5m\u0015\t\u0001U#\u0001\u0005dCR\fG._:u\u0013\t\u0011UH\u0001\nDCN,\u0017J\\:f]NLG/\u001b<f\u001b\u0006\u0004\bC\u0001#N\u001d\t)5\n\u0005\u0002G\u00136\tqI\u0003\u0002I]\u00051AH]8pizR\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u000ba\u0001\u0015:fI\u00164\u0017B\u0001(P\u0005\u0019\u0019FO]5oO*\u0011A*S\u0001\u0015gB,7-\u001b4jK\u0012\\\u0015MZ6b!\u0006\u0014\u0018-\\:\u0011\t\u0011\u00136iQ\u0005\u0003'>\u00131!T1q\u000391\u0017-\u001b7P]\u0012\u000bG/\u0019'pgN\u0004\"AV,\u000e\u0003%K!\u0001W%\u0003\u000f\t{w\u000e\\3b]\u0006q\u0011N\\2mk\u0012,\u0007*Z1eKJ\u001c\u0018aD:uCJ$\u0018N\\4PM\u001a\u001cX\r^:\u0011\u0005]b\u0016BA/\u0014\u0005UY\u0015MZ6b\u001f\u001a47/\u001a;SC:<W\rT5nSR\fQ\"\u001a8eS:<wJ\u001a4tKR\u001c\u0018A\u0002\u001fj]&$h\bF\u0005bE\u000e$WMZ4iSB\u0011q\u0007\u0001\u0005\u0006[)\u0001\r\u0001\r\u0005\u0006k)\u0001\rA\u000e\u0005\u0006u)\u0001\ra\u000f\u0005\u0006!*\u0001\r!\u0015\u0005\u0006)*\u0001\r!\u0016\u0005\u00063*\u0001\r!\u0016\u0005\u00065*\u0001\ra\u0017\u0005\u0006=*\u0001\raW\u0001\u000ea>dG\u000eV5nK>,H/T:\u0016\u00031\u0004\"AV7\n\u00059L%\u0001\u0002'p]\u001e\fa\u0002]8mYRKW.Z8vi6\u001b\b%A\u0005d_:4XM\u001d;feV\t!\u000f\u0005\u00028g&\u0011Ao\u0005\u0002\u001a\u0017\u000647.\u0019*fG>\u0014H\rV8S_^\u001cuN\u001c<feR,'/\u0001\u0006d_:4XM\u001d;fe\u0002\naa]2iK6\fW#\u0001=\u0011\u0005edX\"\u0001>\u000b\u0005m,\u0012!\u0002;za\u0016\u001c\u0018BA?{\u0005)\u0019FO];diRK\b/Z\u0001\nEVLG\u000eZ*dC:$\"!!\u0001\u0011\r\u0005\r\u0011\u0011BA\u0007\u001b\t\t)AC\u0002\u0002\b]\t1A\u001d3e\u0013\u0011\tY!!\u0002\u0003\u0007I#E\tE\u00022\u0003\u001fI1!!\u0005\u0016\u0005\r\u0011vn^\u0001\ti>\u001cFO]5oOR\t1\t")
public class KafkaRelation
extends BaseRelation
implements TableScan,
Logging {
    private final SQLContext sqlContext;
    private final ConsumerStrategy strategy;
    private final CaseInsensitiveMap<String> sourceOptions;
    private final Map<String, String> specifiedKafkaParams;
    private final boolean failOnDataLoss;
    private final boolean includeHeaders;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final KafkaOffsetRangeLimit endingOffsets;
    private final long pollTimeoutMs;
    private final KafkaRecordToRowConverter converter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    private KafkaRecordToRowConverter converter() {
        return this.converter;
    }

    public StructType schema() {
        return KafkaRecordToRowConverter$.MODULE$.kafkaSchema(this.includeHeaders);
    }

    public RDD<Row> buildScan() {
        Seq<KafkaOffsetRange> seq;
        String uniqueGroupId = KafkaSourceProvider$.MODULE$.batchUniqueGroupId(this.sourceOptions);
        try (KafkaOffsetReader kafkaOffsetReader = KafkaOffsetReader$.MODULE$.build(this.strategy, KafkaSourceProvider$.MODULE$.kafkaParamsForDriver(this.specifiedKafkaParams), this.sourceOptions, new StringBuilder(7).append(uniqueGroupId).append("-driver").toString());){
            seq = kafkaOffsetReader.getOffsetRangesFromUnresolvedOffsets(this.startingOffsets, this.endingOffsets);
        }
        Seq<KafkaOffsetRange> offsetRanges = seq;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("GetBatch generating RDD of offset range: ").append(((TraversableOnce)offsetRanges.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topicPartition().toString(), (Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString());
        java.util.Map<String, Object> executorKafkaParams = KafkaSourceProvider$.MODULE$.kafkaParamsForExecutors(this.specifiedKafkaParams, uniqueGroupId);
        Function1<ConsumerRecord<byte[], byte[]>, InternalRow> toInternalRow = this.includeHeaders ? this.converter().toInternalRowWithHeaders() : this.converter().toInternalRowWithoutHeaders();
        RDD rdd = new KafkaSourceRDD(this.sqlContext().sparkContext(), executorKafkaParams, offsetRanges, this.pollTimeoutMs(), this.failOnDataLoss).map(toInternalRow, ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sqlContext().internalCreateDataFrame(rdd.setName("kafka"), this.schema(), this.sqlContext().internalCreateDataFrame$default$3()).rdd();
    }

    public String toString() {
        return new StringBuilder(38).append("KafkaRelation(strategy=").append(this.strategy).append(", start=").append(this.startingOffsets).append(", end=").append(this.endingOffsets).append(")").toString();
    }

    public KafkaRelation(SQLContext sqlContext, ConsumerStrategy strategy, CaseInsensitiveMap<String> sourceOptions, Map<String, String> specifiedKafkaParams, boolean failOnDataLoss, boolean includeHeaders, KafkaOffsetRangeLimit startingOffsets, KafkaOffsetRangeLimit endingOffsets) {
        this.sqlContext = sqlContext;
        this.strategy = strategy;
        this.sourceOptions = sourceOptions;
        this.specifiedKafkaParams = specifiedKafkaParams;
        this.failOnDataLoss = failOnDataLoss;
        this.includeHeaders = includeHeaders;
        this.startingOffsets = startingOffsets;
        this.endingOffsets = endingOffsets;
        Logging.$init$((Logging)this);
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = startingOffsets;
        LatestOffsetRangeLimit$ latestOffsetRangeLimit$ = LatestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(kafkaOffsetRangeLimit == null ? latestOffsetRangeLimit$ != null : !kafkaOffsetRangeLimit.equals(latestOffsetRangeLimit$), (Function0 & Serializable & scala.Serializable)() -> "Starting offset not allowed to be set to latest offsets.");
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit2 = endingOffsets;
        EarliestOffsetRangeLimit$ earliestOffsetRangeLimit$ = EarliestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(kafkaOffsetRangeLimit2 == null ? earliestOffsetRangeLimit$ != null : !kafkaOffsetRangeLimit2.equals(earliestOffsetRangeLimit$), (Function0 & Serializable & scala.Serializable)() -> "Ending offset not allowed to be set to earliest offsets.");
        this.pollTimeoutMs = new StringOps(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), (Function0 & Serializable & scala.Serializable)() -> ((Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.sqlContext().sparkContext().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L))).toString()))).toLong();
        this.converter = new KafkaRecordToRowConverter();
    }
}

