/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.kafka010.ConsumerStrategy;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.UninterruptibleThread;
import org.apache.spark.util.UninterruptibleThreadRunner;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tme!B\u00181\u0001AR\u0004\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011A\u0003!Q1A\u0005BEC\u0001b\u001b\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\tY\u0002\u0011\t\u0011)A\u0005[\"AA\u000f\u0001B\u0001B\u0003%!\fC\u0003v\u0001\u0011\u0005a\u000fC\u0004}\u0001\t\u0007I\u0011A?\t\u000f\u0005\u001d\u0001\u0001)A\u0005}\"I\u0011\u0011\u0002\u0001A\u0002\u0013%\u00111\u0002\u0005\n\u0003\u001b\u0001\u0001\u0019!C\u0005\u0003\u001fAq!a\u0007\u0001A\u0003&!\fC\u0005\u0002\u001e\u0001\u0001\r\u0011\"\u0003\u0002 !I\u0011q\u0005\u0001A\u0002\u0013%\u0011\u0011\u0006\u0005\t\u0003[\u0001\u0001\u0015)\u0003\u0002\"!I\u0011q\u0006\u0001A\u0002\u0013E\u0011\u0011\u0007\u0005\n\u0003'\u0002\u0001\u0019!C\t\u0003+B\u0001\"!\u0017\u0001A\u0003&\u00111\u0007\u0005\b\u0003s\u0001A\u0011CA\u0019\u0011)\t\u0019\u0007\u0001b\u0001\n\u0003\u0001\u0014q\u0004\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002\"!I\u0011q\r\u0001C\u0002\u0013%\u0011\u0011\u000e\u0005\t\u0003c\u0002\u0001\u0015!\u0003\u0002l!I\u00111\u000f\u0001C\u0002\u0013%\u0011Q\u000f\u0005\t\u0003{\u0002\u0001\u0015!\u0003\u0002x!Q\u0011q\u0010\u0001C\u0002\u0013\u0005\u0001'!!\t\u0011\u0005%\u0005\u0001)A\u0005\u0003\u0007Cq!a#\u0001\t\u0013\ti\tC\u0004\u0002\u001a\u0002!I!a'\t\u000f\u0005u\u0005\u0001\"\u0011\u0002\u001c\"9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0006bBAR\u0001\u0011%\u0011Q\u0015\u0005\b\u0003s\u0003A\u0011IA^\u0011\u001d\ty\r\u0001C!\u0003#Dq!a:\u0001\t\u0003\nI\u000fC\u0004\u0002t\u0002!I!!>\t\u000f\t5\u0001\u0001\"\u0011\u0003\u0010!9!\u0011\u0003\u0001\u0005B\tM\u0001b\u0002B\u0007\u0001\u0011\u0005#\u0011\u0006\u0005\b\u0005\u007f\u0001A\u0011\tB!\u0011\u001d\u0011\u0019\u0006\u0001C\u0005\u0005+BqA!\u0017\u0001\t\u0003\u0012Y\u0006C\u0004\u0003h\u0001!IA!\u001b\t\u0013\tM\u0004!%A\u0005\n\tU\u0004b\u0002BF\u0001\u0011%!Q\u0012\u0005\b\u0005/\u0003A\u0011BAQ\u0011\u001d\u0011I\n\u0001C\u0005\u0003C\u0013\u0011dS1gW\u0006|eMZ:fiJ+\u0017\rZ3s\u0007>t7/^7fe*\u0011\u0011GM\u0001\tW\u000647.\u0019\u00192a)\u00111\u0007N\u0001\u0004gFd'BA\u001b7\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0004(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0005\u0019qN]4\u0014\t\u0001Y\u0014)\u0012\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t\u001bU\"\u0001\u0019\n\u0005\u0011\u0003$!E&bM.\fwJ\u001a4tKR\u0014V-\u00193feB\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nN\u0001\tS:$XM\u001d8bY&\u0011!j\u0012\u0002\b\u0019><w-\u001b8h\u0003A\u0019wN\\:v[\u0016\u00148\u000b\u001e:bi\u0016<\u0017p\u0001\u0001\u0011\u0005\ts\u0015BA(1\u0005A\u0019uN\\:v[\u0016\u00148\u000b\u001e:bi\u0016<\u00170A\tee&4XM]&bM.\f\u0007+\u0019:b[N,\u0012A\u0015\t\u0005'bSV-D\u0001U\u0015\t)f+\u0001\u0003vi&d'\"A,\u0002\t)\fg/Y\u0005\u00033R\u00131!T1q!\tY&M\u0004\u0002]AB\u0011Q,P\u0007\u0002=*\u0011q\fT\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005l\u0014A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!Y\u001f\u0011\u0005\u0019LW\"A4\u000b\u0005!4\u0016\u0001\u00027b]\u001eL!A[4\u0003\r=\u0013'.Z2u\u0003I!'/\u001b<fe.\u000bgm[1QCJ\fWn\u001d\u0011\u0002\u001bI,\u0017\rZ3s\u001fB$\u0018n\u001c8t!\rq'OW\u0007\u0002_*\u0011Q\u000b\u001d\u0006\u0003cJ\n\u0001bY1uC2L8\u000f^\u0005\u0003g>\u0014!cQ1tK&s7/\u001a8tSRLg/Z'ba\u0006\u0019BM]5wKJ<%o\\;q\u0013\u0012\u0004&/\u001a4jq\u00061A(\u001b8jiz\"Ra\u001e=zun\u0004\"A\u0011\u0001\t\u000b-3\u0001\u0019A'\t\u000bA3\u0001\u0019\u0001*\t\u000b14\u0001\u0019A7\t\u000bQ4\u0001\u0019\u0001.\u00027Ut\u0017N\u001c;feJ,\b\u000f^5cY\u0016$\u0006N]3bIJ+hN\\3s+\u0005q\bcA@\u0002\u00045\u0011\u0011\u0011\u0001\u0006\u0003+RJA!!\u0002\u0002\u0002\tYRK\\5oi\u0016\u0014(/\u001e9uS\ndW\r\u00165sK\u0006$'+\u001e8oKJ\fA$\u001e8j]R,'O];qi&\u0014G.\u001a+ie\u0016\fGMU;o]\u0016\u0014\b%A\u0004he>,\b/\u00133\u0016\u0003i\u000b1b\u001a:pkBLEm\u0018\u0013fcR!\u0011\u0011CA\f!\ra\u00141C\u0005\u0004\u0003+i$\u0001B+oSRD\u0001\"!\u0007\u000b\u0003\u0003\u0005\rAW\u0001\u0004q\u0012\n\u0014\u0001C4s_V\u0004\u0018\n\u001a\u0011\u0002\r9,\u0007\u0010^%e+\t\t\t\u0003E\u0002=\u0003GI1!!\n>\u0005\rIe\u000e^\u0001\u000b]\u0016DH/\u00133`I\u0015\fH\u0003BA\t\u0003WA\u0011\"!\u0007\u000e\u0003\u0003\u0005\r!!\t\u0002\u000f9,\u0007\u0010^%eA\u0005IqlY8ogVlWM]\u000b\u0003\u0003g\u0001\u0002\"!\u000e\u0002D\u0005\u001d\u0013qI\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005A1m\u001c8tk6,'O\u0003\u0003\u0002>\u0005}\u0012aB2mS\u0016tGo\u001d\u0006\u0004\u0003\u00032\u0014!B6bM.\f\u0017\u0002BA#\u0003o\u0011\u0001bQ8ogVlWM\u001d\t\u0006y\u0005%\u0013QJ\u0005\u0004\u0003\u0017j$!B!se\u0006L\bc\u0001\u001f\u0002P%\u0019\u0011\u0011K\u001f\u0003\t\tKH/Z\u0001\u000e?\u000e|gn];nKJ|F%Z9\u0015\t\u0005E\u0011q\u000b\u0005\n\u00033\u0001\u0012\u0011!a\u0001\u0003g\t!bX2p]N,X.\u001a:!Q\r\t\u0012Q\f\t\u0004y\u0005}\u0013bAA1{\tAao\u001c7bi&dW-\u0001\fnCb|eMZ:fi\u001a+Go\u00195BiR,W\u000e\u001d;t\u0003]i\u0017\r_(gMN,GOR3uG\"\fE\u000f^3naR\u001c\b%A\u0007nS:\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003W\u0002R\u0001PA7\u0003CI1!a\u001c>\u0005\u0019y\u0005\u000f^5p]\u0006qQ.\u001b8QCJ$\u0018\u000e^5p]N\u0004\u0013a\u0004:b]\u001e,7)\u00197dk2\fGo\u001c:\u0016\u0005\u0005]\u0004c\u0001\"\u0002z%\u0019\u00111\u0010\u0019\u00035-\u000bgm[1PM\u001a\u001cX\r\u001e*b]\u001e,7)\u00197dk2\fGo\u001c:\u0002!I\fgnZ3DC2\u001cW\u000f\\1u_J\u0004\u0013\u0001H8gMN,GOR3uG\"\fE\u000f^3naRLe\u000e^3sm\u0006dWj]\u000b\u0003\u0003\u0007\u00032\u0001PAC\u0013\r\t9)\u0010\u0002\u0005\u0019>tw-A\u000fpM\u001a\u001cX\r\u001e$fi\u000eD\u0017\t\u001e;f[B$\u0018J\u001c;feZ\fG.T:!\u0003q\u0019\bn\\;mI\u0012KgO^=Va2\u000b'oZ3QCJ$\u0018\u000e^5p]N$B!a$\u0002\u0016B\u0019A(!%\n\u0007\u0005MUHA\u0004C_>dW-\u00198\t\u000f\u0005]5\u00041\u0001\u0002\"\u0005\u0011b.^7U_BL7\rU1si&$\u0018n\u001c8t\u0003-qW\r\u001f;He>,\b/\u00133\u0015\u0003i\u000b\u0001\u0002^8TiJLgnZ\u0001\u0006G2|7/\u001a\u000b\u0003\u0003#\tACZ3uG\"$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cHCAAT!\u0015Y\u0016\u0011VAW\u0013\r\tY\u000b\u001a\u0002\u0004'\u0016$\b\u0003BAX\u0003kk!!!-\u000b\t\u0005M\u0016qH\u0001\u0007G>lWn\u001c8\n\t\u0005]\u0016\u0011\u0017\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003U1W\r^2i!\u0006\u0014H/\u001b;j_:|eMZ:fiN$b!!0\u0002B\u0006-\u0007cB.\u0002@\u00065\u00161Q\u0005\u00033\u0012Dq!a1!\u0001\u0004\t)-\u0001\tpM\u001a\u001cX\r\u001e*b]\u001e,G*[7jiB\u0019!)a2\n\u0007\u0005%\u0007GA\u000bLC\u001a\\\u0017m\u00144gg\u0016$(+\u00198hK2KW.\u001b;\t\u000f\u00055\u0007\u00051\u0001\u0002\u0010\u0006\t\u0012n]*uCJ$\u0018N\\4PM\u001a\u001cX\r^:\u0002)\u0019,Go\u00195Ta\u0016\u001c\u0017NZ5d\u001f\u001a47/\u001a;t)\u0019\t\u0019.!7\u0002^B\u0019!)!6\n\u0007\u0005]\u0007GA\tLC\u001a\\\u0017mU8ve\u000e,wJ\u001a4tKRDq!a7\"\u0001\u0004\ti,\u0001\tqCJ$\u0018\u000e^5p]>3gm]3ug\"9\u0011q\\\u0011A\u0002\u0005\u0005\u0018A\u0004:fa>\u0014H\u000fR1uC2{7o\u001d\t\u0007y\u0005\r(,!\u0005\n\u0007\u0005\u0015XHA\u0005Gk:\u001cG/[8oc\u0005\u0011c-\u001a;dQN\u0003XmY5gS\u000e$\u0016.\\3ti\u0006l\u0007OQ1tK\u0012|eMZ:fiN$b!a5\u0002l\u0006=\bbBAwE\u0001\u0007\u0011QX\u0001\u0014a\u0006\u0014H/\u001b;j_:$\u0016.\\3ti\u0006l\u0007o\u001d\u0005\b\u0003c\u0014\u0003\u0019AAH\u0003]1\u0017-\u001b7t\u001f:tu.T1uG\"LgnZ(gMN,G/A\u000bgKR\u001c\u0007n\u00159fG&4\u0017nY(gMN,Go\u001d\u0019\u0015\u0011\u0005M\u0017q\u001fB\u0001\u0005\u000fAq!!?$\u0001\u0004\tY0\u0001\u0011g]\u0006\u001b8/\u001a:u!\u0006\u0014\u0018-\\3uKJ\u001cx+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c\bc\u0002\u001f\u0002d\u0006u\u0018\u0011\u0003\t\u0006'\u0006}\u0018QV\u0005\u0004\u0003W#\u0006b\u0002B\u0002G\u0001\u0007!QA\u0001\u001bM:\u0014V\r\u001e:jKZ,\u0007+\u0019:uSRLwN\\(gMN,Go\u001d\t\by\u0005\r\u0018Q`A_\u0011\u001d\u0011Ia\ta\u0001\u0005\u0017\taC\u001a8BgN,'\u000f\u001e$fi\u000eDW\rZ(gMN,Go\u001d\t\by\u0005\r\u0018QXA\t\u0003Q1W\r^2i\u000b\u0006\u0014H.[3ti>3gm]3ugR\u0011\u0011QX\u0001\u0013M\u0016$8\r\u001b'bi\u0016\u001cHo\u00144gg\u0016$8\u000f\u0006\u0003\u0003\u0016\t\r\u0002\u0003\u0002B\f\u0005;q1A\u0011B\r\u0013\r\u0011Y\u0002M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yB!\t\u0003%A\u000b'\u000f^5uS>twJ\u001a4tKRl\u0015\r\u001d\u0006\u0004\u00057\u0001\u0004b\u0002B\u0013K\u0001\u0007!qE\u0001\rW:|wO\\(gMN,Go\u001d\t\u0006y\u00055$Q\u0003\u000b\u0005\u0003{\u0013Y\u0003C\u0004\u0003.\u0019\u0002\rAa\f\u0002\u001b9,w\u000fU1si&$\u0018n\u001c8t!\u0019\u0011\tD!\u000f\u0002.:!!1\u0007B\u001c\u001d\ri&QG\u0005\u0002}%\u0019!1D\u001f\n\t\tm\"Q\b\u0002\u0004'\u0016\f(b\u0001B\u000e{\u0005!s-\u001a;PM\u001a\u001cX\r\u001e*b]\u001e,7O\u0012:p[Vs'/Z:pYZ,Gm\u00144gg\u0016$8\u000f\u0006\u0004\u0003D\t-#q\n\t\u0007\u0005c\u0011ID!\u0012\u0011\u0007\t\u00139%C\u0002\u0003JA\u0012\u0001cS1gW\u0006|eMZ:fiJ\u000bgnZ3\t\u000f\t5s\u00051\u0001\u0002F\u0006y1\u000f^1si&twm\u00144gg\u0016$8\u000fC\u0004\u0003R\u001d\u0002\r!!2\u0002\u001b\u0015tG-\u001b8h\u001f\u001a47/\u001a;t\u0003U9W\r^*peR,G-\u0012=fGV$xN\u001d'jgR$\"Aa\u0016\u0011\tq\nIEW\u0001#O\u0016$xJ\u001a4tKR\u0014\u0016M\\4fg\u001a\u0013x.\u001c*fg>dg/\u001a3PM\u001a\u001cX\r^:\u0015\u0011\t\r#Q\fB1\u0005KBqAa\u0018*\u0001\u0004\u0011)\"\u0001\u000bge>l\u0007+\u0019:uSRLwN\\(gMN,Go\u001d\u0005\b\u0005GJ\u0003\u0019\u0001B\u000b\u0003U)h\u000e^5m!\u0006\u0014H/\u001b;j_:|eMZ:fiNDq!a8*\u0001\u0004\t\t/\u0001\u000fqCJ$\u0018\u000e^5p]N\f5o]5h]\u0016$Gk\\\"p]N,X.\u001a:\u0015\r\u0005u&1\u000eB8\u0011\u001d\u0011iG\u000ba\u0001\u0005\u000b\tAAY8es\"I!\u0011\u000f\u0016\u0011\u0002\u0003\u0007\u0011qR\u0001\u0017M\u0016$8\r[5oO\u0016\u000b'\u000f\\5fgR|eMZ:fi\u00061\u0003/\u0019:uSRLwN\\:BgNLwM\\3e)>\u001cuN\\:v[\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t]$\u0006BAH\u0005sZ#Aa\u001f\u0011\t\tu$qQ\u0007\u0003\u0005\u007fRAA!!\u0003\u0004\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u000bk\u0014AC1o]>$\u0018\r^5p]&!!\u0011\u0012B@\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001co&$\bNU3ue&,7oV5uQ>,H/\u00138uKJ\u0014X\u000f\u001d;\u0015\t\u0005u&q\u0012\u0005\t\u0005[bC\u00111\u0001\u0003\u0012B)AHa%\u0002>&\u0019!QS\u001f\u0003\u0011q\u0012\u0017P\\1nKz\nAb\u001d;pa\u000e{gn];nKJ\fQB]3tKR\u001cuN\\:v[\u0016\u0014\b")
public class KafkaOffsetReaderConsumer
implements KafkaOffsetReader,
Logging {
    private final ConsumerStrategy consumerStrategy;
    private final java.util.Map<String, Object> driverKafkaParams;
    private final String driverGroupIdPrefix;
    private final UninterruptibleThreadRunner uninterruptibleThreadRunner;
    private String groupId;
    private int nextId;
    private volatile Consumer<byte[], byte[]> _consumer;
    private final int maxOffsetFetchAttempts;
    private final Option<Object> minPartitions;
    private final KafkaOffsetRangeCalculator rangeCalculator;
    private final long offsetFetchAttemptIntervalMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public java.util.Map<String, Object> driverKafkaParams() {
        return this.driverKafkaParams;
    }

    public UninterruptibleThreadRunner uninterruptibleThreadRunner() {
        return this.uninterruptibleThreadRunner;
    }

    private String groupId() {
        return this.groupId;
    }

    private void groupId_$eq(String x$1) {
        this.groupId = x$1;
    }

    private int nextId() {
        return this.nextId;
    }

    private void nextId_$eq(int x$1) {
        this.nextId = x$1;
    }

    public Consumer<byte[], byte[]> _consumer() {
        return this._consumer;
    }

    public void _consumer_$eq(Consumer<byte[], byte[]> x$1) {
        this._consumer = x$1;
    }

    public synchronized Consumer<byte[], byte[]> consumer() {
        block0: {
            Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
            if (this._consumer() != null) break block0;
            HashMap<String, Object> newKafkaParams = new HashMap<String, Object>(this.driverKafkaParams());
            Object object = this.driverKafkaParams().get("group.id") == null ? newKafkaParams.put("group.id", this.nextGroupId()) : BoxedUnit.UNIT;
            this._consumer_$eq(this.consumerStrategy.createConsumer(newKafkaParams));
        }
        return this._consumer();
    }

    @Override
    public int maxOffsetFetchAttempts() {
        return this.maxOffsetFetchAttempts;
    }

    private Option<Object> minPartitions() {
        return this.minPartitions;
    }

    private KafkaOffsetRangeCalculator rangeCalculator() {
        return this.rangeCalculator;
    }

    @Override
    public long offsetFetchAttemptIntervalMs() {
        return this.offsetFetchAttemptIntervalMs;
    }

    private boolean shouldDivvyUpLargePartitions(int numTopicPartitions) {
        return BoxesRunTime.unboxToBoolean((Object)this.minPartitions().map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 > numTopicPartitions).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    private String nextGroupId() {
        this.groupId_$eq(new StringBuilder(1).append(this.driverGroupIdPrefix).append("-").append(this.nextId()).toString());
        this.nextId_$eq(this.nextId() + 1);
        return this.groupId();
    }

    public String toString() {
        return this.consumerStrategy.toString();
    }

    @Override
    public void close() {
        Object object = this._consumer() != null ? this.uninterruptibleThreadRunner().runUninterruptibly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopConsumer()) : BoxedUnit.UNIT;
        this.uninterruptibleThreadRunner().shutdown();
    }

    private scala.collection.immutable.Set<TopicPartition> fetchTopicPartitions() {
        return (scala.collection.immutable.Set)this.uninterruptibleThreadRunner().runUninterruptibly((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
            this.consumer().poll(0L);
            Set partitions = this.consumer().assignment();
            this.consumer().pause((Collection)partitions);
            return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toSet();
        });
    }

    @Override
    public scala.collection.immutable.Map<TopicPartition, Object> fetchPartitionOffsets(KafkaOffsetRangeLimit offsetRangeLimit, boolean isStartingOffsets) {
        scala.collection.immutable.Map<TopicPartition, Object> map;
        scala.collection.immutable.Set<TopicPartition> partitions = this.fetchTopicPartitions();
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = offsetRangeLimit;
        if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            map = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TopicPartition topicPartition = x0$1;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.EARLIEST()));
                return tuple2;
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            map = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TopicPartition topicPartition = x0$2;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST()));
                return tuple2;
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
            SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
            scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets = specificOffsetRangeLimit.partitionOffsets();
            map = this.validateTopicPartitions$1(partitions, partitionOffsets);
        } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
            SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
            scala.collection.immutable.Map<TopicPartition, Object> partitionTimestamps = specificTimestampRangeLimit.topicTimestamps();
            map = this.fetchSpecificTimestampBasedOffsets(partitionTimestamps, isStartingOffsets).partitionToOffsets();
        } else {
            throw new MatchError((Object)kafkaOffsetRangeLimit);
        }
        return map;
    }

    @Override
    public KafkaSourceOffset fetchSpecificOffsets(scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets, Function1<String, BoxedUnit> reportDataLoss) {
        Function1 & Serializable & scala.Serializable fnAssertParametersWithPartitions = (Function1 & Serializable & scala.Serializable)partitions -> {
            KafkaOffsetReaderConsumer.$anonfun$fetchSpecificOffsets$1(this, partitionOffsets, partitions);
            return BoxedUnit.UNIT;
        };
        Function1 & Serializable & scala.Serializable fnRetrievePartitionOffsets = (Function1 & Serializable & scala.Serializable)x$3 -> partitionOffsets;
        Function1 & Serializable & scala.Serializable fnAssertFetchedOffsets = (Function1 & Serializable & scala.Serializable)fetched -> {
            partitionOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KafkaOffsetReaderConsumer.$anonfun$fetchSpecificOffsets$6(fetched, reportDataLoss$1, x0$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        return this.fetchSpecificOffsets0((Function1<Set<TopicPartition>, BoxedUnit>)fnAssertParametersWithPartitions, (Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)fnRetrievePartitionOffsets, (Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit>)fnAssertFetchedOffsets);
    }

    @Override
    public KafkaSourceOffset fetchSpecificTimestampBasedOffsets(scala.collection.immutable.Map<TopicPartition, Object> partitionTimestamps, boolean failsOnNoMatchingOffset) {
        Function1 & Serializable & scala.Serializable fnAssertParametersWithPartitions = (Function1 & Serializable & scala.Serializable)partitions -> {
            KafkaOffsetReaderConsumer.$anonfun$fetchSpecificTimestampBasedOffsets$1(this, partitionTimestamps, partitions);
            return BoxedUnit.UNIT;
        };
        Function1 & Serializable & scala.Serializable fnRetrievePartitionOffsets = (Function1 & Serializable & scala.Serializable)x$4 -> {
            java.util.Map converted = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionTimestamps.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long timestamp = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)timestamp);
                return tuple22;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).asJava();
            java.util.Map offsetForTime = this.consumer().offsetsForTimes(converted);
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetForTime).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                OffsetAndTimestamp offsetAndTimestamp;
                TopicPartition tp;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    tp = (TopicPartition)tuple2._1();
                    offsetAndTimestamp = (OffsetAndTimestamp)tuple2._2();
                    if (failsOnNoMatchingOffset) {
                        Predef$.MODULE$.assert(offsetAndTimestamp != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("No offset matched from request of ").append("topic-partition ").append(tp).append(" and timestamp ").append(partitionTimestamps.apply((Object)tp)).append(".").toString());
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 tuple22 = offsetAndTimestamp == null ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST())) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)offsetAndTimestamp.offset()));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        };
        Function1 & Serializable & scala.Serializable fnAssertFetchedOffsets = (Function1 & Serializable & scala.Serializable)x$5 -> {
            KafkaOffsetReaderConsumer.$anonfun$fetchSpecificTimestampBasedOffsets$8(x$5);
            return BoxedUnit.UNIT;
        };
        return this.fetchSpecificOffsets0((Function1<Set<TopicPartition>, BoxedUnit>)fnAssertParametersWithPartitions, (Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)fnRetrievePartitionOffsets, (Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit>)fnAssertFetchedOffsets);
    }

    private KafkaSourceOffset fetchSpecificOffsets0(Function1<Set<TopicPartition>, BoxedUnit> fnAssertParametersWithPartitions, Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>> fnRetrievePartitionOffsets, Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit> fnAssertFetchedOffsets) {
        scala.collection.immutable.Map<TopicPartition, Object> fetched = this.partitionsAssignedToConsumer((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            fnAssertParametersWithPartitions.apply(partitions);
            scala.collection.immutable.Map partitionOffsets = (scala.collection.immutable.Map)fnRetrievePartitionOffsets.apply(partitions);
            partitionOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KafkaOffsetReaderConsumer.$anonfun$fetchSpecificOffsets0$2(this, x0$1);
                return BoxedUnit.UNIT;
            });
            return (scala.collection.immutable.Map)partitionOffsets.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(tp)));
                return tuple22;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        }, this.partitionsAssignedToConsumer$default$2());
        fnAssertFetchedOffsets.apply(fetched);
        return new KafkaSourceOffset(fetched);
    }

    @Override
    public scala.collection.immutable.Map<TopicPartition, Object> fetchEarliestOffsets() {
        return this.partitionsAssignedToConsumer((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            void var2_2;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to the beginning");
            this.consumer().seekToBeginning((Collection)partitions);
            scala.collection.immutable.Map partitionOffsets = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Got earliest offsets for partition : ").append(partitionOffsets).toString());
            return var2_2;
        }, true);
    }

    @Override
    public scala.collection.immutable.Map<TopicPartition, Object> fetchLatestOffsets(Option<scala.collection.immutable.Map<TopicPartition, Object>> knownOffsets) {
        return this.partitionsAssignedToConsumer((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            scala.collection.immutable.Map map;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to the end.");
            if (knownOffsets.isEmpty()) {
                this.consumer().seekToEnd((Collection)partitions);
                map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            } else {
                ObjectRef partitionOffsets = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
                ObjectRef incorrectOffsets = ObjectRef.create((Object)Nil$.MODULE$);
                int attempt = 0;
                do {
                    this.consumer().seekToEnd((Collection)partitions);
                    partitionOffsets.elem = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    ++attempt;
                    incorrectOffsets.elem = KafkaOffsetReaderConsumer.findIncorrectOffsets$1(partitionOffsets, knownOffsets);
                    if (!((Seq)incorrectOffsets.elem).nonEmpty()) continue;
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Found incorrect offsets in some partitions ").append("(partition, previous offset, fetched offset): ").append((Seq)incorrectOffsets$2.elem).toString());
                    if (attempt >= this.maxOffsetFetchAttempts()) continue;
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Retrying to fetch latest offsets because of incorrect offsets");
                    Thread.sleep(this.offsetFetchAttemptIntervalMs());
                } while (((Seq)incorrectOffsets.elem).nonEmpty() && attempt < this.maxOffsetFetchAttempts());
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Got latest offsets for partition : ").append((scala.collection.immutable.Map)partitionOffsets$4.elem).toString());
                map = (scala.collection.immutable.Map)partitionOffsets.elem;
            }
            return map;
        }, this.partitionsAssignedToConsumer$default$2());
    }

    @Override
    public scala.collection.immutable.Map<TopicPartition, Object> fetchEarliestOffsets(Seq<TopicPartition> newPartitions) {
        return newPartitions.isEmpty() ? Predef$.MODULE$.Map().empty() : this.partitionsAssignedToConsumer((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            void var3_3;
            this.consumer().seekToBeginning((Collection)partitions);
            scala.collection.immutable.Map partitionOffsets = ((TraversableOnce)((TraversableLike)newPartitions.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)partitions.contains(p)))).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Got earliest offsets for new partitions: ").append(partitionOffsets).toString());
            return var3_3;
        }, true);
    }

    @Override
    public Seq<KafkaOffsetRange> getOffsetRangesFromUnresolvedOffsets(KafkaOffsetRangeLimit startingOffsets, KafkaOffsetRangeLimit endingOffsets) {
        Seq seq;
        scala.collection.immutable.Map<TopicPartition, Object> fromPartitionOffsets = this.fetchPartitionOffsets(startingOffsets, true);
        scala.collection.immutable.Map<TopicPartition, Object> untilPartitionOffsets = this.fetchPartitionOffsets(endingOffsets, false);
        scala.collection.immutable.Set set = fromPartitionOffsets.keySet();
        scala.collection.immutable.Set set2 = untilPartitionOffsets.keySet();
        if (set == null ? set2 != null : !set.equals(set2)) {
            Ordering topicOrdering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)t -> t.topic(), (Ordering)Ordering.String$.MODULE$);
            String fromTopics = ((TraversableOnce)fromPartitionOffsets.keySet().toList().sorted(topicOrdering)).mkString(",");
            String untilTopics = ((TraversableOnce)untilPartitionOffsets.keySet().toList().sorted(topicOrdering)).mkString(",");
            throw new IllegalStateException(new StringBuilder(84).append("different topic partitions ").append("for starting offsets topics[").append(fromTopics).append("] and ").append("ending offsets topics[").append(untilTopics).append("]").toString());
        }
        Seq offsetRangesBase = ((SetLike)untilPartitionOffsets.keySet().map((Function1 & Serializable & scala.Serializable)tp -> {
            long fromOffset = BoxesRunTime.unboxToLong((Object)fromPartitionOffsets.get(tp).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(27).append(tp).append(" doesn't have a from offset").toString());
            }));
            long untilOffset = BoxesRunTime.unboxToLong((Object)untilPartitionOffsets.apply(tp));
            return new KafkaOffsetRange((TopicPartition)tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
        }, Set$.MODULE$.canBuildFrom())).toSeq();
        if (this.shouldDivvyUpLargePartitions(offsetRangesBase.size())) {
            scala.collection.immutable.Map fromOffsetsMap = ((TraversableOnce)offsetRangesBase.map((Function1 & Serializable & scala.Serializable)range -> new Tuple2((Object)range.topicPartition(), (Object)BoxesRunTime.boxToLong((long)range.fromOffset())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            scala.collection.immutable.Map untilOffsetsMap = ((TraversableOnce)offsetRangesBase.map((Function1 & Serializable & scala.Serializable)range -> new Tuple2((Object)range.topicPartition(), (Object)BoxesRunTime.boxToLong((long)range.untilOffset())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            scala.collection.immutable.Map<TopicPartition, Object> resolvedFromOffsets = this.fetchSpecificOffsets((scala.collection.immutable.Map<TopicPartition, Object>)fromOffsetsMap, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$7 -> {
                KafkaOffsetReaderConsumer.$anonfun$getOffsetRangesFromUnresolvedOffsets$6(x$7);
                return BoxedUnit.UNIT;
            }).partitionToOffsets();
            scala.collection.immutable.Map<TopicPartition, Object> resolvedUntilOffsets = this.fetchSpecificOffsets((scala.collection.immutable.Map<TopicPartition, Object>)untilOffsetsMap, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$8 -> {
                KafkaOffsetReaderConsumer.$anonfun$getOffsetRangesFromUnresolvedOffsets$7(x$8);
                return BoxedUnit.UNIT;
            }).partitionToOffsets();
            Seq ranges = (Seq)((TraversableLike)offsetRangesBase.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.topicPartition(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)tp -> new KafkaOffsetRange((TopicPartition)tp, BoxesRunTime.unboxToLong((Object)resolvedFromOffsets.apply(tp)), BoxesRunTime.unboxToLong((Object)resolvedUntilOffsets.apply(tp)), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom());
            scala.collection.immutable.Map divvied = this.rangeCalculator().getRanges((Seq<KafkaOffsetRange>)ranges, this.rangeCalculator().getRanges$default$2()).groupBy((Function1 & Serializable & scala.Serializable)x$10 -> x$10.topicPartition());
            seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)divvied.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Seq seq;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Seq splitOffsetRanges = (Seq)tuple2._2();
                    if (splitOffsetRanges.length() == 1) {
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange(tp, BoxesRunTime.unboxToLong((Object)fromOffsetsMap.apply((Object)tp)), BoxesRunTime.unboxToLong((Object)untilOffsetsMap.apply((Object)tp)), (Option<String>)None$.MODULE$)}));
                    } else {
                        KafkaOffsetRange qual$1 = (KafkaOffsetRange)splitOffsetRanges.head();
                        long x$1 = BoxesRunTime.unboxToLong((Object)fromOffsetsMap.apply((Object)tp));
                        TopicPartition x$2 = qual$1.copy$default$1();
                        long x$3 = qual$1.copy$default$3();
                        Option<String> x$4 = qual$1.copy$default$4();
                        KafkaOffsetRange first = qual$1.copy(x$2, x$1, x$3, x$4);
                        KafkaOffsetRange qual$2 = (KafkaOffsetRange)splitOffsetRanges.last();
                        long x$5 = BoxesRunTime.unboxToLong((Object)untilOffsetsMap.apply((Object)tp));
                        TopicPartition x$6 = qual$2.copy$default$1();
                        long x$7 = qual$2.copy$default$2();
                        Option<String> x$8 = qual$2.copy$default$4();
                        KafkaOffsetRange end = qual$2.copy(x$6, x$7, x$5, x$8);
                        seq = (Seq)((SeqLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{first}))).$plus$plus((GenTraversableOnce)((IterableLike)splitOffsetRanges.drop(1)).dropRight(1), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)end, Seq$.MODULE$.canBuildFrom());
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Seq seq2 = seq;
                return seq2;
            }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(KafkaOffsetRange.class)))).toSeq();
        } else {
            seq = offsetRangesBase;
        }
        return seq;
    }

    private String[] getSortedExecutorList() {
        BlockManager bm = SparkEnv$.MODULE$.get().blockManager();
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bm.master().getPeers(bm.blockManagerId()).toArray(ClassTag$.MODULE$.apply(BlockManagerId.class)))).map((Function1 & Serializable & scala.Serializable)x -> new ExecutorCacheTaskLocation(x.host(), x.executorId()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExecutorCacheTaskLocation.class))))).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetReaderConsumer.compare$1(a, b))))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    @Override
    public Seq<KafkaOffsetRange> getOffsetRangesFromResolvedOffsets(scala.collection.immutable.Map<TopicPartition, Object> fromPartitionOffsets, scala.collection.immutable.Map<TopicPartition, Object> untilPartitionOffsets, Function1<String, BoxedUnit> reportDataLoss) {
        Object object;
        Object object2;
        scala.collection.immutable.Set newPartitions = (scala.collection.immutable.Set)untilPartitionOffsets.keySet().diff((GenSet)fromPartitionOffsets.keySet());
        scala.collection.immutable.Map<TopicPartition, Object> newPartitionInitialOffsets = this.fetchEarliestOffsets((Seq<TopicPartition>)newPartitions.toSeq());
        scala.collection.immutable.Set set = newPartitionInitialOffsets.keySet();
        scala.collection.immutable.Set set2 = newPartitions;
        if (set == null ? set2 != null : !set.equals(set2)) {
            scala.collection.immutable.Set deletedPartitions = (scala.collection.immutable.Set)newPartitions.diff((GenSet)newPartitionInitialOffsets.keySet());
            object2 = reportDataLoss.apply((Object)new StringBuilder(64).append("Cannot find earliest offsets of ").append(deletedPartitions).append(". Some data may have been missed").toString());
        } else {
            object2 = BoxedUnit.UNIT;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Partitions added: ").append(newPartitionInitialOffsets).toString());
        ((IterableLike)newPartitionInitialOffsets.filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetReaderConsumer.$anonfun$getOffsetRangesFromResolvedOffsets$2(x$12)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaOffsetReaderConsumer.$anonfun$getOffsetRangesFromResolvedOffsets$3(reportDataLoss, x0$1);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set deletedPartitions = (scala.collection.immutable.Set)fromPartitionOffsets.keySet().diff((GenSet)untilPartitionOffsets.keySet());
        if (deletedPartitions.nonEmpty()) {
            String message = this.driverKafkaParams().containsKey("group.id") ? new StringBuilder(11).append(deletedPartitions).append(" are gone. ").append(KafkaSourceProvider$.MODULE$.CUSTOM_GROUP_ID_ERROR_MESSAGE()).toString() : new StringBuilder(42).append(deletedPartitions).append(" are gone. Some data may have been missed.").toString();
            object = reportDataLoss.apply((Object)message);
        } else {
            object = BoxedUnit.UNIT;
        }
        Seq topicPartitions = ((SetLike)untilPartitionOffsets.keySet().filter((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetReaderConsumer.$anonfun$getOffsetRangesFromResolvedOffsets$4(newPartitionInitialOffsets, fromPartitionOffsets, tp)))).toSeq();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("TopicPartitions: ").append(topicPartitions.mkString(", ")).toString());
        scala.collection.immutable.Map fromOffsets = fromPartitionOffsets.$plus$plus(newPartitionInitialOffsets);
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = untilPartitionOffsets;
        Seq ranges = (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> {
            long fromOffset = BoxesRunTime.unboxToLong((Object)fromOffsets.apply(tp));
            long untilOffset = BoxesRunTime.unboxToLong((Object)untilOffsets.apply(tp));
            Object object = untilOffset < fromOffset ? reportDataLoss.apply((Object)new StringBuilder(73).append("Partition ").append(tp).append("'s offset was changed from ").append(fromOffset).append(" to ").append(untilOffset).append(", some data may have been missed").toString()) : BoxedUnit.UNIT;
            return new KafkaOffsetRange((TopicPartition)tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom());
        return this.rangeCalculator().getRanges((Seq<KafkaOffsetRange>)ranges, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.getSortedExecutorList()));
    }

    private scala.collection.immutable.Map<TopicPartition, Object> partitionsAssignedToConsumer(Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>> body, boolean fetchingEarliestOffset) {
        return (scala.collection.immutable.Map)this.uninterruptibleThreadRunner().runUninterruptibly((Function0 & Serializable & scala.Serializable)() -> this.withRetriesWithoutInterrupt((Function0<scala.collection.immutable.Map<TopicPartition, Object>>)(Function0 & Serializable & scala.Serializable)() -> {
            this.consumer().poll(0L);
            Set partitions = this.consumer().assignment();
            if (!fetchingEarliestOffset) {
                ((IterableLike)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                    KafkaOffsetReaderConsumer.$anonfun$partitionsAssignedToConsumer$4(x$13);
                    return BoxedUnit.UNIT;
                });
            }
            this.consumer().pause((Collection)partitions);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Partitions assigned to consumer: ").append(partitions).append(".").toString());
            return (scala.collection.immutable.Map)body.apply((Object)partitions);
        }));
    }

    private boolean partitionsAssignedToConsumer$default$2() {
        return false;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> withRetriesWithoutInterrupt(Function0<scala.collection.immutable.Map<TopicPartition, Object>> body) {
        scala.collection.immutable.Map map;
        Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
        KafkaOffsetReaderConsumer kafkaOffsetReaderConsumer = this;
        synchronized (kafkaOffsetReaderConsumer) {
            ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
            IntRef attempt = IntRef.create((int)1);
            ObjectRef lastException = ObjectRef.create(null);
            while (((Option)result.elem).isEmpty() && attempt.elem <= this.maxOffsetFetchAttempts() && !Thread.currentThread().isInterrupted()) {
                Thread thread = Thread.currentThread();
                if (thread instanceof UninterruptibleThread) {
                    UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
                    BoxedUnit boxedUnit = (BoxedUnit)uninterruptibleThread.runUninterruptibly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        try {
                            result$1.elem = new Some(body.apply());
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (!option.isEmpty()) {
                                Throwable e = (Throwable)option.get();
                                lastException$1.elem = e;
                                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Error in attempt ").append(attempt$1.elem).append(" getting Kafka offsets: ").toString(), e);
                                ++attempt$1.elem;
                                Thread.sleep(this.offsetFetchAttemptIntervalMs());
                                this.resetConsumer();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            throw throwable;
                        }
                    });
                    continue;
                }
                throw new IllegalStateException("Kafka APIs must be executed on a o.a.spark.util.UninterruptibleThread");
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (((Option)result.elem).isEmpty()) {
                Predef$.MODULE$.assert(attempt.elem > this.maxOffsetFetchAttempts());
                Predef$.MODULE$.assert((Throwable)lastException.elem != null);
                throw (Throwable)lastException.elem;
            }
            map = (scala.collection.immutable.Map)((Option)result.elem).get();
        }
        return map;
    }

    private synchronized void stopConsumer() {
        block0: {
            Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
            if (this._consumer() == null) break block0;
            this._consumer().close();
        }
    }

    private synchronized void resetConsumer() {
        this.stopConsumer();
        this._consumer_$eq(null);
    }

    public static final /* synthetic */ int $anonfun$minPartitions$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    private final scala.collection.immutable.Map validateTopicPartitions$1(scala.collection.immutable.Set partitions, scala.collection.immutable.Map partitionOffsets) {
        scala.collection.immutable.Set set = partitions;
        scala.collection.immutable.Set set2 = partitionOffsets.keySet();
        Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(142).append("If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest.\n").append("Specified: ").append(partitionOffsets.keySet()).append(" Assigned: ").append(partitions).toString());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Partitions assigned to consumer: ").append(partitions).append(". Seeking to ").append(partitionOffsets).toString());
        return partitionOffsets;
    }

    public static final /* synthetic */ void $anonfun$fetchSpecificOffsets$1(KafkaOffsetReaderConsumer $this, scala.collection.immutable.Map partitionOffsets$2, Set partitions) {
        Object object = JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala();
        scala.collection.immutable.Set set = partitionOffsets$2.keySet();
        Predef$.MODULE$.assert(!(object != null ? !object.equals(set) : set != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(161).append("If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest, if you don't care.\n").append("Specified: ").append(partitionOffsets$2.keySet()).append(" Assigned: ").append(JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toString());
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Partitions assigned to consumer: ").append(partitions).append(". Seeking to ").append(partitionOffsets$2).toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$fetchSpecificOffsets$6(scala.collection.immutable.Map fetched$1, Function1 reportDataLoss$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            long off = tuple2._2$mcJ$sp();
            if (off != KafkaOffsetRangeLimit$.MODULE$.LATEST() && off != KafkaOffsetRangeLimit$.MODULE$.EARLIEST()) {
                BoxedUnit boxedUnit = BoxesRunTime.unboxToLong((Object)fetched$1.apply((Object)tp)) != off ? (BoxedUnit)reportDataLoss$1.apply((Object)new StringBuilder(48).append("startingOffsets for ").append(tp).append(" was ").append(off).append(" but consumer reset to ").append(fetched$1.apply((Object)tp)).toString()) : BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$fetchSpecificTimestampBasedOffsets$1(KafkaOffsetReaderConsumer $this, scala.collection.immutable.Map partitionTimestamps$1, Set partitions) {
        Object object = JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala();
        scala.collection.immutable.Set set = partitionTimestamps$1.keySet();
        Predef$.MODULE$.assert(!(object != null ? !object.equals(set) : set != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append("If starting/endingOffsetsByTimestamp contains specific offsets, you must specify all ").append("topics. Specified: ").append(partitionTimestamps$1.keySet()).append(" Assigned: ").append(JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toString());
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Partitions assigned to consumer: ").append(partitions).append(". Seeking to ").append(partitionTimestamps$1).toString());
    }

    public static final /* synthetic */ void $anonfun$fetchSpecificTimestampBasedOffsets$8(scala.collection.immutable.Map x$5) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$fetchSpecificOffsets0$2(KafkaOffsetReaderConsumer $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            if (KafkaOffsetRangeLimit$.MODULE$.LATEST() == l) {
                $this.consumer().seekToEnd(Arrays.asList((Object[])new TopicPartition[]{tp}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            if (KafkaOffsetRangeLimit$.MODULE$.EARLIEST() == l) {
                $this.consumer().seekToBeginning(Arrays.asList((Object[])new TopicPartition[]{tp}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicPartition tp = (TopicPartition)tuple2._1();
        long off = tuple2._2$mcJ$sp();
        $this.consumer().seek(tp, off);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$fetchLatestOffsets$6(long offset$1, TopicPartition tp$2, ObjectRef incorrectOffsets$1, long knownOffset) {
        BoxedUnit boxedUnit;
        if (knownOffset > offset$1) {
            Tuple3 incorrectOffset = new Tuple3((Object)tp$2, (Object)BoxesRunTime.boxToLong((long)knownOffset), (Object)BoxesRunTime.boxToLong((long)offset$1));
            boxedUnit = ((ArrayBuffer)incorrectOffsets$1.elem).$plus$eq((Object)incorrectOffset);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$fetchLatestOffsets$5(TopicPartition tp$2, long offset$1, ObjectRef incorrectOffsets$1, scala.collection.immutable.Map x$6) {
        x$6.get((Object)tp$2).foreach((Function1 & Serializable & scala.Serializable)knownOffset -> KafkaOffsetReaderConsumer.$anonfun$fetchLatestOffsets$6(offset$1, tp$2, incorrectOffsets$1, BoxesRunTime.unboxToLong((Object)knownOffset)));
    }

    public static final /* synthetic */ void $anonfun$fetchLatestOffsets$4(Option knownOffsets$1, ObjectRef incorrectOffsets$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        knownOffsets$1.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            KafkaOffsetReaderConsumer.$anonfun$fetchLatestOffsets$5(tp, offset, incorrectOffsets$1, x$6);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final Seq findIncorrectOffsets$1(ObjectRef partitionOffsets$4, Option knownOffsets$1) {
        ObjectRef incorrectOffsets = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        ((scala.collection.immutable.Map)partitionOffsets$4.elem).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaOffsetReaderConsumer.$anonfun$fetchLatestOffsets$4(knownOffsets$1, incorrectOffsets, x0$1);
            return BoxedUnit.UNIT;
        });
        return ((ArrayBuffer)incorrectOffsets.elem).toSeq();
    }

    public static final /* synthetic */ void $anonfun$getOffsetRangesFromUnresolvedOffsets$6(String x$7) {
    }

    public static final /* synthetic */ void $anonfun$getOffsetRangesFromUnresolvedOffsets$7(String x$8) {
    }

    private static final boolean compare$1(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
        String string = a.host();
        String string2 = b.host();
        return !(string != null ? !string.equals(string2) : string2 != null) ? new StringOps(Predef$.MODULE$.augmentString(a.executorId())).$greater((Object)b.executorId()) : new StringOps(Predef$.MODULE$.augmentString(a.host())).$greater((Object)b.host());
    }

    public static final /* synthetic */ boolean $anonfun$getOffsetRangesFromResolvedOffsets$2(Tuple2 x$12) {
        return x$12._2$mcJ$sp() != 0L;
    }

    public static final /* synthetic */ void $anonfun$getOffsetRangesFromResolvedOffsets$3(Function1 reportDataLoss$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition p = (TopicPartition)tuple2._1();
        long o = tuple2._2$mcJ$sp();
        BoxedUnit boxedUnit = (BoxedUnit)reportDataLoss$2.apply((Object)new StringBuilder(74).append("Added partition ").append(p).append(" starts from ").append(o).append(" instead of 0. Some data may have been missed").toString());
    }

    public static final /* synthetic */ boolean $anonfun$getOffsetRangesFromResolvedOffsets$4(scala.collection.immutable.Map newPartitionInitialOffsets$1, scala.collection.immutable.Map fromPartitionOffsets$2, TopicPartition tp) {
        return newPartitionInitialOffsets$1.contains((Object)tp) || fromPartitionOffsets$2.contains((Object)tp);
    }

    public static final /* synthetic */ void $anonfun$partitionsAssignedToConsumer$4(Tuple2 x$13) {
    }

    public KafkaOffsetReaderConsumer(ConsumerStrategy consumerStrategy, java.util.Map<String, Object> driverKafkaParams, CaseInsensitiveMap<String> readerOptions, String driverGroupIdPrefix) {
        this.consumerStrategy = consumerStrategy;
        this.driverKafkaParams = driverKafkaParams;
        this.driverGroupIdPrefix = driverGroupIdPrefix;
        Logging.$init$((Logging)this);
        this.uninterruptibleThreadRunner = new UninterruptibleThreadRunner("Kafka Offset Reader");
        this.groupId = null;
        this.nextId = 0;
        this._consumer = null;
        this.maxOffsetFetchAttempts = new StringOps(Predef$.MODULE$.augmentString((String)readerOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.FETCH_OFFSET_NUM_RETRY(), (Function0 & Serializable & scala.Serializable)() -> "3"))).toInt();
        this.minPartitions = readerOptions.get(KafkaSourceProvider$.MODULE$.MIN_PARTITIONS_OPTION_KEY()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)KafkaOffsetReaderConsumer.$anonfun$minPartitions$1(x$1)));
        this.rangeCalculator = new KafkaOffsetRangeCalculator(this.minPartitions());
        this.offsetFetchAttemptIntervalMs = new StringOps(Predef$.MODULE$.augmentString((String)readerOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.FETCH_OFFSET_RETRY_INTERVAL_MS(), (Function0 & Serializable & scala.Serializable)() -> "1000"))).toLong();
    }
}

