/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010.consumer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager$;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaTokenUtil$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.consumer.FetchedData;
import org.apache.spark.sql.kafka010.consumer.FetchedDataPool;
import org.apache.spark.sql.kafka010.consumer.FetchedRecord;
import org.apache.spark.sql.kafka010.consumer.InternalKafkaConsumer;
import org.apache.spark.sql.kafka010.consumer.InternalKafkaConsumerPool;
import org.apache.spark.sql.kafka010.consumer.KafkaDataConsumer$;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r%g!\u00022d\u0001\u0015|\u0007\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011\u0002@\t\u0015\u00055\u0001A!A!\u0002\u0013\ty\u0001\u0003\u0006\u0002B\u0001\u0011\t\u0011)A\u0005\u0003\u0007B!\"a\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA'\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+B\u0011\"!\u0019\u0001\u0005\u0004%I!a\u0019\t\u0011\u0005-\u0004\u0001)A\u0005\u0003KB!\"!\u001c\u0001\u0001\u0004%\taYA8\u0011)\ti\b\u0001a\u0001\n\u0003\u0019\u0017q\u0010\u0005\t\u0003\u0017\u0003\u0001\u0015)\u0003\u0002r!I\u0011Q\u0013\u0001A\u0002\u0013%\u0011q\u0013\u0005\n\u0003C\u0003\u0001\u0019!C\u0005\u0003GC\u0001\"a*\u0001A\u0003&\u0011\u0011\u0014\u0005\n\u0003W\u0003!\u0019!C\u0005\u0003[C\u0001\"a,\u0001A\u0003%\u0011q\u0004\u0005\n\u0003c\u0003!\u0019!C\u0005\u0003gC\u0001b!\u0005\u0001A\u0003%\u0011Q\u0017\u0005\n\u0007'\u0001!\u0019!C\u0005\u0007+A\u0001b!\b\u0001A\u0003%1q\u0003\u0005\b\u0007?\u0001A\u0011AB\u0011\u0011\u001d\u0019Y\u0005\u0001C\u0001\u0007\u001bBqa!\u0015\u0001\t\u0003\u0019\u0019\u0006C\u0004\u0004V\u0001!Iaa\u0015\t\u000f\r]\u0003\u0001\"\u0003\u0004T!91\u0011\f\u0001\u0005\n\rm\u0003bBB2\u0001\u0011%1Q\r\u0005\b\u0007k\u0002A\u0011BB<\u0011!\u0019\t\t\u0001C\u0001K\u000e\r\u0005bBBC\u0001\u0011%11\u000b\u0005\b\u0007\u000f\u0003A\u0011BBE\u0011\u001d\u0019i\t\u0001C\u0005\u0007\u001fCqaa&\u0001\t\u0013\u0019I\nC\u0005\u0004(\u0002\t\n\u0011\"\u0003\u0004\u000e!91\u0011\u0016\u0001\u0005\n\r-v\u0001CA]G\"\u0005Q-a/\u0007\u000f\t\u001c\u0007\u0012A3\u0002>\"9\u00111\u000b\u0013\u0005\u0002\u0005}\u0006\"CAaI\t\u0007I\u0011AAb\u0011!\tY\r\nQ\u0001\n\u0005\u0015gABAgI\u0001\u000by\r\u0003\u0006\u0002^\"\u0012)\u001a!C\u0001\u0003\u0007D!\"a8)\u0005#\u0005\u000b\u0011BAc\u0011)\t\t\u000f\u000bBK\u0002\u0013\u0005\u00111\u0019\u0005\u000b\u0003GD#\u0011#Q\u0001\n\u0005\u0015\u0007bBA*Q\u0011\u0005\u0011Q\u001d\u0005\n\u0003_D\u0013\u0011!C\u0001\u0003cD\u0011\"a>)#\u0003%\t!!?\t\u0013\t=\u0001&%A\u0005\u0002\u0005e\b\"\u0003B\tQ\u0005\u0005I\u0011\tB\n\u0011%\u0011I\u0002KA\u0001\n\u0003\u0011Y\u0002C\u0005\u0003$!\n\t\u0011\"\u0001\u0003&!I!q\u0006\u0015\u0002\u0002\u0013\u0005#\u0011\u0007\u0005\n\u0005\u007fA\u0013\u0011!C\u0001\u0005\u0003B\u0011B!\u0012)\u0003\u0003%\tEa\u0012\t\u0013\t%\u0003&!A\u0005B\t-\u0003\"\u0003B'Q\u0005\u0005I\u0011\tB(\u000f%\u0011\u0019\u0006JA\u0001\u0012\u0003\u0011)FB\u0005\u0002N\u0012\n\t\u0011#\u0001\u0003X!9\u00111\u000b\u001e\u0005\u0002\t\u0015\u0004\"\u0003B%u\u0005\u0005IQ\tB&\u0011%\u00119GOA\u0001\n\u0003\u0013I\u0007C\u0005\u0003pi\n\t\u0011\"!\u0003r!I!q\u0010\u001e\u0002\u0002\u0013%!\u0011\u0011\u0004\u0007\u0005\u0007#\u0003I!\"\t\u0015\u0005-\u0006I!f\u0001\n\u0003\ti\u000b\u0003\u0006\u00020\u0002\u0013\t\u0012)A\u0005\u0003?A\u0011\u0002 !\u0003\u0016\u0004%\tAa\"\t\u0013\t%\u0005I!E!\u0002\u0013q\bbBA*\u0001\u0012\u0005!1\u0012\u0005\b\u0003'\u0002E\u0011\u0001BJ\u0011%\ty\u000fQA\u0001\n\u0003\u0011I\nC\u0005\u0002x\u0002\u000b\n\u0011\"\u0001\u0003 \"I!q\u0002!\u0012\u0002\u0013\u0005!1\u0015\u0005\n\u0005#\u0001\u0015\u0011!C!\u0005'A\u0011B!\u0007A\u0003\u0003%\tAa\u0007\t\u0013\t\r\u0002)!A\u0005\u0002\t\u001d\u0006\"\u0003B\u0018\u0001\u0006\u0005I\u0011\tB\u0019\u0011%\u0011y\u0004QA\u0001\n\u0003\u0011Y\u000bC\u0005\u0003F\u0001\u000b\t\u0011\"\u0011\u0003H!I!\u0011\n!\u0002\u0002\u0013\u0005#1\n\u0005\n\u0005\u001b\u0002\u0015\u0011!C!\u0005_;\u0011Ba-%\u0003\u0003E\tA!.\u0007\u0013\t\rE%!A\t\u0002\t]\u0006bBA*'\u0012\u0005!1\u0018\u0005\n\u0005\u0013\u001a\u0016\u0011!C#\u0005\u0017B\u0011Ba\u001aT\u0003\u0003%\tI!0\t\u0013\t=4+!A\u0005\u0002\n\r\u0007\"\u0003B@'\u0006\u0005I\u0011\u0002BA\u0011%\u0011Y\r\nb\u0001\n\u0013\u0011i\r\u0003\u0005\u0003X\u0012\u0002\u000b\u0011\u0002Bh\u0011%\t\t\u0005\nb\u0001\n\u0013\u0011I\u000e\u0003\u0005\u0003\\\u0012\u0002\u000b\u0011BA\"\u0011%\tY\u0005\nb\u0001\n\u0013\u0011i\u000e\u0003\u0005\u0003`\u0012\u0002\u000b\u0011BA'\u0011\u001d\u0011\t\u000f\nC\u0001\u0005GDqA!;%\t\u0013\u0011Y\u000fC\u0005\u0004\f\u0011\n\n\u0011\"\u0003\u0004\u000e\t\t2*\u00194lC\u0012\u000bG/Y\"p]N,X.\u001a:\u000b\u0005\u0011,\u0017\u0001C2p]N,X.\u001a:\u000b\u0005\u0019<\u0017\u0001C6bM.\f\u0007'\r\u0019\u000b\u0005!L\u0017aA:rY*\u0011!n[\u0001\u0006gB\f'o\u001b\u0006\u0003Y6\fa!\u00199bG\",'\"\u00018\u0002\u0007=\u0014xmE\u0002\u0001aZ\u0004\"!\u001d;\u000e\u0003IT\u0011a]\u0001\u0006g\u000e\fG.Y\u0005\u0003kJ\u0014a!\u00118z%\u00164\u0007CA<{\u001b\u0005A(BA=j\u0003!Ig\u000e^3s]\u0006d\u0017BA>y\u0005\u001daunZ4j]\u001e\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u0001\u0001\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u0019\u0019w.\\7p]*\u0019\u0011qA6\u0002\u000b-\fgm[1\n\t\u0005-\u0011\u0011\u0001\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003-Y\u0017MZ6b!\u0006\u0014\u0018-\\:\u0011\u0011\u0005E\u00111DA\u0010\u0003ki!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0005kRLGN\u0003\u0002\u0002\u001a\u0005!!.\u0019<b\u0013\u0011\ti\"a\u0005\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\"\u0005=b\u0002BA\u0012\u0003W\u00012!!\ns\u001b\t\t9CC\u0002\u0002*u\fa\u0001\u0010:p_Rt\u0014bAA\u0017e\u00061\u0001K]3eK\u001aLA!!\r\u00024\t11\u000b\u001e:j]\u001eT1!!\fs!\u0011\t9$!\u0010\u000e\u0005\u0005e\"\u0002BA\u001e\u0003/\tA\u0001\\1oO&!\u0011qHA\u001d\u0005\u0019y%M[3di\u0006a1m\u001c8tk6,'\u000fU8pYB!\u0011QIA$\u001b\u0005\u0019\u0017bAA%G\nI\u0012J\u001c;fe:\fGnS1gW\u0006\u001cuN\\:v[\u0016\u0014\bk\\8m\u0003=1W\r^2iK\u0012$\u0015\r^1Q_>d\u0007\u0003BA#\u0003\u001fJ1!!\u0015d\u0005=1U\r^2iK\u0012$\u0015\r^1Q_>d\u0017A\u0002\u001fj]&$h\b\u0006\u0006\u0002X\u0005e\u00131LA/\u0003?\u00022!!\u0012\u0001\u0011\u0015aX\u00011\u0001\u007f\u0011\u001d\ti!\u0002a\u0001\u0003\u001fAq!!\u0011\u0006\u0001\u0004\t\u0019\u0005C\u0004\u0002L\u0015\u0001\r!!\u0014\u0002-%\u001cHk\\6f]B\u0013xN^5eKJ,e.\u00192mK\u0012,\"!!\u001a\u0011\u0007E\f9'C\u0002\u0002jI\u0014qAQ8pY\u0016\fg.A\fjgR{7.\u001a8Qe>4\u0018\u000eZ3s\u000b:\f'\r\\3eA\u0005IqlY8ogVlWM]\u000b\u0003\u0003c\u0002R!]A:\u0003oJ1!!\u001es\u0005\u0019y\u0005\u000f^5p]B!\u0011QIA=\u0013\r\tYh\u0019\u0002\u0016\u0013:$XM\u001d8bY.\u000bgm[1D_:\u001cX/\\3s\u00035y6m\u001c8tk6,'o\u0018\u0013fcR!\u0011\u0011QAD!\r\t\u00181Q\u0005\u0004\u0003\u000b\u0013(\u0001B+oSRD\u0011\"!#\n\u0003\u0003\u0005\r!!\u001d\u0002\u0007a$\u0013'\u0001\u0006`G>t7/^7fe\u0002B3ACAH!\r\t\u0018\u0011S\u0005\u0004\u0003'\u0013(\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0019}3W\r^2iK\u0012$\u0015\r^1\u0016\u0005\u0005e\u0005#B9\u0002t\u0005m\u0005\u0003BA#\u0003;K1!a(d\u0005-1U\r^2iK\u0012$\u0015\r^1\u0002!}3W\r^2iK\u0012$\u0015\r^1`I\u0015\fH\u0003BAA\u0003KC\u0011\"!#\r\u0003\u0003\u0005\r!!'\u0002\u001b}3W\r^2iK\u0012$\u0015\r^1!Q\ri\u0011qR\u0001\bOJ|W\u000f]%e+\t\ty\"\u0001\u0005he>,\b/\u00133!\u0003!\u0019\u0017m\u00195f\u0017\u0016LXCAA[!\r\t9\f\u0011\b\u0004\u0003\u000b\u001a\u0013!E&bM.\fG)\u0019;b\u0007>t7/^7feB\u0019\u0011Q\t\u0013\u0014\u0007\u0011\u0002h\u000f\u0006\u0002\u0002<\u0006qQKT&O\u001f^sul\u0014$G'\u0016#VCAAc!\r\t\u0018qY\u0005\u0004\u0003\u0013\u0014(\u0001\u0002'p]\u001e\fq\"\u0016(L\u001d>;fjX(G\rN+E\u000b\t\u0002\u0015\u0003Z\f\u0017\u000e\\1cY\u0016|eMZ:fiJ\u000bgnZ3\u0014\r!\u0002\u0018\u0011[Al!\r\t\u00181[\u0005\u0004\u0003+\u0014(a\u0002)s_\u0012,8\r\u001e\t\u0004c\u0006e\u0017bAAne\na1+\u001a:jC2L'0\u00192mK\u0006AQ-\u0019:mS\u0016\u001cH/A\u0005fCJd\u0017.Z:uA\u00051A.\u0019;fgR\fq\u0001\\1uKN$\b\u0005\u0006\u0004\u0002h\u0006-\u0018Q\u001e\t\u0004\u0003SDS\"\u0001\u0013\t\u000f\u0005uW\u00061\u0001\u0002F\"9\u0011\u0011]\u0017A\u0002\u0005\u0015\u0017\u0001B2paf$b!a:\u0002t\u0006U\b\"CAo]A\u0005\t\u0019AAc\u0011%\t\tO\fI\u0001\u0002\u0004\t)-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005m(\u0006BAc\u0003{\\#!a@\u0011\t\t\u0005!1B\u0007\u0003\u0005\u0007QAA!\u0002\u0003\b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0013\u0011\u0018AC1o]>$\u0018\r^5p]&!!Q\u0002B\u0002\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u0003\t\u0005\u0003o\u00119\"\u0003\u0003\u00022\u0005e\u0012\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u000f!\r\t(qD\u0005\u0004\u0005C\u0011(aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u0014\u0005[\u00012!\u001dB\u0015\u0013\r\u0011YC\u001d\u0002\u0004\u0003:L\b\"CAEg\u0005\u0005\t\u0019\u0001B\u000f\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u001a!\u0019\u0011)Da\u000f\u0003(5\u0011!q\u0007\u0006\u0004\u0005s\u0011\u0018AC2pY2,7\r^5p]&!!Q\bB\u001c\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0015$1\t\u0005\n\u0003\u0013+\u0014\u0011!a\u0001\u0005O\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005;\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005+\ta!Z9vC2\u001cH\u0003BA3\u0005#B\u0011\"!#9\u0003\u0003\u0005\rAa\n\u0002)\u00053\u0018-\u001b7bE2,wJ\u001a4tKR\u0014\u0016M\\4f!\r\tIOO\n\u0006u\te\u0013q\u001b\t\u000b\u00057\u0012\t'!2\u0002F\u0006\u001dXB\u0001B/\u0015\r\u0011yF]\u0001\beVtG/[7f\u0013\u0011\u0011\u0019G!\u0018\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003V\u0005)\u0011\r\u001d9msR1\u0011q\u001dB6\u0005[Bq!!8>\u0001\u0004\t)\rC\u0004\u0002bv\u0002\r!!2\u0002\u000fUt\u0017\r\u001d9msR!!1\u000fB>!\u0015\t\u00181\u000fB;!\u001d\t(qOAc\u0003\u000bL1A!\u001fs\u0005\u0019!V\u000f\u001d7fe!I!Q\u0010 \u0002\u0002\u0003\u0007\u0011q]\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u000e\u0003\u0011\r\u000b7\r[3LKf\u001cb\u0001\u00119\u0002R\u0006]W#\u0001@\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\"bA!$\u0003\u0010\nE\u0005cAAu\u0001\"9\u00111V#A\u0002\u0005}\u0001\"\u0002?F\u0001\u0004qHC\u0002BG\u0005+\u00139\nC\u0003}\r\u0002\u0007a\u0010C\u0004\u0002\u000e\u0019\u0003\r!a\u0004\u0015\r\t5%1\u0014BO\u0011%\tYk\u0012I\u0001\u0002\u0004\ty\u0002C\u0004}\u000fB\u0005\t\u0019\u0001@\u0016\u0005\t\u0005&\u0006BA\u0010\u0003{,\"A!*+\u0007y\fi\u0010\u0006\u0003\u0003(\t%\u0006\"CAE\u0019\u0006\u0005\t\u0019\u0001B\u000f)\u0011\t)G!,\t\u0013\u0005%e*!AA\u0002\t\u001dB\u0003BA3\u0005cC\u0011\"!#R\u0003\u0003\u0005\rAa\n\u0002\u0011\r\u000b7\r[3LKf\u00042!!;T'\u0015\u0019&\u0011XAl!%\u0011YF!\u0019\u0002 y\u0014i\t\u0006\u0002\u00036R1!Q\u0012B`\u0005\u0003Dq!a+W\u0001\u0004\ty\u0002C\u0003}-\u0002\u0007a\u0010\u0006\u0003\u0003F\n%\u0007#B9\u0002t\t\u001d\u0007CB9\u0003x\u0005}a\u0010C\u0005\u0003~]\u000b\t\u00111\u0001\u0003\u000e\u0006I1\u000f]1sW\u000e{gNZ\u000b\u0003\u0005\u001f\u0004BA!5\u0003T6\t\u0011.C\u0002\u0003V&\u0014\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015M\u0004\u0018M]6D_:4\u0007%\u0006\u0002\u0002D\u0005i1m\u001c8tk6,'\u000fU8pY\u0002*\"!!\u0014\u0002!\u0019,Go\u00195fI\u0012\u000bG/\u0019)p_2\u0004\u0013aB1dcVL'/\u001a\u000b\u0007\u0003/\u0012)Oa:\t\u000bq|\u0006\u0019\u0001@\t\u000f\u00055q\f1\u0001\u0002\u0010\u0005y!/\u001a9peR$\u0015\r^1M_N\u001c\b\u0007\u0006\u0005\u0002\u0002\n5(\u0011\u001fB{\u0011\u001d\u0011y\u000f\u0019a\u0001\u0003K\naBZ1jY>sG)\u0019;b\u0019>\u001c8\u000fC\u0004\u0003t\u0002\u0004\r!a\b\u0002\u0019\u0019Lg.\u00197NKN\u001c\u0018mZ3\t\u0013\t]\b\r%AA\u0002\te\u0018!B2bkN,\u0007\u0003\u0002B~\u0007\u000bqAA!@\u0004\u00029!\u0011Q\u0005B\u0000\u0013\u0005\u0019\u0018bAB\u0002e\u00069\u0001/Y2lC\u001e,\u0017\u0002BB\u0004\u0007\u0013\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\r\r!/A\rsKB|'\u000f\u001e#bi\u0006dun]:1I\u0011,g-Y;mi\u0012\u001aTCAB\bU\u0011\u0011I0!@\u0002\u0013\r\f7\r[3LKf\u0004\u0013!\u00044fi\u000eDW\r\u001a*fG>\u0014H-\u0006\u0002\u0004\u0018A!\u0011QIB\r\u0013\r\u0019Yb\u0019\u0002\u000e\r\u0016$8\r[3e%\u0016\u001cwN\u001d3\u0002\u001d\u0019,Go\u00195fIJ+7m\u001c:eA\u0005\u0019q-\u001a;\u0015\u0015\r\r2QHB!\u0007\u000b\u001aI\u0005\u0005\u0005\u0004&\r52\u0011GB\u0019\u001b\t\u00199CC\u0002e\u0007SQAaa\u000b\u0002\u0006\u000591\r\\5f]R\u001c\u0018\u0002BB\u0018\u0007O\u0011abQ8ogVlWM\u001d*fG>\u0014H\rE\u0003r\u0007g\u00199$C\u0002\u00046I\u0014Q!\u0011:sCf\u00042!]B\u001d\u0013\r\u0019YD\u001d\u0002\u0005\u0005f$X\rC\u0004\u0004@Q\u0001\r!!2\u0002\r=4gm]3u\u0011\u001d\u0019\u0019\u0005\u0006a\u0001\u0003\u000b\f1\"\u001e8uS2|eMZ:fi\"91q\t\u000bA\u0002\u0005\u0015\u0017!\u00049pY2$\u0016.\\3pkRl5\u000fC\u0004\u0003pR\u0001\r!!\u001a\u0002/\u001d,G/\u0011<bS2\f'\r\\3PM\u001a\u001cX\r\u001e*b]\u001e,GCAB(!\r\t9\fK\u0001\be\u0016dW-Y:f)\t\t\t)A\bsK2,\u0017m]3D_:\u001cX/\\3s\u0003I\u0011X\r\\3bg\u00164U\r^2iK\u0012$\u0015\r^1\u0002C\u001d,G/R1sY&,7\u000f^!wC&d\u0017M\u00197f\u001f\u001a47/\u001a;CKR<X-\u001a8\u0015\u0011\u0005\u00157QLB0\u0007CBa\u0001Z\rA\u0002\u0005]\u0004bBB 3\u0001\u0007\u0011Q\u0019\u0005\b\u0007\u0007J\u0002\u0019AAc\u0003-1W\r^2i%\u0016\u001cwN\u001d3\u0015\u001d\r]1qMB5\u0007[\u001ayg!\u001d\u0004t!1AM\u0007a\u0001\u0003oBqaa\u001b\u001b\u0001\u0004\tY*A\u0006gKR\u001c\u0007.\u001a3ECR\f\u0007bBB 5\u0001\u0007\u0011Q\u0019\u0005\b\u0007\u0007R\u0002\u0019AAc\u0011\u001d\u00199E\u0007a\u0001\u0003\u000bDqAa<\u001b\u0001\u0004\t)'A\u0005gKR\u001c\u0007\u000eR1uCRQ\u0011\u0011QB=\u0007w\u001aiha \t\r\u0011\\\u0002\u0019AA<\u0011\u001d\u0019Yg\u0007a\u0001\u00037Cqaa\u0010\u001c\u0001\u0004\t)\rC\u0004\u0004Hm\u0001\r!!2\u0002+\u001d,Go\u0014:SKR\u0014\u0018.\u001a<f\u0007>t7/^7feR\u0011\u0011qO\u0001\u0011e\u0016$(/[3wK\u000e{gn];nKJ\f\u0001dZ3u\u001fJ\u0014V\r\u001e:jKZ,g)\u001a;dQ\u0016$G)\u0019;b)\u0011\tYja#\t\u000f\r}b\u00041\u0001\u0002F\u0006\t\u0012\r\u001a3ji&|g.\u00197NKN\u001c\u0018mZ3\u0015\u0011\u0005}1\u0011SBJ\u0007+CQ\u0001`\u0010A\u0002yDq!a+ \u0001\u0004\ty\u0002C\u0004\u0003p~\u0001\r!!\u001a\u0002\u001dI,\u0007o\u001c:u\t\u0006$\u0018\rT8tgRa\u0011\u0011QBN\u0007;\u001byj!)\u0004&\")A\u0010\ta\u0001}\"9\u00111\u0016\u0011A\u0002\u0005}\u0001b\u0002BxA\u0001\u0007\u0011Q\r\u0005\b\u0007G\u0003\u0003\u0019AA\u0010\u0003\u001diWm]:bO\u0016D\u0011Ba>!!\u0003\u0005\rA!?\u00021I,\u0007o\u001c:u\t\u0006$\u0018\rT8tg\u0012\"WMZ1vYR$S'\u0001\u000fsk:,f.\u001b8uKJ\u0014X\u000f\u001d;jE2L\u0018J\u001a)pgNL'\r\\3\u0016\t\r561\u0017\u000b\u0005\u0007_\u001by\f\u0005\u0003\u00042\u000eMF\u0002\u0001\u0003\b\u0007k\u0013#\u0019AB\\\u0005\u0005!\u0016\u0003BB]\u0005O\u00012!]B^\u0013\r\u0019iL\u001d\u0002\b\u001d>$\b.\u001b8h\u0011!\u0019\tM\tCA\u0002\r\r\u0017\u0001\u00022pIf\u0004R!]Bc\u0007_K1aa2s\u0005!a$-\u001f8b[\u0016t\u0004")
public class KafkaDataConsumer
implements Logging {
    private final TopicPartition topicPartition;
    private final Map<String, Object> kafkaParams;
    private final InternalKafkaConsumerPool consumerPool;
    private final FetchedDataPool fetchedDataPool;
    private final boolean isTokenProviderEnabled;
    private volatile Option<InternalKafkaConsumer> _consumer;
    private volatile Option<FetchedData> _fetchedData;
    private final String groupId;
    private final CacheKey cacheKey;
    private final FetchedRecord fetchedRecord;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KafkaDataConsumer acquire(TopicPartition topicPartition, Map<String, Object> map) {
        return KafkaDataConsumer$.MODULE$.acquire(topicPartition, map);
    }

    public static long UNKNOWN_OFFSET() {
        return KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean isTokenProviderEnabled() {
        return this.isTokenProviderEnabled;
    }

    public Option<InternalKafkaConsumer> _consumer() {
        return this._consumer;
    }

    public void _consumer_$eq(Option<InternalKafkaConsumer> x$1) {
        this._consumer = x$1;
    }

    private Option<FetchedData> _fetchedData() {
        return this._fetchedData;
    }

    private void _fetchedData_$eq(Option<FetchedData> x$1) {
        this._fetchedData = x$1;
    }

    private String groupId() {
        return this.groupId;
    }

    private CacheKey cacheKey() {
        return this.cacheKey;
    }

    private FetchedRecord fetchedRecord() {
        return this.fetchedRecord;
    }

    public ConsumerRecord<byte[], byte[]> get(long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        return (ConsumerRecord)this.runUninterruptiblyIfPossible((Function0 & Serializable & scala.Serializable)() -> {
            ConsumerRecord<byte[], byte[]> consumerRecord;
            Predef$.MODULE$.require(offset < untilOffset, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("offset must always be less than untilOffset [offset: ").append(offset).append(", untilOffset: ").append(untilOffset).append("]").toString());
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            FetchedData fetchedData = this.getOrRetrieveFetchedData(offset);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Get ").append(this.groupId()).append(" ").append($this.topicPartition).append(" nextOffset ").append(fetchedData.nextOffsetInFetchedData()).append(" ").append("requested ").append(offset).toString());
            LongRef toFetchOffset = LongRef.create((long)offset);
            FetchedRecord fetchedRecord = null;
            boolean isFetchComplete = false;
            while (toFetchOffset.elem != KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET() && !isFetchComplete) {
                try {
                    fetchedRecord = this.fetchRecord(consumer, fetchedData, toFetchOffset.elem, untilOffset, pollTimeoutMs, failOnDataLoss);
                    if (fetchedRecord.record() != null) {
                        isFetchComplete = true;
                        continue;
                    }
                    toFetchOffset.elem = fetchedRecord.nextOffsetToFetch();
                    if (toFetchOffset.elem >= untilOffset) {
                        fetchedData.reset();
                        toFetchOffset.elem = KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
                        continue;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Skipped offsets [").append(offset).append(", ").append(toFetchOffset$1.elem).append("]").toString());
                }
                catch (OffsetOutOfRangeException e) {
                    this.releaseConsumer();
                    fetchedData.reset();
                    this.reportDataLoss($this.topicPartition, this.groupId(), failOnDataLoss, new StringBuilder(20).append("Cannot fetch offset ").append(toFetchOffset.elem).toString(), e);
                    toFetchOffset.elem = this.getEarliestAvailableOffsetBetween(consumer, toFetchOffset.elem, untilOffset);
                }
            }
            if (isFetchComplete) {
                consumerRecord = fetchedRecord.record();
            } else {
                fetchedData.reset();
                consumerRecord = null;
            }
            return consumerRecord;
        });
    }

    public AvailableOffsetRange getAvailableOffsetRange() {
        return (AvailableOffsetRange)this.runUninterruptiblyIfPossible((Function0 & Serializable & scala.Serializable)() -> {
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            return consumer.getAvailableOffsetRange();
        });
    }

    public void release() {
        this.releaseConsumer();
        this.releaseFetchedData();
    }

    private void releaseConsumer() {
        block0: {
            if (!this._consumer().isDefined()) break block0;
            this.consumerPool.returnObject((InternalKafkaConsumer)this._consumer().get());
            this._consumer_$eq((Option<InternalKafkaConsumer>)None$.MODULE$);
        }
    }

    private void releaseFetchedData() {
        block0: {
            if (!this._fetchedData().isDefined()) break block0;
            this.fetchedDataPool.release(this.cacheKey(), (FetchedData)this._fetchedData().get());
            this._fetchedData_$eq((Option<FetchedData>)None$.MODULE$);
        }
    }

    private long getEarliestAvailableOffsetBetween(InternalKafkaConsumer consumer, long offset, long untilOffset) {
        long l;
        AvailableOffsetRange range = consumer.getAvailableOffsetRange();
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Some data may be lost. Recovering from the earliest offset: ").append(range.earliest()).toString());
        TopicPartition topicPartition = consumer.topicPartition();
        String groupId = consumer.groupId();
        if (offset >= range.latest() || range.earliest() >= untilOffset) {
            String warningMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(untilOffset).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString())).stripMargin();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
            l = KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
        } else if (offset >= range.earliest()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Found a disappeared offset ").append(offset).append(". Some data may be lost ").append(this.additionalMessage(topicPartition, groupId, false)).toString());
            l = offset;
        } else {
            String warningMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(range.earliest()).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString())).stripMargin();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
            l = range.earliest();
        }
        return l;
    }

    private FetchedRecord fetchRecord(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        FetchedRecord fetchedRecord;
        if (offset != fetchedData.nextOffsetInFetchedData()) {
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        } else if (!fetchedData.hasNext()) {
            if (offset < fetchedData.offsetAfterPoll()) {
                long nextOffsetToFetch = fetchedData.offsetAfterPoll();
                fetchedData.reset();
                return this.fetchedRecord().withRecord(null, nextOffsetToFetch);
            }
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        }
        if (!fetchedData.hasNext()) {
            Predef$.MODULE$.assert(offset <= fetchedData.offsetAfterPoll(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("seek to ").append(offset).append(" and poll but the offset was reset to ").append(fetchedData.offsetAfterPoll()).toString());
            fetchedRecord = this.fetchedRecord().withRecord(null, fetchedData.offsetAfterPoll());
        } else {
            ConsumerRecord<byte[], byte[]> record = fetchedData.next();
            if (record.offset() > offset) {
                long earliestOffset;
                Tuple2<Object, Object> tuple2 = fetchedData.availableOffsetRange();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                long l = earliestOffset = tuple2._1$mcJ$sp();
                long earliestOffset2 = l;
                if (earliestOffset2 <= offset) {
                    fetchedData.previous();
                    return this.fetchedRecord().withRecord(null, record.offset());
                }
                if (failOnDataLoss) {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), true, new StringBuilder(28).append("Cannot fetch records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
                    throw new IllegalStateException("reportDataLoss didn't throw an exception when 'failOnDataLoss' is true");
                }
                if (record.offset() >= untilOffset) {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(untilOffset).append(")").toString(), this.reportDataLoss$default$5());
                    fetchedRecord = this.fetchedRecord().withRecord(null, untilOffset);
                } else {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
                    fetchedRecord = this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
                }
            } else {
                if (record.offset() < offset) {
                    throw new IllegalStateException(new StringBuilder(51).append("Tried to fetch ").append(offset).append(" but the returned record offset was ").append(record.offset()).toString());
                }
                fetchedRecord = this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
            }
        }
        return fetchedRecord;
    }

    private void fetchData(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long pollTimeoutMs) {
        Tuple3<List<ConsumerRecord<byte[], byte[]>>, Object, AvailableOffsetRange> tuple3 = consumer.fetch(offset, pollTimeoutMs);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        List records = (List)tuple3._1();
        long offsetAfterPoll = BoxesRunTime.unboxToLong((Object)tuple3._2());
        AvailableOffsetRange range = (AvailableOffsetRange)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)records, (Object)BoxesRunTime.boxToLong((long)offsetAfterPoll), (Object)range);
        Tuple3 tuple33 = tuple32;
        List records2 = (List)tuple33._1();
        long offsetAfterPoll2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
        AvailableOffsetRange range2 = (AvailableOffsetRange)tuple33._3();
        fetchedData.withNewPoll(records2.listIterator(), offsetAfterPoll2, range2);
    }

    public InternalKafkaConsumer getOrRetrieveConsumer() {
        block1: {
            if (!this._consumer().isDefined()) {
                this.retrieveConsumer();
            }
            Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Consumer must be defined");
            if (!this.isTokenProviderEnabled() || !KafkaTokenUtil$.MODULE$.needTokenUpdate(((InternalKafkaConsumer)this._consumer().get()).kafkaParamsWithSecurity(), ((InternalKafkaConsumer)this._consumer().get()).clusterConfig())) break block1;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cached consumer uses an old delegation token, invalidating.");
            this.releaseConsumer();
            this.consumerPool.invalidateKey(this.cacheKey());
            this.fetchedDataPool.invalidate(this.cacheKey());
            this.retrieveConsumer();
        }
        return (InternalKafkaConsumer)this._consumer().get();
    }

    private void retrieveConsumer() {
        this._consumer_$eq((Option<InternalKafkaConsumer>)Option$.MODULE$.apply((Object)this.consumerPool.borrowObject(this.cacheKey(), this.kafkaParams)));
        Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "borrowing consumer from pool must always succeed.");
    }

    private FetchedData getOrRetrieveFetchedData(long offset) {
        FetchedData fetchedData;
        Option<FetchedData> option = this._fetchedData();
        if (None$.MODULE$.equals(option)) {
            this._fetchedData_$eq((Option<FetchedData>)Option$.MODULE$.apply((Object)this.fetchedDataPool.acquire(this.cacheKey(), offset)));
            Predef$.MODULE$.require(this._fetchedData().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "acquiring fetched data from cache must always succeed.");
            fetchedData = (FetchedData)this._fetchedData().get();
        } else if (option instanceof Some) {
            FetchedData fetchedData2;
            Some some = (Some)option;
            fetchedData = fetchedData2 = (FetchedData)some.value();
        } else {
            throw new MatchError(option);
        }
        return fetchedData;
    }

    private String additionalMessage(TopicPartition topicPartition, String groupId, boolean failOnDataLoss) {
        return failOnDataLoss ? new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString() : new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString();
    }

    private void reportDataLoss(TopicPartition topicPartition, String groupId, boolean failOnDataLoss, String message, Throwable cause) {
        String finalMessage = new StringBuilder(1).append(message).append(" ").append(this.additionalMessage(topicPartition, groupId, failOnDataLoss)).toString();
        KafkaDataConsumer$.MODULE$.org$apache$spark$sql$kafka010$consumer$KafkaDataConsumer$$reportDataLoss0(failOnDataLoss, finalMessage, cause);
    }

    private Throwable reportDataLoss$default$5() {
        return null;
    }

    private <T> T runUninterruptiblyIfPossible(Function0<T> body) {
        Object object;
        Thread thread = Thread.currentThread();
        if (thread instanceof UninterruptibleThread) {
            UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
            object = uninterruptibleThread.runUninterruptibly(body);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "KafkaDataConsumer is not running in UninterruptibleThread. It may hang when KafkaDataConsumer's methods are interrupted because of KAFKA-1894");
            object = body.apply();
        }
        return (T)object;
    }

    public KafkaDataConsumer(TopicPartition topicPartition, Map<String, Object> kafkaParams, InternalKafkaConsumerPool consumerPool, FetchedDataPool fetchedDataPool) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        this.consumerPool = consumerPool;
        this.fetchedDataPool = fetchedDataPool;
        Logging.$init$((Logging)this);
        this.isTokenProviderEnabled = HadoopDelegationTokenManager$.MODULE$.isServiceEnabled(SparkEnv$.MODULE$.get().conf(), "kafka");
        this._consumer = None$.MODULE$;
        this._fetchedData = None$.MODULE$;
        this.groupId = (String)kafkaParams.get("group.id");
        this.cacheKey = new CacheKey(this.groupId(), topicPartition);
        this.fetchedRecord = new FetchedRecord(null, KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET());
    }

    public static class AvailableOffsetRange
    implements Product,
    scala.Serializable {
        private final long earliest;
        private final long latest;

        public long earliest() {
            return this.earliest;
        }

        public long latest() {
            return this.latest;
        }

        public AvailableOffsetRange copy(long earliest, long latest) {
            return new AvailableOffsetRange(earliest, latest);
        }

        public long copy$default$1() {
            return this.earliest();
        }

        public long copy$default$2() {
            return this.latest();
        }

        public String productPrefix() {
            return "AvailableOffsetRange";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Long l;
            int n = x$1;
            switch (n) {
                case 0: {
                    l = BoxesRunTime.boxToLong((long)this.earliest());
                    break;
                }
                case 1: {
                    l = BoxesRunTime.boxToLong((long)this.latest());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return l;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AvailableOffsetRange;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.earliest()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.latest()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AvailableOffsetRange)) return false;
            boolean bl = true;
            if (!bl) return false;
            AvailableOffsetRange availableOffsetRange = (AvailableOffsetRange)x$1;
            if (this.earliest() != availableOffsetRange.earliest()) return false;
            if (this.latest() != availableOffsetRange.latest()) return false;
            if (!availableOffsetRange.canEqual(this)) return false;
            return true;
        }

        public AvailableOffsetRange(long earliest, long latest) {
            this.earliest = earliest;
            this.latest = latest;
            Product.$init$((Product)this);
        }
    }

    public static class CacheKey
    implements Product,
    scala.Serializable {
        private final String groupId;
        private final TopicPartition topicPartition;

        public String groupId() {
            return this.groupId;
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }

        public CacheKey copy(String groupId, TopicPartition topicPartition) {
            return new CacheKey(groupId, topicPartition);
        }

        public String copy$default$1() {
            return this.groupId();
        }

        public TopicPartition copy$default$2() {
            return this.topicPartition();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = this.groupId();
                    break;
                }
                case 1: {
                    string = this.topicPartition();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return string;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            String string = this.groupId();
            String string2 = cacheKey.groupId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            TopicPartition topicPartition = this.topicPartition();
            TopicPartition topicPartition2 = cacheKey.topicPartition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            if (!cacheKey.canEqual(this)) return false;
            return true;
        }

        public CacheKey(String groupId, TopicPartition topicPartition) {
            this.groupId = groupId;
            this.topicPartition = topicPartition;
            Product.$init$((Product)this);
        }

        public CacheKey(TopicPartition topicPartition, Map<String, Object> kafkaParams) {
            this((String)kafkaParams.get("group.id"), topicPartition);
        }
    }
}

