/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010.producer;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaConfigUpdater;
import org.apache.spark.kafka010.KafkaRedactionUtil$;
import org.apache.spark.sql.kafka010.package$;
import org.apache.spark.sql.kafka010.producer.CachedKafkaProducer;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.MapLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\rc!\u0002\u00192\u0001Ej\u0004\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011Y\u0003!Q1A\u0005\u0002]C\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\t=\u0002\u0011\t\u0011)A\u0005?\")1\r\u0001C\u0001I\")1\r\u0001C\u0001U\"AQ\u000e\u0001b\u0001\n\u0003\td\u000e\u0003\u0004s\u0001\u0001\u0006Ia\u001c\u0005\bg\u0002\u0011\r\u0011\"\u0003u\u0011\u001d\t)\u000e\u0001Q\u0001\nUDq!!=\u0001\t\u0013\t\u0019\u0010C\u0005\u0003\u001a\u0001\u0011\r\u0011\"\u0003\u0003\u001c!A!Q\u0004\u0001!\u0002\u0013\t)\u0010\u0003\u0005\u0002<\u0002!\t!\rB\u0010\u0011!\tY\r\u0001C\u0001c\t\r\u0002\u0002\u0003B\u0014\u0001\u0011\u0005\u0011'!*\t\u0011\u0005E\u0007\u0001\"\u00012\u0003KC\u0001B!\u000b\u0001\t\u0003\t$1\u0006\u0005\b\u0005c\u0001A\u0011BAS\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kAqA!\u0010\u0001\t\u0013\u0011ydB\u0004\u0000c!\u00051'!\u0001\u0007\u000fA\n\u0004\u0012A\u001a\u0002\u0004!11m\u0006C\u0001\u0003\u000bA\u0011\"a\u0002\u0018\u0005\u0004%I!!\u0003\t\u000f\u0005-q\u0003)A\u0005K\u00161\u0011QB\f\u0005\u0003\u001f)a!!\u0013\u0018\t\u0005-caBA5/\u0001\t\u00141\u000e\u0005\neu\u0011)\u0019!C\u0001\u0003[B!\"!\u001e\u001e\u0005\u0003\u0005\u000b\u0011BA8\u0011%\t9(\bB\u0001B\u0003%q\u000e\u0003\u0004d;\u0011\u0005\u0011\u0011\u0010\u0005\t\u0003\u0007k\u0002\u0019!C\u0005]\"I\u0011QQ\u000fA\u0002\u0013%\u0011q\u0011\u0005\b\u0003'k\u0002\u0015)\u0003p\u0011!\t)*\ba\u0001\n\u0013q\u0007\"CAL;\u0001\u0007I\u0011BAM\u0011\u001d\ti*\bQ!\n=Dq!a(\u001e\t\u0003\td\u000eC\u0004\u0002\"v!\t!\r8\t\u000f\u0005\rV\u0004\"\u0001\u0002&\"9\u0011qU\u000f\u0005\u0002\u0005%\u0006bBAX;\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003w;B\u0011AA_\u0011\u001d\tYm\u0006C\u0001\u0003\u001bDq!!5\u0018\t\u0003\t)KA\rJ]R,'O\\1m\u0017\u000647.\u0019)s_\u0012,8-\u001a:Q_>d'B\u0001\u001a4\u0003!\u0001(o\u001c3vG\u0016\u0014(B\u0001\u001b6\u0003!Y\u0017MZ6baE\u0002$B\u0001\u001c8\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003qe\nQa\u001d9be.T!AO\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0014aA8sON\u0019\u0001A\u0010#\u0011\u0005}\u0012U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\r\u0005s\u0017PU3g!\t)\u0005*D\u0001G\u0015\t9u'\u0001\u0005j]R,'O\\1m\u0013\tIeIA\u0004M_\u001e<\u0017N\\4\u0002\u001f\u0015DXmY;u_J\u001cVM\u001d<jG\u0016\u001c\u0001\u0001\u0005\u0002N)6\taJ\u0003\u0002P!\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005E\u0013\u0016\u0001B;uS2T\u0011aU\u0001\u0005U\u00064\u0018-\u0003\u0002V\u001d\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u000b\rdwnY6\u0016\u0003a\u0003\"!W.\u000e\u0003iS!!U\u001c\n\u0005qS&!B\"m_\u000e\\\u0017AB2m_\u000e\\\u0007%\u0001\u0003d_:4\u0007C\u00011b\u001b\u00059\u0014B\u000128\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\u0005K\u001eD\u0017\u000e\u0005\u0002g\u00015\t\u0011\u0007C\u0003K\u000b\u0001\u0007A\nC\u0003W\u000b\u0001\u0007\u0001\fC\u0003_\u000b\u0001\u0007q\f\u0006\u0002fW\")AN\u0002a\u0001?\u0006I1\u000f]1sW\u000e{gNZ\u0001\u0019G\u0006\u001c\u0007.Z#ya&\u0014X\rV5nK>,H/T5mY&\u001cX#A8\u0011\u0005}\u0002\u0018BA9A\u0005\u0011auN\\4\u00023\r\f7\r[3FqBL'/\u001a+j[\u0016|W\u000f^'jY2L7\u000fI\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0002kB)ao_?\u0002T6\tqO\u0003\u0002ys\u00069Q.\u001e;bE2,'B\u0001>A\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003y^\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002\u007f79\u0011aMF\u0001\u001a\u0013:$XM\u001d8bY.\u000bgm[1Qe>$WoY3s!>|G\u000e\u0005\u0002g/M\u0019qC\u0010#\u0015\u0005\u0005\u0005\u0011\u0001\u00029p_2,\u0012!Z\u0001\u0006a>|G\u000e\t\u0002\t\u0007\u0006\u001c\u0007.Z&fsB1\u0011\u0011CA\u0011\u0003OqA!a\u0005\u0002\u001e9!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a-\u000ba\u0001\u0010:p_Rt\u0014\"A!\n\u0007\u0005}\u0001)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0012Q\u0005\u0002\u0004'\u0016\f(bAA\u0010\u0001B9q(!\u000b\u0002.\u0005u\u0012bAA\u0016\u0001\n1A+\u001e9mKJ\u0002B!a\f\u000289!\u0011\u0011GA\u001a!\r\t)\u0002Q\u0005\u0004\u0003k\u0001\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002:\u0005m\"AB*ue&twMC\u0002\u00026\u0001\u0003B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007\u0012\u0016\u0001\u00027b]\u001eLA!a\u0012\u0002B\t1qJ\u00196fGR\u0014\u0001\u0002\u0015:pIV\u001cWM\u001d\t\t\u0003\u001b\nI&!\u0018\u0002^5\u0011\u0011q\n\u0006\u0004e\u0005E#\u0002BA*\u0003+\nqa\u00197jK:$8OC\u0002\u0002Xe\nQa[1gW\u0006LA!a\u0017\u0002P\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u0004RaPA0\u0003GJ1!!\u0019A\u0005\u0015\t%O]1z!\ry\u0014QM\u0005\u0004\u0003O\u0002%\u0001\u0002\"zi\u0016\u00141cQ1dQ\u0016$\u0007K]8ek\u000e,'/\u00128uef\u001c\"!\b \u0016\u0005\u0005=\u0004c\u00014\u0002r%\u0019\u00111O\u0019\u0003'\r\u000b7\r[3e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013\u0001F2bG\",W\t\u001f9je\u0016$\u0016.\\3pkRt5\u000f\u0006\u0004\u0002|\u0005}\u0014\u0011\u0011\t\u0004\u0003{jR\"A\f\t\rI\n\u0003\u0019AA8\u0011\u0019\t9(\ta\u0001_\u0006IqL]3g\u0007>,h\u000e^\u0001\u000e?J,gmQ8v]R|F%Z9\u0015\t\u0005%\u0015q\u0012\t\u0004\u007f\u0005-\u0015bAAG\u0001\n!QK\\5u\u0011!\t\tjIA\u0001\u0002\u0004y\u0017a\u0001=%c\u0005QqL]3g\u0007>,h\u000e\u001e\u0011\u0002\u0013}+\u0007\u0010]5sK\u0006#\u0018!D0fqBL'/Z!u?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0006m\u0005\u0002CAIM\u0005\u0005\t\u0019A8\u0002\u0015}+\u0007\u0010]5sK\u0006#\b%\u0001\u0005sK\u001a\u001cu.\u001e8u\u0003!)\u0007\u0010]5sK\u0006#\u0018A\u00045b]\u0012dWMQ8se><X\r\u001a\u000b\u0003\u0003\u0013\u000ba\u0002[1oI2,'+\u001a;ve:,G\r\u0006\u0003\u0002\n\u0006-\u0006BBAWW\u0001\u0007q.A\u0005dkJ$\u0016.\\3Og\u00069Q\r\u001f9je\u0016$G\u0003BAZ\u0003s\u00032aPA[\u0013\r\t9\f\u0011\u0002\b\u0005>|G.Z1o\u0011\u0019\ti\u000b\fa\u0001_\u00069\u0011mY9vSJ,G\u0003BA8\u0003\u007fCq!!1.\u0001\u0004\t\u0019-A\u0006lC\u001a\\\u0017\rU1sC6\u001c\b\u0003CAc\u0003\u000f\fi#!\u0010\u000e\u0003AK1!!3Q\u0005\ri\u0015\r]\u0001\be\u0016dW-Y:f)\u0011\tI)a4\t\rIr\u0003\u0019AA8\u0003\u0015\u0011Xm]3u!\tqX$\u0001\u0004dC\u000eDW\r\t\u0015\b\u0015\u0005e\u00171^Aw!\u0011\tY.a:\u000e\u0005\u0005u'bA(\u0002`*!\u0011\u0011]Ar\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0003K\fQA[1wCbLA!!;\u0002^\nIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003_\fA\u0001\u001e5jg\u0006\u00112\u000f^1si\u00163\u0018n\u0019;peRC'/Z1e)\t\t)\u0010E\u0003@\u0003o\fY0C\u0002\u0002z\u0002\u0013aa\u00149uS>t\u0007\u0007BA\u007f\u0005\u000f\u0001R!TA\u0000\u0005\u0007I1A!\u0001O\u0005=\u00196\r[3ek2,GMR;ukJ,\u0007\u0003\u0002B\u0003\u0005\u000fa\u0001\u0001B\u0006\u0003\n-\t\t\u0011!A\u0003\u0002\t-!aA0%cE!!Q\u0002B\n!\ry$qB\u0005\u0004\u0005#\u0001%a\u0002(pi\"Lgn\u001a\t\u0004\u007f\tU\u0011b\u0001B\f\u0001\n\u0019\u0011I\\=\u0002\u0013M\u001c\u0007.\u001a3vY\u0016$WCAA{\u0003)\u00198\r[3ek2,G\r\t\u000b\u0005\u0003_\u0012\t\u0003C\u0004\u0002B:\u0001\r!a1\u0015\t\u0005%%Q\u0005\u0005\u0007e=\u0001\r!a\u001c\u0002\u0011MDW\u000f\u001e3po:\f\u0001bZ3u\u0003Nl\u0015\r]\u000b\u0003\u0005[\u0001r!a\f\u00030u\f\u0019.\u0003\u0003\u0002J\u0006m\u0012\u0001D3wS\u000e$X\t\u001f9je\u0016$\u0017aE2sK\u0006$XmS1gW\u0006\u0004&o\u001c3vG\u0016\u0014H\u0003\u0002B\u001c\u0005s\u0001\"A \u000f\t\u000f\tmB\u00031\u0001\u0002\u0010\u0005I\u0001/\u0019:b[N\u001cV-]\u0001\fa\u0006\u0014\u0018-\\:U_N+\u0017\u000f\u0006\u0003\u0002\u0010\t\u0005\u0003bBAa+\u0001\u0007\u00111\u0019")
public class InternalKafkaProducerPool
implements Logging {
    private final ScheduledExecutorService executorService;
    private final Clock clock;
    private final SparkConf conf;
    private final long cacheExpireTimeoutMillis;
    @GuardedBy(value="this")
    private final HashMap<Seq<Tuple2<String, Object>>, CachedProducerEntry> cache;
    private final Option<ScheduledFuture<?>> scheduled;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Clock clock() {
        return this.clock;
    }

    public long cacheExpireTimeoutMillis() {
        return this.cacheExpireTimeoutMillis;
    }

    private HashMap<Seq<Tuple2<String, Object>>, CachedProducerEntry> cache() {
        return this.cache;
    }

    private Option<ScheduledFuture<?>> startEvictorThread() {
        None$ none$;
        long evictorThreadRunIntervalMillis = BoxesRunTime.unboxToLong((Object)this.conf.get(package$.MODULE$.PRODUCER_CACHE_EVICTOR_THREAD_RUN_INTERVAL()));
        if (evictorThreadRunIntervalMillis > 0L) {
            ScheduledFuture<?> future = this.executorService.scheduleAtFixedRate(() -> Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.evictExpired()), 0L, evictorThreadRunIntervalMillis, TimeUnit.MILLISECONDS);
            none$ = new Some(future);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<ScheduledFuture<?>> scheduled() {
        return this.scheduled;
    }

    public CachedKafkaProducer acquire(java.util.Map<String, Object> kafkaParams) {
        CachedKafkaProducer cachedKafkaProducer;
        java.util.Map updatedKafkaProducerConfiguration = new KafkaConfigUpdater("executor", ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(kafkaParams).asScala()).toMap(Predef$.MODULE$.$conforms())).setAuthenticationConfigIfNeeded().build();
        Seq<Tuple2<String, Object>> paramsSeq = this.paramsToSeq(updatedKafkaProducerConfiguration);
        InternalKafkaProducerPool internalKafkaProducerPool = this;
        synchronized (internalKafkaProducerPool) {
            CachedProducerEntry entry = (CachedProducerEntry)this.cache().getOrElseUpdate(paramsSeq, (Function0 & Serializable & scala.Serializable)() -> {
                KafkaProducer<byte[], byte[]> producer = this.createKafkaProducer(paramsSeq);
                CachedKafkaProducer cachedProducer = new CachedKafkaProducer(paramsSeq, producer);
                return new CachedProducerEntry(cachedProducer, TimeUnit.MILLISECONDS.toNanos(this.cacheExpireTimeoutMillis()));
            });
            entry.handleBorrowed();
            cachedKafkaProducer = entry.producer();
        }
        return cachedKafkaProducer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void release(CachedKafkaProducer producer) {
        Option option = this.cache().get(producer.cacheKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            CachedProducerEntry entry = (CachedProducerEntry)some.value();
            String string = entry.producer().id();
            String string2 = producer.id();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                entry.handleReturned(this.clock().nanoTime());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Released producer ").append(producer.id()).append(" is not a member of the cache. Closing.").toString());
        producer.close();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void shutdown() {
        this.scheduled().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.cancel(false)));
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.executorService, ThreadUtils$.MODULE$.shutdown$default$2());
    }

    public synchronized void reset() {
        this.cache().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            InternalKafkaProducerPool.$anonfun$reset$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.cache().clear();
    }

    public scala.collection.immutable.Map<Seq<Tuple2<String, Object>>, CachedProducerEntry> getAsMap() {
        return this.cache().toMap(Predef$.MODULE$.$conforms());
    }

    private void evictExpired() {
        long curTimeNs = this.clock().nanoTime();
        ArrayBuffer producers = new ArrayBuffer();
        InternalKafkaProducerPool internalKafkaProducerPool = this;
        synchronized (internalKafkaProducerPool) {
            HashMap cfr_ignored_0 = (HashMap)this.cache().retain((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)InternalKafkaProducerPool.$anonfun$evictExpired$1(curTimeNs, producers, x0$1, x1$1)));
        }
        producers.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            InternalKafkaProducerPool.$anonfun$evictExpired$2(x$2);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private KafkaProducer<byte[], byte[]> createKafkaProducer(Seq<Tuple2<String, Object>> paramsSeq) {
        void var2_2;
        block0: {
            KafkaProducer kafkaProducer = new KafkaProducer((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)paramsSeq.toMap(Predef$.MODULE$.$conforms())).asJava());
            if (!this.log().isDebugEnabled()) break block0;
            Seq redactedParamsSeq = KafkaRedactionUtil$.MODULE$.redactParams(paramsSeq);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Created a new instance of KafkaProducer for ").append(redactedParamsSeq).append(".").toString());
        }
        return var2_2;
    }

    private Seq<Tuple2<String, Object>> paramsToSeq(java.util.Map<String, Object> kafkaParams) {
        return (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(kafkaParams).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x -> (String)x._1(), (Ordering)Ordering.String$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$reset$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        CachedProducerEntry v = (CachedProducerEntry)tuple2._2();
        v.producer().close();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$evictExpired$1(long curTimeNs$1, ArrayBuffer producers$1, Seq x0$1, CachedProducerEntry x1$1) {
        boolean bl;
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            CachedProducerEntry v = (CachedProducerEntry)tuple2._2();
            if (v.expired(curTimeNs$1)) {
                producers$1.$plus$eq((Object)v);
                bl = false;
            } else {
                bl = true;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$evictExpired$2(CachedProducerEntry x$2) {
        x$2.producer().close();
    }

    public InternalKafkaProducerPool(ScheduledExecutorService executorService, Clock clock, SparkConf conf) {
        this.executorService = executorService;
        this.clock = clock;
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.cacheExpireTimeoutMillis = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.PRODUCER_CACHE_TIMEOUT()));
        this.cache = new HashMap();
        this.scheduled = this.startEvictorThread();
    }

    public InternalKafkaProducerPool(SparkConf sparkConf) {
        this(ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("kafka-producer-cache-evictor"), (Clock)new SystemClock(), sparkConf);
    }

    public static class CachedProducerEntry {
        private final CachedKafkaProducer producer;
        private final long cacheExpireTimeoutNs;
        private long _refCount;
        private long _expireAt;

        public CachedKafkaProducer producer() {
            return this.producer;
        }

        private long _refCount() {
            return this._refCount;
        }

        private void _refCount_$eq(long x$1) {
            this._refCount = x$1;
        }

        private long _expireAt() {
            return this._expireAt;
        }

        private void _expireAt_$eq(long x$1) {
            this._expireAt = x$1;
        }

        public long refCount() {
            return this._refCount();
        }

        public long expireAt() {
            return this._expireAt();
        }

        public void handleBorrowed() {
            this._refCount_$eq(this._refCount() + 1L);
            this._expireAt_$eq(Long.MAX_VALUE);
        }

        public void handleReturned(long curTimeNs) {
            block0: {
                Predef$.MODULE$.require(this._refCount() > 0L, (Function0 & Serializable & scala.Serializable)() -> "Reference count shouldn't become negative. Returning same producer multiple times would occur this bug. Check the logic around returning producer.");
                this._refCount_$eq(this._refCount() - 1L);
                if (this._refCount() != 0L) break block0;
                this._expireAt_$eq(curTimeNs + this.cacheExpireTimeoutNs);
            }
        }

        public boolean expired(long curTimeNs) {
            return this._refCount() == 0L && this._expireAt() < curTimeNs;
        }

        public CachedProducerEntry(CachedKafkaProducer producer, long cacheExpireTimeoutNs) {
            this.producer = producer;
            this.cacheExpireTimeoutNs = cacheExpireTimeoutNs;
            this._refCount = 0L;
            this._expireAt = Long.MAX_VALUE;
        }
    }
}

