/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.CompositeReadLimit;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.ReadMinRows;
import org.apache.spark.sql.connector.read.streaming.ReportsSourceMetrics;
import org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.JsonUtils$;
import org.apache.spark.sql.kafka010.KafkaBatchInputPartition;
import org.apache.spark.sql.kafka010.KafkaBatchReaderFactory$;
import org.apache.spark.sql.kafka010.KafkaMicroBatchStream$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.MockedSystemClock;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.UninterruptibleThread;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}c!B\u001a5\u0001Qr\u0004\"C/\u0001\u0005\u000b\u0007I\u0011\u0001\u001b_\u0011!!\u0007A!A!\u0002\u0013y\u0006\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011e\u0004!\u0011!Q\u0001\niD\u0001b \u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\u000b\u0003\u0003\u0001!\u0011!Q\u0001\n\u0005\r\u0001BCA\u0005\u0001\t\u0005\t\u0015!\u0003\u0002\f!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001BCA\u0013\u0001\t\u0007I\u0011\u0001\u001b\u0002(!A\u0011q\u0006\u0001!\u0002\u0013\tI\u0003\u0003\u0006\u00022\u0001\u0011\r\u0011\"\u00015\u0003gA\u0001\"a\u000f\u0001A\u0003%\u0011Q\u0007\u0005\u000b\u0003{\u0001!\u0019!C\u0001i\u0005M\u0002\u0002CA \u0001\u0001\u0006I!!\u000e\t\u0015\u0005\u0005\u0003A1A\u0005\u0002Q\n9\u0003\u0003\u0005\u0002D\u0001\u0001\u000b\u0011BA\u0015\u0011)\t)\u0005\u0001b\u0001\n\u0003!\u0014q\t\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002J!I\u0011Q\u000b\u0001A\u0002\u0013%\u0011q\u0005\u0005\n\u0003/\u0002\u0001\u0019!C\u0005\u00033B\u0001\"!\u001a\u0001A\u0003&\u0011\u0011\u0006\u0005\n\u0003O\u0002!\u0019!C\u0005\u0003SB\u0001\"a\u001b\u0001A\u0003%\u00111\u0002\u0005\f\u0003[\u0002\u0001\u0019!a\u0001\n\u0013\ty\u0007C\u0006\u0002x\u0001\u0001\r\u00111A\u0005\n\u0005e\u0004bCA?\u0001\u0001\u0007\t\u0011)Q\u0005\u0003cB1\"a \u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0002\"Y\u0011\u0011\u0013\u0001A\u0002\u0003\u0007I\u0011BAJ\u0011-\t9\n\u0001a\u0001\u0002\u0003\u0006K!a!\t\u000f\u0005e\u0005\u0001\"\u0011\u0002\u001c\"9\u00111\u0015\u0001\u0005B\u0005\u0015\u0006bBAW\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003_\u0003A\u0011IAN\u0011\u001d\ty\u000b\u0001C!\u0003cCq!a/\u0001\t\u0013\ti\fC\u0004\u0002b\u0002!\t%a9\t\u000f\u0005e\b\u0001\"\u0011\u0002|\"9!1\u0001\u0001\u0005B\t\u0015\u0001b\u0002B\u0006\u0001\u0011\u0005#Q\u0002\u0005\b\u0005#\u0001A\u0011\tB\n\u0011\u001d\u0011)\u0002\u0001C!\u0005/AqA!\u0007\u0001\t\u0003\u0012Y\u0002C\u0004\u0003*\u0001!IAa\u000b\t\u000f\t5\u0002\u0001\"\u0003\u00030!9!Q\b\u0001\u0005\n\t}\u0002B\u0004B#\u0001A\u0005\u0019\u0011!A\u0005\n\u0005\u0015&qI\u0004\b\u0005\u0013\"\u0004\u0012\u0001B&\r\u0019\u0019D\u0007#\u0001\u0003N!9\u00111\u0003\u0019\u0005\u0002\tU\u0003b\u0002B\ra\u0011\u0005!q\u000b\u0002\u0016\u0017\u000647.Y'jGJ|')\u0019;dQN#(/Z1n\u0015\t)d'\u0001\u0005lC\u001a\\\u0017\rM\u00191\u0015\t9\u0004(A\u0002tc2T!!\u000f\u001e\u0002\u000bM\u0004\u0018M]6\u000b\u0005mb\u0014AB1qC\u000eDWMC\u0001>\u0003\ry'oZ\n\u0007\u0001}:\u0015\u000bV,\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00027b]\u001eT\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0003\n1qJ\u00196fGR\u0004\"\u0001S(\u000e\u0003%S!AS&\u0002\u0013M$(/Z1nS:<'B\u0001'N\u0003\u0011\u0011X-\u00193\u000b\u000593\u0014!C2p]:,7\r^8s\u0013\t\u0001\u0016J\u0001\rTkB\u0004xN\u001d;t\u0003\u0012l\u0017n]:j_:\u001cuN\u001c;s_2\u0004\"\u0001\u0013*\n\u0005MK%\u0001\u0006*fa>\u0014Ho]*pkJ\u001cW-T3ue&\u001c7\u000f\u0005\u0002I+&\u0011a+\u0013\u0002\u0011\u001b&\u001c'o\u001c\"bi\u000eD7\u000b\u001e:fC6\u0004\"\u0001W.\u000e\u0003eS!A\u0017\u001d\u0002\u0011%tG/\u001a:oC2L!\u0001X-\u0003\u000f1{wmZ5oO\u0006\t2.\u00194lC>3gm]3u%\u0016\fG-\u001a:\u0016\u0003}\u0003\"\u0001Y1\u000e\u0003QJ!A\u0019\u001b\u0003#-\u000bgm[1PM\u001a\u001cX\r\u001e*fC\u0012,'o\u0001\u0001\u0002%-\fgm[1PM\u001a\u001cX\r\u001e*fC\u0012,'\u000fI\u0001\u0014Kb,7-\u001e;pe.\u000bgm[1QCJ\fWn\u001d\t\u0005O*dw(D\u0001i\u0015\tI7)\u0001\u0003vi&d\u0017BA6i\u0005\ri\u0015\r\u001d\t\u0003[Zt!A\u001c;\u0011\u0005=\u0014X\"\u00019\u000b\u0005E\u001c\u0017A\u0002\u001fs_>$hHC\u0001t\u0003\u0015\u00198-\u00197b\u0013\t)(/\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u0014aa\u0015;sS:<'BA;s\u0003\u001dy\u0007\u000f^5p]N\u0004\"a_?\u000e\u0003qT!!\u001b\u001c\n\u0005yd(\u0001G\"bg\u0016Len]3og&$\u0018N^3TiJLgnZ'ba\u0006aQ.\u001a;bI\u0006$\u0018\rU1uQ\u0006y1\u000f^1si&twm\u00144gg\u0016$8\u000fE\u0002a\u0003\u000bI1!a\u00025\u0005UY\u0015MZ6b\u001f\u001a47/\u001a;SC:<W\rT5nSR\faBZ1jY>sG)\u0019;b\u0019>\u001c8\u000f\u0005\u0003\u0002\u000e\u0005=Q\"\u0001:\n\u0007\u0005E!OA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)9\t9\"!\u0007\u0002\u001c\u0005u\u0011qDA\u0011\u0003G\u0001\"\u0001\u0019\u0001\t\u000buC\u0001\u0019A0\t\u000b\u0015D\u0001\u0019\u00014\t\u000beD\u0001\u0019\u0001>\t\u000b}D\u0001\u0019\u00017\t\u000f\u0005\u0005\u0001\u00021\u0001\u0002\u0004!9\u0011\u0011\u0002\u0005A\u0002\u0005-\u0011!\u00049pY2$\u0016.\\3pkRl5/\u0006\u0002\u0002*A!\u0011QBA\u0016\u0013\r\tiC\u001d\u0002\u0005\u0019>tw-\u0001\bq_2dG+[7f_V$Xj\u001d\u0011\u0002)5\f\u0007p\u00144gg\u0016$8\u000fU3s)JLwmZ3s+\t\t)\u0004\u0005\u0004\u0002\u000e\u0005]\u0012\u0011F\u0005\u0004\u0003s\u0011(AB(qi&|g.A\u000bnCb|eMZ:fiN\u0004VM\u001d+sS\u001e<WM\u001d\u0011\u0002'5Lgn\u00144gg\u0016$\b+\u001a:Ue&<w-\u001a:\u0002)5Lgn\u00144gg\u0016$\b+\u001a:Ue&<w-\u001a:!\u0003Ei\u0017\r\u001f+sS\u001e<WM\u001d#fY\u0006LXj]\u0001\u0013[\u0006DHK]5hO\u0016\u0014H)\u001a7bs6\u001b\b%A\u0003dY>\u001c7.\u0006\u0002\u0002JA!\u00111JA(\u001b\t\tiE\u0003\u0002jq%!\u0011\u0011KA'\u0005\u0015\u0019En\\2l\u0003\u0019\u0019Gn\\2lA\u0005\tB.Y:u)JLwmZ3s\u001b&dG.[:\u0002+1\f7\u000f\u001e+sS\u001e<WM]'jY2L7o\u0018\u0013fcR!\u00111LA1!\u0011\ti!!\u0018\n\u0007\u0005}#O\u0001\u0003V]&$\b\"CA2)\u0005\u0005\t\u0019AA\u0015\u0003\rAH%M\u0001\u0013Y\u0006\u001cH\u000f\u0016:jO\u001e,'/T5mY&\u001c\b%\u0001\bj]\u000edW\u000fZ3IK\u0006$WM]:\u0016\u0005\u0005-\u0011aD5oG2,H-\u001a%fC\u0012,'o\u001d\u0011\u0002'\u0015tG\rU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:\u0016\u0005\u0005E\u0004c\u00011\u0002t%\u0019\u0011Q\u000f\u001b\u0003#-\u000bgm[1T_V\u00148-Z(gMN,G/A\ff]\u0012\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$8o\u0018\u0013fcR!\u00111LA>\u0011%\t\u0019'GA\u0001\u0002\u0004\t\t(\u0001\u000bf]\u0012\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$8\u000fI\u0001\u0017Y\u0006$Xm\u001d;QCJ$\u0018\u000e^5p]>3gm]3ugV\u0011\u00111\u0011\t\u0005\u0003\u000b\u000bYID\u0002a\u0003\u000fK1!!#5\u0003\u001d\u0001\u0018mY6bO\u0016LA!!$\u0002\u0010\n\u0011\u0002+\u0019:uSRLwN\\(gMN,G/T1q\u0015\r\tI\tN\u0001\u001bY\u0006$Xm\u001d;QCJ$\u0018\u000e^5p]>3gm]3ug~#S-\u001d\u000b\u0005\u00037\n)\nC\u0005\u0002dq\t\t\u00111\u0001\u0002\u0004\u00069B.\u0019;fgR\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$8\u000fI\u0001\u000eS:LG/[1m\u001f\u001a47/\u001a;\u0015\u0005\u0005u\u0005c\u0001%\u0002 &\u0019\u0011\u0011U%\u0003\r=3gm]3u\u0003M9W\r\u001e#fM\u0006,H\u000e\u001e*fC\u0012d\u0015.\\5u)\t\t9\u000bE\u0002I\u0003SK1!a+J\u0005%\u0011V-\u00193MS6LG/\u0001\nsKB|'\u000f\u001e'bi\u0016\u001cHo\u00144gg\u0016$\u0018\u0001\u00047bi\u0016\u001cHo\u00144gg\u0016$HCBAO\u0003g\u000b9\fC\u0004\u00026\n\u0002\r!!(\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005e&\u00051\u0001\u0002(\u0006I!/Z1e\u0019&l\u0017\u000e^\u0001\u000bI\u0016d\u0017-\u001f\"bi\u000eDGCCA\u0006\u0003\u007f\u000b\u0019-a7\u0002`\"9\u0011\u0011Y\u0012A\u0002\u0005%\u0012\u0001C7j]2KW.\u001b;\t\u000f\u0005\u00157\u00051\u0001\u0002H\u0006iA.\u0019;fgR|eMZ:fiN\u0004r!\\Ae\u0003\u0017\fI#\u0003\u0002lqB!\u0011QZAl\u001b\t\tyM\u0003\u0003\u0002R\u0006M\u0017AB2p[6|gNC\u0002\u0002Vj\nQa[1gW\u0006LA!!7\u0002P\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAoG\u0001\u0007\u0011qY\u0001\u000fGV\u0014(/\u001a8u\u001f\u001a47/\u001a;t\u0011\u001d\t\te\ta\u0001\u0003S\t1\u0003\u001d7b]&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N$b!!:\u0002t\u0006U\bCBA\u0007\u0003O\fY/C\u0002\u0002jJ\u0014Q!\u0011:sCf\u0004B!!<\u0002p6\t1*C\u0002\u0002r.\u0013a\"\u00138qkR\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u00026\u0012\u0002\r!!(\t\u000f\u0005]H\u00051\u0001\u0002\u001e\u0006\u0019QM\u001c3\u0002'\r\u0014X-\u0019;f%\u0016\fG-\u001a:GC\u000e$xN]=\u0015\u0005\u0005u\b\u0003BAw\u0003\u007fL1A!\u0001L\u0005Y\u0001\u0016M\u001d;ji&|gNU3bI\u0016\u0014h)Y2u_JL\u0018!\u00053fg\u0016\u0014\u0018.\u00197ju\u0016|eMZ:fiR!\u0011Q\u0014B\u0004\u0011\u0019\u0011IA\na\u0001Y\u0006!!n]8o\u0003\u0019\u0019w.\\7jiR!\u00111\fB\b\u0011\u001d\t9p\na\u0001\u0003;\u000bAa\u001d;paR\u0011\u00111L\u0001\ti>\u001cFO]5oOR\tA.A\u0004nKR\u0014\u0018nY:\u0015\t\tu!q\u0004\t\u0005O*dG\u000eC\u0004\u0003\")\u0002\rAa\t\u0002)1\fG/Z:u\u0007>t7/^7fI>3gm]3u!\u00159'QEAO\u0013\r\u00119\u0003\u001b\u0002\t\u001fB$\u0018n\u001c8bY\u0006\u0011s-\u001a;Pe\u000e\u0013X-\u0019;f\u0013:LG/[1m!\u0006\u0014H/\u001b;j_:|eMZ:fiN$\"!a!\u0002\u0013I\fG/\u001a'j[&$H\u0003CAB\u0005c\u0011)D!\u000f\t\u000f\tMB\u00061\u0001\u0002*\u0005)A.[7ji\"9!q\u0007\u0017A\u0002\u0005\r\u0015\u0001\u00024s_6DqAa\u000f-\u0001\u0004\t\u0019)A\u0003v]RLG.\u0001\bsKB|'\u000f\u001e#bi\u0006dun]:\u0015\t\u0005m#\u0011\t\u0005\u0007\u0005\u0007j\u0003\u0019\u00017\u0002\u000f5,7o]1hK\u0006I2/\u001e9fe\u0012:W\r\u001e#fM\u0006,H\u000e\u001e*fC\u0012d\u0015.\\5u\u0013\r\t\u0019kT\u0001\u0016\u0017\u000647.Y'jGJ|')\u0019;dQN#(/Z1n!\t\u0001\u0007g\u0005\u00031\u0005\u001f:\u0006\u0003BA\u0007\u0005#J1Aa\u0015s\u0005\u0019\te.\u001f*fMR\u0011!1\n\u000b\u0007\u0005;\u0011IFa\u0017\t\u000f\t\u0005\"\u00071\u0001\u0003$!9!Q\f\u001aA\u0002\u0005\r\u0015a\b7bi\u0016\u001cH/\u0011<bS2\f'\r\\3QCJ$\u0018\u000e^5p]>3gm]3ug\u0002")
public class KafkaMicroBatchStream
implements SupportsAdmissionControl,
ReportsSourceMetrics,
MicroBatchStream,
Logging {
    private final KafkaOffsetReader kafkaOffsetReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final Option<Object> minOffsetPerTrigger;
    private final long maxTriggerDelayMs;
    private final Clock clock;
    private long lastTriggerMillis;
    private final boolean includeHeaders;
    private KafkaSourceOffset endPartitionOffsets;
    private scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private /* synthetic */ ReadLimit super$getDefaultReadLimit() {
        return super.getDefaultReadLimit();
    }

    public KafkaOffsetReader kafkaOffsetReader() {
        return this.kafkaOffsetReader;
    }

    public long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    public Option<Object> minOffsetPerTrigger() {
        return this.minOffsetPerTrigger;
    }

    public long maxTriggerDelayMs() {
        return this.maxTriggerDelayMs;
    }

    public Clock clock() {
        return this.clock;
    }

    private long lastTriggerMillis() {
        return this.lastTriggerMillis;
    }

    private void lastTriggerMillis_$eq(long x$1) {
        this.lastTriggerMillis = x$1;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private KafkaSourceOffset endPartitionOffsets() {
        return this.endPartitionOffsets;
    }

    private void endPartitionOffsets_$eq(KafkaSourceOffset x$1) {
        this.endPartitionOffsets = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets() {
        return this.latestPartitionOffsets;
    }

    private void latestPartitionOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.latestPartitionOffsets = x$1;
    }

    public Offset initialOffset() {
        return new KafkaSourceOffset(this.getOrCreateInitialPartitionOffsets());
    }

    public ReadLimit getDefaultReadLimit() {
        return this.minOffsetPerTrigger().isDefined() && this.maxOffsetsPerTrigger().isDefined() ? ReadLimit.compositeLimit((ReadLimit[])((ReadLimit[])((Object[])new ReadLimit[]{ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()), ReadLimit.maxRows((long)BoxesRunTime.unboxToLong((Object)this.maxOffsetsPerTrigger().get()))}))) : (this.minOffsetPerTrigger().isDefined() ? ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()) : (ReadLimit)this.maxOffsetsPerTrigger().map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaMicroBatchStream.$anonfun$getDefaultReadLimit$1(BoxesRunTime.unboxToLong((Object)x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$getDefaultReadLimit()));
    }

    public Offset reportLatestOffset() {
        return new KafkaSourceOffset(this.latestPartitionOffsets());
    }

    public Offset latestOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset latestOffset(Offset start, ReadLimit readLimit) {
        scala.collection.immutable.Map map;
        Seq seq;
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        this.latestPartitionOffsets_$eq(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(startPartitionOffsets)));
        ReadLimit readLimit2 = readLimit;
        if (readLimit2 instanceof CompositeReadLimit) {
            CompositeReadLimit compositeReadLimit = (CompositeReadLimit)readLimit2;
            seq = Predef$.MODULE$.wrapRefArray((Object[])compositeReadLimit.getReadLimits());
        } else {
            seq = (Seq)new .colon.colon((Object)readLimit2, (List)Nil$.MODULE$);
        }
        Seq limits = seq;
        if (limits.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$1(x$3)))) {
            map = this.latestPartitionOffsets();
        } else {
            Option lowerLimit = limits.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$2(x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> (ReadMinRows)x$5);
            Option upperLimit = limits.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$4(x$6))).map((Function1 & Serializable & scala.Serializable)x$7 -> (ReadMaxRows)x$7);
            map = (scala.collection.immutable.Map)lowerLimit.flatMap((Function1 & Serializable & scala.Serializable)limit -> {
                None$ none$;
                boolean skipBatch = this.delayBatch(limit.minRows(), this.latestPartitionOffsets(), startPartitionOffsets, limit.maxTriggerDelayMs());
                if (skipBatch) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Delaying batch as number of records available is less than minOffsetsPerTrigger");
                    none$ = new Some((Object)startPartitionOffsets);
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> upperLimit.map((Function1 & Serializable & scala.Serializable)limit -> this.rateLimit(limit.maxRows(), startPartitionOffsets, this.latestPartitionOffsets()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.latestPartitionOffsets());
        }
        scala.collection.immutable.Map offsets = map;
        this.endPartitionOffsets_$eq(new KafkaSourceOffset(offsets));
        return this.endPartitionOffsets();
    }

    private boolean delayBatch(long minLimit, scala.collection.immutable.Map<TopicPartition, Object> latestOffsets, scala.collection.immutable.Map<TopicPartition, Object> currentOffsets, long maxTriggerDelayMs) {
        boolean bl;
        if (this.clock().getTimeMillis() - this.lastTriggerMillis() >= maxTriggerDelayMs) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Maximum wait time is passed, triggering batch");
            this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
            bl = false;
        } else {
            double newRecords = BoxesRunTime.unboxToLong((Object)((MapLike)latestOffsets.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topic = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Iterable iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToLong((long)(offset - BoxesRunTime.unboxToLong((Object)currentOffsets.getOrElse((Object)topic, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))))));
                return iterable;
            }, Map$.MODULE$.canBuildFrom())).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            if (newRecords < (double)minLimit) {
                bl = true;
            } else {
                this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
                bl = false;
            }
        }
        return bl;
    }

    public InputPartition[] planInputPartitions(Offset start, Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        scala.collection.immutable.Map<TopicPartition, Object> endPartitionOffsets = ((KafkaSourceOffset)end).partitionToOffsets();
        Seq<KafkaOffsetRange> offsetRanges = this.kafkaOffsetReader().getOffsetRangesFromResolvedOffsets(startPartitionOffsets, endPartitionOffsets, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
            this.reportDataLoss(message);
            return BoxedUnit.UNIT;
        });
        return (InputPartition[])((TraversableOnce)offsetRanges.map((Function1 & Serializable & scala.Serializable)range -> new KafkaBatchInputPartition((KafkaOffsetRange)range, $this.executorKafkaParams, this.pollTimeoutMs(), $this.failOnDataLoss, this.includeHeaders()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public PartitionReaderFactory createReaderFactory() {
        return KafkaBatchReaderFactory$.MODULE$;
    }

    public Offset deserializeOffset(String json) {
        return new KafkaSourceOffset(JsonUtils$.MODULE$.partitionOffsets(json));
    }

    public void commit(Offset end) {
    }

    public void stop() {
        this.kafkaOffsetReader().close();
    }

    public String toString() {
        return new StringBuilder(9).append("KafkaV2[").append(this.kafkaOffsetReader()).append("]").toString();
    }

    public Map<String, String> metrics(Optional<Offset> latestConsumedOffset) {
        return KafkaMicroBatchStream$.MODULE$.metrics(latestConsumedOffset, this.latestPartitionOffsets());
    }

    private scala.collection.immutable.Map<TopicPartition, Object> getOrCreateInitialPartitionOffsets() {
        Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
        Predef$.MODULE$.assert(SparkSession$.MODULE$.getActiveSession().nonEmpty());
        KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter((SparkSession)SparkSession$.MODULE$.getActiveSession().get(), this.metadataPath);
        return ((KafkaSourceOffset)((Object)metadataLog.get(0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var3_12;
            KafkaSourceOffset kafkaSourceOffset;
            KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
            if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchEarliestOffsets());
            } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
            } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
                    this.reportDataLoss(message);
                    return BoxedUnit.UNIT;
                });
            } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                Enumeration.Value strategy = specificTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificTimestampBasedOffsets(p, true, strategy);
            } else if (kafkaOffsetRangeLimit instanceof GlobalTimestampRangeLimit) {
                GlobalTimestampRangeLimit globalTimestampRangeLimit = (GlobalTimestampRangeLimit)kafkaOffsetRangeLimit;
                long ts = globalTimestampRangeLimit.timestamp();
                Enumeration.Value strategy = globalTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchGlobalTimestampBasedOffsets(ts, true, strategy);
            } else {
                throw new MatchError((Object)kafkaOffsetRangeLimit);
            }
            KafkaSourceOffset offsets = kafkaSourceOffset;
            metadataLog.add(0L, (Object)offsets);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append((Object)offsets).toString());
            return var3_12;
        }))).partitionToOffsets();
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        LazyRef fromNew$lzy = new LazyRef();
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Iterable iterable = Option$.MODULE$.option2Iterable(from.get((Object)tp).orElse((Function0 & Serializable & scala.Serializable)() -> this.fromNew$1(fromNew$lzy, until, from).get((Object)tp)).flatMap((Function1 & Serializable & scala.Serializable)begin -> KafkaMicroBatchStream.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin))));
            return iterable;
        }, Map$.MODULE$.canBuildFrom());
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return total < 1.0 ? until : (scala.collection.immutable.Map)until.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)size -> {
                long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)this.fromNew$1(fromNew$lzy, until, from).apply((Object)tp))));
                double prorate = (double)limit * ((double)size / total);
                long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                return Math.min(end, off);
            }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> end));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString());
    }

    public static final /* synthetic */ long $anonfun$maxOffsetsPerTrigger$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static final /* synthetic */ long $anonfun$minOffsetPerTrigger$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ ReadLimit $anonfun$getDefaultReadLimit$1(long x$1) {
        return ReadLimit.maxRows((long)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$1(ReadLimit x$3) {
        return x$3 instanceof ReadAllAvailable;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$2(ReadLimit x$4) {
        return x$4 instanceof ReadMinRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$4(ReadLimit x$6) {
        return x$6 instanceof ReadMaxRows;
    }

    private final /* synthetic */ scala.collection.immutable.Map fromNew$lzycompute$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = fromNew$lzy$1;
        synchronized (lazyRef) {
            map = fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : (scala.collection.immutable.Map)fromNew$lzy$1.initialize(this.kafkaOffsetReader().fetchEarliestOffsets((Seq<TopicPartition>)until$1.keySet().diff((GenSet)from$1.keySet()).toSeq()));
        }
        return map;
    }

    private final scala.collection.immutable.Map fromNew$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        return fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : this.fromNew$lzycompute$1(fromNew$lzy$1, until$1, from$1);
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaMicroBatchStream $this, long end$1, TopicPartition tp$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("rateLimit ").append(tp$1).append(" size is ").append(size).toString());
        return size > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)BoxesRunTime.boxToLong((long)size))) : None$.MODULE$;
    }

    public KafkaMicroBatchStream(KafkaOffsetReader kafkaOffsetReader, Map<String, Object> executorKafkaParams, CaseInsensitiveStringMap options, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.kafkaOffsetReader = kafkaOffsetReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Logging.$init$((Logging)this);
        this.pollTimeoutMs = options.getLong(KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L);
        this.maxOffsetsPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)KafkaMicroBatchStream.$anonfun$maxOffsetsPerTrigger$1(x$1)));
        this.minOffsetPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MIN_OFFSET_PER_TRIGGER())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)KafkaMicroBatchStream.$anonfun$minOffsetPerTrigger$1(x$2)));
        this.maxTriggerDelayMs = Utils$.MODULE$.timeStringAsMs((String)Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_TRIGGER_DELAY())).getOrElse((Function0 & Serializable & scala.Serializable)() -> KafkaSourceProvider$.MODULE$.DEFAULT_MAX_TRIGGER_DELAY()));
        this.clock = options.containsKey((Object)KafkaSourceProvider$.MODULE$.MOCK_SYSTEM_TIME()) ? new MockedSystemClock() : new SystemClock();
        this.lastTriggerMillis = 0L;
        this.includeHeaders = options.getBoolean(KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), false);
    }
}

