/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class JsonUtils$ {
    public static JsonUtils$ MODULE$;
    private final Formats formats;

    static {
        new JsonUtils$();
    }

    private Formats formats() {
        return this.formats;
    }

    public TopicPartition[] partitions(String str) {
        TopicPartition[] topicPartitionArray;
        try {
            topicPartitionArray = (TopicPartition[])((TraversableOnce)((TraversableLike)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))})))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String topic = (String)tuple2._1();
                Seq parts = (Seq)tuple2._2();
                Seq seq = (Seq)parts.map((Function1 & Serializable & scala.Serializable)part -> JsonUtils$.$anonfun$partitions$2(topic, BoxesRunTime.unboxToInt((Object)part)), Seq$.MODULE$.canBuildFrom());
                return seq;
            }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TopicPartition.class));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(51).append("Expected e.g. {\"topicA\":[0,1],\"topicB\":[0,1]}, got ").append(str).toString());
            }
            throw throwable;
        }
        return topicPartitionArray;
    }

    public String partitions(Iterable<TopicPartition> partitions) {
        HashMap result = new HashMap();
        partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            List parts = (List)result.getOrElse((Object)tp.topic(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            int n = tp.partition();
            return result.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)parts.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n))));
        });
        return Serialization$.MODULE$.write((Object)result, this.formats());
    }

    public Map<TopicPartition, Object> partitionOffsets(String str) {
        Map map;
        try {
            map = (Map)((TraversableLike)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(Map.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Long()}))})))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String topic = (String)tuple2._1();
                Map partOffsets = (Map)tuple2._2();
                Map map = (Map)partOffsets.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int part = tuple2._1$mcI$sp();
                    long offset = tuple2._2$mcJ$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, part)), (Object)BoxesRunTime.boxToLong((long)offset));
                    return tuple22;
                }, Map$.MODULE$.canBuildFrom());
                return map;
            }, Map$.MODULE$.canBuildFrom());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(64).append("Expected e.g. {\"topicA\":{\"0\":23,\"1\":-1},\"topicB\":{\"0\":-2}}, got ").append(str).toString());
            }
            throw throwable;
        }
        return map;
    }

    public Map<TopicPartition, Object> partitionTimestamps(String str) {
        Map map;
        try {
            map = (Map)((TraversableLike)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(Map.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Long()}))})))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String topic = (String)tuple2._1();
                Map partTimestamps = (Map)tuple2._2();
                Map map = (Map)partTimestamps.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int part = tuple2._1$mcI$sp();
                    long timestamp = tuple2._2$mcJ$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, part)), (Object)BoxesRunTime.boxToLong((long)timestamp));
                    return tuple22;
                }, Map$.MODULE$.canBuildFrom());
                return map;
            }, Map$.MODULE$.canBuildFrom());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(122).append("Expected e.g. {\"topicA\": {\"0\": 123456789, \"1\": 123456789},\n             |\"topicB\": {\"0\": 123456789, \"1\": 123456789}}, got ").append(str).toString())).stripMargin());
            }
            throw throwable;
        }
        return map;
    }

    public String partitionOffsets(Map<TopicPartition, Object> partitionOffsets) {
        HashMap result = new HashMap();
        Ordering<TopicPartition> order = new Ordering<TopicPartition>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<TopicPartition> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, TopicPartition> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public int compare(TopicPartition x, TopicPartition y) {
                return package$.MODULE$.Ordering().Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$).compare((Object)new Tuple2((Object)x.topic(), (Object)BoxesRunTime.boxToInteger((int)x.partition())), (Object)new Tuple2((Object)y.topic(), (Object)BoxesRunTime.boxToInteger((int)y.partition())));
            }
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
        Seq partitions = (Seq)partitionOffsets.keySet().toSeq().sorted((Ordering)order);
        partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            long off = BoxesRunTime.unboxToLong((Object)partitionOffsets.apply(tp));
            HashMap parts = (HashMap)result.getOrElse((Object)tp.topic(), (Function0 & Serializable & scala.Serializable)() -> new HashMap());
            parts.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)BoxesRunTime.boxToLong((long)off)));
            return result.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)parts));
        });
        return Serialization$.MODULE$.write((Object)result, this.formats());
    }

    public String partitionTimestamps(Map<TopicPartition, Object> topicTimestamps) {
        return this.partitionOffsets(topicTimestamps);
    }

    public static final /* synthetic */ TopicPartition $anonfun$partitions$2(String topic$1, int part) {
        return new TopicPartition(topic$1, part);
    }

    private JsonUtils$() {
        MODULE$ = this;
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }
}

