/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.CompositeReadLimit;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.ReadMinRows;
import org.apache.spark.sql.connector.read.streaming.ReportsSourceMetrics;
import org.apache.spark.sql.connector.read.streaming.SupportsTriggerAvailableNow;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.JsonUtils$;
import org.apache.spark.sql.kafka010.KafkaBatchInputPartition;
import org.apache.spark.sql.kafka010.KafkaBatchReaderFactory$;
import org.apache.spark.sql.kafka010.KafkaExceptions$;
import org.apache.spark.sql.kafka010.KafkaMicroBatchStream$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.MockedSystemClock;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=d!B\u001c9\u0001a\u0012\u0005\"C1\u0001\u0005\u000b\u0007I\u0011\u0001\u001dc\u0011!A\u0007A!A!\u0002\u0013\u0019\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u0011u\u0004!\u0011!Q\u0001\nyD\u0011\"a\u0002\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0015\u0005%\u0001A!A!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u0012\u0001\u0011\t\u0011)A\u0005\u0003'Aq!a\u0007\u0001\t\u0003\ti\u0002\u0003\u0006\u0002.\u0001\u0011\r\u0011\"\u00019\u0003_A\u0001\"a\u000e\u0001A\u0003%\u0011\u0011\u0007\u0005\u000b\u0003s\u0001!\u0019!C\u0001q\u0005m\u0002\u0002CA\"\u0001\u0001\u0006I!!\u0010\t\u0015\u0005\u0015\u0003A1A\u0005\u0002a\nY\u0004\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA\u001f\u0011)\tI\u0005\u0001b\u0001\n\u0003A\u0014q\u0006\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u00022!Q\u0011Q\n\u0001C\u0002\u0013\u0005\u0001(a\u0014\t\u0011\u0005m\u0003\u0001)A\u0005\u0003#B\u0011\"!\u0018\u0001\u0001\u0004%I!a\f\t\u0013\u0005}\u0003\u00011A\u0005\n\u0005\u0005\u0004\u0002CA7\u0001\u0001\u0006K!!\r\t\u0013\u0005=\u0004A1A\u0005\n\u0005E\u0004\u0002CA:\u0001\u0001\u0006I!a\u0005\t\u0017\u0005U\u0004\u00011AA\u0002\u0013%\u0011q\u000f\u0005\f\u0003\u000f\u0003\u0001\u0019!a\u0001\n\u0013\tI\tC\u0006\u0002\u000e\u0002\u0001\r\u0011!Q!\n\u0005e\u0004bCAH\u0001\u0001\u0007\t\u0019!C\u0005\u0003oB1\"!%\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0014\"Y\u0011q\u0013\u0001A\u0002\u0003\u0005\u000b\u0015BA=\u0011%\tI\n\u0001a\u0001\n\u0013\t\t\bC\u0005\u0002\u001c\u0002\u0001\r\u0011\"\u0003\u0002\u001e\"A\u0011\u0011\u0015\u0001!B\u0013\t\u0019\u0002C\u0004\u0002$\u0002!\t%!*\t\u000f\u00055\u0006\u0001\"\u0011\u00020\"9\u0011q\u0017\u0001\u0005B\u0005\u0015\u0006bBA]\u0001\u0011\u0005\u0013Q\u0015\u0005\b\u0003s\u0003A\u0011IA^\u0011\u001d\t)\r\u0001C\u0005\u0003\u000fDq!a;\u0001\t\u0003\ni\u000fC\u0004\u0003\u0004\u0001!\tE!\u0002\t\u000f\t5\u0001\u0001\"\u0011\u0003\u0010!9!Q\u0003\u0001\u0005B\t]\u0001b\u0002B\u000e\u0001\u0011\u0005#Q\u0004\u0005\b\u0005?\u0001A\u0011\tB\u0011\u0011\u001d\u0011\u0019\u0003\u0001C!\u0005KAqAa\r\u0001\t\u0013\u0011)\u0004C\u0004\u00038\u0001!IA!\u000f\t\u000f\t\u001d\u0003\u0001\"\u0003\u0003J!9!q\n\u0001\u0005\n\tE\u0003b\u0002B,\u0001\u0011\u0005#QD\u0004\b\u00053B\u0004\u0012\u0001B.\r\u00199\u0004\b#\u0001\u0003^!9\u00111\u0004\u001b\u0005\u0002\t\u0015\u0004b\u0002B\u0012i\u0011\u0005!q\r\u0002\u0016\u0017\u000647.Y'jGJ|')\u0019;dQN#(/Z1n\u0015\tI$(\u0001\u0005lC\u001a\\\u0017\rM\u00191\u0015\tYD(A\u0002tc2T!!\u0010 \u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'oZ\n\u0007\u0001\r[U\u000bW.\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015\u0001\u00027b]\u001eT\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u000b\n1qJ\u00196fGR\u0004\"\u0001T*\u000e\u00035S!AT(\u0002\u0013M$(/Z1nS:<'B\u0001)R\u0003\u0011\u0011X-\u00193\u000b\u0005IS\u0014!C2p]:,7\r^8s\u0013\t!VJA\u000eTkB\u0004xN\u001d;t)JLwmZ3s\u0003Z\f\u0017\u000e\\1cY\u0016tun\u001e\t\u0003\u0019ZK!aV'\u0003)I+\u0007o\u001c:ugN{WO]2f\u001b\u0016$(/[2t!\ta\u0015,\u0003\u0002[\u001b\n\u0001R*[2s_\n\u000bGo\u00195TiJ,\u0017-\u001c\t\u00039~k\u0011!\u0018\u0006\u0003=r\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003Av\u0013q\u0001T8hO&tw-A\tlC\u001a\\\u0017m\u00144gg\u0016$(+Z1eKJ,\u0012a\u0019\t\u0003I\u0016l\u0011\u0001O\u0005\u0003Mb\u0012\u0011cS1gW\u0006|eMZ:fiJ+\u0017\rZ3s\u0007\u0001\t!c[1gW\u0006|eMZ:fiJ+\u0017\rZ3sA\u0005\u0019R\r_3dkR|'oS1gW\u0006\u0004\u0016M]1ngB!1N\u001c9D\u001b\u0005a'BA7H\u0003\u0011)H/\u001b7\n\u0005=d'aA'baB\u0011\u0011O\u001f\b\u0003eb\u0004\"a\u001d<\u000e\u0003QT!!^4\u0002\rq\u0012xn\u001c;?\u0015\u00059\u0018!B:dC2\f\u0017BA=w\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e4\u0018aB8qi&|gn\u001d\t\u0004\u007f\u0006\rQBAA\u0001\u0015\ti'(\u0003\u0003\u0002\u0006\u0005\u0005!\u0001G\"bg\u0016Len]3og&$\u0018N^3TiJLgnZ'ba\u0006aQ.\u001a;bI\u0006$\u0018\rU1uQ\u0006y1\u000f^1si&twm\u00144gg\u0016$8\u000fE\u0002e\u0003\u001bI1!a\u00049\u0005UY\u0015MZ6b\u001f\u001a47/\u001a;SC:<W\rT5nSR\faBZ1jY>sG)\u0019;b\u0019>\u001c8\u000f\u0005\u0003\u0002\u0016\u0005]Q\"\u0001<\n\u0007\u0005eaOA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)9\ty\"!\t\u0002$\u0005\u0015\u0012qEA\u0015\u0003W\u0001\"\u0001\u001a\u0001\t\u000b\u0005D\u0001\u0019A2\t\u000b%D\u0001\u0019\u00016\t\u000buD\u0001\u0019\u0001@\t\r\u0005\u001d\u0001\u00021\u0001q\u0011\u001d\tI\u0001\u0003a\u0001\u0003\u0017Aq!!\u0005\t\u0001\u0004\t\u0019\"A\u0007q_2dG+[7f_V$Xj]\u000b\u0003\u0003c\u0001B!!\u0006\u00024%\u0019\u0011Q\u0007<\u0003\t1{gnZ\u0001\u000fa>dG\u000eV5nK>,H/T:!\u0003Qi\u0017\r_(gMN,Go\u001d)feR\u0013\u0018nZ4feV\u0011\u0011Q\b\t\u0007\u0003+\ty$!\r\n\u0007\u0005\u0005cO\u0001\u0004PaRLwN\\\u0001\u0016[\u0006DxJ\u001a4tKR\u001c\b+\u001a:Ue&<w-\u001a:!\u0003Mi\u0017N\\(gMN,G\u000fU3s)JLwmZ3s\u0003Qi\u0017N\\(gMN,G\u000fU3s)JLwmZ3sA\u0005\tR.\u0019=Ue&<w-\u001a:EK2\f\u00170T:\u0002%5\f\u0007\u0010\u0016:jO\u001e,'\u000fR3mCfl5\u000fI\u0001\u0006G2|7m[\u000b\u0003\u0003#\u0002B!a\u0015\u0002X5\u0011\u0011Q\u000b\u0006\u0003[rJA!!\u0017\u0002V\t)1\t\\8dW\u000611\r\\8dW\u0002\n\u0011\u0003\\1tiR\u0013\u0018nZ4fe6KG\u000e\\5t\u0003Ua\u0017m\u001d;Ue&<w-\u001a:NS2d\u0017n]0%KF$B!a\u0019\u0002jA!\u0011QCA3\u0013\r\t9G\u001e\u0002\u0005+:LG\u000fC\u0005\u0002lQ\t\t\u00111\u0001\u00022\u0005\u0019\u0001\u0010J\u0019\u0002%1\f7\u000f\u001e+sS\u001e<WM]'jY2L7\u000fI\u0001\u000fS:\u001cG.\u001e3f\u0011\u0016\fG-\u001a:t+\t\t\u0019\"A\bj]\u000edW\u000fZ3IK\u0006$WM]:!\u0003Ya\u0017\r^3tiB\u000b'\u000f^5uS>twJ\u001a4tKR\u001cXCAA=!\u0011\tY(!!\u000f\u0007\u0011\fi(C\u0002\u0002\u0000a\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0004\u0006\u0015%A\u0005)beRLG/[8o\u001f\u001a47/\u001a;NCBT1!a 9\u0003ia\u0017\r^3tiB\u000b'\u000f^5uS>twJ\u001a4tKR\u001cx\fJ3r)\u0011\t\u0019'a#\t\u0013\u0005-\u0014$!AA\u0002\u0005e\u0014a\u00067bi\u0016\u001cH\u000fU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:!\u0003u\tG\u000e\u001c#bi\u00064uN\u001d+sS\u001e<WM]!wC&d\u0017M\u00197f\u001d><\u0018!I1mY\u0012\u000bG/\u0019$peR\u0013\u0018nZ4fe\u00063\u0018-\u001b7bE2,gj\\<`I\u0015\fH\u0003BA2\u0003+C\u0011\"a\u001b\u001d\u0003\u0003\u0005\r!!\u001f\u0002=\u0005dG\u000eR1uC\u001a{'\u000f\u0016:jO\u001e,'/\u0011<bS2\f'\r\\3O_^\u0004\u0013!F5t)JLwmZ3s\u0003Z\f\u0017\u000e\\1cY\u0016tun^\u0001\u001aSN$&/[4hKJ\fe/Y5mC\ndWMT8x?\u0012*\u0017\u000f\u0006\u0003\u0002d\u0005}\u0005\"CA6?\u0005\u0005\t\u0019AA\n\u0003YI7\u000f\u0016:jO\u001e,'/\u0011<bS2\f'\r\\3O_^\u0004\u0013!D5oSRL\u0017\r\\(gMN,G\u000f\u0006\u0002\u0002(B\u0019A*!+\n\u0007\u0005-VJ\u0001\u0004PM\u001a\u001cX\r^\u0001\u0014O\u0016$H)\u001a4bk2$(+Z1e\u0019&l\u0017\u000e\u001e\u000b\u0003\u0003c\u00032\u0001TAZ\u0013\r\t),\u0014\u0002\n%\u0016\fG\rT5nSR\f!C]3q_J$H*\u0019;fgR|eMZ:fi\u0006aA.\u0019;fgR|eMZ:fiR1\u0011qUA_\u0003\u0003Dq!a0&\u0001\u0004\t9+A\u0003ti\u0006\u0014H\u000fC\u0004\u0002D\u0016\u0002\r!!-\u0002\u0013I,\u0017\r\u001a'j[&$\u0018A\u00033fY\u0006L()\u0019;dQRQ\u00111CAe\u0003\u001b\f)/!;\t\u000f\u0005-g\u00051\u0001\u00022\u0005AQ.\u001b8MS6LG\u000fC\u0004\u0002P\u001a\u0002\r!!5\u0002\u001b1\fG/Z:u\u001f\u001a47/\u001a;t!\u001d\t\u00181[Ak\u0003cI!a\u001c?\u0011\t\u0005]\u0017\u0011]\u0007\u0003\u00033TA!a7\u0002^\u000611m\\7n_:T1!a8?\u0003\u0015Y\u0017MZ6b\u0013\u0011\t\u0019/!7\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011q\u001d\u0014A\u0002\u0005E\u0017AD2veJ,g\u000e^(gMN,Go\u001d\u0005\b\u0003\u00132\u0003\u0019AA\u0019\u0003M\u0001H.\u00198J]B,H\u000fU1si&$\u0018n\u001c8t)\u0019\ty/!@\u0002\u0000B1\u0011QCAy\u0003kL1!a=w\u0005\u0015\t%O]1z!\u0011\t90!?\u000e\u0003=K1!a?P\u00059Ie\u000e];u!\u0006\u0014H/\u001b;j_:Dq!a0(\u0001\u0004\t9\u000bC\u0004\u0003\u0002\u001d\u0002\r!a*\u0002\u0007\u0015tG-A\nde\u0016\fG/\u001a*fC\u0012,'OR1di>\u0014\u0018\u0010\u0006\u0002\u0003\bA!\u0011q\u001fB\u0005\u0013\r\u0011Ya\u0014\u0002\u0017!\u0006\u0014H/\u001b;j_:\u0014V-\u00193fe\u001a\u000b7\r^8ss\u0006\tB-Z:fe&\fG.\u001b>f\u001f\u001a47/\u001a;\u0015\t\u0005\u001d&\u0011\u0003\u0005\u0007\u0005'I\u0003\u0019\u00019\u0002\t)\u001cxN\\\u0001\u0007G>lW.\u001b;\u0015\t\u0005\r$\u0011\u0004\u0005\b\u0005\u0003Q\u0003\u0019AAT\u0003\u0011\u0019Ho\u001c9\u0015\u0005\u0005\r\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003A\fq!\\3ue&\u001c7\u000f\u0006\u0003\u0003(\t%\u0002\u0003B6oaBDqAa\u000b.\u0001\u0004\u0011i#\u0001\u000bmCR,7\u000f^\"p]N,X.\u001a3PM\u001a\u001cX\r\u001e\t\u0006W\n=\u0012qU\u0005\u0004\u0005ca'\u0001C(qi&|g.\u00197\u0002E\u001d,Go\u0014:De\u0016\fG/Z%oSRL\u0017\r\u001c)beRLG/[8o\u001f\u001a47/\u001a;t)\t\tI(A\u0005sCR,G*[7jiRA\u0011\u0011\u0010B\u001e\u0005\u007f\u0011\u0019\u0005C\u0004\u0003>=\u0002\r!!\r\u0002\u000b1LW.\u001b;\t\u000f\t\u0005s\u00061\u0001\u0002z\u0005!aM]8n\u0011\u001d\u0011)e\fa\u0001\u0003s\nQ!\u001e8uS2\faB]3q_J$H)\u0019;b\u0019>\u001c8\u000f\u0006\u0003\u0002d\t-\u0003B\u0002B'a\u0001\u0007\u0001/A\u0004nKN\u001c\u0018mZ3\u0002KY,'/\u001b4z\u000b:$wJ\u001a4tKR4uN\u001d+sS\u001e<WM]!wC&d\u0017M\u00197f\u001d><H\u0003BA2\u0005'BqA!\u00162\u0001\u0004\t\t.A\nf]\u0012\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$8/A\u000fqe\u0016\u0004\u0018M]3G_J$&/[4hKJ\fe/Y5mC\ndWMT8x\u0003UY\u0015MZ6b\u001b&\u001c'o\u001c\"bi\u000eD7\u000b\u001e:fC6\u0004\"\u0001\u001a\u001b\u0014\tQ\u0012yf\u0017\t\u0005\u0003+\u0011\t'C\u0002\u0003dY\u0014a!\u00118z%\u00164GC\u0001B.)\u0019\u00119C!\u001b\u0003l!9!1\u0006\u001cA\u0002\t5\u0002b\u0002B7m\u0001\u0007\u0011\u0011P\u0001 Y\u0006$Xm\u001d;Bm\u0006LG.\u00192mKB\u000b'\u000f^5uS>twJ\u001a4tKR\u001c\b")
public class KafkaMicroBatchStream
implements SupportsTriggerAvailableNow,
ReportsSourceMetrics,
MicroBatchStream,
Logging {
    private final KafkaOffsetReader kafkaOffsetReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final Option<Object> minOffsetPerTrigger;
    private final long maxTriggerDelayMs;
    private final Clock clock;
    private long lastTriggerMillis;
    private final boolean includeHeaders;
    private scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets;
    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow;
    private boolean isTriggerAvailableNow;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public KafkaOffsetReader kafkaOffsetReader() {
        return this.kafkaOffsetReader;
    }

    public long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    public Option<Object> minOffsetPerTrigger() {
        return this.minOffsetPerTrigger;
    }

    public long maxTriggerDelayMs() {
        return this.maxTriggerDelayMs;
    }

    public Clock clock() {
        return this.clock;
    }

    private long lastTriggerMillis() {
        return this.lastTriggerMillis;
    }

    private void lastTriggerMillis_$eq(long x$1) {
        this.lastTriggerMillis = x$1;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets() {
        return this.latestPartitionOffsets;
    }

    private void latestPartitionOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.latestPartitionOffsets = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow() {
        return this.allDataForTriggerAvailableNow;
    }

    private void allDataForTriggerAvailableNow_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.allDataForTriggerAvailableNow = x$1;
    }

    private boolean isTriggerAvailableNow() {
        return this.isTriggerAvailableNow;
    }

    private void isTriggerAvailableNow_$eq(boolean x$1) {
        this.isTriggerAvailableNow = x$1;
    }

    public Offset initialOffset() {
        return new KafkaSourceOffset(this.getOrCreateInitialPartitionOffsets());
    }

    public ReadLimit getDefaultReadLimit() {
        if (this.minOffsetPerTrigger().isDefined() && this.maxOffsetsPerTrigger().isDefined()) {
            return ReadLimit.compositeLimit((ReadLimit[])((ReadLimit[])((Object[])new ReadLimit[]{ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()), ReadLimit.maxRows((long)BoxesRunTime.unboxToLong((Object)this.maxOffsetsPerTrigger().get()))})));
        }
        if (this.minOffsetPerTrigger().isDefined()) {
            return ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs());
        }
        return (ReadLimit)this.maxOffsetsPerTrigger().map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaMicroBatchStream.$anonfun$getDefaultReadLimit$1(BoxesRunTime.unboxToLong((Object)x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ReadLimit.allAvailable());
    }

    public Offset reportLatestOffset() {
        return (Offset)Option$.MODULE$.apply((Object)new KafkaSourceOffset(this.latestPartitionOffsets())).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$reportLatestOffset$1(x$3))).orNull(Predef$.MODULE$.$conforms());
    }

    public Offset latestOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset latestOffset(Offset start, ReadLimit readLimit) {
        scala.collection.immutable.Map map;
        Seq limits;
        Seq seq;
        scala.collection.immutable.Map<TopicPartition, Object> map2;
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        if (this.isTriggerAvailableNow()) {
            if (this.allDataForTriggerAvailableNow() != null) {
                map2 = this.allDataForTriggerAvailableNow();
            } else {
                this.allDataForTriggerAvailableNow_$eq(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(startPartitionOffsets)));
                map2 = this.allDataForTriggerAvailableNow();
            }
        } else {
            map2 = this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(startPartitionOffsets));
        }
        this.latestPartitionOffsets_$eq(map2);
        ReadLimit readLimit2 = readLimit;
        if (readLimit2 instanceof CompositeReadLimit) {
            CompositeReadLimit compositeReadLimit = (CompositeReadLimit)readLimit2;
            seq = Predef$.MODULE$.wrapRefArray((Object[])compositeReadLimit.getReadLimits());
        } else {
            seq = limits = (Seq)new .colon.colon((Object)readLimit2, (List)Nil$.MODULE$);
        }
        if (limits.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$1(x$4)))) {
            map = this.latestPartitionOffsets();
        } else {
            Option lowerLimit = limits.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$2(x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> (ReadMinRows)x$6);
            Option upperLimit = limits.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$4(x$7))).map((Function1 & Serializable & scala.Serializable)x$8 -> (ReadMaxRows)x$8);
            map = (scala.collection.immutable.Map)lowerLimit.flatMap((Function1 & Serializable & scala.Serializable)limit -> {
                boolean skipBatch = this.delayBatch(limit.minRows(), this.latestPartitionOffsets(), startPartitionOffsets, limit.maxTriggerDelayMs());
                if (skipBatch) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Delaying batch as number of records available is less than minOffsetsPerTrigger");
                    return new Some((Object)startPartitionOffsets);
                }
                return None$.MODULE$;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> upperLimit.map((Function1 & Serializable & scala.Serializable)limit -> this.rateLimit(limit.maxRows(), startPartitionOffsets, this.latestPartitionOffsets()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.latestPartitionOffsets());
        }
        scala.collection.immutable.Map offsets = map;
        return (Offset)Option$.MODULE$.apply((Object)new KafkaSourceOffset(offsets)).filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$11(x$9))).orNull(Predef$.MODULE$.$conforms());
    }

    private boolean delayBatch(long minLimit, scala.collection.immutable.Map<TopicPartition, Object> latestOffsets, scala.collection.immutable.Map<TopicPartition, Object> currentOffsets, long maxTriggerDelayMs) {
        if (this.clock().getTimeMillis() - this.lastTriggerMillis() >= maxTriggerDelayMs) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Maximum wait time is passed, triggering batch");
            this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
            return false;
        }
        double newRecords = BoxesRunTime.unboxToLong((Object)((MapLike)latestOffsets.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition topic = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToLong((long)(offset - BoxesRunTime.unboxToLong((Object)currentOffsets.getOrElse((Object)topic, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))))));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (newRecords < (double)minLimit) {
            return true;
        }
        this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
        return false;
    }

    public InputPartition[] planInputPartitions(Offset start, Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        scala.collection.immutable.Map<TopicPartition, Object> endPartitionOffsets = ((KafkaSourceOffset)end).partitionToOffsets();
        if (this.allDataForTriggerAvailableNow() != null) {
            this.verifyEndOffsetForTriggerAvailableNow(endPartitionOffsets);
        }
        Seq<KafkaOffsetRange> offsetRanges = this.kafkaOffsetReader().getOffsetRangesFromResolvedOffsets(startPartitionOffsets, endPartitionOffsets, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
            this.reportDataLoss(message);
            return BoxedUnit.UNIT;
        });
        return (InputPartition[])((TraversableOnce)offsetRanges.map((Function1 & Serializable & scala.Serializable)range -> new KafkaBatchInputPartition((KafkaOffsetRange)range, $this.executorKafkaParams, this.pollTimeoutMs(), $this.failOnDataLoss, this.includeHeaders()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public PartitionReaderFactory createReaderFactory() {
        return KafkaBatchReaderFactory$.MODULE$;
    }

    public Offset deserializeOffset(String json) {
        return new KafkaSourceOffset(JsonUtils$.MODULE$.partitionOffsets(json));
    }

    public void commit(Offset end) {
    }

    public void stop() {
        this.kafkaOffsetReader().close();
    }

    public String toString() {
        return new StringBuilder(9).append("KafkaV2[").append(this.kafkaOffsetReader()).append("]").toString();
    }

    public Map<String, String> metrics(Optional<Offset> latestConsumedOffset) {
        return KafkaMicroBatchStream$.MODULE$.metrics(latestConsumedOffset, this.latestPartitionOffsets());
    }

    private scala.collection.immutable.Map<TopicPartition, Object> getOrCreateInitialPartitionOffsets() {
        Predef$.MODULE$.assert(SparkSession$.MODULE$.getActiveSession().nonEmpty());
        KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter((SparkSession)SparkSession$.MODULE$.getActiveSession().get(), this.metadataPath);
        return ((KafkaSourceOffset)((Object)metadataLog.get(0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            KafkaSourceOffset kafkaSourceOffset;
            KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
            if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchEarliestOffsets());
            } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
            } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
                    this.reportDataLoss(message);
                    return BoxedUnit.UNIT;
                });
            } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                Enumeration.Value strategy = specificTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificTimestampBasedOffsets(p, true, strategy);
            } else if (kafkaOffsetRangeLimit instanceof GlobalTimestampRangeLimit) {
                GlobalTimestampRangeLimit globalTimestampRangeLimit = (GlobalTimestampRangeLimit)kafkaOffsetRangeLimit;
                long ts = globalTimestampRangeLimit.timestamp();
                Enumeration.Value strategy = globalTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchGlobalTimestampBasedOffsets(ts, true, strategy);
            } else {
                throw new MatchError((Object)kafkaOffsetRangeLimit);
            }
            KafkaSourceOffset offsets = kafkaSourceOffset;
            metadataLog.add(0L, (Object)offsets);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append((Object)offsets).toString());
            return offsets;
        }))).partitionToOffsets();
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        LazyRef fromNew$lzy = new LazyRef();
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                long end = tuple2._2$mcJ$sp();
                return Option$.MODULE$.option2Iterable(from.get((Object)tp).orElse((Function0 & Serializable & scala.Serializable)() -> this.fromNew$1(fromNew$lzy, until, from).get((Object)tp)).flatMap((Function1 & Serializable & scala.Serializable)begin -> KafkaMicroBatchStream.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin))));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (total < 1.0) {
            return until;
        }
        return (scala.collection.immutable.Map)until.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                long end = tuple2._2$mcJ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)size -> {
                    long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)this.fromNew$1(fromNew$lzy, until, from).apply((Object)tp))));
                    double prorate = (double)limit * ((double)size / total);
                    long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                    long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                    return Math.min(end, off);
                }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> end));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString());
    }

    private void verifyEndOffsetForTriggerAvailableNow(scala.collection.immutable.Map<TopicPartition, Object> endPartitionOffsets) {
        Set tpsForPrefetched = this.allDataForTriggerAvailableNow().keySet();
        Set tpsForEndOffset = endPartitionOffsets.keySet();
        Set set = tpsForPrefetched;
        Set set2 = tpsForEndOffset;
        if (set == null ? set2 != null : !set.equals(set2)) {
            throw KafkaExceptions$.MODULE$.mismatchedTopicPartitionsBetweenEndOffsetAndPrefetched((Set<TopicPartition>)tpsForPrefetched, (Set<TopicPartition>)tpsForEndOffset);
        }
        boolean endOffsetHasGreaterThanPrefetched = this.allDataForTriggerAvailableNow().keySet().exists((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$verifyEndOffsetForTriggerAvailableNow$1(this, endPartitionOffsets, tp)));
        if (endOffsetHasGreaterThanPrefetched) {
            throw KafkaExceptions$.MODULE$.endOffsetHasGreaterOffsetForTopicPartitionThanPrefetched(this.allDataForTriggerAvailableNow(), endPartitionOffsets);
        }
        scala.collection.immutable.Map<TopicPartition, Object> latestOffsets = this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(endPartitionOffsets));
        Set tpsForLatestOffsets = latestOffsets.keySet();
        if (!tpsForEndOffset.subsetOf((GenSet)tpsForLatestOffsets)) {
            throw KafkaExceptions$.MODULE$.lostTopicPartitionsInEndOffsetWithTriggerAvailableNow((Set<TopicPartition>)tpsForLatestOffsets, (Set<TopicPartition>)tpsForEndOffset);
        }
        boolean endOffsetHasGreaterThenLatest = tpsForEndOffset.exists((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$verifyEndOffsetForTriggerAvailableNow$2(latestOffsets, endPartitionOffsets, tp)));
        if (endOffsetHasGreaterThenLatest) {
            throw KafkaExceptions$.MODULE$.endOffsetHasGreaterOffsetForTopicPartitionThanLatestWithTriggerAvailableNow(latestOffsets, endPartitionOffsets);
        }
    }

    public void prepareForTriggerAvailableNow() {
        this.isTriggerAvailableNow_$eq(true);
    }

    public static final /* synthetic */ long $anonfun$maxOffsetsPerTrigger$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static final /* synthetic */ long $anonfun$minOffsetPerTrigger$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ ReadLimit $anonfun$getDefaultReadLimit$1(long x$1) {
        return ReadLimit.maxRows((long)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$reportLatestOffset$1(KafkaSourceOffset x$3) {
        return x$3.partitionToOffsets().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$1(ReadLimit x$4) {
        return x$4 instanceof ReadAllAvailable;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$2(ReadLimit x$5) {
        return x$5 instanceof ReadMinRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$4(ReadLimit x$7) {
        return x$7 instanceof ReadMaxRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$11(KafkaSourceOffset x$9) {
        return x$9.partitionToOffsets().isEmpty();
    }

    private final /* synthetic */ scala.collection.immutable.Map fromNew$lzycompute$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = fromNew$lzy$1;
        synchronized (lazyRef) {
            map = fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : (scala.collection.immutable.Map)fromNew$lzy$1.initialize(this.kafkaOffsetReader().fetchEarliestOffsets((Seq<TopicPartition>)until$1.keySet().diff((GenSet)from$1.keySet()).toSeq()));
        }
        return map;
    }

    private final scala.collection.immutable.Map fromNew$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        if (fromNew$lzy$1.initialized()) {
            return (scala.collection.immutable.Map)fromNew$lzy$1.value();
        }
        return this.fromNew$lzycompute$1(fromNew$lzy$1, until$1, from$1);
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaMicroBatchStream $this, long end$1, TopicPartition tp$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("rateLimit ").append(tp$1).append(" size is ").append(size).toString());
        if (size > 0L) {
            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)BoxesRunTime.boxToLong((long)size)));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$verifyEndOffsetForTriggerAvailableNow$1(KafkaMicroBatchStream $this, scala.collection.immutable.Map endPartitionOffsets$1, TopicPartition tp) {
        long offsetFromPrefetched = BoxesRunTime.unboxToLong((Object)$this.allDataForTriggerAvailableNow().apply((Object)tp));
        long offsetFromEndOffset = BoxesRunTime.unboxToLong((Object)endPartitionOffsets$1.apply((Object)tp));
        return offsetFromEndOffset > offsetFromPrefetched;
    }

    public static final /* synthetic */ boolean $anonfun$verifyEndOffsetForTriggerAvailableNow$2(scala.collection.immutable.Map latestOffsets$1, scala.collection.immutable.Map endPartitionOffsets$1, TopicPartition tp) {
        long offsetFromLatest = BoxesRunTime.unboxToLong((Object)latestOffsets$1.apply((Object)tp));
        long offsetFromEndOffset = BoxesRunTime.unboxToLong((Object)endPartitionOffsets$1.apply((Object)tp));
        return offsetFromEndOffset > offsetFromLatest;
    }

    public KafkaMicroBatchStream(KafkaOffsetReader kafkaOffsetReader, Map<String, Object> executorKafkaParams, CaseInsensitiveStringMap options, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.kafkaOffsetReader = kafkaOffsetReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Logging.$init$((Logging)this);
        this.pollTimeoutMs = options.getLong(KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L);
        this.maxOffsetsPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)KafkaMicroBatchStream.$anonfun$maxOffsetsPerTrigger$1(x$1)));
        this.minOffsetPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MIN_OFFSET_PER_TRIGGER())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)KafkaMicroBatchStream.$anonfun$minOffsetPerTrigger$1(x$2)));
        this.maxTriggerDelayMs = Utils$.MODULE$.timeStringAsMs((String)Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_TRIGGER_DELAY())).getOrElse((Function0 & Serializable & scala.Serializable)() -> KafkaSourceProvider$.MODULE$.DEFAULT_MAX_TRIGGER_DELAY()));
        this.clock = options.containsKey((Object)KafkaSourceProvider$.MODULE$.MOCK_SYSTEM_TIME()) ? new MockedSystemClock() : new SystemClock();
        this.lastTriggerMillis = 0L;
        this.includeHeaders = options.getBoolean(KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), false);
        this.isTriggerAvailableNow = false;
    }
}

