/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.read.streaming.CompositeReadLimit;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.ReadMinRows;
import org.apache.spark.sql.connector.read.streaming.SupportsTriggerAvailableNow;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.KafkaExceptions$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter$;
import org.apache.spark.sql.kafka010.KafkaSource$;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceOffset$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaSourceRDD;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.MockedSystemClock;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg!B\u001e=\u0001q2\u0005\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u00111\u0004!\u0011!Q\u0001\n5D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u001d\u0005\u000b\u0003\u0017\u0001!\u0011!Q\u0001\n\u00055\u0001\"CA\u000e\u0001\t\u0005\t\u0015!\u0003y\u0011)\ti\u0002\u0001B\u0001B\u0003%\u0011q\u0004\u0005\u000b\u0003K\u0001!\u0011!Q\u0001\n\u0005\u001d\u0002bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\n\u0003\u0007\u0002!\u0019!C\u0005\u0003\u000bB\u0001\"a\u0014\u0001A\u0003%\u0011q\t\u0005\n\u0003#\u0002!\u0019!C\u0005\u0003'B\u0001\"a\u0017\u0001A\u0003%\u0011Q\u000b\u0005\n\u0003;\u0002!\u0019!C\u0005\u0003?B\u0001\"a\u001a\u0001A\u0003%\u0011\u0011\r\u0005\u000b\u0003S\u0002!\u0019!C\u0001y\u0005}\u0003\u0002CA6\u0001\u0001\u0006I!!\u0019\t\u0015\u00055\u0004A1A\u0005\u0002q\n\u0019\u0006\u0003\u0005\u0002p\u0001\u0001\u000b\u0011BA+\u0011)\t\t\b\u0001b\u0001\n\u0003a\u00141\u000f\u0005\t\u0003\u007f\u0002\u0001\u0015!\u0003\u0002v!I\u0011\u0011\u0011\u0001C\u0002\u0013%\u00111\u0011\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002(!I\u0011q\u0011\u0001A\u0002\u0013%\u00111\u000b\u0005\n\u0003\u0013\u0003\u0001\u0019!C\u0005\u0003\u0017C\u0001\"a&\u0001A\u0003&\u0011Q\u000b\u0005\f\u00033\u0003\u0001\u0019!a\u0001\n\u0013\tY\nC\u0006\u0002,\u0002\u0001\r\u00111A\u0005\n\u00055\u0006bCAY\u0001\u0001\u0007\t\u0011)Q\u0005\u0003;C\u0011\"a-\u0001\u0001\u0004%I!a!\t\u0013\u0005U\u0006\u00011A\u0005\n\u0005]\u0006\u0002CA^\u0001\u0001\u0006K!a\n\t\u0015\u0005u\u0006\u0001#b\u0001\n\u0013\ty\fC\u0004\u0002V\u0002!\t%a6\t\u0013\u0005}\u0007\u00011A\u0005\n\u0005\u0005\b\"CAs\u0001\u0001\u0007I\u0011BAt\u0011!\tY\u000f\u0001Q!\n\u0005\r\b\"CAw\u0001\u0001\u0007I\u0011BAq\u0011%\ty\u000f\u0001a\u0001\n\u0013\t\t\u0010\u0003\u0005\u0002v\u0002\u0001\u000b\u0015BAr\u0011%\t9\u0010\u0001b\u0001\n\u0013\tI\u0010\u0003\u0005\u0003\u0002\u0001\u0001\u000b\u0011BA~\u0011\u001d\u0011\u0019\u0001\u0001C!\u0005\u000bAqAa\u0005\u0001\t\u0003\u0012)\u0002C\u0004\u0003 \u0001!\tE!\t\t\u000f\t\u001d\u0002\u0001\"\u0011\u0003*!9!1\u0007\u0001\u0005\n\tU\u0002b\u0002B#\u0001\u0011%!q\t\u0005\b\u0005'\u0002A\u0011\tB+\u0011\u001d\u0011Y\b\u0001C!\u0005{BqAa \u0001\t\u0003\u0012\t\tC\u0004\u0003\u0004\u0002!IA!\"\t\u000f\t-\u0005\u0001\"\u0003\u0003\u000e\"9!1\u0013\u0001\u0005B\tut\u0001\u0003BKy!\u0005AHa&\u0007\u000fmb\u0004\u0012\u0001\u001f\u0003\u001a\"9\u0011qF\u001c\u0005\u0002\t\u0005\u0006b\u0002BRo\u0011\u0005!Q\u0015\u0005\b\u0005_;D\u0011\u0002BY\u0005-Y\u0015MZ6b'>,(oY3\u000b\u0005ur\u0014\u0001C6bM.\f\u0007'\r\u0019\u000b\u0005}\u0002\u0015aA:rY*\u0011\u0011IQ\u0001\u0006gB\f'o\u001b\u0006\u0003\u0007\u0012\u000ba!\u00199bG\",'\"A#\u0002\u0007=\u0014xmE\u0003\u0001\u000f>K\u0006\r\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006!A.\u00198h\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT%\u0003\r=\u0013'.Z2u!\t\u0001v+D\u0001R\u0015\t\u00116+A\u0005tiJ,\u0017-\\5oO*\u0011A+V\u0001\u0005e\u0016\fGM\u0003\u0002W}\u0005I1m\u001c8oK\u000e$xN]\u0005\u00031F\u00131dU;qa>\u0014Ho\u001d+sS\u001e<WM]!wC&d\u0017M\u00197f\u001d><\bC\u0001._\u001b\u0005Y&B\u0001*]\u0015\tif(A\u0005fq\u0016\u001cW\u000f^5p]&\u0011ql\u0017\u0002\u0007'>,(oY3\u0011\u0005\u0005$W\"\u00012\u000b\u0005\r\u0004\u0015\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0015\u0014'a\u0002'pO\u001eLgnZ\u0001\u000bgFd7i\u001c8uKb$8\u0001\u0001\t\u0003S*l\u0011AP\u0005\u0003Wz\u0012!bU)M\u0007>tG/\u001a=u\u0003-Y\u0017MZ6b%\u0016\fG-\u001a:\u0011\u00059|W\"\u0001\u001f\n\u0005Ad$!E&bM.\fwJ\u001a4tKR\u0014V-\u00193fe\u0006\u0019R\r_3dkR|'oS1gW\u0006\u0004\u0016M]1ngB!1O\u001e=H\u001b\u0005!(BA;L\u0003\u0011)H/\u001b7\n\u0005]$(aA'baB\u0019\u00110!\u0002\u000f\u0007i\f\t\u0001\u0005\u0002|}6\tAP\u0003\u0002~O\u00061AH]8pizR\u0011a`\u0001\u0006g\u000e\fG.Y\u0005\u0004\u0003\u0007q\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002\b\u0005%!AB*ue&twMC\u0002\u0002\u0004y\fQb]8ve\u000e,w\n\u001d;j_:\u001c\b#BA\b\u0003/AXBAA\t\u0015\r)\u00181\u0003\u0006\u0004\u0003+q\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005e\u0011\u0011\u0003\u0002\u0013\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wK6\u000b\u0007/\u0001\u0007nKR\fG-\u0019;b!\u0006$\b.A\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;t!\rq\u0017\u0011E\u0005\u0004\u0003Ga$!F&bM.\fwJ\u001a4tKR\u0014\u0016M\\4f\u0019&l\u0017\u000e^\u0001\u000fM\u0006LGn\u00148ECR\fGj\\:t!\u0011\tI#a\u000b\u000e\u0003yL1!!\f\u007f\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003EA\u001a\u0003k\t9$!\u000f\u0002<\u0005u\u0012qHA!!\tq\u0007\u0001C\u0003g\u0011\u0001\u0007\u0001\u000eC\u0003m\u0011\u0001\u0007Q\u000eC\u0003r\u0011\u0001\u0007!\u000fC\u0004\u0002\f!\u0001\r!!\u0004\t\r\u0005m\u0001\u00021\u0001y\u0011\u001d\ti\u0002\u0003a\u0001\u0003?Aq!!\n\t\u0001\u0004\t9#\u0001\u0002tGV\u0011\u0011q\t\t\u0005\u0003\u0013\nY%D\u0001A\u0013\r\ti\u0005\u0011\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0004g\u000e\u0004\u0013!\u00049pY2$\u0016.\\3pkRl5/\u0006\u0002\u0002VA!\u0011\u0011FA,\u0013\r\tIF \u0002\u0005\u0019>tw-\u0001\bq_2dG+[7f_V$Xj\u001d\u0011\u0002)5\f\u0007p\u00144gg\u0016$8\u000fU3s)JLwmZ3s+\t\t\t\u0007\u0005\u0004\u0002*\u0005\r\u0014QK\u0005\u0004\u0003Kr(AB(qi&|g.A\u000bnCb|eMZ:fiN\u0004VM\u001d+sS\u001e<WM\u001d\u0011\u0002'5Lgn\u00144gg\u0016$\b+\u001a:Ue&<w-\u001a:\u0002)5Lgn\u00144gg\u0016$\b+\u001a:Ue&<w-\u001a:!\u0003Ei\u0017\r\u001f+sS\u001e<WM\u001d#fY\u0006LXj]\u0001\u0013[\u0006DHK]5hO\u0016\u0014H)\u001a7bs6\u001b\b%A\u0003dY>\u001c7.\u0006\u0002\u0002vA!\u0011qOA>\u001b\t\tIH\u0003\u0002v\u0001&!\u0011QPA=\u0005\u0015\u0019En\\2l\u0003\u0019\u0019Gn\\2lA\u0005q\u0011N\\2mk\u0012,\u0007*Z1eKJ\u001cXCAA\u0014\u0003=Ign\u00197vI\u0016DU-\u00193feN\u0004\u0013!\u00057bgR$&/[4hKJl\u0015\u000e\u001c7jg\u0006)B.Y:u)JLwmZ3s\u001b&dG.[:`I\u0015\fH\u0003BAG\u0003'\u0003B!!\u000b\u0002\u0010&\u0019\u0011\u0011\u0013@\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003+C\u0012\u0011!a\u0001\u0003+\n1\u0001\u001f\u00132\u0003Ia\u0017m\u001d;Ue&<w-\u001a:NS2d\u0017n\u001d\u0011\u0002;\u0005dG\u000eR1uC\u001a{'\u000f\u0016:jO\u001e,'/\u0011<bS2\f'\r\\3O_^,\"!!(\u0011\t\u0005}\u0015Q\u0015\b\u0004]\u0006\u0005\u0016bAARy\u00059\u0001/Y2lC\u001e,\u0017\u0002BAT\u0003S\u0013!\u0003U1si&$\u0018n\u001c8PM\u001a\u001cX\r^'ba*\u0019\u00111\u0015\u001f\u0002C\u0005dG\u000eR1uC\u001a{'\u000f\u0016:jO\u001e,'/\u0011<bS2\f'\r\\3O_^|F%Z9\u0015\t\u00055\u0015q\u0016\u0005\n\u0003+[\u0012\u0011!a\u0001\u0003;\u000ba$\u00197m\t\u0006$\u0018MR8s)JLwmZ3s\u0003Z\f\u0017\u000e\\1cY\u0016tun\u001e\u0011\u0002+%\u001cHK]5hO\u0016\u0014\u0018I^1jY\u0006\u0014G.\u001a(po\u0006I\u0012n\u001d+sS\u001e<WM]!wC&d\u0017M\u00197f\u001d><x\fJ3r)\u0011\ti)!/\t\u0013\u0005Ue$!AA\u0002\u0005\u001d\u0012AF5t)JLwmZ3s\u0003Z\f\u0017\u000e\\1cY\u0016tun\u001e\u0011\u0002/%t\u0017\u000e^5bYB\u000b'\u000f^5uS>twJ\u001a4tKR\u001cXCAAa!\u001dI\u00181YAc\u0003+J1a^A\u0005!\u0011\t9-!5\u000e\u0005\u0005%'\u0002BAf\u0003\u001b\faaY8n[>t'bAAh\u0005\u0006)1.\u00194lC&!\u00111[Ae\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1cZ3u\t\u00164\u0017-\u001e7u%\u0016\fG\rT5nSR$\"!!7\u0011\u0007A\u000bY.C\u0002\u0002^F\u0013\u0011BU3bI2KW.\u001b;\u0002/\r,(O]3oiB\u000b'\u000f^5uS>twJ\u001a4tKR\u001cXCAAr!\u0019\tI#a\u0019\u0002B\u0006Y2-\u001e:sK:$\b+\u0019:uSRLwN\\(gMN,Go]0%KF$B!!$\u0002j\"I\u0011QS\u0012\u0002\u0002\u0003\u0007\u00111]\u0001\u0019GV\u0014(/\u001a8u!\u0006\u0014H/\u001b;j_:|eMZ:fiN\u0004\u0013A\u00067bi\u0016\u001cH\u000fU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:\u000251\fG/Z:u!\u0006\u0014H/\u001b;j_:|eMZ:fiN|F%Z9\u0015\t\u00055\u00151\u001f\u0005\n\u0003+3\u0013\u0011!a\u0001\u0003G\fq\u0003\\1uKN$\b+\u0019:uSRLwN\\(gMN,Go\u001d\u0011\u0002\u0013\r|gN^3si\u0016\u0014XCAA~!\rq\u0017Q`\u0005\u0004\u0003\u007fd$!G&bM.\f'+Z2pe\u0012$vNU8x\u0007>tg/\u001a:uKJ\f!bY8om\u0016\u0014H/\u001a:!\u0003\u0019\u00198\r[3nCV\u0011!q\u0001\t\u0005\u0005\u0013\u0011y!\u0004\u0002\u0003\f)\u0019!Q\u0002 \u0002\u000bQL\b/Z:\n\t\tE!1\u0002\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017!C4fi>3gm]3u+\t\u00119\u0002\u0005\u0004\u0002*\u0005\r$\u0011\u0004\t\u00045\nm\u0011b\u0001B\u000f7\n1qJ\u001a4tKR\f!C]3q_J$H*\u0019;fgR|eMZ:fiR\u0011!1\u0005\t\u0004!\n\u0015\u0012b\u0001B\u000f#\u0006aA.\u0019;fgR|eMZ:fiR1!1\u0005B\u0016\u0005_AqA!\f.\u0001\u0004\u0011\u0019#A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bb\u0002B\u0019[\u0001\u0007\u0011\u0011\\\u0001\u0006Y&l\u0017\u000e^\u0001\u000bI\u0016d\u0017-\u001f\"bi\u000eDGCCA\u0014\u0005o\u0011YDa\u0010\u0003D!9!\u0011\b\u0018A\u0002\u0005U\u0013\u0001C7j]2KW.\u001b;\t\u000f\tub\u00061\u0001\u0002B\u0006iA.\u0019;fgR|eMZ:fiNDqA!\u0011/\u0001\u0004\t\t-\u0001\bdkJ\u0014XM\u001c;PM\u001a\u001cX\r^:\t\u000f\u00055d\u00061\u0001\u0002V\u0005I!/\u0019;f\u0019&l\u0017\u000e\u001e\u000b\t\u0003\u0003\u0014IEa\u0013\u0003P!9!\u0011G\u0018A\u0002\u0005U\u0003b\u0002B'_\u0001\u0007\u0011\u0011Y\u0001\u0005MJ|W\u000eC\u0004\u0003R=\u0002\r!!1\u0002\u000bUtG/\u001b7\u0002\u0011\u001d,GOQ1uG\"$bAa\u0016\u0003t\t]\u0004\u0003\u0002B-\u0005[rAAa\u0017\u0003l9!!Q\fB5\u001d\u0011\u0011yFa\u001a\u000f\t\t\u0005$Q\r\b\u0004w\n\r\u0014\"A#\n\u0005\r#\u0015BA!C\u0013\ty\u0004)C\u0002\u0002$zJAAa\u001c\u0003r\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003Gs\u0004b\u0002B;a\u0001\u0007!qC\u0001\u0006gR\f'\u000f\u001e\u0005\b\u0005s\u0002\u0004\u0019\u0001B\r\u0003\r)g\u000eZ\u0001\u0005gR|\u0007\u000f\u0006\u0002\u0002\u000e\u0006AAo\\*ue&tw\rF\u0001y\u00039\u0011X\r]8si\u0012\u000bG/\u0019'pgN$B!!$\u0003\b\"1!\u0011R\u001aA\u0002a\fq!\\3tg\u0006<W-A\u0013wKJLg-_#oI>3gm]3u\r>\u0014HK]5hO\u0016\u0014\u0018I^1jY\u0006\u0014G.\u001a(poR!\u0011Q\u0012BH\u0011\u001d\u0011\t\n\u000ea\u0001\u0003\u0003\f1#\u001a8e!\u0006\u0014H/\u001b;j_:|eMZ:fiN\fQ\u0004\u001d:fa\u0006\u0014XMR8s)JLwmZ3s\u0003Z\f\u0017\u000e\\1cY\u0016tun^\u0001\f\u0017\u000647.Y*pkJ\u001cW\r\u0005\u0002ooM\u0019qGa'\u0011\t\u0005%\"QT\u0005\u0004\u0005?s(AB!osJ+g\r\u0006\u0002\u0003\u0018\u0006)r-\u001a;T_J$X\rZ#yK\u000e,Ho\u001c:MSN$H\u0003\u0002BT\u0005[\u0003R!!\u000b\u0003*bL1Aa+\u007f\u0005\u0015\t%O]1z\u0011\u001d\t\u0019%\u000fa\u0001\u0003\u000f\nqaY8na\u0006\u0014X\r\u0006\u0004\u0002(\tM&1\u0019\u0005\b\u0005kS\u0004\u0019\u0001B\\\u0003\u0005\t\u0007\u0003\u0002B]\u0005\u007fk!Aa/\u000b\u0007\tu\u0006)A\u0005tG\",G-\u001e7fe&!!\u0011\u0019B^\u0005e)\u00050Z2vi>\u00148)Y2iKR\u000b7o\u001b'pG\u0006$\u0018n\u001c8\t\u000f\t\u0015'\b1\u0001\u00038\u0006\t!\r")
public class KafkaSource
implements SupportsTriggerAvailableNow,
Source,
Logging {
    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets;
    private final SQLContext sqlContext;
    private final KafkaOffsetReader kafkaReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final SparkContext sc;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final Option<Object> minOffsetPerTrigger;
    private final long maxTriggerDelayMs;
    private final Clock clock;
    private final boolean includeHeaders;
    private long lastTriggerMillis;
    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow;
    private boolean isTriggerAvailableNow;
    private Option<scala.collection.immutable.Map<TopicPartition, Object>> currentPartitionOffsets;
    private Option<scala.collection.immutable.Map<TopicPartition, Object>> latestPartitionOffsets;
    private final KafkaRecordToRowConverter converter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static String[] getSortedExecutorList(SparkContext sparkContext) {
        return KafkaSource$.MODULE$.getSortedExecutorList(sparkContext);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void commit(org.apache.spark.sql.execution.streaming.Offset end) {
        Source.commit$((Source)this, (org.apache.spark.sql.execution.streaming.Offset)end);
    }

    public Offset initialOffset() {
        return Source.initialOffset$((Source)this);
    }

    public Offset deserializeOffset(String json) {
        return Source.deserializeOffset$((Source)this, (String)json);
    }

    public void commit(Offset end) {
        Source.commit$((Source)this, (Offset)end);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    private Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    public Option<Object> minOffsetPerTrigger() {
        return this.minOffsetPerTrigger;
    }

    public long maxTriggerDelayMs() {
        return this.maxTriggerDelayMs;
    }

    public Clock clock() {
        return this.clock;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private long lastTriggerMillis() {
        return this.lastTriggerMillis;
    }

    private void lastTriggerMillis_$eq(long x$1) {
        this.lastTriggerMillis = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow() {
        return this.allDataForTriggerAvailableNow;
    }

    private void allDataForTriggerAvailableNow_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.allDataForTriggerAvailableNow = x$1;
    }

    private boolean isTriggerAvailableNow() {
        return this.isTriggerAvailableNow;
    }

    private void isTriggerAvailableNow_$eq(boolean x$1) {
        this.isTriggerAvailableNow = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets$lzycompute() {
        KafkaSource kafkaSource = this;
        synchronized (kafkaSource) {
            if (!this.bitmap$0) {
                KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter(this.sqlContext.sparkSession(), this.metadataPath);
                this.initialPartitionOffsets = ((KafkaSourceOffset)((Object)metadataLog.get(0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    KafkaSourceOffset kafkaSourceOffset;
                    KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
                    if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                        kafkaSourceOffset = new KafkaSourceOffset($this.kafkaReader.fetchEarliestOffsets());
                    } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                        kafkaSourceOffset = new KafkaSourceOffset($this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
                    } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                        SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                        scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                        kafkaSourceOffset = $this.kafkaReader.fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
                            this.reportDataLoss(message);
                            return BoxedUnit.UNIT;
                        });
                    } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                        SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                        scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                        Enumeration.Value strategy = specificTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                        kafkaSourceOffset = $this.kafkaReader.fetchSpecificTimestampBasedOffsets(p, true, strategy);
                    } else if (kafkaOffsetRangeLimit instanceof GlobalTimestampRangeLimit) {
                        GlobalTimestampRangeLimit globalTimestampRangeLimit = (GlobalTimestampRangeLimit)kafkaOffsetRangeLimit;
                        long ts = globalTimestampRangeLimit.timestamp();
                        Enumeration.Value strategy = globalTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                        kafkaSourceOffset = $this.kafkaReader.fetchGlobalTimestampBasedOffsets(ts, true, strategy);
                    } else {
                        throw new MatchError((Object)kafkaOffsetRangeLimit);
                    }
                    KafkaSourceOffset offsets = kafkaSourceOffset;
                    metadataLog.add(0L, (Object)offsets);
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append((Object)offsets).toString());
                    return offsets;
                }))).partitionToOffsets();
                this.bitmap$0 = true;
            }
        }
        return this.initialPartitionOffsets;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets() {
        if (!this.bitmap$0) {
            return this.initialPartitionOffsets$lzycompute();
        }
        return this.initialPartitionOffsets;
    }

    public ReadLimit getDefaultReadLimit() {
        if (this.minOffsetPerTrigger().isDefined() && this.maxOffsetsPerTrigger().isDefined()) {
            return ReadLimit.compositeLimit((ReadLimit[])((ReadLimit[])((Object[])new ReadLimit[]{ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()), ReadLimit.maxRows((long)BoxesRunTime.unboxToLong((Object)this.maxOffsetsPerTrigger().get()))})));
        }
        if (this.minOffsetPerTrigger().isDefined()) {
            return ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs());
        }
        return (ReadLimit)this.maxOffsetsPerTrigger().map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaSource.$anonfun$getDefaultReadLimit$1(BoxesRunTime.unboxToLong((Object)x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ReadLimit.allAvailable());
    }

    private Option<scala.collection.immutable.Map<TopicPartition, Object>> currentPartitionOffsets() {
        return this.currentPartitionOffsets;
    }

    private void currentPartitionOffsets_$eq(Option<scala.collection.immutable.Map<TopicPartition, Object>> x$1) {
        this.currentPartitionOffsets = x$1;
    }

    private Option<scala.collection.immutable.Map<TopicPartition, Object>> latestPartitionOffsets() {
        return this.latestPartitionOffsets;
    }

    private void latestPartitionOffsets_$eq(Option<scala.collection.immutable.Map<TopicPartition, Object>> x$1) {
        this.latestPartitionOffsets = x$1;
    }

    private KafkaRecordToRowConverter converter() {
        return this.converter;
    }

    public StructType schema() {
        return KafkaRecordToRowConverter$.MODULE$.kafkaSchema(this.includeHeaders());
    }

    public Option<org.apache.spark.sql.execution.streaming.Offset> getOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset reportLatestOffset() {
        return (Offset)this.latestPartitionOffsets().map((Function1 & Serializable & scala.Serializable)x$3 -> new KafkaSourceOffset((scala.collection.immutable.Map<TopicPartition, Object>)x$3)).orNull(Predef$.MODULE$.$conforms());
    }

    public Offset latestOffset(Offset startOffset, ReadLimit limit2) {
        scala.collection.immutable.Map map;
        Seq limits;
        Seq seq;
        scala.collection.immutable.Map map2;
        this.initialPartitionOffsets();
        Option currentOffsets = this.currentPartitionOffsets().orElse((Function0 & Serializable & scala.Serializable)() -> new Some(this.initialPartitionOffsets()));
        if (this.isTriggerAvailableNow()) {
            if (this.allDataForTriggerAvailableNow() != null) {
                map2 = this.allDataForTriggerAvailableNow();
            } else {
                this.allDataForTriggerAvailableNow_$eq(this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)currentOffsets));
                map2 = this.allDataForTriggerAvailableNow();
            }
        } else {
            map2 = this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)currentOffsets);
        }
        scala.collection.immutable.Map latest = map2;
        this.latestPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)(latest.isEmpty() ? None$.MODULE$ : new Some(latest)));
        ReadLimit readLimit = limit2;
        if (readLimit instanceof CompositeReadLimit) {
            CompositeReadLimit compositeReadLimit = (CompositeReadLimit)readLimit;
            seq = Predef$.MODULE$.wrapRefArray((Object[])compositeReadLimit.getReadLimits());
        } else {
            seq = limits = (Seq)new .colon.colon((Object)readLimit, (List)Nil$.MODULE$);
        }
        if (limits.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$2(x$4)))) {
            map = latest;
        } else {
            Option lowerLimit = limits.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$3(x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> (ReadMinRows)x$6);
            Option upperLimit = limits.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$5(x$7))).map((Function1 & Serializable & scala.Serializable)x$8 -> (ReadMaxRows)x$8);
            map = (scala.collection.immutable.Map)lowerLimit.flatMap((Function1 & Serializable & scala.Serializable)limit -> {
                boolean skipBatch = this.delayBatch(limit.minRows(), (scala.collection.immutable.Map<TopicPartition, Object>)latest, (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)currentOffsets.get()), limit.maxTriggerDelayMs());
                if (skipBatch) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Delaying batch as number of records available is less than minOffsetsPerTrigger");
                    return new Some(currentOffsets.get());
                }
                return None$.MODULE$;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> upperLimit.map((Function1 & Serializable & scala.Serializable)limit -> this.rateLimit(limit.maxRows(), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)this.currentPartitionOffsets().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.initialPartitionOffsets())), (scala.collection.immutable.Map<TopicPartition, Object>)latest))).getOrElse((Function0 & Serializable & scala.Serializable)() -> latest);
        }
        scala.collection.immutable.Map offsets = map;
        this.currentPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(offsets));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("GetOffset: ").append(((SeqLike)offsets.toSeq().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toString(), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).toString());
        return (Offset)Option$.MODULE$.apply((Object)new KafkaSourceOffset(offsets)).filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$15(x$10))).orNull(Predef$.MODULE$.$conforms());
    }

    private boolean delayBatch(long minLimit, scala.collection.immutable.Map<TopicPartition, Object> latestOffsets, scala.collection.immutable.Map<TopicPartition, Object> currentOffsets, long maxTriggerDelayMs) {
        if (this.clock().getTimeMillis() - this.lastTriggerMillis() >= maxTriggerDelayMs) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Maximum wait time is passed, triggering batch");
            this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
            return false;
        }
        double newRecords = BoxesRunTime.unboxToLong((Object)((MapLike)latestOffsets.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition topic = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToLong((long)(offset - BoxesRunTime.unboxToLong((Object)currentOffsets.getOrElse((Object)topic, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))))));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (newRecords < (double)minLimit) {
            return true;
        }
        this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
        return false;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        LazyRef fromNew$lzy = new LazyRef();
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                long end = tuple2._2$mcJ$sp();
                return Option$.MODULE$.option2Iterable(from.get((Object)tp).orElse((Function0 & Serializable & scala.Serializable)() -> this.fromNew$1(fromNew$lzy, until, from).get((Object)tp)).flatMap((Function1 & Serializable & scala.Serializable)begin -> KafkaSource.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin))));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (total < 1.0) {
            return until;
        }
        return (scala.collection.immutable.Map)until.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                long end = tuple2._2$mcJ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)size -> {
                    long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)this.fromNew$1(fromNew$lzy, until, from).apply((Object)tp))));
                    double prorate = (double)limit * ((double)size / total);
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("rateLimit ").append(tp).append(" prorated amount is ").append(prorate).toString());
                    long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                    long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("rateLimit ").append(tp).append(" new offset is ").append(off).toString());
                    return Math.min(end, off);
                }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> end));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Dataset<Row> getBatch(Option<org.apache.spark.sql.execution.streaming.Offset> start, org.apache.spark.sql.execution.streaming.Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> map;
        Option<org.apache.spark.sql.execution.streaming.Offset> option;
        this.initialPartitionOffsets();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("GetBatch called with start = ").append(start).append(", end = ").append(end).toString());
        scala.collection.immutable.Map<TopicPartition, Object> untilPartitionOffsets = KafkaSourceOffset$.MODULE$.getPartitionOffsets(end);
        if (this.allDataForTriggerAvailableNow() != null) {
            this.verifyEndOffsetForTriggerAvailableNow(untilPartitionOffsets);
        }
        if (this.currentPartitionOffsets().isEmpty()) {
            this.currentPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(untilPartitionOffsets));
        }
        if (start.isDefined()) {
            Object object = start.get();
            org.apache.spark.sql.execution.streaming.Offset offset = end;
            if (!(object != null ? !object.equals(offset) : offset != null)) {
                return this.sqlContext.internalCreateDataFrame(this.sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)).setName("empty"), this.schema(), true);
            }
        }
        if ((option = start) instanceof Some) {
            Some some = (Some)option;
            org.apache.spark.sql.execution.streaming.Offset prevBatchEndOffset = (org.apache.spark.sql.execution.streaming.Offset)some.value();
            map = KafkaSourceOffset$.MODULE$.getPartitionOffsets(prevBatchEndOffset);
        } else if (None$.MODULE$.equals(option)) {
            map = this.initialPartitionOffsets();
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Map<TopicPartition, Object> fromPartitionOffsets = map;
        Seq<KafkaOffsetRange> offsetRanges = this.kafkaReader.getOffsetRangesFromResolvedOffsets(fromPartitionOffsets, untilPartitionOffsets, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
            this.reportDataLoss(message);
            return BoxedUnit.UNIT;
        });
        RDD rdd = this.includeHeaders() ? new KafkaSourceRDD(this.sc(), this.executorKafkaParams, offsetRanges, this.pollTimeoutMs(), this.failOnDataLoss).map(this.converter().toInternalRowWithHeaders(), ClassTag$.MODULE$.apply(InternalRow.class)) : new KafkaSourceRDD(this.sc(), this.executorKafkaParams, offsetRanges, this.pollTimeoutMs(), this.failOnDataLoss).map(this.converter().toInternalRowWithoutHeaders(), ClassTag$.MODULE$.apply(InternalRow.class));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("GetBatch generating RDD of offset range: ").append(((TraversableOnce)offsetRanges.sortBy((Function1 & Serializable & scala.Serializable)x$11 -> x$11.topicPartition().toString(), (Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString());
        return this.sqlContext.internalCreateDataFrame(rdd.setName("kafka"), this.schema(), true);
    }

    public synchronized void stop() {
        this.kafkaReader.close();
    }

    public String toString() {
        return new StringBuilder(15).append("KafkaSourceV1[").append(this.kafkaReader).append("]").toString();
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString());
    }

    private void verifyEndOffsetForTriggerAvailableNow(scala.collection.immutable.Map<TopicPartition, Object> endPartitionOffsets) {
        Set tpsForPrefetched = this.allDataForTriggerAvailableNow().keySet();
        Set tpsForEndOffset = endPartitionOffsets.keySet();
        Set set = tpsForPrefetched;
        Set set2 = tpsForEndOffset;
        if (set == null ? set2 != null : !set.equals(set2)) {
            throw KafkaExceptions$.MODULE$.mismatchedTopicPartitionsBetweenEndOffsetAndPrefetched((Set<TopicPartition>)tpsForPrefetched, (Set<TopicPartition>)tpsForEndOffset);
        }
        boolean endOffsetHasGreaterThanPrefetched = this.allDataForTriggerAvailableNow().keySet().exists((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$verifyEndOffsetForTriggerAvailableNow$1(this, endPartitionOffsets, tp)));
        if (endOffsetHasGreaterThanPrefetched) {
            throw KafkaExceptions$.MODULE$.endOffsetHasGreaterOffsetForTopicPartitionThanPrefetched(this.allDataForTriggerAvailableNow(), endPartitionOffsets);
        }
        scala.collection.immutable.Map<TopicPartition, Object> latestOffsets = this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(endPartitionOffsets));
        Set tpsForLatestOffsets = latestOffsets.keySet();
        if (!tpsForEndOffset.subsetOf((GenSet)tpsForLatestOffsets)) {
            throw KafkaExceptions$.MODULE$.lostTopicPartitionsInEndOffsetWithTriggerAvailableNow((Set<TopicPartition>)tpsForLatestOffsets, (Set<TopicPartition>)tpsForEndOffset);
        }
        boolean endOffsetHasGreaterThenLatest = tpsForEndOffset.exists((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$verifyEndOffsetForTriggerAvailableNow$2(latestOffsets, endPartitionOffsets, tp)));
        if (endOffsetHasGreaterThenLatest) {
            throw KafkaExceptions$.MODULE$.endOffsetHasGreaterOffsetForTopicPartitionThanLatestWithTriggerAvailableNow(latestOffsets, endPartitionOffsets);
        }
    }

    public void prepareForTriggerAvailableNow() {
        this.isTriggerAvailableNow_$eq(true);
    }

    public static final /* synthetic */ long $anonfun$maxOffsetsPerTrigger$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static final /* synthetic */ long $anonfun$minOffsetPerTrigger$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ ReadLimit $anonfun$getDefaultReadLimit$1(long x$1) {
        return ReadLimit.maxRows((long)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$2(ReadLimit x$4) {
        return x$4 instanceof ReadAllAvailable;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$3(ReadLimit x$5) {
        return x$5 instanceof ReadMinRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$5(ReadLimit x$7) {
        return x$7 instanceof ReadMaxRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$15(KafkaSourceOffset x$10) {
        return x$10.partitionToOffsets().isEmpty();
    }

    private final /* synthetic */ scala.collection.immutable.Map fromNew$lzycompute$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = fromNew$lzy$1;
        synchronized (lazyRef) {
            map = fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : (scala.collection.immutable.Map)fromNew$lzy$1.initialize(this.kafkaReader.fetchEarliestOffsets((Seq<TopicPartition>)until$1.keySet().diff((GenSet)from$1.keySet()).toSeq()));
        }
        return map;
    }

    private final scala.collection.immutable.Map fromNew$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        if (fromNew$lzy$1.initialized()) {
            return (scala.collection.immutable.Map)fromNew$lzy$1.value();
        }
        return this.fromNew$lzycompute$1(fromNew$lzy$1, until$1, from$1);
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaSource $this, long end$1, TopicPartition tp$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("rateLimit ").append(tp$1).append(" size is ").append(size).toString());
        if (size > 0L) {
            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)BoxesRunTime.boxToLong((long)size)));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$verifyEndOffsetForTriggerAvailableNow$1(KafkaSource $this, scala.collection.immutable.Map endPartitionOffsets$1, TopicPartition tp) {
        long offsetFromPrefetched = BoxesRunTime.unboxToLong((Object)$this.allDataForTriggerAvailableNow().apply((Object)tp));
        long offsetFromEndOffset = BoxesRunTime.unboxToLong((Object)endPartitionOffsets$1.apply((Object)tp));
        return offsetFromEndOffset > offsetFromPrefetched;
    }

    public static final /* synthetic */ boolean $anonfun$verifyEndOffsetForTriggerAvailableNow$2(scala.collection.immutable.Map latestOffsets$1, scala.collection.immutable.Map endPartitionOffsets$1, TopicPartition tp) {
        long offsetFromLatest = BoxesRunTime.unboxToLong((Object)latestOffsets$1.apply((Object)tp));
        long offsetFromEndOffset = BoxesRunTime.unboxToLong((Object)endPartitionOffsets$1.apply((Object)tp));
        return offsetFromEndOffset > offsetFromLatest;
    }

    public KafkaSource(SQLContext sqlContext, KafkaOffsetReader kafkaReader, Map<String, Object> executorKafkaParams, CaseInsensitiveMap<String> sourceOptions, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.sqlContext = sqlContext;
        this.kafkaReader = kafkaReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Source.$init$((Source)this);
        Logging.$init$((Logging)this);
        this.sc = sqlContext.sparkContext();
        this.pollTimeoutMs = new StringOps(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), (Function0 & Serializable & scala.Serializable)() -> Long.toString(BoxesRunTime.unboxToLong((Object)this.sc().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L)))).toLong();
        this.maxOffsetsPerTrigger = sourceOptions.get(KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)KafkaSource.$anonfun$maxOffsetsPerTrigger$1(x$1)));
        this.minOffsetPerTrigger = sourceOptions.get(KafkaSourceProvider$.MODULE$.MIN_OFFSET_PER_TRIGGER()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)KafkaSource.$anonfun$minOffsetPerTrigger$1(x$2)));
        this.maxTriggerDelayMs = Utils$.MODULE$.timeStringAsMs((String)sourceOptions.get(KafkaSourceProvider$.MODULE$.MAX_TRIGGER_DELAY()).getOrElse((Function0 & Serializable & scala.Serializable)() -> KafkaSourceProvider$.MODULE$.DEFAULT_MAX_TRIGGER_DELAY()));
        this.clock = sourceOptions.contains(KafkaSourceProvider$.MODULE$.MOCK_SYSTEM_TIME()) ? new MockedSystemClock() : new SystemClock();
        this.includeHeaders = new StringOps(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
        this.lastTriggerMillis = 0L;
        this.isTriggerAvailableNow = false;
        this.currentPartitionOffsets = None$.MODULE$;
        this.latestPartitionOffsets = None$.MODULE$;
        this.converter = new KafkaRecordToRowConverter();
    }
}

