/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.read.streaming.CompositeReadLimit;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.ReadMinRows;
import org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter$;
import org.apache.spark.sql.kafka010.KafkaSource$;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceOffset$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaSourceRDD;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tud!\u0002\u001a4\u0001Mj\u0004\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011D\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\ty\u0002\u0011\t\u0011)A\u0005{\"I\u0011\u0011\u0002\u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\u000b\u0003\u0017\u0001!\u0011!Q\u0001\n\u00055\u0001BCA\n\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0011!\ti\u0004\u0001Q\u0001\n\u0005U\u0002\"CA \u0001\t\u0007I\u0011BA!\u0011!\tI\u0005\u0001Q\u0001\n\u0005\r\u0003\"CA&\u0001\t\u0007I\u0011BA'\u0011!\t)\u0006\u0001Q\u0001\n\u0005=\u0003BCA,\u0001\t\u0007I\u0011A\u001a\u0002N!A\u0011\u0011\f\u0001!\u0002\u0013\ty\u0005\u0003\u0006\u0002\\\u0001\u0011\r\u0011\"\u00014\u0003\u0003B\u0001\"!\u0018\u0001A\u0003%\u00111\t\u0005\n\u0003?\u0002!\u0019!C\u0005\u0003CB\u0001\"a\u0019\u0001A\u0003%\u0011Q\u0003\u0005\n\u0003K\u0002\u0001\u0019!C\u0005\u0003\u0003B\u0011\"a\u001a\u0001\u0001\u0004%I!!\u001b\t\u0011\u0005U\u0004\u0001)Q\u0005\u0003\u0007B!\"a\u001e\u0001\u0011\u000b\u0007I\u0011BA=\u0011\u001d\ty\t\u0001C!\u0003#C\u0011\"!'\u0001\u0001\u0004%I!a'\t\u0013\u0005}\u0005\u00011A\u0005\n\u0005\u0005\u0006\u0002CAS\u0001\u0001\u0006K!!(\t\u0013\u0005\u001d\u0006\u00011A\u0005\n\u0005m\u0005\"CAU\u0001\u0001\u0007I\u0011BAV\u0011!\ty\u000b\u0001Q!\n\u0005u\u0005\"CAY\u0001\t\u0007I\u0011BAZ\u0011!\tY\f\u0001Q\u0001\n\u0005U\u0006bBA_\u0001\u0011\u0005\u0013q\u0018\u0005\b\u0003\u001b\u0004A\u0011IAh\u0011\u001d\tI\u000e\u0001C!\u00037Dq!!9\u0001\t\u0003\n\u0019\u000fC\u0004\u0002n\u0002!I!a<\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002!9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\u001c\u0001\u0011\u0005#\u0011\b\u0005\b\u0005w\u0001A\u0011\tB\u001f\u0011\u001d\u0011y\u0004\u0001C\u0005\u0005\u0003BaBa\u0012\u0001!\u0003\r\t\u0011!C\u0005\u0003#\u0013Ie\u0002\u0005\u0003LMB\ta\rB'\r\u001d\u00114\u0007#\u00014\u0005\u001fBq!!\b/\t\u0003\u00119\u0006C\u0004\u0003Z9\"\tAa\u0017\t\u000f\t\u0015d\u0006\"\u0003\u0003h\tY1*\u00194lCN{WO]2f\u0015\t!T'\u0001\u0005lC\u001a\\\u0017\rM\u00191\u0015\t1t'A\u0002tc2T!\u0001O\u001d\u0002\u000bM\u0004\u0018M]6\u000b\u0005iZ\u0014AB1qC\u000eDWMC\u0001=\u0003\ry'oZ\n\u0006\u0001y2\u0005k\u0016\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bA\u0001\\1oO*\t1)\u0001\u0003kCZ\f\u0017BA#A\u0005\u0019y%M[3diB\u0011qIT\u0007\u0002\u0011*\u0011\u0011JS\u0001\ngR\u0014X-Y7j]\u001eT!a\u0013'\u0002\tI,\u0017\r\u001a\u0006\u0003\u001bV\n\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005=C%\u0001G*vaB|'\u000f^:BI6L7o]5p]\u000e{g\u000e\u001e:pYB\u0011\u0011+V\u0007\u0002%*\u0011\u0011j\u0015\u0006\u0003)V\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005Y\u0013&AB*pkJ\u001cW\r\u0005\u0002Y76\t\u0011L\u0003\u0002[o\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002]3\n9Aj\\4hS:<\u0017AC:rY\u000e{g\u000e^3yi\u000e\u0001\u0001C\u00011b\u001b\u0005)\u0014B\u000126\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010^\u0001\fW\u000647.\u0019*fC\u0012,'\u000f\u0005\u0002fM6\t1'\u0003\u0002hg\t\t2*\u00194lC>3gm]3u%\u0016\fG-\u001a:\u0002'\u0015DXmY;u_J\\\u0015MZ6b!\u0006\u0014\u0018-\\:\u0011\t)lwNP\u0007\u0002W*\u0011ANQ\u0001\u0005kRLG.\u0003\u0002oW\n\u0019Q*\u00199\u0011\u0005ALhBA9x!\t\u0011X/D\u0001t\u0015\t!h,\u0001\u0004=e>|GO\u0010\u0006\u0002m\u0006)1oY1mC&\u0011\u00010^\u0001\u0007!J,G-\u001a4\n\u0005i\\(AB*ue&twM\u0003\u0002yk\u0006i1o\\;sG\u0016|\u0005\u000f^5p]N\u0004BA`A\u0003_6\tqPC\u0002m\u0003\u0003Q1!a\u00016\u0003!\u0019\u0017\r^1msN$\u0018bAA\u0004\u007f\n\u00112)Y:f\u0013:\u001cXM\\:ji&4X-T1q\u00031iW\r^1eCR\f\u0007+\u0019;i\u0003=\u0019H/\u0019:uS:<wJ\u001a4tKR\u001c\bcA3\u0002\u0010%\u0019\u0011\u0011C\u001a\u0003+-\u000bgm[1PM\u001a\u001cX\r\u001e*b]\u001e,G*[7ji\u0006qa-Y5m\u001f:$\u0015\r^1M_N\u001c\b\u0003BA\f\u00033i\u0011!^\u0005\u0004\u00037)(a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005\u0005\u00121EA\u0013\u0003O\tI#a\u000b\u0002.\u0005=\u0002CA3\u0001\u0011\u0015i\u0006\u00021\u0001`\u0011\u0015\u0019\u0007\u00021\u0001e\u0011\u0015A\u0007\u00021\u0001j\u0011\u0015a\b\u00021\u0001~\u0011\u0019\tI\u0001\u0003a\u0001_\"9\u00111\u0002\u0005A\u0002\u00055\u0001bBA\n\u0011\u0001\u0007\u0011QC\u0001\u0003g\u000e,\"!!\u000e\u0011\t\u0005]\u0012\u0011H\u0007\u0002o%\u0019\u00111H\u001c\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\u0002\u0007M\u001c\u0007%A\u0007q_2dG+[7f_V$Xj]\u000b\u0003\u0003\u0007\u0002B!a\u0006\u0002F%\u0019\u0011qI;\u0003\t1{gnZ\u0001\u000fa>dG\u000eV5nK>,H/T:!\u0003Qi\u0017\r_(gMN,Go\u001d)feR\u0013\u0018nZ4feV\u0011\u0011q\n\t\u0007\u0003/\t\t&a\u0011\n\u0007\u0005MSO\u0001\u0004PaRLwN\\\u0001\u0016[\u0006DxJ\u001a4tKR\u001c\b+\u001a:Ue&<w-\u001a:!\u0003Mi\u0017N\\(gMN,G\u000fU3s)JLwmZ3s\u0003Qi\u0017N\\(gMN,G\u000fU3s)JLwmZ3sA\u0005\tR.\u0019=Ue&<w-\u001a:EK2\f\u00170T:\u0002%5\f\u0007\u0010\u0016:jO\u001e,'\u000fR3mCfl5\u000fI\u0001\u000fS:\u001cG.\u001e3f\u0011\u0016\fG-\u001a:t+\t\t)\"A\bj]\u000edW\u000fZ3IK\u0006$WM]:!\u0003Ea\u0017m\u001d;Ue&<w-\u001a:NS2d\u0017n]\u0001\u0016Y\u0006\u001cH\u000f\u0016:jO\u001e,'/T5mY&\u001cx\fJ3r)\u0011\tY'!\u001d\u0011\t\u0005]\u0011QN\u0005\u0004\u0003_*(\u0001B+oSRD\u0011\"a\u001d\u0017\u0003\u0003\u0005\r!a\u0011\u0002\u0007a$\u0013'\u0001\nmCN$HK]5hO\u0016\u0014X*\u001b7mSN\u0004\u0013aF5oSRL\u0017\r\u001c)beRLG/[8o\u001f\u001a47/\u001a;t+\t\tY\bE\u0004q\u0003{\ny(a\u0011\n\u00059\\\b\u0003BAA\u0003\u0017k!!a!\u000b\t\u0005\u0015\u0015qQ\u0001\u0007G>lWn\u001c8\u000b\u0007\u0005%\u0015(A\u0003lC\u001a\\\u0017-\u0003\u0003\u0002\u000e\u0006\r%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0014O\u0016$H)\u001a4bk2$(+Z1e\u0019&l\u0017\u000e\u001e\u000b\u0003\u0003'\u00032aRAK\u0013\r\t9\n\u0013\u0002\n%\u0016\fG\rT5nSR\fqcY;se\u0016tG\u000fU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:\u0016\u0005\u0005u\u0005CBA\f\u0003#\nY(A\u000edkJ\u0014XM\u001c;QCJ$\u0018\u000e^5p]>3gm]3ug~#S-\u001d\u000b\u0005\u0003W\n\u0019\u000bC\u0005\u0002tm\t\t\u00111\u0001\u0002\u001e\u0006A2-\u001e:sK:$\b+\u0019:uSRLwN\\(gMN,Go\u001d\u0011\u0002-1\fG/Z:u!\u0006\u0014H/\u001b;j_:|eMZ:fiN\f!\u0004\\1uKN$\b+\u0019:uSRLwN\\(gMN,Go]0%KF$B!a\u001b\u0002.\"I\u00111\u000f\u0010\u0002\u0002\u0003\u0007\u0011QT\u0001\u0018Y\u0006$Xm\u001d;QCJ$\u0018\u000e^5p]>3gm]3ug\u0002\n\u0011bY8om\u0016\u0014H/\u001a:\u0016\u0005\u0005U\u0006cA3\u00028&\u0019\u0011\u0011X\u001a\u00033-\u000bgm[1SK\u000e|'\u000f\u001a+p%><8i\u001c8wKJ$XM]\u0001\u000bG>tg/\u001a:uKJ\u0004\u0013AB:dQ\u0016l\u0017-\u0006\u0002\u0002BB!\u00111YAe\u001b\t\t)MC\u0002\u0002HV\nQ\u0001^=qKNLA!a3\u0002F\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0013\u001d,Go\u00144gg\u0016$XCAAi!\u0019\t9\"!\u0015\u0002TB\u0019\u0011+!6\n\u0007\u0005]'K\u0001\u0004PM\u001a\u001cX\r^\u0001\u0013e\u0016\u0004xN\u001d;MCR,7\u000f^(gMN,G\u000f\u0006\u0002\u0002^B\u0019q)a8\n\u0007\u0005]\u0007*\u0001\u0007mCR,7\u000f^(gMN,G\u000f\u0006\u0004\u0002^\u0006\u0015\u0018\u0011\u001e\u0005\b\u0003O,\u0003\u0019AAo\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000f\u0005-X\u00051\u0001\u0002\u0014\u0006)A.[7ji\u0006QA-\u001a7bs\n\u000bGo\u00195\u0015\u0015\u0005U\u0011\u0011_A{\u0003s\fi\u0010C\u0004\u0002t\u001a\u0002\r!a\u0011\u0002\u00115Lg\u000eT5nSRDq!a>'\u0001\u0004\tY(A\u0007mCR,7\u000f^(gMN,Go\u001d\u0005\b\u0003w4\u0003\u0019AA>\u00039\u0019WO\u001d:f]R|eMZ:fiNDq!a\u0017'\u0001\u0004\t\u0019%A\u0005sCR,G*[7jiRA\u00111\u0010B\u0002\u0005\u000b\u0011I\u0001C\u0004\u0002l\u001e\u0002\r!a\u0011\t\u000f\t\u001dq\u00051\u0001\u0002|\u0005!aM]8n\u0011\u001d\u0011Ya\na\u0001\u0003w\nQ!\u001e8uS2\f\u0001bZ3u\u0005\u0006$8\r\u001b\u000b\u0007\u0005#\u0011yCa\r\u0011\t\tM!\u0011\u0006\b\u0005\u0005+\u0011)C\u0004\u0003\u0003\u0018\t\rb\u0002\u0002B\r\u0005CqAAa\u0007\u0003 9\u0019!O!\b\n\u0003qJ!AO\u001e\n\u0005aJ\u0014B\u0001\u001c8\u0013\r\u00119#N\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YC!\f\u0003\u0013\u0011\u000bG/\u0019$sC6,'b\u0001B\u0014k!9!\u0011\u0007\u0015A\u0002\u0005E\u0017!B:uCJ$\bb\u0002B\u001bQ\u0001\u0007\u00111[\u0001\u0004K:$\u0017\u0001B:u_B$\"!a\u001b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\\\u0001\u000fe\u0016\u0004xN\u001d;ECR\fGj\\:t)\u0011\tYGa\u0011\t\r\t\u00153\u00061\u0001p\u0003\u001diWm]:bO\u0016\f\u0011d];qKJ$s-\u001a;EK\u001a\fW\u000f\u001c;SK\u0006$G*[7ji&\u0019\u0011q\u0012(\u0002\u0017-\u000bgm[1T_V\u00148-\u001a\t\u0003K:\u001a2A\fB)!\u0011\t9Ba\u0015\n\u0007\tUSO\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005\u001b\nQcZ3u'>\u0014H/\u001a3Fq\u0016\u001cW\u000f^8s\u0019&\u001cH\u000f\u0006\u0003\u0003^\t\r\u0004#BA\f\u0005?z\u0017b\u0001B1k\n)\u0011I\u001d:bs\"9\u0011\u0011\u0007\u0019A\u0002\u0005U\u0012aB2p[B\f'/\u001a\u000b\u0007\u0003+\u0011IG!\u001f\t\u000f\t-\u0014\u00071\u0001\u0003n\u0005\t\u0011\r\u0005\u0003\u0003p\tUTB\u0001B9\u0015\r\u0011\u0019hN\u0001\ng\u000eDW\rZ;mKJLAAa\u001e\u0003r\tIR\t_3dkR|'oQ1dQ\u0016$\u0016m]6M_\u000e\fG/[8o\u0011\u001d\u0011Y(\ra\u0001\u0005[\n\u0011A\u0019")
public class KafkaSource
implements SupportsAdmissionControl,
Source,
Logging {
    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets;
    private final SQLContext sqlContext;
    private final KafkaOffsetReader kafkaReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final SparkContext sc;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final Option<Object> minOffsetPerTrigger;
    private final long maxTriggerDelayMs;
    private final boolean includeHeaders;
    private long lastTriggerMillis;
    private Option<scala.collection.immutable.Map<TopicPartition, Object>> currentPartitionOffsets;
    private Option<scala.collection.immutable.Map<TopicPartition, Object>> latestPartitionOffsets;
    private final KafkaRecordToRowConverter converter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static String[] getSortedExecutorList(SparkContext sparkContext) {
        return KafkaSource$.MODULE$.getSortedExecutorList(sparkContext);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void commit(org.apache.spark.sql.execution.streaming.Offset end) {
        Source.commit$((Source)this, (org.apache.spark.sql.execution.streaming.Offset)end);
    }

    public Offset initialOffset() {
        return Source.initialOffset$((Source)this);
    }

    public Offset deserializeOffset(String json) {
        return Source.deserializeOffset$((Source)this, (String)json);
    }

    public void commit(Offset end) {
        Source.commit$((Source)this, (Offset)end);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private /* synthetic */ ReadLimit super$getDefaultReadLimit() {
        return super.getDefaultReadLimit();
    }

    private SparkContext sc() {
        return this.sc;
    }

    private long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    private Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    public Option<Object> minOffsetPerTrigger() {
        return this.minOffsetPerTrigger;
    }

    public long maxTriggerDelayMs() {
        return this.maxTriggerDelayMs;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private long lastTriggerMillis() {
        return this.lastTriggerMillis;
    }

    private void lastTriggerMillis_$eq(long x$1) {
        this.lastTriggerMillis = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets$lzycompute() {
        KafkaSource kafkaSource = this;
        synchronized (kafkaSource) {
            if (!this.bitmap$0) {
                KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter(this.sqlContext.sparkSession(), this.metadataPath);
                this.initialPartitionOffsets = ((KafkaSourceOffset)metadataLog.get(0L).getOrElse((Function0 & Serializable)() -> {
                    void var3_12;
                    KafkaSourceOffset kafkaSourceOffset;
                    KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
                    if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                        kafkaSourceOffset = new KafkaSourceOffset($this.kafkaReader.fetchEarliestOffsets());
                    } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                        kafkaSourceOffset = new KafkaSourceOffset($this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
                    } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                        SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                        scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                        kafkaSourceOffset = $this.kafkaReader.fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable)message -> {
                            this.reportDataLoss(message);
                            return BoxedUnit.UNIT;
                        });
                    } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                        SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                        scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                        Enumeration.Value strategy = specificTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                        kafkaSourceOffset = $this.kafkaReader.fetchSpecificTimestampBasedOffsets(p, true, strategy);
                    } else if (kafkaOffsetRangeLimit instanceof GlobalTimestampRangeLimit) {
                        GlobalTimestampRangeLimit globalTimestampRangeLimit = (GlobalTimestampRangeLimit)kafkaOffsetRangeLimit;
                        long ts = globalTimestampRangeLimit.timestamp();
                        Enumeration.Value strategy = globalTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                        kafkaSourceOffset = $this.kafkaReader.fetchGlobalTimestampBasedOffsets(ts, true, strategy);
                    } else {
                        throw new MatchError((Object)kafkaOffsetRangeLimit);
                    }
                    KafkaSourceOffset offsets = kafkaSourceOffset;
                    metadataLog.add(0L, offsets);
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append(offsets).toString());
                    return var3_12;
                })).partitionToOffsets();
                this.bitmap$0 = true;
            }
        }
        return this.initialPartitionOffsets;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets() {
        return !this.bitmap$0 ? this.initialPartitionOffsets$lzycompute() : this.initialPartitionOffsets;
    }

    public ReadLimit getDefaultReadLimit() {
        return this.minOffsetPerTrigger().isDefined() && this.maxOffsetsPerTrigger().isDefined() ? ReadLimit.compositeLimit((ReadLimit[])((ReadLimit[])((Object[])new ReadLimit[]{ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()), ReadLimit.maxRows((long)BoxesRunTime.unboxToLong((Object)this.maxOffsetsPerTrigger().get()))}))) : (this.minOffsetPerTrigger().isDefined() ? ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()) : (ReadLimit)this.maxOffsetsPerTrigger().map((Function1 & Serializable)x$1 -> KafkaSource.$anonfun$getDefaultReadLimit$1(BoxesRunTime.unboxToLong((Object)x$1))).getOrElse((Function0 & Serializable)() -> this.super$getDefaultReadLimit()));
    }

    private Option<scala.collection.immutable.Map<TopicPartition, Object>> currentPartitionOffsets() {
        return this.currentPartitionOffsets;
    }

    private void currentPartitionOffsets_$eq(Option<scala.collection.immutable.Map<TopicPartition, Object>> x$1) {
        this.currentPartitionOffsets = x$1;
    }

    private Option<scala.collection.immutable.Map<TopicPartition, Object>> latestPartitionOffsets() {
        return this.latestPartitionOffsets;
    }

    private void latestPartitionOffsets_$eq(Option<scala.collection.immutable.Map<TopicPartition, Object>> x$1) {
        this.latestPartitionOffsets = x$1;
    }

    private KafkaRecordToRowConverter converter() {
        return this.converter;
    }

    public StructType schema() {
        return KafkaRecordToRowConverter$.MODULE$.kafkaSchema(this.includeHeaders());
    }

    public Option<org.apache.spark.sql.execution.streaming.Offset> getOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset reportLatestOffset() {
        return (Offset)this.latestPartitionOffsets().map((Function1 & Serializable)x$3 -> new KafkaSourceOffset((scala.collection.immutable.Map<TopicPartition, Object>)x$3)).getOrElse((Function0 & Serializable)() -> null);
    }

    public Offset latestOffset(Offset startOffset, ReadLimit limit2) {
        scala.collection.immutable.Map map;
        IndexedSeq indexedSeq;
        this.initialPartitionOffsets();
        Option currentOffsets = this.currentPartitionOffsets().orElse((Function0 & Serializable)() -> new Some(this.initialPartitionOffsets()));
        scala.collection.immutable.Map latest = this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)currentOffsets);
        this.latestPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(latest));
        ReadLimit readLimit = limit2;
        if (readLimit instanceof CompositeReadLimit) {
            CompositeReadLimit compositeReadLimit = (CompositeReadLimit)readLimit;
            indexedSeq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)compositeReadLimit.getReadLimits());
        } else {
            indexedSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReadLimit[]{readLimit}));
        }
        IndexedSeq limits = indexedSeq;
        if (limits.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$2(x$4)))) {
            map = latest;
        } else {
            Option lowerLimit = limits.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$3(x$5))).map((Function1 & Serializable)x$6 -> (ReadMinRows)x$6);
            Option upperLimit = limits.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$5(x$7))).map((Function1 & Serializable)x$8 -> (ReadMaxRows)x$8);
            map = (scala.collection.immutable.Map)lowerLimit.flatMap((Function1 & Serializable)limit -> {
                None$ none$;
                boolean skipBatch = this.delayBatch(limit.minRows(), (scala.collection.immutable.Map<TopicPartition, Object>)latest, (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)currentOffsets.get()), limit.maxTriggerDelayMs());
                if (skipBatch) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Delaying batch as number of records available is less than minOffsetsPerTrigger");
                    none$ = new Some(currentOffsets.get());
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }).orElse((Function0 & Serializable)() -> upperLimit.map((Function1 & Serializable)limit -> this.rateLimit(limit.maxRows(), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)this.currentPartitionOffsets().getOrElse((Function0 & Serializable)() -> this.initialPartitionOffsets())), (scala.collection.immutable.Map<TopicPartition, Object>)latest))).getOrElse((Function0 & Serializable)() -> latest);
        }
        scala.collection.immutable.Map offsets = map;
        this.currentPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(offsets));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("GetOffset: ").append(((SeqOps)offsets.toSeq().map((Function1 & Serializable)x$9 -> x$9.toString())).sorted((Ordering)Ordering.String$.MODULE$)).toString());
        return new KafkaSourceOffset(offsets);
    }

    private boolean delayBatch(long minLimit, scala.collection.immutable.Map<TopicPartition, Object> latestOffsets, scala.collection.immutable.Map<TopicPartition, Object> currentOffsets, long maxTriggerDelayMs) {
        boolean bl;
        if (System.currentTimeMillis() - this.lastTriggerMillis() >= maxTriggerDelayMs) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Maximum wait time is passed, triggering batch");
            this.lastTriggerMillis_$eq(System.currentTimeMillis());
            bl = false;
        } else {
            double newRecords = BoxesRunTime.unboxToLong((Object)((MapOps)latestOffsets.flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topic = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Some some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToLong((long)(offset - BoxesRunTime.unboxToLong((Object)currentOffsets.getOrElse((Object)topic, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))))));
                return some;
            })).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            if (newRecords < (double)minLimit) {
                bl = true;
            } else {
                this.lastTriggerMillis_$eq(System.currentTimeMillis());
                bl = false;
            }
        }
        return bl;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        LazyRef fromNew$lzy = new LazyRef();
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Option option = from.get((Object)tp).orElse((Function0 & Serializable)() -> this.fromNew$1(fromNew$lzy, until, from).get((Object)tp)).flatMap((Function1 & Serializable)begin -> KafkaSource.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin)));
            return option;
        });
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return total < 1.0 ? until : (scala.collection.immutable.Map)until.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable)size -> {
                long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)this.fromNew$1(fromNew$lzy, until, from).apply((Object)tp))));
                double prorate = (double)limit * ((double)size / total);
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("rateLimit ").append(tp).append(" prorated amount is ").append(prorate).toString());
                long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("rateLimit ").append(tp).append(" new offset is ").append(off).toString());
                return Math.min(end, off);
            }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> end));
            return tuple22;
        });
    }

    public Dataset<Row> getBatch(Option<org.apache.spark.sql.execution.streaming.Offset> start, org.apache.spark.sql.execution.streaming.Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> map;
        Option<org.apache.spark.sql.execution.streaming.Offset> option;
        this.initialPartitionOffsets();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("GetBatch called with start = ").append(start).append(", end = ").append(end).toString());
        scala.collection.immutable.Map<TopicPartition, Object> untilPartitionOffsets = KafkaSourceOffset$.MODULE$.getPartitionOffsets(end);
        if (this.currentPartitionOffsets().isEmpty()) {
            this.currentPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(untilPartitionOffsets));
        }
        if (start.isDefined()) {
            Object object = start.get();
            org.apache.spark.sql.execution.streaming.Offset offset = end;
            if (!(object != null ? !object.equals(offset) : offset != null)) {
                return this.sqlContext.internalCreateDataFrame(this.sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)).setName("empty"), this.schema(), true);
            }
        }
        if ((option = start) instanceof Some) {
            Some some = (Some)option;
            org.apache.spark.sql.execution.streaming.Offset prevBatchEndOffset = (org.apache.spark.sql.execution.streaming.Offset)some.value();
            map = KafkaSourceOffset$.MODULE$.getPartitionOffsets(prevBatchEndOffset);
        } else if (None$.MODULE$.equals(option)) {
            map = this.initialPartitionOffsets();
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Map<TopicPartition, Object> fromPartitionOffsets = map;
        Seq<KafkaOffsetRange> offsetRanges = this.kafkaReader.getOffsetRangesFromResolvedOffsets(fromPartitionOffsets, untilPartitionOffsets, (Function1<String, BoxedUnit>)(Function1 & Serializable)message -> {
            this.reportDataLoss(message);
            return BoxedUnit.UNIT;
        });
        RDD rdd = this.includeHeaders() ? new KafkaSourceRDD(this.sc(), this.executorKafkaParams, offsetRanges, this.pollTimeoutMs(), this.failOnDataLoss).map(this.converter().toInternalRowWithHeaders(), ClassTag$.MODULE$.apply(InternalRow.class)) : new KafkaSourceRDD(this.sc(), this.executorKafkaParams, offsetRanges, this.pollTimeoutMs(), this.failOnDataLoss).map(this.converter().toInternalRowWithoutHeaders(), ClassTag$.MODULE$.apply(InternalRow.class));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("GetBatch generating RDD of offset range: ").append(((IterableOnceOps)offsetRanges.sortBy((Function1 & Serializable)x$10 -> x$10.topicPartition().toString(), (Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString());
        return this.sqlContext.internalCreateDataFrame(rdd.setName("kafka"), this.schema(), true);
    }

    public synchronized void stop() {
        this.kafkaReader.close();
    }

    public String toString() {
        return new StringBuilder(15).append("KafkaSourceV1[").append(this.kafkaReader).append("]").toString();
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(0).append(message).append(new StringBuilder(2).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(message).append(new StringBuilder(2).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString()).toString());
    }

    public static final /* synthetic */ ReadLimit $anonfun$getDefaultReadLimit$1(long x$1) {
        return ReadLimit.maxRows((long)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$2(ReadLimit x$4) {
        return x$4 instanceof ReadAllAvailable;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$3(ReadLimit x$5) {
        return x$5 instanceof ReadMinRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$5(ReadLimit x$7) {
        return x$7 instanceof ReadMaxRows;
    }

    private final /* synthetic */ scala.collection.immutable.Map fromNew$lzycompute$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = fromNew$lzy$1;
        synchronized (lazyRef) {
            map = fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : (scala.collection.immutable.Map)fromNew$lzy$1.initialize(this.kafkaReader.fetchEarliestOffsets((Seq<TopicPartition>)until$1.keySet().diff((Set)from$1.keySet()).toSeq()));
        }
        return map;
    }

    private final scala.collection.immutable.Map fromNew$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        return fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : this.fromNew$lzycompute$1(fromNew$lzy$1, until$1, from$1);
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaSource $this, long end$1, TopicPartition tp$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("rateLimit ").append(tp$1).append(" size is ").append(size).toString());
        return size > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)BoxesRunTime.boxToLong((long)size))) : None$.MODULE$;
    }

    public KafkaSource(SQLContext sqlContext, KafkaOffsetReader kafkaReader, Map<String, Object> executorKafkaParams, CaseInsensitiveMap<String> sourceOptions, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.sqlContext = sqlContext;
        this.kafkaReader = kafkaReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Source.$init$((Source)this);
        Logging.$init$((Logging)this);
        this.sc = sqlContext.sparkContext();
        this.pollTimeoutMs = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), (Function0 & Serializable)() -> Long.toString(BoxesRunTime.unboxToLong((Object)this.sc().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L))));
        this.maxOffsetsPerTrigger = sourceOptions.get(KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$1))));
        this.minOffsetPerTrigger = sourceOptions.get(KafkaSourceProvider$.MODULE$.MIN_OFFSET_PER_TRIGGER()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$2))));
        this.maxTriggerDelayMs = Utils$.MODULE$.timeStringAsMs((String)sourceOptions.get(KafkaSourceProvider$.MODULE$.MAX_TRIGGER_DELAY()).getOrElse((Function0 & Serializable)() -> KafkaSourceProvider$.MODULE$.DEFAULT_MAX_TRIGGER_DELAY()));
        this.includeHeaders = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), (Function0 & Serializable)() -> "false")));
        this.lastTriggerMillis = 0L;
        this.currentPartitionOffsets = None$.MODULE$;
        this.latestPartitionOffsets = None$.MODULE$;
        this.converter = new KafkaRecordToRowConverter();
    }
}

