/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.CompositeReadLimit;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.ReadMinRows;
import org.apache.spark.sql.connector.read.streaming.ReportsSourceMetrics;
import org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.JsonUtils$;
import org.apache.spark.sql.kafka010.KafkaBatchInputPartition;
import org.apache.spark.sql.kafka010.KafkaBatchReaderFactory$;
import org.apache.spark.sql.kafka010.KafkaMicroBatchStream$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.UninterruptibleThread;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t-c!B\u00193\u0001Ib\u0004\"C.\u0001\u0005\u000b\u0007I\u0011\u0001\u001a]\u0011!\u0011\u0007A!A!\u0002\u0013i\u0006\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011]\u0004!\u0011!Q\u0001\naD\u0001\" \u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\t}\u0002\u0011\t\u0011)A\u0005\u007f\"Q\u0011Q\u0001\u0001\u0003\u0002\u0003\u0006I!a\u0002\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!Q\u0011\u0011\u0005\u0001C\u0002\u0013\u0005!'a\t\t\u0011\u0005-\u0002\u0001)A\u0005\u0003KA!\"!\f\u0001\u0005\u0004%\tAMA\u0018\u0011!\t9\u0004\u0001Q\u0001\n\u0005E\u0002BCA\u001d\u0001\t\u0007I\u0011\u0001\u001a\u00020!A\u00111\b\u0001!\u0002\u0013\t\t\u0004\u0003\u0006\u0002>\u0001\u0011\r\u0011\"\u00013\u0003GA\u0001\"a\u0010\u0001A\u0003%\u0011Q\u0005\u0005\n\u0003\u0003\u0002\u0001\u0019!C\u0005\u0003GA\u0011\"a\u0011\u0001\u0001\u0004%I!!\u0012\t\u0011\u0005E\u0003\u0001)Q\u0005\u0003KA\u0011\"a\u0015\u0001\u0005\u0004%I!!\u0016\t\u0011\u0005]\u0003\u0001)A\u0005\u0003\u000fA1\"!\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\\!Y\u00111\r\u0001A\u0002\u0003\u0007I\u0011BA3\u0011-\tI\u0007\u0001a\u0001\u0002\u0003\u0006K!!\u0018\t\u0017\u0005-\u0004\u00011AA\u0002\u0013%\u0011Q\u000e\u0005\f\u0003{\u0002\u0001\u0019!a\u0001\n\u0013\ty\bC\u0006\u0002\u0004\u0002\u0001\r\u0011!Q!\n\u0005=\u0004bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u0003\u001f\u0003A\u0011IAI\u0011\u001d\tI\n\u0001C!\u0003\u000fCq!a'\u0001\t\u0003\n9\tC\u0004\u0002\u001c\u0002!\t%!(\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u0011Q\u001a\u0001\u0005B\u0005=\u0007bBAs\u0001\u0011\u0005\u0013q\u001d\u0005\b\u0003_\u0004A\u0011IAy\u0011\u001d\t9\u0010\u0001C!\u0003sDq!!@\u0001\t\u0003\ny\u0010C\u0004\u0003\u0002\u0001!\tEa\u0001\t\u000f\t\u0015\u0001\u0001\"\u0011\u0003\b!9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\r\u0001\u0011%!1\u0004\u0005\b\u0005S\u0001A\u0011\u0002B\u0016\u00119\u0011\t\u0004\u0001I\u0001\u0004\u0003\u0005I\u0011BAI\u0005g9qA!\u000e3\u0011\u0003\u00119D\u0002\u00042e!\u0005!\u0011\b\u0005\b\u0003\u001fqC\u0011\u0001B!\u0011\u001d\u0011)A\fC\u0001\u0005\u0007\u0012QcS1gW\u0006l\u0015n\u0019:p\u0005\u0006$8\r[*ue\u0016\fWN\u0003\u00024i\u0005A1.\u00194lCB\n\u0004G\u0003\u00026m\u0005\u00191/\u001d7\u000b\u0005]B\u0014!B:qCJ\\'BA\u001d;\u0003\u0019\t\u0007/Y2iK*\t1(A\u0002pe\u001e\u001cb\u0001A\u001fF\u001fJ+\u0006C\u0001 D\u001b\u0005y$B\u0001!B\u0003\u0011a\u0017M\\4\u000b\u0003\t\u000bAA[1wC&\u0011Ai\u0010\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0019kU\"A$\u000b\u0005!K\u0015!C:ue\u0016\fW.\u001b8h\u0015\tQ5*\u0001\u0003sK\u0006$'B\u0001'5\u0003%\u0019wN\u001c8fGR|'/\u0003\u0002O\u000f\nA2+\u001e9q_J$8/\u00113nSN\u001c\u0018n\u001c8D_:$(o\u001c7\u0011\u0005\u0019\u0003\u0016BA)H\u0005Q\u0011V\r]8siN\u001cv.\u001e:dK6+GO]5dgB\u0011aiU\u0005\u0003)\u001e\u0013\u0001#T5de>\u0014\u0015\r^2i'R\u0014X-Y7\u0011\u0005YKV\"A,\u000b\u0005a3\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005i;&a\u0002'pO\u001eLgnZ\u0001\u0012W\u000647.Y(gMN,GOU3bI\u0016\u0014X#A/\u0011\u0005y{V\"\u0001\u001a\n\u0005\u0001\u0014$!E&bM.\fwJ\u001a4tKR\u0014V-\u00193fe\u000e\u0001\u0011AE6bM.\fwJ\u001a4tKR\u0014V-\u00193fe\u0002\n1#\u001a=fGV$xN]&bM.\f\u0007+\u0019:b[N\u0004B!\u001a5k{5\taM\u0003\u0002h\u0003\u0006!Q\u000f^5m\u0013\tIgMA\u0002NCB\u0004\"a\u001b;\u000f\u00051\u0014\bCA7q\u001b\u0005q'BA8b\u0003\u0019a$o\\8u})\t\u0011/A\u0003tG\u0006d\u0017-\u0003\u0002ta\u00061\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u0019\b/A\u0004paRLwN\\:\u0011\u0005e\\X\"\u0001>\u000b\u0005\u001d$\u0014B\u0001?{\u0005a\u0019\u0015m]3J]N,gn]5uSZ,7\u000b\u001e:j]\u001el\u0015\r]\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f[\u0001\u0010gR\f'\u000f^5oO>3gm]3ugB\u0019a,!\u0001\n\u0007\u0005\r!GA\u000bLC\u001a\\\u0017m\u00144gg\u0016$(+\u00198hK2KW.\u001b;\u0002\u001d\u0019\f\u0017\u000e\\(o\t\u0006$\u0018\rT8tgB!\u0011\u0011BA\u0006\u001b\u0005\u0001\u0018bAA\u0007a\n9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\b\u0002\u0014\u0005U\u0011qCA\r\u00037\ti\"a\b\u0011\u0005y\u0003\u0001\"B.\t\u0001\u0004i\u0006\"B2\t\u0001\u0004!\u0007\"B<\t\u0001\u0004A\b\"B?\t\u0001\u0004Q\u0007\"\u0002@\t\u0001\u0004y\bbBA\u0003\u0011\u0001\u0007\u0011qA\u0001\u000ea>dG\u000eV5nK>,H/T:\u0016\u0005\u0005\u0015\u0002\u0003BA\u0005\u0003OI1!!\u000bq\u0005\u0011auN\\4\u0002\u001dA|G\u000e\u001c+j[\u0016|W\u000f^'tA\u0005!R.\u0019=PM\u001a\u001cX\r^:QKJ$&/[4hKJ,\"!!\r\u0011\r\u0005%\u00111GA\u0013\u0013\r\t)\u0004\u001d\u0002\u0007\u001fB$\u0018n\u001c8\u0002+5\f\u0007p\u00144gg\u0016$8\u000fU3s)JLwmZ3sA\u0005\u0019R.\u001b8PM\u001a\u001cX\r\u001e)feR\u0013\u0018nZ4fe\u0006!R.\u001b8PM\u001a\u001cX\r\u001e)feR\u0013\u0018nZ4fe\u0002\n\u0011#\\1y)JLwmZ3s\t\u0016d\u0017-_'t\u0003Ii\u0017\r\u001f+sS\u001e<WM\u001d#fY\u0006LXj\u001d\u0011\u0002#1\f7\u000f\u001e+sS\u001e<WM]'jY2L7/A\u000bmCN$HK]5hO\u0016\u0014X*\u001b7mSN|F%Z9\u0015\t\u0005\u001d\u0013Q\n\t\u0005\u0003\u0013\tI%C\u0002\u0002LA\u0014A!\u00168ji\"I\u0011q\n\n\u0002\u0002\u0003\u0007\u0011QE\u0001\u0004q\u0012\n\u0014A\u00057bgR$&/[4hKJl\u0015\u000e\u001c7jg\u0002\na\"\u001b8dYV$W\rS3bI\u0016\u00148/\u0006\u0002\u0002\b\u0005y\u0011N\\2mk\u0012,\u0007*Z1eKJ\u001c\b%A\nf]\u0012\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$8/\u0006\u0002\u0002^A\u0019a,a\u0018\n\u0007\u0005\u0005$GA\tLC\u001a\\\u0017mU8ve\u000e,wJ\u001a4tKR\fq#\u001a8e!\u0006\u0014H/\u001b;j_:|eMZ:fiN|F%Z9\u0015\t\u0005\u001d\u0013q\r\u0005\n\u0003\u001f:\u0012\u0011!a\u0001\u0003;\nA#\u001a8e!\u0006\u0014H/\u001b;j_:|eMZ:fiN\u0004\u0013A\u00067bi\u0016\u001cH\u000fU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:\u0016\u0005\u0005=\u0004\u0003BA9\u0003or1AXA:\u0013\r\t)HM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI(a\u001f\u0003%A\u000b'\u000f^5uS>twJ\u001a4tKRl\u0015\r\u001d\u0006\u0004\u0003k\u0012\u0014A\u00077bi\u0016\u001cH\u000fU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:`I\u0015\fH\u0003BA$\u0003\u0003C\u0011\"a\u0014\u001b\u0003\u0003\u0005\r!a\u001c\u0002/1\fG/Z:u!\u0006\u0014H/\u001b;j_:|eMZ:fiN\u0004\u0013!D5oSRL\u0017\r\\(gMN,G\u000f\u0006\u0002\u0002\nB\u0019a)a#\n\u0007\u00055uI\u0001\u0004PM\u001a\u001cX\r^\u0001\u0014O\u0016$H)\u001a4bk2$(+Z1e\u0019&l\u0017\u000e\u001e\u000b\u0003\u0003'\u00032ARAK\u0013\r\t9j\u0012\u0002\n%\u0016\fG\rT5nSR\f!C]3q_J$H*\u0019;fgR|eMZ:fi\u0006aA.\u0019;fgR|eMZ:fiR1\u0011\u0011RAP\u0003GCq!!)!\u0001\u0004\tI)A\u0003ti\u0006\u0014H\u000fC\u0004\u0002&\u0002\u0002\r!a%\u0002\u0013I,\u0017\r\u001a'j[&$\u0018A\u00033fY\u0006L()\u0019;dQRQ\u0011qAAV\u0003_\u000b9-a3\t\u000f\u00055\u0016\u00051\u0001\u0002&\u0005AQ.\u001b8MS6LG\u000fC\u0004\u00022\u0006\u0002\r!a-\u0002\u001b1\fG/Z:u\u001f\u001a47/\u001a;t!\u001dY\u0017QWA\\\u0003KI!!\u001b<\u0011\t\u0005e\u00161Y\u0007\u0003\u0003wSA!!0\u0002@\u000611m\\7n_:T1!!19\u0003\u0015Y\u0017MZ6b\u0013\u0011\t)-a/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011\u0011Z\u0011A\u0002\u0005M\u0016AD2veJ,g\u000e^(gMN,Go\u001d\u0005\b\u0003{\t\u0003\u0019AA\u0013\u0003M\u0001H.\u00198J]B,H\u000fU1si&$\u0018n\u001c8t)\u0019\t\t.a8\u0002bB1\u0011\u0011BAj\u0003/L1!!6q\u0005\u0015\t%O]1z!\u0011\tI.a7\u000e\u0003%K1!!8J\u00059Ie\u000e];u!\u0006\u0014H/\u001b;j_:Dq!!)#\u0001\u0004\tI\tC\u0004\u0002d\n\u0002\r!!#\u0002\u0007\u0015tG-A\nde\u0016\fG/\u001a*fC\u0012,'OR1di>\u0014\u0018\u0010\u0006\u0002\u0002jB!\u0011\u0011\\Av\u0013\r\ti/\u0013\u0002\u0017!\u0006\u0014H/\u001b;j_:\u0014V-\u00193fe\u001a\u000b7\r^8ss\u0006\tB-Z:fe&\fG.\u001b>f\u001f\u001a47/\u001a;\u0015\t\u0005%\u00151\u001f\u0005\u0007\u0003k$\u0003\u0019\u00016\u0002\t)\u001cxN\\\u0001\u0007G>lW.\u001b;\u0015\t\u0005\u001d\u00131 \u0005\b\u0003G,\u0003\u0019AAE\u0003\u0011\u0019Ho\u001c9\u0015\u0005\u0005\u001d\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003)\fq!\\3ue&\u001c7\u000f\u0006\u0003\u0003\n\t-\u0001\u0003B3iU*DqA!\u0004)\u0001\u0004\u0011y!\u0001\u000bmCR,7\u000f^\"p]N,X.\u001a3PM\u001a\u001cX\r\u001e\t\u0006K\nE\u0011\u0011R\u0005\u0004\u0005'1'\u0001C(qi&|g.\u00197\u0002E\u001d,Go\u0014:De\u0016\fG/Z%oSRL\u0017\r\u001c)beRLG/[8o\u001f\u001a47/\u001a;t)\t\ty'A\u0005sCR,G*[7jiRA\u0011q\u000eB\u000f\u0005C\u0011)\u0003C\u0004\u0003 )\u0002\r!!\n\u0002\u000b1LW.\u001b;\t\u000f\t\r\"\u00061\u0001\u0002p\u0005!aM]8n\u0011\u001d\u00119C\u000ba\u0001\u0003_\nQ!\u001e8uS2\faB]3q_J$H)\u0019;b\u0019>\u001c8\u000f\u0006\u0003\u0002H\t5\u0002B\u0002B\u0018W\u0001\u0007!.A\u0004nKN\u001c\u0018mZ3\u00023M,\b/\u001a:%O\u0016$H)\u001a4bk2$(+Z1e\u0019&l\u0017\u000e^\u0005\u0004\u0003\u001fk\u0015!F&bM.\fW*[2s_\n\u000bGo\u00195TiJ,\u0017-\u001c\t\u0003=:\u001aBA\fB\u001e+B!\u0011\u0011\u0002B\u001f\u0013\r\u0011y\u0004\u001d\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t]BC\u0002B\u0005\u0005\u000b\u00129\u0005C\u0004\u0003\u000eA\u0002\rAa\u0004\t\u000f\t%\u0003\u00071\u0001\u0002p\u0005yB.\u0019;fgR\fe/Y5mC\ndW\rU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:")
public class KafkaMicroBatchStream
implements SupportsAdmissionControl,
ReportsSourceMetrics,
MicroBatchStream,
Logging {
    private final KafkaOffsetReader kafkaOffsetReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final Option<Object> minOffsetPerTrigger;
    private final long maxTriggerDelayMs;
    private long lastTriggerMillis;
    private final boolean includeHeaders;
    private KafkaSourceOffset endPartitionOffsets;
    private scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private /* synthetic */ ReadLimit super$getDefaultReadLimit() {
        return super.getDefaultReadLimit();
    }

    public KafkaOffsetReader kafkaOffsetReader() {
        return this.kafkaOffsetReader;
    }

    public long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    public Option<Object> minOffsetPerTrigger() {
        return this.minOffsetPerTrigger;
    }

    public long maxTriggerDelayMs() {
        return this.maxTriggerDelayMs;
    }

    private long lastTriggerMillis() {
        return this.lastTriggerMillis;
    }

    private void lastTriggerMillis_$eq(long x$1) {
        this.lastTriggerMillis = x$1;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private KafkaSourceOffset endPartitionOffsets() {
        return this.endPartitionOffsets;
    }

    private void endPartitionOffsets_$eq(KafkaSourceOffset x$1) {
        this.endPartitionOffsets = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets() {
        return this.latestPartitionOffsets;
    }

    private void latestPartitionOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.latestPartitionOffsets = x$1;
    }

    public Offset initialOffset() {
        return new KafkaSourceOffset(this.getOrCreateInitialPartitionOffsets());
    }

    public ReadLimit getDefaultReadLimit() {
        return this.minOffsetPerTrigger().isDefined() && this.maxOffsetsPerTrigger().isDefined() ? ReadLimit.compositeLimit((ReadLimit[])((ReadLimit[])((Object[])new ReadLimit[]{ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()), ReadLimit.maxRows((long)BoxesRunTime.unboxToLong((Object)this.maxOffsetsPerTrigger().get()))}))) : (this.minOffsetPerTrigger().isDefined() ? ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()) : (ReadLimit)this.maxOffsetsPerTrigger().map((Function1 & Serializable)x$1 -> KafkaMicroBatchStream.$anonfun$getDefaultReadLimit$1(BoxesRunTime.unboxToLong((Object)x$1))).getOrElse((Function0 & Serializable)() -> this.super$getDefaultReadLimit()));
    }

    public Offset reportLatestOffset() {
        return new KafkaSourceOffset(this.latestPartitionOffsets());
    }

    public Offset latestOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset latestOffset(Offset start, ReadLimit readLimit) {
        scala.collection.immutable.Map map;
        IndexedSeq indexedSeq;
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        this.latestPartitionOffsets_$eq(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(startPartitionOffsets)));
        ReadLimit readLimit2 = readLimit;
        if (readLimit2 instanceof CompositeReadLimit) {
            CompositeReadLimit compositeReadLimit = (CompositeReadLimit)readLimit2;
            indexedSeq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)compositeReadLimit.getReadLimits());
        } else {
            indexedSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReadLimit[]{readLimit2}));
        }
        IndexedSeq limits = indexedSeq;
        if (limits.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$1(x$5)))) {
            map = this.latestPartitionOffsets();
        } else {
            Option lowerLimit = limits.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$2(x$6))).map((Function1 & Serializable)x$7 -> (ReadMinRows)x$7);
            Option upperLimit = limits.find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$4(x$8))).map((Function1 & Serializable)x$9 -> (ReadMaxRows)x$9);
            map = (scala.collection.immutable.Map)lowerLimit.flatMap((Function1 & Serializable)limit -> {
                None$ none$;
                boolean skipBatch = this.delayBatch(limit.minRows(), this.latestPartitionOffsets(), startPartitionOffsets, limit.maxTriggerDelayMs());
                if (skipBatch) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Delaying batch as number of records available is less than minOffsetsPerTrigger");
                    none$ = new Some((Object)startPartitionOffsets);
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }).orElse((Function0 & Serializable)() -> upperLimit.map((Function1 & Serializable)limit -> this.rateLimit(limit.maxRows(), startPartitionOffsets, this.latestPartitionOffsets()))).getOrElse((Function0 & Serializable)() -> this.latestPartitionOffsets());
        }
        scala.collection.immutable.Map offsets = map;
        this.endPartitionOffsets_$eq(new KafkaSourceOffset(offsets));
        return this.endPartitionOffsets();
    }

    private boolean delayBatch(long minLimit, scala.collection.immutable.Map<TopicPartition, Object> latestOffsets, scala.collection.immutable.Map<TopicPartition, Object> currentOffsets, long maxTriggerDelayMs) {
        boolean bl;
        if (System.currentTimeMillis() - this.lastTriggerMillis() >= maxTriggerDelayMs) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Maximum wait time is passed, triggering batch");
            this.lastTriggerMillis_$eq(System.currentTimeMillis());
            bl = false;
        } else {
            double newRecords = BoxesRunTime.unboxToLong((Object)((MapOps)latestOffsets.flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topic = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Some some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToLong((long)(offset - BoxesRunTime.unboxToLong((Object)currentOffsets.getOrElse((Object)topic, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))))));
                return some;
            })).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            if (newRecords < (double)minLimit) {
                bl = true;
            } else {
                this.lastTriggerMillis_$eq(System.currentTimeMillis());
                bl = false;
            }
        }
        return bl;
    }

    public InputPartition[] planInputPartitions(Offset start, Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        scala.collection.immutable.Map<TopicPartition, Object> endPartitionOffsets = ((KafkaSourceOffset)end).partitionToOffsets();
        Seq<KafkaOffsetRange> offsetRanges = this.kafkaOffsetReader().getOffsetRangesFromResolvedOffsets(startPartitionOffsets, endPartitionOffsets, (Function1<String, BoxedUnit>)(Function1 & Serializable)message -> {
            this.reportDataLoss(message);
            return BoxedUnit.UNIT;
        });
        return (InputPartition[])((IterableOnceOps)offsetRanges.map((Function1 & Serializable)range -> new KafkaBatchInputPartition((KafkaOffsetRange)range, $this.executorKafkaParams, this.pollTimeoutMs(), $this.failOnDataLoss, this.includeHeaders()))).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public PartitionReaderFactory createReaderFactory() {
        return KafkaBatchReaderFactory$.MODULE$;
    }

    public Offset deserializeOffset(String json) {
        return new KafkaSourceOffset(JsonUtils$.MODULE$.partitionOffsets(json));
    }

    public void commit(Offset end) {
    }

    public void stop() {
        this.kafkaOffsetReader().close();
    }

    public String toString() {
        return new StringBuilder(9).append("KafkaV2[").append(this.kafkaOffsetReader()).append("]").toString();
    }

    public Map<String, String> metrics(Optional<Offset> latestConsumedOffset) {
        return KafkaMicroBatchStream$.MODULE$.metrics(latestConsumedOffset, this.latestPartitionOffsets());
    }

    private scala.collection.immutable.Map<TopicPartition, Object> getOrCreateInitialPartitionOffsets() {
        Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
        Predef$.MODULE$.assert(SparkSession$.MODULE$.getActiveSession().nonEmpty());
        KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter((SparkSession)SparkSession$.MODULE$.getActiveSession().get(), this.metadataPath);
        return ((KafkaSourceOffset)metadataLog.get(0L).getOrElse((Function0 & Serializable)() -> {
            void var3_12;
            KafkaSourceOffset kafkaSourceOffset;
            KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
            if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchEarliestOffsets());
            } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
            } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable)message -> {
                    this.reportDataLoss(message);
                    return BoxedUnit.UNIT;
                });
            } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                Enumeration.Value strategy = specificTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificTimestampBasedOffsets(p, true, strategy);
            } else if (kafkaOffsetRangeLimit instanceof GlobalTimestampRangeLimit) {
                GlobalTimestampRangeLimit globalTimestampRangeLimit = (GlobalTimestampRangeLimit)kafkaOffsetRangeLimit;
                long ts = globalTimestampRangeLimit.timestamp();
                Enumeration.Value strategy = globalTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchGlobalTimestampBasedOffsets(ts, true, strategy);
            } else {
                throw new MatchError((Object)kafkaOffsetRangeLimit);
            }
            KafkaSourceOffset offsets = kafkaSourceOffset;
            metadataLog.add(0L, offsets);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append(offsets).toString());
            return var3_12;
        })).partitionToOffsets();
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        LazyRef fromNew$lzy = new LazyRef();
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Option option = from.get((Object)tp).orElse((Function0 & Serializable)() -> this.fromNew$1(fromNew$lzy, until, from).get((Object)tp)).flatMap((Function1 & Serializable)begin -> KafkaMicroBatchStream.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin)));
            return option;
        });
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return total < 1.0 ? until : (scala.collection.immutable.Map)until.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable)size -> {
                long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)this.fromNew$1(fromNew$lzy, until, from).apply((Object)tp))));
                double prorate = (double)limit * ((double)size / total);
                long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                return Math.min(end, off);
            }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> end));
            return tuple22;
        });
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(0).append(message).append(new StringBuilder(2).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(message).append(new StringBuilder(2).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString()).toString());
    }

    public static final /* synthetic */ ReadLimit $anonfun$getDefaultReadLimit$1(long x$1) {
        return ReadLimit.maxRows((long)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$1(ReadLimit x$5) {
        return x$5 instanceof ReadAllAvailable;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$2(ReadLimit x$6) {
        return x$6 instanceof ReadMinRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$4(ReadLimit x$8) {
        return x$8 instanceof ReadMaxRows;
    }

    private final /* synthetic */ scala.collection.immutable.Map fromNew$lzycompute$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = fromNew$lzy$1;
        synchronized (lazyRef) {
            map = fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : (scala.collection.immutable.Map)fromNew$lzy$1.initialize(this.kafkaOffsetReader().fetchEarliestOffsets((Seq<TopicPartition>)until$1.keySet().diff((Set)from$1.keySet()).toSeq()));
        }
        return map;
    }

    private final scala.collection.immutable.Map fromNew$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        return fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : this.fromNew$lzycompute$1(fromNew$lzy$1, until$1, from$1);
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaMicroBatchStream $this, long end$1, TopicPartition tp$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("rateLimit ").append(tp$1).append(" size is ").append(size).toString());
        return size > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)BoxesRunTime.boxToLong((long)size))) : None$.MODULE$;
    }

    public KafkaMicroBatchStream(KafkaOffsetReader kafkaOffsetReader, Map<String, Object> executorKafkaParams, CaseInsensitiveStringMap options, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.kafkaOffsetReader = kafkaOffsetReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Logging.$init$((Logging)this);
        this.pollTimeoutMs = options.getLong(KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L);
        this.maxOffsetsPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER())).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$1))));
        this.minOffsetPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MIN_OFFSET_PER_TRIGGER())).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$2))));
        this.maxTriggerDelayMs = Utils$.MODULE$.timeStringAsMs((String)Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_TRIGGER_DELAY())).getOrElse((Function0 & Serializable)() -> KafkaSourceProvider$.MODULE$.DEFAULT_MAX_TRIGGER_DELAY()));
        this.lastTriggerMillis = 0L;
        this.includeHeaders = options.getBoolean(KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), false);
    }
}

