/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.CompositeReadLimit;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.ReadMinRows;
import org.apache.spark.sql.connector.read.streaming.ReportsSourceMetrics;
import org.apache.spark.sql.connector.read.streaming.SupportsTriggerAvailableNow;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.JsonUtils$;
import org.apache.spark.sql.kafka010.KafkaBatchInputPartition;
import org.apache.spark.sql.kafka010.KafkaBatchReaderFactory$;
import org.apache.spark.sql.kafka010.KafkaMicroBatchStream$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.MockedSystemClock;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.UninterruptibleThread;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tUc!B\u001a5\u0001Qr\u0004\"C/\u0001\u0005\u000b\u0007I\u0011\u0001\u001b_\u0011!!\u0007A!A!\u0002\u0013y\u0006\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011e\u0004!\u0011!Q\u0001\niD\u0001b \u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\u000b\u0003\u0003\u0001!\u0011!Q\u0001\n\u0005\r\u0001BCA\u0005\u0001\t\u0005\t\u0015!\u0003\u0002\f!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001BCA\u0013\u0001\t\u0007I\u0011\u0001\u001b\u0002(!A\u0011q\u0006\u0001!\u0002\u0013\tI\u0003\u0003\u0006\u00022\u0001\u0011\r\u0011\"\u00015\u0003gA\u0001\"a\u000f\u0001A\u0003%\u0011Q\u0007\u0005\u000b\u0003{\u0001!\u0019!C\u0001i\u0005M\u0002\u0002CA \u0001\u0001\u0006I!!\u000e\t\u0015\u0005\u0005\u0003A1A\u0005\u0002Q\n9\u0003\u0003\u0005\u0002D\u0001\u0001\u000b\u0011BA\u0015\u0011)\t)\u0005\u0001b\u0001\n\u0003!\u0014q\t\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002J!I\u0011Q\u000b\u0001A\u0002\u0013%\u0011q\u0005\u0005\n\u0003/\u0002\u0001\u0019!C\u0005\u00033B\u0001\"!\u001a\u0001A\u0003&\u0011\u0011\u0006\u0005\n\u0003O\u0002!\u0019!C\u0005\u0003SB\u0001\"a\u001b\u0001A\u0003%\u00111\u0002\u0005\f\u0003[\u0002\u0001\u0019!a\u0001\n\u0013\ty\u0007C\u0006\u0002\u0000\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0005bCAC\u0001\u0001\u0007\t\u0011)Q\u0005\u0003cB1\"a\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002p!Y\u0011\u0011\u0012\u0001A\u0002\u0003\u0007I\u0011BAF\u0011-\ty\t\u0001a\u0001\u0002\u0003\u0006K!!\u001d\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\"9\u00111\u0014\u0001\u0005B\u0005u\u0005bBAS\u0001\u0011\u0005\u00131\u0013\u0005\b\u0003O\u0003A\u0011IAJ\u0011\u001d\t9\u000b\u0001C!\u0003SCq!a-\u0001\t\u0013\t)\fC\u0004\u0002Z\u0002!\t%a7\t\u000f\u0005E\b\u0001\"\u0011\u0002t\"9\u00111 \u0001\u0005B\u0005u\bb\u0002B\u0002\u0001\u0011\u0005#Q\u0001\u0005\b\u0005\u0013\u0001A\u0011\tB\u0006\u0011\u001d\u0011i\u0001\u0001C!\u0005\u001fAqA!\u0005\u0001\t\u0003\u0012\u0019\u0002C\u0004\u0003\"\u0001!IAa\t\t\u000f\t\u0015\u0002\u0001\"\u0003\u0003(!9!Q\u0007\u0001\u0005\n\t]\u0002b\u0002B\u001f\u0001\u0011\u0005#1B\u0004\b\u0005\u007f!\u0004\u0012\u0001B!\r\u0019\u0019D\u0007#\u0001\u0003D!9\u00111\u0003\u0019\u0005\u0002\t-\u0003b\u0002B\ta\u0011\u0005!Q\n\u0002\u0016\u0017\u000647.Y'jGJ|')\u0019;dQN#(/Z1n\u0015\t)d'\u0001\u0005lC\u001a\\\u0017\rM\u00191\u0015\t9\u0004(A\u0002tc2T!!\u000f\u001e\u0002\u000bM\u0004\u0018M]6\u000b\u0005mb\u0014AB1qC\u000eDWMC\u0001>\u0003\ry'oZ\n\u0007\u0001}:\u0015\u000bV,\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00027b]\u001eT\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0003\n1qJ\u00196fGR\u0004\"\u0001S(\u000e\u0003%S!AS&\u0002\u0013M$(/Z1nS:<'B\u0001'N\u0003\u0011\u0011X-\u00193\u000b\u000593\u0014!C2p]:,7\r^8s\u0013\t\u0001\u0016JA\u000eTkB\u0004xN\u001d;t)JLwmZ3s\u0003Z\f\u0017\u000e\\1cY\u0016tun\u001e\t\u0003\u0011JK!aU%\u0003)I+\u0007o\u001c:ugN{WO]2f\u001b\u0016$(/[2t!\tAU+\u0003\u0002W\u0013\n\u0001R*[2s_\n\u000bGo\u00195TiJ,\u0017-\u001c\t\u00031nk\u0011!\u0017\u0006\u00035b\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00039f\u0013q\u0001T8hO&tw-A\tlC\u001a\\\u0017m\u00144gg\u0016$(+Z1eKJ,\u0012a\u0018\t\u0003A\u0006l\u0011\u0001N\u0005\u0003ER\u0012\u0011cS1gW\u0006|eMZ:fiJ+\u0017\rZ3s\u0007\u0001\t!c[1gW\u0006|eMZ:fiJ+\u0017\rZ3sA\u0005\u0019R\r_3dkR|'oS1gW\u0006\u0004\u0016M]1ngB!qM\u001b7@\u001b\u0005A'BA5D\u0003\u0011)H/\u001b7\n\u0005-D'aA'baB\u0011QN\u001e\b\u0003]R\u0004\"a\u001c:\u000e\u0003AT!!]2\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0018!B:dC2\f\u0017BA;s\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000f\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0014\u0018aB8qi&|gn\u001d\t\u0003wvl\u0011\u0001 \u0006\u0003SZJ!A ?\u00031\r\u000b7/Z%og\u0016t7/\u001b;jm\u0016\u001cFO]5oO6\u000b\u0007/\u0001\u0007nKR\fG-\u0019;b!\u0006$\b.A\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;t!\r\u0001\u0017QA\u0005\u0004\u0003\u000f!$!F&bM.\fwJ\u001a4tKR\u0014\u0016M\\4f\u0019&l\u0017\u000e^\u0001\u000fM\u0006LGn\u00148ECR\fGj\\:t!\u0011\ti!a\u0004\u000e\u0003IL1!!\u0005s\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDCDA\f\u00033\tY\"!\b\u0002 \u0005\u0005\u00121\u0005\t\u0003A\u0002AQ!\u0018\u0005A\u0002}CQ!\u001a\u0005A\u0002\u0019DQ!\u001f\u0005A\u0002iDQa \u0005A\u00021Dq!!\u0001\t\u0001\u0004\t\u0019\u0001C\u0004\u0002\n!\u0001\r!a\u0003\u0002\u001bA|G\u000e\u001c+j[\u0016|W\u000f^'t+\t\tI\u0003\u0005\u0003\u0002\u000e\u0005-\u0012bAA\u0017e\n!Aj\u001c8h\u00039\u0001x\u000e\u001c7US6,w.\u001e;Ng\u0002\nA#\\1y\u001f\u001a47/\u001a;t!\u0016\u0014HK]5hO\u0016\u0014XCAA\u001b!\u0019\ti!a\u000e\u0002*%\u0019\u0011\u0011\b:\u0003\r=\u0003H/[8o\u0003Ui\u0017\r_(gMN,Go\u001d)feR\u0013\u0018nZ4fe\u0002\n1#\\5o\u001f\u001a47/\u001a;QKJ$&/[4hKJ\fA#\\5o\u001f\u001a47/\u001a;QKJ$&/[4hKJ\u0004\u0013!E7bqR\u0013\u0018nZ4fe\u0012+G.Y=Ng\u0006\u0011R.\u0019=Ue&<w-\u001a:EK2\f\u00170T:!\u0003\u0015\u0019Gn\\2l+\t\tI\u0005\u0005\u0003\u0002L\u0005=SBAA'\u0015\tI\u0007(\u0003\u0003\u0002R\u00055#!B\"m_\u000e\\\u0017AB2m_\u000e\\\u0007%A\tmCN$HK]5hO\u0016\u0014X*\u001b7mSN\fQ\u0003\\1tiR\u0013\u0018nZ4fe6KG\u000e\\5t?\u0012*\u0017\u000f\u0006\u0003\u0002\\\u0005\u0005\u0004\u0003BA\u0007\u0003;J1!a\u0018s\u0005\u0011)f.\u001b;\t\u0013\u0005\rD#!AA\u0002\u0005%\u0012a\u0001=%c\u0005\u0011B.Y:u)JLwmZ3s\u001b&dG.[:!\u00039Ign\u00197vI\u0016DU-\u00193feN,\"!a\u0003\u0002\u001f%t7\r\\;eK\"+\u0017\rZ3sg\u0002\na\u0003\\1uKN$\b+\u0019:uSRLwN\\(gMN,Go]\u000b\u0003\u0003c\u0002B!a\u001d\u0002z9\u0019\u0001-!\u001e\n\u0007\u0005]D'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0014Q\u0010\u0002\u0013!\u0006\u0014H/\u001b;j_:|eMZ:fi6\u000b\u0007OC\u0002\u0002xQ\n!\u0004\\1uKN$\b+\u0019:uSRLwN\\(gMN,Go]0%KF$B!a\u0017\u0002\u0004\"I\u00111M\r\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\u0018Y\u0006$Xm\u001d;QCJ$\u0018\u000e^5p]>3gm]3ug\u0002\nQ$\u00197m\t\u0006$\u0018MR8s)JLwmZ3s\u0003Z\f\u0017\u000e\\1cY\u0016tun^\u0001\"C2dG)\u0019;b\r>\u0014HK]5hO\u0016\u0014\u0018I^1jY\u0006\u0014G.\u001a(po~#S-\u001d\u000b\u0005\u00037\ni\tC\u0005\u0002dq\t\t\u00111\u0001\u0002r\u0005q\u0012\r\u001c7ECR\fgi\u001c:Ue&<w-\u001a:Bm\u0006LG.\u00192mK:{w\u000fI\u0001\u000eS:LG/[1m\u001f\u001a47/\u001a;\u0015\u0005\u0005U\u0005c\u0001%\u0002\u0018&\u0019\u0011\u0011T%\u0003\r=3gm]3u\u0003M9W\r\u001e#fM\u0006,H\u000e\u001e*fC\u0012d\u0015.\\5u)\t\ty\nE\u0002I\u0003CK1!a)J\u0005%\u0011V-\u00193MS6LG/\u0001\nsKB|'\u000f\u001e'bi\u0016\u001cHo\u00144gg\u0016$\u0018\u0001\u00047bi\u0016\u001cHo\u00144gg\u0016$HCBAK\u0003W\u000by\u000bC\u0004\u0002.\n\u0002\r!!&\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005E&\u00051\u0001\u0002 \u0006I!/Z1e\u0019&l\u0017\u000e^\u0001\u000bI\u0016d\u0017-\u001f\"bi\u000eDGCCA\u0006\u0003o\u000bY,a5\u0002X\"9\u0011\u0011X\u0012A\u0002\u0005%\u0012\u0001C7j]2KW.\u001b;\t\u000f\u0005u6\u00051\u0001\u0002@\u0006iA.\u0019;fgR|eMZ:fiN\u0004r!\\Aa\u0003\u0007\fI#\u0003\u0002lqB!\u0011QYAh\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017AB2p[6|gNC\u0002\u0002Nj\nQa[1gW\u0006LA!!5\u0002H\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAkG\u0001\u0007\u0011qX\u0001\u000fGV\u0014(/\u001a8u\u001f\u001a47/\u001a;t\u0011\u001d\t\te\ta\u0001\u0003S\t1\u0003\u001d7b]&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N$b!!8\u0002l\u00065\bCBA\u0007\u0003?\f\u0019/C\u0002\u0002bJ\u0014Q!\u0011:sCf\u0004B!!:\u0002h6\t1*C\u0002\u0002j.\u0013a\"\u00138qkR\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002.\u0012\u0002\r!!&\t\u000f\u0005=H\u00051\u0001\u0002\u0016\u0006\u0019QM\u001c3\u0002'\r\u0014X-\u0019;f%\u0016\fG-\u001a:GC\u000e$xN]=\u0015\u0005\u0005U\b\u0003BAs\u0003oL1!!?L\u0005Y\u0001\u0016M\u001d;ji&|gNU3bI\u0016\u0014h)Y2u_JL\u0018!\u00053fg\u0016\u0014\u0018.\u00197ju\u0016|eMZ:fiR!\u0011QSA\u0000\u0011\u0019\u0011\tA\na\u0001Y\u0006!!n]8o\u0003\u0019\u0019w.\\7jiR!\u00111\fB\u0004\u0011\u001d\tyo\na\u0001\u0003+\u000bAa\u001d;paR\u0011\u00111L\u0001\ti>\u001cFO]5oOR\tA.A\u0004nKR\u0014\u0018nY:\u0015\t\tU!q\u0003\t\u0005O*dG\u000eC\u0004\u0003\u001a)\u0002\rAa\u0007\u0002)1\fG/Z:u\u0007>t7/^7fI>3gm]3u!\u00159'QDAK\u0013\r\u0011y\u0002\u001b\u0002\t\u001fB$\u0018n\u001c8bY\u0006\u0011s-\u001a;Pe\u000e\u0013X-\u0019;f\u0013:LG/[1m!\u0006\u0014H/\u001b;j_:|eMZ:fiN$\"!!\u001d\u0002\u0013I\fG/\u001a'j[&$H\u0003CA9\u0005S\u0011iC!\r\t\u000f\t-B\u00061\u0001\u0002*\u0005)A.[7ji\"9!q\u0006\u0017A\u0002\u0005E\u0014\u0001\u00024s_6DqAa\r-\u0001\u0004\t\t(A\u0003v]RLG.\u0001\bsKB|'\u000f\u001e#bi\u0006dun]:\u0015\t\u0005m#\u0011\b\u0005\u0007\u0005wi\u0003\u0019\u00017\u0002\u000f5,7o]1hK\u0006i\u0002O]3qCJ,gi\u001c:Ue&<w-\u001a:Bm\u0006LG.\u00192mK:{w/A\u000bLC\u001a\\\u0017-T5de>\u0014\u0015\r^2i'R\u0014X-Y7\u0011\u0005\u0001\u00044\u0003\u0002\u0019\u0003F]\u0003B!!\u0004\u0003H%\u0019!\u0011\n:\u0003\r\u0005s\u0017PU3g)\t\u0011\t\u0005\u0006\u0004\u0003\u0016\t=#\u0011\u000b\u0005\b\u00053\u0011\u0004\u0019\u0001B\u000e\u0011\u001d\u0011\u0019F\ra\u0001\u0003c\nq\u0004\\1uKN$\u0018I^1jY\u0006\u0014G.\u001a)beRLG/[8o\u001f\u001a47/\u001a;t\u0001")
public class KafkaMicroBatchStream
implements SupportsTriggerAvailableNow,
ReportsSourceMetrics,
MicroBatchStream,
Logging {
    private final KafkaOffsetReader kafkaOffsetReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final Option<Object> minOffsetPerTrigger;
    private final long maxTriggerDelayMs;
    private final Clock clock;
    private long lastTriggerMillis;
    private final boolean includeHeaders;
    private scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets;
    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public KafkaOffsetReader kafkaOffsetReader() {
        return this.kafkaOffsetReader;
    }

    public long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    public Option<Object> minOffsetPerTrigger() {
        return this.minOffsetPerTrigger;
    }

    public long maxTriggerDelayMs() {
        return this.maxTriggerDelayMs;
    }

    public Clock clock() {
        return this.clock;
    }

    private long lastTriggerMillis() {
        return this.lastTriggerMillis;
    }

    private void lastTriggerMillis_$eq(long x$1) {
        this.lastTriggerMillis = x$1;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets() {
        return this.latestPartitionOffsets;
    }

    private void latestPartitionOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.latestPartitionOffsets = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow() {
        return this.allDataForTriggerAvailableNow;
    }

    private void allDataForTriggerAvailableNow_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.allDataForTriggerAvailableNow = x$1;
    }

    public Offset initialOffset() {
        return new KafkaSourceOffset(this.getOrCreateInitialPartitionOffsets());
    }

    public ReadLimit getDefaultReadLimit() {
        return this.minOffsetPerTrigger().isDefined() && this.maxOffsetsPerTrigger().isDefined() ? ReadLimit.compositeLimit((ReadLimit[])((ReadLimit[])((Object[])new ReadLimit[]{ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()), ReadLimit.maxRows((long)BoxesRunTime.unboxToLong((Object)this.maxOffsetsPerTrigger().get()))}))) : (this.minOffsetPerTrigger().isDefined() ? ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()) : (ReadLimit)this.maxOffsetsPerTrigger().map((Function1 & Serializable)x$1 -> KafkaMicroBatchStream.$anonfun$getDefaultReadLimit$1(BoxesRunTime.unboxToLong((Object)x$1))).getOrElse((Function0 & Serializable)() -> ReadLimit.allAvailable()));
    }

    public Offset reportLatestOffset() {
        return (Offset)Option$.MODULE$.apply((Object)new KafkaSourceOffset(this.latestPartitionOffsets())).filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$reportLatestOffset$1(x$5))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Offset latestOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset latestOffset(Offset start, ReadLimit readLimit) {
        scala.collection.immutable.Map map;
        IndexedSeq indexedSeq;
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        this.latestPartitionOffsets_$eq(this.allDataForTriggerAvailableNow() != null ? this.allDataForTriggerAvailableNow() : this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(startPartitionOffsets)));
        ReadLimit readLimit2 = readLimit;
        if (readLimit2 instanceof CompositeReadLimit) {
            CompositeReadLimit compositeReadLimit = (CompositeReadLimit)readLimit2;
            indexedSeq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)compositeReadLimit.getReadLimits());
        } else {
            indexedSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReadLimit[]{readLimit2}));
        }
        IndexedSeq limits = indexedSeq;
        if (limits.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$1(x$6)))) {
            map = this.latestPartitionOffsets();
        } else {
            Option lowerLimit = limits.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$2(x$7))).map((Function1 & Serializable)x$8 -> (ReadMinRows)x$8);
            Option upperLimit = limits.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$4(x$9))).map((Function1 & Serializable)x$10 -> (ReadMaxRows)x$10);
            map = (scala.collection.immutable.Map)lowerLimit.flatMap((Function1 & Serializable)limit -> {
                None$ none$;
                boolean skipBatch = this.delayBatch(limit.minRows(), this.latestPartitionOffsets(), startPartitionOffsets, limit.maxTriggerDelayMs());
                if (skipBatch) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Delaying batch as number of records available is less than minOffsetsPerTrigger");
                    none$ = new Some((Object)startPartitionOffsets);
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }).orElse((Function0 & Serializable)() -> upperLimit.map((Function1 & Serializable)limit -> this.rateLimit(limit.maxRows(), startPartitionOffsets, this.latestPartitionOffsets()))).getOrElse((Function0 & Serializable)() -> this.latestPartitionOffsets());
        }
        scala.collection.immutable.Map offsets = map;
        return (Offset)Option$.MODULE$.apply((Object)new KafkaSourceOffset(offsets)).filterNot((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$11(x$11))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean delayBatch(long minLimit, scala.collection.immutable.Map<TopicPartition, Object> latestOffsets, scala.collection.immutable.Map<TopicPartition, Object> currentOffsets, long maxTriggerDelayMs) {
        boolean bl;
        if (this.clock().getTimeMillis() - this.lastTriggerMillis() >= maxTriggerDelayMs) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Maximum wait time is passed, triggering batch");
            this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
            bl = false;
        } else {
            double newRecords = BoxesRunTime.unboxToLong((Object)((MapOps)latestOffsets.flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topic = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Some some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToLong((long)(offset - BoxesRunTime.unboxToLong((Object)currentOffsets.getOrElse((Object)topic, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))))));
                return some;
            })).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            if (newRecords < (double)minLimit) {
                bl = true;
            } else {
                this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
                bl = false;
            }
        }
        return bl;
    }

    public InputPartition[] planInputPartitions(Offset start, Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        scala.collection.immutable.Map<TopicPartition, Object> endPartitionOffsets = ((KafkaSourceOffset)end).partitionToOffsets();
        Seq<KafkaOffsetRange> offsetRanges = this.kafkaOffsetReader().getOffsetRangesFromResolvedOffsets(startPartitionOffsets, endPartitionOffsets, (Function1<String, BoxedUnit>)(Function1 & Serializable)message -> {
            this.reportDataLoss(message);
            return BoxedUnit.UNIT;
        });
        return (InputPartition[])((IterableOnceOps)offsetRanges.map((Function1 & Serializable)range -> new KafkaBatchInputPartition((KafkaOffsetRange)range, $this.executorKafkaParams, this.pollTimeoutMs(), $this.failOnDataLoss, this.includeHeaders()))).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public PartitionReaderFactory createReaderFactory() {
        return KafkaBatchReaderFactory$.MODULE$;
    }

    public Offset deserializeOffset(String json) {
        return new KafkaSourceOffset(JsonUtils$.MODULE$.partitionOffsets(json));
    }

    public void commit(Offset end) {
    }

    public void stop() {
        this.kafkaOffsetReader().close();
    }

    public String toString() {
        return new StringBuilder(9).append("KafkaV2[").append(this.kafkaOffsetReader()).append("]").toString();
    }

    public Map<String, String> metrics(Optional<Offset> latestConsumedOffset) {
        return KafkaMicroBatchStream$.MODULE$.metrics(latestConsumedOffset, this.latestPartitionOffsets());
    }

    private scala.collection.immutable.Map<TopicPartition, Object> getOrCreateInitialPartitionOffsets() {
        Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
        Predef$.MODULE$.assert(SparkSession$.MODULE$.getActiveSession().nonEmpty());
        KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter((SparkSession)SparkSession$.MODULE$.getActiveSession().get(), this.metadataPath);
        return ((KafkaSourceOffset)metadataLog.get(0L).getOrElse((Function0 & Serializable)() -> {
            void var3_12;
            KafkaSourceOffset kafkaSourceOffset;
            KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
            if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchEarliestOffsets());
            } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
            } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable)message -> {
                    this.reportDataLoss(message);
                    return BoxedUnit.UNIT;
                });
            } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                Enumeration.Value strategy = specificTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificTimestampBasedOffsets(p, true, strategy);
            } else if (kafkaOffsetRangeLimit instanceof GlobalTimestampRangeLimit) {
                GlobalTimestampRangeLimit globalTimestampRangeLimit = (GlobalTimestampRangeLimit)kafkaOffsetRangeLimit;
                long ts = globalTimestampRangeLimit.timestamp();
                Enumeration.Value strategy = globalTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchGlobalTimestampBasedOffsets(ts, true, strategy);
            } else {
                throw new MatchError((Object)kafkaOffsetRangeLimit);
            }
            KafkaSourceOffset offsets = kafkaSourceOffset;
            metadataLog.add(0L, offsets);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append(offsets).toString());
            return var3_12;
        })).partitionToOffsets();
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        LazyRef fromNew$lzy = new LazyRef();
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Option option = from.get((Object)tp).orElse((Function0 & Serializable)() -> this.fromNew$1(fromNew$lzy, until, from).get((Object)tp)).flatMap((Function1 & Serializable)begin -> KafkaMicroBatchStream.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin)));
            return option;
        });
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return total < 1.0 ? until : (scala.collection.immutable.Map)until.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable)size -> {
                long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)this.fromNew$1(fromNew$lzy, until, from).apply((Object)tp))));
                double prorate = (double)limit * ((double)size / total);
                long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                return Math.min(end, off);
            }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> end));
            return tuple22;
        });
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(0).append(message).append(new StringBuilder(2).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(message).append(new StringBuilder(2).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString()).toString());
    }

    public void prepareForTriggerAvailableNow() {
        this.allDataForTriggerAvailableNow_$eq(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(this.getOrCreateInitialPartitionOffsets())));
    }

    public static final /* synthetic */ ReadLimit $anonfun$getDefaultReadLimit$1(long x$1) {
        return ReadLimit.maxRows((long)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$reportLatestOffset$1(KafkaSourceOffset x$5) {
        return x$5.partitionToOffsets().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$1(ReadLimit x$6) {
        return x$6 instanceof ReadAllAvailable;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$2(ReadLimit x$7) {
        return x$7 instanceof ReadMinRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$4(ReadLimit x$9) {
        return x$9 instanceof ReadMaxRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$11(KafkaSourceOffset x$11) {
        return x$11.partitionToOffsets().isEmpty();
    }

    private final /* synthetic */ scala.collection.immutable.Map fromNew$lzycompute$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = fromNew$lzy$1;
        synchronized (lazyRef) {
            map = fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : (scala.collection.immutable.Map)fromNew$lzy$1.initialize(this.kafkaOffsetReader().fetchEarliestOffsets((Seq<TopicPartition>)until$1.keySet().diff((Set)from$1.keySet()).toSeq()));
        }
        return map;
    }

    private final scala.collection.immutable.Map fromNew$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        return fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : this.fromNew$lzycompute$1(fromNew$lzy$1, until$1, from$1);
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaMicroBatchStream $this, long end$1, TopicPartition tp$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("rateLimit ").append(tp$1).append(" size is ").append(size).toString());
        return size > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)BoxesRunTime.boxToLong((long)size))) : None$.MODULE$;
    }

    public KafkaMicroBatchStream(KafkaOffsetReader kafkaOffsetReader, Map<String, Object> executorKafkaParams, CaseInsensitiveStringMap options, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.kafkaOffsetReader = kafkaOffsetReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Logging.$init$((Logging)this);
        this.pollTimeoutMs = options.getLong(KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L);
        this.maxOffsetsPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER())).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$1))));
        this.minOffsetPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MIN_OFFSET_PER_TRIGGER())).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$2))));
        this.maxTriggerDelayMs = Utils$.MODULE$.timeStringAsMs((String)Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_TRIGGER_DELAY())).getOrElse((Function0 & Serializable)() -> KafkaSourceProvider$.MODULE$.DEFAULT_MAX_TRIGGER_DELAY()));
        this.clock = options.containsKey((Object)KafkaSourceProvider$.MODULE$.MOCK_SYSTEM_TIME()) ? new MockedSystemClock() : new SystemClock();
        this.lastTriggerMillis = 0L;
        this.includeHeaders = options.getBoolean(KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), false);
    }
}

