/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.CompositeReadLimit;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.ReadMinRows;
import org.apache.spark.sql.connector.read.streaming.ReportsSourceMetrics;
import org.apache.spark.sql.connector.read.streaming.SupportsTriggerAvailableNow;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.JsonUtils$;
import org.apache.spark.sql.kafka010.KafkaBatchInputPartition;
import org.apache.spark.sql.kafka010.KafkaBatchReaderFactory$;
import org.apache.spark.sql.kafka010.KafkaExceptions$;
import org.apache.spark.sql.kafka010.KafkaMicroBatchStream$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.MockedSystemClock;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t}c!\u0002\u001b6\u0001Uz\u0004\"\u00030\u0001\u0005\u000b\u0007I\u0011A\u001b`\u0011!)\u0007A!A!\u0002\u0013\u0001\u0007\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011B4\t\u0011i\u0004!\u0011!Q\u0001\nmD\u0011\"!\u0001\u0001\u0005\u0003\u0005\u000b\u0011B7\t\u0015\u0005\r\u0001A!A!\u0002\u0013\t)\u0001\u0003\u0006\u0002\f\u0001\u0011\t\u0011)A\u0005\u0003\u001bAq!!\u0006\u0001\t\u0003\t9\u0002\u0003\u0006\u0002(\u0001\u0011\r\u0011\"\u00016\u0003SA\u0001\"!\r\u0001A\u0003%\u00111\u0006\u0005\u000b\u0003g\u0001!\u0019!C\u0001k\u0005U\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\u000e\t\u0015\u0005}\u0002A1A\u0005\u0002U\n)\u0004\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u001c\u0011)\t\u0019\u0005\u0001b\u0001\n\u0003)\u0014\u0011\u0006\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002,!Q\u0011q\t\u0001C\u0002\u0013\u0005Q'!\u0013\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u0017B\u0011\"a\u0016\u0001\u0001\u0004%I!!\u000b\t\u0013\u0005e\u0003\u00011A\u0005\n\u0005m\u0003\u0002CA4\u0001\u0001\u0006K!a\u000b\t\u0013\u0005%\u0004A1A\u0005\n\u0005-\u0004\u0002CA7\u0001\u0001\u0006I!!\u0004\t\u0017\u0005=\u0004\u00011AA\u0002\u0013%\u0011\u0011\u000f\u0005\f\u0003\u0003\u0003\u0001\u0019!a\u0001\n\u0013\t\u0019\tC\u0006\u0002\b\u0002\u0001\r\u0011!Q!\n\u0005M\u0004bCAE\u0001\u0001\u0007\t\u0019!C\u0005\u0003cB1\"a#\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u000e\"Y\u0011\u0011\u0013\u0001A\u0002\u0003\u0005\u000b\u0015BA:\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!!(\u0001\t\u0003\ny\nC\u0004\u0002(\u0002!\t%!&\t\u000f\u0005%\u0006\u0001\"\u0011\u0002\u0016\"9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBA[\u0001\u0011%\u0011q\u0017\u0005\b\u00037\u0004A\u0011IAo\u0011\u001d\t\u0019\u0010\u0001C!\u0003kDq!!@\u0001\t\u0003\ny\u0010C\u0004\u0003\u0006\u0001!\tEa\u0002\t\u000f\t-\u0001\u0001\"\u0011\u0003\u000e!9!q\u0002\u0001\u0005B\tE\u0001b\u0002B\n\u0001\u0011\u0005#Q\u0003\u0005\b\u0005G\u0001A\u0011\u0002B\u0013\u0011\u001d\u00119\u0003\u0001C\u0005\u0005SAqAa\u000e\u0001\t\u0013\u0011I\u0004C\u0004\u0003@\u0001!IA!\u0011\t\u000f\t\u001d\u0003\u0001\"\u0011\u0003\u000e\u001d9!\u0011J\u001b\t\u0002\t-cA\u0002\u001b6\u0011\u0003\u0011i\u0005C\u0004\u0002\u0016E\"\tA!\u0016\t\u000f\tM\u0011\u0007\"\u0001\u0003X\t)2*\u00194lC6K7M]8CCR\u001c\u0007n\u0015;sK\u0006l'B\u0001\u001c8\u0003!Y\u0017MZ6baE\u0002$B\u0001\u001d:\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003um\nQa\u001d9be.T!\u0001P\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0014aA8sON1\u0001\u0001\u0011%S+b\u0003\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\t1\fgn\u001a\u0006\u0002\u000b\u0006!!.\u0019<b\u0013\t9%I\u0001\u0004PE*,7\r\u001e\t\u0003\u0013Bk\u0011A\u0013\u0006\u0003\u00172\u000b\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u00055s\u0015\u0001\u0002:fC\u0012T!aT\u001c\u0002\u0013\r|gN\\3di>\u0014\u0018BA)K\u0005m\u0019V\u000f\u001d9peR\u001cHK]5hO\u0016\u0014\u0018I^1jY\u0006\u0014G.\u001a(poB\u0011\u0011jU\u0005\u0003)*\u0013ACU3q_J$8oU8ve\u000e,W*\u001a;sS\u000e\u001c\bCA%W\u0013\t9&J\u0001\tNS\u000e\u0014xNQ1uG\"\u001cFO]3b[B\u0011\u0011\fX\u0007\u00025*\u00111,O\u0001\tS:$XM\u001d8bY&\u0011QL\u0017\u0002\b\u0019><w-\u001b8h\u0003EY\u0017MZ6b\u001f\u001a47/\u001a;SK\u0006$WM]\u000b\u0002AB\u0011\u0011MY\u0007\u0002k%\u00111-\u000e\u0002\u0012\u0017\u000647.Y(gMN,GOU3bI\u0016\u00148\u0001A\u0001\u0013W\u000647.Y(gMN,GOU3bI\u0016\u0014\b%A\nfq\u0016\u001cW\u000f^8s\u0017\u000647.\u0019)be\u0006l7\u000f\u0005\u0003iW6\u0004U\"A5\u000b\u0005)$\u0015\u0001B;uS2L!\u0001\\5\u0003\u00075\u000b\u0007\u000f\u0005\u0002oo:\u0011q.\u001e\t\u0003aNl\u0011!\u001d\u0006\u0003e\u0012\fa\u0001\u0010:p_Rt$\"\u0001;\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001c\u0018A\u0002)sK\u0012,g-\u0003\u0002ys\n11\u000b\u001e:j]\u001eT!A^:\u0002\u000f=\u0004H/[8ogB\u0011AP`\u0007\u0002{*\u0011!nN\u0005\u0003\u007fv\u0014\u0001dQ1tK&s7/\u001a8tSRLg/Z*ue&tw-T1q\u00031iW\r^1eCR\f\u0007+\u0019;i\u0003=\u0019H/\u0019:uS:<wJ\u001a4tKR\u001c\bcA1\u0002\b%\u0019\u0011\u0011B\u001b\u0003+-\u000bgm[1PM\u001a\u001cX\r\u001e*b]\u001e,G*[7ji\u0006qa-Y5m\u001f:$\u0015\r^1M_N\u001c\b\u0003BA\b\u0003#i\u0011a]\u0005\u0004\u0003'\u0019(a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001d\u0005e\u00111DA\u000f\u0003?\t\t#a\t\u0002&A\u0011\u0011\r\u0001\u0005\u0006=\"\u0001\r\u0001\u0019\u0005\u0006M\"\u0001\ra\u001a\u0005\u0006u\"\u0001\ra\u001f\u0005\u0007\u0003\u0003A\u0001\u0019A7\t\u000f\u0005\r\u0001\u00021\u0001\u0002\u0006!9\u00111\u0002\u0005A\u0002\u00055\u0011!\u00049pY2$\u0016.\\3pkRl5/\u0006\u0002\u0002,A!\u0011qBA\u0017\u0013\r\tyc\u001d\u0002\u0005\u0019>tw-\u0001\bq_2dG+[7f_V$Xj\u001d\u0011\u0002)5\f\u0007p\u00144gg\u0016$8\u000fU3s)JLwmZ3s+\t\t9\u0004\u0005\u0004\u0002\u0010\u0005e\u00121F\u0005\u0004\u0003w\u0019(AB(qi&|g.A\u000bnCb|eMZ:fiN\u0004VM\u001d+sS\u001e<WM\u001d\u0011\u0002'5Lgn\u00144gg\u0016$\b+\u001a:Ue&<w-\u001a:\u0002)5Lgn\u00144gg\u0016$\b+\u001a:Ue&<w-\u001a:!\u0003Ei\u0017\r\u001f+sS\u001e<WM\u001d#fY\u0006LXj]\u0001\u0013[\u0006DHK]5hO\u0016\u0014H)\u001a7bs6\u001b\b%A\u0003dY>\u001c7.\u0006\u0002\u0002LA!\u0011QJA)\u001b\t\tyE\u0003\u0002ks%!\u00111KA(\u0005\u0015\u0019En\\2l\u0003\u0019\u0019Gn\\2lA\u0005\tB.Y:u)JLwmZ3s\u001b&dG.[:\u0002+1\f7\u000f\u001e+sS\u001e<WM]'jY2L7o\u0018\u0013fcR!\u0011QLA2!\u0011\ty!a\u0018\n\u0007\u0005\u00054O\u0001\u0003V]&$\b\"CA3)\u0005\u0005\t\u0019AA\u0016\u0003\rAH%M\u0001\u0013Y\u0006\u001cH\u000f\u0016:jO\u001e,'/T5mY&\u001c\b%\u0001\bj]\u000edW\u000fZ3IK\u0006$WM]:\u0016\u0005\u00055\u0011aD5oG2,H-\u001a%fC\u0012,'o\u001d\u0011\u0002-1\fG/Z:u!\u0006\u0014H/\u001b;j_:|eMZ:fiN,\"!a\u001d\u0011\t\u0005U\u00141\u0010\b\u0004C\u0006]\u0014bAA=k\u00059\u0001/Y2lC\u001e,\u0017\u0002BA?\u0003\u007f\u0012!\u0003U1si&$\u0018n\u001c8PM\u001a\u001cX\r^'ba*\u0019\u0011\u0011P\u001b\u000251\fG/Z:u!\u0006\u0014H/\u001b;j_:|eMZ:fiN|F%Z9\u0015\t\u0005u\u0013Q\u0011\u0005\n\u0003KJ\u0012\u0011!a\u0001\u0003g\nq\u0003\\1uKN$\b+\u0019:uSRLwN\\(gMN,Go\u001d\u0011\u0002;\u0005dG\u000eR1uC\u001a{'\u000f\u0016:jO\u001e,'/\u0011<bS2\f'\r\\3O_^\f\u0011%\u00197m\t\u0006$\u0018MR8s)JLwmZ3s\u0003Z\f\u0017\u000e\\1cY\u0016tun^0%KF$B!!\u0018\u0002\u0010\"I\u0011Q\r\u000f\u0002\u0002\u0003\u0007\u00111O\u0001\u001fC2dG)\u0019;b\r>\u0014HK]5hO\u0016\u0014\u0018I^1jY\u0006\u0014G.\u001a(po\u0002\nQ\"\u001b8ji&\fGn\u00144gg\u0016$HCAAL!\rI\u0015\u0011T\u0005\u0004\u00037S%AB(gMN,G/A\nhKR$UMZ1vYR\u0014V-\u00193MS6LG\u000f\u0006\u0002\u0002\"B\u0019\u0011*a)\n\u0007\u0005\u0015&JA\u0005SK\u0006$G*[7ji\u0006\u0011\"/\u001a9peRd\u0015\r^3ti>3gm]3u\u00031a\u0017\r^3ti>3gm]3u)\u0019\t9*!,\u00022\"9\u0011q\u0016\u0012A\u0002\u0005]\u0015!B:uCJ$\bbBAZE\u0001\u0007\u0011\u0011U\u0001\ne\u0016\fG\rT5nSR\f!\u0002Z3mCf\u0014\u0015\r^2i))\ti!!/\u0002>\u0006U\u0017\u0011\u001c\u0005\b\u0003w\u001b\u0003\u0019AA\u0016\u0003!i\u0017N\u001c'j[&$\bbBA`G\u0001\u0007\u0011\u0011Y\u0001\u000eY\u0006$Xm\u001d;PM\u001a\u001cX\r^:\u0011\u000f9\f\u0019-!2\u0002,%\u0011A.\u001f\t\u0005\u0003\u000f\f\t.\u0004\u0002\u0002J*!\u00111ZAg\u0003\u0019\u0019w.\\7p]*\u0019\u0011qZ\u001e\u0002\u000b-\fgm[1\n\t\u0005M\u0017\u0011\u001a\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t9n\ta\u0001\u0003\u0003\fabY;se\u0016tGo\u00144gg\u0016$8\u000fC\u0004\u0002D\r\u0002\r!a\u000b\u0002'Ad\u0017M\\%oaV$\b+\u0019:uSRLwN\\:\u0015\r\u0005}\u0017Q^Ax!\u0019\ty!!9\u0002f&\u0019\u00111]:\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005\u001d\u0018\u0011^\u0007\u0002\u0019&\u0019\u00111\u001e'\u0003\u001d%s\u0007/\u001e;QCJ$\u0018\u000e^5p]\"9\u0011q\u0016\u0013A\u0002\u0005]\u0005bBAyI\u0001\u0007\u0011qS\u0001\u0004K:$\u0017aE2sK\u0006$XMU3bI\u0016\u0014h)Y2u_JLHCAA|!\u0011\t9/!?\n\u0007\u0005mHJ\u0001\fQCJ$\u0018\u000e^5p]J+\u0017\rZ3s\r\u0006\u001cGo\u001c:z\u0003E!Wm]3sS\u0006d\u0017N_3PM\u001a\u001cX\r\u001e\u000b\u0005\u0003/\u0013\t\u0001\u0003\u0004\u0003\u0004\u0019\u0002\r!\\\u0001\u0005UN|g.\u0001\u0004d_6l\u0017\u000e\u001e\u000b\u0005\u0003;\u0012I\u0001C\u0004\u0002r\u001e\u0002\r!a&\u0002\tM$x\u000e\u001d\u000b\u0003\u0003;\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002[\u00069Q.\u001a;sS\u000e\u001cH\u0003\u0002B\f\u00053\u0001B\u0001[6n[\"9!1\u0004\u0016A\u0002\tu\u0011\u0001\u00067bi\u0016\u001cHoQ8ogVlW\rZ(gMN,G\u000fE\u0003i\u0005?\t9*C\u0002\u0003\"%\u0014\u0001b\u00149uS>t\u0017\r\\\u0001#O\u0016$xJ]\"sK\u0006$X-\u00138ji&\fG\u000eU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:\u0015\u0005\u0005M\u0014!\u0003:bi\u0016d\u0015.\\5u)!\t\u0019Ha\u000b\u00030\tM\u0002b\u0002B\u0017Y\u0001\u0007\u00111F\u0001\u0006Y&l\u0017\u000e\u001e\u0005\b\u0005ca\u0003\u0019AA:\u0003\u00111'o\\7\t\u000f\tUB\u00061\u0001\u0002t\u0005)QO\u001c;jY\u0006q!/\u001a9peR$\u0015\r^1M_N\u001cH\u0003BA/\u0005wAaA!\u0010.\u0001\u0004i\u0017aB7fgN\fw-Z\u0001&m\u0016\u0014\u0018NZ=F]\u0012|eMZ:fi\u001a{'\u000f\u0016:jO\u001e,'/\u0011<bS2\f'\r\\3O_^$B!!\u0018\u0003D!9!Q\t\u0018A\u0002\u0005\u0005\u0017aE3oIB\u000b'\u000f^5uS>twJ\u001a4tKR\u001c\u0018!\b9sKB\f'/\u001a$peR\u0013\u0018nZ4fe\u00063\u0018-\u001b7bE2,gj\\<\u0002+-\u000bgm[1NS\u000e\u0014xNQ1uG\"\u001cFO]3b[B\u0011\u0011-M\n\u0005c\t=\u0003\f\u0005\u0003\u0002\u0010\tE\u0013b\u0001B*g\n1\u0011I\\=SK\u001a$\"Aa\u0013\u0015\r\t]!\u0011\fB.\u0011\u001d\u0011Yb\ra\u0001\u0005;AqA!\u00184\u0001\u0004\t\u0019(A\u0010mCR,7\u000f^!wC&d\u0017M\u00197f!\u0006\u0014H/\u001b;j_:|eMZ:fiN\u0004")
public class KafkaMicroBatchStream
implements SupportsTriggerAvailableNow,
ReportsSourceMetrics,
MicroBatchStream,
Logging {
    private final KafkaOffsetReader kafkaOffsetReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final Option<Object> minOffsetPerTrigger;
    private final long maxTriggerDelayMs;
    private final Clock clock;
    private long lastTriggerMillis;
    private final boolean includeHeaders;
    private scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets;
    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public KafkaOffsetReader kafkaOffsetReader() {
        return this.kafkaOffsetReader;
    }

    public long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    public Option<Object> minOffsetPerTrigger() {
        return this.minOffsetPerTrigger;
    }

    public long maxTriggerDelayMs() {
        return this.maxTriggerDelayMs;
    }

    public Clock clock() {
        return this.clock;
    }

    private long lastTriggerMillis() {
        return this.lastTriggerMillis;
    }

    private void lastTriggerMillis_$eq(long x$1) {
        this.lastTriggerMillis = x$1;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets() {
        return this.latestPartitionOffsets;
    }

    private void latestPartitionOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.latestPartitionOffsets = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow() {
        return this.allDataForTriggerAvailableNow;
    }

    private void allDataForTriggerAvailableNow_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.allDataForTriggerAvailableNow = x$1;
    }

    public Offset initialOffset() {
        return new KafkaSourceOffset(this.getOrCreateInitialPartitionOffsets());
    }

    public ReadLimit getDefaultReadLimit() {
        return this.minOffsetPerTrigger().isDefined() && this.maxOffsetsPerTrigger().isDefined() ? ReadLimit.compositeLimit((ReadLimit[])((ReadLimit[])((Object[])new ReadLimit[]{ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()), ReadLimit.maxRows((long)BoxesRunTime.unboxToLong((Object)this.maxOffsetsPerTrigger().get()))}))) : (this.minOffsetPerTrigger().isDefined() ? ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()) : (ReadLimit)this.maxOffsetsPerTrigger().map((Function1 & Serializable)x$1 -> KafkaMicroBatchStream.$anonfun$getDefaultReadLimit$1(BoxesRunTime.unboxToLong((Object)x$1))).getOrElse((Function0 & Serializable)() -> ReadLimit.allAvailable()));
    }

    public Offset reportLatestOffset() {
        return (Offset)Option$.MODULE$.apply((Object)new KafkaSourceOffset(this.latestPartitionOffsets())).filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$reportLatestOffset$1(x$5))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Offset latestOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset latestOffset(Offset start, ReadLimit readLimit) {
        scala.collection.immutable.Map map;
        IndexedSeq indexedSeq;
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        this.latestPartitionOffsets_$eq(this.allDataForTriggerAvailableNow() != null ? this.allDataForTriggerAvailableNow() : this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(startPartitionOffsets)));
        ReadLimit readLimit2 = readLimit;
        if (readLimit2 instanceof CompositeReadLimit) {
            CompositeReadLimit compositeReadLimit = (CompositeReadLimit)readLimit2;
            indexedSeq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)compositeReadLimit.getReadLimits());
        } else {
            indexedSeq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReadLimit[]{readLimit2}));
        }
        IndexedSeq limits = indexedSeq;
        if (limits.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$1(x$6)))) {
            map = this.latestPartitionOffsets();
        } else {
            Option lowerLimit = limits.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$2(x$7))).map((Function1 & Serializable)x$8 -> (ReadMinRows)x$8);
            Option upperLimit = limits.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$4(x$9))).map((Function1 & Serializable)x$10 -> (ReadMaxRows)x$10);
            map = (scala.collection.immutable.Map)lowerLimit.flatMap((Function1 & Serializable)limit -> {
                None$ none$;
                boolean skipBatch = this.delayBatch(limit.minRows(), this.latestPartitionOffsets(), startPartitionOffsets, limit.maxTriggerDelayMs());
                if (skipBatch) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Delaying batch as number of records available is less than minOffsetsPerTrigger");
                    none$ = new Some((Object)startPartitionOffsets);
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }).orElse((Function0 & Serializable)() -> upperLimit.map((Function1 & Serializable)limit -> this.rateLimit(limit.maxRows(), startPartitionOffsets, this.latestPartitionOffsets()))).getOrElse((Function0 & Serializable)() -> this.latestPartitionOffsets());
        }
        scala.collection.immutable.Map offsets = map;
        return (Offset)Option$.MODULE$.apply((Object)new KafkaSourceOffset(offsets)).filterNot((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$11(x$11))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean delayBatch(long minLimit, scala.collection.immutable.Map<TopicPartition, Object> latestOffsets, scala.collection.immutable.Map<TopicPartition, Object> currentOffsets, long maxTriggerDelayMs) {
        boolean bl;
        if (this.clock().getTimeMillis() - this.lastTriggerMillis() >= maxTriggerDelayMs) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Maximum wait time is passed, triggering batch");
            this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
            bl = false;
        } else {
            double newRecords = BoxesRunTime.unboxToLong((Object)((MapOps)latestOffsets.flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topic = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Some some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToLong((long)(offset - BoxesRunTime.unboxToLong((Object)currentOffsets.getOrElse((Object)topic, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))))));
                return some;
            })).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            if (newRecords < (double)minLimit) {
                bl = true;
            } else {
                this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
                bl = false;
            }
        }
        return bl;
    }

    public InputPartition[] planInputPartitions(Offset start, Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        scala.collection.immutable.Map<TopicPartition, Object> endPartitionOffsets = ((KafkaSourceOffset)end).partitionToOffsets();
        if (this.allDataForTriggerAvailableNow() != null) {
            this.verifyEndOffsetForTriggerAvailableNow(endPartitionOffsets);
        }
        Seq<KafkaOffsetRange> offsetRanges = this.kafkaOffsetReader().getOffsetRangesFromResolvedOffsets(startPartitionOffsets, endPartitionOffsets, (Function1<String, BoxedUnit>)(Function1 & Serializable)message -> {
            this.reportDataLoss(message);
            return BoxedUnit.UNIT;
        });
        return (InputPartition[])((IterableOnceOps)offsetRanges.map((Function1 & Serializable)range -> new KafkaBatchInputPartition((KafkaOffsetRange)range, $this.executorKafkaParams, this.pollTimeoutMs(), $this.failOnDataLoss, this.includeHeaders()))).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public PartitionReaderFactory createReaderFactory() {
        return KafkaBatchReaderFactory$.MODULE$;
    }

    public Offset deserializeOffset(String json) {
        return new KafkaSourceOffset(JsonUtils$.MODULE$.partitionOffsets(json));
    }

    public void commit(Offset end) {
    }

    public void stop() {
        this.kafkaOffsetReader().close();
    }

    public String toString() {
        return new StringBuilder(9).append("KafkaV2[").append(this.kafkaOffsetReader()).append("]").toString();
    }

    public Map<String, String> metrics(Optional<Offset> latestConsumedOffset) {
        return KafkaMicroBatchStream$.MODULE$.metrics(latestConsumedOffset, this.latestPartitionOffsets());
    }

    private scala.collection.immutable.Map<TopicPartition, Object> getOrCreateInitialPartitionOffsets() {
        Predef$.MODULE$.assert(SparkSession$.MODULE$.getActiveSession().nonEmpty());
        KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter((SparkSession)SparkSession$.MODULE$.getActiveSession().get(), this.metadataPath);
        return ((KafkaSourceOffset)metadataLog.get(0L).getOrElse((Function0 & Serializable)() -> {
            void var3_12;
            KafkaSourceOffset kafkaSourceOffset;
            KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
            if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchEarliestOffsets());
            } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
            } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable)message -> {
                    this.reportDataLoss(message);
                    return BoxedUnit.UNIT;
                });
            } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                Enumeration.Value strategy = specificTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificTimestampBasedOffsets(p, true, strategy);
            } else if (kafkaOffsetRangeLimit instanceof GlobalTimestampRangeLimit) {
                GlobalTimestampRangeLimit globalTimestampRangeLimit = (GlobalTimestampRangeLimit)kafkaOffsetRangeLimit;
                long ts = globalTimestampRangeLimit.timestamp();
                Enumeration.Value strategy = globalTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchGlobalTimestampBasedOffsets(ts, true, strategy);
            } else {
                throw new MatchError((Object)kafkaOffsetRangeLimit);
            }
            KafkaSourceOffset offsets = kafkaSourceOffset;
            metadataLog.add(0L, offsets);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append(offsets).toString());
            return var3_12;
        })).partitionToOffsets();
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        LazyRef fromNew$lzy = new LazyRef();
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Option option = from.get((Object)tp).orElse((Function0 & Serializable)() -> this.fromNew$1(fromNew$lzy, until, from).get((Object)tp)).flatMap((Function1 & Serializable)begin -> KafkaMicroBatchStream.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin)));
            return option;
        });
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return total < 1.0 ? until : (scala.collection.immutable.Map)until.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable)size -> {
                long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)this.fromNew$1(fromNew$lzy, until, from).apply((Object)tp))));
                double prorate = (double)limit * ((double)size / total);
                long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                return Math.min(end, off);
            }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> end));
            return tuple22;
        });
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(0).append(message).append(new StringBuilder(2).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(message).append(new StringBuilder(2).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString()).toString());
    }

    private void verifyEndOffsetForTriggerAvailableNow(scala.collection.immutable.Map<TopicPartition, Object> endPartitionOffsets) {
        scala.collection.immutable.Set tpsForPrefetched = this.allDataForTriggerAvailableNow().keySet();
        scala.collection.immutable.Set tpsForEndOffset = endPartitionOffsets.keySet();
        scala.collection.immutable.Set set = tpsForPrefetched;
        scala.collection.immutable.Set set2 = tpsForEndOffset;
        if (set == null ? set2 != null : !set.equals(set2)) {
            throw KafkaExceptions$.MODULE$.mismatchedTopicPartitionsBetweenEndOffsetAndPrefetched((scala.collection.immutable.Set<TopicPartition>)tpsForPrefetched, (scala.collection.immutable.Set<TopicPartition>)tpsForEndOffset);
        }
        boolean endOffsetHasGreaterThanPrefetched = this.allDataForTriggerAvailableNow().keySet().exists((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$verifyEndOffsetForTriggerAvailableNow$1(this, endPartitionOffsets, tp)));
        if (endOffsetHasGreaterThanPrefetched) {
            throw KafkaExceptions$.MODULE$.endOffsetHasGreaterOffsetForTopicPartitionThanPrefetched(this.allDataForTriggerAvailableNow(), endPartitionOffsets);
        }
        scala.collection.immutable.Map<TopicPartition, Object> latestOffsets = this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(endPartitionOffsets));
        scala.collection.immutable.Set tpsForLatestOffsets = latestOffsets.keySet();
        if (!tpsForEndOffset.subsetOf((Set)tpsForLatestOffsets)) {
            throw KafkaExceptions$.MODULE$.lostTopicPartitionsInEndOffsetWithTriggerAvailableNow((scala.collection.immutable.Set<TopicPartition>)tpsForLatestOffsets, (scala.collection.immutable.Set<TopicPartition>)tpsForEndOffset);
        }
        boolean endOffsetHasGreaterThenLatest = tpsForEndOffset.exists((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$verifyEndOffsetForTriggerAvailableNow$2(latestOffsets, endPartitionOffsets, tp)));
        if (endOffsetHasGreaterThenLatest) {
            throw KafkaExceptions$.MODULE$.endOffsetHasGreaterOffsetForTopicPartitionThanLatestWithTriggerAvailableNow(latestOffsets, endPartitionOffsets);
        }
    }

    public void prepareForTriggerAvailableNow() {
        this.allDataForTriggerAvailableNow_$eq(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(this.getOrCreateInitialPartitionOffsets())));
    }

    public static final /* synthetic */ ReadLimit $anonfun$getDefaultReadLimit$1(long x$1) {
        return ReadLimit.maxRows((long)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$reportLatestOffset$1(KafkaSourceOffset x$5) {
        return x$5.partitionToOffsets().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$1(ReadLimit x$6) {
        return x$6 instanceof ReadAllAvailable;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$2(ReadLimit x$7) {
        return x$7 instanceof ReadMinRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$4(ReadLimit x$9) {
        return x$9 instanceof ReadMaxRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$11(KafkaSourceOffset x$11) {
        return x$11.partitionToOffsets().isEmpty();
    }

    private final /* synthetic */ scala.collection.immutable.Map fromNew$lzycompute$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = fromNew$lzy$1;
        synchronized (lazyRef) {
            map = fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : (scala.collection.immutable.Map)fromNew$lzy$1.initialize(this.kafkaOffsetReader().fetchEarliestOffsets((Seq<TopicPartition>)until$1.keySet().diff((Set)from$1.keySet()).toSeq()));
        }
        return map;
    }

    private final scala.collection.immutable.Map fromNew$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        return fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : this.fromNew$lzycompute$1(fromNew$lzy$1, until$1, from$1);
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaMicroBatchStream $this, long end$1, TopicPartition tp$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("rateLimit ").append(tp$1).append(" size is ").append(size).toString());
        return size > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)BoxesRunTime.boxToLong((long)size))) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$verifyEndOffsetForTriggerAvailableNow$1(KafkaMicroBatchStream $this, scala.collection.immutable.Map endPartitionOffsets$1, TopicPartition tp) {
        long offsetFromPrefetched = BoxesRunTime.unboxToLong((Object)$this.allDataForTriggerAvailableNow().apply((Object)tp));
        long offsetFromEndOffset = BoxesRunTime.unboxToLong((Object)endPartitionOffsets$1.apply((Object)tp));
        return offsetFromEndOffset > offsetFromPrefetched;
    }

    public static final /* synthetic */ boolean $anonfun$verifyEndOffsetForTriggerAvailableNow$2(scala.collection.immutable.Map latestOffsets$1, scala.collection.immutable.Map endPartitionOffsets$1, TopicPartition tp) {
        long offsetFromLatest = BoxesRunTime.unboxToLong((Object)latestOffsets$1.apply((Object)tp));
        long offsetFromEndOffset = BoxesRunTime.unboxToLong((Object)endPartitionOffsets$1.apply((Object)tp));
        return offsetFromEndOffset > offsetFromLatest;
    }

    public KafkaMicroBatchStream(KafkaOffsetReader kafkaOffsetReader, Map<String, Object> executorKafkaParams, CaseInsensitiveStringMap options, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.kafkaOffsetReader = kafkaOffsetReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Logging.$init$((Logging)this);
        this.pollTimeoutMs = options.getLong(KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L);
        this.maxOffsetsPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER())).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$1))));
        this.minOffsetPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MIN_OFFSET_PER_TRIGGER())).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$2))));
        this.maxTriggerDelayMs = Utils$.MODULE$.timeStringAsMs((String)Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_TRIGGER_DELAY())).getOrElse((Function0 & Serializable)() -> KafkaSourceProvider$.MODULE$.DEFAULT_MAX_TRIGGER_DELAY()));
        this.clock = options.containsKey((Object)KafkaSourceProvider$.MODULE$.MOCK_SYSTEM_TIME()) ? new MockedSystemClock() : new SystemClock();
        this.lastTriggerMillis = 0L;
        this.includeHeaders = options.getBoolean(KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), false);
    }
}

