/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class JsonUtils$ {
    public static final JsonUtils$ MODULE$ = new JsonUtils$();
    private static final Formats formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);

    private Formats formats() {
        return formats;
    }

    public TopicPartition[] partitions(String str) {
        TopicPartition[] topicPartitionArray;
        try {
            topicPartitionArray = (TopicPartition[])((IterableOnceOps)((IterableOps)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Nil$.MODULE$)})))).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    Seq parts = (Seq)tuple2._2();
                    return (Seq)parts.map((Function1 & Serializable)part -> JsonUtils$.$anonfun$partitions$2(topic, BoxesRunTime.unboxToInt((Object)part)));
                }
                throw new MatchError((Object)tuple2);
            })).toArray(ClassTag$.MODULE$.apply(TopicPartition.class));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw new IllegalArgumentException("Expected e.g. {\"topicA\":[0,1],\"topicB\":[0,1]}, got " + str);
            }
            throw throwable;
        }
        return topicPartitionArray;
    }

    public String partitions(Iterable<TopicPartition> partitions) {
        HashMap result = new HashMap();
        partitions.foreach((Function1 & Serializable)tp -> {
            List parts = (List)result.getOrElse((Object)tp.topic(), (Function0 & Serializable)() -> Nil$.MODULE$);
            int n = tp.partition();
            return (HashMap)result.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)parts.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n))));
        });
        return Serialization$.MODULE$.write((Object)result, this.formats());
    }

    public Map<TopicPartition, Object> partitionOffsets(String str) {
        Map map;
        try {
            map = (Map)((MapOps)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(Map.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Long()}))})))).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    Map partOffsets = (Map)tuple2._2();
                    return partOffsets.map((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            int part = tuple2._1$mcI$sp();
                            long offset = tuple2._2$mcJ$sp();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, part)), (Object)BoxesRunTime.boxToLong((long)offset));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                throw new MatchError((Object)tuple2);
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw new IllegalArgumentException("Expected e.g. {\"topicA\":{\"0\":23,\"1\":-1},\"topicB\":{\"0\":-2}}, got " + str);
            }
            throw throwable;
        }
        return map;
    }

    public Map<TopicPartition, Object> partitionTimestamps(String str) {
        Map map;
        try {
            map = (Map)((MapOps)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(Map.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Long()}))})))).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    Map partTimestamps = (Map)tuple2._2();
                    return partTimestamps.map((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            int part = tuple2._1$mcI$sp();
                            long timestamp = tuple2._2$mcJ$sp();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, part)), (Object)BoxesRunTime.boxToLong((long)timestamp));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                throw new MatchError((Object)tuple2);
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw new IllegalArgumentException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Expected e.g. {\"topicA\": {\"0\": 123456789, \"1\": 123456789},\n             |\"topicB\": {\"0\": 123456789, \"1\": 123456789}}, got " + str)));
            }
            throw throwable;
        }
        return map;
    }

    public String partitionOffsets(Map<TopicPartition, Object> partitionOffsets) {
        HashMap result = new HashMap();
        Ordering<TopicPartition> order = new Ordering<TopicPartition>(){
            private static final long serialVersionUID = 0L;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<TopicPartition> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public boolean isReverseOf(Ordering<?> other) {
                return Ordering.isReverseOf$((Ordering)this, other);
            }

            public <U> Ordering<U> on(Function1<U, TopicPartition> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering<TopicPartition> orElse(Ordering<TopicPartition> other) {
                return Ordering.orElse$((Ordering)this, other);
            }

            public <S> Ordering<TopicPartition> orElseBy(Function1<TopicPartition, S> f, Ordering<S> ord) {
                return Ordering.orElseBy$((Ordering)this, f, ord);
            }

            public Ordering.OrderingOps mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public final int compare(TopicPartition x, TopicPartition y) {
                return JsonUtils$.org$apache$spark$sql$kafka010$JsonUtils$$$anonfun$partitionOffsets$3(x, y);
            }
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
        Seq partitions = (Seq)partitionOffsets.keySet().toSeq().sorted((Ordering)order);
        partitions.foreach((Function1 & Serializable)tp -> {
            long off = BoxesRunTime.unboxToLong((Object)partitionOffsets.apply(tp));
            HashMap parts = (HashMap)result.getOrElse((Object)tp.topic(), (Function0 & Serializable)() -> new HashMap());
            parts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)BoxesRunTime.boxToLong((long)off)));
            return (HashMap)result.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)parts));
        });
        return Serialization$.MODULE$.write((Object)result, this.formats());
    }

    public String partitionTimestamps(Map<TopicPartition, Object> topicTimestamps) {
        return this.partitionOffsets(topicTimestamps);
    }

    public static final /* synthetic */ TopicPartition $anonfun$partitions$2(String topic$1, int part) {
        return new TopicPartition(topic$1, part);
    }

    public static final /* synthetic */ int org$apache$spark$sql$kafka010$JsonUtils$$$anonfun$partitionOffsets$3(TopicPartition x, TopicPartition y) {
        return package$.MODULE$.Ordering().Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$).compare((Object)new Tuple2((Object)x.topic(), (Object)BoxesRunTime.boxToInteger((int)x.partition())), (Object)new Tuple2((Object)y.topic(), (Object)BoxesRunTime.boxToInteger((int)y.partition())));
    }

    private JsonUtils$() {
    }
}

