/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkException;
import org.apache.spark.sql.kafka010.KafkaExceptionsHelper$;
import org.apache.spark.sql.kafka010.KafkaIllegalStateException;
import org.apache.spark.sql.kafka010.KafkaIllegalStateException$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ScalaRunTime$;

public final class KafkaExceptions$ {
    public static final KafkaExceptions$ MODULE$ = new KafkaExceptions$();

    public SparkException mismatchedTopicPartitionsBetweenEndOffsetAndPrefetched(Set<TopicPartition> tpsForPrefetched, Set<TopicPartition> tpsForEndOffset) {
        String errMsg = KafkaExceptionsHelper$.MODULE$.errorClassesJsonReader().getErrorMessage("MISMATCHED_TOPIC_PARTITIONS_BETWEEN_END_OFFSET_AND_PREFETCHED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tpsForPrefetched"), (Object)tpsForPrefetched.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tpsForEndOffset"), (Object)tpsForEndOffset.toString())})));
        return new SparkException(errMsg);
    }

    public SparkException endOffsetHasGreaterOffsetForTopicPartitionThanPrefetched(Map<TopicPartition, Object> prefetchedOffset, Map<TopicPartition, Object> endOffset) {
        String errMsg = KafkaExceptionsHelper$.MODULE$.errorClassesJsonReader().getErrorMessage("END_OFFSET_HAS_GREATER_OFFSET_FOR_TOPIC_PARTITION_THAN_PREFETCHED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prefetchedOffset"), (Object)prefetchedOffset.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endOffset"), (Object)endOffset.toString())})));
        return new SparkException(errMsg);
    }

    public SparkException lostTopicPartitionsInEndOffsetWithTriggerAvailableNow(Set<TopicPartition> tpsForLatestOffset, Set<TopicPartition> tpsForEndOffset) {
        String errMsg = KafkaExceptionsHelper$.MODULE$.errorClassesJsonReader().getErrorMessage("LOST_TOPIC_PARTITIONS_IN_END_OFFSET_WITH_TRIGGER_AVAILABLENOW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tpsForLatestOffset"), (Object)tpsForLatestOffset.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tpsForEndOffset"), (Object)tpsForEndOffset.toString())})));
        return new SparkException(errMsg);
    }

    public SparkException endOffsetHasGreaterOffsetForTopicPartitionThanLatestWithTriggerAvailableNow(Map<TopicPartition, Object> latestOffset, Map<TopicPartition, Object> endOffset) {
        String errMsg = KafkaExceptionsHelper$.MODULE$.errorClassesJsonReader().getErrorMessage("END_OFFSET_HAS_GREATER_OFFSET_FOR_TOPIC_PARTITION_THAN_LATEST_WITH_TRIGGER_AVAILABLENOW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestOffset"), (Object)latestOffset.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endOffset"), (Object)endOffset.toString())})));
        return new SparkException(errMsg);
    }

    public KafkaIllegalStateException couldNotReadOffsetRange(long startOffset, long endOffset, TopicPartition topicPartition, String groupId, Throwable cause) {
        return new KafkaIllegalStateException("KAFKA_DATA_LOSS.COULD_NOT_READ_OFFSET_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startOffset"), (Object)Long.toString(startOffset)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endOffset"), (Object)Long.toString(endOffset)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topicPartition"), (Object)topicPartition.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupId"), Option$.MODULE$.apply((Object)groupId).getOrElse((Function0 & Serializable)() -> "null"))}))), cause);
    }

    public KafkaIllegalStateException startOffsetReset(TopicPartition topicPartition, long offset, long fetchedOffset) {
        return new KafkaIllegalStateException("KAFKA_DATA_LOSS.START_OFFSET_RESET", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topicPartition"), (Object)topicPartition.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offset"), (Object)Long.toString(offset)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetchedOffset"), (Object)Long.toString(fetchedOffset))}))), KafkaIllegalStateException$.MODULE$.$lessinit$greater$default$3());
    }

    public KafkaIllegalStateException initialOffsetNotFoundForPartitions(Set<TopicPartition> partitions) {
        return new KafkaIllegalStateException("KAFKA_DATA_LOSS.INITIAL_OFFSET_NOT_FOUND_FOR_PARTITIONS", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), (Object)partitions.toString())}))), KafkaIllegalStateException$.MODULE$.$lessinit$greater$default$3());
    }

    public KafkaIllegalStateException addedPartitionDoesNotStartFromZero(TopicPartition topicPartition, long startOffset) {
        return new KafkaIllegalStateException("KAFKA_DATA_LOSS.ADDED_PARTITION_DOES_NOT_START_FROM_OFFSET_ZERO", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topicPartition"), (Object)topicPartition.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startOffset"), (Object)Long.toString(startOffset))}))), KafkaIllegalStateException$.MODULE$.$lessinit$greater$default$3());
    }

    public KafkaIllegalStateException partitionsDeleted(Set<TopicPartition> partitions, Option<String> groupIdConfigName) {
        Option<String> option = groupIdConfigName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String config = (String)some.value();
            return new KafkaIllegalStateException("KAFKA_DATA_LOSS.PARTITIONS_DELETED_AND_GROUP_ID_CONFIG_PRESENT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), (Object)partitions.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupIdConfig"), (Object)config)}))), KafkaIllegalStateException$.MODULE$.$lessinit$greater$default$3());
        }
        if (None$.MODULE$.equals(option)) {
            return new KafkaIllegalStateException("KAFKA_DATA_LOSS.PARTITIONS_DELETED", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), (Object)partitions.toString())}))), KafkaIllegalStateException$.MODULE$.$lessinit$greater$default$3());
        }
        throw new MatchError(option);
    }

    public KafkaIllegalStateException partitionOffsetChanged(TopicPartition topicPartition, long prevOffset, long newOffset) {
        return new KafkaIllegalStateException("KAFKA_DATA_LOSS.PARTITION_OFFSET_CHANGED", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topicPartition"), (Object)topicPartition.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prevOffset"), (Object)Long.toString(prevOffset)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newOffset"), (Object)Long.toString(newOffset))}))), KafkaIllegalStateException$.MODULE$.$lessinit$greater$default$3());
    }

    public KafkaIllegalStateException startOffsetDoesNotMatchAssigned(Set<TopicPartition> specifiedPartitions, Set<TopicPartition> assignedPartitions) {
        return new KafkaIllegalStateException("KAFKA_START_OFFSET_DOES_NOT_MATCH_ASSIGNED", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"specifiedPartitions"), (Object)specifiedPartitions.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assignedPartitions"), (Object)assignedPartitions.toString())}))), KafkaIllegalStateException$.MODULE$.$lessinit$greater$default$3());
    }

    public KafkaIllegalStateException timestampOffsetDoesNotMatchAssigned(boolean isStartingOffsets, Set<TopicPartition> specifiedPartitions, Set<TopicPartition> assignedPartitions) {
        return new KafkaIllegalStateException("KAFKA_TIMESTAMP_OFFSET_DOES_NOT_MATCH_ASSIGNED", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"position"), (Object)(isStartingOffsets ? "start" : "end")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"specifiedPartitions"), (Object)specifiedPartitions.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assignedPartitions"), (Object)assignedPartitions.toString())}))), KafkaIllegalStateException$.MODULE$.$lessinit$greater$default$3());
    }

    private KafkaExceptions$() {
    }
}

