/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0005}a!B\b\u0011\u0001AQ\u0002\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011A\u0012\t\u0011)\u0002!\u0011!Q\u0001\n\u0011B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tc\u0001\u0011\t\u0011)A\u0005[!)!\u0007\u0001C\u0001g!)\u0001\b\u0001C\u0001s!9a\u000bAI\u0001\n\u00039\u0006\"\u00022\u0001\t\u0013\u0019\u0007\"B6\u0001\t\u0013a\u0007\"B:\u0001\t\u0013!x\u0001CA\u0002!!\u0005\u0001#!\u0002\u0007\u000f=\u0001\u0002\u0012\u0001\t\u0002\b!1!\u0007\u0004C\u0001\u0003\u0013Aq!a\u0003\r\t\u0003\tiA\u0001\u000eLC\u001a\\\u0017m\u00144gg\u0016$(+\u00198hK\u000e\u000bGnY;mCR|'O\u0003\u0002\u0012%\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u00035i\u0017N\u001c)beRLG/[8og\u000e\u0001Q#\u0001\u0013\u0011\u0007q)s%\u0003\u0002';\t1q\n\u001d;j_:\u0004\"\u0001\b\u0015\n\u0005%j\"aA%oi\u0006qQ.\u001b8QCJ$\u0018\u000e^5p]N\u0004\u0013AF7bqJ+7m\u001c:egB+'\u000fU1si&$\u0018n\u001c8\u0016\u00035\u00022\u0001H\u0013/!\tar&\u0003\u00021;\t!Aj\u001c8h\u0003]i\u0017\r\u001f*fG>\u0014Hm\u001d)feB\u000b'\u000f^5uS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004iY:\u0004CA\u001b\u0001\u001b\u0005\u0001\u0002\"B\u0011\u0006\u0001\u0004!\u0003\"B\u0016\u0006\u0001\u0004i\u0013!C4fiJ\u000bgnZ3t)\rQ\u0014j\u0013\t\u0004w\r3eB\u0001\u001fB\u001d\ti\u0004)D\u0001?\u0015\ty$%\u0001\u0004=e>|GOP\u0005\u0002=%\u0011!)H\u0001\ba\u0006\u001c7.Y4f\u0013\t!UIA\u0002TKFT!AQ\u000f\u0011\u0005U:\u0015B\u0001%\u0011\u0005AY\u0015MZ6b\u001f\u001a47/\u001a;SC:<W\rC\u0003K\r\u0001\u0007!(\u0001\u0004sC:<Wm\u001d\u0005\b\u0019\u001a\u0001\n\u00111\u0001N\u0003E)\u00070Z2vi>\u0014Hj\\2bi&|gn\u001d\t\u0004w\rs\u0005CA(T\u001d\t\u0001\u0016\u000b\u0005\u0002>;%\u0011!+H\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002S;\u0005\u0019r-\u001a;SC:<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\t\u0001L\u000b\u0002N3.\n!\f\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003?v\t!\"\u00198o_R\fG/[8o\u0013\t\tGLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1cZ3u\t&4\u0018\u000eZ3e!\u0006\u0014H/\u001b;j_:$2\u0001Z4j!\rYTMR\u0005\u0003M\u0016\u0013!\"\u00138eKb,GmU3r\u0011\u0015A\u0007\u00021\u0001(\u0003\u0015\u0001\u0018M\u001d;t\u0011\u0015Q\u0007\u00021\u0001G\u0003-ygMZ:fiJ\u000bgnZ3\u0002\u0019\u001d,G\u000fU1si\u000e{WO\u001c;\u0015\t\u001djw.\u001d\u0005\u0006]&\u0001\rAL\u0001\u0005g&TX\rC\u0003q\u0013\u0001\u0007a&A\u0005u_R\fGnU5{K\")!/\u0003a\u0001O\u0005AQ.\u001b8QCJ$8/A\u0006hKRdunY1uS>tG\u0003B;w\u0003\u0003\u00012\u0001H\u0013O\u0011\u00159(\u00021\u0001y\u0003\t!\b\u000f\u0005\u0002z}6\t!P\u0003\u0002|y\u000611m\\7n_:T!! \f\u0002\u000b-\fgm[1\n\u0005}T(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006\u0019*\u0001\r!T\u0001\u001b\u0017\u000647.Y(gMN,GOU1oO\u0016\u001c\u0015\r\\2vY\u0006$xN\u001d\t\u0003k1\u0019\"\u0001D\u000e\u0015\u0005\u0005\u0015\u0011!B1qa2LHc\u0001\u001b\u0002\u0010!9\u0011\u0011\u0003\bA\u0002\u0005M\u0011aB8qi&|gn\u001d\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004\n\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003;\t9B\u0001\rDCN,\u0017J\\:f]NLG/\u001b<f'R\u0014\u0018N\\4NCB\u0004")
public class KafkaOffsetRangeCalculator {
    private final Option<Object> minPartitions;
    private final Option<Object> maxRecordsPerPartition;

    public static KafkaOffsetRangeCalculator apply(CaseInsensitiveStringMap options) {
        return KafkaOffsetRangeCalculator$.MODULE$.apply(options);
    }

    public Option<Object> minPartitions() {
        return this.minPartitions;
    }

    public Option<Object> maxRecordsPerPartition() {
        return this.maxRecordsPerPartition;
    }

    public Seq<KafkaOffsetRange> getRanges(Seq<KafkaOffsetRange> ranges, Seq<String> executorLocations) {
        Seq dividedOffsetRanges;
        Seq offsetRanges = (Seq)ranges.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetRangeCalculator.$anonfun$getRanges$1(x$1)));
        if ((this.minPartitions().isEmpty() || offsetRanges.size() >= BoxesRunTime.unboxToInt((Object)this.minPartitions().get())) && this.maxRecordsPerPartition().isEmpty()) {
            return (Seq)offsetRanges.map((Function1 & Serializable)range -> {
                Option<String> x$1 = this.getLocation(range.topicPartition(), executorLocations);
                TopicPartition x$2 = range.copy$default$1();
                long x$3 = range.copy$default$2();
                long x$4 = range.copy$default$3();
                return range.copy(x$2, x$3, x$4, x$1);
            });
        }
        if (this.maxRecordsPerPartition().isDefined()) {
            long maxRecords = BoxesRunTime.unboxToLong((Object)this.maxRecordsPerPartition().get());
            v0 = (Seq)((IterableOps)offsetRanges.flatMap((Function1 & Serializable)range -> {
                long size = range.size();
                int parts = (int)package$.MODULE$.ceil((double)size / (double)maxRecords);
                return this.getDividedPartition(parts, (KafkaOffsetRange)range);
            })).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetRangeCalculator.$anonfun$getRanges$4(x$2)));
        } else {
            v0 = dividedOffsetRanges = offsetRanges;
        }
        if (this.minPartitions().isDefined() && BoxesRunTime.unboxToInt((Object)this.minPartitions().get()) > dividedOffsetRanges.size()) {
            long totalSize = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)dividedOffsetRanges.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            Seq unsplitRanges = (Seq)dividedOffsetRanges.filter((Function1 & Serializable)range -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetRangeCalculator.$anonfun$getRanges$6(this, totalSize, range)));
            long unsplitRangeTotalSize = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)unsplitRanges.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long splitRangeTotalSize = totalSize - unsplitRangeTotalSize;
            Set unsplitRangeTopicPartitions = ((IterableOnceOps)unsplitRanges.map((Function1 & Serializable)x$5 -> x$5.topicPartition())).toSet();
            int splitRangeMinPartitions = package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)this.minPartitions().get()) - unsplitRanges.size(), 1);
            return (Seq)((IterableOps)dividedOffsetRanges.flatMap((Function1 & Serializable)range -> {
                TopicPartition tp = range.topicPartition();
                long size = range.size();
                int parts = unsplitRangeTopicPartitions.contains((Object)tp) ? 1 : this.getPartCount(size, splitRangeTotalSize, splitRangeMinPartitions);
                return this.getDividedPartition(parts, (KafkaOffsetRange)range);
            })).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetRangeCalculator.$anonfun$getRanges$10(x$6)));
        }
        return dividedOffsetRanges;
    }

    public Seq<String> getRanges$default$2() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private IndexedSeq<KafkaOffsetRange> getDividedPartition(int parts, KafkaOffsetRange offsetRange) {
        LongRef remaining = LongRef.create((long)offsetRange.size());
        LongRef startOffset = LongRef.create((long)offsetRange.fromOffset());
        TopicPartition tp = offsetRange.topicPartition();
        long untilOffset = offsetRange.untilOffset();
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), parts).map((Function1 & Serializable)part -> KafkaOffsetRangeCalculator.$anonfun$getDividedPartition$1(remaining, parts, startOffset, untilOffset, tp, BoxesRunTime.unboxToInt((Object)part)));
    }

    private int getPartCount(long size, long totalSize, int minParts) {
        return (int)package$.MODULE$.max(package$.MODULE$.round((double)size / (double)totalSize * (double)minParts), 1L);
    }

    private Option<String> getLocation(TopicPartition tp, Seq<String> executorLocations) {
        int numExecutors = executorLocations.length();
        if (numExecutors > 0) {
            return new Some(executorLocations.apply(KafkaOffsetRangeCalculator.floorMod$1(tp.hashCode(), numExecutors)));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getRanges$1(KafkaOffsetRange x$1) {
        return x$1.size() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$getRanges$4(KafkaOffsetRange x$2) {
        return x$2.size() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$getRanges$6(KafkaOffsetRangeCalculator $this, long totalSize$1, KafkaOffsetRange range) {
        return $this.getPartCount(range.size(), totalSize$1, BoxesRunTime.unboxToInt((Object)$this.minPartitions().get())) == 1;
    }

    public static final /* synthetic */ boolean $anonfun$getRanges$10(KafkaOffsetRange x$6) {
        return x$6.size() > 0L;
    }

    public static final /* synthetic */ KafkaOffsetRange $anonfun$getDividedPartition$1(LongRef remaining$1, int parts$1, LongRef startOffset$1, long untilOffset$1, TopicPartition tp$1, int part) {
        long thisPartition = remaining$1.elem / (long)(parts$1 - part);
        remaining$1.elem -= thisPartition;
        long endOffset = package$.MODULE$.min(startOffset$1.elem + thisPartition, untilOffset$1);
        KafkaOffsetRange offsetRange = new KafkaOffsetRange(tp$1, startOffset$1.elem, endOffset, (Option<String>)None$.MODULE$);
        startOffset$1.elem = endOffset;
        return offsetRange;
    }

    private static final int floorMod$1(long a, int b) {
        return ((int)(a % (long)b) + b) % b;
    }

    public KafkaOffsetRangeCalculator(Option<Object> minPartitions, Option<Object> maxRecordsPerPartition) {
        this.minPartitions = minPartitions;
        this.maxRecordsPerPartition = maxRecordsPerPartition;
        Predef$.MODULE$.require(minPartitions.isEmpty() || BoxesRunTime.unboxToInt((Object)minPartitions.get()) > 0);
        Predef$.MODULE$.require(maxRecordsPerPartition.isEmpty() || BoxesRunTime.unboxToLong((Object)maxRecordsPerPartition.get()) > 0L);
    }
}

