/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.classic.ClassicConversions$;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.connector.read.streaming.CompositeReadLimit;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.ReadMinRows;
import org.apache.spark.sql.connector.read.streaming.SupportsTriggerAvailableNow;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.KafkaExceptions$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter$;
import org.apache.spark.sql.kafka010.KafkaSource$;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceOffset$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaSourceRDD;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.MockedSystemClock;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\teg!\u0002\u001d:\u0001e\u001a\u0005\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u0011%\u0004!\u0011!Q\u0001\n)D\u0001B\u001c\u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\u000b\u0003\u000b\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001\"CA\u000b\u0001\t\u0005\t\u0015!\u0003v\u0011)\t9\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003?\u0001!\u0011!Q\u0001\n\u0005\u0005\u0002bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003\u007fA\u0001\"!\u0013\u0001A\u0003%\u0011\u0011\t\u0005\n\u0003\u0017\u0002!\u0019!C\u0005\u0003\u001bB\u0001\"!\u0016\u0001A\u0003%\u0011q\n\u0005\n\u0003/\u0002!\u0019!C\u0005\u00033B\u0001\"!\u0019\u0001A\u0003%\u00111\f\u0005\u000b\u0003G\u0002!\u0019!C\u0001s\u0005e\u0003\u0002CA3\u0001\u0001\u0006I!a\u0017\t\u0015\u0005\u001d\u0004A1A\u0005\u0002e\ni\u0005\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA(\u0011)\tY\u0007\u0001b\u0001\n\u0003I\u0014Q\u000e\u0005\t\u0003s\u0002\u0001\u0015!\u0003\u0002p!I\u00111\u0010\u0001C\u0002\u0013%\u0011Q\u0010\u0005\t\u0003\u007f\u0002\u0001\u0015!\u0003\u0002\"!I\u0011\u0011\u0011\u0001A\u0002\u0013%\u0011Q\n\u0005\n\u0003\u0007\u0003\u0001\u0019!C\u0005\u0003\u000bC\u0001\"!%\u0001A\u0003&\u0011q\n\u0005\f\u0003'\u0003\u0001\u0019!a\u0001\n\u0013\t)\nC\u0006\u0002&\u0002\u0001\r\u00111A\u0005\n\u0005\u001d\u0006bCAV\u0001\u0001\u0007\t\u0011)Q\u0005\u0003/C!\"!,\u0001\u0011\u000b\u0007I\u0011BAX\u0011\u001d\t)\r\u0001C!\u0003\u000fD\u0011\"a4\u0001\u0001\u0004%I!!5\t\u0013\u0005U\u0007\u00011A\u0005\n\u0005]\u0007\u0002CAn\u0001\u0001\u0006K!a5\t\u0013\u0005u\u0007\u00011A\u0005\n\u0005E\u0007\"CAp\u0001\u0001\u0007I\u0011BAq\u0011!\t)\u000f\u0001Q!\n\u0005M\u0007\"CAt\u0001\t\u0007I\u0011BAu\u0011!\t\t\u0010\u0001Q\u0001\n\u0005-\bbBAz\u0001\u0011\u0005\u0013Q\u001f\u0005\b\u0005\u0007\u0001A\u0011\tB\u0003\u0011\u001d\u0011y\u0001\u0001C!\u0005#AqAa\u0006\u0001\t\u0003\u0012I\u0002C\u0004\u0003$\u0001!IA!\n\t\u000f\tU\u0002\u0001\"\u0003\u00038!9!1\t\u0001\u0005B\t\u0015\u0003b\u0002B:\u0001\u0011\u0005#Q\u000f\u0005\b\u0005o\u0002A\u0011\tB=\u0011\u001d\u0011Y\b\u0001C\u0005\u0005{BqA!(\u0001\t\u0013\u0011y\nC\u0004\u0003&\u0002!\tE!\u001e\b\u0011\t\u001d\u0016\b#\u0001:\u0005S3q\u0001O\u001d\t\u0002e\u0012Y\u000bC\u0004\u0002*Q\"\tAa-\t\u000f\tUF\u0007\"\u0001\u00038\"9!\u0011\u0019\u001b\u0005\n\t\r'aC&bM.\f7k\\;sG\u0016T!AO\u001e\u0002\u0011-\fgm[11cAR!\u0001P\u001f\u0002\u0007M\fHN\u0003\u0002?\u007f\u0005)1\u000f]1sW*\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h'\u0015\u0001A\t\u0014,^!\t)%*D\u0001G\u0015\t9\u0005*\u0001\u0003mC:<'\"A%\u0002\t)\fg/Y\u0005\u0003\u0017\u001a\u0013aa\u00142kK\u000e$\bCA'U\u001b\u0005q%BA(Q\u0003%\u0019HO]3b[&twM\u0003\u0002R%\u0006!!/Z1e\u0015\t\u00196(A\u0005d_:tWm\u0019;pe&\u0011QK\u0014\u0002\u001c'V\u0004\bo\u001c:ugR\u0013\u0018nZ4fe\u00063\u0018-\u001b7bE2,gj\\<\u0011\u0005][V\"\u0001-\u000b\u0005=K&B\u0001.<\u0003%)\u00070Z2vi&|g.\u0003\u0002]1\n11k\\;sG\u0016\u0004\"AX1\u000e\u0003}S!\u0001Y\u001f\u0002\u0011%tG/\u001a:oC2L!AY0\u0003\u000f1{wmZ5oO\u0006Q1/\u001d7D_:$X\r\u001f;\u0004\u0001A\u0011amZ\u0007\u0002w%\u0011\u0001n\u000f\u0002\u000b'Fc5i\u001c8uKb$\u0018aC6bM.\f'+Z1eKJ\u0004\"a\u001b7\u000e\u0003eJ!!\\\u001d\u0003#-\u000bgm[1PM\u001a\u001cX\r\u001e*fC\u0012,'/A\nfq\u0016\u001cW\u000f^8s\u0017\u000647.\u0019)be\u0006l7\u000f\u0005\u0003qgV$U\"A9\u000b\u0005ID\u0015\u0001B;uS2L!\u0001^9\u0003\u00075\u000b\u0007\u000f\u0005\u0002w\u007f:\u0011q/ \t\u0003qnl\u0011!\u001f\u0006\u0003u\u0012\fa\u0001\u0010:p_Rt$\"\u0001?\u0002\u000bM\u001c\u0017\r\\1\n\u0005y\\\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0002\u0005\r!AB*ue&twM\u0003\u0002\u007fw\u0006i1o\\;sG\u0016|\u0005\u000f^5p]N\u0004R!!\u0003\u0002\u0012Ul!!a\u0003\u000b\u0007I\fiAC\u0002\u0002\u0010m\n\u0001bY1uC2L8\u000f^\u0005\u0005\u0003'\tYA\u0001\nDCN,\u0017J\\:f]NLG/\u001b<f\u001b\u0006\u0004\u0018\u0001D7fi\u0006$\u0017\r^1QCRD\u0017aD:uCJ$\u0018N\\4PM\u001a\u001cX\r^:\u0011\u0007-\fY\"C\u0002\u0002\u001ee\u0012QcS1gW\u0006|eMZ:fiJ\u000bgnZ3MS6LG/\u0001\bgC&dwJ\u001c#bi\u0006dun]:\u0011\t\u0005\r\u0012QE\u0007\u0002w&\u0019\u0011qE>\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"\u0002#!\f\u00020\u0005E\u00121GA\u001b\u0003o\tI$a\u000f\u0011\u0005-\u0004\u0001\"B2\t\u0001\u0004)\u0007\"B5\t\u0001\u0004Q\u0007\"\u00028\t\u0001\u0004y\u0007bBA\u0003\u0011\u0001\u0007\u0011q\u0001\u0005\u0007\u0003+A\u0001\u0019A;\t\u000f\u0005]\u0001\u00021\u0001\u0002\u001a!9\u0011q\u0004\u0005A\u0002\u0005\u0005\u0012AA:d+\t\t\t\u0005\u0005\u0003\u0002D\u0005\u0015S\"A\u001f\n\u0007\u0005\u001dSH\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\u0002tG\u0002\nQ\u0002]8mYRKW.Z8vi6\u001bXCAA(!\u0011\t\u0019#!\u0015\n\u0007\u0005M3P\u0001\u0003M_:<\u0017A\u00049pY2$\u0016.\\3pkRl5\u000fI\u0001\u0015[\u0006DxJ\u001a4tKR\u001c\b+\u001a:Ue&<w-\u001a:\u0016\u0005\u0005m\u0003CBA\u0012\u0003;\ny%C\u0002\u0002`m\u0014aa\u00149uS>t\u0017!F7bq>3gm]3ugB+'\u000f\u0016:jO\u001e,'\u000fI\u0001\u0014[&twJ\u001a4tKR\u0004VM\u001d+sS\u001e<WM]\u0001\u0015[&twJ\u001a4tKR\u0004VM\u001d+sS\u001e<WM\u001d\u0011\u0002#5\f\u0007\u0010\u0016:jO\u001e,'\u000fR3mCfl5/\u0001\nnCb$&/[4hKJ$U\r\\1z\u001bN\u0004\u0013!B2m_\u000e\\WCAA8!\u0011\t\t(!\u001e\u000e\u0005\u0005M$B\u0001:>\u0013\u0011\t9(a\u001d\u0003\u000b\rcwnY6\u0002\r\rdwnY6!\u00039Ign\u00197vI\u0016DU-\u00193feN,\"!!\t\u0002\u001f%t7\r\\;eK\"+\u0017\rZ3sg\u0002\n\u0011\u0003\\1tiR\u0013\u0018nZ4fe6KG\u000e\\5t\u0003Ua\u0017m\u001d;Ue&<w-\u001a:NS2d\u0017n]0%KF$B!a\"\u0002\u000eB!\u00111EAE\u0013\r\tYi\u001f\u0002\u0005+:LG\u000fC\u0005\u0002\u0010b\t\t\u00111\u0001\u0002P\u0005\u0019\u0001\u0010J\u0019\u0002%1\f7\u000f\u001e+sS\u001e<WM]'jY2L7\u000fI\u0001\u001eC2dG)\u0019;b\r>\u0014HK]5hO\u0016\u0014\u0018I^1jY\u0006\u0014G.\u001a(poV\u0011\u0011q\u0013\t\u0005\u00033\u000byJD\u0002l\u00037K1!!(:\u0003\u001d\u0001\u0018mY6bO\u0016LA!!)\u0002$\n\u0011\u0002+\u0019:uSRLwN\\(gMN,G/T1q\u0015\r\ti*O\u0001\"C2dG)\u0019;b\r>\u0014HK]5hO\u0016\u0014\u0018I^1jY\u0006\u0014G.\u001a(po~#S-\u001d\u000b\u0005\u0003\u000f\u000bI\u000bC\u0005\u0002\u0010n\t\t\u00111\u0001\u0002\u0018\u0006q\u0012\r\u001c7ECR\fgi\u001c:Ue&<w-\u001a:Bm\u0006LG.\u00192mK:{w\u000fI\u0001\u0018S:LG/[1m!\u0006\u0014H/\u001b;j_:|eMZ:fiN,\"!!-\u0011\u000fY\f\u0019,!.\u0002P%\u0019A/a\u0001\u0011\t\u0005]\u0016\u0011Y\u0007\u0003\u0003sSA!a/\u0002>\u000611m\\7n_:T1!a0@\u0003\u0015Y\u0017MZ6b\u0013\u0011\t\u0019-!/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019r-\u001a;EK\u001a\fW\u000f\u001c;SK\u0006$G*[7jiR\u0011\u0011\u0011\u001a\t\u0004\u001b\u0006-\u0017bAAg\u001d\nI!+Z1e\u0019&l\u0017\u000e^\u0001\u0018GV\u0014(/\u001a8u!\u0006\u0014H/\u001b;j_:|eMZ:fiN,\"!a5\u0011\r\u0005\r\u0012QLAY\u0003m\u0019WO\u001d:f]R\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$8o\u0018\u0013fcR!\u0011qQAm\u0011%\ty\tIA\u0001\u0002\u0004\t\u0019.\u0001\rdkJ\u0014XM\u001c;QCJ$\u0018\u000e^5p]>3gm]3ug\u0002\na\u0003\\1uKN$\b+\u0019:uSRLwN\\(gMN,Go]\u0001\u001bY\u0006$Xm\u001d;QCJ$\u0018\u000e^5p]>3gm]3ug~#S-\u001d\u000b\u0005\u0003\u000f\u000b\u0019\u000fC\u0005\u0002\u0010\u000e\n\t\u00111\u0001\u0002T\u00069B.\u0019;fgR\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$8\u000fI\u0001\nG>tg/\u001a:uKJ,\"!a;\u0011\u0007-\fi/C\u0002\u0002pf\u0012\u0011dS1gW\u0006\u0014VmY8sIR{'k\\<D_:4XM\u001d;fe\u0006Q1m\u001c8wKJ$XM\u001d\u0011\u0002\rM\u001c\u0007.Z7b+\t\t9\u0010\u0005\u0003\u0002z\u0006}XBAA~\u0015\r\tipO\u0001\u0006if\u0004Xm]\u0005\u0005\u0005\u0003\tYP\u0001\u0006TiJ,8\r\u001e+za\u0016\f\u0011bZ3u\u001f\u001a47/\u001a;\u0016\u0005\t\u001d\u0001CBA\u0012\u0003;\u0012I\u0001E\u0002X\u0005\u0017I1A!\u0004Y\u0005\u0019yeMZ:fi\u0006\u0011\"/\u001a9peRd\u0015\r^3ti>3gm]3u)\t\u0011\u0019\u0002E\u0002N\u0005+I1A!\u0004O\u00031a\u0017\r^3ti>3gm]3u)\u0019\u0011\u0019Ba\u0007\u0003 !9!Q\u0004\u0016A\u0002\tM\u0011aC:uCJ$xJ\u001a4tKRDqA!\t+\u0001\u0004\tI-A\u0003mS6LG/\u0001\u0006eK2\f\u0017PQ1uG\"$\"\"!\t\u0003(\t-\"q\u0006B\u001a\u0011\u001d\u0011Ic\u000ba\u0001\u0003\u001f\n\u0001\"\\5o\u0019&l\u0017\u000e\u001e\u0005\b\u0005[Y\u0003\u0019AAY\u00035a\u0017\r^3ti>3gm]3ug\"9!\u0011G\u0016A\u0002\u0005E\u0016AD2veJ,g\u000e^(gMN,Go\u001d\u0005\b\u0003OZ\u0003\u0019AA(\u0003%\u0011\u0018\r^3MS6LG\u000f\u0006\u0005\u00022\ne\"1\bB \u0011\u001d\u0011\t\u0003\fa\u0001\u0003\u001fBqA!\u0010-\u0001\u0004\t\t,\u0001\u0003ge>l\u0007b\u0002B!Y\u0001\u0007\u0011\u0011W\u0001\u0006k:$\u0018\u000e\\\u0001\tO\u0016$()\u0019;dQR1!q\tB6\u0005_\u0002BA!\u0013\u0003f9!!1\nB1\u001d\u0011\u0011iE!\u0018\u000f\t\t=#1\f\b\u0005\u0005#\u0012IF\u0004\u0003\u0003T\t]cb\u0001=\u0003V%\t!)\u0003\u0002A\u0003&\u0011ahP\u0005\u0003yuJ1Aa\u0018<\u0003\u001d\u0019G.Y:tS\u000eLA!!(\u0003d)\u0019!qL\u001e\n\t\t\u001d$\u0011\u000e\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!!(\u0003d!9!QN\u0017A\u0002\t\u001d\u0011!B:uCJ$\bb\u0002B9[\u0001\u0007!\u0011B\u0001\u0004K:$\u0017\u0001B:u_B$\"!a\"\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!^\u0001\u000fe\u0016\u0004xN\u001d;ECR\fGj\\:t)\u0019\t9Ia \u0003\u0004\"1!\u0011\u0011\u0019A\u0002U\fq!\\3tg\u0006<W\rC\u0004\u0003\u0006B\u0002\rAa\"\u0002\u0019\u001d,G/\u0012=dKB$\u0018n\u001c8\u0011\r\u0005\r\"\u0011\u0012BG\u0013\r\u0011Yi\u001f\u0002\n\rVt7\r^5p]B\u0002BAa$\u0003\u0018:!!\u0011\u0013BK\u001d\rA(1S\u0005\u0002y&\u0019\u0011QT>\n\t\te%1\u0014\u0002\n)\"\u0014xn^1cY\u0016T1!!(|\u0003\u00152XM]5gs\u0016sGm\u00144gg\u0016$hi\u001c:Ue&<w-\u001a:Bm\u0006LG.\u00192mK:{w\u000f\u0006\u0003\u0002\b\n\u0005\u0006b\u0002BRc\u0001\u0007\u0011\u0011W\u0001\u0014K:$\u0007+\u0019:uSRLwN\\(gMN,Go]\u0001\u001eaJ,\u0007/\u0019:f\r>\u0014HK]5hO\u0016\u0014\u0018I^1jY\u0006\u0014G.\u001a(po\u0006Y1*\u00194lCN{WO]2f!\tYGgE\u00025\u0005[\u0003B!a\t\u00030&\u0019!\u0011W>\u0003\r\u0005s\u0017PU3g)\t\u0011I+A\u000bhKR\u001cvN\u001d;fI\u0016CXmY;u_Jd\u0015n\u001d;\u0015\t\te&q\u0018\t\u0006\u0003G\u0011Y,^\u0005\u0004\u0005{[(!B!se\u0006L\bbBA\u001fm\u0001\u0007\u0011\u0011I\u0001\bG>l\u0007/\u0019:f)\u0019\t\tC!2\u0003V\"9!qY\u001cA\u0002\t%\u0017!A1\u0011\t\t-'\u0011[\u0007\u0003\u0005\u001bT1Aa4>\u0003%\u00198\r[3ek2,'/\u0003\u0003\u0003T\n5'!G#yK\u000e,Ho\u001c:DC\u000eDW\rV1tW2{7-\u0019;j_:DqAa68\u0001\u0004\u0011I-A\u0001c\u0001")
public class KafkaSource
implements SupportsTriggerAvailableNow,
Source,
Logging {
    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets;
    private final SQLContext sqlContext;
    private final KafkaOffsetReader kafkaReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final SparkContext sc;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final Option<Object> minOffsetPerTrigger;
    private final long maxTriggerDelayMs;
    private final Clock clock;
    private final boolean includeHeaders;
    private long lastTriggerMillis;
    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow;
    private Option<scala.collection.immutable.Map<TopicPartition, Object>> currentPartitionOffsets;
    private Option<scala.collection.immutable.Map<TopicPartition, Object>> latestPartitionOffsets;
    private final KafkaRecordToRowConverter converter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static String[] getSortedExecutorList(SparkContext sc) {
        return KafkaSource$.MODULE$.getSortedExecutorList(sc);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void commit(org.apache.spark.sql.execution.streaming.Offset end) {
        Source.commit$((Source)this, (org.apache.spark.sql.execution.streaming.Offset)end);
    }

    public Offset initialOffset() {
        return Source.initialOffset$((Source)this);
    }

    public Offset deserializeOffset(String json) {
        return Source.deserializeOffset$((Source)this, (String)json);
    }

    public void commit(Offset end) {
        Source.commit$((Source)this, (Offset)end);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    private Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    public Option<Object> minOffsetPerTrigger() {
        return this.minOffsetPerTrigger;
    }

    public long maxTriggerDelayMs() {
        return this.maxTriggerDelayMs;
    }

    public Clock clock() {
        return this.clock;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private long lastTriggerMillis() {
        return this.lastTriggerMillis;
    }

    private void lastTriggerMillis_$eq(long x$1) {
        this.lastTriggerMillis = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow() {
        return this.allDataForTriggerAvailableNow;
    }

    private void allDataForTriggerAvailableNow_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.allDataForTriggerAvailableNow = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets$lzycompute() {
        KafkaSource kafkaSource = this;
        synchronized (kafkaSource) {
            if (!this.bitmap$0) {
                KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter(this.sqlContext.sparkSession(), this.metadataPath);
                this.initialPartitionOffsets = ((KafkaSourceOffset)metadataLog.get(0L).getOrElse((Function0 & Serializable)() -> {
                    KafkaSourceOffset kafkaSourceOffset;
                    KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
                    if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                        kafkaSourceOffset = new KafkaSourceOffset($this.kafkaReader.fetchEarliestOffsets());
                    } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                        kafkaSourceOffset = new KafkaSourceOffset($this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
                    } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                        SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                        scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                        kafkaSourceOffset = $this.kafkaReader.fetchSpecificOffsets(p, (Function2<String, Function0<Throwable>, BoxedUnit>)(Function2 & Serializable)(message, getException) -> {
                            this.reportDataLoss(message, (Function0<Throwable>)getException);
                            return BoxedUnit.UNIT;
                        });
                    } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                        SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                        scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                        Enumeration.Value strategy = specificTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                        kafkaSourceOffset = $this.kafkaReader.fetchSpecificTimestampBasedOffsets(p, true, strategy);
                    } else if (kafkaOffsetRangeLimit instanceof GlobalTimestampRangeLimit) {
                        GlobalTimestampRangeLimit globalTimestampRangeLimit = (GlobalTimestampRangeLimit)kafkaOffsetRangeLimit;
                        long ts = globalTimestampRangeLimit.timestamp();
                        Enumeration.Value strategy = globalTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                        kafkaSourceOffset = $this.kafkaReader.fetchGlobalTimestampBasedOffsets(ts, true, strategy);
                    } else {
                        throw new MatchError((Object)kafkaOffsetRangeLimit);
                    }
                    KafkaSourceOffset offsets = kafkaSourceOffset;
                    metadataLog.add(0L, offsets);
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Initial offsets: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.OFFSETS$.MODULE$, (Object)offsets)}))));
                    return offsets;
                })).partitionToOffsets();
                this.bitmap$0 = true;
            }
        }
        return this.initialPartitionOffsets;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets() {
        if (!this.bitmap$0) {
            return this.initialPartitionOffsets$lzycompute();
        }
        return this.initialPartitionOffsets;
    }

    public ReadLimit getDefaultReadLimit() {
        if (this.minOffsetPerTrigger().isDefined() && this.maxOffsetsPerTrigger().isDefined()) {
            return ReadLimit.compositeLimit((ReadLimit[])((ReadLimit[])((Object[])new ReadLimit[]{ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()), ReadLimit.maxRows((long)BoxesRunTime.unboxToLong((Object)this.maxOffsetsPerTrigger().get()))})));
        }
        if (this.minOffsetPerTrigger().isDefined()) {
            return ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs());
        }
        return (ReadLimit)this.maxOffsetsPerTrigger().map((Function1 & Serializable)x$1 -> KafkaSource.$anonfun$getDefaultReadLimit$1(BoxesRunTime.unboxToLong((Object)x$1))).getOrElse((Function0 & Serializable)() -> ReadLimit.allAvailable());
    }

    private Option<scala.collection.immutable.Map<TopicPartition, Object>> currentPartitionOffsets() {
        return this.currentPartitionOffsets;
    }

    private void currentPartitionOffsets_$eq(Option<scala.collection.immutable.Map<TopicPartition, Object>> x$1) {
        this.currentPartitionOffsets = x$1;
    }

    private Option<scala.collection.immutable.Map<TopicPartition, Object>> latestPartitionOffsets() {
        return this.latestPartitionOffsets;
    }

    private void latestPartitionOffsets_$eq(Option<scala.collection.immutable.Map<TopicPartition, Object>> x$1) {
        this.latestPartitionOffsets = x$1;
    }

    private KafkaRecordToRowConverter converter() {
        return this.converter;
    }

    public StructType schema() {
        return KafkaRecordToRowConverter$.MODULE$.kafkaSchema(this.includeHeaders());
    }

    public Option<org.apache.spark.sql.execution.streaming.Offset> getOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset reportLatestOffset() {
        return (Offset)this.latestPartitionOffsets().map((Function1 & Serializable)x$4 -> new KafkaSourceOffset((scala.collection.immutable.Map<TopicPartition, Object>)x$4)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Offset latestOffset(Offset startOffset, ReadLimit limit2) {
        scala.collection.immutable.Map map;
        .colon.colon limits;
        this.initialPartitionOffsets();
        Option currentOffsets = this.currentPartitionOffsets().orElse((Function0 & Serializable)() -> new Some(this.initialPartitionOffsets()));
        scala.collection.immutable.Map latest = this.allDataForTriggerAvailableNow() != null ? this.allDataForTriggerAvailableNow() : this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)currentOffsets);
        this.latestPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)(latest.isEmpty() ? None$.MODULE$ : new Some(latest)));
        ReadLimit readLimit = limit2;
        if (readLimit instanceof CompositeReadLimit) {
            CompositeReadLimit compositeReadLimit = (CompositeReadLimit)readLimit;
            v0 = ArrayImplicits$.MODULE$.SparkArrayOps((Object)compositeReadLimit.getReadLimits()).toImmutableArraySeq();
        } else {
            v0 = limits = new .colon.colon((Object)readLimit, (List)Nil$.MODULE$);
        }
        if (limits.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$2(x$5)))) {
            map = latest;
        } else {
            Option lowerLimit = limits.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$3(x$6))).map((Function1 & Serializable)x$7 -> (ReadMinRows)x$7);
            Option upperLimit = limits.find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$5(x$8))).map((Function1 & Serializable)x$9 -> (ReadMaxRows)x$9);
            map = (scala.collection.immutable.Map)lowerLimit.flatMap((Function1 & Serializable)limit -> {
                boolean skipBatch = this.delayBatch(limit.minRows(), (scala.collection.immutable.Map<TopicPartition, Object>)latest, (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)currentOffsets.get()), limit.maxTriggerDelayMs());
                if (skipBatch) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Delaying batch as number of records available is less than minOffsetsPerTrigger");
                    return new Some(currentOffsets.get());
                }
                return None$.MODULE$;
            }).orElse((Function0 & Serializable)() -> upperLimit.map((Function1 & Serializable)limit -> this.rateLimit(limit.maxRows(), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)this.currentPartitionOffsets().getOrElse((Function0 & Serializable)() -> this.initialPartitionOffsets())), (scala.collection.immutable.Map<TopicPartition, Object>)latest))).getOrElse((Function0 & Serializable)() -> latest);
        }
        scala.collection.immutable.Map offsets = map;
        this.currentPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(offsets));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "GetOffset: " + ((SeqOps)offsets.toSeq().map((Function1 & Serializable)x$10 -> x$10.toString())).sorted((Ordering)Ordering.String$.MODULE$));
        return (Offset)Option$.MODULE$.apply((Object)new KafkaSourceOffset(offsets)).filterNot((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$15(x$11))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean delayBatch(long minLimit, scala.collection.immutable.Map<TopicPartition, Object> latestOffsets, scala.collection.immutable.Map<TopicPartition, Object> currentOffsets, long maxTriggerDelayMs) {
        if (this.clock().getTimeMillis() - this.lastTriggerMillis() >= maxTriggerDelayMs) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Maximum wait time is passed, triggering batch");
            this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
            return false;
        }
        double newRecords = BoxesRunTime.unboxToLong((Object)((MapOps)latestOffsets.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition topic = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToLong((long)(offset - BoxesRunTime.unboxToLong((Object)currentOffsets.getOrElse((Object)topic, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))))));
            }
            throw new MatchError((Object)tuple2);
        })).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (newRecords < (double)minLimit) {
            return true;
        }
        this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
        return false;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        LazyRef fromNew$lzy = new LazyRef();
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                long end = tuple2._2$mcJ$sp();
                return from.get((Object)tp).orElse((Function0 & Serializable)() -> this.fromNew$1(fromNew$lzy, until, from).get((Object)tp)).flatMap((Function1 & Serializable)begin -> KafkaSource.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin)));
            }
            throw new MatchError((Object)tuple2);
        });
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (total < 1.0) {
            return until;
        }
        return (scala.collection.immutable.Map)until.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                long end = tuple2._2$mcJ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable)size -> {
                    long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)this.fromNew$1(fromNew$lzy, until, from).apply((Object)tp))));
                    double prorate = (double)limit * ((double)size / total);
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "rateLimit " + tp + " prorated amount is " + prorate);
                    long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                    long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "rateLimit " + tp + " new offset is " + off);
                    return Math.min(end, off);
                }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> end));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Dataset<Row> getBatch(Option<org.apache.spark.sql.execution.streaming.Offset> start, org.apache.spark.sql.execution.streaming.Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> map;
        Option<org.apache.spark.sql.execution.streaming.Offset> option;
        this.initialPartitionOffsets();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"GetBatch called with start = ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FROM_OFFSET$.MODULE$, (Object)start)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"end = ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.UNTIL_OFFSET$.MODULE$, (Object)end)})))));
        scala.collection.immutable.Map<TopicPartition, Object> untilPartitionOffsets = KafkaSourceOffset$.MODULE$.getPartitionOffsets(end);
        if (this.allDataForTriggerAvailableNow() != null) {
            this.verifyEndOffsetForTriggerAvailableNow(untilPartitionOffsets);
        }
        if (this.currentPartitionOffsets().isEmpty()) {
            this.currentPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(untilPartitionOffsets));
        }
        if (start.isDefined()) {
            Object object = start.get();
            org.apache.spark.sql.execution.streaming.Offset offset = end;
            if (!(object != null ? !object.equals(offset) : offset != null)) {
                return ClassicConversions$.MODULE$.castToImpl(this.sqlContext).internalCreateDataFrame(this.sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)).setName("empty"), this.schema(), true);
            }
        }
        if ((option = start) instanceof Some) {
            Some some = (Some)option;
            org.apache.spark.sql.execution.streaming.Offset prevBatchEndOffset = (org.apache.spark.sql.execution.streaming.Offset)some.value();
            map = KafkaSourceOffset$.MODULE$.getPartitionOffsets(prevBatchEndOffset);
        } else if (None$.MODULE$.equals(option)) {
            map = this.initialPartitionOffsets();
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Map<TopicPartition, Object> fromPartitionOffsets = map;
        Seq<KafkaOffsetRange> offsetRanges = this.kafkaReader.getOffsetRangesFromResolvedOffsets(fromPartitionOffsets, untilPartitionOffsets, (Function2<String, Function0<Throwable>, BoxedUnit>)(Function2 & Serializable)(message, getException) -> {
            this.reportDataLoss(message, (Function0<Throwable>)getException);
            return BoxedUnit.UNIT;
        });
        RDD rdd = this.includeHeaders() ? new KafkaSourceRDD(this.sc(), this.executorKafkaParams, offsetRanges, this.pollTimeoutMs(), this.failOnDataLoss).map(this.converter().toInternalRowWithHeaders(), ClassTag$.MODULE$.apply(InternalRow.class)) : new KafkaSourceRDD(this.sc(), this.executorKafkaParams, offsetRanges, this.pollTimeoutMs(), this.failOnDataLoss).map(this.converter().toInternalRowWithoutHeaders(), ClassTag$.MODULE$.apply(InternalRow.class));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"GetBatch generating RDD of offset range: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TOPIC_PARTITIONS$.MODULE$, (Object)((IterableOnceOps)offsetRanges.sortBy((Function1 & Serializable)x$12 -> x$12.topicPartition().toString(), (Ordering)Ordering.String$.MODULE$)).mkString(", "))})))));
        return ClassicConversions$.MODULE$.castToImpl(this.sqlContext).internalCreateDataFrame(rdd.setName("kafka"), this.schema(), true);
    }

    public synchronized void stop() {
        this.kafkaReader.close();
    }

    public String toString() {
        return "KafkaSourceV1[" + this.kafkaReader + "]";
    }

    private void reportDataLoss(String message, Function0<Throwable> getException) {
        if (this.failOnDataLoss) {
            throw (Throwable)getException.apply();
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ". ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ERROR$.MODULE$, (Object)message), new MDC((LogKey)LogKeys.TIP$.MODULE$, (Object)KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE())}))));
    }

    private void verifyEndOffsetForTriggerAvailableNow(scala.collection.immutable.Map<TopicPartition, Object> endPartitionOffsets) {
        scala.collection.immutable.Set tpsForPrefetched = this.allDataForTriggerAvailableNow().keySet();
        scala.collection.immutable.Set tpsForEndOffset = endPartitionOffsets.keySet();
        scala.collection.immutable.Set set = tpsForPrefetched;
        scala.collection.immutable.Set set2 = tpsForEndOffset;
        if (set == null ? set2 != null : !set.equals(set2)) {
            throw KafkaExceptions$.MODULE$.mismatchedTopicPartitionsBetweenEndOffsetAndPrefetched((scala.collection.immutable.Set<TopicPartition>)tpsForPrefetched, (scala.collection.immutable.Set<TopicPartition>)tpsForEndOffset);
        }
        boolean endOffsetHasGreaterThanPrefetched = this.allDataForTriggerAvailableNow().keySet().exists((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$verifyEndOffsetForTriggerAvailableNow$1(this, endPartitionOffsets, tp)));
        if (endOffsetHasGreaterThanPrefetched) {
            throw KafkaExceptions$.MODULE$.endOffsetHasGreaterOffsetForTopicPartitionThanPrefetched(this.allDataForTriggerAvailableNow(), endPartitionOffsets);
        }
        scala.collection.immutable.Map<TopicPartition, Object> latestOffsets = this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(endPartitionOffsets));
        scala.collection.immutable.Set tpsForLatestOffsets = latestOffsets.keySet();
        if (!tpsForEndOffset.subsetOf((Set)tpsForLatestOffsets)) {
            throw KafkaExceptions$.MODULE$.lostTopicPartitionsInEndOffsetWithTriggerAvailableNow((scala.collection.immutable.Set<TopicPartition>)tpsForLatestOffsets, (scala.collection.immutable.Set<TopicPartition>)tpsForEndOffset);
        }
        boolean endOffsetHasGreaterThenLatest = tpsForEndOffset.exists((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$verifyEndOffsetForTriggerAvailableNow$2(latestOffsets, endPartitionOffsets, tp)));
        if (endOffsetHasGreaterThenLatest) {
            throw KafkaExceptions$.MODULE$.endOffsetHasGreaterOffsetForTopicPartitionThanLatestWithTriggerAvailableNow(latestOffsets, endPartitionOffsets);
        }
    }

    public void prepareForTriggerAvailableNow() {
        this.allDataForTriggerAvailableNow_$eq(this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(this.initialPartitionOffsets())));
    }

    public static final /* synthetic */ ReadLimit $anonfun$getDefaultReadLimit$1(long x$1) {
        return ReadLimit.maxRows((long)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$2(ReadLimit x$5) {
        return x$5 instanceof ReadAllAvailable;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$3(ReadLimit x$6) {
        return x$6 instanceof ReadMinRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$5(ReadLimit x$8) {
        return x$8 instanceof ReadMaxRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$15(KafkaSourceOffset x$11) {
        return x$11.partitionToOffsets().isEmpty();
    }

    private final /* synthetic */ scala.collection.immutable.Map fromNew$lzycompute$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = fromNew$lzy$1;
        synchronized (lazyRef) {
            map = fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : (scala.collection.immutable.Map)fromNew$lzy$1.initialize(this.kafkaReader.fetchEarliestOffsets((Seq<TopicPartition>)until$1.keySet().diff((Set)from$1.keySet()).toSeq()));
        }
        return map;
    }

    private final scala.collection.immutable.Map fromNew$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        if (fromNew$lzy$1.initialized()) {
            return (scala.collection.immutable.Map)fromNew$lzy$1.value();
        }
        return this.fromNew$lzycompute$1(fromNew$lzy$1, until$1, from$1);
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaSource $this, long end$1, TopicPartition tp$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "rateLimit " + tp$1 + " size is " + size);
        if (size > 0L) {
            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)BoxesRunTime.boxToLong((long)size)));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$verifyEndOffsetForTriggerAvailableNow$1(KafkaSource $this, scala.collection.immutable.Map endPartitionOffsets$1, TopicPartition tp) {
        long offsetFromPrefetched = BoxesRunTime.unboxToLong((Object)$this.allDataForTriggerAvailableNow().apply((Object)tp));
        long offsetFromEndOffset = BoxesRunTime.unboxToLong((Object)endPartitionOffsets$1.apply((Object)tp));
        return offsetFromEndOffset > offsetFromPrefetched;
    }

    public static final /* synthetic */ boolean $anonfun$verifyEndOffsetForTriggerAvailableNow$2(scala.collection.immutable.Map latestOffsets$1, scala.collection.immutable.Map endPartitionOffsets$1, TopicPartition tp) {
        long offsetFromLatest = BoxesRunTime.unboxToLong((Object)latestOffsets$1.apply((Object)tp));
        long offsetFromEndOffset = BoxesRunTime.unboxToLong((Object)endPartitionOffsets$1.apply((Object)tp));
        return offsetFromEndOffset > offsetFromLatest;
    }

    public KafkaSource(SQLContext sqlContext, KafkaOffsetReader kafkaReader, Map<String, Object> executorKafkaParams, CaseInsensitiveMap<String> sourceOptions, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.sqlContext = sqlContext;
        this.kafkaReader = kafkaReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Source.$init$((Source)this);
        Logging.$init$((Logging)this);
        this.sc = sqlContext.sparkContext();
        this.pollTimeoutMs = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), (Function0 & Serializable)() -> Long.toString(BoxesRunTime.unboxToLong((Object)this.sc().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L))));
        this.maxOffsetsPerTrigger = sourceOptions.get(KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$1))));
        this.minOffsetPerTrigger = sourceOptions.get(KafkaSourceProvider$.MODULE$.MIN_OFFSET_PER_TRIGGER()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$2))));
        this.maxTriggerDelayMs = Utils$.MODULE$.timeStringAsMs((String)sourceOptions.get(KafkaSourceProvider$.MODULE$.MAX_TRIGGER_DELAY()).getOrElse((Function0 & Serializable)() -> KafkaSourceProvider$.MODULE$.DEFAULT_MAX_TRIGGER_DELAY()));
        this.clock = sourceOptions.contains(KafkaSourceProvider$.MODULE$.MOCK_SYSTEM_TIME()) ? new MockedSystemClock() : new SystemClock();
        this.includeHeaders = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), (Function0 & Serializable)() -> "false")));
        this.lastTriggerMillis = 0L;
        this.currentPartitionOffsets = None$.MODULE$;
        this.latestPartitionOffsets = None$.MODULE$;
        this.converter = new KafkaRecordToRowConverter();
    }
}

