/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Locale;
import java.util.UUID;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaConfigUpdater;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.JsonUtils$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$StrategyOnNoMatchStartingOffset$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class KafkaSourceProvider$
implements Logging {
    public static final KafkaSourceProvider$ MODULE$ = new KafkaSourceProvider$();
    private static final String org$apache$spark$sql$kafka010$KafkaSourceProvider$$ASSIGN;
    private static final String org$apache$spark$sql$kafka010$KafkaSourceProvider$$SUBSCRIBE_PATTERN;
    private static final String org$apache$spark$sql$kafka010$KafkaSourceProvider$$SUBSCRIBE;
    private static final Set<String> org$apache$spark$sql$kafka010$KafkaSourceProvider$$STRATEGY_OPTION_KEYS;
    private static final String STARTING_OFFSETS_OPTION_KEY;
    private static final String ENDING_OFFSETS_OPTION_KEY;
    private static final String STARTING_OFFSETS_BY_TIMESTAMP_OPTION_KEY;
    private static final String ENDING_OFFSETS_BY_TIMESTAMP_OPTION_KEY;
    private static final String STARTING_TIMESTAMP_OPTION_KEY;
    private static final String ENDING_TIMESTAMP_OPTION_KEY;
    private static final String org$apache$spark$sql$kafka010$KafkaSourceProvider$$FAIL_ON_DATA_LOSS_OPTION_KEY;
    private static final String MIN_PARTITIONS_OPTION_KEY;
    private static final String MAX_RECORDS_PER_PARTITION_OPTION_KEY;
    private static final String MAX_OFFSET_PER_TRIGGER;
    private static final String MIN_OFFSET_PER_TRIGGER;
    private static final String MAX_TRIGGER_DELAY;
    private static final String DEFAULT_MAX_TRIGGER_DELAY;
    private static final String FETCH_OFFSET_NUM_RETRY;
    private static final String FETCH_OFFSET_RETRY_INTERVAL_MS;
    private static final String CONSUMER_POLL_TIMEOUT;
    private static final String STARTING_OFFSETS_BY_TIMESTAMP_STRATEGY_KEY;
    private static final String org$apache$spark$sql$kafka010$KafkaSourceProvider$$GROUP_ID_PREFIX;
    private static final String INCLUDE_HEADERS;
    private static final String MOCK_SYSTEM_TIME;
    private static final String TOPIC_OPTION_KEY;
    private static final String INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE;
    private static final String CUSTOM_GROUP_ID_ERROR_MESSAGE;
    private static final String serClassName;
    private static final String deserClassName;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        org$apache$spark$sql$kafka010$KafkaSourceProvider$$ASSIGN = "assign";
        org$apache$spark$sql$kafka010$KafkaSourceProvider$$SUBSCRIBE_PATTERN = "subscribepattern";
        org$apache$spark$sql$kafka010$KafkaSourceProvider$$SUBSCRIBE = "subscribe";
        org$apache$spark$sql$kafka010$KafkaSourceProvider$$STRATEGY_OPTION_KEYS = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.org$apache$spark$sql$kafka010$KafkaSourceProvider$$SUBSCRIBE(), MODULE$.org$apache$spark$sql$kafka010$KafkaSourceProvider$$SUBSCRIBE_PATTERN(), MODULE$.org$apache$spark$sql$kafka010$KafkaSourceProvider$$ASSIGN()}));
        STARTING_OFFSETS_OPTION_KEY = "startingoffsets";
        ENDING_OFFSETS_OPTION_KEY = "endingoffsets";
        STARTING_OFFSETS_BY_TIMESTAMP_OPTION_KEY = "startingoffsetsbytimestamp";
        ENDING_OFFSETS_BY_TIMESTAMP_OPTION_KEY = "endingoffsetsbytimestamp";
        STARTING_TIMESTAMP_OPTION_KEY = "startingtimestamp";
        ENDING_TIMESTAMP_OPTION_KEY = "endingtimestamp";
        org$apache$spark$sql$kafka010$KafkaSourceProvider$$FAIL_ON_DATA_LOSS_OPTION_KEY = "failondataloss";
        MIN_PARTITIONS_OPTION_KEY = "minpartitions";
        MAX_RECORDS_PER_PARTITION_OPTION_KEY = "maxrecordsperpartition";
        MAX_OFFSET_PER_TRIGGER = "maxoffsetspertrigger";
        MIN_OFFSET_PER_TRIGGER = "minoffsetspertrigger";
        MAX_TRIGGER_DELAY = "maxtriggerdelay";
        DEFAULT_MAX_TRIGGER_DELAY = "15m";
        FETCH_OFFSET_NUM_RETRY = "fetchoffset.numretries";
        FETCH_OFFSET_RETRY_INTERVAL_MS = "fetchoffset.retryintervalms";
        CONSUMER_POLL_TIMEOUT = "kafkaconsumer.polltimeoutms";
        STARTING_OFFSETS_BY_TIMESTAMP_STRATEGY_KEY = "startingoffsetsbytimestampstrategy";
        org$apache$spark$sql$kafka010$KafkaSourceProvider$$GROUP_ID_PREFIX = "groupidprefix";
        INCLUDE_HEADERS = "includeheaders";
        MOCK_SYSTEM_TIME = "_mockSystemTime";
        TOPIC_OPTION_KEY = "topic";
        INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |Some data may have been lost because they are not available in Kafka any more; either the\n      | data was aged out by Kafka or the topic may have been deleted before all the data in the\n      | topic was processed. If you want your streaming query to fail on such cases, set the source\n      | option \"failOnDataLoss\" to \"true\".\n    "));
        CUSTOM_GROUP_ID_ERROR_MESSAGE = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Kafka option 'kafka.group.id' has been set on this query, it is\n       | not recommended to set this option. This option is unsafe to use since multiple concurrent\n       | queries or sources using the same group id will interfere with each other as they are part\n       | of the same consumer group. Restarted queries may also suffer interference from the\n       | previous run having the same group id. The user should have only one query per group id,\n       | and/or set the option 'kafka.session.timeout.ms' to be very small so that the Kafka\n       | consumers from the previous query are marked dead by the Kafka group coordinator before the\n       | restarted query starts running.\n    "));
        serClassName = ByteArraySerializer.class.getName();
        deserClassName = ByteArrayDeserializer.class.getName();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String org$apache$spark$sql$kafka010$KafkaSourceProvider$$ASSIGN() {
        return org$apache$spark$sql$kafka010$KafkaSourceProvider$$ASSIGN;
    }

    public String org$apache$spark$sql$kafka010$KafkaSourceProvider$$SUBSCRIBE_PATTERN() {
        return org$apache$spark$sql$kafka010$KafkaSourceProvider$$SUBSCRIBE_PATTERN;
    }

    public String org$apache$spark$sql$kafka010$KafkaSourceProvider$$SUBSCRIBE() {
        return org$apache$spark$sql$kafka010$KafkaSourceProvider$$SUBSCRIBE;
    }

    public Set<String> org$apache$spark$sql$kafka010$KafkaSourceProvider$$STRATEGY_OPTION_KEYS() {
        return org$apache$spark$sql$kafka010$KafkaSourceProvider$$STRATEGY_OPTION_KEYS;
    }

    public String STARTING_OFFSETS_OPTION_KEY() {
        return STARTING_OFFSETS_OPTION_KEY;
    }

    public String ENDING_OFFSETS_OPTION_KEY() {
        return ENDING_OFFSETS_OPTION_KEY;
    }

    public String STARTING_OFFSETS_BY_TIMESTAMP_OPTION_KEY() {
        return STARTING_OFFSETS_BY_TIMESTAMP_OPTION_KEY;
    }

    public String ENDING_OFFSETS_BY_TIMESTAMP_OPTION_KEY() {
        return ENDING_OFFSETS_BY_TIMESTAMP_OPTION_KEY;
    }

    public String STARTING_TIMESTAMP_OPTION_KEY() {
        return STARTING_TIMESTAMP_OPTION_KEY;
    }

    public String ENDING_TIMESTAMP_OPTION_KEY() {
        return ENDING_TIMESTAMP_OPTION_KEY;
    }

    public String org$apache$spark$sql$kafka010$KafkaSourceProvider$$FAIL_ON_DATA_LOSS_OPTION_KEY() {
        return org$apache$spark$sql$kafka010$KafkaSourceProvider$$FAIL_ON_DATA_LOSS_OPTION_KEY;
    }

    public String MIN_PARTITIONS_OPTION_KEY() {
        return MIN_PARTITIONS_OPTION_KEY;
    }

    public String MAX_RECORDS_PER_PARTITION_OPTION_KEY() {
        return MAX_RECORDS_PER_PARTITION_OPTION_KEY;
    }

    public String MAX_OFFSET_PER_TRIGGER() {
        return MAX_OFFSET_PER_TRIGGER;
    }

    public String MIN_OFFSET_PER_TRIGGER() {
        return MIN_OFFSET_PER_TRIGGER;
    }

    public String MAX_TRIGGER_DELAY() {
        return MAX_TRIGGER_DELAY;
    }

    public String DEFAULT_MAX_TRIGGER_DELAY() {
        return DEFAULT_MAX_TRIGGER_DELAY;
    }

    public String FETCH_OFFSET_NUM_RETRY() {
        return FETCH_OFFSET_NUM_RETRY;
    }

    public String FETCH_OFFSET_RETRY_INTERVAL_MS() {
        return FETCH_OFFSET_RETRY_INTERVAL_MS;
    }

    public String CONSUMER_POLL_TIMEOUT() {
        return CONSUMER_POLL_TIMEOUT;
    }

    public String STARTING_OFFSETS_BY_TIMESTAMP_STRATEGY_KEY() {
        return STARTING_OFFSETS_BY_TIMESTAMP_STRATEGY_KEY;
    }

    public String org$apache$spark$sql$kafka010$KafkaSourceProvider$$GROUP_ID_PREFIX() {
        return org$apache$spark$sql$kafka010$KafkaSourceProvider$$GROUP_ID_PREFIX;
    }

    public String INCLUDE_HEADERS() {
        return INCLUDE_HEADERS;
    }

    public String MOCK_SYSTEM_TIME() {
        return MOCK_SYSTEM_TIME;
    }

    public String TOPIC_OPTION_KEY() {
        return TOPIC_OPTION_KEY;
    }

    public String INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE() {
        return INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE;
    }

    public String CUSTOM_GROUP_ID_ERROR_MESSAGE() {
        return CUSTOM_GROUP_ID_ERROR_MESSAGE;
    }

    private String serClassName() {
        return serClassName;
    }

    private String deserClassName() {
        return deserClassName;
    }

    public KafkaOffsetRangeLimit getKafkaOffsetRangeLimit(CaseInsensitiveMap<String> params, String globalOffsetTimestampOptionKey, String offsetByTimestampOptionKey, String offsetOptionKey, KafkaOffsetRangeLimit defaultOffsets) {
        Enumeration.Value strategyOnNoMatchStartingOffset = (Enumeration.Value)params.get(this.STARTING_OFFSETS_BY_TIMESTAMP_STRATEGY_KEY()).map((Function1 & Serializable)v -> KafkaSourceProvider$StrategyOnNoMatchStartingOffset$.MODULE$.withName(v.toUpperCase(Locale.ROOT))).getOrElse((Function0 & Serializable)() -> KafkaSourceProvider$StrategyOnNoMatchStartingOffset$.MODULE$.ERROR());
        if (params.contains(globalOffsetTimestampOptionKey)) {
            GlobalTimestampRangeLimit globalTimestampRangeLimit;
            String tsStr = ((String)params.apply((Object)globalOffsetTimestampOptionKey)).trim();
            try {
                long ts = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(tsStr));
                globalTimestampRangeLimit = new GlobalTimestampRangeLimit(ts, strategyOnNoMatchStartingOffset);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Expected a single long value, got " + tsStr);
            }
            return globalTimestampRangeLimit;
        }
        if (params.contains(offsetByTimestampOptionKey)) {
            String json = ((String)params.apply((Object)offsetByTimestampOptionKey)).trim();
            return new SpecificTimestampRangeLimit(JsonUtils$.MODULE$.partitionTimestamps(json), strategyOnNoMatchStartingOffset);
        }
        boolean bl = false;
        Some some = null;
        Option option = params.get(offsetOptionKey).map((Function1 & Serializable)x$10 -> x$10.trim());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String offset = (String)some.value();
            String string = offset.toLowerCase(Locale.ROOT);
            String string2 = "latest";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return LatestOffsetRangeLimit$.MODULE$;
            }
        }
        if (bl) {
            String offset = (String)some.value();
            String string = offset.toLowerCase(Locale.ROOT);
            String string3 = "earliest";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                return EarliestOffsetRangeLimit$.MODULE$;
            }
        }
        if (bl) {
            String json = (String)some.value();
            return new SpecificOffsetRangeLimit(JsonUtils$.MODULE$.partitionOffsets(json));
        }
        if (None$.MODULE$.equals(option)) {
            return defaultOffsets;
        }
        throw new MatchError((Object)option);
    }

    public java.util.Map<String, Object> kafkaParamsForDriver(Map<String, String> specifiedKafkaParams) {
        return new KafkaConfigUpdater("source", specifiedKafkaParams).set("key.deserializer", (Object)this.deserClassName()).set("value.deserializer", (Object)this.deserClassName()).set("auto.offset.reset", (Object)"earliest").set("enable.auto.commit", (Object)"false").set("max.poll.records", (Object)1).setIfUnset("receive.buffer.bytes", (Object)Predef$.MODULE$.int2Integer(65536)).build();
    }

    public java.util.Map<String, Object> kafkaParamsForExecutors(Map<String, String> specifiedKafkaParams, String uniqueGroupId) {
        return new KafkaConfigUpdater("executor", specifiedKafkaParams).set("key.deserializer", (Object)this.deserClassName()).set("value.deserializer", (Object)this.deserClassName()).set("auto.offset.reset", (Object)"none").setIfUnset("group.id", (Object)(uniqueGroupId + "-executor")).set("enable.auto.commit", (Object)"false").setIfUnset("receive.buffer.bytes", (Object)Predef$.MODULE$.int2Integer(65536)).build();
    }

    public String batchUniqueGroupId(CaseInsensitiveMap<String> params) {
        String groupIdPrefix = (String)params.getOrElse((Object)this.org$apache$spark$sql$kafka010$KafkaSourceProvider$$GROUP_ID_PREFIX(), (Function0 & Serializable)() -> "spark-kafka-relation");
        return groupIdPrefix + "-" + UUID.randomUUID();
    }

    public String org$apache$spark$sql$kafka010$KafkaSourceProvider$$streamingUniqueGroupId(CaseInsensitiveMap<String> params, String metadataPath) {
        String groupIdPrefix = (String)params.getOrElse((Object)this.org$apache$spark$sql$kafka010$KafkaSourceProvider$$GROUP_ID_PREFIX(), (Function0 & Serializable)() -> "spark-kafka-source");
        return groupIdPrefix + "-" + UUID.randomUUID() + "-" + metadataPath.hashCode();
    }

    public java.util.Map<String, Object> kafkaParamsForProducer(CaseInsensitiveMap<String> params) {
        if (params.contains("kafka.key.serializer")) {
            throw new IllegalArgumentException("Kafka option 'key.serializer' is not supported as keys are serialized with ByteArraySerializer.");
        }
        if (params.contains("kafka.value.serializer")) {
            throw new IllegalArgumentException("Kafka option 'value.serializer' is not supported as value are serialized with ByteArraySerializer.");
        }
        Map<String, String> specifiedKafkaParams = this.org$apache$spark$sql$kafka010$KafkaSourceProvider$$convertToSpecifiedParams((Map<String, String>)params);
        return new KafkaConfigUpdater("executor", specifiedKafkaParams).set("key.serializer", (Object)this.serClassName()).set("value.serializer", (Object)this.serClassName()).build();
    }

    public Map<String, String> org$apache$spark$sql$kafka010$KafkaSourceProvider$$convertToSpecifiedParams(Map<String, String> parameters) {
        return ((IterableOnceOps)((IterableOps)parameters.keySet().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)KafkaSourceProvider$.$anonfun$convertToSpecifiedParams$1(x$11)))).map((Function1 & Serializable)k -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(k), 6)), parameters.apply(k)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$convertToSpecifiedParams$1(String x$11) {
        return x$11.toLowerCase(Locale.ROOT).startsWith("kafka.");
    }

    private KafkaSourceProvider$() {
    }
}

