/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaWriteTask;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class KafkaWriter$
implements Logging {
    public static final KafkaWriter$ MODULE$ = new KafkaWriter$();
    private static final String TOPIC_ATTRIBUTE_NAME;
    private static final String KEY_ATTRIBUTE_NAME;
    private static final String VALUE_ATTRIBUTE_NAME;
    private static final String HEADERS_ATTRIBUTE_NAME;
    private static final String PARTITION_ATTRIBUTE_NAME;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        TOPIC_ATTRIBUTE_NAME = "topic";
        KEY_ATTRIBUTE_NAME = "key";
        VALUE_ATTRIBUTE_NAME = "value";
        HEADERS_ATTRIBUTE_NAME = "headers";
        PARTITION_ATTRIBUTE_NAME = "partition";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String TOPIC_ATTRIBUTE_NAME() {
        return TOPIC_ATTRIBUTE_NAME;
    }

    public String KEY_ATTRIBUTE_NAME() {
        return KEY_ATTRIBUTE_NAME;
    }

    public String VALUE_ATTRIBUTE_NAME() {
        return VALUE_ATTRIBUTE_NAME;
    }

    public String HEADERS_ATTRIBUTE_NAME() {
        return HEADERS_ATTRIBUTE_NAME;
    }

    public String PARTITION_ATTRIBUTE_NAME() {
        return PARTITION_ATTRIBUTE_NAME;
    }

    public String toString() {
        return "KafkaWriter";
    }

    public void validateQuery(Seq<Attribute> schema, Option<String> topic) {
        try {
            this.topicExpression(schema, topic);
            this.keyExpression(schema);
            this.valueExpression(schema);
            this.headersExpression(schema);
            this.partitionExpression(schema);
        }
        catch (IllegalStateException e) {
            throw new AnalysisException("_LEGACY_ERROR_TEMP_3080", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)e.getMessage())})));
        }
    }

    public Option<String> validateQuery$default$2() {
        return None$.MODULE$;
    }

    public void write(QueryExecution queryExecution, java.util.Map<String, Object> kafkaParameters, Option<String> topic) {
        Seq schema = queryExecution.analyzed().output();
        this.validateQuery((Seq<Attribute>)schema, topic);
        queryExecution.toRdd().foreachPartition((Function1 & Serializable)iter -> {
            KafkaWriter$.$anonfun$write$1(kafkaParameters, schema, topic, iter);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> write$default$3() {
        return None$.MODULE$;
    }

    public Expression topicExpression(Seq<Attribute> schema, Option<String> topic) {
        return (Expression)topic.map((Function1 & Serializable)x$1 -> Literal$.MODULE$.apply(x$1)).getOrElse((Function0 & Serializable)() -> MODULE$.expression(schema, MODULE$.TOPIC_ATTRIBUTE_NAME(), (Seq<DataType>)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$), (Function0<Expression>)(Function0 & Serializable)() -> {
            throw new IllegalStateException("topic option required when no '" + MODULE$.TOPIC_ATTRIBUTE_NAME() + "' attribute is present. Use the " + KafkaSourceProvider$.MODULE$.TOPIC_OPTION_KEY() + " option for setting a topic.");
        }));
    }

    public Option<String> topicExpression$default$2() {
        return None$.MODULE$;
    }

    public Expression keyExpression(Seq<Attribute> schema) {
        return this.expression(schema, this.KEY_ATTRIBUTE_NAME(), (Seq<DataType>)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$)), (Function0<Expression>)(Function0 & Serializable)() -> new Literal(null, (DataType)BinaryType$.MODULE$));
    }

    public Expression valueExpression(Seq<Attribute> schema) {
        return this.expression(schema, this.VALUE_ATTRIBUTE_NAME(), (Seq<DataType>)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$)), (Function0<Expression>)(Function0 & Serializable)() -> {
            throw new IllegalStateException("Required attribute '" + MODULE$.VALUE_ATTRIBUTE_NAME() + "' not found");
        });
    }

    public Expression headersExpression(Seq<Attribute> schema) {
        return this.expression(schema, this.HEADERS_ATTRIBUTE_NAME(), (Seq<DataType>)new .colon.colon((Object)KafkaRecordToRowConverter$.MODULE$.headersType(), (List)Nil$.MODULE$), (Function0<Expression>)(Function0 & Serializable)() -> new Literal(CatalystTypeConverters$.MODULE$.convertToCatalyst(null), (DataType)KafkaRecordToRowConverter$.MODULE$.headersType()));
    }

    public Expression partitionExpression(Seq<Attribute> schema) {
        return this.expression(schema, this.PARTITION_ATTRIBUTE_NAME(), (Seq<DataType>)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$), (Function0<Expression>)(Function0 & Serializable)() -> new Literal(null, (DataType)IntegerType$.MODULE$));
    }

    private Expression expression(Seq<Attribute> schema, String attrName, Seq<DataType> desired, Function0<Expression> function0) {
        Expression expr = (Expression)schema.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KafkaWriter$.$anonfun$expression$1(attrName, x$2))).getOrElse(function0);
        if (!desired.exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType(e, expr.dataType())))) {
            throw new IllegalStateException(attrName + " attribute unsupported type " + expr.dataType().catalogString() + ". " + attrName + " must be a(n) " + ((IterableOnceOps)desired.map((Function1 & Serializable)x$3 -> x$3.catalogString())).mkString(" or "));
        }
        return expr;
    }

    public static final /* synthetic */ void $anonfun$write$1(java.util.Map kafkaParameters$1, Seq schema$1, Option topic$1, Iterator iter) {
        KafkaWriteTask writeTask = new KafkaWriteTask(kafkaParameters$1, (Seq<Attribute>)schema$1, (Option<String>)topic$1);
        Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable)() -> writeTask.execute((Iterator<InternalRow>)iter), (Function0)(JFunction0.mcV.sp & Serializable)() -> writeTask.close());
    }

    public static final /* synthetic */ boolean $anonfun$expression$1(String attrName$1, Attribute x$2) {
        String string = x$2.name();
        String string2 = attrName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private KafkaWriter$() {
    }
}

