/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.Logging;
import java.math.BigInteger;
import java.util.Map;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.HiveTypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.types.ArrayType;
import org.apache.spark.sql.catalyst.types.BooleanType$;
import org.apache.spark.sql.catalyst.types.DataType;
import org.apache.spark.sql.catalyst.types.DecimalType$;
import org.apache.spark.sql.catalyst.types.DoubleType$;
import org.apache.spark.sql.catalyst.types.IntegerType$;
import org.apache.spark.sql.catalyst.types.LongType$;
import org.apache.spark.sql.catalyst.types.NullType$;
import org.apache.spark.sql.catalyst.types.StringType$;
import org.apache.spark.sql.catalyst.types.StructField;
import org.apache.spark.sql.catalyst.types.StructType;
import org.apache.spark.sql.execution.ExistingRdd;
import org.apache.spark.sql.execution.SparkLogicalPlan;
import org.apache.spark.sql.json.JsonRDD$;
import org.apache.spark.sql.json.JsonRDD$$anonfun$org$apache$spark$sql$json$JsonRDD$$asRow$1$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;

public final class JsonRDD$
implements Logging {
    public static final JsonRDD$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new JsonRDD$();
    }

    private Logger logger$lzycompute() {
        JsonRDD$ jsonRDD$ = this;
        synchronized (jsonRDD$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public LogicalPlan inferSchema(RDD<String> json, double samplingRatio) {
        Predef$.MODULE$.require(samplingRatio > 0.0, (Function0)new Serializable(samplingRatio){
            public static final long serialVersionUID = 0L;
            private final double samplingRatio$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"samplingRatio (", ") should be greater than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.samplingRatio$1)}));
            }
            {
                this.samplingRatio$1 = samplingRatio$1;
            }
        });
        RDD schemaData = samplingRatio > 0.99 ? json : json.sample(false, samplingRatio, 1L);
        Set allKeys = (Set)this.parseJson((RDD<String>)schemaData).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<Tuple2<String, DataType>> apply(scala.collection.immutable.Map<String, Object> m) {
                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes(m);
            }
        }, ClassTag$.MODULE$.apply(Set.class)).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<Tuple2<String, DataType>> apply(Set<Tuple2<String, DataType>> x$1, Set<Tuple2<String, DataType>> x$2) {
                return (Set)x$1.$plus$plus(x$2);
            }
        });
        StructType baseSchema = this.createSchema((Set<Tuple2<String, DataType>>)allKeys);
        return this.createLogicalPlan((RDD<String>)json, baseSchema);
    }

    public double inferSchema$default$2() {
        return 1.0;
    }

    private LogicalPlan createLogicalPlan(RDD<String> json, StructType baseSchema) {
        StructType schema = this.org$apache$spark$sql$json$JsonRDD$$nullTypeToStringType(baseSchema);
        return new SparkLogicalPlan(new ExistingRdd(this.asAttributes(schema), (RDD<Row>)this.parseJson(json).map((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final Row apply(scala.collection.immutable.Map<String, Object> x$3) {
                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$asRow(x$3, this.schema$1);
            }
            {
                this.schema$1 = schema$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class))));
    }

    private StructType createSchema(Set<Tuple2<String, DataType>> allKeys) {
        scala.collection.immutable.Map resolved = (scala.collection.immutable.Map)allKeys.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, DataType> x0$1) {
                Tuple2<String, DataType> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key;
                    String string = key = (String)tuple2._1();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Seq<String>, DataType> apply(Tuple2<String, Set<Tuple2<String, DataType>>> x0$2) {
                Tuple2<String, Set<Tuple2<String, DataType>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Set typeSet = (Set)tuple2._2();
                    Seq fieldName = Predef$.MODULE$.refArrayOps((Object[])key.substring(1, key.length() - 1).split("`.`")).toSeq();
                    DataType dataType = (DataType)((TraversableOnce)typeSet.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DataType apply(Tuple2<String, DataType> x0$3) {
                            Tuple2<String, DataType> tuple2 = x0$3;
                            if (tuple2 != null) {
                                DataType dataType;
                                DataType dataType2 = dataType = (DataType)tuple2._2();
                                return dataType2;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Set$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DataType apply(DataType type1, DataType type2) {
                            return JsonRDD$.MODULE$.compatibleType(type1, type2);
                        }
                    });
                    Tuple2 tuple22 = new Tuple2((Object)fieldName, (Object)dataType);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        return this.org$apache$spark$sql$json$JsonRDD$$makeStruct$1(resolved.keySet().toSeq(), (Seq)Nil$.MODULE$, resolved);
    }

    public DataType compatibleType(DataType t1, DataType t2) {
        Tuple2 tuple2;
        block9: {
            DataType dataType;
            block3: {
                StringType$ stringType$;
                block5: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    block2: {
                                        Option applicableConversion = HiveTypeCoercion$.MODULE$.allPromotions().find((Function1)new Serializable(t1, t2){
                                            public static final long serialVersionUID = 0L;
                                            private final DataType t1$1;
                                            private final DataType t2$1;

                                            public final boolean apply(Seq<DataType> p) {
                                                return p.contains((Object)this.t1$1) && p.contains((Object)this.t2$1);
                                            }
                                            {
                                                this.t1$1 = t1$1;
                                                this.t2$1 = t2$1;
                                            }
                                        });
                                        Option returnType = applicableConversion.map((Function1)new Serializable(t1, t2){
                                            public static final long serialVersionUID = 0L;
                                            public final DataType t1$1;
                                            public final DataType t2$1;

                                            public final DataType apply(Seq<DataType> x$8) {
                                                return (DataType)((TraversableLike)x$8.filter((Function1)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ anonfun.15 $outer;

                                                    /*
                                                     * Enabled force condition propagation
                                                     * Lifted jumps to return sites
                                                     */
                                                    public final boolean apply(DataType t) {
                                                        DataType dataType = t;
                                                        DataType dataType2 = this.$outer.t1$1;
                                                        if (dataType == null) {
                                                            if (dataType2 == null) return true;
                                                        } else if (dataType.equals(dataType2)) return true;
                                                        DataType dataType3 = t;
                                                        DataType dataType4 = this.$outer.t2$1;
                                                        if (dataType3 != null) {
                                                            if (!dataType3.equals(dataType4)) return false;
                                                            return true;
                                                        }
                                                        if (dataType4 == null) return true;
                                                        return false;
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                })).last();
                                            }
                                            {
                                                this.t1$1 = t1$1;
                                                this.t2$1 = t2$1;
                                            }
                                        });
                                        if (!returnType.isDefined()) break block2;
                                        dataType = (DataType)returnType.get();
                                        break block3;
                                    }
                                    tuple2 = new Tuple2((Object)t1, (Object)t2);
                                    if (tuple2 == null) break block4;
                                    DataType other = (DataType)tuple2._1();
                                    DataType dataType2 = (DataType)tuple2._2();
                                    if (other == null) break block4;
                                    DataType dataType3 = other;
                                    NullType$ nullType$ = NullType$.MODULE$;
                                    DataType dataType4 = dataType2;
                                    if (nullType$ != null ? !nullType$.equals(dataType4) : dataType4 != null) break block4;
                                    stringType$ = dataType3;
                                    break block5;
                                }
                                if (tuple2 == null) break block6;
                                DataType dataType5 = (DataType)tuple2._1();
                                DataType other = (DataType)tuple2._2();
                                NullType$ nullType$ = NullType$.MODULE$;
                                DataType dataType6 = dataType5;
                                if ((nullType$ != null ? !nullType$.equals(dataType6) : dataType6 != null) || other == null) break block6;
                                DataType dataType7 = other;
                                stringType$ = dataType7;
                                break block5;
                            }
                            if (tuple2 == null) break block7;
                            DataType dataType8 = (DataType)tuple2._1();
                            DataType dataType9 = (DataType)tuple2._2();
                            if (!(dataType8 instanceof StructType)) break block7;
                            StructType structType = (StructType)dataType8;
                            Seq fields1 = structType.fields();
                            if (!(dataType9 instanceof StructType)) break block7;
                            StructType structType2 = (StructType)dataType9;
                            Seq fields2 = structType2.fields();
                            scala.collection.immutable.Iterable newFields = (scala.collection.immutable.Iterable)((TraversableLike)fields1.$plus$plus((GenTraversableOnce)fields2, Seq$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(StructField field) {
                                    return field.name();
                                }
                            }).map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final StructField apply(Tuple2<String, Seq<StructField>> x0$6) {
                                    Tuple2<String, Seq<StructField>> tuple2 = x0$6;
                                    if (tuple2 != null) {
                                        String name = (String)tuple2._1();
                                        Seq fieldTypes = (Seq)tuple2._2();
                                        DataType dataType = (DataType)((TraversableOnce)fieldTypes.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final DataType apply(StructField field) {
                                                return field.dataType();
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final DataType apply(DataType type1, DataType type2) {
                                                return JsonRDD$.MODULE$.compatibleType(type1, type2);
                                            }
                                        });
                                        StructField structField = new StructField(name, dataType, true);
                                        return structField;
                                    }
                                    throw new MatchError(tuple2);
                                }
                            }, Iterable$.MODULE$.canBuildFrom());
                            stringType$ = new StructType((Seq)newFields.toSeq().sortBy((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(StructField x0$7) {
                                    StructField structField = x0$7;
                                    if (structField != null) {
                                        String name;
                                        String string = name = structField.name();
                                        return string;
                                    }
                                    throw new MatchError((Object)structField);
                                }
                            }, (Ordering)Ordering.String$.MODULE$));
                            break block5;
                        }
                        if (tuple2 == null) break block8;
                        DataType dataType10 = (DataType)tuple2._1();
                        DataType dataType11 = (DataType)tuple2._2();
                        if (!(dataType10 instanceof ArrayType)) break block8;
                        ArrayType arrayType = (ArrayType)dataType10;
                        DataType elementType1 = arrayType.elementType();
                        if (!(dataType11 instanceof ArrayType)) break block8;
                        ArrayType arrayType2 = (ArrayType)dataType11;
                        DataType elementType2 = arrayType2.elementType();
                        stringType$ = new ArrayType(this.compatibleType(elementType1, elementType2));
                        break block5;
                    }
                    if (tuple2 == null) break block9;
                    stringType$ = StringType$.MODULE$;
                }
                dataType = stringType$;
            }
            return dataType;
        }
        throw new MatchError((Object)tuple2);
    }

    public DataType org$apache$spark$sql$json$JsonRDD$$typeOfPrimitiveValue(Object value) {
        Object object = value;
        Object object2 = object instanceof String ? StringType$.MODULE$ : (object instanceof Integer ? IntegerType$.MODULE$ : (object instanceof Long ? LongType$.MODULE$ : (object instanceof BigInteger ? DecimalType$.MODULE$ : (object instanceof Double ? DoubleType$.MODULE$ : (object instanceof java.math.BigDecimal ? DecimalType$.MODULE$ : (object instanceof Boolean ? BooleanType$.MODULE$ : (object == null ? NullType$.MODULE$ : StringType$.MODULE$)))))));
        return object2;
    }

    public ArrayType org$apache$spark$sql$json$JsonRDD$$typeOfArray(Seq<Object> l) {
        ArrayType arrayType;
        Seq elements = (Seq)l.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(Object v) {
                return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(v));
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (elements.isEmpty()) {
            arrayType = new ArrayType((DataType)NullType$.MODULE$);
        } else {
            DataType elementType = (DataType)((TraversableOnce)elements.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final DataType apply(Object e) {
                    StructType structType;
                    Object object = e;
                    if (object instanceof scala.collection.immutable.Map) {
                        structType = new StructType((Seq)Nil$.MODULE$);
                    } else if (object instanceof Seq) {
                        Seq seq = (Seq)object;
                        structType = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfArray((Seq<Object>)seq);
                    } else {
                        structType = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfPrimitiveValue(object);
                    }
                    return structType;
                }
            }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final DataType apply(DataType type1, DataType type2) {
                    return JsonRDD$.MODULE$.compatibleType(type1, type2);
                }
            });
            arrayType = new ArrayType(elementType);
        }
        return arrayType;
    }

    public Set<Tuple2<String, DataType>> org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes(scala.collection.immutable.Map<String, Object> m) {
        return ((TraversableOnce)((TraversableLike)m.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$8) {
                Tuple2<String, Object> tuple2 = x0$8;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object dataType = tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), dataType);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Iterable<Tuple2<String, DataType>> apply(Tuple2<String, Object> x0$9) {
                Tuple2<String, Object> tuple2;
                block8: {
                    List list;
                    block3: {
                        block4: {
                            ArrayType arrayType;
                            block7: {
                                List list2;
                                block6: {
                                    String string;
                                    block5: {
                                        DataType dataType;
                                        block2: {
                                            tuple2 = x0$9;
                                            if (tuple2 == null) break block2;
                                            String key = (String)tuple2._1();
                                            Object struct = tuple2._2();
                                            if (key == null) break block2;
                                            String string2 = key;
                                            if (!(struct instanceof scala.collection.immutable.Map)) break block2;
                                            scala.collection.immutable.Map map = (scala.collection.immutable.Map)struct;
                                            list = (scala.collection.immutable.Iterable)((SetLike)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes((scala.collection.immutable.Map<String, Object>)map).map((Function1)new Serializable(this, string2){
                                                public static final long serialVersionUID = 0L;
                                                private final String x2$1;

                                                public final Tuple2<String, DataType> apply(Tuple2<String, DataType> x0$10) {
                                                    Tuple2<String, DataType> tuple2 = x0$10;
                                                    if (tuple2 != null) {
                                                        String k = (String)tuple2._1();
                                                        DataType dataType = (DataType)tuple2._2();
                                                        Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$1, k})), (Object)dataType);
                                                        return tuple22;
                                                    }
                                                    throw new MatchError(tuple2);
                                                }
                                                {
                                                    this.x2$1 = x2$1;
                                                }
                                            }, Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)string2, (Object)new StructType((Seq)Nil$.MODULE$))})));
                                            break block3;
                                        }
                                        if (tuple2 == null) break block4;
                                        String key = (String)tuple2._1();
                                        Object array = tuple2._2();
                                        if (key == null) break block4;
                                        string = key;
                                        if (!(array instanceof List)) break block4;
                                        List list3 = (List)array;
                                        arrayType = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfArray((Seq<Object>)list3);
                                        if (arrayType == null || !((dataType = arrayType.elementType()) instanceof StructType)) break block5;
                                        StructType structType = (StructType)dataType;
                                        Seq seq = structType.fields();
                                        Nil$ nil$ = Nil$.MODULE$;
                                        Seq seq2 = seq;
                                        if (nil$ != null ? !nil$.equals(seq2) : seq2 != null) break block5;
                                        list2 = (List)((SeqLike)((TraversableLike)list3.flatMap((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Set<Tuple2<String, DataType>> apply(scala.collection.immutable.Map<String, Object> element) {
                                                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes(element);
                                            }
                                        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, string){
                                            public static final long serialVersionUID = 0L;
                                            private final String x4$1;

                                            public final Tuple2<String, DataType> apply(Tuple2<String, DataType> x0$11) {
                                                Tuple2<String, DataType> tuple2 = x0$11;
                                                if (tuple2 != null) {
                                                    String k = (String)tuple2._1();
                                                    DataType dataType = (DataType)tuple2._2();
                                                    Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x4$1, k})), (Object)dataType);
                                                    return tuple22;
                                                }
                                                throw new MatchError(tuple2);
                                            }
                                            {
                                                this.x4$1 = x4$1;
                                            }
                                        }, List$.MODULE$.canBuildFrom())).$colon$plus((Object)new Tuple2((Object)string, (Object)new ArrayType((DataType)new StructType((Seq)Nil$.MODULE$))), List$.MODULE$.canBuildFrom());
                                        break block6;
                                    }
                                    if (arrayType == null) break block7;
                                    DataType elementType = arrayType.elementType();
                                    Tuple2 tuple22 = new Tuple2((Object)string, (Object)new ArrayType(elementType));
                                    list2 = Nil$.MODULE$.$colon$colon((Object)tuple22);
                                }
                                list = list2;
                                break block3;
                            }
                            throw new MatchError((Object)arrayType);
                        }
                        if (tuple2 == null) break block8;
                        String key = (String)tuple2._1();
                        Object value = tuple2._2();
                        if (key == null) break block8;
                        String string = key;
                        Tuple2 tuple23 = new Tuple2((Object)string, (Object)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfPrimitiveValue(value));
                        list = Nil$.MODULE$.$colon$colon((Object)tuple23);
                    }
                    return list;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).toSet();
    }

    public Object org$apache$spark$sql$json$JsonRDD$$scalafy(Object obj) {
        Object object;
        Object object2 = obj;
        if (object2 instanceof Map) {
            Map map = (Map)object2;
            object = JavaConversions$.MODULE$.mapAsScalaMap(map).toMap(Predef$.MODULE$.conforms()).mapValues((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object obj) {
                    return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(obj);
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(Tuple2<String, Object> x) {
                    return (Tuple2)Predef$.MODULE$.identity(x);
                }
            }, Map$.MODULE$.canBuildFrom());
        } else if (object2 instanceof java.util.List) {
            java.util.List list = (java.util.List)object2;
            object = JavaConversions$.MODULE$.asScalaBuffer(list).toList().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object obj) {
                    return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(obj);
                }
            }, List$.MODULE$.canBuildFrom());
        } else {
            object = object2;
        }
        return object;
    }

    private RDD<scala.collection.immutable.Map<String, Object>> parseJson(RDD<String> json) {
        return json.mapPartitions((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Map<String, Object>> apply(Iterator<String> iter) {
                ObjectMapper mapper = new ObjectMapper();
                return iter.map((Function1)new Serializable(this, mapper){
                    public static final long serialVersionUID = 0L;
                    private final ObjectMapper mapper$1;

                    public final Map<String, Object> apply(String record) {
                        return (Map)this.mapper$1.readValue(record, Map.class);
                    }
                    {
                        this.mapper$1 = mapper$1;
                    }
                });
            }
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Map.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object obj) {
                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(obj);
            }
        }, ClassTag$.MODULE$.Any()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Object> apply(Object x$11) {
                return (scala.collection.immutable.Map)x$11;
            }
        }, ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class));
    }

    private long toLong(Object value) {
        Object object;
        block4: {
            long l;
            block3: {
                block2: {
                    object = value;
                    if (!(object instanceof Integer)) break block2;
                    Integer n = (Integer)object;
                    l = BoxesRunTime.unboxToInt((Object)n);
                    break block3;
                }
                if (!(object instanceof Long)) break block4;
                Long l2 = (Long)object;
                l = BoxesRunTime.unboxToLong((Object)l2);
            }
            return l;
        }
        throw new MatchError(object);
    }

    private double toDouble(Object value) {
        Object object;
        block5: {
            double d;
            block3: {
                block4: {
                    block2: {
                        object = value;
                        if (!(object instanceof Integer)) break block2;
                        Integer n = (Integer)object;
                        d = BoxesRunTime.unboxToInt((Object)n);
                        break block3;
                    }
                    if (!(object instanceof Long)) break block4;
                    Long l = (Long)object;
                    d = BoxesRunTime.unboxToLong((Object)l);
                    break block3;
                }
                if (!(object instanceof Double)) break block5;
                Double d2 = (Double)object;
                d = BoxesRunTime.unboxToDouble((Object)d2);
            }
            return d;
        }
        throw new MatchError(object);
    }

    private BigDecimal toDecimal(Object value) {
        Object object;
        block7: {
            BigDecimal bigDecimal;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                object = value;
                                if (!(object instanceof Integer)) break block2;
                                Integer n = (Integer)object;
                                bigDecimal = BigDecimal$.MODULE$.apply(Predef$.MODULE$.Integer2int(n));
                                break block3;
                            }
                            if (!(object instanceof Long)) break block4;
                            Long l = (Long)object;
                            bigDecimal = BigDecimal$.MODULE$.apply(Predef$.MODULE$.Long2long(l));
                            break block3;
                        }
                        if (!(object instanceof BigInteger)) break block5;
                        BigInteger bigInteger = (BigInteger)object;
                        bigDecimal = BigDecimal$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(bigInteger));
                        break block3;
                    }
                    if (!(object instanceof Double)) break block6;
                    Double d = (Double)object;
                    bigDecimal = BigDecimal$.MODULE$.apply(Predef$.MODULE$.Double2double(d));
                    break block3;
                }
                if (!(object instanceof java.math.BigDecimal)) break block7;
                java.math.BigDecimal bigDecimal2 = (java.math.BigDecimal)object;
                bigDecimal = BigDecimal$.MODULE$.apply(bigDecimal2);
            }
            return bigDecimal;
        }
        throw new MatchError(object);
    }

    private String toJsonArrayString(Seq<Object> seq) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        IntRef count = new IntRef(0);
        seq.foreach((Function1)new Serializable(builder, count){
            public static final long serialVersionUID = 0L;
            private final StringBuilder builder$1;
            private final IntRef count$1;

            public final StringBuilder apply(Object element) {
                Object object = this.count$1.elem > 0 ? this.builder$1.append(",") : BoxedUnit.UNIT;
                ++this.count$1.elem;
                return this.builder$1.append(JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$toString(element));
            }
            {
                this.builder$1 = builder$1;
                this.count$1 = count$1;
            }
        });
        builder.append("]");
        return builder.toString();
    }

    private String toJsonObjectString(scala.collection.immutable.Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        IntRef count = new IntRef(0);
        map.foreach((Function1)new Serializable(builder, count){
            public static final long serialVersionUID = 0L;
            private final StringBuilder builder$2;
            private final IntRef count$2;

            public final StringBuilder apply(Tuple2<String, Object> x0$12) {
                Tuple2<String, Object> tuple2 = x0$12;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    Object object = this.count$2.elem > 0 ? this.builder$2.append(",") : BoxedUnit.UNIT;
                    ++this.count$2.elem;
                    StringBuilder stringBuilder = this.builder$2.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\"", "\\\":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$toString(value)})));
                    return stringBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$2 = builder$2;
                this.count$2 = count$2;
            }
        });
        builder.append("}");
        return builder.toString();
    }

    public String org$apache$spark$sql$json$JsonRDD$$toString(Object value) {
        String string;
        Object object = value;
        if (object instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
            string = this.toJsonObjectString((scala.collection.immutable.Map<String, Object>)map);
        } else if (object instanceof Seq) {
            Seq seq = (Seq)object;
            string = this.toJsonArrayString((Seq<Object>)seq);
        } else {
            string = (String)Option$.MODULE$.apply(object).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Object x$12) {
                    return x$12.toString();
                }
            }).orNull(Predef$.MODULE$.conforms());
        }
        return string;
    }

    public Object enforceCorrectType(Object value, DataType desiredType) {
        DataType dataType;
        block12: {
            String string;
            block3: {
                Object object;
                block5: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block4: {
                                                block2: {
                                                    if (value != null) break block2;
                                                    string = null;
                                                    break block3;
                                                }
                                                dataType = desiredType;
                                                if (!(dataType instanceof ArrayType)) break block4;
                                                ArrayType arrayType = (ArrayType)dataType;
                                                DataType elementType = arrayType.elementType();
                                                object = ((Seq)value).map((Function1)new Serializable(elementType){
                                                    public static final long serialVersionUID = 0L;
                                                    private final DataType elementType$1;

                                                    public final Object apply(Object x$13) {
                                                        return JsonRDD$.MODULE$.enforceCorrectType(x$13, this.elementType$1);
                                                    }
                                                    {
                                                        this.elementType$1 = elementType$1;
                                                    }
                                                }, Seq$.MODULE$.canBuildFrom());
                                                break block5;
                                            }
                                            StringType$ stringType$ = StringType$.MODULE$;
                                            DataType dataType2 = dataType;
                                            if (stringType$ != null ? !stringType$.equals(dataType2) : dataType2 != null) break block6;
                                            object = this.org$apache$spark$sql$json$JsonRDD$$toString(value);
                                            break block5;
                                        }
                                        IntegerType$ integerType$ = IntegerType$.MODULE$;
                                        DataType dataType3 = dataType;
                                        if (integerType$ != null ? !integerType$.equals(dataType3) : dataType3 != null) break block7;
                                        object = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)value));
                                        break block5;
                                    }
                                    LongType$ longType$ = LongType$.MODULE$;
                                    DataType dataType4 = dataType;
                                    if (longType$ != null ? !longType$.equals(dataType4) : dataType4 != null) break block8;
                                    object = BoxesRunTime.boxToLong((long)this.toLong(value));
                                    break block5;
                                }
                                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                DataType dataType5 = dataType;
                                if (doubleType$ != null ? !doubleType$.equals(dataType5) : dataType5 != null) break block9;
                                object = BoxesRunTime.boxToDouble((double)this.toDouble(value));
                                break block5;
                            }
                            DecimalType$ decimalType$ = DecimalType$.MODULE$;
                            DataType dataType6 = dataType;
                            if (decimalType$ != null ? !decimalType$.equals(dataType6) : dataType6 != null) break block10;
                            object = this.toDecimal(value);
                            break block5;
                        }
                        BooleanType$ booleanType$ = BooleanType$.MODULE$;
                        DataType dataType7 = dataType;
                        if (booleanType$ != null ? !booleanType$.equals(dataType7) : dataType7 != null) break block11;
                        object = BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)value));
                        break block5;
                    }
                    NullType$ nullType$ = NullType$.MODULE$;
                    DataType dataType8 = dataType;
                    if (nullType$ != null ? !nullType$.equals(dataType8) : dataType8 != null) break block12;
                    object = null;
                }
                string = object;
            }
            return string;
        }
        throw new MatchError((Object)dataType);
    }

    /*
     * WARNING - void declaration
     */
    public Row org$apache$spark$sql$json$JsonRDD$$asRow(scala.collection.immutable.Map<String, Object> json, StructType schema) {
        void var3_3;
        GenericMutableRow row = new GenericMutableRow(schema.fields().length());
        ((IterableLike)schema.fields().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(json, row){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map json$1;
            private final GenericMutableRow row$1;

            public final void apply(Tuple2<StructField, Object> x0$13) {
                Tuple2<StructField, Object> tuple2;
                block5: {
                    block3: {
                        block4: {
                            ArrayType arrayType;
                            DataType structType;
                            block2: {
                                tuple2 = x0$13;
                                if (tuple2 == null) break block2;
                                StructField structField = (StructField)tuple2._1();
                                int i = tuple2._2$mcI$sp();
                                if (structField == null) break block2;
                                String name = structField.name();
                                DataType fields = structField.dataType();
                                if (!(fields instanceof StructType)) break block2;
                                StructType structType2 = (StructType)fields;
                                this.row$1.update(i, this.json$1.get((Object)name).flatMap((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<Object> apply(Object v) {
                                        return Option$.MODULE$.apply(v);
                                    }
                                }).map((Function1)new Serializable(this, structType2){
                                    public static final long serialVersionUID = 0L;
                                    private final StructType x10$1;

                                    public final Row apply(Object v) {
                                        return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$asRow((scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)v), this.x10$1);
                                    }
                                    {
                                        this.x10$1 = x10$1;
                                    }
                                }).orNull(Predef$.MODULE$.conforms()));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (tuple2 == null) break block4;
                            StructField structField = (StructField)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            if (structField == null) break block4;
                            String name = structField.name();
                            DataType dataType = structField.dataType();
                            if (!(dataType instanceof ArrayType) || !((structType = (arrayType = (ArrayType)dataType).elementType()) instanceof StructType)) break block4;
                            StructType structType3 = (StructType)structType;
                            this.row$1.update(i, this.json$1.get((Object)name).flatMap((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Option<Object> apply(Object v) {
                                    return Option$.MODULE$.apply(v);
                                }
                            }).map((Function1)new Serializable(this, structType3){
                                public static final long serialVersionUID = 0L;
                                public final StructType x11$1;

                                public final Seq<Row> apply(Object v) {
                                    return (Seq)((Seq)v).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$org$apache$spark$sql$json$JsonRDD$$asRow$1$$anonfun$apply$9 $outer;

                                        public final Row apply(Object e) {
                                            return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$asRow((scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)e), this.$outer.x11$1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom());
                                }
                                {
                                    this.x11$1 = x11$1;
                                }
                            }).orNull(Predef$.MODULE$.conforms()));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (tuple2 == null) break block5;
                        StructField structField = (StructField)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        if (structField == null) break block5;
                        String name = structField.name();
                        DataType dataType = structField.dataType();
                        this.row$1.update(i, this.json$1.get((Object)name).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Option<Object> apply(Object v) {
                                return Option$.MODULE$.apply(v);
                            }
                        }).map((Function1)new Serializable(this, dataType){
                            public static final long serialVersionUID = 0L;
                            private final DataType dataType$1;

                            public final Object apply(Object x$14) {
                                return JsonRDD$.MODULE$.enforceCorrectType(x$14, this.dataType$1);
                            }
                            {
                                this.dataType$1 = dataType$1;
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Null$ apply() {
                                return null;
                            }
                        }));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.json$1 = json$1;
                this.row$1 = row$1;
            }
        });
        return var3_3;
    }

    public StructType org$apache$spark$sql$json$JsonRDD$$nullTypeToStringType(StructType struct) {
        Seq fields = (Seq)struct.fields().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(StructField x0$14) {
                StructField structField;
                block2: {
                    DataType dataType;
                    block7: {
                        StringType$ stringType$;
                        boolean nullable;
                        String fieldName;
                        block4: {
                            block6: {
                                block5: {
                                    block3: {
                                        structField = x0$14;
                                        if (structField == null) break block2;
                                        fieldName = structField.name();
                                        DataType dataType2 = structField.dataType();
                                        nullable = structField.nullable();
                                        dataType = dataType2;
                                        NullType$ nullType$ = NullType$.MODULE$;
                                        DataType dataType3 = dataType;
                                        if (nullType$ != null ? !nullType$.equals(dataType3) : dataType3 != null) break block3;
                                        stringType$ = StringType$.MODULE$;
                                        break block4;
                                    }
                                    if (!(dataType instanceof ArrayType)) break block5;
                                    ArrayType arrayType = (ArrayType)dataType;
                                    DataType dataType4 = arrayType.elementType();
                                    NullType$ nullType$ = NullType$.MODULE$;
                                    DataType dataType5 = dataType4;
                                    if (nullType$ != null ? !nullType$.equals(dataType5) : dataType5 != null) break block5;
                                    stringType$ = new ArrayType((DataType)StringType$.MODULE$);
                                    break block4;
                                }
                                if (!(dataType instanceof StructType)) break block6;
                                StructType structType = (StructType)dataType;
                                stringType$ = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$nullTypeToStringType(structType);
                                break block4;
                            }
                            if (dataType == null) break block7;
                            DataType dataType6 = dataType;
                            stringType$ = dataType6;
                        }
                        StringType$ newType = stringType$;
                        StructField structField2 = new StructField(fieldName, (DataType)newType, nullable);
                        return structField2;
                    }
                    throw new MatchError((Object)dataType);
                }
                throw new MatchError((Object)structField);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new StructType(fields);
    }

    private Seq<AttributeReference> asAttributes(StructType struct) {
        return (Seq)struct.fields().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AttributeReference apply(StructField f) {
                String x$15 = f.name();
                DataType x$16 = f.dataType();
                boolean x$17 = true;
                ExprId x$18 = AttributeReference$.MODULE$.apply$default$4(x$15, x$16, x$17);
                Seq x$19 = AttributeReference$.MODULE$.apply$default$5(x$15, x$16, x$17);
                return new AttributeReference(x$15, x$16, x$17, x$18, x$19);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private StructType asStruct(Seq<AttributeReference> attributes) {
        Seq fields = (Seq)attributes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(AttributeReference x0$15) {
                AttributeReference attributeReference = x0$15;
                if (attributeReference != null) {
                    String name = attributeReference.name();
                    DataType dataType = attributeReference.dataType();
                    boolean nullable = attributeReference.nullable();
                    StructField structField = new StructField(name, dataType, nullable);
                    return structField;
                }
                throw new MatchError((Object)attributeReference);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new StructType(fields);
    }

    public final StructType org$apache$spark$sql$json$JsonRDD$$makeStruct$1(Seq values, Seq prefix, scala.collection.immutable.Map resolved$1) {
        Tuple2 tuple2 = values.partition((Function1)new anonfun.7());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq topLevel = (Seq)tuple2._1();
            Seq structLike = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topLevel, (Object)structLike);
            Seq topLevel2 = (Seq)tuple23._1();
            Seq structLike2 = (Seq)tuple23._2();
            Seq topLevelFields = (Seq)((TraversableLike)topLevel2.filter((Function1)new Serializable(resolved$1, prefix){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map resolved$1;
                private final Seq prefix$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(Seq<String> name) {
                    boolean bl = false;
                    ArrayType arrayType = null;
                    DataType dataType = (DataType)this.resolved$1.get(this.prefix$1.$plus$plus(name, Seq$.MODULE$.canBuildFrom())).get();
                    if (dataType instanceof ArrayType) {
                        bl = true;
                        arrayType = (ArrayType)dataType;
                        DataType dataType2 = arrayType.elementType();
                        if (dataType2 instanceof StructType) {
                            StructType structType = (StructType)dataType2;
                            Seq seq = structType.fields();
                            Nil$ nil$ = Nil$.MODULE$;
                            Seq seq2 = seq;
                            if (nil$ == null) {
                                if (seq2 == null) return false;
                            } else if (nil$.equals(seq2)) {
                                return false;
                            }
                        }
                    }
                    if (bl) {
                        return true;
                    }
                    if (!(dataType instanceof StructType)) return true;
                    return false;
                }
                {
                    this.resolved$1 = resolved$1;
                    this.prefix$1 = prefix$1;
                }
            })).map((Function1)new Serializable(resolved$1, prefix){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map resolved$1;
                private final Seq prefix$1;

                public final StructField apply(Seq<String> a) {
                    return new StructField((String)a.head(), (DataType)this.resolved$1.get(this.prefix$1.$plus$plus(a, Seq$.MODULE$.canBuildFrom())).get(), true);
                }
                {
                    this.resolved$1 = resolved$1;
                    this.prefix$1 = prefix$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq structFields = ((TraversableOnce)((TraversableLike)structLike2.groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Seq<String> x$6) {
                    return (String)x$6.apply(0);
                }
            }).map((Function1)new Serializable(resolved$1, prefix){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map resolved$1;
                private final Seq prefix$1;

                public final Option<StructField> apply(Tuple2<String, Seq<Seq<String>>> x0$4) {
                    Tuple2<String, Seq<Seq<String>>> tuple2;
                    block2: {
                        DataType dataType;
                        block6: {
                            Some some;
                            block4: {
                                block5: {
                                    StructType structType;
                                    String name;
                                    block3: {
                                        tuple2 = x0$4;
                                        if (tuple2 == null) break block2;
                                        name = (String)tuple2._1();
                                        Seq fields = (Seq)tuple2._2();
                                        Seq nestedFields = (Seq)fields.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Seq<String> apply(Seq<String> x$7) {
                                                return (Seq)x$7.tail();
                                            }
                                        }, Seq$.MODULE$.canBuildFrom());
                                        structType = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$makeStruct$1(nestedFields, (Seq)this.prefix$1.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()), this.resolved$1);
                                        DataType dataType2 = (DataType)this.resolved$1.get(this.prefix$1.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom())).get();
                                        dataType = dataType2;
                                        if (!(dataType instanceof ArrayType)) break block3;
                                        some = new Some((Object)new StructField(name, (DataType)new ArrayType((DataType)structType), true));
                                        break block4;
                                    }
                                    if (!(dataType instanceof StructType)) break block5;
                                    some = new Some((Object)new StructField(name, (DataType)structType, true));
                                    break block4;
                                }
                                StringType$ stringType$ = StringType$.MODULE$;
                                DataType dataType3 = dataType;
                                if (stringType$ != null ? !stringType$.equals(dataType3) : dataType3 != null) break block6;
                                some = None$.MODULE$;
                            }
                            Some some2 = some;
                            return some2;
                        }
                        throw new MatchError((Object)dataType);
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.resolved$1 = resolved$1;
                    this.prefix$1 = prefix$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<StructField> apply(Option<StructField> field) {
                    return Option$.MODULE$.option2Iterable(field);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            return new StructType((Seq)((SeqLike)topLevelFields.$plus$plus((GenTraversableOnce)structFields, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x0$5) {
                    StructField structField = x0$5;
                    if (structField != null) {
                        String name;
                        String string = name = structField.name();
                        return string;
                    }
                    throw new MatchError((Object)structField);
                }
            }, (Ordering)Ordering.String$.MODULE$));
        }
        throw new MatchError((Object)tuple2);
    }

    private JsonRDD$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

