/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedException;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.parquet.ParquetRelation;
import org.apache.spark.sql.parquet.ParquetTypesConverter$;
import parquet.hadoop.metadata.CompressionCodecName;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.sys.package$;

public final class ParquetRelation$
implements Serializable {
    public static final ParquetRelation$ MODULE$;
    private final CompressionCodecName defaultCompression;

    static {
        new ParquetRelation$();
    }

    public void enableLogForwarding() {
        Logger parquetLogger = Logger.getLogger("parquet");
        Predef$.MODULE$.refArrayOps((Object[])parquetLogger.getHandlers()).foreach((Function1)new Serializable(parquetLogger){
            public static final long serialVersionUID = 0L;
            private final Logger parquetLogger$1;

            public final void apply(Handler x$1) {
                this.parquetLogger$1.removeHandler(x$1);
            }
            {
                this.parquetLogger$1 = parquetLogger$1;
            }
        });
        if (!parquetLogger.getUseParentHandlers()) {
            parquetLogger.setUseParentHandlers(true);
        }
    }

    public CompressionCodecName defaultCompression() {
        return this.defaultCompression;
    }

    public ParquetRelation create(String pathString, LogicalPlan child, Configuration conf) {
        if (child.resolved()) {
            return this.createEmpty(pathString, (Seq<Attribute>)child.output(), false, conf);
        }
        throw new UnresolvedException((TreeNode)child, "Attempt to create Parquet table from unresolved child (when schema is not available)");
    }

    public ParquetRelation createEmpty(String pathString, Seq<Attribute> attributes, boolean allowExisting, Configuration conf) {
        Path path = this.checkPath(pathString, allowExisting, conf);
        if (conf.get("parquet.compression") == null) {
            conf.set("parquet.compression", this.defaultCompression().name());
        }
        this.enableLogForwarding();
        ParquetTypesConverter$.MODULE$.writeMetaData(attributes, path, conf);
        return new ParquetRelation(attributes, conf, path){
            private final Seq<Attribute> output;

            public Seq<Attribute> output() {
                return this.output;
            }
            {
                this.output = attributes$1;
            }
        };
    }

    private Path checkPath(String pathStr, boolean allowExisting, Configuration conf) {
        if (pathStr == null) {
            throw new IllegalArgumentException("Unable to create ParquetRelation: path is null");
        }
        Path origPath = new Path(pathStr);
        FileSystem fs = origPath.getFileSystem(conf);
        if (fs == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to create ParquetRelation: incorrectly formatted path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pathStr})));
        }
        Path path = origPath.makeQualified(fs);
        if (!allowExisting && fs.exists(path)) {
            throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pathStr})));
        }
        if (fs.exists(path) && !fs.getFileStatus(path).getPermission().getUserAction().implies(FsAction.READ_WRITE)) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to create ParquetRelation: path ", " not read-writable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        return path;
    }

    public ParquetRelation apply(String path, Option<Configuration> conf) {
        return new ParquetRelation(path, conf);
    }

    public Option<Tuple2<String, Option<Configuration>>> unapply(ParquetRelation x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.path(), x$0.conf()));
    }

    public Option<Configuration> apply$default$2() {
        return None$.MODULE$;
    }

    public Option<Configuration> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ParquetRelation$() {
        MODULE$ = this;
        this.defaultCompression = CompressionCodecName.GZIP;
    }
}

