/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.catalyst.trees.LeafNode;
import org.apache.spark.sql.execution.LeafNode;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.parquet.FileSystemHelper$;
import org.apache.spark.sql.parquet.FilteringParquetRowInputFormat;
import org.apache.spark.sql.parquet.ParquetFilters$;
import org.apache.spark.sql.parquet.ParquetRelation;
import org.apache.spark.sql.parquet.ParquetTypesConverter$;
import org.apache.spark.sql.parquet.RowReadSupport;
import org.apache.spark.sql.parquet.RowReadSupport$;
import org.apache.spark.sql.parquet.RowWriteSupport$;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.util.ContextUtil;
import parquet.io.InvalidRecordException;
import parquet.schema.MessageType;
import parquet.schema.Type;
import scala.Function1;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0001\u0003\u00016\u0011\u0001\u0003U1scV,G\u000fV1cY\u0016\u001c6-\u00198\u000b\u0005\r!\u0011a\u00029beF,X\r\u001e\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0006\u00019!r#\b\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005M\u0001\"!C*qCJ\\\u0007\u000b\\1o!\tyQ#\u0003\u0002\u0017!\tAA*Z1g\u001d>$W\r\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013AB8viB,H/F\u0001$!\r!Cf\f\b\u0003K)r!AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012BA\u0016\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!!\f\u0018\u0003\u0007M+\u0017O\u0003\u0002,3A\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00025\t\u0005A1-\u0019;bYf\u001cH/\u0003\u00027c\tI\u0011\t\u001e;sS\n,H/\u001a\u0005\tq\u0001\u0011\t\u0012)A\u0005G\u00059q.\u001e;qkR\u0004\u0003\u0002\u0003\u001e\u0001\u0005+\u0007I\u0011A\u001e\u0002\u0011I,G.\u0019;j_:,\u0012\u0001\u0010\t\u0003{yj\u0011AA\u0005\u0003\u007f\t\u0011q\u0002U1scV,GOU3mCRLwN\u001c\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005y\u0005I!/\u001a7bi&|g\u000e\t\u0005\t\u0007\u0002\u0011)\u001a!C\u0001\t\u0006\t2m\u001c7v[:\u0004&/\u001e8j]\u001e\u0004&/\u001a3\u0016\u0003\u0015\u00032\u0001\n\u0017G!\t\u0001t)\u0003\u0002Ic\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011)\u0003!\u0011#Q\u0001\n\u0015\u000b!cY8mk6t\u0007K];oS:<\u0007K]3eA!AA\n\u0001BC\u0002\u0013\u0005Q*\u0001\u0006tc2\u001cuN\u001c;fqR,\u0012A\u0014\t\u0003\u001fBk\u0011\u0001B\u0005\u0003#\u0012\u0011!bU)M\u0007>tG/\u001a=u\u0011!\u0019\u0006A!A!\u0002\u0013q\u0015aC:rY\u000e{g\u000e^3yi\u0002B#AU+\u0011\u0005a1\u0016BA,\u001a\u0005%!(/\u00198tS\u0016tG\u000fC\u0003Z\u0001\u0011\u0005!,\u0001\u0004=S:LGO\u0010\u000b\u00057z{\u0006\r\u0006\u0002];B\u0011Q\b\u0001\u0005\u0006\u0019b\u0003\rA\u0014\u0005\u0006Ca\u0003\ra\t\u0005\u0006ua\u0003\r\u0001\u0010\u0005\u0006\u0007b\u0003\r!\u0012\u0005\u0006E\u0002!\teY\u0001\bKb,7-\u001e;f)\u0005!\u0007cA3iU6\taM\u0003\u0002h\r\u0005\u0019!\u000f\u001a3\n\u0005%4'a\u0001*E\tB\u0011\u0001g[\u0005\u0003YF\u00121AU8x\u0011\u0015q\u0007\u0001\"\u0011p\u00035yG\u000f[3s\u0007>\u0004\u00180\u0011:hgV\t\u0001\u000fE\u0002rm:k\u0011A\u001d\u0006\u0003gR\f\u0011\"[7nkR\f'\r\\3\u000b\u0005UL\u0012AC2pY2,7\r^5p]&\u0011qO\u001d\u0002\u0005\u0019&\u001cH\u000fC\u0003z\u0001\u0011\u0005!0\u0001\u0007qeVtWmQ8mk6t7\u000f\u0006\u0002]w\")A\u0010\u001fa\u0001G\u0005\u0001\u0002O];oK\u0012\fE\u000f\u001e:jEV$Xm\u001d\u0005\u0006}\u0002!Ia`\u0001\u0013m\u0006d\u0017\u000eZ1uKB\u0013xN[3di&|g\u000e\u0006\u0003\u0002\u0002\u0005\u001d\u0001c\u0001\r\u0002\u0004%\u0019\u0011QA\r\u0003\u000f\t{w\u000e\\3b]\"1\u0011\u0011B?A\u0002\r\n!\u0002\u001d:pU\u0016\u001cG/[8o\u0011%\ti\u0001AA\u0001\n\u0003\ty!\u0001\u0003d_BLH\u0003CA\t\u0003+\t9\"!\u0007\u0015\u0007q\u000b\u0019\u0002\u0003\u0004M\u0003\u0017\u0001\rA\u0014\u0005\tC\u0005-\u0001\u0013!a\u0001G!A!(a\u0003\u0011\u0002\u0003\u0007A\b\u0003\u0005D\u0003\u0017\u0001\n\u00111\u0001F\u0011%\ti\u0002AI\u0001\n\u0003\ty\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005\"fA\u0012\u0002$-\u0012\u0011Q\u0005\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003%)hn\u00195fG.,GMC\u0002\u00020e\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019$!\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00028\u0001\t\n\u0011\"\u0001\u0002:\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u001eU\ra\u00141\u0005\u0005\n\u0003\u007f\u0001\u0011\u0013!C\u0001\u0003\u0003\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002D)\u001aQ)a\t\t\u0013\u0005\u001d\u0003!!A\u0005B\u0005%\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002LA!\u0011QJA,\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013\u0001\u00027b]\u001eT!!!\u0016\u0002\t)\fg/Y\u0005\u0005\u00033\nyE\u0001\u0004TiJLgn\u001a\u0005\n\u0003;\u0002\u0011\u0011!C\u0001\u0003?\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0019\u0011\u0007a\t\u0019'C\u0002\u0002fe\u00111!\u00138u\u0011%\tI\u0007AA\u0001\n\u0003\tY'\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u00141\u000f\t\u00041\u0005=\u0014bAA93\t\u0019\u0011I\\=\t\u0015\u0005U\u0014qMA\u0001\u0002\u0004\t\t'A\u0002yIEB\u0011\"!\u001f\u0001\u0003\u0003%\t%a\u001f\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!! \u0011\r\u0005}\u0014\u0011QA7\u001b\u0005!\u0018bAABi\nA\u0011\n^3sCR|'\u000fC\u0005\u0002\b\u0002\t\t\u0011\"\u0001\u0002\n\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0002\u0005-\u0005BCA;\u0003\u000b\u000b\t\u00111\u0001\u0002n!I\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0013\u0011S\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\r\u0005\n\u0003+\u0003\u0011\u0011!C!\u0003/\u000ba!Z9vC2\u001cH\u0003BA\u0001\u00033C!\"!\u001e\u0002\u0014\u0006\u0005\t\u0019AA7\u000f%\tiJAA\u0001\u0012\u0003\ty*\u0001\tQCJ\fX/\u001a;UC\ndWmU2b]B\u0019Q(!)\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003G\u001bR!!)\u0002&v\u00012\u0001GAT\u0013\r\tI+\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000fe\u000b\t\u000b\"\u0001\u0002.R\u0011\u0011q\u0014\u0005\u000b\u0003c\u000b\t+!A\u0005F\u0005M\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0003BCA\\\u0003C\u000b\t\u0011\"!\u0002:\u0006)\u0011\r\u001d9msRA\u00111XAa\u0003\u0007\f)\rF\u0002]\u0003{Ca\u0001TA[\u0001\u0004q\u0005fAA_+\"1\u0011%!.A\u0002\rBaAOA[\u0001\u0004a\u0004BB\"\u00026\u0002\u0007Q\t\u0003\u0006\u0002J\u0006\u0005\u0016\u0011!CA\u0003\u0017\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002N\u0006e\u0007#\u0002\r\u0002P\u0006M\u0017bAAi3\t1q\n\u001d;j_:\u0004b\u0001GAkGq*\u0015bAAl3\t1A+\u001e9mKNB\u0011\"a7\u0002H\u0006\u0005\t\u0019\u0001/\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002`\u0006\u0005\u0016\u0011!C\u0005\u0003C\f1B]3bIJ+7o\u001c7wKR\u0011\u00111\u001d\t\u0005\u0003\u001b\n)/\u0003\u0003\u0002h\u0006=#AB(cU\u0016\u001cG\u000f")
public class ParquetTableScan
extends SparkPlan
implements LeafNode,
Product,
Serializable {
    private final Seq<Attribute> output;
    private final ParquetRelation relation;
    private final Seq<Expression> columnPruningPred;
    private final transient SQLContext sqlContext;

    public Nil$ children() {
        return LeafNode.class.children((org.apache.spark.sql.catalyst.trees.LeafNode)this);
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public ParquetRelation relation() {
        return this.relation;
    }

    public Seq<Expression> columnPruningPred() {
        return this.columnPruningPred;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public RDD<Row> execute() {
        SparkContext sc = this.sqlContext().sparkContext();
        Job job = new Job(sc.hadoopConfiguration());
        ParquetInputFormat.setReadSupportClass((Job)job, RowReadSupport.class);
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Seq<Path> fileList = FileSystemHelper$.MODULE$.listFiles(this.relation().path(), conf);
        fileList.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path path) {
                return !path.getName().startsWith("_");
            }
        }).foreach((Function1)new Serializable(this, job){
            public static final long serialVersionUID = 0L;
            private final Job job$1;

            public final void apply(Path path) {
                FileInputFormat.addInputPath((Job)this.job$1, (Path)path);
            }
            {
                this.job$1 = job$1;
            }
        });
        conf.set(RowReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), ParquetTypesConverter$.MODULE$.convertToString(this.output()));
        conf.set(RowWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), ParquetTypesConverter$.MODULE$.convertToString(this.relation().output()));
        if (this.columnPruningPred().length() > 0 && sc.conf().getBoolean(ParquetFilters$.MODULE$.PARQUET_FILTER_PUSHDOWN_ENABLED(), true)) {
            ParquetFilters$.MODULE$.serializeFilterExpressions(this.columnPruningPred(), conf);
        }
        return sc.newAPIHadoopRDD(conf, FilteringParquetRowInputFormat.class, Void.class, Row.class).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Tuple2<Void, Row> x$1) {
                return (Row)x$1._2();
            }
        }, ClassTag$.MODULE$.apply(Row.class)).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Row x$2) {
                return x$2 != null;
            }
        });
    }

    public List<SQLContext> otherCopyArgs() {
        SQLContext sQLContext = this.sqlContext();
        return Nil$.MODULE$.$colon$colon((Object)sQLContext);
    }

    public ParquetTableScan pruneColumns(Seq<Attribute> prunedAttributes) {
        boolean success = this.validateProjection(prunedAttributes);
        if (success) {
            return new ParquetTableScan(prunedAttributes, this.relation(), this.columnPruningPred(), this.sqlContext());
        }
        throw package$.MODULE$.error("Warning: Could not validate Parquet schema projection in pruneColumns");
    }

    private boolean validateProjection(Seq<Attribute> projection) {
        boolean bl;
        MessageType original = this.relation().parquetSchema();
        MessageType candidate = ParquetTypesConverter$.MODULE$.convertFromAttributes(projection);
        try {
            original.checkContains((Type)candidate);
            bl = true;
        }
        catch (InvalidRecordException invalidRecordException) {
            bl = false;
        }
        return bl;
    }

    public ParquetTableScan copy(Seq<Attribute> output2, ParquetRelation relation, Seq<Expression> columnPruningPred, SQLContext sqlContext) {
        return new ParquetTableScan(output2, relation, columnPruningPred, sqlContext);
    }

    public Seq<Attribute> copy$default$1() {
        return this.output();
    }

    public ParquetRelation copy$default$2() {
        return this.relation();
    }

    public Seq<Expression> copy$default$3() {
        return this.columnPruningPred();
    }

    public String productPrefix() {
        return "ParquetTableScan";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.columnPruningPred();
                break;
            }
            case 1: {
                object = this.relation();
                break;
            }
            case 0: {
                object = this.output();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParquetTableScan;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParquetTableScan)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParquetTableScan parquetTableScan = (ParquetTableScan)x$1;
        Seq<Attribute> seq = this.output();
        Seq<Attribute> seq2 = parquetTableScan.output();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        ParquetRelation parquetRelation = this.relation();
        ParquetRelation parquetRelation2 = parquetTableScan.relation();
        if (parquetRelation == null) {
            if (parquetRelation2 != null) {
                return false;
            }
        } else if (!((Object)((Object)parquetRelation)).equals((Object)parquetRelation2)) return false;
        Seq<Expression> seq3 = this.columnPruningPred();
        Seq<Expression> seq4 = parquetTableScan.columnPruningPred();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        if (!parquetTableScan.canEqual(this)) return false;
        return true;
    }

    public ParquetTableScan(Seq<Attribute> output2, ParquetRelation relation, Seq<Expression> columnPruningPred, SQLContext sqlContext) {
        this.output = output2;
        this.relation = relation;
        this.columnPruningPred = columnPruningPred;
        this.sqlContext = sqlContext;
        LeafNode.class.$init$((org.apache.spark.sql.catalyst.trees.LeafNode)this);
        Product.class.$init$((Product)this);
    }
}

