/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.Logging;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.types.ArrayType;
import org.apache.spark.sql.catalyst.types.BooleanType$;
import org.apache.spark.sql.catalyst.types.ByteType$;
import org.apache.spark.sql.catalyst.types.DataType;
import org.apache.spark.sql.catalyst.types.DataType$;
import org.apache.spark.sql.catalyst.types.DoubleType$;
import org.apache.spark.sql.catalyst.types.FloatType$;
import org.apache.spark.sql.catalyst.types.IntegerType$;
import org.apache.spark.sql.catalyst.types.LongType$;
import org.apache.spark.sql.catalyst.types.MapType;
import org.apache.spark.sql.catalyst.types.PrimitiveType;
import org.apache.spark.sql.catalyst.types.ShortType$;
import org.apache.spark.sql.catalyst.types.StringType$;
import org.apache.spark.sql.catalyst.types.StructField;
import org.apache.spark.sql.catalyst.types.StructType;
import org.apache.spark.sql.catalyst.types.StructType$;
import org.apache.spark.sql.parquet.CatalystConverter$;
import org.apache.spark.sql.parquet.ParquetRelation$;
import org.apache.spark.sql.parquet.RowReadSupport$;
import org.slf4j.Logger;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.ContextUtil;
import parquet.schema.ConversionPatterns;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class ParquetTypesConverter$
implements Logging {
    public static final ParquetTypesConverter$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new ParquetTypesConverter$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public boolean isPrimitiveType(DataType ctype) {
        return PrimitiveType.class.isAssignableFrom(ctype.getClass());
    }

    public DataType toPrimitiveDataType(PrimitiveType.PrimitiveTypeName parquetType) {
        PrimitiveType.PrimitiveTypeName primitiveTypeName;
        block11: {
            StringType$ stringType$;
            block5: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block4: {
                                        primitiveTypeName = parquetType;
                                        PrimitiveType.PrimitiveTypeName primitiveTypeName2 = PrimitiveType.PrimitiveTypeName.BINARY;
                                        PrimitiveType.PrimitiveTypeName primitiveTypeName3 = primitiveTypeName;
                                        if (primitiveTypeName2 != null ? !primitiveTypeName2.equals(primitiveTypeName3) : primitiveTypeName3 != null) break block4;
                                        stringType$ = StringType$.MODULE$;
                                        break block5;
                                    }
                                    PrimitiveType.PrimitiveTypeName primitiveTypeName4 = PrimitiveType.PrimitiveTypeName.BOOLEAN;
                                    PrimitiveType.PrimitiveTypeName primitiveTypeName5 = primitiveTypeName;
                                    if (primitiveTypeName4 != null ? !primitiveTypeName4.equals(primitiveTypeName5) : primitiveTypeName5 != null) break block6;
                                    stringType$ = BooleanType$.MODULE$;
                                    break block5;
                                }
                                PrimitiveType.PrimitiveTypeName primitiveTypeName6 = PrimitiveType.PrimitiveTypeName.DOUBLE;
                                PrimitiveType.PrimitiveTypeName primitiveTypeName7 = primitiveTypeName;
                                if (primitiveTypeName6 != null ? !primitiveTypeName6.equals(primitiveTypeName7) : primitiveTypeName7 != null) break block7;
                                stringType$ = DoubleType$.MODULE$;
                                break block5;
                            }
                            PrimitiveType.PrimitiveTypeName primitiveTypeName8 = PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
                            PrimitiveType.PrimitiveTypeName primitiveTypeName9 = primitiveTypeName;
                            if (primitiveTypeName8 != null ? !primitiveTypeName8.equals(primitiveTypeName9) : primitiveTypeName9 != null) break block8;
                            stringType$ = new ArrayType((DataType)ByteType$.MODULE$);
                            break block5;
                        }
                        PrimitiveType.PrimitiveTypeName primitiveTypeName10 = PrimitiveType.PrimitiveTypeName.FLOAT;
                        PrimitiveType.PrimitiveTypeName primitiveTypeName11 = primitiveTypeName;
                        if (primitiveTypeName10 != null ? !primitiveTypeName10.equals(primitiveTypeName11) : primitiveTypeName11 != null) break block9;
                        stringType$ = FloatType$.MODULE$;
                        break block5;
                    }
                    PrimitiveType.PrimitiveTypeName primitiveTypeName12 = PrimitiveType.PrimitiveTypeName.INT32;
                    PrimitiveType.PrimitiveTypeName primitiveTypeName13 = primitiveTypeName;
                    if (primitiveTypeName12 != null ? !primitiveTypeName12.equals(primitiveTypeName13) : primitiveTypeName13 != null) break block10;
                    stringType$ = IntegerType$.MODULE$;
                    break block5;
                }
                PrimitiveType.PrimitiveTypeName primitiveTypeName14 = PrimitiveType.PrimitiveTypeName.INT64;
                PrimitiveType.PrimitiveTypeName primitiveTypeName15 = primitiveTypeName;
                if (primitiveTypeName14 != null ? !primitiveTypeName14.equals(primitiveTypeName15) : primitiveTypeName15 != null) break block11;
                stringType$ = LongType$.MODULE$;
            }
            return stringType$;
        }
        PrimitiveType.PrimitiveTypeName primitiveTypeName16 = PrimitiveType.PrimitiveTypeName.INT96;
        PrimitiveType.PrimitiveTypeName primitiveTypeName17 = primitiveTypeName;
        if (!(primitiveTypeName16 != null ? !primitiveTypeName16.equals(primitiveTypeName17) : primitiveTypeName17 != null)) {
            throw package$.MODULE$.error("Potential loss of precision: cannot convert INT96");
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported parquet datatype ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parquetType})));
    }

    public DataType toDataType(Type parquetType) {
        DataType dataType;
        if (parquetType.isPrimitive()) {
            dataType = this.toPrimitiveDataType(parquetType.asPrimitiveType().getPrimitiveTypeName());
        } else {
            ArrayType arrayType;
            GroupType groupType = parquetType.asGroupType();
            OriginalType originalType = parquetType.getOriginalType();
            OriginalType originalType2 = OriginalType.LIST;
            OriginalType originalType3 = originalType;
            if (!(originalType2 != null ? !originalType2.equals(originalType3) : originalType3 != null)) {
                Predef$.MODULE$.assert(groupType.getFieldCount() == 1);
                Type field = (Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0);
                arrayType = new ArrayType(this.toDataType(field));
            } else {
                OriginalType originalType4 = OriginalType.MAP;
                OriginalType originalType5 = originalType;
                if (!(originalType4 != null ? !originalType4.equals(originalType5) : originalType5 != null)) {
                    Predef$.MODULE$.assert(!((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0)).isPrimitive(), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Parquet Map type malformatted: expected nested group for map!";
                        }
                    });
                    GroupType keyValueGroup = ((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0)).asGroupType();
                    Predef$.MODULE$.assert(keyValueGroup.getFieldCount() == 2, (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Parquet Map type malformatted: nested group should have 2 (key, value) fields!";
                        }
                    });
                    DataType keyType = this.toDataType((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(0));
                    Type.Repetition repetition = ((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(0)).getRepetition();
                    Type.Repetition repetition2 = Type.Repetition.REQUIRED;
                    Predef$.MODULE$.assert(!(repetition != null ? !repetition.equals(repetition2) : repetition2 != null));
                    DataType valueType = this.toDataType((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(1));
                    Type.Repetition repetition3 = ((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(1)).getRepetition();
                    Type.Repetition repetition4 = Type.Repetition.REQUIRED;
                    Predef$.MODULE$.assert(!(repetition3 != null ? !repetition3.equals(repetition4) : repetition4 != null));
                    arrayType = new MapType(keyType, valueType);
                } else {
                    ArrayType arrayType2;
                    if (this.correspondsToMap$1(groupType)) {
                        GroupType keyValueGroup = ((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0)).asGroupType();
                        DataType keyType = this.toDataType((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(0));
                        Type.Repetition repetition = ((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(0)).getRepetition();
                        Type.Repetition repetition5 = Type.Repetition.REQUIRED;
                        Predef$.MODULE$.assert(!(repetition != null ? !repetition.equals(repetition5) : repetition5 != null));
                        DataType valueType = this.toDataType((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(1));
                        Type.Repetition repetition6 = ((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(1)).getRepetition();
                        Type.Repetition repetition7 = Type.Repetition.REQUIRED;
                        Predef$.MODULE$.assert(!(repetition6 != null ? !repetition6.equals(repetition7) : repetition7 != null));
                        arrayType2 = new MapType(keyType, valueType);
                    } else if (this.correspondsToArray$1(groupType)) {
                        DataType elementType = this.toDataType((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0));
                        arrayType2 = new ArrayType(elementType);
                    } else {
                        Buffer fields = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final StructField apply(Type ptype) {
                                Type.Repetition repetition = ptype.getRepetition();
                                Type.Repetition repetition2 = Type.Repetition.REQUIRED;
                                return new StructField(ptype.getName(), ParquetTypesConverter$.MODULE$.toDataType(ptype), repetition != null ? !repetition.equals(repetition2) : repetition2 != null);
                            }
                        }, Buffer$.MODULE$.canBuildFrom());
                        arrayType2 = new StructType((Seq)fields);
                    }
                    arrayType = arrayType2;
                }
            }
            dataType = arrayType;
        }
        return dataType;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Option<PrimitiveType.PrimitiveTypeName> fromPrimitiveDataType(DataType ctype) {
        void var4_14;
        DataType dataType = ctype;
        StringType$ stringType$ = StringType$.MODULE$;
        DataType dataType2 = dataType;
        if (!(stringType$ != null ? !stringType$.equals(dataType2) : dataType2 != null)) {
            Some some = new Some((Object)PrimitiveType.PrimitiveTypeName.BINARY);
            return var4_14;
        }
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        DataType dataType3 = dataType;
        if (!(booleanType$ != null ? !booleanType$.equals(dataType3) : dataType3 != null)) {
            Some some = new Some((Object)PrimitiveType.PrimitiveTypeName.BOOLEAN);
            return var4_14;
        }
        DoubleType$ doubleType$ = DoubleType$.MODULE$;
        DataType dataType4 = dataType;
        if (!(doubleType$ != null ? !doubleType$.equals(dataType4) : dataType4 != null)) {
            Some some = new Some((Object)PrimitiveType.PrimitiveTypeName.DOUBLE);
            return var4_14;
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType dataType5 = arrayType.elementType();
            ByteType$ byteType$ = ByteType$.MODULE$;
            DataType dataType6 = dataType5;
            if (!(byteType$ != null ? !byteType$.equals(dataType6) : dataType6 != null)) {
                Some some = new Some((Object)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
                return var4_14;
            }
        }
        FloatType$ floatType$ = FloatType$.MODULE$;
        DataType dataType7 = dataType;
        if (!(floatType$ != null ? !floatType$.equals(dataType7) : dataType7 != null)) {
            Some some = new Some((Object)PrimitiveType.PrimitiveTypeName.FLOAT);
            return var4_14;
        }
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        DataType dataType8 = dataType;
        if (!(integerType$ != null ? !integerType$.equals(dataType8) : dataType8 != null)) {
            Some some = new Some((Object)PrimitiveType.PrimitiveTypeName.INT32);
            return var4_14;
        }
        ShortType$ shortType$ = ShortType$.MODULE$;
        DataType dataType9 = dataType;
        if (!(shortType$ != null ? !shortType$.equals(dataType9) : dataType9 != null)) {
            Some some = new Some((Object)PrimitiveType.PrimitiveTypeName.INT32);
            return var4_14;
        }
        ByteType$ byteType$ = ByteType$.MODULE$;
        DataType dataType10 = dataType;
        if (!(byteType$ != null ? !byteType$.equals(dataType10) : dataType10 != null)) {
            Some some = new Some((Object)PrimitiveType.PrimitiveTypeName.INT32);
            return var4_14;
        }
        LongType$ longType$ = LongType$.MODULE$;
        DataType dataType11 = dataType;
        if (!(longType$ != null ? !longType$.equals(dataType11) : dataType11 != null)) {
            Some some = new Some((Object)PrimitiveType.PrimitiveTypeName.INT64);
            return var4_14;
        }
        None$ none$ = None$.MODULE$;
        return var4_14;
    }

    public Type fromDataType(DataType ctype, String name, boolean nullable, boolean inArray) {
        block7: {
            parquet.schema.PrimitiveType primitiveType;
            block3: {
                GroupType groupType;
                block5: {
                    DataType dataType;
                    Type.Repetition repetition;
                    block6: {
                        block4: {
                            block2: {
                                repetition = inArray ? Type.Repetition.REPEATED : (nullable ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED);
                                Option<PrimitiveType.PrimitiveTypeName> primitiveType2 = this.fromPrimitiveDataType(ctype);
                                if (!primitiveType2.isDefined()) break block2;
                                primitiveType = new parquet.schema.PrimitiveType(repetition, (PrimitiveType.PrimitiveTypeName)primitiveType2.get(), name);
                                break block3;
                            }
                            dataType = ctype;
                            if (!(dataType instanceof ArrayType)) break block4;
                            ArrayType arrayType = (ArrayType)dataType;
                            DataType elementType = arrayType.elementType();
                            Type parquetElementType = this.fromDataType(elementType, CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), false, true);
                            groupType = ConversionPatterns.listType((Type.Repetition)repetition, (String)name, (Type)parquetElementType);
                            break block5;
                        }
                        if (!(dataType instanceof StructType)) break block6;
                        StructType structType = (StructType)dataType;
                        Seq structFields = structType.fields();
                        Seq fields = (Seq)structFields.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Type apply(StructField field) {
                                return ParquetTypesConverter$.MODULE$.fromDataType(field.dataType(), field.name(), field.nullable(), false);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        groupType = new GroupType(repetition, name, JavaConversions$.MODULE$.seqAsJavaList(fields));
                        break block5;
                    }
                    if (!(dataType instanceof MapType)) break block7;
                    MapType mapType = (MapType)dataType;
                    DataType keyType = mapType.keyType();
                    DataType valueType = mapType.valueType();
                    Type parquetKeyType = this.fromDataType(keyType, CatalystConverter$.MODULE$.MAP_KEY_SCHEMA_NAME(), false, false);
                    Type parquetValueType = this.fromDataType(valueType, CatalystConverter$.MODULE$.MAP_VALUE_SCHEMA_NAME(), false, false);
                    groupType = ConversionPatterns.mapType((Type.Repetition)repetition, (String)name, (Type)parquetKeyType, (Type)parquetValueType);
                }
                primitiveType = groupType;
            }
            return primitiveType;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported datatype ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctype})));
    }

    public boolean fromDataType$default$3() {
        return true;
    }

    public boolean fromDataType$default$4() {
        return false;
    }

    public Seq<Attribute> convertToAttributes(Type parquetSchema) {
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(parquetSchema.asGroupType().getFields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AttributeReference apply(Type field) {
                String x$2 = field.getName();
                DataType x$3 = ParquetTypesConverter$.MODULE$.toDataType(field);
                Type.Repetition repetition = field.getRepetition();
                Type.Repetition repetition2 = Type.Repetition.REQUIRED;
                boolean x$4 = repetition != null ? !repetition.equals(repetition2) : repetition2 != null;
                ExprId x$5 = AttributeReference$.MODULE$.$lessinit$greater$default$4(x$2, x$3, x$4);
                Seq x$6 = AttributeReference$.MODULE$.$lessinit$greater$default$5(x$2, x$3, x$4);
                return new AttributeReference(x$2, x$3, x$4, x$5, x$6);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public MessageType convertFromAttributes(Seq<Attribute> attributes) {
        Seq fields = (Seq)attributes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Type apply(Attribute attribute) {
                return ParquetTypesConverter$.MODULE$.fromDataType(attribute.dataType(), attribute.name(), attribute.nullable(), ParquetTypesConverter$.MODULE$.fromDataType$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new MessageType("root", JavaConversions$.MODULE$.seqAsJavaList(fields));
    }

    public Seq<Attribute> convertFromString(String string) {
        DataType dataType = DataType$.MODULE$.apply(string);
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Seq seq = structType.toAttributes();
            return seq;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can convert ", " to row"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public String convertToString(Seq<Attribute> schema) {
        return StructType$.MODULE$.fromAttributes(schema).toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeMetaData(Seq<Attribute> attributes, Path origPath, Configuration conf) {
        Object object;
        if (origPath == null) {
            throw new IllegalArgumentException("Unable to write Parquet metadata: path is null");
        }
        FileSystem fs = origPath.getFileSystem(conf);
        if (fs == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to write Parquet metadata: path ", " is incorrectly formatted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origPath})));
        }
        Path path = origPath.makeQualified(fs);
        if (fs.exists(path) && !fs.getFileStatus(path).isDir()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected to write to directory ", " but found file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        Path metadataPath = new Path(path, "_metadata");
        if (fs.exists(metadataPath)) {
            try {
                object = BoxesRunTime.boxToBoolean((boolean)fs.delete(metadataPath, true));
            }
            catch (IOException iOException) {
                void var6_6;
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete previous PARQUET_METADATA_FILE at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_6})));
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put(RowReadSupport$.MODULE$.SPARK_METADATA_KEY(), this.convertToString(attributes));
        MessageType parquetSchema = this.convertFromAttributes(attributes);
        FileMetaData metaData = new FileMetaData(parquetSchema, extraMetadata, "Spark");
        ParquetRelation$.MODULE$.enableLogForwarding();
        Footer footer = new Footer(path, new ParquetMetadata(metaData, JavaConversions$.MODULE$.seqAsJavaList((Seq)Nil$.MODULE$)));
        ParquetFileWriter.writeMetadataFile((Configuration)conf, (Path)path, (List)JavaConversions$.MODULE$.seqAsJavaList((Seq)Nil$.MODULE$.$colon$colon((Object)footer)));
    }

    public ParquetMetadata readMetaData(Path origPath, Option<Configuration> configuration) {
        if (origPath == null) {
            throw new IllegalArgumentException("Unable to read Parquet metadata: path is null");
        }
        Job job = new Job();
        Configuration conf = (Configuration)configuration.getOrElse((Function0)new Serializable(job){
            public static final long serialVersionUID = 0L;
            private final Job job$1;

            public final Configuration apply() {
                return ContextUtil.getConfiguration((JobContext)this.job$1);
            }
            {
                this.job$1 = job$1;
            }
        });
        FileSystem fs = origPath.getFileSystem(conf);
        if (fs == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incorrectly formatted Parquet metadata path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origPath})));
        }
        Path path = origPath.makeQualified(fs);
        if (fs.getFileStatus(path).isDir()) {
            ParquetMetadata parquetMetadata;
            ParquetRelation$.MODULE$.enableLogForwarding();
            Path metadataPath = new Path(path, "_metadata");
            if (fs.exists(metadataPath) && fs.isFile(metadataPath)) {
                parquetMetadata = ParquetFileReader.readFooter((Configuration)conf, (Path)metadataPath);
            } else {
                List footers = ParquetFileReader.readFooters((Configuration)conf, (FileStatus)fs.getFileStatus(path));
                if (footers.size() == 0) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find Parquet metadata at path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
                }
                parquetMetadata = ((Footer)JavaConversions$.MODULE$.asScalaBuffer(footers).apply(0)).getParquetMetadata();
            }
            return parquetMetadata;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " for be a directory with Parquet files/metadata"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
    }

    public Seq<Attribute> readSchemaFromFile(Path origPath, Option<Configuration> conf) {
        Seq<Attribute> seq;
        Map keyValueMetadata = this.readMetaData(origPath, conf).getFileMetaData().getKeyValueMetaData();
        if (keyValueMetadata.get(RowReadSupport$.MODULE$.SPARK_METADATA_KEY()) == null) {
            Seq<Attribute> attributes = this.convertToAttributes((Type)this.readMetaData(origPath, conf).getFileMetaData().getSchema());
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Falling back to schema conversion from Parquet types; result: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attributes})));
            seq = attributes;
        } else {
            seq = this.convertFromString((String)keyValueMetadata.get(RowReadSupport$.MODULE$.SPARK_METADATA_KEY()));
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean correspondsToMap$1(GroupType groupType) {
        if (groupType.getFieldCount() != 1) return false;
        if (((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0)).isPrimitive()) {
            return false;
        }
        GroupType keyValueGroup = ((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0)).asGroupType();
        Type.Repetition repetition = keyValueGroup.getRepetition();
        Type.Repetition repetition2 = Type.Repetition.REPEATED;
        if (repetition == null) {
            if (repetition2 != null) {
                return false;
            }
        } else if (!repetition.equals(repetition2)) return false;
        String string = keyValueGroup.getName();
        String string2 = CatalystConverter$.MODULE$.MAP_SCHEMA_NAME();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (keyValueGroup.getFieldCount() != 2) return false;
        String string3 = ((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(0)).getName();
        String string4 = CatalystConverter$.MODULE$.MAP_KEY_SCHEMA_NAME();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = ((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(1)).getName();
        String string6 = CatalystConverter$.MODULE$.MAP_VALUE_SCHEMA_NAME();
        if (string5 == null) {
            if (string6 == null) return true;
            return false;
        } else {
            if (!string5.equals(string6)) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean correspondsToArray$1(GroupType groupType) {
        if (groupType.getFieldCount() != 1) return false;
        String string = groupType.getFieldName(0);
        String string2 = CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Type.Repetition repetition = ((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0)).getRepetition();
        Type.Repetition repetition2 = Type.Repetition.REPEATED;
        if (repetition == null) {
            if (repetition2 == null) return true;
            return false;
        } else {
            if (!repetition.equals(repetition2)) return false;
            return true;
        }
    }

    private ParquetTypesConverter$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

