/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.Logging;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.parquet.ParquetTypesConverter$;
import org.apache.spark.sql.parquet.RowReadSupport$;
import org.apache.spark.sql.parquet.RowRecordMaterializer;
import org.apache.spark.sql.parquet.RowWriteSupport$;
import org.slf4j.Logger;
import parquet.hadoop.api.ReadSupport;
import parquet.io.api.RecordMaterializer;
import parquet.schema.MessageType;
import parquet.schema.Type;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb!B\u0001\u0003\u0001\ta!A\u0004*poJ+\u0017\rZ*vaB|'\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001]1scV,GO\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u001f!\rqACF\u0007\u0002\u001f)\u0011\u0001#E\u0001\u0004CBL'B\u0001\n\u0014\u0003\u0019A\u0017\rZ8pa*\t1!\u0003\u0002\u0016\u001f\tY!+Z1e'V\u0004\bo\u001c:u!\t9B$D\u0001\u0019\u0015\tI\"$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000e\u0005\u0003!\u0019\u0017\r^1msN$\u0018BA\u000f\u0019\u0005\r\u0011vn\u001e\t\u0003?\u0001j\u0011AB\u0005\u0003C\u0019\u0011q\u0001T8hO&tw\rC\u0003$\u0001\u0011\u0005Q%\u0001\u0004=S:LGOP\u0002\u0001)\u00051\u0003CA\u0014\u0001\u001b\u0005\u0011\u0001\"B\u0015\u0001\t\u0003R\u0013A\u00049sKB\f'/\u001a$peJ+\u0017\r\u001a\u000b\u0006WIRdJ\u0016\t\u0004YA2R\"A\u0017\u000b\u0005Aq#BA\u0018\u0014\u0003\tIw.\u0003\u00022[\t\u0011\"+Z2pe\u0012l\u0015\r^3sS\u0006d\u0017N_3s\u0011\u0015\u0019\u0004\u00061\u00015\u0003\u0011\u0019wN\u001c4\u0011\u0005UBT\"\u0001\u001c\u000b\u0005M:$B\u0001\n\t\u0013\tIdGA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006w!\u0002\r\u0001P\u0001\ngR\u0014\u0018N\\4NCB\u0004B!\u0010\"E\t6\taH\u0003\u0002@\u0001\u0006!Q\u000f^5m\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\u00075\u000b\u0007\u000f\u0005\u0002F\u0017:\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\u00061\u0001K]3eK\u001aL!\u0001T'\u0003\rM#(/\u001b8h\u0015\tQu\tC\u0003PQ\u0001\u0007\u0001+\u0001\u0006gS2,7k\u00195f[\u0006\u0004\"!\u0015+\u000e\u0003IS!aU\n\u0002\rM\u001c\u0007.Z7b\u0013\t)&KA\u0006NKN\u001c\u0018mZ3UsB,\u0007\"B,)\u0001\u0004A\u0016a\u0003:fC\u0012\u001cuN\u001c;fqR\u0004\"!W3\u000f\u0005i\u001bgBA.c\u001d\ta\u0016M\u0004\u0002^A6\taL\u0003\u0002`I\u00051AH]8pizJ\u0011aA\u0005\u0003%MI!\u0001E\t\n\u0005\u0011|\u0011a\u0003*fC\u0012\u001cV\u000f\u001d9peRL!AZ4\u0003\u0017I+\u0017\rZ\"p]R,\u0007\u0010\u001e\u0006\u0003I>AQ!\u001b\u0001\u0005B)\fA!\u001b8jiR!\u0001l[7p\u0011\u0015a\u0007\u000e1\u00015\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]\")a\u000e\u001ba\u0001y\u0005\u00012.Z=WC2,X-T3uC\u0012\u000bG/\u0019\u0005\u0006\u001f\"\u0004\r\u0001U\u0004\u0007c\nA\tA\u0001:\u0002\u001dI{wOU3bIN+\b\u000f]8siB\u0011qe\u001d\u0004\u0007\u0003\tA\tA\u0001;\u0014\u0005M,\bC\u0001$w\u0013\t9xI\u0001\u0004B]f\u0014VM\u001a\u0005\u0006GM$\t!\u001f\u000b\u0002e\"91p\u001db\u0001\n\u0003a\u0018AG*Q\u0003J[uLU(X?J+\u0015+V#T)\u0016#ulU\"I\u000b6\u000bU#A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t\u0001Q\u0001\u0005Y\u0006tw-\u0003\u0002M\u007f\"9\u0011qA:!\u0002\u0013i\u0018aG*Q\u0003J[uLU(X?J+\u0015+V#T)\u0016#ulU\"I\u000b6\u000b\u0005\u0005\u0003\u0005\u0002\fM\u0014\r\u0011\"\u0001}\u0003I\u0019\u0006+\u0011*L?6+E+\u0011#B)\u0006{6*R-\t\u000f\u0005=1\u000f)A\u0005{\u0006\u00192\u000bU!S\u0017~kU\tV!E\u0003R\u000bulS#ZA!9\u00111C:\u0005\n\u0005U\u0011AE4fiJ+\u0017/^3ti\u0016$7k\u00195f[\u0006$B!a\u0006\u00020A1\u0011\u0011DA\u0012\u0003SqA!a\u0007\u0002 9\u0019Q,!\b\n\u0003!K1!!\tH\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\n\u0002(\t\u00191+Z9\u000b\u0007\u0005\u0005r\tE\u0002\u0018\u0003WI1!!\f\u0019\u0005%\tE\u000f\u001e:jEV$X\r\u0003\u0004m\u0003#\u0001\r\u0001\u000e")
public class RowReadSupport
extends ReadSupport<Row>
implements Logging {
    private transient Logger org$apache$spark$Logging$$log_;

    public static String SPARK_METADATA_KEY() {
        return RowReadSupport$.MODULE$.SPARK_METADATA_KEY();
    }

    public static String SPARK_ROW_REQUESTED_SCHEMA() {
        return RowReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RecordMaterializer<Row> prepareForRead(Configuration conf, Map<String, String> stringMap, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"preparing for read with Parquet file schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileSchema})));
        MessageType parquetSchema = readContext.getRequestedSchema();
        Seq<Attribute> schema = null;
        if (readContext.getReadSupportMetadata() != null) {
            if (readContext.getReadSupportMetadata().get(RowReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA()) == null) {
                if (readContext.getReadSupportMetadata().get(RowReadSupport$.MODULE$.SPARK_METADATA_KEY()) != null) {
                    schema = ParquetTypesConverter$.MODULE$.convertFromString((String)readContext.getReadSupportMetadata().get(RowReadSupport$.MODULE$.SPARK_METADATA_KEY()));
                }
            } else {
                schema = ParquetTypesConverter$.MODULE$.convertFromString((String)readContext.getReadSupportMetadata().get(RowReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA()));
            }
        }
        if (schema == null) {
            this.log().debug("falling back to Parquet read schema");
            schema = ParquetTypesConverter$.MODULE$.convertToAttributes((Type)parquetSchema);
        }
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"list of attributes that will be read: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema})));
        return new RowRecordMaterializer(parquetSchema, schema);
    }

    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        Object object;
        MessageType parquetSchema = fileSchema;
        HashMap<String, String> metadata = new HashMap<String, String>();
        Seq<Attribute> requestedAttributes = RowReadSupport$.MODULE$.org$apache$spark$sql$parquet$RowReadSupport$$getRequestedSchema(configuration);
        if (requestedAttributes == null) {
            object = BoxedUnit.UNIT;
        } else {
            parquetSchema = ParquetTypesConverter$.MODULE$.convertFromAttributes(requestedAttributes);
            object = metadata.put(RowReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), ParquetTypesConverter$.MODULE$.convertToString(requestedAttributes));
        }
        String origAttributesStr = configuration.get(RowWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        Object object2 = origAttributesStr == null ? BoxedUnit.UNIT : metadata.put(RowReadSupport$.MODULE$.SPARK_METADATA_KEY(), origAttributesStr);
        return new ReadSupport.ReadContext(parquetSchema, metadata);
    }

    public RowReadSupport() {
        Logging.class.$init$((Logging)this);
    }
}

