/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.sql.parquet.CatalystConverter$;
import org.apache.spark.sql.parquet.ParquetRelation;
import org.apache.spark.sql.parquet.ParquetRelation$;
import org.apache.spark.sql.parquet.TestGroupWriteSupport;
import org.apache.spark.sql.test.TestSQLContext$;
import org.apache.spark.util.Utils$;
import parquet.example.data.Group;
import parquet.example.data.simple.SimpleGroup;
import parquet.hadoop.ParquetWriter;
import parquet.hadoop.api.WriteSupport;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ParquetTestData$ {
    public static final ParquetTestData$ MODULE$;
    private final String testSchema;
    private final Seq<String> testSchemaFieldNames;
    private final String subTestSchema;
    private final String testFilterSchema;
    private final Seq<String> subTestSchemaFieldNames;
    private final File testDir;
    private final File testFilterDir;
    private ParquetRelation testData;
    private final String testNestedSchema1;
    private final String testNestedSchema2;
    private final String testNestedSchema3;
    private final String testNestedSchema4;
    private final File testNestedDir1;
    private final File testNestedDir2;
    private final File testNestedDir3;
    private final File testNestedDir4;
    private ParquetRelation testNestedData1;
    private ParquetRelation testNestedData2;
    private volatile byte bitmap$0;

    static {
        new ParquetTestData$();
    }

    private ParquetRelation testData$lzycompute() {
        ParquetTestData$ parquetTestData$ = this;
        synchronized (parquetTestData$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.testData = new ParquetRelation(this.testDir().toURI().toString(), (Option<Configuration>)None$.MODULE$, TestSQLContext$.MODULE$, ParquetRelation$.MODULE$.$lessinit$greater$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.testData;
        }
    }

    private ParquetRelation testNestedData1$lzycompute() {
        ParquetTestData$ parquetTestData$ = this;
        synchronized (parquetTestData$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.testNestedData1 = new ParquetRelation(this.testNestedDir1().toURI().toString(), (Option<Configuration>)None$.MODULE$, TestSQLContext$.MODULE$, ParquetRelation$.MODULE$.$lessinit$greater$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.testNestedData1;
        }
    }

    private ParquetRelation testNestedData2$lzycompute() {
        ParquetTestData$ parquetTestData$ = this;
        synchronized (parquetTestData$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.testNestedData2 = new ParquetRelation(this.testNestedDir2().toURI().toString(), (Option<Configuration>)None$.MODULE$, TestSQLContext$.MODULE$, ParquetRelation$.MODULE$.$lessinit$greater$default$4());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.testNestedData2;
        }
    }

    public String testSchema() {
        return this.testSchema;
    }

    public Seq<String> testSchemaFieldNames() {
        return this.testSchemaFieldNames;
    }

    public String subTestSchema() {
        return this.subTestSchema;
    }

    public String testFilterSchema() {
        return this.testFilterSchema;
    }

    public Seq<String> subTestSchemaFieldNames() {
        return this.subTestSchemaFieldNames;
    }

    public File testDir() {
        return this.testDir;
    }

    public File testFilterDir() {
        return this.testFilterDir;
    }

    public ParquetRelation testData() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.testData$lzycompute() : this.testData;
    }

    public String testNestedSchema1() {
        return this.testNestedSchema1;
    }

    public String testNestedSchema2() {
        return this.testNestedSchema2;
    }

    public String testNestedSchema3() {
        return this.testNestedSchema3;
    }

    public String testNestedSchema4() {
        return this.testNestedSchema4;
    }

    public File testNestedDir1() {
        return this.testNestedDir1;
    }

    public File testNestedDir2() {
        return this.testNestedDir2;
    }

    public File testNestedDir3() {
        return this.testNestedDir3;
    }

    public File testNestedDir4() {
        return this.testNestedDir4;
    }

    public ParquetRelation testNestedData1() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.testNestedData1$lzycompute() : this.testNestedData1;
    }

    public ParquetRelation testNestedData2() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.testNestedData2$lzycompute() : this.testNestedData2;
    }

    public void writeFile() {
        this.testDir().delete();
        Path path = new Path(new Path(this.testDir().toURI()), new Path("part-r-0.parquet"));
        Job job = new Job();
        MessageType schema = MessageTypeParser.parseMessageType((String)this.testSchema());
        TestGroupWriteSupport writeSupport = new TestGroupWriteSupport(schema);
        ParquetWriter writer = new ParquetWriter(path, (WriteSupport)writeSupport);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach$mVc$sp((Function1)new Serializable(schema, writer){
            public static final long serialVersionUID = 0L;
            private final MessageType schema$1;
            private final ParquetWriter writer$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                SimpleGroup record = new SimpleGroup((GroupType)this.schema$1);
                if (i % 3 == 0) {
                    record.add(0, true);
                } else {
                    record.add(0, false);
                }
                if (i % 5 == 0) {
                    record.add(1, 5);
                }
                record.add(2, "abc");
                record.add(3, (long)i << 33);
                record.add(4, 2.5f);
                record.add(5, 4.5);
                this.writer$1.write((Object)record);
            }
            {
                this.schema$1 = schema$1;
                this.writer$1 = writer$1;
            }
        });
        writer.close();
    }

    public void writeFilterFile(int records) {
        this.testFilterDir().delete();
        Path path = new Path(new Path(this.testFilterDir().toURI()), new Path("part-r-0.parquet"));
        MessageType schema = MessageTypeParser.parseMessageType((String)this.testFilterSchema());
        TestGroupWriteSupport writeSupport = new TestGroupWriteSupport(schema);
        ParquetWriter writer = new ParquetWriter(path, (WriteSupport)writeSupport);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), records).foreach$mVc$sp((Function1)new Serializable(schema, writer){
            public static final long serialVersionUID = 0L;
            private final MessageType schema$2;
            private final ParquetWriter writer$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                SimpleGroup record = new SimpleGroup((GroupType)this.schema$2);
                if (i % 4 == 0) {
                    record.add(0, true);
                } else {
                    record.add(0, false);
                }
                record.add(1, i);
                record.add(2, ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                record.add(3, (long)i);
                record.add(4, (float)i + 0.5f);
                record.add(5, (double)i + 0.5);
                this.writer$2.write((Object)record);
            }
            {
                this.schema$2 = schema$2;
                this.writer$2 = writer$2;
            }
        });
        writer.close();
    }

    public int writeFilterFile$default$1() {
        return 200;
    }

    public void writeNestedFile1() {
        this.testNestedDir1().delete();
        Path path = new Path(new Path(this.testNestedDir1().toURI()), new Path("part-r-0.parquet"));
        MessageType schema = MessageTypeParser.parseMessageType((String)this.testNestedSchema1());
        SimpleGroup r1 = new SimpleGroup((GroupType)schema);
        r1.add(0, "Julien Le Dem");
        r1.addGroup(1).append(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), "555 123 4567").append(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), "555 666 1337").append(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), "XXX XXX XXXX");
        Group contacts = r1.addGroup(2);
        contacts.addGroup(0).append("name", "Dmitriy Ryaboy").append("phoneNumber", "555 987 6543");
        contacts.addGroup(0).append("name", "Chris Aniszczyk");
        SimpleGroup r2 = new SimpleGroup((GroupType)schema);
        r2.add(0, "A. Nonymous");
        TestGroupWriteSupport writeSupport = new TestGroupWriteSupport(schema);
        ParquetWriter writer = new ParquetWriter(path, (WriteSupport)writeSupport);
        writer.write((Object)r1);
        writer.write((Object)r2);
        writer.close();
    }

    public void writeNestedFile2() {
        this.testNestedDir2().delete();
        Path path = new Path(new Path(this.testNestedDir2().toURI()), new Path("part-r-0.parquet"));
        MessageType schema = MessageTypeParser.parseMessageType((String)this.testNestedSchema2());
        SimpleGroup r1 = new SimpleGroup((GroupType)schema);
        r1.add(0, 1);
        r1.add(1, 7);
        Group longs = r1.addGroup(2);
        longs.add(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), (long)1 << 32);
        longs.add(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), (long)1 << 33);
        longs.add(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), (long)1 << 34);
        Group booleanNumberPair = r1.addGroup(3).addGroup(0);
        booleanNumberPair.add("value", 2.5);
        booleanNumberPair.add("truth", false);
        Group top_level = r1.addGroup(4);
        Group second_level_a = top_level.addGroup(0);
        Group second_level_b = top_level.addGroup(0);
        Group third_level_aa = second_level_a.addGroup(0);
        Group third_level_ab = second_level_a.addGroup(0);
        Group third_level_c = second_level_b.addGroup(0);
        third_level_aa.add(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), 7);
        third_level_ab.add(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), 8);
        third_level_c.add(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), 9);
        TestGroupWriteSupport writeSupport = new TestGroupWriteSupport(schema);
        ParquetWriter writer = new ParquetWriter(path, (WriteSupport)writeSupport);
        writer.write((Object)r1);
        writer.close();
    }

    public void writeNestedFile3() {
        this.testNestedDir3().delete();
        Path path = new Path(new Path(this.testNestedDir3().toURI()), new Path("part-r-0.parquet"));
        MessageType schema = MessageTypeParser.parseMessageType((String)this.testNestedSchema3());
        SimpleGroup r1 = new SimpleGroup((GroupType)schema);
        r1.add(0, 1);
        Group booleanNumberPairs = r1.addGroup(1);
        Group g1 = booleanNumberPairs.addGroup(0);
        g1.add(0, 1);
        Group nested1 = g1.addGroup(1);
        Group ng1 = nested1.addGroup(0);
        ng1.add(0, 1.5);
        ng1.add(1, false);
        Group ng2 = nested1.addGroup(0);
        ng2.add(0, 2.5);
        ng2.add(1, true);
        Group g2 = booleanNumberPairs.addGroup(0);
        g2.add(0, 2);
        Group ng3 = g2.addGroup(1).addGroup(0);
        ng3.add(0, 3.5);
        ng3.add(1, false);
        TestGroupWriteSupport writeSupport = new TestGroupWriteSupport(schema);
        ParquetWriter writer = new ParquetWriter(path, (WriteSupport)writeSupport);
        writer.write((Object)r1);
        writer.close();
    }

    public void writeNestedFile4() {
        this.testNestedDir4().delete();
        Path path = new Path(new Path(this.testNestedDir4().toURI()), new Path("part-r-0.parquet"));
        MessageType schema = MessageTypeParser.parseMessageType((String)this.testNestedSchema4());
        SimpleGroup r1 = new SimpleGroup((GroupType)schema);
        r1.add(0, 7);
        Group map1 = r1.addGroup(1);
        Group keyValue1 = map1.addGroup(0);
        keyValue1.add(0, "key1");
        keyValue1.add(1, 1);
        Group keyValue2 = map1.addGroup(0);
        keyValue2.add(0, "key2");
        keyValue2.add(1, 2);
        Group map2 = r1.addGroup(2);
        Group keyValue3 = map2.addGroup(0);
        keyValue3.add(0, "seven");
        Group valueGroup1 = keyValue3.addGroup(1);
        valueGroup1.add(0, (long)42);
        valueGroup1.add(1, "the answer");
        Group keyValue4 = map2.addGroup(0);
        keyValue4.add(0, "eight");
        Group valueGroup2 = keyValue4.addGroup(1);
        valueGroup2.add(0, (long)49);
        TestGroupWriteSupport writeSupport = new TestGroupWriteSupport(schema);
        ParquetWriter writer = new ParquetWriter(path, (WriteSupport)writeSupport);
        writer.write((Object)r1);
        writer.close();
    }

    private ParquetTestData$() {
        MODULE$ = this;
        this.testSchema = "message myrecord {\n      optional boolean myboolean;\n      optional int32 myint;\n      optional binary mystring (UTF8);\n      optional int64 mylong;\n      optional float myfloat;\n      optional double mydouble;\n      }";
        this.testSchemaFieldNames = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"myboolean:Boolean", "myint:Int", "mystring:String", "mylong:Long", "myfloat:Float", "mydouble:Double"}));
        this.subTestSchema = "\n      message myrecord {\n      optional boolean myboolean;\n      optional int64 mylong;\n      }\n    ";
        this.testFilterSchema = "\n      message myrecord {\n      required boolean myboolean;\n      required int32 myint;\n      required binary mystring (UTF8);\n      required int64 mylong;\n      required float myfloat;\n      required double mydouble;\n      }\n    ";
        this.subTestSchemaFieldNames = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"myboolean:Boolean", "mylong:Long"}));
        this.testDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1());
        this.testFilterDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1());
        this.testNestedSchema1 = "\n      message AddressBook {\n        required binary owner (UTF8);\n        optional group ownerPhoneNumbers {\n          repeated binary array (UTF8);\n        }\n        optional group contacts {\n          repeated group array {\n            required binary name (UTF8);\n            optional binary phoneNumber (UTF8);\n          }\n        }\n      }\n    ";
        this.testNestedSchema2 = "\n      message TestNested2 {\n        required int32 firstInt;\n        optional int32 secondInt;\n        optional group longs {\n          repeated int64 array;\n        }\n        required group entries {\n          repeated group array {\n            required double value;\n            optional boolean truth;\n          }\n        }\n        optional group outerouter {\n          repeated group array {\n            repeated group array {\n              repeated int32 array;\n            }\n          }\n        }\n      }\n    ";
        this.testNestedSchema3 = "\n      message TestNested3 {\n        required int32 x;\n        optional group booleanNumberPairs {\n          repeated group array {\n            required int32 key;\n            optional group value {\n              repeated group array {\n                required double nestedValue;\n                optional boolean truth;\n              }\n            }\n          }\n        }\n      }\n    ";
        this.testNestedSchema4 = "\n      message TestNested4 {\n        required int32 x;\n        optional group data1 {\n          repeated group map {\n            required binary key (UTF8);\n            required int32 value;\n          }\n        }\n        required group data2 {\n          repeated group map {\n            required binary key (UTF8);\n            required group value {\n              required int64 payload1;\n              optional binary payload2 (UTF8);\n            }\n          }\n        }\n      }\n    ";
        this.testNestedDir1 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1());
        this.testNestedDir2 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1());
        this.testNestedDir3 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1());
        this.testNestedDir4 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1());
    }
}

