/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.spark.sql

/**
 * :: DeveloperApi ::
 * An execution engine for relational query plans that runs on top Spark and returns RDDs.
 *
 * Note that the operators in this package are created automatically by a query planner using a
 * [[SQLContext]] and are not intended to be used directly by end users of Spark SQL.  They are
 * documented here in order to make it easier for others to understand the performance
 * characteristics of query plans that are generated by Spark SQL.
 */
package object execution
