/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.ShuffledRDD;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.catalyst.plans.physical.SinglePartition$;
import org.apache.spark.sql.catalyst.trees.UnaryNode;
import org.apache.spark.sql.execution.Limit$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkSqlSerializer;
import org.apache.spark.sql.execution.UnaryNode;
import org.apache.spark.sql.execution.UnaryNode$class;
import org.apache.spark.util.MutablePair;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u00016\u0011Q\u0001T5nSRT!a\u0001\u0003\u0002\u0013\u0015DXmY;uS>t'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f%UY\u0002CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005%\u0019\u0006/\u0019:l!2\fg\u000e\u0005\u0002\u0010'%\u0011AC\u0001\u0002\n+:\f'/\u001f(pI\u0016\u0004\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u00179%\u0011Qd\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t?\u0001\u0011)\u001a!C\u0001A\u0005)A.[7jiV\t\u0011\u0005\u0005\u0002\u0017E%\u00111e\u0006\u0002\u0004\u0013:$\b\u0002C\u0013\u0001\u0005#\u0005\u000b\u0011B\u0011\u0002\r1LW.\u001b;!\u0011!9\u0003A!f\u0001\n\u0003A\u0013!B2iS2$W#\u0001\b\t\u0011)\u0002!\u0011#Q\u0001\n9\taa\u00195jY\u0012\u0004\u0003\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0002/_A\u0002\"a\u0004\u0001\t\u000b}Y\u0003\u0019A\u0011\t\u000b\u001dZ\u0003\u0019\u0001\b\t\u000bI\u0002A\u0011B\u001a\u0002%M|'\u000f\u001e\"bg\u0016$7\u000b[;gM2,wJ\\\u000b\u0002iA\u0011a#N\u0005\u0003m]\u0011qAQ8pY\u0016\fg\u000eC\u00039\u0001\u0011\u0005\u0013(\u0001\u0004pkR\u0004X\u000f^\u000b\u0002uA\u00191h\u0011$\u000f\u0005q\neBA\u001fA\u001b\u0005q$BA \r\u0003\u0019a$o\\8u}%\t\u0001$\u0003\u0002C/\u00059\u0001/Y2lC\u001e,\u0017B\u0001#F\u0005\r\u0019V-\u001d\u0006\u0003\u0005^\u0001\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0017\u0012\t\u0001bY1uC2L8\u000f^\u0005\u0003\u001b\"\u0013\u0011\"\u0011;ue&\u0014W\u000f^3\t\u000b=\u0003A\u0011\t)\u0002%=,H\u000f];u!\u0006\u0014H/\u001b;j_:LgnZ\u000b\u0002#:\u0011!kV\u0007\u0002'*\u0011A+V\u0001\ta\"L8/[2bY*\u0011aKS\u0001\u0006a2\fgn]\u0005\u00031N\u000bqbU5oO2,\u0007+\u0019:uSRLwN\u001c\u0005\u00065\u0002!\teW\u0001\u000fKb,7-\u001e;f\u0007>dG.Z2u)\u0005a\u0006c\u0001\f^?&\u0011al\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u000f\u0002L!!\u0019%\u0003\u0007I{w\u000fC\u0003d\u0001\u0011\u0005C-A\u0004fq\u0016\u001cW\u000f^3\u0015\u0003\u0015\u00042AZ5`\u001b\u00059'B\u00015\u0007\u0003\r\u0011H\rZ\u0005\u0003U\u001e\u00141A\u0015#E\u0011\u001da\u0007!!A\u0005\u00025\fAaY8qsR\u0019aF\\8\t\u000f}Y\u0007\u0013!a\u0001C!9qe\u001bI\u0001\u0002\u0004q\u0001bB9\u0001#\u0003%\tA]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005\u0019(FA\u0011uW\u0005)\bC\u0001<|\u001b\u00059(B\u0001=z\u0003%)hn\u00195fG.,GM\u0003\u0002{/\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005q<(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9a\u0010AI\u0001\n\u0003y\u0018AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0003Q#A\u0004;\t\u0013\u0005\u0015\u0001!!A\u0005B\u0005\u001d\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\nA!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001\u00027b]\u001eT!!a\u0005\u0002\t)\fg/Y\u0005\u0005\u0003/\tiA\u0001\u0004TiJLgn\u001a\u0005\t\u00037\u0001\u0011\u0011!C\u0001A\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0011\u0011E\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019#!\u000b\u0011\u0007Y\t)#C\u0002\u0002(]\u00111!\u00118z\u0011%\tY#!\b\u0002\u0002\u0003\u0007\u0011%A\u0002yIEB\u0011\"a\f\u0001\u0003\u0003%\t%!\r\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\r\u0011\r\u0005U\u00121HA\u0012\u001b\t\t9DC\u0002\u0002:]\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti$a\u000e\u0003\u0011%#XM]1u_JD\u0011\"!\u0011\u0001\u0003\u0003%\t!a\u0011\u0002\u0011\r\fg.R9vC2$2\u0001NA#\u0011)\tY#a\u0010\u0002\u0002\u0003\u0007\u00111\u0005\u0005\n\u0003\u0013\u0002\u0011\u0011!C!\u0003\u0017\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002C!I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0013\u0011K\u0001\u0007KF,\u0018\r\\:\u0015\u0007Q\n\u0019\u0006\u0003\u0006\u0002,\u00055\u0013\u0011!a\u0001\u0003GA3\u0001AA,!\u0011\tI&!\u0018\u000e\u0005\u0005m#B\u0001>\u0007\u0013\u0011\ty&a\u0017\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5\b\u0013\u0005\r$!!A\t\u0002\u0005\u0015\u0014!\u0002'j[&$\bcA\b\u0002h\u0019A\u0011AAA\u0001\u0012\u0003\tIgE\u0003\u0002h\u0005-4\u0004E\u0004\u0002n\u0005M\u0014E\u0004\u0018\u000e\u0005\u0005=$bAA9/\u00059!/\u001e8uS6,\u0017\u0002BA;\u0003_\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001da\u0013q\rC\u0001\u0003s\"\"!!\u001a\t\u0015\u0005u\u0014qMA\u0001\n\u000b\ny(\u0001\u0005u_N#(/\u001b8h)\t\tI\u0001\u0003\u0006\u0002\u0004\u0006\u001d\u0014\u0011!CA\u0003\u000b\u000bQ!\u00199qYf$RALAD\u0003\u0013CaaHAA\u0001\u0004\t\u0003BB\u0014\u0002\u0002\u0002\u0007a\u0002\u0003\u0006\u0002\u000e\u0006\u001d\u0014\u0011!CA\u0003\u001f\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0012\u0006u\u0005#\u0002\f\u0002\u0014\u0006]\u0015bAAK/\t1q\n\u001d;j_:\u0004RAFAMC9I1!a'\u0018\u0005\u0019!V\u000f\u001d7fe!I\u0011qTAF\u0003\u0003\u0005\rAL\u0001\u0004q\u0012\u0002\u0004BCAR\u0003O\n\t\u0011\"\u0003\u0002&\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\u000b\u0005\u0003\u0002\f\u0005%\u0016\u0002BAV\u0003\u001b\u0011aa\u00142kK\u000e$\b")
public class Limit
extends SparkPlan
implements UnaryNode,
Product {
    private final int limit;
    private final SparkPlan child;

    public static Function1<Tuple2<Object, SparkPlan>, Limit> tupled() {
        return Limit$.MODULE$.tupled();
    }

    public static Function1<Object, Function1<SparkPlan, Limit>> curried() {
        return Limit$.MODULE$.curried();
    }

    public List<SparkPlan> children() {
        return UnaryNode.class.children((org.apache.spark.sql.catalyst.trees.UnaryNode)this);
    }

    public int limit() {
        return this.limit;
    }

    public SparkPlan child() {
        return this.child;
    }

    private boolean sortBasedShuffleOn() {
        return SparkEnv$.MODULE$.get().shuffleManager() instanceof SortShuffleManager;
    }

    public Seq<Attribute> output() {
        return this.child().output();
    }

    public SinglePartition$ outputPartitioning() {
        return SinglePartition$.MODULE$;
    }

    @Override
    public Row[] executeCollect() {
        int numPartsToTry;
        if (this.limit() == 0) {
            return new Row[0];
        }
        RDD childRDD = this.child().execute().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Row x$3) {
                return x$3.copy();
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        ArrayBuffer buf = new ArrayBuffer();
        int totalParts = childRDD.partitions().length;
        for (int partsScanned = 0; buf.size() < this.limit() && partsScanned < totalParts; partsScanned += numPartsToTry) {
            numPartsToTry = 1;
            if (partsScanned > 0) {
                numPartsToTry = buf.size() == 0 ? totalParts - 1 : (int)(1.5 * (double)this.limit() * (double)partsScanned / (double)buf.size());
            }
            numPartsToTry = package$.MODULE$.max(0, numPartsToTry);
            int left = this.limit() - buf.size();
            Range p = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(partsScanned), package$.MODULE$.min(partsScanned + numPartsToTry, totalParts));
            SparkContext sc = this.sqlContext().sparkContext();
            Row[][] res = (Row[][])sc.runJob(childRDD, (Function1)new Serializable(this, left){
                public static final long serialVersionUID = 0L;
                private final int left$1;

                public final Row[] apply(Iterator<Row> it) {
                    return (Row[])it.take(this.left$1).toArray(ClassTag$.MODULE$.apply(Row.class));
                }
                {
                    this.left$1 = left$1;
                }
            }, (Seq)p, false, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Row.class)));
            Predef$.MODULE$.refArrayOps((Object[])res).foreach((Function1)new Serializable(this, buf){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Limit $outer;
                private final ArrayBuffer buf$1;

                public final ArrayBuffer<Row> apply(Row[] x$4) {
                    return this.buf$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])x$4).take(this.$outer.limit() - this.buf$1.size())));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.buf$1 = buf$1;
                }
            });
        }
        return (Row[])Predef$.MODULE$.refArrayOps((Object[])buf.toArray(ClassTag$.MODULE$.apply(Row.class))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Limit $outer;

            public final Row apply(Row x$5) {
                return ScalaReflection$.MODULE$.convertRowToScala(x$5, this.$outer.schema());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
    }

    @Override
    public RDD<Row> execute() {
        RDD rDD;
        if (this.sortBasedShuffleOn()) {
            RDD<Row> qual$3 = this.child().execute();
            Serializable x$27 = new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Limit $outer;

                public final Iterator<Tuple2<Object, Row>> apply(Iterator<Row> iter) {
                    return iter.take(this.$outer.limit()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Row> apply(Row row) {
                            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)row.copy());
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
            boolean x$28 = qual$3.mapPartitions$default$2();
            rDD = qual$3.mapPartitions((Function1)x$27, x$28, ClassTag$.MODULE$.apply(Tuple2.class));
        } else {
            RDD<Row> qual$4 = this.child().execute();
            Serializable x$29 = new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Limit $outer;

                public final Iterator<MutablePair<Object, Row>> apply(Iterator<Row> iter) {
                    MutablePair mutablePair = new MutablePair();
                    return iter.take(this.$outer.limit()).map((Function1)new Serializable(this, mutablePair){
                        public static final long serialVersionUID = 0L;
                        private final MutablePair mutablePair$1;

                        public final MutablePair<Object, Row> apply(Row row) {
                            return this.mutablePair$1.update((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)row);
                        }
                        {
                            this.mutablePair$1 = mutablePair$1;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
            boolean x$30 = qual$4.mapPartitions$default$2();
            rDD = qual$4.mapPartitions((Function1)x$29, x$30, ClassTag$.MODULE$.apply(MutablePair.class));
        }
        RDD rdd = rDD;
        HashPartitioner part = new HashPartitioner(1);
        ShuffledRDD shuffled = new ShuffledRDD(rdd, (Partitioner)part);
        shuffled.setSerializer((Serializer)new SparkSqlSerializer(new SparkConf(false)));
        return shuffled.mapPartitions((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Limit $outer;

            public final Iterator<Row> apply(Iterator<Tuple2<Object, Row>> x$6) {
                return x$6.take(this.$outer.limit()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Row apply(Tuple2<Object, Row> x$7) {
                        return (Row)x$7._2();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, shuffled.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
    }

    public Limit copy(int limit, SparkPlan child) {
        return new Limit(limit, child);
    }

    public int copy$default$1() {
        return this.limit();
    }

    public SparkPlan copy$default$2() {
        return this.child();
    }

    public String productPrefix() {
        return "Limit";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.child();
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.limit());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Limit;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.limit());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)((Object)this.child())));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Limit)) return false;
        boolean bl = true;
        if (!bl) return false;
        Limit limit = (Limit)x$1;
        if (this.limit() != limit.limit()) return false;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = limit.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!((Object)((Object)sparkPlan)).equals((Object)sparkPlan2)) return false;
        if (!limit.canEqual(this)) return false;
        return true;
    }

    public Limit(int limit, SparkPlan child) {
        this.limit = limit;
        this.child = child;
        UnaryNode.class.$init$((org.apache.spark.sql.catalyst.trees.UnaryNode)this);
        UnaryNode$class.$init$(this);
        Product.class.$init$((Product)this);
    }
}

