/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.Logging;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.catalyst.types.ArrayType;
import org.apache.spark.sql.catalyst.types.BinaryType$;
import org.apache.spark.sql.catalyst.types.BooleanType$;
import org.apache.spark.sql.catalyst.types.ByteType$;
import org.apache.spark.sql.catalyst.types.DataType;
import org.apache.spark.sql.catalyst.types.DecimalType;
import org.apache.spark.sql.catalyst.types.DoubleType$;
import org.apache.spark.sql.catalyst.types.FloatType$;
import org.apache.spark.sql.catalyst.types.IntegerType$;
import org.apache.spark.sql.catalyst.types.LongType$;
import org.apache.spark.sql.catalyst.types.MapType;
import org.apache.spark.sql.catalyst.types.PrecisionInfo;
import org.apache.spark.sql.catalyst.types.PrimitiveType;
import org.apache.spark.sql.catalyst.types.ShortType$;
import org.apache.spark.sql.catalyst.types.StringType$;
import org.apache.spark.sql.catalyst.types.StructField;
import org.apache.spark.sql.catalyst.types.StructType;
import org.apache.spark.sql.catalyst.types.UserDefinedType;
import org.apache.spark.sql.catalyst.types.decimal.Decimal;
import org.apache.spark.sql.parquet.CatalystConverter$;
import org.apache.spark.sql.parquet.ParquetRelation$;
import org.apache.spark.sql.parquet.ParquetTypesConverter$;
import org.apache.spark.sql.parquet.RowReadSupport$;
import org.apache.spark.sql.parquet.RowWriteSupport$;
import org.slf4j.Logger;
import parquet.hadoop.api.WriteSupport;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t\ra!B\u0001\u0003\u0001\ta!a\u0004*po^\u0013\u0018\u000e^3TkB\u0004xN\u001d;\u000b\u0005\r!\u0011a\u00029beF,X\r\u001e\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e=A\u0019a\u0002\u0006\f\u000e\u0003=Q!\u0001E\t\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0013'\u00051\u0001.\u00193p_BT\u0011aA\u0005\u0003+=\u0011Ab\u0016:ji\u0016\u001cV\u000f\u001d9peR\u0004\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u00037\u0011\t\u0001bY1uC2L8\u000f^\u0005\u0003;a\u00111AU8x!\ty\u0002%D\u0001\u0007\u0013\t\tcAA\u0004M_\u001e<\u0017N\\4\t\u000b\r\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A\n\t\u0003O\u0001i\u0011A\u0001\u0005\tS\u0001\u0001\r\u0011\"\u0001\u0003U\u00051qO]5uKJ,\u0012a\u000b\t\u0003YAj\u0011!\f\u0006\u0003!9R!aL\n\u0002\u0005%|\u0017BA\u0019.\u00059\u0011VmY8sI\u000e{gn];nKJD\u0001b\r\u0001A\u0002\u0013\u0005!\u0001N\u0001\u000boJLG/\u001a:`I\u0015\fHCA\u001b<!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0011)f.\u001b;\t\u000fq\u0012\u0014\u0011!a\u0001W\u0005\u0019\u0001\u0010J\u0019\t\ry\u0002\u0001\u0015)\u0003,\u0003\u001d9(/\u001b;fe\u0002B\u0001\u0002\u0011\u0001A\u0002\u0013\u0005!!Q\u0001\u000bCR$(/\u001b2vi\u0016\u001cX#\u0001\"\u0011\u0007\r[eJ\u0004\u0002E\u0013:\u0011Q\tS\u0007\u0002\r*\u0011q\tJ\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!AS\u001c\u0002\u000fA\f7m[1hK&\u0011A*\u0014\u0002\u0004'\u0016\f(B\u0001&8!\t9r*\u0003\u0002Q1\tI\u0011\t\u001e;sS\n,H/\u001a\u0005\t%\u0002\u0001\r\u0011\"\u0001\u0003'\u0006q\u0011\r\u001e;sS\n,H/Z:`I\u0015\fHCA\u001bU\u0011\u001da\u0014+!AA\u0002\tCaA\u0016\u0001!B\u0013\u0011\u0015aC1uiJL'-\u001e;fg\u0002BQ\u0001\u0017\u0001\u0005Be\u000bA!\u001b8jiR\u0011!,\u0019\t\u00037zs!A\u0004/\n\u0005u{\u0011\u0001D,sSR,7+\u001e9q_J$\u0018BA0a\u000519&/\u001b;f\u0007>tG/\u001a=u\u0015\tiv\u0002C\u0003c/\u0002\u00071-A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003I\"l\u0011!\u001a\u0006\u0003M\u001e\fAaY8oM*\u0011!\u0003C\u0005\u0003S\u0016\u0014QbQ8oM&<WO]1uS>t\u0007\"B6\u0001\t\u0003b\u0017a\u00049sKB\f'/\u001a$pe^\u0013\u0018\u000e^3\u0015\u0005Uj\u0007\"\u00028k\u0001\u0004Y\u0013A\u0004:fG>\u0014HmQ8ogVlWM\u001d\u0005\u0006a\u0002!\t%]\u0001\u0006oJLG/\u001a\u000b\u0003kIDQa]8A\u0002Y\taA]3d_J$\u0007BB;\u0001\t\u0003\u0011a/\u0001\u0006xe&$XMV1mk\u0016$2!N<\u0000\u0011\u0015AH\u000f1\u0001z\u0003\u0019\u00198\r[3nCB\u0011!0`\u0007\u0002w*\u0011APG\u0001\u0006if\u0004Xm]\u0005\u0003}n\u0014\u0001\u0002R1uCRK\b/\u001a\u0005\b\u0003\u0003!\b\u0019AA\u0002\u0003\u00151\u0018\r\\;f!\r1\u0014QA\u0005\u0004\u0003\u000f9$aA!os\"A\u00111\u0002\u0001\u0005\u0002\t\ti!\u0001\bxe&$X\r\u0015:j[&$\u0018N^3\u0015\u000bU\ny!a\u0006\t\u000fa\fI\u00011\u0001\u0002\u0012A\u0019!0a\u0005\n\u0007\u0005U1PA\u0007Qe&l\u0017\u000e^5wKRK\b/\u001a\u0005\t\u0003\u0003\tI\u00011\u0001\u0002\u0004!A\u00111\u0004\u0001\u0005\u0002\t\ti\"A\u0006xe&$Xm\u0015;sk\u000e$H#B\u001b\u0002 \u0005\u001d\u0002b\u0002=\u0002\u001a\u0001\u0007\u0011\u0011\u0005\t\u0004u\u0006\r\u0012bAA\u0013w\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011\u0005%\u0012\u0011\u0004a\u0001\u0003W\taa\u001d;sk\u000e$\b\u0007BA\u0017\u0003\u007f\u0001b!a\f\u00026\u0005mbbA\u0014\u00022%\u0019\u00111\u0007\u0002\u0002#\r\u000bG/\u00197zgR\u001cuN\u001c<feR,'/\u0003\u0003\u00028\u0005e\"aD*ueV\u001cGoU2bY\u0006$\u0016\u0010]3\u000b\u0007\u0005M\"\u0001\u0005\u0003\u0002>\u0005}B\u0002\u0001\u0003\r\u0003\u0003\n9#!A\u0001\u0002\u000b\u0005\u00111\t\u0002\u0004?\u0012*\u0014\u0003BA#\u0003\u0007\u00012ANA$\u0013\r\tIe\u000e\u0002\b\u001d>$\b.\u001b8h\u0011!\ti\u0005\u0001C\u0001\u0005\u0005=\u0013AC<sSR,\u0017I\u001d:bsR)Q'!\u0015\u0002Z!9\u00010a\u0013A\u0002\u0005M\u0003c\u0001>\u0002V%\u0019\u0011qK>\u0003\u0013\u0005\u0013(/Y=UsB,\u0007\u0002CA.\u0003\u0017\u0002\r!!\u0018\u0002\u000b\u0005\u0014(/Y=1\t\u0005}\u0013q\r\t\u0007\u0003_\t\t'!\u001a\n\t\u0005\r\u0014\u0011\b\u0002\u000f\u0003J\u0014\u0018-_*dC2\fG+\u001f9f!\u0011\ti$a\u001a\u0005\u0019\u0005%\u0014\u0011LA\u0001\u0002\u0003\u0015\t!a\u0011\u0003\u0007}#c\u0007\u0003\u0005\u0002n\u0001!\tAAA8\u0003!9(/\u001b;f\u001b\u0006\u0004H#B\u001b\u0002r\u0005e\u0004b\u0002=\u0002l\u0001\u0007\u00111\u000f\t\u0004u\u0006U\u0014bAA<w\n9Q*\u00199UsB,\u0007\u0002CA>\u0003W\u0002\r!! \u0002\u00075\f\u0007\u000f\r\u0004\u0002\u0000\u0005\u001d\u0015Q\u0012\t\t\u0003_\t\t)!\"\u0002\f&!\u00111QA\u001d\u00051i\u0015\r]*dC2\fG+\u001f9f!\u0011\ti$a\"\u0005\u0019\u0005%\u0015\u0011PA\u0001\u0002\u0003\u0015\t!a\u0011\u0003\u0007}#s\u0007\u0005\u0003\u0002>\u00055E\u0001DAH\u0003s\n\t\u0011!A\u0003\u0002\u0005\r#aA0%q!I\u00111\u0013\u0001C\u0002\u0013%\u0011QS\u0001\rg\u000e\u0014\u0018\r^2i\u0005f$Xm]\u000b\u0003\u0003/\u0003RANAM\u0003;K1!a'8\u0005\u0015\t%O]1z!\r1\u0014qT\u0005\u0004\u0003C;$\u0001\u0002\"zi\u0016D\u0001\"!*\u0001A\u0003%\u0011qS\u0001\u000eg\u000e\u0014\u0018\r^2i\u0005f$Xm\u001d\u0011\t\u0011\u0005%\u0006\u0001\"\u0001\u0003\u0003W\u000bAb\u001e:ji\u0016$UmY5nC2$R!NAW\u0003wC\u0001\"a,\u0002(\u0002\u0007\u0011\u0011W\u0001\bI\u0016\u001c\u0017.\\1m!\u0011\t\u0019,a.\u000e\u0005\u0005U&bAAXw&!\u0011\u0011XA[\u0005\u001d!UmY5nC2D\u0001\"!0\u0002(\u0002\u0007\u0011qX\u0001\naJ,7-[:j_:\u00042ANAa\u0013\r\t\u0019m\u000e\u0002\u0004\u0013:$x\u0001CAd\u0005!\u0005!!!3\u0002\u001fI{wo\u0016:ji\u0016\u001cV\u000f\u001d9peR\u00042aJAf\r\u001d\t!\u0001#\u0001\u0003\u0003\u001b\u001cB!a3\u0002PB\u0019a'!5\n\u0007\u0005MwG\u0001\u0004B]f\u0014VM\u001a\u0005\bG\u0005-G\u0011AAl)\t\tI\r\u0003\u0006\u0002\\\u0006-'\u0019!C\u0001\u0003;\f\u0001c\u0015)B%.{&kT,`'\u000eCU)T!\u0016\u0005\u0005}\u0007\u0003BAq\u0003Ot1ANAr\u0013\r\t)oN\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00181\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015x\u0007C\u0005\u0002p\u0006-\u0007\u0015!\u0003\u0002`\u0006\t2\u000bU!S\u0017~\u0013vjV0T\u0007\"+U*\u0011\u0011\t\u0011\u0005M\u00181\u001aC\u0001\u0003k\f\u0011bZ3u'\u000eDW-\\1\u0015\u0007\t\u000b9\u0010\u0003\u0004c\u0003c\u0004\ra\u0019\u0005\t\u0003w\fY\r\"\u0001\u0002~\u0006I1/\u001a;TG\",W.\u0019\u000b\u0006k\u0005}(\u0011\u0001\u0005\u0007q\u0006e\b\u0019\u0001\"\t\r\t\fI\u00101\u0001d\u0001")
public class RowWriteSupport
extends WriteSupport<Row>
implements Logging {
    private RecordConsumer writer;
    private Seq<Attribute> attributes;
    private final byte[] scratchBytes;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void setSchema(Seq<Attribute> seq, Configuration configuration) {
        RowWriteSupport$.MODULE$.setSchema(seq, configuration);
    }

    public static Seq<Attribute> getSchema(Configuration configuration) {
        return RowWriteSupport$.MODULE$.getSchema(configuration);
    }

    public static String SPARK_ROW_SCHEMA() {
        return RowWriteSupport$.MODULE$.SPARK_ROW_SCHEMA();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RecordConsumer writer() {
        return this.writer;
    }

    public void writer_$eq(RecordConsumer x$1) {
        this.writer = x$1;
    }

    public Seq<Attribute> attributes() {
        return this.attributes;
    }

    public void attributes_$eq(Seq<Attribute> x$1) {
        this.attributes = x$1;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        String origAttributesStr = configuration.get(RowWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(RowReadSupport$.MODULE$.SPARK_METADATA_KEY(), origAttributesStr);
        if (this.attributes() == null) {
            this.attributes_$eq(ParquetTypesConverter$.MODULE$.convertFromString(origAttributesStr));
        }
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"write support initialized for requested schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.attributes()})));
        ParquetRelation$.MODULE$.enableLogForwarding();
        return new WriteSupport.WriteContext(ParquetTypesConverter$.MODULE$.convertFromAttributes(this.attributes()), metadata);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.writer_$eq(recordConsumer);
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"preparing for write with schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.attributes()})));
    }

    public void write(Row record) {
        int attributesSize = this.attributes().size();
        if (attributesSize > record.size()) {
            throw new IndexOutOfBoundsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to write more fields than contained in row (", ">", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)attributesSize), BoxesRunTime.boxToInteger((int)record.size())})));
        }
        this.writer().startMessage();
        for (int index = 0; index < attributesSize; ++index) {
            if (record.apply(index) == null) continue;
            this.writer().startField(((NamedExpression)this.attributes().apply(index)).name(), index);
            this.writeValue(((Expression)this.attributes().apply(index)).dataType(), record.apply(index));
            this.writer().endField(((NamedExpression)this.attributes().apply(index)).name(), index);
        }
        this.writer().endMessage();
    }

    public void writeValue(DataType schema, Object value) {
        if (value != null) {
            DataType dataType = schema;
            if (dataType instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                this.writeValue(userDefinedType.sqlType(), value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                this.writeArray(arrayType, (Seq<Object>)((Seq)value));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                this.writeMap(mapType, (Map)value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                this.writeStruct(structType, (Seq<Object>)((Seq)value));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.writePrimitive((PrimitiveType)schema, value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void writePrimitive(PrimitiveType schema, Object value) {
        block14: {
            block4: {
                PrimitiveType primitiveType;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    if (value == null) break block4;
                                                    primitiveType = schema;
                                                    StringType$ stringType$ = StringType$.MODULE$;
                                                    PrimitiveType primitiveType2 = primitiveType;
                                                    if (stringType$ != null ? !stringType$.equals(primitiveType2) : primitiveType2 != null) break block5;
                                                    this.writer().addBinary(Binary.fromByteArray((byte[])((String)value).getBytes("utf-8")));
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block4;
                                                }
                                                BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                                PrimitiveType primitiveType3 = primitiveType;
                                                if (binaryType$ != null ? !binaryType$.equals(primitiveType3) : primitiveType3 != null) break block6;
                                                this.writer().addBinary(Binary.fromByteArray((byte[])((byte[])value)));
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block4;
                                            }
                                            IntegerType$ integerType$ = IntegerType$.MODULE$;
                                            PrimitiveType primitiveType4 = primitiveType;
                                            if (integerType$ != null ? !integerType$.equals(primitiveType4) : primitiveType4 != null) break block7;
                                            this.writer().addInteger(BoxesRunTime.unboxToInt((Object)value));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block4;
                                        }
                                        ShortType$ shortType$ = ShortType$.MODULE$;
                                        PrimitiveType primitiveType5 = primitiveType;
                                        if (shortType$ != null ? !shortType$.equals(primitiveType5) : primitiveType5 != null) break block8;
                                        this.writer().addInteger((int)BoxesRunTime.unboxToShort((Object)value));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    LongType$ longType$ = LongType$.MODULE$;
                                    PrimitiveType primitiveType6 = primitiveType;
                                    if (longType$ != null ? !longType$.equals(primitiveType6) : primitiveType6 != null) break block9;
                                    this.writer().addLong(BoxesRunTime.unboxToLong((Object)value));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                ByteType$ byteType$ = ByteType$.MODULE$;
                                PrimitiveType primitiveType7 = primitiveType;
                                if (byteType$ != null ? !byteType$.equals(primitiveType7) : primitiveType7 != null) break block10;
                                this.writer().addInteger((int)BoxesRunTime.unboxToByte((Object)value));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            DoubleType$ doubleType$ = DoubleType$.MODULE$;
                            PrimitiveType primitiveType8 = primitiveType;
                            if (doubleType$ != null ? !doubleType$.equals(primitiveType8) : primitiveType8 != null) break block11;
                            this.writer().addDouble(BoxesRunTime.unboxToDouble((Object)value));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        FloatType$ floatType$ = FloatType$.MODULE$;
                        PrimitiveType primitiveType9 = primitiveType;
                        if (floatType$ != null ? !floatType$.equals(primitiveType9) : primitiveType9 != null) break block12;
                        this.writer().addFloat(BoxesRunTime.unboxToFloat((Object)value));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                    PrimitiveType primitiveType10 = primitiveType;
                    if (booleanType$ != null ? !booleanType$.equals(primitiveType10) : primitiveType10 != null) break block13;
                    this.writer().addBoolean(BoxesRunTime.unboxToBoolean((Object)value));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (!(primitiveType instanceof DecimalType)) break block14;
                DecimalType decimalType = (DecimalType)primitiveType;
                Option option = decimalType.precisionInfo();
                None$ none$ = None$.MODULE$;
                if (!(option == null ? none$ != null : !option.equals(none$)) || ((PrecisionInfo)decimalType.precisionInfo().get()).precision() > 18) {
                    throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported datatype ", ", cannot write to consumer"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{decimalType})));
                }
                this.writeDecimal((Decimal)value, ((PrecisionInfo)decimalType.precisionInfo().get()).precision());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not know how to writer ", " to consumer"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema})));
    }

    public void writeStruct(StructType schema, Seq<Object> struct) {
        if (struct != null) {
            StructField[] fields = (StructField[])schema.fields().toArray(ClassTag$.MODULE$.apply(StructField.class));
            this.writer().startGroup();
            for (int i = 0; i < Predef$.MODULE$.refArrayOps((Object[])fields).size(); ++i) {
                if (struct.apply(i) == null) continue;
                this.writer().startField(fields[i].name(), i);
                this.writeValue(fields[i].dataType(), struct.apply(i));
                this.writer().endField(fields[i].name(), i);
            }
            this.writer().endGroup();
        }
    }

    public void writeArray(ArrayType schema, Seq<Object> array) {
        DataType elementType = schema.elementType();
        this.writer().startGroup();
        if (array.size() > 0) {
            if (schema.containsNull()) {
                this.writer().startField(CatalystConverter$.MODULE$.ARRAY_CONTAINS_NULL_BAG_SCHEMA_NAME(), 0);
                for (int i = 0; i < array.size(); ++i) {
                    this.writer().startGroup();
                    if (array.apply(i) != null) {
                        this.writer().startField(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), 0);
                        this.writeValue(elementType, array.apply(i));
                        this.writer().endField(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), 0);
                    }
                    this.writer().endGroup();
                }
                this.writer().endField(CatalystConverter$.MODULE$.ARRAY_CONTAINS_NULL_BAG_SCHEMA_NAME(), 0);
            } else {
                this.writer().startField(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), 0);
                for (int i = 0; i < array.size(); ++i) {
                    this.writeValue(elementType, array.apply(i));
                }
                this.writer().endField(CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME(), 0);
            }
        }
        this.writer().endGroup();
    }

    public void writeMap(MapType schema, Map<?, Object> map) {
        this.writer().startGroup();
        if (map.size() > 0) {
            this.writer().startField(CatalystConverter$.MODULE$.MAP_SCHEMA_NAME(), 0);
            map.withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                    Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, schema){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RowWriteSupport $outer;
                private final MapType schema$1;

                public final void apply(Tuple2<Object, Object> x$1) {
                    Tuple2<Object, Object> tuple2 = x$1;
                    if (tuple2 != null) {
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        this.$outer.writer().startGroup();
                        this.$outer.writer().startField(CatalystConverter$.MODULE$.MAP_KEY_SCHEMA_NAME(), 0);
                        this.$outer.writeValue(this.schema$1.keyType(), key);
                        this.$outer.writer().endField(CatalystConverter$.MODULE$.MAP_KEY_SCHEMA_NAME(), 0);
                        if (value != null) {
                            this.$outer.writer().startField(CatalystConverter$.MODULE$.MAP_VALUE_SCHEMA_NAME(), 1);
                            this.$outer.writeValue(this.schema$1.valueType(), value);
                            this.$outer.writer().endField(CatalystConverter$.MODULE$.MAP_VALUE_SCHEMA_NAME(), 1);
                        }
                        this.$outer.writer().endGroup();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.schema$1 = schema$1;
                }
            });
            this.writer().endField(CatalystConverter$.MODULE$.MAP_SCHEMA_NAME(), 0);
        }
        this.writer().endGroup();
    }

    private byte[] scratchBytes() {
        return this.scratchBytes;
    }

    public void writeDecimal(Decimal decimal, int precision) {
        int numBytes = ParquetTypesConverter$.MODULE$.BYTES_FOR_PRECISION()[precision];
        long unscaledLong = decimal.toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes - 1);
        while (i < numBytes) {
            this.scratchBytes()[i] = (byte)(unscaledLong >> shift);
            ++i;
            shift -= 8;
        }
        this.writer().addBinary(Binary.fromByteArray((byte[])this.scratchBytes(), (int)0, (int)numBytes));
    }

    public RowWriteSupport() {
        Logging.class.$init$((Logging)this);
        this.writer = null;
        this.attributes = null;
        this.scratchBytes = new byte[8];
    }
}

